/* A Bison parser, made by GNU Bison 2.5.  */

/* Bison implementation for Yacc-like parsers in C
   
      Copyright (C) 1984, 1989-1990, 2000-2011 Free Software Foundation, Inc.
   
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.
   
   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Using locations.  */
#define YYLSP_NEEDED 1

/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yylval          base_yylval
#define yychar          base_yychar
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */

/* Line 268 of yacc.c  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
		if (N)						\
			(Current) = (Rhs)[1];	\
		else						\
			(Current) = (Rhs)[0];	\
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char	pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);

			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
				fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in another functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn't cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = EMPTY;
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char var_text[20];
			char *original_var;
			bool skip_set_var = false;
			bool var_ptr = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(var_text, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable)
					 && (strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement")) == 0))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar
					  && ptr->variable->type->type != ECPGt_char
					  && ptr->variable->type->type != ECPGt_unsigned_char
					  && ptr->variable->type->type != ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																			   mm_strdup("1"),
																			   ptr->variable->type->u.element->counter),
														  ptr->variable->type->size),
									  0);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar
					  || ptr->variable->type->type == ECPGt_char
					  || ptr->variable->type->type == ECPGt_unsigned_char
					  || ptr->variable->type->type == ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				if (ptr->variable->type->type == ECPGt_varchar)
					var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_struct
					 || ptr->variable->type->type == ECPGt_union)
			{
				newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
									  ECPGmake_struct_type(ptr->variable->type->u.members,
														   ptr->variable->type->type,
														   ptr->variable->type->type_name,
														   ptr->variable->type->struct_sizeof),
									  0);
				var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct
					|| ptr->variable->type->u.element->type == ECPGt_union)
				{
					newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->variable->type->u.element->u.members,
															   ptr->variable->type->u.element->type,
															   ptr->variable->type->u.element->type_name,
															   ptr->variable->type->u.element->struct_sizeof),
										  0);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																				   ptr->variable->type->u.element->size,
																				   ptr->variable->type->u.element->counter),
															  ptr->variable->type->size),
										  0);
					var_ptr = true;
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				var_ptr = true;
			}

			/* create call to "ECPGset_var(<counter>, <connection>, <pointer>. <line number>)" */
			if (!skip_set_var)
			{
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(var_text, "%d))", ecpg_internal_var);
				var_ptr = false;

				if (ptr->indicator->type->type == ECPGt_struct
					|| ptr->indicator->type->type == ECPGt_union)
				{
					newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->indicator->type->u.members,
															   ptr->indicator->type->type,
															   ptr->indicator->type->type_name,
															   ptr->indicator->type->struct_sizeof),
										  0);
					var_ptr = true;
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct
						|| ptr->indicator->type->u.element->type == ECPGt_union)
					{
						newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
											  ECPGmake_struct_type(ptr->indicator->type->u.element->u.members,
																   ptr->indicator->type->u.element->type,
																   ptr->indicator->type->u.element->type_name,
																   ptr->indicator->type->u.element->struct_sizeof),
											  0);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("),
													  mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)),
													  mm_strdup(" *)(ECPGget_var("), mm_strdup(var_text)),
											  ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type,
																					   ptr->indicator->type->u.element->size,
																					   ptr->indicator->type->u.element->counter),
																  ptr->indicator->type->size),
											  0);
						var_ptr = true;
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
					var_ptr = true;
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && strcmp(cur->function, current_function) == 0))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = ((name[0] == ':' || name[0] == '"') ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char *dimension, char *length, enum ECPGttype type_enum,
			char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
		 type_enum == ECPGt_union) &&
		initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Line 268 of yacc.c  */
#line 635 "preproc.c"

/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     CSTRING = 326,
     CVARIABLE = 327,
     CPP_LINE = 328,
     IP = 329,
     DOLCONST = 330,
     ECONST = 331,
     NCONST = 332,
     UCONST = 333,
     UIDENT = 334,
     IDENT = 335,
     FCONST = 336,
     SCONST = 337,
     BCONST = 338,
     XCONST = 339,
     Op = 340,
     ICONST = 341,
     PARAM = 342,
     TYPECAST = 343,
     DOT_DOT = 344,
     COLON_EQUALS = 345,
     ABORT_P = 346,
     ABSOLUTE_P = 347,
     ACCESS = 348,
     ACTION = 349,
     ADD_P = 350,
     ADMIN = 351,
     AFTER = 352,
     AGGREGATE = 353,
     ALL = 354,
     ALSO = 355,
     ALTER = 356,
     ALWAYS = 357,
     ANALYSE = 358,
     ANALYZE = 359,
     AND = 360,
     ANY = 361,
     ARRAY = 362,
     AS = 363,
     ASC = 364,
     ASSERTION = 365,
     ASSIGNMENT = 366,
     ASYMMETRIC = 367,
     AT = 368,
     ATTRIBUTE = 369,
     AUTHORIZATION = 370,
     BACKWARD = 371,
     BEFORE = 372,
     BEGIN_P = 373,
     BETWEEN = 374,
     BIGINT = 375,
     BINARY = 376,
     BIT = 377,
     BOOLEAN_P = 378,
     BOTH = 379,
     BY = 380,
     CACHE = 381,
     CALLED = 382,
     CASCADE = 383,
     CASCADED = 384,
     CASE = 385,
     CAST = 386,
     CATALOG_P = 387,
     CHAIN = 388,
     CHAR_P = 389,
     CHARACTER = 390,
     CHARACTERISTICS = 391,
     CHECK = 392,
     CHECKPOINT = 393,
     CLASS = 394,
     CLOSE = 395,
     CLUSTER = 396,
     COALESCE = 397,
     COLLATE = 398,
     COLLATION = 399,
     COLUMN = 400,
     COMMENT = 401,
     COMMENTS = 402,
     COMMIT = 403,
     COMMITTED = 404,
     CONCURRENTLY = 405,
     CONFIGURATION = 406,
     CONNECTION = 407,
     CONSTRAINT = 408,
     CONSTRAINTS = 409,
     CONTENT_P = 410,
     CONTINUE_P = 411,
     CONVERSION_P = 412,
     COPY = 413,
     COST = 414,
     CREATE = 415,
     CROSS = 416,
     CSV = 417,
     CURRENT_P = 418,
     CURRENT_CATALOG = 419,
     CURRENT_DATE = 420,
     CURRENT_ROLE = 421,
     CURRENT_SCHEMA = 422,
     CURRENT_TIME = 423,
     CURRENT_TIMESTAMP = 424,
     CURRENT_USER = 425,
     CURSOR = 426,
     CYCLE = 427,
     DATA_P = 428,
     DATABASE = 429,
     DAY_P = 430,
     DEALLOCATE = 431,
     DEC = 432,
     DECIMAL_P = 433,
     DECLARE = 434,
     DEFAULT = 435,
     DEFAULTS = 436,
     DEFERRABLE = 437,
     DEFERRED = 438,
     DEFINER = 439,
     DELETE_P = 440,
     DELIMITER = 441,
     DELIMITERS = 442,
     DESC = 443,
     DICTIONARY = 444,
     DISABLE_P = 445,
     DISCARD = 446,
     DISTINCT = 447,
     DO = 448,
     DOCUMENT_P = 449,
     DOMAIN_P = 450,
     DOUBLE_P = 451,
     DROP = 452,
     EACH = 453,
     ELSE = 454,
     ENABLE_P = 455,
     ENCODING = 456,
     ENCRYPTED = 457,
     END_P = 458,
     ENUM_P = 459,
     ESCAPE = 460,
     EVENT = 461,
     EXCEPT = 462,
     EXCLUDE = 463,
     EXCLUDING = 464,
     EXCLUSIVE = 465,
     EXECUTE = 466,
     EXISTS = 467,
     EXPLAIN = 468,
     EXTENSION = 469,
     EXTERNAL = 470,
     EXTRACT = 471,
     FALSE_P = 472,
     FAMILY = 473,
     FETCH = 474,
     FIRST_P = 475,
     FLOAT_P = 476,
     FOLLOWING = 477,
     FOR = 478,
     FORCE = 479,
     FOREIGN = 480,
     FORWARD = 481,
     FREEZE = 482,
     FROM = 483,
     FULL = 484,
     FUNCTION = 485,
     FUNCTIONS = 486,
     GLOBAL = 487,
     GRANT = 488,
     GRANTED = 489,
     GREATEST = 490,
     GROUP_P = 491,
     HANDLER = 492,
     HAVING = 493,
     HEADER_P = 494,
     HOLD = 495,
     HOUR_P = 496,
     IDENTITY_P = 497,
     IF_P = 498,
     ILIKE = 499,
     IMMEDIATE = 500,
     IMMUTABLE = 501,
     IMPLICIT_P = 502,
     IN_P = 503,
     INCLUDING = 504,
     INCREMENT = 505,
     INDEX = 506,
     INDEXES = 507,
     INHERIT = 508,
     INHERITS = 509,
     INITIALLY = 510,
     INLINE_P = 511,
     INNER_P = 512,
     INOUT = 513,
     INPUT_P = 514,
     INSENSITIVE = 515,
     INSERT = 516,
     INSTEAD = 517,
     INT_P = 518,
     INTEGER = 519,
     INTERSECT = 520,
     INTERVAL = 521,
     INTO = 522,
     INVOKER = 523,
     IS = 524,
     ISNULL = 525,
     ISOLATION = 526,
     JOIN = 527,
     KEY = 528,
     LABEL = 529,
     LANGUAGE = 530,
     LARGE_P = 531,
     LAST_P = 532,
     LATERAL_P = 533,
     LC_COLLATE_P = 534,
     LC_CTYPE_P = 535,
     LEADING = 536,
     LEAKPROOF = 537,
     LEAST = 538,
     LEFT = 539,
     LEVEL = 540,
     LIKE = 541,
     LIMIT = 542,
     LISTEN = 543,
     LOAD = 544,
     LOCAL = 545,
     LOCALTIME = 546,
     LOCALTIMESTAMP = 547,
     LOCATION = 548,
     LOCK_P = 549,
     MAPPING = 550,
     MATCH = 551,
     MATERIALIZED = 552,
     MAXVALUE = 553,
     MINUTE_P = 554,
     MINVALUE = 555,
     MODE = 556,
     MONTH_P = 557,
     MOVE = 558,
     NAME_P = 559,
     NAMES = 560,
     NATIONAL = 561,
     NATURAL = 562,
     NCHAR = 563,
     NEXT = 564,
     NO = 565,
     NONE = 566,
     NOT = 567,
     NOTHING = 568,
     NOTIFY = 569,
     NOTNULL = 570,
     NOWAIT = 571,
     NULL_P = 572,
     NULLIF = 573,
     NULLS_P = 574,
     NUMERIC = 575,
     OBJECT_P = 576,
     OF = 577,
     OFF = 578,
     OFFSET = 579,
     OIDS = 580,
     ON = 581,
     ONLY = 582,
     OPERATOR = 583,
     OPTION = 584,
     OPTIONS = 585,
     OR = 586,
     ORDER = 587,
     OUT_P = 588,
     OUTER_P = 589,
     OVER = 590,
     OVERLAPS = 591,
     OVERLAY = 592,
     OWNED = 593,
     OWNER = 594,
     PARSER = 595,
     PARTIAL = 596,
     PARTITION = 597,
     PASSING = 598,
     PASSWORD = 599,
     PLACING = 600,
     PLANS = 601,
     POSITION = 602,
     PRECEDING = 603,
     PRECISION = 604,
     PRESERVE = 605,
     PREPARE = 606,
     PREPARED = 607,
     PRIMARY = 608,
     PRIOR = 609,
     PRIVILEGES = 610,
     PROCEDURAL = 611,
     PROCEDURE = 612,
     PROGRAM = 613,
     QUOTE = 614,
     RANGE = 615,
     READ = 616,
     REAL = 617,
     REASSIGN = 618,
     RECHECK = 619,
     RECURSIVE = 620,
     REF = 621,
     REFERENCES = 622,
     REFRESH = 623,
     REINDEX = 624,
     RELATIVE_P = 625,
     RELEASE = 626,
     RENAME = 627,
     REPEATABLE = 628,
     REPLACE = 629,
     REPLICA = 630,
     RESET = 631,
     RESTART = 632,
     RESTRICT = 633,
     RETURNING = 634,
     RETURNS = 635,
     REVOKE = 636,
     RIGHT = 637,
     ROLE = 638,
     ROLLBACK = 639,
     ROW = 640,
     ROWS = 641,
     RULE = 642,
     SAVEPOINT = 643,
     SCHEMA = 644,
     SCROLL = 645,
     SEARCH = 646,
     SECOND_P = 647,
     SECURITY = 648,
     SELECT = 649,
     SEQUENCE = 650,
     SEQUENCES = 651,
     SERIALIZABLE = 652,
     SERVER = 653,
     SESSION = 654,
     SESSION_USER = 655,
     SET = 656,
     SETOF = 657,
     SHARE = 658,
     SHOW = 659,
     SIMILAR = 660,
     SIMPLE = 661,
     SMALLINT = 662,
     SNAPSHOT = 663,
     SOME = 664,
     STABLE = 665,
     STANDALONE_P = 666,
     START = 667,
     STATEMENT = 668,
     STATISTICS = 669,
     STDIN = 670,
     STDOUT = 671,
     STORAGE = 672,
     STRICT_P = 673,
     STRIP_P = 674,
     SUBSTRING = 675,
     SYMMETRIC = 676,
     SYSID = 677,
     SYSTEM_P = 678,
     TABLE = 679,
     TABLES = 680,
     TABLESPACE = 681,
     TEMP = 682,
     TEMPLATE = 683,
     TEMPORARY = 684,
     TEXT_P = 685,
     THEN = 686,
     TIME = 687,
     TIMESTAMP = 688,
     TO = 689,
     TRAILING = 690,
     TRANSACTION = 691,
     TREAT = 692,
     TRIGGER = 693,
     TRIM = 694,
     TRUE_P = 695,
     TRUNCATE = 696,
     TRUSTED = 697,
     TYPE_P = 698,
     TYPES_P = 699,
     UNBOUNDED = 700,
     UNCOMMITTED = 701,
     UNENCRYPTED = 702,
     UNION = 703,
     UNIQUE = 704,
     UNKNOWN = 705,
     UNLISTEN = 706,
     UNLOGGED = 707,
     UNTIL = 708,
     UPDATE = 709,
     USER = 710,
     USING = 711,
     VACUUM = 712,
     VALID = 713,
     VALIDATE = 714,
     VALIDATOR = 715,
     VALUE_P = 716,
     VALUES = 717,
     VARCHAR = 718,
     VARIADIC = 719,
     VARYING = 720,
     VERBOSE = 721,
     VERSION_P = 722,
     VIEW = 723,
     VOLATILE = 724,
     WHEN = 725,
     WHERE = 726,
     WHITESPACE_P = 727,
     WINDOW = 728,
     WITH = 729,
     WITHOUT = 730,
     WORK = 731,
     WRAPPER = 732,
     WRITE = 733,
     XML_P = 734,
     XMLATTRIBUTES = 735,
     XMLCONCAT = 736,
     XMLELEMENT = 737,
     XMLEXISTS = 738,
     XMLFOREST = 739,
     XMLPARSE = 740,
     XMLPI = 741,
     XMLROOT = 742,
     XMLSERIALIZE = 743,
     YEAR_P = 744,
     YES_P = 745,
     ZONE = 746,
     NULLS_FIRST = 747,
     NULLS_LAST = 748,
     WITH_TIME = 749,
     POSTFIXOP = 750,
     UMINUS = 751
   };
#endif



#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE
{

/* Line 293 of yacc.c  */
#line 564 "preproc.y"

	double	dval;
	char	*str;
	int		ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;



/* Line 293 of yacc.c  */
#line 1184 "preproc.c"
} YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 343 of yacc.c  */
#line 1209 "preproc.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int yyi)
#else
static int
YYID (yyi)
    int yyi;
#endif
{
  return yyi;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)				\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack_alloc, Stack, yysize);			\
	Stack = &yyptr->Stack_alloc;					\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   107764

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  516
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  699
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2791
/* YYNRULES -- Number of states.  */
#define YYNSTATES  5104

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   751

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   503,     2,     2,
     508,   509,   501,   499,   511,   500,   510,   502,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   513,   512,
     496,   495,   497,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   506,     2,   507,   504,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   514,     2,   515,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     498,   505
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint16 yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   245,   247,   249,   251,   253,   255,   257,
     259,   261,   263,   265,   267,   269,   271,   272,   278,   280,
     281,   284,   285,   288,   289,   292,   295,   299,   303,   305,
     309,   313,   316,   318,   320,   323,   326,   329,   333,   337,
     343,   349,   350,   354,   360,   366,   372,   377,   381,   387,
     391,   397,   403,   410,   412,   414,   418,   424,   431,   436,
     446,   454,   456,   457,   460,   461,   463,   465,   467,   469,
     471,   473,   476,   480,   484,   487,   493,   495,   499,   503,
     507,   511,   515,   519,   522,   525,   528,   531,   535,   539,
     543,   547,   549,   553,   555,   559,   561,   563,   566,   569,
     572,   574,   576,   578,   580,   582,   584,   586,   590,   597,
     599,   601,   603,   605,   607,   608,   610,   612,   615,   619,
     624,   628,   631,   634,   636,   639,   641,   645,   650,   656,
     661,   664,   669,   671,   673,   675,   677,   679,   682,   685,
     688,   691,   696,   703,   708,   715,   720,   727,   732,   739,
     745,   753,   755,   759,   762,   766,   771,   778,   785,   792,
     798,   804,   811,   818,   823,   832,   837,   840,   844,   851,
     856,   860,   864,   868,   872,   876,   881,   886,   890,   894,
     898,   902,   906,   910,   915,   920,   924,   927,   931,   934,
     937,   941,   945,   948,   951,   953,   957,   960,   962,   964,
     965,   968,   969,   972,   973,   977,   980,   981,   983,   987,
     991,   993,   999,  1003,  1008,  1010,  1014,  1019,  1026,  1031,
    1040,  1043,  1046,  1058,  1066,  1068,  1070,  1072,  1073,  1075,
    1077,  1079,  1081,  1085,  1088,  1089,  1091,  1093,  1095,  1099,
    1103,  1105,  1107,  1111,  1115,  1119,  1123,  1128,  1131,  1133,
    1134,  1137,  1138,  1142,  1143,  1145,  1146,  1148,  1152,  1155,
    1157,  1159,  1161,  1165,  1166,  1168,  1172,  1174,  1186,  1201,
    1212,  1226,  1228,  1230,  1233,  1236,  1239,  1242,  1244,  1245,
    1247,  1248,  1252,  1253,  1255,  1259,  1261,  1265,  1267,  1269,
    1271,  1273,  1275,  1280,  1285,  1288,  1289,  1293,  1295,  1297,
    1300,  1303,  1305,  1309,  1314,  1320,  1323,  1329,  1331,  1334,
    1337,  1340,  1344,  1348,  1352,  1353,  1355,  1357,  1359,  1361,
    1363,  1365,  1369,  1371,  1377,  1385,  1389,  1398,  1403,  1413,
    1425,  1428,  1429,  1433,  1434,  1436,  1440,  1442,  1445,  1448,
    1451,  1452,  1454,  1458,  1462,  1469,  1474,  1475,  1477,  1479,
    1482,  1485,  1486,  1490,  1494,  1497,  1499,  1501,  1504,  1507,
    1512,  1513,  1516,  1519,  1522,  1523,  1527,  1532,  1537,  1538,
    1541,  1542,  1547,  1548,  1552,  1558,  1561,  1565,  1566,  1575,
    1580,  1582,  1583,  1589,  1595,  1600,  1607,  1609,  1610,  1612,
    1615,  1618,  1620,  1623,  1627,  1630,  1633,  1636,  1639,  1643,
    1647,  1649,  1653,  1655,  1656,  1658,  1661,  1663,  1665,  1669,
    1676,  1687,  1689,  1690,  1692,  1695,  1698,  1699,  1702,  1705,
    1707,  1708,  1714,  1722,  1724,  1725,  1732,  1735,  1736,  1740,
    1746,  1752,  1761,  1764,  1765,  1768,  1771,  1774,  1780,  1783,
    1784,  1787,  1795,  1806,  1813,  1820,  1827,  1834,  1842,  1850,
    1860,  1870,  1877,  1885,  1892,  1901,  1910,  1919,  1928,  1935,
    1942,  1950,  1958,  1967,  1974,  1981,  1989,  1992,  1995,  1998,
    2001,  2003,  2006,  2008,  2009,  2016,  2025,  2033,  2040,  2045,
    2046,  2048,  2052,  2057,  2059,  2063,  2065,  2068,  2071,  2074,
    2077,  2079,  2081,  2092,  2095,  2096,  2099,  2102,  2104,  2105,
    2110,  2117,  2123,  2128,  2133,  2144,  2158,  2164,  2172,  2181,
    2183,  2185,  2187,  2195,  2205,  2214,  2230,  2251,  2253,  2255,
    2258,  2260,  2264,  2266,  2268,  2270,  2274,  2276,  2280,  2281,
    2283,  2284,  2286,  2288,  2293,  2294,  2296,  2300,  2301,  2303,
    2305,  2307,  2309,  2312,  2313,  2314,  2317,  2320,  2322,  2325,
    2328,  2331,  2334,  2341,  2350,  2362,  2376,  2378,  2382,  2388,
    2390,  2394,  2400,  2402,  2405,  2408,  2410,  2419,  2424,  2430,
    2435,  2440,  2445,  2449,  2457,  2466,  2473,  2480,  2487,  2494,
    2501,  2506,  2512,  2516,  2518,  2522,  2526,  2528,  2530,  2532,
    2534,  2536,  2538,  2542,  2546,  2550,  2552,  2556,  2560,  2562,
    2563,  2565,  2569,  2577,  2587,  2597,  2601,  2602,  2616,  2618,
    2622,  2628,  2635,  2640,  2648,  2651,  2653,  2654,  2657,  2658,
    2661,  2666,  2667,  2669,  2670,  2677,  2686,  2695,  2697,  2701,
    2707,  2713,  2721,  2731,  2739,  2749,  2755,  2762,  2769,  2774,
    2780,  2788,  2790,  2792,  2794,  2797,  2799,  2802,  2805,  2807,
    2809,  2811,  2813,  2815,  2817,  2821,  2825,  2829,  2833,  2835,
    2839,  2841,  2844,  2847,  2851,  2857,  2860,  2863,  2864,  2871,
    2879,  2887,  2895,  2904,  2913,  2920,  2929,  2939,  2949,  2957,
    2968,  2976,  2978,  2980,  2982,  2984,  2986,  2988,  2990,  2992,
    2994,  2997,  2999,  3001,  3003,  3005,  3007,  3010,  3012,  3016,
    3019,  3023,  3027,  3031,  3035,  3037,  3039,  3048,  3058,  3068,
    3078,  3088,  3091,  3092,  3094,  3096,  3099,  3102,  3104,  3106,
    3108,  3110,  3112,  3114,  3116,  3118,  3121,  3123,  3125,  3128,
    3131,  3135,  3140,  3146,  3151,  3157,  3161,  3166,  3170,  3175,
    3177,  3180,  3184,  3188,  3192,  3196,  3201,  3206,  3210,  3214,
    3219,  3224,  3229,  3234,  3236,  3238,  3240,  3241,  3249,  3257,
    3268,  3270,  3272,  3275,  3280,  3286,  3288,  3292,  3295,  3298,
    3301,  3304,  3306,  3309,  3312,  3317,  3321,  3324,  3327,  3330,
    3333,  3337,  3340,  3343,  3346,  3352,  3358,  3364,  3366,  3370,
    3372,  3375,  3379,  3380,  3382,  3386,  3389,  3396,  3403,  3413,
    3417,  3418,  3422,  3423,  3429,  3432,  3433,  3437,  3441,  3445,
    3453,  3461,  3472,  3474,  3476,  3478,  3480,  3495,  3497,  3498,
    3500,  3501,  3503,  3504,  3507,  3508,  3510,  3514,  3520,  3526,
    3534,  3537,  3538,  3540,  3543,  3544,  3546,  3548,  3549,  3551,
    3553,  3554,  3564,  3577,  3585,  3588,  3589,  3593,  3596,  3598,
    3602,  3606,  3609,  3611,  3615,  3619,  3623,  3626,  3629,  3631,
    3633,  3635,  3637,  3640,  3642,  3644,  3646,  3648,  3653,  3659,
    3661,  3665,  3669,  3671,  3674,  3679,  3685,  3687,  3689,  3691,
    3693,  3697,  3701,  3704,  3707,  3709,  3712,  3715,  3718,  3720,
    3723,  3726,  3728,  3730,  3732,  3736,  3739,  3740,  3743,  3745,
    3749,  3755,  3757,  3760,  3762,  3763,  3769,  3777,  3783,  3791,
    3797,  3805,  3809,  3815,  3821,  3827,  3829,  3833,  3836,  3838,
    3841,  3843,  3846,  3858,  3869,  3880,  3883,  3886,  3887,  3897,
    3900,  3901,  3906,  3911,  3916,  3918,  3920,  3922,  3923,  3931,
    3938,  3945,  3952,  3959,  3968,  3977,  3984,  3991,  3999,  4009,
    4019,  4026,  4033,  4040,  4049,  4056,  4065,  4072,  4081,  4089,
    4099,  4106,  4115,  4123,  4133,  4142,  4153,  4163,  4175,  4184,
    4194,  4206,  4215,  4224,  4232,  4239,  4246,  4253,  4259,  4265,
    4274,  4283,  4292,  4301,  4308,  4318,  4320,  4321,  4324,  4325,
    4333,  4340,  4347,  4354,  4361,  4368,  4376,  4386,  4396,  4403,
    4412,  4421,  4430,  4439,  4448,  4455,  4464,  4471,  4480,  4488,
    4498,  4506,  4516,  4523,  4531,  4538,  4545,  4552,  4559,  4566,
    4574,  4582,  4590,  4600,  4610,  4617,  4624,  4631,  4640,  4649,
    4658,  4665,  4673,  4687,  4689,  4691,  4695,  4699,  4701,  4703,
    4705,  4707,  4709,  4711,  4713,  4714,  4716,  4718,  4720,  4722,
    4724,  4726,  4727,  4734,  4743,  4747,  4750,  4751,  4754,  4757,
    4760,  4763,  4767,  4771,  4774,  4777,  4780,  4783,  4787,  4790,
    4796,  4801,  4805,  4809,  4813,  4815,  4817,  4818,  4822,  4825,
    4828,  4830,  4833,  4835,  4839,  4842,  4844,  4845,  4855,  4867,
    4879,  4893,  4897,  4902,  4907,  4908,  4911,  4917,  4920,  4921,
    4925,  4929,  4933,  4937,  4941,  4945,  4949,  4953,  4957,  4961,
    4965,  4969,  4973,  4978,  4982,  4986,  4988,  4989,  4995,  5002,
    5007,  5010,  5011,  5016,  5020,  5026,  5033,  5038,  5045,  5052,
    5058,  5066,  5076,  5083,  5085,  5086,  5093,  5105,  5117,  5129,
    5143,  5153,  5165,  5176,  5181,  5184,  5190,  5193,  5194,  5199,
    5205,  5211,  5216,  5223,  5225,  5229,  5231,  5233,  5235,  5237,
    5240,  5245,  5247,  5249,  5251,  5252,  5254,  5255,  5257,  5258,
    5262,  5263,  5266,  5271,  5275,  5281,  5283,  5285,  5287,  5289,
    5291,  5293,  5295,  5297,  5299,  5301,  5305,  5308,  5310,  5312,
    5314,  5316,  5317,  5323,  5328,  5332,  5333,  5335,  5337,  5339,
    5341,  5346,  5356,  5360,  5361,  5368,  5370,  5375,  5378,  5380,
    5384,  5387,  5391,  5392,  5400,  5403,  5404,  5410,  5414,  5415,
    5418,  5421,  5424,  5428,  5430,  5434,  5436,  5439,  5441,  5442,
    5451,  5453,  5457,  5459,  5461,  5465,  5471,  5474,  5476,  5480,
    5488,  5490,  5492,  5493,  5497,  5500,  5503,  5506,  5507,  5510,
    5513,  5515,  5517,  5521,  5525,  5527,  5530,  5535,  5540,  5543,
    5547,  5553,  5559,  5561,  5563,  5573,  5575,  5578,  5583,  5588,
    5593,  5596,  5600,  5602,  5606,  5613,  5615,  5616,  5619,  5621,
    5622,  5626,  5630,  5635,  5640,  5645,  5650,  5654,  5657,  5659,
    5661,  5662,  5664,  5666,  5667,  5669,  5675,  5677,  5678,  5680,
    5681,  5685,  5687,  5691,  5696,  5700,  5703,  5706,  5708,  5710,
    5712,  5713,  5716,  5721,  5727,  5730,  5734,  5736,  5738,  5740,
    5742,  5746,  5747,  5749,  5751,  5753,  5755,  5757,  5761,  5762,
    5765,  5766,  5768,  5772,  5774,  5775,  5777,  5780,  5784,  5787,
    5792,  5795,  5799,  5802,  5803,  5806,  5810,  5813,  5814,  5816,
    5820,  5823,  5826,  5830,  5833,  5837,  5839,  5844,  5848,  5853,
    5859,  5864,  5870,  5875,  5881,  5884,  5889,  5891,  5893,  5894,
    5896,  5901,  5907,  5912,  5913,  5916,  5919,  5922,  5924,  5926,
    5927,  5932,  5935,  5937,  5940,  5943,  5948,  5950,  5954,  5956,
    5959,  5963,  5965,  5968,  5969,  5972,  5977,  5978,  5980,  5981,
    5983,  5987,  5991,  5994,  5998,  6004,  6011,  6014,  6018,  6022,
    6027,  6028,  6030,  6032,  6034,  6036,  6038,  6041,  6047,  6049,
    6051,  6053,  6055,  6058,  6062,  6066,  6067,  6069,  6071,  6073,
    6075,  6077,  6080,  6083,  6086,  6089,  6092,  6094,  6098,  6099,
    6101,  6103,  6105,  6107,  6113,  6116,  6118,  6120,  6122,  6124,
    6130,  6133,  6136,  6139,  6141,  6145,  6149,  6152,  6154,  6155,
    6159,  6160,  6166,  6169,  6175,  6178,  6180,  6183,  6187,  6188,
    6190,  6192,  6194,  6196,  6198,  6200,  6204,  6208,  6212,  6216,
    6220,  6224,  6228,  6229,  6231,  6236,  6238,  6242,  6246,  6252,
    6255,  6258,  6262,  6266,  6270,  6274,  6278,  6282,  6286,  6290,
    6294,  6298,  6301,  6304,  6308,  6312,  6315,  6319,  6325,  6330,
    6337,  6341,  6347,  6352,  6359,  6364,  6371,  6377,  6385,  6389,
    6392,  6397,  6400,  6404,  6408,  6413,  6417,  6422,  6426,  6431,
    6437,  6444,  6451,  6459,  6466,  6474,  6481,  6489,  6493,  6498,
    6503,  6510,  6513,  6517,  6522,  6524,  6528,  6531,  6534,  6538,
    6542,  6546,  6550,  6554,  6558,  6562,  6566,  6570,  6574,  6577,
    6580,  6586,  6593,  6600,  6608,  6612,  6617,  6619,  6621,  6624,
    6629,  6631,  6633,  6635,  6638,  6641,  6644,  6647,  6649,  6654,
    6660,  6667,  6676,  6683,  6691,  6699,  6705,  6711,  6713,  6715,
    6720,  6722,  6727,  6729,  6734,  6736,  6741,  6743,  6745,  6747,
    6749,  6751,  6753,  6760,  6765,  6770,  6775,  6780,  6787,  6793,
    6799,  6805,  6810,  6817,  6822,  6827,  6832,  6837,  6843,  6851,
    6859,  6869,  6875,  6880,  6887,  6893,  6901,  6909,  6917,  6920,
    6924,  6928,  6932,  6937,  6938,  6943,  6945,  6949,  6953,  6955,
    6957,  6959,  6962,  6965,  6966,  6969,  6974,  6979,  6986,  6989,
    6990,  6992,  6996,  7000,  7003,  7006,  7007,  7014,  7016,  7017,
    7021,  7022,  7025,  7028,  7029,  7031,  7036,  7039,  7042,  7045,
    7048,  7051,  7056,  7060,  7066,  7068,  7070,  7072,  7074,  7076,
    7078,  7080,  7082,  7084,  7086,  7088,  7090,  7092,  7094,  7096,
    7101,  7103,  7108,  7110,  7115,  7117,  7120,  7122,  7125,  7127,
    7131,  7133,  7137,  7139,  7143,  7145,  7149,  7153,  7157,  7160,
    7162,  7166,  7170,  7171,  7173,  7175,  7177,  7179,  7181,  7183,
    7185,  7187,  7192,  7196,  7199,  7203,  7204,  7208,  7212,  7215,
    7218,  7220,  7221,  7224,  7227,  7231,  7234,  7236,  7238,  7242,
    7248,  7250,  7253,  7258,  7261,  7262,  7264,  7265,  7267,  7270,
    7273,  7276,  7280,  7286,  7288,  7291,  7292,  7295,  7297,  7298,
    7300,  7302,  7304,  7308,  7312,  7314,  7318,  7322,  7325,  7327,
    7329,  7331,  7335,  7337,  7340,  7342,  7346,  7348,  7350,  7352,
    7354,  7356,  7358,  7360,  7363,  7365,  7367,  7369,  7371,  7373,
    7376,  7382,  7385,  7389,  7396,  7398,  7400,  7402,  7404,  7406,
    7408,  7410,  7412,  7414,  7417,  7420,  7422,  7424,  7426,  7428,
    7430,  7432,  7434,  7436,  7438,  7440,  7442,  7444,  7446,  7448,
    7450,  7452,  7454,  7456,  7458,  7460,  7462,  7464,  7466,  7468,
    7470,  7472,  7474,  7476,  7478,  7480,  7482,  7484,  7486,  7488,
    7490,  7492,  7494,  7496,  7498,  7500,  7502,  7504,  7506,  7508,
    7510,  7512,  7514,  7516,  7518,  7520,  7522,  7524,  7526,  7528,
    7530,  7532,  7534,  7536,  7538,  7540,  7542,  7544,  7546,  7548,
    7550,  7552,  7554,  7556,  7558,  7560,  7562,  7564,  7566,  7568,
    7570,  7572,  7574,  7576,  7578,  7580,  7582,  7584,  7586,  7588,
    7590,  7592,  7594,  7596,  7598,  7600,  7602,  7604,  7606,  7608,
    7610,  7612,  7614,  7616,  7618,  7620,  7622,  7624,  7626,  7628,
    7630,  7632,  7634,  7636,  7638,  7640,  7642,  7644,  7646,  7648,
    7650,  7652,  7654,  7656,  7658,  7660,  7662,  7664,  7666,  7668,
    7670,  7672,  7674,  7676,  7678,  7680,  7682,  7684,  7686,  7688,
    7690,  7692,  7694,  7696,  7698,  7700,  7702,  7704,  7706,  7708,
    7710,  7712,  7714,  7716,  7718,  7720,  7722,  7724,  7726,  7728,
    7730,  7732,  7734,  7736,  7738,  7740,  7742,  7744,  7746,  7748,
    7750,  7752,  7754,  7756,  7758,  7760,  7762,  7764,  7766,  7768,
    7770,  7772,  7774,  7776,  7778,  7780,  7782,  7784,  7786,  7788,
    7790,  7792,  7794,  7796,  7798,  7800,  7802,  7804,  7806,  7808,
    7810,  7812,  7814,  7816,  7818,  7820,  7822,  7824,  7826,  7828,
    7830,  7832,  7834,  7836,  7838,  7840,  7842,  7844,  7846,  7848,
    7850,  7852,  7854,  7856,  7858,  7860,  7862,  7864,  7866,  7868,
    7870,  7872,  7874,  7876,  7878,  7880,  7882,  7884,  7886,  7888,
    7890,  7892,  7894,  7896,  7898,  7900,  7902,  7904,  7906,  7908,
    7910,  7912,  7914,  7916,  7918,  7920,  7922,  7924,  7926,  7928,
    7930,  7932,  7934,  7936,  7938,  7940,  7942,  7944,  7946,  7948,
    7950,  7952,  7954,  7956,  7958,  7960,  7962,  7964,  7966,  7968,
    7970,  7972,  7974,  7976,  7978,  7980,  7982,  7984,  7986,  7988,
    7990,  7992,  7994,  7996,  7998,  8000,  8002,  8004,  8006,  8008,
    8010,  8012,  8014,  8016,  8018,  8020,  8022,  8024,  8026,  8028,
    8030,  8032,  8034,  8036,  8038,  8040,  8042,  8044,  8046,  8048,
    8050,  8052,  8054,  8056,  8058,  8060,  8062,  8064,  8066,  8068,
    8070,  8072,  8074,  8076,  8078,  8080,  8082,  8084,  8086,  8088,
    8090,  8092,  8094,  8096,  8098,  8100,  8102,  8104,  8106,  8108,
    8110,  8112,  8114,  8116,  8118,  8120,  8122,  8124,  8126,  8128,
    8130,  8132,  8134,  8136,  8138,  8140,  8142,  8144,  8146,  8148,
    8150,  8152,  8154,  8156,  8158,  8160,  8162,  8164,  8166,  8168,
    8170,  8172,  8174,  8176,  8178,  8180,  8182,  8184,  8186,  8188,
    8190,  8192,  8194,  8196,  8198,  8200,  8202,  8203,  8206,  8211,
    8215,  8218,  8220,  8222,  8224,  8226,  8228,  8229,  8238,  8241,
    8247,  8251,  8254,  8257,  8261,  8269,  8271,  8273,  8275,  8276,
    8279,  8282,  8284,  8285,  8287,  8291,  8293,  8296,  8297,  8300,
    8301,  8304,  8305,  8307,  8311,  8316,  8320,  8322,  8324,  8326,
    8328,  8331,  8332,  8335,  8340,  8341,  8344,  8347,  8350,  8352,
    8354,  8362,  8366,  8368,  8370,  8372,  8374,  8377,  8378,  8380,
    8384,  8388,  8392,  8396,  8397,  8402,  8408,  8414,  8415,  8417,
    8419,  8421,  8424,  8427,  8429,  8432,  8433,  8441,  8442,  8448,
    8449,  8454,  8457,  8460,  8461,  8464,  8466,  8468,  8470,  8472,
    8474,  8476,  8478,  8480,  8482,  8484,  8486,  8492,  8495,  8497,
    8501,  8504,  8507,  8511,  8512,  8518,  8520,  8521,  8527,  8530,
    8533,  8535,  8537,  8539,  8542,  8545,  8549,  8551,  8554,  8557,
    8561,  8565,  8570,  8573,  8575,  8578,  8580,  8582,  8585,  8588,
    8592,  8594,  8596,  8598,  8600,  8601,  8603,  8607,  8613,  8614,
    8617,  8618,  8620,  8623,  8627,  8630,  8632,  8634,  8636,  8637,
    8639,  8641,  8643,  8645,  8647,  8650,  8653,  8657,  8658,  8660,
    8663,  8665,  8670,  8674,  8679,  8683,  8686,  8688,  8692,  8694,
    8696,  8698,  8700,  8703,  8706,  8708,  8711,  8714,  8716,  8718,
    8720,  8725,  8730,  8735,  8740,  8745,  8747,  8748,  8752,  8756,
    8761,  8763,  8767,  8771,  8776,  8778,  8782,  8786,  8788,  8790,
    8792,  8799,  8801,  8805,  8809,  8816,  8818,  8822,  8826,  8828,
    8830,  8833,  8836,  8838,  8840,  8842,  8844,  8846,  8848,  8850,
    8852,  8854,  8856,  8858,  8860,  8862,  8864,  8866,  8868,  8873,
    8878,  8880,  8882,  8887,  8892,  8896,  8897,  8905,  8907,  8908,
    8909,  8917,  8921,  8926,  8930,  8932,  8934,  8936,  8939,  8943,
    8949,  8952,  8958,  8961,  8963,  8965,  8967,  8969,  8971,  8973,
    8975,  8977,  8979,  8981,  8983,  8985,  8987,  8989,  8991,  8993,
    8995,  8997,  8999,  9001,  9003,  9005,  9007,  9009,  9011,  9013,
    9015,  9017,  9019,  9021,  9023,  9025,  9027,  9029,  9031,  9033,
    9035,  9037,  9039,  9041,  9043,  9045,  9047,  9049,  9051,  9053,
    9055,  9057,  9059,  9061,  9063,  9065,  9067,  9069,  9071,  9073,
    9075,  9077,  9079,  9081,  9083,  9085,  9087,  9089,  9091,  9093,
    9095,  9097,  9099,  9101,  9103,  9105,  9107,  9109,  9111,  9113,
    9115,  9117,  9119,  9121,  9123,  9125,  9127,  9129,  9131,  9133,
    9135,  9137,  9139,  9141,  9143,  9145,  9147,  9149,  9151,  9153,
    9155,  9157,  9161,  9163,  9164,  9166,  9169,  9171,  9174,  9176,
    9178,  9180,  9183,  9186,  9188,  9190,  9192,  9194,  9196,  9198,
    9200,  9202,  9204,  9206,  9208,  9210,  9212,  9214,  9216,  9218,
    9221,  9225,  9227,  9230,  9232,  9236,  9238,  9242,  9244,  9246,
    9248,  9250,  9252,  9254,  9256,  9258,  9260,  9262,  9264,  9266,
    9268,  9270,  9272,  9274,  9276,  9278,  9280,  9282,  9284,  9286,
    9288,  9290,  9292,  9294,  9296,  9298,  9300,  9302,  9304,  9306,
    9308,  9310,  9312,  9314,  9316,  9318,  9320,  9322,  9324,  9326,
    9328,  9330,  9332,  9334,  9336,  9338,  9340,  9342,  9344,  9346,
    9348,  9350,  9352,  9354,  9356,  9358,  9360,  9362,  9364,  9367,
    9371,  9374,  9378,  9380,  9384,  9388,  9392,  9396,  9400,  9404,
    9406,  9408,  9409,  9412,  9415,  9417,  9419,  9422,  9424,  9426,
    9428,  9429
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int16 yyrhs[] =
{
     517,     0,    -1,  1066,    -1,   705,    -1,   852,    -1,   853,
      -1,   770,    -1,   858,    -1,   720,    -1,   657,    -1,   660,
      -1,   666,    -1,   680,    -1,   682,    -1,   805,    -1,   534,
      -1,   826,    -1,   827,    -1,   636,    -1,   561,    -1,   572,
      -1,   528,    -1,   526,    -1,   861,    -1,   860,    -1,   686,
      -1,   530,    -1,   529,    -1,   868,    -1,   559,    -1,   575,
      -1,   863,    -1,   744,    -1,   556,    -1,   576,    -1,  1068,
      -1,   707,    -1,   816,    -1,   862,    -1,   857,    -1,   654,
      -1,   661,    -1,   675,    -1,   681,    -1,   786,    -1,   533,
      -1,   631,    -1,   722,    -1,   729,    -1,   730,    -1,   643,
      -1,   537,    -1,   635,    -1,   592,    -1,   651,    -1,   687,
      -1,   701,    -1,   519,    -1,   525,    -1,   683,    -1,   848,
      -1,  1209,    -1,   903,    -1,   709,    -1,   890,    -1,   560,
      -1,   813,    -1,   708,    -1,   818,    -1,   665,    -1,   679,
      -1,   536,    -1,   733,    -1,   734,    -1,   735,    -1,   649,
      -1,   835,    -1,   737,    -1,   653,    -1,   700,    -1,   531,
      -1,   532,    -1,   685,    -1,   856,    -1,   883,    -1,   874,
      -1,   751,    -1,   755,    -1,   766,    -1,   775,    -1,   885,
      -1,   838,    -1,   634,    -1,   847,    -1,   892,    -1,   836,
      -1,   880,    -1,   736,    -1,   820,    -1,   809,    -1,   808,
      -1,   810,    -1,   823,    -1,   756,    -1,   767,    -1,   828,
      -1,   747,    -1,   907,    -1,   840,    -1,   742,    -1,   839,
      -1,   896,    -1,   865,    -1,   552,    -1,   541,    -1,   555,
      -1,   845,    -1,  1145,    -1,  1071,    -1,  1088,    -1,  1146,
      -1,  1128,    -1,  1143,    -1,  1129,    -1,  1089,    -1,  1133,
      -1,  1155,    -1,  1147,    -1,  1134,    -1,  1163,    -1,  1165,
      -1,  1158,    -1,  1150,    -1,  1166,    -1,  1169,    -1,  1171,
      -1,    -1,   160,   383,  1059,   520,   521,    -1,   474,    -1,
      -1,   521,   524,    -1,    -1,   522,   523,    -1,    -1,   344,
    1199,    -1,   344,   317,    -1,   202,   344,  1199,    -1,   447,
     344,  1199,    -1,   253,    -1,   152,   287,  1060,    -1,   458,
     453,  1199,    -1,   455,  1049,    -1,  1201,    -1,   523,    -1,
     422,  1058,    -1,    96,  1049,    -1,   383,  1049,    -1,   248,
     383,  1049,    -1,   248,   236,  1049,    -1,   160,   455,  1059,
     520,   521,    -1,   101,   383,  1059,   520,   522,    -1,    -1,
     248,   174,  1051,    -1,   101,   383,  1059,   527,   553,    -1,
     101,   383,    99,   527,   553,    -1,   101,   455,  1059,   520,
     522,    -1,   101,   455,  1059,   553,    -1,   197,   383,  1049,
      -1,   197,   383,   243,   212,  1049,    -1,   197,   455,  1049,
      -1,   197,   455,   243,   212,  1049,    -1,   160,   236,  1059,
     520,   521,    -1,   101,   236,  1059,   535,   455,  1049,    -1,
      95,    -1,   197,    -1,   197,   236,  1049,    -1,   197,   236,
     243,   212,  1049,    -1,   160,   389,   538,   115,  1059,   539,
      -1,   160,   389,  1179,   539,    -1,   160,   389,   243,   312,
     212,   538,   115,  1059,   539,    -1,   160,   389,   243,   312,
     212,  1179,   539,    -1,  1179,    -1,    -1,   539,   540,    -1,
      -1,   592,    -1,   775,    -1,   635,    -1,   687,    -1,   755,
      -1,   845,    -1,   401,   542,    -1,   401,   290,   542,    -1,
     401,   399,   542,    -1,   436,   843,    -1,   399,   136,   108,
     436,   843,    -1,   543,    -1,   544,   434,   545,    -1,   544,
     495,   545,    -1,   544,   434,   180,    -1,   544,   495,   180,
      -1,   544,   228,   163,    -1,   432,   491,   549,    -1,   132,
    1199,    -1,   389,  1199,    -1,   305,   550,    -1,   383,   551,
      -1,   399,   115,   551,    -1,   399,   115,   180,    -1,   479,
     329,   996,    -1,   436,   408,  1199,    -1,  1178,    -1,   544,
     510,  1179,    -1,   546,    -1,   545,   511,   546,    -1,   548,
      -1,   641,    -1,   361,   446,    -1,   361,   149,    -1,   373,
     361,    -1,   397,    -1,   440,    -1,   217,    -1,   326,    -1,
     551,    -1,  1199,    -1,  1201,    -1,   983,  1199,   985,    -1,
     983,   508,  1058,   509,  1199,   985,    -1,   641,    -1,   180,
      -1,   290,    -1,  1199,    -1,   180,    -1,    -1,  1061,    -1,
    1199,    -1,   376,   544,    -1,   376,   432,   491,    -1,   376,
     436,   271,   285,    -1,   376,   399,   115,    -1,   376,    99,
      -1,   401,   542,    -1,   552,    -1,   401,   543,    -1,   552,
      -1,   404,   544,  1212,    -1,   404,   432,   491,  1212,    -1,
     404,   436,   271,   285,  1212,    -1,   404,   399,   115,  1212,
      -1,   404,    99,    -1,   401,   154,   557,   558,    -1,    99,
      -1,  1047,    -1,   183,    -1,   245,    -1,   138,    -1,   191,
      99,    -1,   191,   427,    -1,   191,   429,    -1,   191,   346,
      -1,   101,   424,   954,   562,    -1,   101,   424,   243,   212,
     954,   562,    -1,   101,   251,  1048,   562,    -1,   101,   251,
     243,   212,  1048,   562,    -1,   101,   395,  1048,   562,    -1,
     101,   395,   243,   212,  1048,   562,    -1,   101,   468,  1048,
     562,    -1,   101,   468,   243,   212,  1048,   562,    -1,   101,
     297,   468,  1048,   562,    -1,   101,   297,   468,   243,   212,
    1048,   562,    -1,   563,    -1,   562,   511,   563,    -1,    95,
     600,    -1,    95,   145,   600,    -1,   101,   824,  1179,   564,
      -1,   101,   824,  1179,   197,   312,   317,    -1,   101,   824,
    1179,   401,   312,   317,    -1,   101,   824,  1179,   401,   414,
    1060,    -1,   101,   824,  1179,   401,   568,    -1,   101,   824,
    1179,   376,   568,    -1,   101,   824,  1179,   401,   417,  1179,
      -1,   197,   824,   243,   212,  1179,   565,    -1,   197,   824,
    1179,   565,    -1,   101,   824,  1179,   825,   443,   963,   566,
     567,    -1,   101,   824,  1179,   669,    -1,    95,   609,    -1,
     459,   153,  1050,    -1,   197,   153,   243,   212,  1050,   565,
      -1,   197,   153,  1050,   565,    -1,   401,   474,   325,    -1,
     401,   475,   325,    -1,   141,   326,  1050,    -1,   401,   475,
     141,    -1,   200,   438,  1050,    -1,   200,   102,   438,  1050,
      -1,   200,   375,   438,  1050,    -1,   200,   438,    99,    -1,
     200,   438,   455,    -1,   190,   438,  1050,    -1,   190,   438,
      99,    -1,   190,   438,   455,    -1,   200,   387,  1050,    -1,
     200,   102,   387,  1050,    -1,   200,   375,   387,  1050,    -1,
     190,   387,  1050,    -1,   253,  1048,    -1,   310,   253,  1048,
      -1,   322,   740,    -1,   312,   322,    -1,   339,   434,  1059,
      -1,   401,   426,  1050,    -1,   401,   568,    -1,   376,   568,
      -1,   669,    -1,   401,   180,   987,    -1,   197,   180,    -1,
     128,    -1,   378,    -1,    -1,   143,   740,    -1,    -1,   456,
     987,    -1,    -1,   508,   570,   509,    -1,   474,   568,    -1,
      -1,   571,    -1,   570,   511,   571,    -1,  1181,   495,   713,
      -1,  1181,    -1,  1181,   510,  1181,   495,   713,    -1,  1181,
     510,  1181,    -1,   101,   443,   740,   573,    -1,   574,    -1,
     573,   511,   574,    -1,    95,   114,   962,   565,    -1,   197,
     114,   243,   212,  1179,   565,    -1,   197,   114,  1179,   565,
      -1,   101,   114,  1179,   825,   443,   963,   566,   565,    -1,
     140,   904,    -1,   140,    99,    -1,   158,   583,  1048,   612,
     584,   577,   578,   579,   585,   520,   580,    -1,   158,   908,
     434,   578,   579,   520,   580,    -1,   228,    -1,   434,    -1,
     358,    -1,    -1,  1199,    -1,   415,    -1,   416,    -1,   581,
      -1,   508,   587,   509,    -1,   581,   582,    -1,    -1,   121,
      -1,   325,    -1,   227,    -1,   186,   859,  1199,    -1,   317,
     859,  1199,    -1,   162,    -1,   239,    -1,   359,   859,  1199,
      -1,   205,   859,  1199,    -1,   224,   359,   613,    -1,   224,
     359,   501,    -1,   224,   312,   317,   613,    -1,   201,  1199,
      -1,   121,    -1,    -1,   474,   325,    -1,    -1,   586,   187,
    1199,    -1,    -1,   456,    -1,    -1,   588,    -1,   587,   511,
     588,    -1,  1181,   589,    -1,   548,    -1,   641,    -1,   501,
      -1,   508,   590,   509,    -1,    -1,   591,    -1,   590,   511,
     591,    -1,   548,    -1,   160,   593,   424,  1048,   508,   594,
     509,   623,   624,   625,   626,    -1,   160,   593,   424,   243,
     312,   212,  1048,   508,   594,   509,   623,   624,   625,   626,
      -1,   160,   593,   424,  1048,   322,   740,   595,   624,   625,
     626,    -1,   160,   593,   424,   243,   312,   212,  1048,   322,
     740,   595,   624,   625,   626,    -1,   429,    -1,   427,    -1,
     290,   429,    -1,   290,   427,    -1,   232,   429,    -1,   232,
     427,    -1,   452,    -1,    -1,   596,    -1,    -1,   508,   597,
     509,    -1,    -1,   598,    -1,   596,   511,   598,    -1,   599,
      -1,   597,   511,   599,    -1,   600,    -1,   606,    -1,   609,
      -1,   601,    -1,   609,    -1,  1179,   963,   667,   602,    -1,
    1179,   474,   330,   602,    -1,   602,   603,    -1,    -1,   153,
    1050,   604,    -1,   604,    -1,   605,    -1,   143,   740,    -1,
     312,   317,    -1,   317,    -1,   449,   802,   627,    -1,   353,
     273,   802,   627,    -1,   137,   508,   987,   509,   611,    -1,
     180,   988,    -1,   367,  1048,   612,   615,   619,    -1,   182,
      -1,   312,   182,    -1,   255,   183,    -1,   255,   245,    -1,
     286,  1048,   607,    -1,   607,   249,   608,    -1,   607,   209,
     608,    -1,    -1,   181,    -1,   154,    -1,   252,    -1,   417,
      -1,   147,    -1,    99,    -1,   153,  1050,   610,    -1,   610,
      -1,   137,   508,   987,   509,   698,    -1,   449,   508,   613,
     509,   802,   627,   698,    -1,   449,   628,   698,    -1,   353,
     273,   508,   613,   509,   802,   627,   698,    -1,   353,   273,
     628,   698,    -1,   208,   779,   508,   616,   509,   802,   627,
     618,   698,    -1,   225,   273,   508,   613,   509,   367,  1048,
     612,   615,   619,   698,    -1,   310,   253,    -1,    -1,   508,
     613,   509,    -1,    -1,   614,    -1,   613,   511,   614,    -1,
    1179,    -1,   296,   229,    -1,   296,   341,    -1,   296,   406,
      -1,    -1,   617,    -1,   616,   511,   617,    -1,   781,   474,
     812,    -1,   781,   474,   328,   508,   812,   509,    -1,   471,
     508,   987,   509,    -1,    -1,   620,    -1,   621,    -1,   620,
     621,    -1,   621,   620,    -1,    -1,   326,   454,   622,    -1,
     326,   185,   622,    -1,   310,    94,    -1,   378,    -1,   128,
      -1,   401,   317,    -1,   401,   180,    -1,   254,   508,  1047,
     509,    -1,    -1,   474,   568,    -1,   474,   325,    -1,   475,
     325,    -1,    -1,   326,   148,   197,    -1,   326,   148,   185,
     386,    -1,   326,   148,   350,   386,    -1,    -1,   426,  1050,
      -1,    -1,   456,   251,   426,  1050,    -1,    -1,   456,   251,
    1054,    -1,  1048,   612,   624,   625,   626,    -1,   474,   173,
      -1,   474,   310,   173,    -1,    -1,   160,   633,   297,   468,
     632,   108,   907,   630,    -1,  1048,   612,   569,   626,    -1,
     452,    -1,    -1,   368,   297,   468,  1048,   630,    -1,   160,
     593,   395,  1048,   637,    -1,   101,   395,  1048,   638,    -1,
     101,   395,   243,   212,  1048,   638,    -1,   638,    -1,    -1,
     639,    -1,   638,   639,    -1,   126,   641,    -1,   172,    -1,
     310,   172,    -1,   250,   640,   641,    -1,   298,   641,    -1,
     300,   641,    -1,   310,   298,    -1,   310,   300,    -1,   338,
     125,   740,    -1,   412,   520,   641,    -1,   377,    -1,   377,
     520,   641,    -1,   125,    -1,    -1,  1198,    -1,   500,  1198,
      -1,  1060,    -1,   641,    -1,   642,   511,   641,    -1,   160,
     787,   644,   650,   275,   551,    -1,   160,   787,   644,   650,
     275,   551,   237,   645,   646,   648,    -1,   442,    -1,    -1,
    1050,    -1,  1050,   741,    -1,   256,   645,    -1,    -1,   460,
     645,    -1,   310,   460,    -1,   647,    -1,    -1,   197,   650,
     275,   551,   565,    -1,   197,   650,   275,   243,   212,   551,
     565,    -1,   356,    -1,    -1,   160,   426,  1050,   652,   293,
    1199,    -1,   339,  1050,    -1,    -1,   197,   426,  1050,    -1,
     197,   426,   243,   212,  1050,    -1,   160,   214,  1050,   520,
     655,    -1,   160,   214,   243,   312,   212,  1050,   520,   655,
      -1,   655,   656,    -1,    -1,   389,  1050,    -1,   467,   551,
      -1,   228,   551,    -1,   101,   214,  1050,   454,   658,    -1,
     658,   659,    -1,    -1,   434,   551,    -1,   101,   214,  1050,
     535,    98,  1056,   714,    -1,   101,   214,  1050,   535,   131,
     508,   963,   108,   963,   509,    -1,   101,   214,  1050,   535,
     144,   740,    -1,   101,   214,  1050,   535,   157,   740,    -1,
     101,   214,  1050,   535,   195,   740,    -1,   101,   214,  1050,
     535,   230,   765,    -1,   101,   214,  1050,   535,   650,   275,
    1050,    -1,   101,   214,  1050,   535,   328,   812,   811,    -1,
     101,   214,  1050,   535,   328,   139,   740,   456,  1052,    -1,
     101,   214,  1050,   535,   328,   218,   740,   456,  1052,    -1,
     101,   214,  1050,   535,   389,  1050,    -1,   101,   214,  1050,
     535,   206,   438,  1050,    -1,   101,   214,  1050,   535,   424,
     740,    -1,   101,   214,  1050,   535,   430,   391,   340,   740,
      -1,   101,   214,  1050,   535,   430,   391,   189,   740,    -1,
     101,   214,  1050,   535,   430,   391,   428,   740,    -1,   101,
     214,  1050,   535,   430,   391,   151,   740,    -1,   101,   214,
    1050,   535,   395,   740,    -1,   101,   214,  1050,   535,   468,
     740,    -1,   101,   214,  1050,   535,   297,   468,   740,    -1,
     101,   214,  1050,   535,   225,   424,   740,    -1,   101,   214,
    1050,   535,   225,   173,   477,  1050,    -1,   101,   214,  1050,
     535,   398,  1050,    -1,   101,   214,  1050,   535,   443,   740,
      -1,   160,   225,   173,   477,  1050,   664,   667,    -1,   237,
     645,    -1,   310,   237,    -1,   460,   645,    -1,   310,   460,
      -1,   662,    -1,   663,   662,    -1,   663,    -1,    -1,   197,
     225,   173,   477,  1050,   565,    -1,   197,   225,   173,   477,
     243,   212,  1050,   565,    -1,   101,   225,   173,   477,  1050,
     664,   669,    -1,   101,   225,   173,   477,  1050,   663,    -1,
     330,   508,   668,   509,    -1,    -1,   672,    -1,   668,   511,
     672,    -1,   330,   508,   670,   509,    -1,   671,    -1,   670,
     511,   671,    -1,   672,    -1,   401,   672,    -1,    95,   672,
      -1,   197,   673,    -1,   673,   674,    -1,  1181,    -1,  1199,
      -1,   160,   398,  1050,   676,   678,   225,   173,   477,  1050,
     667,    -1,   443,  1199,    -1,    -1,   467,  1199,    -1,   467,
     317,    -1,   677,    -1,    -1,   197,   398,  1050,   565,    -1,
     197,   398,   243,   212,  1050,   565,    -1,   101,   398,  1050,
     677,   669,    -1,   101,   398,  1050,   677,    -1,   101,   398,
    1050,   669,    -1,   160,   225,   424,  1048,   508,   594,   509,
     398,  1050,   667,    -1,   160,   225,   424,   243,   312,   212,
    1048,   508,   594,   509,   398,  1050,   667,    -1,   101,   225,
     424,   954,   562,    -1,   101,   225,   424,   243,   212,   954,
     562,    -1,   160,   455,   295,   223,   684,   398,  1050,   667,
      -1,   170,    -1,   455,    -1,  1059,    -1,   197,   455,   295,
     223,   684,   398,  1050,    -1,   197,   455,   295,   243,   212,
     223,   684,   398,  1050,    -1,   101,   455,   295,   223,   684,
     398,  1050,   669,    -1,   160,   438,  1050,   688,   689,   326,
    1048,   691,   694,   211,   357,  1056,   508,   695,   509,    -1,
     160,   153,   438,  1050,    97,   689,   326,  1048,   697,   698,
     223,   198,   385,   694,   211,   357,  1056,   508,   695,   509,
      -1,   117,    -1,    97,    -1,   262,   322,    -1,   690,    -1,
     689,   331,   690,    -1,   261,    -1,   185,    -1,   454,    -1,
     454,   322,   613,    -1,   441,    -1,   223,   692,   693,    -1,
      -1,   198,    -1,    -1,   385,    -1,   413,    -1,   470,   508,
     987,   509,    -1,    -1,   696,    -1,   695,   511,   696,    -1,
      -1,  1058,    -1,  1198,    -1,  1199,    -1,  1181,    -1,   228,
    1048,    -1,    -1,    -1,   698,   699,    -1,   312,   182,    -1,
     182,    -1,   255,   245,    -1,   255,   183,    -1,   312,   458,
      -1,   310,   253,    -1,   197,   438,  1050,   326,   740,   565,
      -1,   197,   438,   243,   212,  1050,   326,   740,   565,    -1,
     160,   206,   438,  1050,   326,  1181,   211,   357,  1056,   508,
     509,    -1,   160,   206,   438,  1050,   326,  1181,   470,   702,
     211,   357,  1056,   508,   509,    -1,   703,    -1,   702,   105,
     703,    -1,  1179,   248,   508,   704,   509,    -1,    82,    -1,
     704,   511,    82,    -1,   101,   206,   438,  1050,   706,    -1,
     200,    -1,   200,   375,    -1,   200,   102,    -1,   190,    -1,
     160,   110,  1050,   137,   508,   987,   509,   698,    -1,   197,
     110,  1050,   565,    -1,   160,    98,  1056,   714,   710,    -1,
     160,    98,  1056,   715,    -1,   160,   328,   812,   710,    -1,
     160,   443,   740,   710,    -1,   160,   443,   740,    -1,   160,
     443,   740,   108,   508,   960,   509,    -1,   160,   443,   740,
     108,   204,   508,   718,   509,    -1,   160,   443,   740,   108,
     360,   710,    -1,   160,   430,   391,   340,   740,   710,    -1,
     160,   430,   391,   189,   740,   710,    -1,   160,   430,   391,
     428,   740,   710,    -1,   160,   430,   391,   151,   740,   710,
      -1,   160,   144,   740,   710,    -1,   160,   144,   740,   228,
     740,    -1,   508,   711,   509,    -1,   712,    -1,   711,   511,
     712,    -1,  1181,   495,   713,    -1,  1181,    -1,   796,    -1,
    1065,    -1,  1014,    -1,   641,    -1,  1199,    -1,   508,  1019,
     509,    -1,   508,   501,   509,    -1,   508,   716,   509,    -1,
     717,    -1,   716,   511,   717,    -1,  1201,   495,   713,    -1,
     719,    -1,    -1,  1199,    -1,   719,   511,  1199,    -1,   101,
     443,   740,    95,   461,   721,  1199,    -1,   101,   443,   740,
      95,   461,   721,  1199,   117,  1199,    -1,   101,   443,   740,
      95,   461,   721,  1199,    97,  1199,    -1,   243,   312,   212,
      -1,    -1,   160,   328,   139,   740,   725,   223,   443,   963,
     456,  1052,   726,   108,   723,    -1,   724,    -1,   723,   511,
     724,    -1,   328,  1058,   812,   727,   728,    -1,   328,  1058,
     812,   811,   727,   728,    -1,   230,  1058,  1056,   788,    -1,
     230,  1058,   508,  1019,   509,  1056,   788,    -1,   417,   963,
      -1,   180,    -1,    -1,   218,   740,    -1,    -1,   223,   391,
      -1,   223,   332,   125,   740,    -1,    -1,   364,    -1,    -1,
     160,   328,   218,   740,   456,  1052,    -1,   101,   328,   218,
     740,   456,  1052,    95,   723,    -1,   101,   328,   218,   740,
     456,  1052,   197,   731,    -1,   732,    -1,   731,   511,   732,
      -1,   328,  1058,   508,  1019,   509,    -1,   230,  1058,   508,
    1019,   509,    -1,   197,   328,   139,   740,   456,  1052,   565,
      -1,   197,   328,   139,   243,   212,   740,   456,  1052,   565,
      -1,   197,   328,   218,   740,   456,  1052,   565,    -1,   197,
     328,   218,   243,   212,   740,   456,  1052,   565,    -1,   197,
     338,   125,  1049,   565,    -1,   363,   338,   125,  1049,   434,
    1050,    -1,   197,   738,   243,   212,   739,   565,    -1,   197,
     738,   739,   565,    -1,   197,   251,   150,   739,   565,    -1,
     197,   251,   150,   243,   212,   739,   565,    -1,   424,    -1,
     395,    -1,   468,    -1,   297,   468,    -1,   251,    -1,   225,
     424,    -1,   206,   438,    -1,   443,    -1,   195,    -1,   144,
      -1,   157,    -1,   389,    -1,   214,    -1,   430,   391,   340,
      -1,   430,   391,   189,    -1,   430,   391,   428,    -1,   430,
     391,   151,    -1,   740,    -1,   739,   511,   740,    -1,  1179,
      -1,  1179,   741,    -1,   510,  1053,    -1,   741,   510,  1053,
      -1,   441,   918,   955,   743,   565,    -1,   156,   242,    -1,
     377,   242,    -1,    -1,   146,   326,   745,   740,   269,   746,
      -1,   146,   326,    98,  1056,   714,   269,   746,    -1,   146,
     326,   230,  1056,   788,   269,   746,    -1,   146,   326,   328,
     812,   811,   269,   746,    -1,   146,   326,   153,  1050,   326,
     740,   269,   746,    -1,   146,   326,   387,  1050,   326,   740,
     269,   746,    -1,   146,   326,   387,  1050,   269,   746,    -1,
     146,   326,   438,  1050,   326,   740,   269,   746,    -1,   146,
     326,   328,   139,   740,   456,  1052,   269,   746,    -1,   146,
     326,   328,   218,   740,   456,  1052,   269,   746,    -1,   146,
     326,   276,   321,   641,   269,   746,    -1,   146,   326,   131,
     508,   963,   108,   963,   509,   269,   746,    -1,   146,   326,
     650,   275,   740,   269,   746,    -1,   145,    -1,   174,    -1,
     389,    -1,   251,    -1,   395,    -1,   424,    -1,   195,    -1,
     443,    -1,   468,    -1,   297,   468,    -1,   144,    -1,   157,
      -1,   426,    -1,   214,    -1,   383,    -1,   225,   424,    -1,
     398,    -1,   225,   173,   477,    -1,   206,   438,    -1,   430,
     391,   151,    -1,   430,   391,   189,    -1,   430,   391,   340,
      -1,   430,   391,   428,    -1,  1199,    -1,   317,    -1,   393,
     274,   748,   326,   749,   740,   269,   750,    -1,   393,   274,
     748,   326,    98,  1056,   714,   269,   750,    -1,   393,   274,
     748,   326,   230,  1056,   788,   269,   750,    -1,   393,   274,
     748,   326,   276,   321,   641,   269,   750,    -1,   393,   274,
     748,   326,   650,   275,   740,   269,   750,    -1,   223,   551,
      -1,    -1,   145,    -1,   174,    -1,   206,   438,    -1,   225,
     424,    -1,   389,    -1,   395,    -1,   424,    -1,   195,    -1,
     383,    -1,   426,    -1,   443,    -1,   468,    -1,   297,   468,
      -1,  1199,    -1,   317,    -1,   219,   752,    -1,   303,   752,
      -1,   219,   752,  1213,    -1,   219,   226,   904,  1214,    -1,
     219,   226,   753,   904,  1214,    -1,   219,   116,   904,  1214,
      -1,   219,   116,   753,   904,  1214,    -1,   303,   226,   904,
      -1,   303,   226,   753,   904,    -1,   303,   116,   904,    -1,
     303,   116,   753,   904,    -1,   904,    -1,   753,   904,    -1,
     309,   754,   904,    -1,   354,   754,   904,    -1,   220,   754,
     904,    -1,   277,   754,   904,    -1,    92,  1060,   754,   904,
      -1,   370,  1060,   754,   904,    -1,  1060,   754,   904,    -1,
      99,   754,   904,    -1,   226,  1060,   754,   904,    -1,   226,
      99,   754,   904,    -1,   116,  1060,   754,   904,    -1,   116,
      99,   754,   904,    -1,   228,    -1,   248,    -1,   753,    -1,
      -1,   233,   757,   326,   760,   434,   761,   763,    -1,   381,
     757,   326,   760,   228,   761,   565,    -1,   381,   233,   329,
     223,   757,   326,   760,   228,   761,   565,    -1,   758,    -1,
      99,    -1,    99,   355,    -1,    99,   508,   613,   509,    -1,
      99,   355,   508,   613,   509,    -1,   759,    -1,   758,   511,
     759,    -1,   394,   612,    -1,   367,   612,    -1,   160,   612,
      -1,  1179,   612,    -1,  1047,    -1,   424,  1047,    -1,   395,
    1047,    -1,   225,   173,   477,  1049,    -1,   225,   398,  1049,
      -1,   230,   764,    -1,   174,  1049,    -1,   195,   739,    -1,
     275,  1049,    -1,   276,   321,   642,    -1,   389,  1049,    -1,
     426,  1049,    -1,   443,   739,    -1,    99,   425,   248,   389,
    1049,    -1,    99,   396,   248,   389,  1049,    -1,    99,   231,
     248,   389,  1049,    -1,   762,    -1,   761,   511,   762,    -1,
    1059,    -1,   236,  1059,    -1,   474,   233,   329,    -1,    -1,
     765,    -1,   764,   511,   765,    -1,  1056,   788,    -1,   233,
     758,   434,  1049,   768,   769,    -1,   381,   758,   228,  1049,
     769,   565,    -1,   381,    96,   329,   223,   758,   228,  1049,
     769,   565,    -1,   474,    96,   329,    -1,    -1,   234,   125,
    1059,    -1,    -1,   101,   180,   355,   771,   773,    -1,   771,
     772,    -1,    -1,   248,   389,  1049,    -1,   223,   383,  1049,
      -1,   223,   455,  1049,    -1,   233,   757,   326,   774,   434,
     761,   763,    -1,   381,   757,   326,   774,   228,   761,   565,
      -1,   381,   233,   329,   223,   757,   326,   774,   228,   761,
     565,    -1,   425,    -1,   231,    -1,   396,    -1,   444,    -1,
     160,   776,   251,   777,   778,   326,  1048,   779,   508,   780,
     509,   569,   626,   958,    -1,   449,    -1,    -1,   150,    -1,
      -1,  1054,    -1,    -1,   456,  1052,    -1,    -1,   781,    -1,
     780,   511,   781,    -1,  1179,   782,   783,   784,   785,    -1,
     990,   782,   783,   784,   785,    -1,   508,   987,   509,   782,
     783,   784,   785,    -1,   143,   740,    -1,    -1,   740,    -1,
     456,   740,    -1,    -1,   109,    -1,   188,    -1,    -1,   492,
      -1,   493,    -1,    -1,   160,   787,   230,  1056,   790,   380,
     795,   798,   802,    -1,   160,   787,   230,  1056,   790,   380,
     424,   508,   804,   509,   798,   802,    -1,   160,   787,   230,
    1056,   790,   798,   802,    -1,   331,   374,    -1,    -1,   508,
     789,   509,    -1,   508,   509,    -1,   792,    -1,   789,   511,
     792,    -1,   508,   791,   509,    -1,   508,   509,    -1,   797,
      -1,   791,   511,   797,    -1,   793,   794,   796,    -1,   794,
     793,   796,    -1,   794,   796,    -1,   793,   796,    -1,   796,
      -1,   248,    -1,   333,    -1,   258,    -1,   248,   333,    -1,
     464,    -1,  1180,    -1,   796,    -1,   963,    -1,  1180,   741,
     503,   443,    -1,   402,  1180,   741,   503,   443,    -1,   792,
      -1,   792,   180,   987,    -1,   792,   495,   987,    -1,   800,
      -1,   798,   800,    -1,   127,   326,   317,   259,    -1,   380,
     317,   326,   317,   259,    -1,   418,    -1,   246,    -1,   410,
      -1,   469,    -1,   215,   393,   184,    -1,   215,   393,   268,
      -1,   393,   184,    -1,   393,   268,    -1,   282,    -1,   312,
     282,    -1,   159,   641,    -1,   386,   641,    -1,   554,    -1,
     108,   801,    -1,   275,   551,    -1,   473,    -1,   799,    -1,
    1199,    -1,  1199,   511,  1199,    -1,   474,   710,    -1,    -1,
     794,   796,    -1,   803,    -1,   804,   511,   803,    -1,   101,
     230,   765,   806,   807,    -1,   799,    -1,   806,   799,    -1,
     378,    -1,    -1,   197,   230,  1056,   788,   565,    -1,   197,
     230,   243,   212,  1056,   788,   565,    -1,   197,    98,  1056,
     714,   565,    -1,   197,    98,   243,   212,  1056,   714,   565,
      -1,   197,   328,   812,   811,   565,    -1,   197,   328,   243,
     212,   812,   811,   565,    -1,   508,   963,   509,    -1,   508,
     963,   511,   963,   509,    -1,   508,   311,   511,   963,   509,
      -1,   508,   963,   511,   311,   509,    -1,  1011,    -1,  1179,
     510,   812,    -1,   193,   814,    -1,   815,    -1,   814,   815,
      -1,  1199,    -1,   275,   551,    -1,   160,   131,   508,   963,
     108,   963,   509,   474,   230,   765,   817,    -1,   160,   131,
     508,   963,   108,   963,   509,   475,   230,   817,    -1,   160,
     131,   508,   963,   108,   963,   509,   474,   258,   817,    -1,
     108,   247,    -1,   108,   111,    -1,    -1,   197,   131,   819,
     508,   963,   108,   963,   509,   565,    -1,   243,   212,    -1,
      -1,   369,   821,  1048,   822,    -1,   369,   423,  1050,   822,
      -1,   369,   174,  1050,   822,    -1,   251,    -1,   424,    -1,
     224,    -1,    -1,   101,    98,  1056,   714,   372,   434,  1050,
      -1,   101,   144,   740,   372,   434,  1050,    -1,   101,   157,
     740,   372,   434,  1050,    -1,   101,   174,  1051,   372,   434,
    1051,    -1,   101,   195,   740,   372,   434,  1050,    -1,   101,
     195,   740,   372,   153,  1050,   434,  1050,    -1,   101,   225,
     173,   477,  1050,   372,   434,  1050,    -1,   101,   230,   765,
     372,   434,  1050,    -1,   101,   236,  1059,   372,   434,  1059,
      -1,   101,   650,   275,  1050,   372,   434,  1050,    -1,   101,
     328,   139,   740,   456,  1052,   372,   434,  1050,    -1,   101,
     328,   218,   740,   456,  1052,   372,   434,  1050,    -1,   101,
     389,  1050,   372,   434,  1050,    -1,   101,   398,  1050,   372,
     434,  1050,    -1,   101,   424,   954,   372,   434,  1050,    -1,
     101,   424,   243,   212,   954,   372,   434,  1050,    -1,   101,
     395,  1048,   372,   434,  1050,    -1,   101,   395,   243,   212,
    1048,   372,   434,  1050,    -1,   101,   468,  1048,   372,   434,
    1050,    -1,   101,   468,   243,   212,  1048,   372,   434,  1050,
      -1,   101,   297,   468,  1048,   372,   434,  1050,    -1,   101,
     297,   468,   243,   212,  1048,   372,   434,  1050,    -1,   101,
     251,  1048,   372,   434,  1050,    -1,   101,   251,   243,   212,
    1048,   372,   434,  1050,    -1,   101,   225,   424,   954,   372,
     434,  1050,    -1,   101,   225,   424,   243,   212,   954,   372,
     434,  1050,    -1,   101,   424,   954,   372,   824,  1050,   434,
    1050,    -1,   101,   424,   243,   212,   954,   372,   824,  1050,
     434,  1050,    -1,   101,   297,   468,  1048,   372,   824,  1050,
     434,  1050,    -1,   101,   297,   468,   243,   212,  1048,   372,
     824,  1050,   434,  1050,    -1,   101,   424,   954,   372,   153,
    1050,   434,  1050,    -1,   101,   225,   424,   954,   372,   824,
    1050,   434,  1050,    -1,   101,   225,   424,   243,   212,   954,
     372,   824,  1050,   434,  1050,    -1,   101,   387,  1050,   326,
    1048,   372,   434,  1050,    -1,   101,   438,  1050,   326,  1048,
     372,   434,  1050,    -1,   101,   206,   438,  1050,   372,   434,
    1050,    -1,   101,   383,  1059,   372,   434,  1059,    -1,   101,
     455,  1059,   372,   434,  1059,    -1,   101,   426,  1050,   372,
     434,  1050,    -1,   101,   426,  1050,   401,   568,    -1,   101,
     426,  1050,   376,   568,    -1,   101,   430,   391,   340,   740,
     372,   434,  1050,    -1,   101,   430,   391,   189,   740,   372,
     434,  1050,    -1,   101,   430,   391,   428,   740,   372,   434,
    1050,    -1,   101,   430,   391,   151,   740,   372,   434,  1050,
      -1,   101,   443,   740,   372,   434,  1050,    -1,   101,   443,
     740,   372,   114,  1050,   434,  1050,   565,    -1,   145,    -1,
      -1,   401,   173,    -1,    -1,   101,    98,  1056,   714,   401,
     389,  1050,    -1,   101,   144,   740,   401,   389,  1050,    -1,
     101,   157,   740,   401,   389,  1050,    -1,   101,   195,   740,
     401,   389,  1050,    -1,   101,   214,   740,   401,   389,  1050,
      -1,   101,   230,   765,   401,   389,  1050,    -1,   101,   328,
     812,   811,   401,   389,  1050,    -1,   101,   328,   139,   740,
     456,  1052,   401,   389,  1050,    -1,   101,   328,   218,   740,
     456,  1052,   401,   389,  1050,    -1,   101,   424,   954,   401,
     389,  1050,    -1,   101,   424,   243,   212,   954,   401,   389,
    1050,    -1,   101,   430,   391,   340,   740,   401,   389,  1050,
      -1,   101,   430,   391,   189,   740,   401,   389,  1050,    -1,
     101,   430,   391,   428,   740,   401,   389,  1050,    -1,   101,
     430,   391,   151,   740,   401,   389,  1050,    -1,   101,   395,
    1048,   401,   389,  1050,    -1,   101,   395,   243,   212,  1048,
     401,   389,  1050,    -1,   101,   468,  1048,   401,   389,  1050,
      -1,   101,   468,   243,   212,  1048,   401,   389,  1050,    -1,
     101,   297,   468,  1048,   401,   389,  1050,    -1,   101,   297,
     468,   243,   212,  1048,   401,   389,  1050,    -1,   101,   225,
     424,   954,   401,   389,  1050,    -1,   101,   225,   424,   243,
     212,   954,   401,   389,  1050,    -1,   101,   443,   740,   401,
     389,  1050,    -1,   101,    98,  1056,   714,   339,   434,  1059,
      -1,   101,   144,   740,   339,   434,  1059,    -1,   101,   157,
     740,   339,   434,  1059,    -1,   101,   174,  1051,   339,   434,
    1059,    -1,   101,   195,   740,   339,   434,  1059,    -1,   101,
     230,   765,   339,   434,  1059,    -1,   101,   650,   275,  1050,
     339,   434,  1059,    -1,   101,   276,   321,   641,   339,   434,
    1059,    -1,   101,   328,   812,   811,   339,   434,  1059,    -1,
     101,   328,   139,   740,   456,  1052,   339,   434,  1059,    -1,
     101,   328,   218,   740,   456,  1052,   339,   434,  1059,    -1,
     101,   389,  1050,   339,   434,  1059,    -1,   101,   443,   740,
     339,   434,  1059,    -1,   101,   426,  1050,   339,   434,  1059,
      -1,   101,   430,   391,   189,   740,   339,   434,  1059,    -1,
     101,   430,   391,   151,   740,   339,   434,  1059,    -1,   101,
     225,   173,   477,  1050,   339,   434,  1059,    -1,   101,   398,
    1050,   339,   434,  1059,    -1,   101,   206,   438,  1050,   339,
     434,  1059,    -1,   160,   787,   387,  1050,   108,   326,   833,
     434,  1048,   958,   193,   834,   829,    -1,   313,    -1,   831,
      -1,   508,   830,   509,    -1,   830,   512,   832,    -1,   832,
      -1,   907,    -1,   885,    -1,   896,    -1,   890,    -1,   836,
      -1,   831,    -1,    -1,   394,    -1,   454,    -1,   185,    -1,
     261,    -1,   262,    -1,   100,    -1,    -1,   197,   387,  1050,
     326,   740,   565,    -1,   197,   387,   243,   212,  1050,   326,
     740,   565,    -1,   314,  1179,   837,    -1,   511,  1199,    -1,
      -1,   288,  1179,    -1,   451,  1179,    -1,   451,   501,    -1,
      91,   841,    -1,   118,   841,   844,    -1,   412,   436,   844,
      -1,   148,   841,    -1,   203,   841,    -1,   384,   841,    -1,
     388,  1179,    -1,   371,   388,  1179,    -1,   371,  1179,    -1,
     384,   841,   434,   388,  1179,    -1,   384,   841,   434,  1179,
      -1,   351,   436,  1199,    -1,   148,   352,  1199,    -1,   384,
     352,  1199,    -1,   476,    -1,   436,    -1,    -1,   271,   285,
     547,    -1,   361,   327,    -1,   361,   478,    -1,   182,    -1,
     312,   182,    -1,   842,    -1,   843,   511,   842,    -1,   843,
     842,    -1,   843,    -1,    -1,   160,   593,   468,  1048,   612,
     569,   108,   907,   846,    -1,   160,   331,   374,   593,   468,
    1048,   612,   569,   108,   907,   846,    -1,   160,   593,   365,
     468,  1048,   508,   613,   509,   569,   108,   907,    -1,   160,
     331,   374,   593,   365,   468,  1048,   508,   613,   509,   569,
     108,   907,    -1,   474,   137,   329,    -1,   474,   129,   137,
     329,    -1,   474,   290,   137,   329,    -1,    -1,   289,  1055,
      -1,   160,   174,  1051,   520,   849,    -1,   849,   850,    -1,
      -1,   426,   851,  1050,    -1,   426,   851,   180,    -1,   293,
     851,  1199,    -1,   293,   851,   180,    -1,   428,   851,  1050,
      -1,   428,   851,   180,    -1,   201,   851,  1199,    -1,   201,
     851,  1058,    -1,   201,   851,   180,    -1,   279,   851,  1199,
      -1,   279,   851,   180,    -1,   280,   851,  1199,    -1,   280,
     851,   180,    -1,   152,   287,   851,  1060,    -1,   339,   851,
    1050,    -1,   339,   851,   180,    -1,   495,    -1,    -1,   101,
     174,  1051,   520,   854,    -1,   101,   174,  1051,   401,   426,
    1050,    -1,   101,   174,  1051,   553,    -1,   854,   855,    -1,
      -1,   152,   287,   851,  1060,    -1,   197,   174,  1051,    -1,
     197,   174,   243,   212,  1051,    -1,   160,   195,   740,   859,
     963,   602,    -1,   101,   195,   740,   564,    -1,   101,   195,
     740,   197,   312,   317,    -1,   101,   195,   740,   401,   312,
     317,    -1,   101,   195,   740,    95,   609,    -1,   101,   195,
     740,   197,   153,  1050,   565,    -1,   101,   195,   740,   197,
     153,   243,   212,  1050,   565,    -1,   101,   195,   740,   459,
     153,  1050,    -1,   108,    -1,    -1,   101,   430,   391,   189,
     740,   710,    -1,   101,   430,   391,   151,   740,    95,   295,
     223,  1049,   474,   739,    -1,   101,   430,   391,   151,   740,
     101,   295,   223,  1049,   474,   739,    -1,   101,   430,   391,
     151,   740,   101,   295,   374,   740,   474,   740,    -1,   101,
     430,   391,   151,   740,   101,   295,   223,  1049,   374,   740,
     474,   740,    -1,   101,   430,   391,   151,   740,   197,   295,
     223,  1049,    -1,   101,   430,   391,   151,   740,   197,   295,
     243,   212,   223,  1049,    -1,   160,   725,   157,   740,   223,
    1199,   434,  1199,   228,   740,    -1,   141,   870,  1048,   864,
      -1,   141,   870,    -1,   141,   870,  1054,   326,  1048,    -1,
     456,  1054,    -1,    -1,   457,   871,   872,   870,    -1,   457,
     871,   872,   870,  1048,    -1,   457,   871,   872,   870,   868,
      -1,   457,   508,   866,   509,    -1,   457,   508,   866,   509,
    1048,   873,    -1,   867,    -1,   866,   511,   867,    -1,   869,
      -1,   466,    -1,   227,    -1,   229,    -1,   869,   870,    -1,
     869,   870,  1048,   873,    -1,   104,    -1,   103,    -1,   466,
      -1,    -1,   229,    -1,    -1,   227,    -1,    -1,   508,  1049,
     509,    -1,    -1,   213,   875,    -1,   213,   869,   870,   875,
      -1,   213,   466,   875,    -1,   213,   508,   876,   509,   875,
      -1,   907,    -1,   885,    -1,   896,    -1,   890,    -1,   903,
      -1,  1068,    -1,   631,    -1,   634,    -1,   883,    -1,   877,
      -1,   876,   511,   877,    -1,   878,   879,    -1,  1061,    -1,
     869,    -1,   548,    -1,   641,    -1,    -1,   351,  1087,   881,
     108,   882,    -1,   351,  1087,   228,  1132,    -1,   508,  1019,
     509,    -1,    -1,   907,    -1,   885,    -1,   896,    -1,   890,
      -1,   211,  1087,   884,  1211,    -1,   160,   593,   424,   629,
     108,   211,  1050,   884,   630,    -1,   508,  1016,   509,    -1,
      -1,   915,   261,   267,  1048,   886,   889,    -1,   907,    -1,
     508,   887,   509,   907,    -1,   180,   462,    -1,   888,    -1,
     887,   511,   888,    -1,  1179,  1040,    -1,   379,  1045,  1212,
      -1,    -1,   915,   185,   228,   956,   891,   959,   889,    -1,
     456,   945,    -1,    -1,   294,   918,   955,   893,   895,    -1,
     248,   894,   301,    -1,    -1,    93,   403,    -1,   385,   403,
      -1,   385,   210,    -1,   403,   454,   210,    -1,   403,    -1,
     403,   385,   210,    -1,   210,    -1,    93,   210,    -1,   316,
      -1,    -1,   915,   454,   956,   401,   897,   944,   959,   889,
      -1,   898,    -1,   897,   511,   898,    -1,   899,    -1,   900,
      -1,   901,   495,  1042,    -1,   508,   902,   509,   495,  1044,
      -1,  1179,  1040,    -1,   901,    -1,   902,   511,   901,    -1,
     179,   904,   905,   171,   906,   223,   907,    -1,  1050,    -1,
    1192,    -1,    -1,   905,   310,   390,    -1,   905,   390,    -1,
     905,   121,    -1,   905,   260,    -1,    -1,   474,   240,    -1,
     475,   240,    -1,   909,    -1,   908,    -1,   508,   909,   509,
      -1,   508,   908,   509,    -1,   911,    -1,   910,   922,    -1,
     910,   921,   937,   926,    -1,   910,   921,   925,   938,    -1,
     912,   910,    -1,   912,   910,   922,    -1,   912,   910,   921,
     937,   926,    -1,   912,   910,   921,   925,   938,    -1,   911,
      -1,   908,    -1,   394,   920,  1045,   916,   944,   958,   935,
     936,   999,    -1,   943,    -1,   424,   954,    -1,   910,   448,
     919,   910,    -1,   910,   265,   919,   910,    -1,   910,   207,
     919,   910,    -1,   474,   913,    -1,   474,   365,   913,    -1,
     914,    -1,   913,   511,   914,    -1,  1050,   873,   108,   508,
     882,   509,    -1,   912,    -1,    -1,   267,   917,    -1,  1212,
      -1,    -1,   429,   918,  1048,    -1,   427,   918,  1048,    -1,
     290,   429,   918,  1048,    -1,   290,   427,   918,  1048,    -1,
     232,   429,   918,  1048,    -1,   232,   427,   918,  1048,    -1,
     452,   918,  1048,    -1,   424,  1048,    -1,  1048,    -1,   424,
      -1,    -1,    99,    -1,   192,    -1,    -1,   192,    -1,   192,
     326,   508,  1016,   509,    -1,    99,    -1,    -1,   922,    -1,
      -1,   332,   125,   923,    -1,   924,    -1,   923,   511,   924,
      -1,   987,   456,  1014,   785,    -1,   987,   784,   785,    -1,
     927,   928,    -1,   928,   927,    -1,   927,    -1,   928,    -1,
     925,    -1,    -1,   287,   929,    -1,   287,   929,   511,   930,
      -1,   219,   934,   931,   933,   327,    -1,   324,   930,    -1,
     324,   932,   933,    -1,   987,    -1,    99,    -1,   987,    -1,
    1060,    -1,   508,   987,   509,    -1,    -1,   989,    -1,   385,
      -1,   386,    -1,   220,    -1,   309,    -1,   236,   125,  1016,
      -1,    -1,   238,   987,    -1,    -1,   939,    -1,   223,   361,
     327,    -1,   937,    -1,    -1,   940,    -1,   939,   940,    -1,
     941,   942,   895,    -1,   223,   454,    -1,   223,   310,   273,
     454,    -1,   223,   403,    -1,   223,   273,   403,    -1,   322,
    1047,    -1,    -1,   462,  1044,    -1,   943,   511,  1044,    -1,
     228,   945,    -1,    -1,   946,    -1,   945,   511,   946,    -1,
     954,   949,    -1,   957,   950,    -1,   278,   957,   950,    -1,
     908,   949,    -1,   278,   908,   949,    -1,   947,    -1,   508,
     947,   509,   948,    -1,   508,   947,   509,    -1,   946,   161,
     272,   946,    -1,   946,   951,   272,   946,   953,    -1,   946,
     272,   946,   953,    -1,   946,   307,   951,   272,   946,    -1,
     946,   307,   272,   946,    -1,   108,  1179,   508,  1049,   509,
      -1,   108,  1179,    -1,  1179,   508,  1049,   509,    -1,  1179,
      -1,   948,    -1,    -1,   948,    -1,   108,   508,   961,   509,
      -1,   108,  1179,   508,   961,   509,    -1,  1179,   508,   961,
     509,    -1,    -1,   229,   952,    -1,   284,   952,    -1,   382,
     952,    -1,   257,    -1,   334,    -1,    -1,   456,   508,  1049,
     509,    -1,   326,   987,    -1,  1048,    -1,  1048,   501,    -1,
     327,  1048,    -1,   327,   508,  1048,   509,    -1,   954,    -1,
     955,   511,   954,    -1,   954,    -1,   954,  1179,    -1,   954,
     108,  1179,    -1,   990,    -1,   471,   987,    -1,    -1,   471,
     987,    -1,   471,   163,   322,   904,    -1,    -1,   961,    -1,
      -1,   962,    -1,   961,   511,   962,    -1,  1179,   963,   566,
      -1,   965,   964,    -1,   402,   965,   964,    -1,   965,   107,
     506,  1058,   507,    -1,   402,   965,   107,   506,  1058,   507,
      -1,   965,   107,    -1,   402,   965,   107,    -1,   964,   506,
     507,    -1,   964,   506,  1210,   507,    -1,    -1,   967,    -1,
     969,    -1,   971,    -1,   975,    -1,   982,    -1,   983,   985,
      -1,   983,   508,  1058,   509,   985,    -1,   969,    -1,   972,
      -1,   976,    -1,   982,    -1,  1180,   968,    -1,  1180,   741,
     968,    -1,   508,  1016,   509,    -1,    -1,   263,    -1,   264,
      -1,   407,    -1,   120,    -1,   362,    -1,   221,   970,    -1,
     196,   349,    -1,   178,   968,    -1,   177,   968,    -1,   320,
     968,    -1,   123,    -1,   508,  1058,   509,    -1,    -1,   973,
      -1,   974,    -1,   973,    -1,   974,    -1,   122,   980,   508,
    1016,   509,    -1,   122,   980,    -1,   977,    -1,   978,    -1,
     977,    -1,   978,    -1,   979,   508,  1058,   509,   981,    -1,
     979,   981,    -1,   135,   980,    -1,   134,   980,    -1,   463,
      -1,   306,   135,   980,    -1,   306,   134,   980,    -1,   308,
     980,    -1,   465,    -1,    -1,   135,   401,  1179,    -1,    -1,
     433,   508,  1058,   509,   984,    -1,   433,   984,    -1,   432,
     508,  1058,   509,   984,    -1,   432,   984,    -1,   266,    -1,
     494,   491,    -1,   475,   432,   491,    -1,    -1,   489,    -1,
     302,    -1,   175,    -1,   241,    -1,   299,    -1,   986,    -1,
     489,   434,   302,    -1,   175,   434,   241,    -1,   175,   434,
     299,    -1,   175,   434,   986,    -1,   241,   434,   299,    -1,
     241,   434,   986,    -1,   299,   434,   986,    -1,    -1,   392,
      -1,   392,   508,  1058,   509,    -1,   989,    -1,   987,    88,
     963,    -1,   987,   143,   740,    -1,   987,   113,   432,   491,
     987,    -1,   499,   987,    -1,   500,   987,    -1,   987,   499,
     987,    -1,   987,   500,   987,    -1,   987,   501,   987,    -1,
     987,   502,   987,    -1,   987,   503,   987,    -1,   987,   504,
     987,    -1,   987,   496,   987,    -1,   987,   497,   987,    -1,
     987,   495,   987,    -1,   987,  1013,   987,    -1,  1013,   987,
      -1,   987,  1013,    -1,   987,   105,   987,    -1,   987,   331,
     987,    -1,   312,   987,    -1,   987,   286,   987,    -1,   987,
     286,   987,   205,   987,    -1,   987,   312,   286,   987,    -1,
     987,   312,   286,   987,   205,   987,    -1,   987,   244,   987,
      -1,   987,   244,   987,   205,   987,    -1,   987,   312,   244,
     987,    -1,   987,   312,   244,   987,   205,   987,    -1,   987,
     405,   434,   987,    -1,   987,   405,   434,   987,   205,   987,
      -1,   987,   312,   405,   434,   987,    -1,   987,   312,   405,
     434,   987,   205,   987,    -1,   987,   269,   317,    -1,   987,
     270,    -1,   987,   269,   312,   317,    -1,   987,   315,    -1,
    1009,   336,  1009,    -1,   987,   269,   440,    -1,   987,   269,
     312,   440,    -1,   987,   269,   217,    -1,   987,   269,   312,
     217,    -1,   987,   269,   450,    -1,   987,   269,   312,   450,
      -1,   987,   269,   192,   228,   987,    -1,   987,   269,   312,
     192,   228,   987,    -1,   987,   269,   322,   508,  1019,   509,
      -1,   987,   269,   312,   322,   508,  1019,   509,    -1,   987,
     119,  1041,   988,   105,   988,    -1,   987,   312,   119,  1041,
     988,   105,   988,    -1,   987,   119,   421,   988,   105,   988,
      -1,   987,   312,   119,   421,   988,   105,   988,    -1,   987,
     248,  1031,    -1,   987,   312,   248,  1031,    -1,   987,  1015,
    1010,   908,    -1,   987,  1015,  1010,   508,   987,   509,    -1,
     449,   908,    -1,   987,   269,   194,    -1,   987,   269,   312,
     194,    -1,   989,    -1,   988,    88,   963,    -1,   499,   988,
      -1,   500,   988,    -1,   988,   499,   988,    -1,   988,   500,
     988,    -1,   988,   501,   988,    -1,   988,   502,   988,    -1,
     988,   503,   988,    -1,   988,   504,   988,    -1,   988,   496,
     988,    -1,   988,   497,   988,    -1,   988,   495,   988,    -1,
     988,  1013,   988,    -1,  1013,   988,    -1,   988,  1013,    -1,
     988,   269,   192,   228,   988,    -1,   988,   269,   312,   192,
     228,   988,    -1,   988,   269,   322,   508,  1019,   509,    -1,
     988,   269,   312,   322,   508,  1019,   509,    -1,   988,   269,
     194,    -1,   988,   269,   312,   194,    -1,  1037,    -1,  1057,
      -1,  1196,  1040,    -1,   508,   987,   509,  1040,    -1,  1032,
      -1,   990,    -1,   908,    -1,   908,  1039,    -1,   212,   908,
      -1,   107,   908,    -1,   107,  1020,    -1,  1009,    -1,  1056,
     508,   509,  1002,    -1,  1056,   508,  1017,   509,  1002,    -1,
    1056,   508,   464,  1018,   509,  1002,    -1,  1056,   508,  1017,
     511,   464,  1018,   509,  1002,    -1,  1056,   508,  1017,   922,
     509,  1002,    -1,  1056,   508,    99,  1017,   921,   509,  1002,
      -1,  1056,   508,   192,  1017,   921,   509,  1002,    -1,  1056,
     508,   501,   509,  1002,    -1,   144,   223,   508,   987,   509,
      -1,   165,    -1,   168,    -1,   168,   508,  1058,   509,    -1,
     169,    -1,   169,   508,  1058,   509,    -1,   291,    -1,   291,
     508,  1058,   509,    -1,   292,    -1,   292,   508,  1058,   509,
      -1,   166,    -1,   170,    -1,   400,    -1,   455,    -1,   164,
      -1,   167,    -1,   131,   508,   987,   108,   963,   509,    -1,
     216,   508,  1022,   509,    -1,   337,   508,  1024,   509,    -1,
     347,   508,  1026,   509,    -1,   420,   508,  1027,   509,    -1,
     437,   508,   987,   108,   963,   509,    -1,   439,   508,   124,
    1030,   509,    -1,   439,   508,   281,  1030,   509,    -1,   439,
     508,   435,  1030,   509,    -1,   439,   508,  1030,   509,    -1,
     318,   508,   987,   511,   987,   509,    -1,   142,   508,  1016,
     509,    -1,   235,   508,  1016,   509,    -1,   283,   508,  1016,
     509,    -1,   481,   508,  1016,   509,    -1,   482,   508,   304,
    1181,   509,    -1,   482,   508,   304,  1181,   511,   993,   509,
      -1,   482,   508,   304,  1181,   511,  1016,   509,    -1,   482,
     508,   304,  1181,   511,   993,   511,  1016,   509,    -1,   483,
     508,   989,   998,   509,    -1,   484,   508,   994,   509,    -1,
     485,   508,   996,   987,   997,   509,    -1,   486,   508,   304,
    1181,   509,    -1,   486,   508,   304,  1181,   511,   987,   509,
      -1,   487,   508,   987,   511,   991,   992,   509,    -1,   488,
     508,   996,   987,   108,   965,   509,    -1,   467,   987,    -1,
     467,   310,   461,    -1,   511,   411,   490,    -1,   511,   411,
     310,    -1,   511,   411,   310,   461,    -1,    -1,   480,   508,
     994,   509,    -1,   995,    -1,   994,   511,   995,    -1,   987,
     108,  1181,    -1,   987,    -1,   194,    -1,   155,    -1,   350,
     472,    -1,   419,   472,    -1,    -1,   343,   989,    -1,   343,
     989,   125,   366,    -1,   343,   125,   366,   989,    -1,   343,
     125,   366,   989,   125,   366,    -1,   473,  1000,    -1,    -1,
    1001,    -1,  1000,   511,  1001,    -1,  1179,   108,  1003,    -1,
     335,  1003,    -1,   335,  1179,    -1,    -1,   508,  1004,  1005,
     921,  1006,   509,    -1,  1179,    -1,    -1,   342,   125,  1016,
      -1,    -1,   360,  1007,    -1,   386,  1007,    -1,    -1,  1008,
      -1,   119,  1008,   105,  1008,    -1,   445,   348,    -1,   445,
     222,    -1,   163,   385,    -1,   987,   348,    -1,   987,   222,
      -1,   385,   508,  1016,   509,    -1,   385,   508,   509,    -1,
     508,  1016,   511,   987,   509,    -1,   106,    -1,   409,    -1,
      99,    -1,    85,    -1,  1012,    -1,   499,    -1,   500,    -1,
     501,    -1,   502,    -1,   503,    -1,   504,    -1,   496,    -1,
     497,    -1,   495,    -1,    85,    -1,   328,   508,   812,   509,
      -1,  1011,    -1,   328,   508,   812,   509,    -1,  1011,    -1,
     328,   508,   812,   509,    -1,   286,    -1,   312,   286,    -1,
     244,    -1,   312,   244,    -1,   987,    -1,  1016,   511,   987,
      -1,  1018,    -1,  1017,   511,  1018,    -1,   987,    -1,   794,
      90,   987,    -1,   963,    -1,  1019,   511,   963,    -1,   506,
    1016,   507,    -1,   506,  1021,   507,    -1,   506,   507,    -1,
    1020,    -1,  1021,   511,  1020,    -1,  1023,   228,   987,    -1,
      -1,  1201,    -1,   489,    -1,   302,    -1,   175,    -1,   241,
      -1,   299,    -1,   392,    -1,  1199,    -1,   987,  1025,  1028,
    1029,    -1,   987,  1025,  1028,    -1,   345,   987,    -1,   988,
     248,   988,    -1,    -1,   987,  1028,  1029,    -1,   987,  1029,
    1028,    -1,   987,  1028,    -1,   987,  1029,    -1,  1016,    -1,
      -1,   228,   987,    -1,   223,   987,    -1,   987,   228,  1016,
      -1,   228,  1016,    -1,  1016,    -1,   908,    -1,   508,  1016,
     509,    -1,   130,  1036,  1033,  1035,   203,    -1,  1034,    -1,
    1033,  1034,    -1,   470,   987,   431,   987,    -1,   199,   987,
      -1,    -1,   987,    -1,    -1,  1179,    -1,  1179,  1039,    -1,
     510,  1053,    -1,   510,   501,    -1,   506,   987,   507,    -1,
     506,   987,   513,   987,   507,    -1,  1038,    -1,  1039,  1038,
      -1,    -1,  1040,  1038,    -1,   112,    -1,    -1,   987,    -1,
     180,    -1,  1042,    -1,  1043,   511,  1042,    -1,   508,  1043,
     509,    -1,  1046,    -1,  1045,   511,  1046,    -1,   987,   108,
    1181,    -1,   987,  1201,    -1,   987,    -1,   501,    -1,  1048,
      -1,  1047,   511,  1048,    -1,  1179,    -1,  1179,  1039,    -1,
    1050,    -1,  1049,   511,  1050,    -1,  1179,    -1,  1179,    -1,
    1179,    -1,  1181,    -1,  1179,    -1,  1199,    -1,  1180,    -1,
    1179,  1039,    -1,  1058,    -1,  1198,    -1,  1199,    -1,  1197,
      -1,    84,    -1,  1056,  1199,    -1,  1056,   508,  1017,   509,
    1199,    -1,   966,  1199,    -1,   983,  1199,   985,    -1,   983,
     508,  1058,   509,  1199,   985,    -1,   440,    -1,   217,    -1,
     317,    -1,  1193,    -1,  1191,    -1,    86,    -1,  1061,    -1,
    1058,    -1,  1193,    -1,   499,  1058,    -1,   500,  1058,    -1,
    1201,    -1,  1062,    -1,  1063,    -1,  1064,    -1,    91,    -1,
      92,    -1,    93,    -1,    94,    -1,    95,    -1,    96,    -1,
      97,    -1,    98,    -1,   100,    -1,   101,    -1,   102,    -1,
     110,    -1,   111,    -1,   113,    -1,   114,    -1,   116,    -1,
     117,    -1,   118,    -1,   125,    -1,   126,    -1,   127,    -1,
     128,    -1,   129,    -1,   132,    -1,   133,    -1,   136,    -1,
     138,    -1,   139,    -1,   140,    -1,   141,    -1,   146,    -1,
     147,    -1,   148,    -1,   149,    -1,   151,    -1,   154,    -1,
     155,    -1,   156,    -1,   157,    -1,   158,    -1,   159,    -1,
     162,    -1,   171,    -1,   172,    -1,   173,    -1,   174,    -1,
     176,    -1,   179,    -1,   181,    -1,   183,    -1,   184,    -1,
     185,    -1,   186,    -1,   187,    -1,   189,    -1,   190,    -1,
     191,    -1,   194,    -1,   195,    -1,   196,    -1,   197,    -1,
     198,    -1,   200,    -1,   201,    -1,   202,    -1,   204,    -1,
     205,    -1,   206,    -1,   208,    -1,   209,    -1,   210,    -1,
     211,    -1,   213,    -1,   214,    -1,   215,    -1,   218,    -1,
     220,    -1,   222,    -1,   224,    -1,   226,    -1,   230,    -1,
     231,    -1,   232,    -1,   234,    -1,   237,    -1,   239,    -1,
     240,    -1,   242,    -1,   243,    -1,   245,    -1,   246,    -1,
     247,    -1,   249,    -1,   250,    -1,   251,    -1,   252,    -1,
     253,    -1,   254,    -1,   256,    -1,   260,    -1,   261,    -1,
     262,    -1,   268,    -1,   271,    -1,   273,    -1,   274,    -1,
     275,    -1,   276,    -1,   277,    -1,   279,    -1,   280,    -1,
     282,    -1,   285,    -1,   288,    -1,   289,    -1,   290,    -1,
     293,    -1,   294,    -1,   295,    -1,   296,    -1,   297,    -1,
     298,    -1,   300,    -1,   301,    -1,   303,    -1,   304,    -1,
     305,    -1,   309,    -1,   310,    -1,   313,    -1,   314,    -1,
     316,    -1,   319,    -1,   321,    -1,   322,    -1,   323,    -1,
     325,    -1,   328,    -1,   329,    -1,   330,    -1,   338,    -1,
     339,    -1,   340,    -1,   341,    -1,   342,    -1,   343,    -1,
     344,    -1,   346,    -1,   348,    -1,   351,    -1,   352,    -1,
     350,    -1,   354,    -1,   355,    -1,   356,    -1,   357,    -1,
     358,    -1,   359,    -1,   360,    -1,   361,    -1,   363,    -1,
     364,    -1,   365,    -1,   366,    -1,   368,    -1,   369,    -1,
     370,    -1,   371,    -1,   372,    -1,   373,    -1,   374,    -1,
     375,    -1,   376,    -1,   377,    -1,   378,    -1,   380,    -1,
     381,    -1,   383,    -1,   384,    -1,   386,    -1,   387,    -1,
     388,    -1,   389,    -1,   390,    -1,   391,    -1,   393,    -1,
     395,    -1,   396,    -1,   397,    -1,   398,    -1,   399,    -1,
     401,    -1,   403,    -1,   404,    -1,   406,    -1,   408,    -1,
     410,    -1,   411,    -1,   412,    -1,   413,    -1,   414,    -1,
     415,    -1,   416,    -1,   417,    -1,   418,    -1,   419,    -1,
     422,    -1,   423,    -1,   425,    -1,   426,    -1,   427,    -1,
     428,    -1,   429,    -1,   430,    -1,   436,    -1,   438,    -1,
     441,    -1,   442,    -1,   443,    -1,   444,    -1,   445,    -1,
     446,    -1,   447,    -1,   450,    -1,   451,    -1,   452,    -1,
     453,    -1,   454,    -1,   457,    -1,   458,    -1,   459,    -1,
     460,    -1,   461,    -1,   465,    -1,   467,    -1,   468,    -1,
     469,    -1,   472,    -1,   475,    -1,   476,    -1,   477,    -1,
     478,    -1,   479,    -1,   490,    -1,   491,    -1,   119,    -1,
     120,    -1,   122,    -1,   123,    -1,   135,    -1,   142,    -1,
     177,    -1,   178,    -1,   212,    -1,   216,    -1,   221,    -1,
     235,    -1,   258,    -1,   264,    -1,   266,    -1,   283,    -1,
     306,    -1,   308,    -1,   311,    -1,   318,    -1,   320,    -1,
     333,    -1,   337,    -1,   347,    -1,   349,    -1,   362,    -1,
     385,    -1,   402,    -1,   407,    -1,   420,    -1,   432,    -1,
     433,    -1,   437,    -1,   439,    -1,   463,    -1,   480,    -1,
     481,    -1,   482,    -1,   483,    -1,   484,    -1,   485,    -1,
     486,    -1,   487,    -1,   488,    -1,   115,    -1,   121,    -1,
     144,    -1,   150,    -1,   161,    -1,   167,    -1,   227,    -1,
     229,    -1,   244,    -1,   257,    -1,   269,    -1,   270,    -1,
     272,    -1,   284,    -1,   286,    -1,   307,    -1,   315,    -1,
     334,    -1,   335,    -1,   336,    -1,   382,    -1,   405,    -1,
     466,    -1,    99,    -1,   103,    -1,   104,    -1,   105,    -1,
     106,    -1,   107,    -1,   108,    -1,   109,    -1,   112,    -1,
     124,    -1,   130,    -1,   131,    -1,   137,    -1,   143,    -1,
     145,    -1,   153,    -1,   160,    -1,   164,    -1,   165,    -1,
     166,    -1,   168,    -1,   169,    -1,   170,    -1,   180,    -1,
     182,    -1,   188,    -1,   192,    -1,   193,    -1,   199,    -1,
     203,    -1,   207,    -1,   217,    -1,   219,    -1,   223,    -1,
     225,    -1,   228,    -1,   233,    -1,   236,    -1,   238,    -1,
     248,    -1,   255,    -1,   265,    -1,   267,    -1,   278,    -1,
     281,    -1,   287,    -1,   291,    -1,   292,    -1,   312,    -1,
     317,    -1,   324,    -1,   326,    -1,   327,    -1,   331,    -1,
     332,    -1,   345,    -1,   353,    -1,   367,    -1,   379,    -1,
     394,    -1,   400,    -1,   409,    -1,   421,    -1,   424,    -1,
     431,    -1,   435,    -1,   440,    -1,   449,    -1,   455,    -1,
     456,    -1,   464,    -1,   470,    -1,   471,    -1,   473,    -1,
     474,    -1,    -1,  1066,  1067,    -1,  1188,  1070,   518,   512,
      -1,  1188,   518,   512,    -1,  1188,  1090,    -1,  1095,    -1,
    1207,    -1,    73,    -1,   514,    -1,   515,    -1,    -1,   160,
     593,   424,   629,   108,  1069,   907,   630,    -1,   113,  1131,
      -1,     9,   434,  1072,  1079,  1080,    -1,     9,   434,   180,
      -1,     9,  1081,    -1,   174,  1072,    -1,  1073,  1076,  1078,
      -1,  1074,   513,  1075,  1078,   502,  1073,  1084,    -1,  1083,
      -1,  1199,    -1,  1051,    -1,    -1,  1201,  1195,    -1,    85,
    1077,    -1,  1075,    -1,    -1,  1179,    -1,  1179,   510,  1077,
      -1,    74,    -1,   513,  1058,    -1,    -1,   108,  1131,    -1,
      -1,   455,  1081,    -1,    -1,  1082,    -1,  1082,   502,  1082,
      -1,  1082,    21,   125,  1082,    -1,  1082,   456,  1082,    -1,
    1059,    -1,  1199,    -1,  1193,    -1,  1195,    -1,    85,  1085,
      -1,    -1,  1179,  1086,    -1,  1179,  1086,    85,  1085,    -1,
      -1,   495,  1058,    -1,   495,  1201,    -1,   495,  1193,    -1,
    1050,    -1,  1083,    -1,   179,   904,   905,   171,   906,   223,
    1087,    -1,   211,   245,  1132,    -1,  1091,    -1,  1102,    -1,
    1104,    -1,   641,    -1,   511,   641,    -1,    -1,   985,    -1,
     489,   434,   299,    -1,   489,   434,   392,    -1,   175,   434,
     175,    -1,   302,   434,   302,    -1,    -1,  1097,  1096,  1099,
    1098,    -1,  1188,   118,   179,    34,   512,    -1,  1188,   203,
     179,    34,   512,    -1,    -1,  1100,    -1,  1091,    -1,    73,
      -1,  1100,  1091,    -1,  1100,    73,    -1,  1104,    -1,  1101,
    1104,    -1,    -1,    70,  1103,  1111,  1127,  1183,   964,   512,
      -1,    -1,  1108,  1111,  1105,  1124,   512,    -1,    -1,  1111,
    1106,  1124,   512,    -1,  1114,   512,    -1,   513,  1058,    -1,
      -1,  1109,  1110,    -1,  1109,    -1,  1110,    -1,    56,    -1,
      67,    -1,    65,    -1,    50,    -1,    51,    -1,    69,    -1,
    1120,    -1,  1116,    -1,  1112,    -1,  1183,   508,  1092,  1093,
     509,    -1,  1183,  1094,    -1,  1118,    -1,   204,  1177,  1113,
      -1,   204,  1113,    -1,   204,  1177,    -1,   514,  1205,   515,
      -1,    -1,  1118,  1115,   514,  1101,   515,    -1,  1114,    -1,
      -1,  1119,  1117,   514,  1101,   515,    -1,    43,  1177,    -1,
     448,  1177,    -1,    43,    -1,   448,    -1,  1121,    -1,  1123,
    1122,    -1,    44,    35,    -1,    44,    35,   263,    -1,    44,
      -1,    44,   263,    -1,    44,    25,    -1,    44,    25,   263,
      -1,    44,    25,    25,    -1,    44,    25,    25,   263,    -1,
      44,   134,    -1,    35,    -1,    35,   263,    -1,   263,    -1,
      25,    -1,    25,   263,    -1,    25,    25,    -1,    25,    25,
     263,    -1,     5,    -1,   134,    -1,   196,    -1,    36,    -1,
      -1,  1125,    -1,  1124,   511,  1125,    -1,  1127,  1182,   964,
    1107,  1126,    -1,    -1,   495,  1206,    -1,    -1,   501,    -1,
     501,   501,    -1,   179,   413,  1201,    -1,    15,  1130,    -1,
    1131,    -1,   163,    -1,    99,    -1,    -1,  1051,    -1,   180,
      -1,  1083,    -1,  1083,    -1,    71,    -1,    17,   904,    -1,
      17,    99,    -1,    28,   904,  1135,    -1,    -1,  1136,    -1,
     456,  1140,    -1,  1137,    -1,   456,    37,    14,  1202,    -1,
     456,    14,  1050,    -1,   267,    37,    14,  1202,    -1,   267,
      14,  1050,    -1,   267,  1050,    -1,  1141,    -1,  1141,   511,
    1140,    -1,  1142,    -1,  1193,    -1,  1191,    -1,  1058,    -1,
     499,  1058,    -1,   500,  1058,    -1,  1198,    -1,   499,  1198,
      -1,   500,  1198,    -1,  1199,    -1,  1197,    -1,  1200,    -1,
      13,   259,  1087,  1137,    -1,    13,  1144,  1087,  1137,    -1,
      13,  1144,  1087,  1138,    -1,    13,   259,  1087,  1139,    -1,
      13,  1144,  1087,  1139,    -1,    29,    -1,    -1,     3,    14,
    1202,    -1,   176,    14,  1202,    -1,    18,    14,  1202,  1148,
      -1,  1149,    -1,  1148,   511,  1149,    -1,  1195,   495,  1154,
      -1,   401,    14,  1202,  1151,    -1,  1152,    -1,  1151,   511,
    1152,    -1,  1154,   495,  1153,    -1,  1058,    -1,  1195,    -1,
      10,    -1,    18,    14,  1202,   461,  1153,  1156,    -1,  1157,
      -1,  1156,   511,  1157,    -1,  1195,   495,  1162,    -1,   401,
      14,  1202,   461,  1153,  1159,    -1,  1160,    -1,  1159,   511,
    1160,    -1,  1162,   495,  1161,    -1,  1198,    -1,  1153,    -1,
     500,  1198,    -1,   500,  1058,    -1,  1199,    -1,     8,    -1,
     173,    -1,    11,    -1,    12,    -1,    22,    -1,    23,    -1,
      24,    -1,   304,    -1,    26,    -1,    27,    -1,   349,    -1,
      31,    -1,    32,    -1,    33,    -1,   443,    -1,   401,     4,
     495,  1164,    -1,   401,     4,   434,  1164,    -1,   326,    -1,
     323,    -1,   401,   152,   434,  1131,    -1,   401,   152,   495,
    1131,    -1,   401,   152,  1131,    -1,    -1,   443,  1167,  1183,
     269,  1111,   964,  1168,    -1,    30,    -1,    -1,    -1,    45,
    1170,  1181,   269,  1111,   964,  1168,    -1,    46,    38,  1172,
      -1,    46,   312,    16,  1172,    -1,    46,    40,  1172,    -1,
     156,    -1,    39,    -1,    42,    -1,    20,  1050,    -1,    19,
     434,  1050,    -1,   193,  1050,   508,  1189,   509,    -1,   193,
       6,    -1,     7,  1050,   508,  1189,   509,    -1,     7,  1050,
      -1,  1174,    -1,  1175,    -1,     6,    -1,     7,    -1,     8,
      -1,    10,    -1,    11,    -1,    12,    -1,    16,    -1,    19,
      -1,    20,    -1,    21,    -1,    22,    -1,    23,    -1,    24,
      -1,    26,    -1,    27,    -1,    31,    -1,    32,    -1,    33,
      -1,    34,    -1,    37,    -1,    38,    -1,    39,    -1,    40,
      -1,    42,    -1,     9,    -1,    13,    -1,    15,    -1,    28,
      -1,    45,    -1,    46,    -1,     5,    -1,    25,    -1,    29,
      -1,    35,    -1,    43,    -1,    36,    -1,    44,    -1,  1181,
      -1,  1201,    -1,  1062,    -1,  1063,    -1,  1186,    -1,  1173,
      -1,  1184,    -1,   134,    -1,   462,    -1,  1201,    -1,  1185,
      -1,  1063,    -1,  1173,    -1,  1184,    -1,   134,    -1,   462,
      -1,  1201,    -1,  1185,    -1,  1064,    -1,  1173,    -1,  1184,
      -1,  1176,    -1,  1182,    -1,  1176,    -1,   134,    -1,   163,
      -1,   259,    -1,   263,    -1,   434,    -1,   448,    -1,   462,
      -1,  1184,    -1,  1186,    -1,  1183,    -1,  1062,    -1,  1065,
      -1,  1175,    -1,   152,    -1,  1201,    -1,  1063,    -1,  1064,
      -1,  1174,    -1,    50,    -1,    51,    -1,    56,    -1,    65,
      -1,    67,    -1,    70,    -1,    69,    -1,  1062,    -1,  1186,
      -1,   152,    -1,   175,    -1,   241,    -1,   299,    -1,   302,
      -1,   392,    -1,   489,    -1,  1190,    -1,  1187,   511,  1190,
      -1,    41,    -1,    -1,  1205,    -1,  1195,  1194,    -1,  1195,
      -1,  1195,  1194,    -1,  1083,    -1,  1195,    -1,  1195,    -1,
      22,  1195,    -1,    22,  1050,    -1,    72,    -1,    87,    -1,
      83,    -1,    81,    -1,    82,    -1,    76,    -1,    77,    -1,
      78,    -1,    75,    -1,    84,    -1,    80,    -1,    71,    -1,
      79,    -1,  1050,    -1,  1083,    -1,  1208,    -1,   508,   509,
      -1,   508,  1204,   509,    -1,  1203,    -1,  1204,  1203,    -1,
    1206,    -1,  1205,   511,  1206,    -1,  1204,    -1,   514,  1205,
     515,    -1,  1208,    -1,   508,    -1,   509,    -1,   511,    -1,
     512,    -1,  1201,    -1,  1058,    -1,  1198,    -1,  1199,    -1,
     501,    -1,   499,    -1,   500,    -1,   502,    -1,   503,    -1,
     317,    -1,    47,    -1,    48,    -1,    49,    -1,    50,    -1,
      51,    -1,    52,    -1,    53,    -1,    54,    -1,    55,    -1,
      56,    -1,    57,    -1,    58,    -1,    60,    -1,    59,    -1,
      61,    -1,    62,    -1,    63,    -1,    64,    -1,    65,    -1,
      66,    -1,    67,    -1,    68,    -1,    70,    -1,    69,    -1,
       5,    -1,   204,    -1,   241,    -1,   263,    -1,    25,    -1,
     299,    -1,   302,    -1,   392,    -1,    35,    -1,    36,    -1,
      43,    -1,    44,    -1,   489,    -1,   134,    -1,   221,    -1,
     434,    -1,   448,    -1,   463,    -1,   506,    -1,   507,    -1,
     495,    -1,   513,    -1,   176,  1087,    -1,   176,   351,  1087,
      -1,   176,    99,    -1,   176,   351,    99,    -1,  1058,    -1,
     508,  1210,   509,    -1,  1210,   499,  1210,    -1,  1210,   500,
    1210,    -1,  1210,   501,  1210,    -1,  1210,   502,  1210,    -1,
    1210,   503,  1210,    -1,  1199,    -1,  1179,    -1,    -1,  1136,
    1212,    -1,  1212,  1136,    -1,  1136,    -1,  1212,    -1,   267,
    1187,    -1,  1138,    -1,  1212,    -1,  1137,    -1,    -1,  1213,
      -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1477,  1477,  1480,  1482,  1484,  1486,  1488,  1490,  1492,
    1494,  1496,  1498,  1500,  1502,  1504,  1506,  1508,  1510,  1512,
    1514,  1516,  1518,  1520,  1522,  1524,  1526,  1528,  1530,  1532,
    1534,  1552,  1554,  1556,  1558,  1560,  1562,  1564,  1566,  1568,
    1570,  1572,  1574,  1576,  1578,  1580,  1582,  1584,  1586,  1588,
    1590,  1592,  1594,  1596,  1598,  1600,  1602,  1604,  1606,  1608,
    1610,  1612,  1616,  1618,  1620,  1622,  1624,  1626,  1628,  1630,
    1632,  1634,  1636,  1638,  1640,  1642,  1644,  1646,  1648,  1650,
    1652,  1654,  1656,  1658,  1660,  1662,  1664,  1666,  1668,  1670,
    1672,  1674,  1676,  1678,  1680,  1682,  1684,  1691,  1693,  1695,
    1697,  1699,  1701,  1703,  1705,  1707,  1709,  1711,  1713,  1719,
    1721,  1723,  1725,  1727,  1729,  1731,  1733,  1735,  1741,  1751,
    1755,  1761,  1765,  1775,  1785,  1786,  1800,  1807,  1813,  1824,
    1830,  1839,  1846,  1852,  1861,  1868,  1876,  1881,  1889,  1894,
    1900,  1905,  1911,  1916,  1922,  1926,  1930,  1934,  1938,  1942,
    1946,  1950,  1954,  1962,  1966,  1970,  1974,  1978,  1982,  1990,
    1998,  2007,  2009,  2017,  2021,  2029,  2037,  2045,  2049,  2057,
    2061,  2069,  2077,  2085,  2089,  2097,  2101,  2109,  2113,  2117,
    2122,  2131,  2136,  2142,  2147,  2153,  2157,  2161,  2165,  2169,
    2173,  2181,  2185,  2189,  2197,  2201,  2205,  2213,  2217,  2221,
    2225,  2229,  2233,  2237,  2242,  2246,  2250,  2254,  2258,  2262,
    2266,  2274,  2278,  2286,  2290,  2298,  2302,  2316,  2320,  2324,
    2328,  2336,  2340,  2344,  2348,  2356,  2360,  2364,  2368,  2372,
    2376,  2380,  2388,  2392,  2397,  2403,  2407,  2415,  2419,  2423,
    2427,  2431,  2439,  2443,  2451,  2455,  2463,  2467,  2471,  2475,
    2479,  2488,  2496,  2500,  2508,  2512,  2520,  2528,  2532,  2536,
    2540,  2548,  2552,  2556,  2560,  2564,  2568,  2572,  2576,  2580,
    2584,  2592,  2596,  2604,  2608,  2612,  2616,  2620,  2624,  2628,
    2632,  2636,  2640,  2644,  2648,  2652,  2656,  2660,  2664,  2668,
    2672,  2676,  2680,  2684,  2688,  2692,  2696,  2700,  2704,  2708,
    2712,  2716,  2720,  2724,  2728,  2732,  2736,  2740,  2744,  2748,
    2752,  2756,  2760,  2764,  2768,  2776,  2780,  2788,  2792,  2797,
    2803,  2808,  2814,  2819,  2825,  2833,  2838,  2844,  2848,  2856,
    2860,  2864,  2868,  2876,  2884,  2888,  2896,  2900,  2904,  2908,
    2916,  2921,  2929,  2937,  2945,  2949,  2957,  2962,  2968,  2972,
    2976,  2984,  2988,  2996,  3001,  3007,  3011,  3015,  3019,  3023,
    3027,  3031,  3035,  3039,  3043,  3047,  3051,  3055,  3063,  3068,
    3074,  3079,  3085,  3090,  3096,  3101,  3107,  3111,  3119,  3127,
    3131,  3135,  3139,  3144,  3150,  3154,  3162,  3170,  3174,  3178,
    3182,  3190,  3194,  3198,  3202,  3206,  3210,  3214,  3219,  3225,
    3230,  3236,  3241,  3247,  3251,  3259,  3263,  3271,  3275,  3279,
    3287,  3291,  3299,  3307,  3315,  3320,  3326,  3330,  3334,  3338,
    3346,  3350,  3354,  3358,  3362,  3366,  3370,  3378,  3382,  3386,
    3390,  3398,  3406,  3410,  3415,  3421,  3425,  3429,  3433,  3437,
    3441,  3449,  3453,  3461,  3465,  3469,  3473,  3477,  3481,  3485,
    3493,  3498,  3504,  3509,  3515,  3519,  3527,  3535,  3539,  3544,
    3549,  3555,  3559,  3567,  3571,  3579,  3584,  3590,  3594,  3598,
    3602,  3607,  3613,  3621,  3629,  3633,  3637,  3641,  3645,  3653,
    3658,  3664,  3668,  3672,  3677,  3683,  3687,  3691,  3696,  3702,
    3707,  3713,  3718,  3724,  3732,  3740,  3744,  3749,  3755,  3763,
    3771,  3776,  3782,  3790,  3798,  3802,  3810,  3815,  3821,  3825,
    3833,  3837,  3841,  3845,  3849,  3853,  3857,  3861,  3865,  3869,
    3873,  3877,  3885,  3890,  3896,  3900,  3904,  3912,  3916,  3924,
    3928,  3936,  3941,  3947,  3951,  3959,  3964,  3970,  3974,  3982,
    3987,  3993,  3997,  4005,  4010,  4016,  4024,  4029,  4035,  4039,
    4047,  4051,  4059,  4064,  4070,  4074,  4078,  4086,  4094,  4099,
    4105,  4113,  4117,  4121,  4125,  4129,  4133,  4137,  4141,  4145,
    4149,  4153,  4157,  4161,  4165,  4169,  4173,  4177,  4181,  4185,
    4189,  4193,  4197,  4201,  4205,  4213,  4221,  4225,  4229,  4233,
    4241,  4245,  4253,  4258,  4264,  4268,  4276,  4280,  4288,  4293,
    4299,  4303,  4311,  4319,  4323,  4331,  4335,  4339,  4343,  4351,
    4359,  4367,  4375,  4383,  4388,  4394,  4398,  4406,  4411,  4417,
    4421,  4429,  4433,  4437,  4445,  4449,  4457,  4461,  4469,  4477,
    4481,  4485,  4493,  4497,  4505,  4513,  4517,  4525,  4529,  4533,
    4541,  4545,  4553,  4557,  4561,  4565,  4569,  4577,  4582,  4588,
    4593,  4599,  4603,  4611,  4616,  4622,  4626,  4631,  4637,  4641,
    4645,  4649,  4657,  4662,  4669,  4671,  4679,  4683,  4687,  4691,
    4695,  4699,  4707,  4711,  4719,  4723,  4731,  4735,  4743,  4751,
    4755,  4763,  4771,  4775,  4779,  4783,  4791,  4800,  4809,  4813,
    4817,  4821,  4825,  4829,  4833,  4837,  4841,  4845,  4849,  4853,
    4857,  4861,  4869,  4877,  4881,  4889,  4893,  4901,  4905,  4909,
    4913,  4917,  4925,  4929,  4937,  4945,  4949,  4957,  4965,  4970,
    4976,  4980,  4988,  4992,  4996,  5004,  5009,  5015,  5023,  5027,
    5035,  5039,  5043,  5047,  5051,  5059,  5064,  5070,  5075,  5081,
    5085,  5090,  5096,  5102,  5108,  5116,  5120,  5128,  5132,  5140,
    5144,  5152,  5156,  5164,  5168,  5176,  5184,  5192,  5196,  5200,
    5204,  5212,  5216,  5220,  5224,  5228,  5232,  5236,  5240,  5244,
    5248,  5252,  5256,  5260,  5264,  5268,  5272,  5276,  5284,  5288,
    5296,  5300,  5308,  5312,  5320,  5328,  5332,  5337,  5343,  5347,
    5351,  5355,  5359,  5363,  5367,  5371,  5375,  5379,  5383,  5387,
    5391,  5399,  5403,  5407,  5411,  5415,  5419,  5423,  5427,  5431,
    5435,  5439,  5443,  5447,  5451,  5455,  5459,  5463,  5467,  5471,
    5475,  5479,  5483,  5487,  5495,  5499,  5507,  5511,  5515,  5519,
    5523,  5531,  5536,  5542,  5546,  5550,  5554,  5558,  5562,  5566,
    5570,  5574,  5578,  5582,  5586,  5590,  5598,  5602,  5610,  5614,
    5618,  5622,  5628,  5634,  5640,  5646,  5652,  5658,  5664,  5674,
    5685,  5696,  5707,  5718,  5729,  5740,  5756,  5772,  5788,  5799,
    5815,  5826,  5842,  5857,  5861,  5869,  5874,  5880,  5888,  5892,
    5900,  5904,  5908,  5912,  5916,  5924,  5928,  5936,  5940,  5944,
    5948,  5956,  5960,  5964,  5968,  5972,  5976,  5980,  5984,  5988,
    5992,  5996,  6000,  6004,  6008,  6012,  6016,  6024,  6028,  6036,
    6040,  6048,  6053,  6059,  6063,  6071,  6079,  6087,  6091,  6099,
    6104,  6110,  6115,  6121,  6129,  6134,  6140,  6144,  6148,  6156,
    6160,  6164,  6172,  6176,  6180,  6184,  6192,  6200,  6205,  6211,
    6216,  6222,  6227,  6233,  6238,  6244,  6248,  6256,  6260,  6264,
    6272,  6277,  6283,  6287,  6292,  6298,  6302,  6307,  6313,  6317,
    6322,  6328,  6332,  6336,  6344,  6349,  6355,  6359,  6367,  6371,
    6379,  6383,  6391,  6395,  6403,  6407,  6411,  6415,  6419,  6427,
    6431,  6435,  6439,  6443,  6451,  6459,  6467,  6471,  6475,  6483,
    6487,  6491,  6499,  6503,  6511,  6515,  6519,  6523,  6527,  6531,
    6535,  6539,  6543,  6547,  6551,  6555,  6559,  6563,  6567,  6575,
    6579,  6583,  6587,  6595,  6599,  6607,  6612,  6618,  6626,  6630,
    6638,  6646,  6650,  6658,  6663,  6669,  6673,  6681,  6685,  6693,
    6697,  6705,  6709,  6713,  6717,  6725,  6729,  6737,  6745,  6749,
    6757,  6761,  6769,  6773,  6777,  6785,  6789,  6794,  6800,  6808,
    6813,  6819,  6823,  6827,  6835,  6839,  6847,  6852,  6858,  6862,
    6866,  6870,  6874,  6878,  6882,  6886,  6890,  6894,  6898,  6902,
    6906,  6910,  6914,  6918,  6922,  6926,  6930,  6934,  6938,  6942,
    6946,  6950,  6954,  6958,  6962,  6966,  6970,  6974,  6978,  6982,
    6986,  6990,  6994,  6998,  7002,  7006,  7010,  7014,  7018,  7022,
    7026,  7030,  7034,  7038,  7042,  7050,  7055,  7061,  7066,  7072,
    7076,  7080,  7084,  7088,  7092,  7096,  7100,  7104,  7108,  7112,
    7116,  7120,  7124,  7128,  7132,  7136,  7140,  7144,  7148,  7152,
    7156,  7160,  7164,  7172,  7176,  7180,  7184,  7188,  7192,  7196,
    7200,  7204,  7208,  7212,  7216,  7220,  7224,  7228,  7232,  7236,
    7240,  7244,  7252,  7260,  7264,  7268,  7276,  7280,  7288,  7292,
    7296,  7300,  7304,  7312,  7317,  7323,  7327,  7331,  7335,  7343,
    7347,  7352,  7358,  7362,  7370,  7378,  7383,  7389,  7397,  7401,
    7409,  7413,  7417,  7421,  7425,  7429,  7433,  7437,  7441,  7445,
    7449,  7453,  7457,  7461,  7469,  7473,  7478,  7484,  7488,  7492,
    7496,  7500,  7508,  7512,  7516,  7524,  7529,  7535,  7539,  7543,
    7547,  7555,  7560,  7565,  7571,  7577,  7585,  7593,  7598,  7604,
    7608,  7612,  7616,  7620,  7624,  7628,  7632,  7636,  7640,  7644,
    7648,  7652,  7656,  7660,  7664,  7672,  7677,  7683,  7687,  7695,
    7703,  7708,  7714,  7722,  7726,  7734,  7742,  7746,  7750,  7754,
    7758,  7762,  7766,  7774,  7779,  7785,  7793,  7797,  7801,  7805,
    7809,  7813,  7821,  7829,  7833,  7837,  7845,  7850,  7856,  7860,
    7864,  7868,  7872,  7880,  7884,  7892,  7896,  7900,  7904,  7912,
    7916,  7924,  7928,  7936,  7941,  7947,  7952,  7958,  7963,  7969,
    7974,  7980,  7984,  7988,  7992,  8000,  8004,  8008,  8012,  8016,
    8020,  8024,  8028,  8032,  8040,  8044,  8052,  8060,  8064,  8072,
    8076,  8081,  8087,  8093,  8103,  8108,  8114,  8118,  8122,  8126,
    8134,  8136,  8144,  8149,  8155,  8163,  8167,  8171,  8179,  8183,
    8191,  8199,  8204,  8210,  8218,  8223,  8229,  8237,  8242,  8248,
    8252,  8256,  8260,  8264,  8268,  8272,  8276,  8284,  8289,  8295,
    8303,  8307,  8315,  8319,  8327,  8335,  8343,  8351,  8355,  8363,
    8416,  8420,  8433,  8435,  8439,  8443,  8447,  8456,  8462,  8466,
    8474,  8478,  8486,  8490,  8498,  8502,  8506,  8510,  8514,  8518,
    8522,  8526,  8534,  8538,  8546,  8550,  8554,  8558,  8562,  8566,
    8574,  8578,  8586,  8590,  8598,  8606,  8611,  8617,  8622,  8624,
    8630,  8634,  8638,  8642,  8646,  8650,  8654,  8658,  8662,  8670,
    8675,  8681,  8685,  8690,  8696,  8700,  8704,  8709,  8715,  8720,
    8726,  8734,  8738,  8746,  8750,  8758,  8762,  8766,  8770,  8778,
    8783,  8789,  8793,  8798,  8806,  8810,  8818,  8822,  8830,  8838,
    8842,  8847,  8853,  8861,  8865,  8873,  8877,  8885,  8890,  8896,
    8901,  8907,  8911,  8919,  8924,  8930,  8934,  8942,  8950,  8954,
    8958,  8962,  8970,  8975,  8981,  8985,  8993,  8998,  9004,  9008,
    9016,  9020,  9024,  9028,  9035,  9042,  9046,  9054,  9058,  9062,
    9066,  9070,  9074,  9082,  9086,  9090,  9094,  9102,  9107,  9113,
    9117,  9121,  9125,  9130,  9136,  9140,  9144,  9148,  9156,  9161,
    9167,  9171,  9179,  9183,  9187,  9191,  9199,  9203,  9211,  9215,
    9219,  9227,  9235,  9240,  9246,  9250,  9256,  9262,  9267,  9273,
    9277,  9285,  9293,  9295,  9297,  9301,  9305,  9309,  9317,  9327,
    9338,  9347,  9351,  9355,  9359,  9363,  9367,  9371,  9379,  9383,
    9387,  9391,  9399,  9403,  9411,  9416,  9422,  9426,  9430,  9434,
    9438,  9442,  9446,  9450,  9454,  9458,  9462,  9470,  9475,  9481,
    9485,  9493,  9497,  9505,  9513,  9521,  9525,  9533,  9537,  9545,
    9553,  9561,  9565,  9569,  9573,  9577,  9581,  9589,  9594,  9600,
    9605,  9611,  9615,  9619,  9623,  9631,  9639,  9643,  9648,  9654,
    9658,  9662,  9666,  9670,  9674,  9678,  9682,  9686,  9690,  9694,
    9698,  9702,  9707,  9713,  9717,  9725,  9729,  9733,  9737,  9741,
    9745,  9749,  9753,  9757,  9761,  9765,  9769,  9773,  9777,  9781,
    9785,  9789,  9793,  9797,  9801,  9805,  9809,  9813,  9817,  9821,
    9825,  9829,  9833,  9837,  9841,  9845,  9849,  9853,  9857,  9861,
    9865,  9869,  9873,  9877,  9881,  9885,  9889,  9893,  9897,  9901,
    9905,  9909,  9913,  9917,  9921,  9925,  9929,  9933,  9937,  9941,
    9945,  9949,  9954,  9958,  9966,  9970,  9974,  9978,  9982,  9986,
    9990,  9994,  9998, 10002, 10006, 10010, 10014, 10018, 10022, 10026,
   10030, 10034, 10038, 10042, 10046, 10050, 10058, 10062, 10066, 10070,
   10074, 10078, 10082, 10086, 10090, 10094, 10098, 10102, 10110, 10114,
   10118, 10122, 10126, 10130, 10134, 10138, 10142, 10146, 10150, 10154,
   10158, 10162, 10166, 10170, 10174, 10178, 10182, 10186, 10190, 10194,
   10198, 10202, 10206, 10210, 10214, 10218, 10222, 10226, 10230, 10234,
   10238, 10242, 10246, 10250, 10254, 10258, 10262, 10266, 10270, 10274,
   10278, 10282, 10286, 10290, 10294, 10298, 10302, 10306, 10314, 10318,
   10326, 10330, 10334, 10339, 10345, 10353, 10357, 10365, 10369, 10377,
   10381, 10389, 10393, 10398, 10404, 10408, 10412, 10416, 10424, 10429,
   10435, 10439, 10447, 10455, 10459, 10464, 10470, 10478, 10482, 10489,
   10494, 10500, 10505, 10510, 10516, 10520, 10528, 10532, 10536, 10540,
   10544, 10552, 10556, 10560, 10568, 10572, 10576, 10584, 10588, 10596,
   10600, 10604, 10608, 10612, 10616, 10620, 10624, 10628, 10636, 10640,
   10648, 10652, 10660, 10664, 10668, 10672, 10676, 10680, 10688, 10692,
   10700, 10704, 10712, 10716, 10724, 10728, 10736, 10740, 10744, 10752,
   10756, 10764, 10769, 10775, 10779, 10783, 10787, 10791, 10795, 10799,
   10803, 10811, 10815, 10823, 10831, 10836, 10842, 10846, 10850, 10854,
   10858, 10863, 10869, 10877, 10885, 10889, 10893, 10901, 10905, 10913,
   10921, 10925, 10933, 10941, 10946, 10952, 10957, 10963, 10967, 10975,
   10979, 10983, 10987, 10995, 10999, 11008, 11010, 11018, 11023, 11029,
   11033, 11041, 11045, 11053, 11061, 11065, 11073, 11077, 11081, 11085,
   11093, 11097, 11105, 11109, 11117, 11121, 11129, 11137, 11145, 11153,
   11161, 11169, 11177, 11181, 11189, 11193, 11197, 11201, 11205, 11209,
   11213, 11217, 11221, 11225, 11229, 11233, 11237, 11241, 11242, 11247,
   11253, 11261, 11265, 11266, 11270, 11278, 11282, 11286, 11290, 11298,
   11302, 11306, 11310, 11314, 11318, 11322, 11326, 11330, 11334, 11338,
   11342, 11346, 11350, 11354, 11358, 11362, 11366, 11370, 11374, 11378,
   11382, 11386, 11390, 11394, 11398, 11402, 11406, 11410, 11414, 11418,
   11422, 11426, 11430, 11434, 11438, 11442, 11446, 11450, 11454, 11458,
   11462, 11466, 11470, 11474, 11478, 11482, 11486, 11490, 11494, 11498,
   11502, 11506, 11510, 11514, 11518, 11522, 11526, 11530, 11534, 11538,
   11542, 11546, 11550, 11554, 11558, 11562, 11566, 11570, 11574, 11578,
   11582, 11586, 11590, 11594, 11598, 11602, 11606, 11610, 11614, 11618,
   11622, 11626, 11630, 11634, 11638, 11642, 11646, 11650, 11654, 11658,
   11662, 11666, 11670, 11674, 11678, 11682, 11686, 11690, 11694, 11698,
   11702, 11706, 11710, 11714, 11718, 11722, 11726, 11730, 11734, 11738,
   11742, 11746, 11750, 11754, 11758, 11762, 11766, 11770, 11774, 11778,
   11782, 11786, 11790, 11794, 11798, 11802, 11806, 11810, 11814, 11818,
   11822, 11826, 11830, 11834, 11838, 11842, 11846, 11850, 11854, 11858,
   11862, 11866, 11870, 11874, 11878, 11882, 11886, 11890, 11894, 11898,
   11902, 11906, 11910, 11914, 11918, 11922, 11926, 11930, 11934, 11938,
   11942, 11946, 11950, 11954, 11958, 11962, 11966, 11970, 11974, 11978,
   11982, 11986, 11990, 11994, 11998, 12002, 12006, 12010, 12014, 12018,
   12022, 12026, 12030, 12034, 12038, 12042, 12046, 12050, 12054, 12058,
   12062, 12066, 12070, 12074, 12078, 12082, 12086, 12090, 12094, 12098,
   12102, 12106, 12110, 12114, 12118, 12122, 12126, 12130, 12134, 12138,
   12142, 12146, 12150, 12154, 12158, 12162, 12166, 12170, 12174, 12178,
   12182, 12186, 12190, 12194, 12198, 12202, 12206, 12210, 12214, 12218,
   12222, 12226, 12230, 12234, 12238, 12242, 12246, 12250, 12254, 12258,
   12262, 12266, 12270, 12274, 12282, 12286, 12290, 12294, 12298, 12302,
   12306, 12310, 12314, 12318, 12322, 12326, 12330, 12334, 12338, 12342,
   12346, 12350, 12354, 12358, 12362, 12366, 12370, 12374, 12378, 12382,
   12386, 12390, 12394, 12398, 12402, 12406, 12410, 12414, 12418, 12422,
   12426, 12430, 12434, 12438, 12442, 12446, 12450, 12454, 12462, 12466,
   12470, 12474, 12478, 12482, 12486, 12490, 12494, 12498, 12502, 12506,
   12510, 12514, 12518, 12522, 12526, 12530, 12534, 12538, 12542, 12546,
   12550, 12558, 12562, 12566, 12570, 12574, 12578, 12582, 12586, 12590,
   12594, 12598, 12602, 12606, 12610, 12614, 12618, 12622, 12626, 12630,
   12634, 12638, 12642, 12646, 12650, 12654, 12658, 12662, 12666, 12670,
   12674, 12678, 12682, 12686, 12690, 12694, 12698, 12702, 12706, 12710,
   12714, 12718, 12722, 12726, 12730, 12734, 12738, 12742, 12746, 12750,
   12754, 12758, 12762, 12766, 12770, 12774, 12778, 12782, 12786, 12790,
   12794, 12798, 12802, 12806, 12810, 12814, 12818, 12822, 12826, 12830,
   12834, 12838, 12842, 12846, 12850, 12854, 12864, 12865, 12868, 12869,
   12870, 12876, 12877, 12878, 12879, 12880, 12893, 12893, 12902, 12917,
   12919, 12922, 12924, 12928, 12940, 12956, 12960, 12971, 12972, 12975,
   12987, 12996, 12997, 13000, 13001, 13002, 13005, 13006, 13009, 13010,
   13013, 13014, 13017, 13019, 13021, 13023, 13027, 13034, 13041, 13057,
   13091, 13101, 13104, 13108, 13121, 13122, 13124, 13126, 13130, 13144,
   13151, 13212, 13221, 13223, 13224, 13227, 13229, 13230, 13233, 13234,
   13235, 13236, 13237, 13244, 13243, 13253, 13255, 13257, 13258, 13261,
   13262, 13263, 13264, 13267, 13268, 13272, 13271, 13288, 13286, 13302,
   13301, 13315, 13321, 13322, 13325, 13327, 13328, 13331, 13332, 13333,
   13334, 13337, 13338, 13341, 13349, 13366, 13374, 13397, 13503, 13537,
   13539, 13541, 13545, 13549, 13548, 13599, 13601, 13600, 13615, 13621,
   13628, 13633, 13639, 13640, 13643, 13644, 13645, 13646, 13647, 13648,
   13649, 13657, 13665, 13668, 13669, 13670, 13671, 13672, 13673, 13681,
   13689, 13690, 13691, 13694, 13695, 13698, 13700, 13709, 13797, 13798,
   13805, 13806, 13807, 13813, 13822, 13825, 13826, 13827, 13828, 13831,
   13832, 13833, 13836, 13838, 13846, 13847, 13853, 13861, 13862, 13865,
   13866, 13869, 13874, 13881, 13886, 13893, 13900, 13900, 13902, 13909,
   13910, 13913, 13914, 13915, 13916, 13917, 13918, 13919, 13920, 13921,
   13927, 13934, 13946, 13952, 13959, 13967, 13968, 13980, 13991, 14002,
   14006, 14007, 14010, 14015, 14019, 14020, 14023, 14029, 14037, 14043,
   14050, 14054, 14055, 14058, 14061, 14065, 14066, 14069, 14075, 14084,
   14089, 14099, 14109, 14121, 14122, 14123, 14124, 14125, 14126, 14127,
   14128, 14129, 14130, 14131, 14132, 14133, 14134, 14135, 14142, 14143,
   14146, 14147, 14154, 14155, 14156, 14163, 14162, 14179, 14180, 14187,
   14186, 14256, 14262, 14268, 14276, 14282, 14288, 14294, 14300, 14306,
   14312, 14318, 14324, 14335, 14336, 14339, 14340, 14341, 14342, 14343,
   14344, 14345, 14346, 14347, 14348, 14349, 14350, 14351, 14352, 14353,
   14354, 14355, 14356, 14357, 14358, 14359, 14360, 14361, 14362, 14365,
   14366, 14367, 14368, 14369, 14370, 14374, 14375, 14376, 14377, 14378,
   14379, 14380, 14383, 14386, 14387, 14388, 14389, 14390, 14391, 14392,
   14393, 14406, 14407, 14408, 14409, 14410, 14411, 14412, 14417, 14418,
   14419, 14420, 14421, 14422, 14428, 14429, 14430, 14431, 14432, 14433,
   14434, 14435, 14436, 14437, 14438, 14441, 14442, 14443, 14444, 14445,
   14448, 14449, 14450, 14451, 14454, 14455, 14456, 14457, 14458, 14459,
   14460, 14477, 14478, 14479, 14482, 14483, 14484, 14485, 14486, 14487,
   14491, 14491, 14494, 14500, 14501, 14504, 14506, 14511, 14521, 14532,
   14539, 14540, 14541, 14544, 14577, 14579, 14581, 14584, 14594, 14604,
   14614, 14615, 14618, 14620, 14621, 14622, 14625, 14627, 14635, 14636,
   14637, 14641, 14642, 14646, 14647, 14650, 14651, 14654, 14655, 14656,
   14657, 14658, 14661, 14662, 14663, 14664, 14665, 14666, 14667, 14668,
   14669, 14670, 14671, 14672, 14673, 14674, 14675, 14676, 14677, 14678,
   14679, 14680, 14681, 14682, 14683, 14684, 14685, 14686, 14687, 14688,
   14689, 14690, 14691, 14692, 14693, 14694, 14695, 14696, 14697, 14698,
   14699, 14700, 14701, 14702, 14703, 14704, 14705, 14706, 14707, 14708,
   14709, 14710, 14711, 14712, 14713, 14714, 14715, 14716, 14719, 14720,
   14721, 14722, 14725, 14726, 14727, 14728, 14729, 14730, 14731, 14732,
   14733, 14736, 14737, 14738, 14739, 14740, 14743, 14744, 14747, 14748,
   14759, 14760
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP",
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST",
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST",
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION",
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS",
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION",
  "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", "AUTHORIZATION",
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT",
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED",
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER",
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER",
  "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT", "COMMENTS",
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION",
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P",
  "COPY", "COST", "CREATE", "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG",
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME",
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P",
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE",
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P",
  "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD",
  "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH",
  "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE",
  "EVENT", "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE",
  "EXISTS", "EXPLAIN", "EXTENSION", "EXTERNAL", "EXTRACT", "FALSE_P",
  "FAMILY", "FETCH", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE",
  "FOREIGN", "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "FUNCTIONS",
  "GLOBAL", "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING",
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE",
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX",
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P",
  "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P",
  "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL",
  "ISOLATION", "JOIN", "KEY", "LABEL", "LANGUAGE", "LARGE_P", "LAST_P",
  "LATERAL_P", "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAKPROOF",
  "LEAST", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL",
  "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "MAPPING", "MATCH",
  "MATERIALIZED", "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", "MONTH_P",
  "MOVE", "NAME_P", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO",
  "NONE", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P",
  "NULLIF", "NULLS_P", "NUMERIC", "OBJECT_P", "OF", "OFF", "OFFSET",
  "OIDS", "ON", "ONLY", "OPERATOR", "OPTION", "OPTIONS", "OR", "ORDER",
  "OUT_P", "OUTER_P", "OVER", "OVERLAPS", "OVERLAY", "OWNED", "OWNER",
  "PARSER", "PARTIAL", "PARTITION", "PASSING", "PASSWORD", "PLACING",
  "PLANS", "POSITION", "PRECEDING", "PRECISION", "PRESERVE", "PREPARE",
  "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE",
  "PROGRAM", "QUOTE", "RANGE", "READ", "REAL", "REASSIGN", "RECHECK",
  "RECURSIVE", "REF", "REFERENCES", "REFRESH", "REINDEX", "RELATIVE_P",
  "RELEASE", "RENAME", "REPEATABLE", "REPLACE", "REPLICA", "RESET",
  "RESTART", "RESTRICT", "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE",
  "ROLLBACK", "ROW", "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL",
  "SEARCH", "SECOND_P", "SECURITY", "SELECT", "SEQUENCE", "SEQUENCES",
  "SERIALIZABLE", "SERVER", "SESSION", "SESSION_USER", "SET", "SETOF",
  "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SNAPSHOT", "SOME",
  "STABLE", "STANDALONE_P", "START", "STATEMENT", "STATISTICS", "STDIN",
  "STDOUT", "STORAGE", "STRICT_P", "STRIP_P", "SUBSTRING", "SYMMETRIC",
  "SYSID", "SYSTEM_P", "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE",
  "TEMPORARY", "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING",
  "TRANSACTION", "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE",
  "TRUSTED", "TYPE_P", "TYPES_P", "UNBOUNDED", "UNCOMMITTED",
  "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNLOGGED",
  "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", "VALIDATE",
  "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", "VARIADIC", "VARYING",
  "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE",
  "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT", "WORK", "WRAPPER", "WRITE",
  "XML_P", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLEXISTS",
  "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P",
  "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_TIME", "'='", "'<'",
  "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS",
  "'['", "']'", "'('", "')'", "'.'", "','", "';'", "':'", "'{'", "'}'",
  "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList",
  "AlterOptRoleList", "AlterOptRoleElem", "CreateOptRoleElem",
  "CreateUserStmt", "AlterRoleStmt", "opt_in_database", "AlterRoleSetStmt",
  "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt",
  "CreateGroupStmt", "AlterGroupStmt", "add_drop", "DropGroupStmt",
  "CreateSchemaStmt", "OptSchemaName", "OptSchemaEltList", "schema_stmt",
  "VariableSetStmt", "set_rest", "set_rest_more", "var_name", "var_list",
  "var_value", "iso_level", "opt_boolean_or_string", "zone_value",
  "opt_encoding", "NonReservedWord_or_Sconst", "VariableResetStmt",
  "SetResetClause", "FunctionSetResetClause", "VariableShowStmt",
  "ConstraintsSetStmt", "constraints_set_list", "constraints_set_mode",
  "CheckPointStmt", "DiscardStmt", "AlterTableStmt", "alter_table_cmds",
  "alter_table_cmd", "alter_column_default", "opt_drop_behavior",
  "opt_collate_clause", "alter_using", "reloptions", "opt_reloptions",
  "reloption_list", "reloption_elem", "AlterCompositeTypeStmt",
  "alter_type_cmds", "alter_type_cmd", "ClosePortalStmt", "CopyStmt",
  "copy_from", "opt_program", "copy_file_name", "copy_options",
  "copy_opt_list", "copy_opt_item", "opt_binary", "opt_oids",
  "copy_delimiter", "opt_using", "copy_generic_opt_list",
  "copy_generic_opt_elem", "copy_generic_opt_arg",
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item",
  "CreateStmt", "OptTemp", "OptTableElementList",
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList",
  "TableElement", "TypedTableElement", "columnDef", "columnOptions",
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr",
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption",
  "TableConstraint", "ConstraintElem", "opt_no_inherit", "opt_column_list",
  "columnList", "columnElem", "key_match", "ExclusionConstraintList",
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions",
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith",
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", "ExistingIndex",
  "create_as_target", "opt_with_data", "CreateMatViewStmt",
  "create_mv_target", "OptNoLog", "RefreshMatViewStmt", "CreateSeqStmt",
  "AlterSeqStmt", "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by",
  "NumericOnly", "NumericOnly_list", "CreatePLangStmt", "opt_trusted",
  "handler_name", "opt_inline_handler", "validator_clause",
  "opt_validator", "DropPLangStmt", "opt_procedural",
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt",
  "CreateExtensionStmt", "create_extension_opt_list",
  "create_extension_opt_item", "AlterExtensionStmt",
  "alter_extension_opt_list", "alter_extension_opt_item",
  "AlterExtensionContentsStmt", "CreateFdwStmt", "fdw_option",
  "fdw_options", "opt_fdw_options", "DropFdwStmt", "AlterFdwStmt",
  "create_generic_options", "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateForeignTableStmt",
  "AlterForeignTableStmt", "CreateUserMappingStmt", "auth_ident",
  "DropUserMappingStmt", "AlterUserMappingStmt", "CreateTrigStmt",
  "TriggerActionTime", "TriggerEvents", "TriggerOneEvent",
  "TriggerForSpec", "TriggerForOptEach", "TriggerForType", "TriggerWhen",
  "TriggerFuncArgs", "TriggerFuncArg", "OptConstrFromTable",
  "ConstraintAttributeSpec", "ConstraintAttributeElem", "DropTrigStmt",
  "CreateEventTrigStmt", "event_trigger_when_list",
  "event_trigger_when_item", "event_trigger_value_list",
  "AlterEventTrigStmt", "enable_trigger", "CreateAssertStmt",
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem",
  "def_arg", "aggr_args", "old_aggr_definition", "old_aggr_list",
  "old_aggr_elem", "opt_enum_val_list", "enum_val_list", "AlterEnumStmt",
  "opt_if_not_exists", "CreateOpClassStmt", "opclass_item_list",
  "opclass_item", "opt_default", "opt_opfamily", "opclass_purpose",
  "opt_recheck", "CreateOpFamilyStmt", "AlterOpFamilyStmt",
  "opclass_drop_list", "opclass_drop", "DropOpClassStmt",
  "DropOpFamilyStmt", "DropOwnedStmt", "ReassignOwnedStmt", "DropStmt",
  "drop_type", "any_name_list", "any_name", "attrs", "TruncateStmt",
  "opt_restart_seqs", "CommentStmt", "comment_type", "comment_text",
  "SecLabelStmt", "opt_provider", "security_label_type", "security_label",
  "FetchStmt", "fetch_args", "from_in", "opt_from_in", "GrantStmt",
  "RevokeStmt", "privileges", "privilege_list", "privilege",
  "privilege_target", "grantee_list", "grantee", "opt_grant_grant_option",
  "function_with_argtypes_list", "function_with_argtypes", "GrantRoleStmt",
  "RevokeRoleStmt", "opt_grant_admin_option", "opt_granted_by",
  "AlterDefaultPrivilegesStmt", "DefACLOptionList", "DefACLOption",
  "DefACLAction", "defacl_privilege_target", "IndexStmt", "opt_unique",
  "opt_concurrently", "opt_index_name", "access_method_clause",
  "index_params", "index_elem", "opt_collate", "opt_class", "opt_asc_desc",
  "opt_nulls_order", "CreateFunctionStmt", "opt_or_replace", "func_args",
  "func_args_list", "func_args_with_defaults",
  "func_args_with_defaults_list", "func_arg", "arg_class", "param_name",
  "func_return", "func_type", "func_arg_with_default",
  "createfunc_opt_list", "common_func_opt_item", "createfunc_opt_item",
  "func_as", "opt_definition", "table_func_column",
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list",
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt",
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list",
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt",
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force",
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt",
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti",
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead",
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt",
  "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "vacuum_option_list",
  "vacuum_option_elem", "AnalyzeStmt", "analyze_keyword", "opt_verbose",
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt",
  "ExplainableStmt", "explain_option_list", "explain_option_elem",
  "explain_option_name", "explain_option_arg", "PrepareStmt",
  "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options",
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens",
  "select_clause", "simple_select", "with_clause", "cte_list",
  "common_table_expr", "opt_with_clause", "into_clause",
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct",
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby",
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause",
  "select_limit_value", "select_offset_value",
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows",
  "first_or_next", "group_clause", "having_clause", "for_locking_clause",
  "opt_for_locking_clause", "for_locking_items", "for_locking_item",
  "for_locking_strength", "locked_rels_list", "values_clause",
  "from_clause", "from_list", "table_ref", "joined_table", "alias_clause",
  "opt_alias_clause", "func_alias_clause", "join_type", "join_outer",
  "join_qual", "relation_expr", "relation_expr_list",
  "relation_expr_opt_alias", "func_table", "where_clause",
  "where_or_current_clause", "OptTableFuncElementList",
  "TableFuncElementList", "TableFuncElement", "Typename",
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType",
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit",
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter",
  "CharacterWithLength", "CharacterWithoutLength", "character",
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval",
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr",
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone",
  "xml_attributes", "xml_attribute_list", "xml_attribute_el",
  "document_or_content", "xml_whitespace_option", "xmlexists_argument",
  "window_clause", "window_definition_list", "window_definition",
  "over_clause", "window_specification", "opt_existing_window_name",
  "opt_partition_clause", "opt_frame_clause", "frame_extent",
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op",
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list",
  "func_arg_expr", "type_list", "array_expr", "array_expr_list",
  "extract_list", "extract_arg", "overlay_list", "overlay_placing",
  "position_list", "substr_list", "substr_from", "substr_for", "trim_list",
  "in_expr", "case_expr", "when_clause_list", "when_clause",
  "case_default", "case_arg", "columnref", "indirection_el", "indirection",
  "opt_indirection", "opt_asymmetric", "ctext_expr", "ctext_expr_list",
  "ctext_row", "target_list", "target_el", "qualified_name_list",
  "qualified_name", "name_list", "name", "database_name", "access_method",
  "attr_name", "index_name", "file_name", "func_name", "AexprConst",
  "Iconst", "RoleId", "SignedIconst", "NonReservedWord",
  "unreserved_keyword", "col_name_keyword", "type_func_name_keyword",
  "reserved_keyword", "statements", "statement", "CreateAsStmt", "$@1",
  "at", "ECPGConnect", "connection_target", "opt_database_name",
  "db_prefix", "server", "opt_server", "server_name", "opt_port",
  "opt_connection_name", "opt_user", "ora_user", "user_name",
  "char_variable", "opt_options", "connect_options", "opt_opt_value",
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt",
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale",
  "ecpg_interval", "ECPGDeclaration", "$@2", "sql_startdeclare",
  "sql_enddeclare", "var_type_declarations", "vt_declarations",
  "variable_declarations", "type_declaration", "$@3", "var_declaration",
  "$@4", "$@5", "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@6", "struct_union_type", "$@7",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@8", "opt_reference", "ECPGVar",
  "$@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param",
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", "ecpg_fetch_into", "opt_ecpg_fetch_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,    61,    60,    62,   750,    43,
      45,    42,    47,    37,    94,   751,    91,    93,    40,    41,
      46,    44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint16 yyr1[] =
{
       0,   516,   517,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   518,   518,   518,
     518,   518,   518,   518,   518,   518,   518,   519,   520,   520,
     521,   521,   522,   522,   523,   523,   523,   523,   523,   523,
     523,   523,   523,   524,   524,   524,   524,   524,   524,   525,
     526,   527,   527,   528,   528,   529,   530,   531,   531,   532,
     532,   533,   534,   535,   535,   536,   536,   537,   537,   537,
     537,   538,   538,   539,   539,   540,   540,   540,   540,   540,
     540,   541,   541,   541,   542,   542,   542,   543,   543,   543,
     543,   543,   543,   543,   543,   543,   543,   543,   543,   543,
     543,   544,   544,   545,   545,   546,   546,   547,   547,   547,
     547,   548,   548,   548,   548,   549,   549,   549,   549,   549,
     549,   549,   550,   550,   550,   551,   551,   552,   552,   552,
     552,   552,   553,   553,   554,   554,   555,   555,   555,   555,
     555,   556,   557,   557,   558,   558,   559,   560,   560,   560,
     560,   561,   561,   561,   561,   561,   561,   561,   561,   561,
     561,   562,   562,   563,   563,   563,   563,   563,   563,   563,
     563,   563,   563,   563,   563,   563,   563,   563,   563,   563,
     563,   563,   563,   563,   563,   563,   563,   563,   563,   563,
     563,   563,   563,   563,   563,   563,   563,   563,   563,   563,
     563,   563,   563,   563,   563,   564,   564,   565,   565,   565,
     566,   566,   567,   567,   568,   569,   569,   570,   570,   571,
     571,   571,   571,   572,   573,   573,   574,   574,   574,   574,
     575,   575,   576,   576,   577,   577,   578,   578,   579,   579,
     579,   580,   580,   581,   581,   582,   582,   582,   582,   582,
     582,   582,   582,   582,   582,   582,   582,   582,   583,   583,
     584,   584,   585,   585,   586,   586,   587,   587,   588,   589,
     589,   589,   589,   589,   590,   590,   591,   592,   592,   592,
     592,   593,   593,   593,   593,   593,   593,   593,   593,   594,
     594,   595,   595,   596,   596,   597,   597,   598,   598,   598,
     599,   599,   600,   601,   602,   602,   603,   603,   603,   603,
     604,   604,   604,   604,   604,   604,   604,   605,   605,   605,
     605,   606,   607,   607,   607,   608,   608,   608,   608,   608,
     608,   609,   609,   610,   610,   610,   610,   610,   610,   610,
     611,   611,   612,   612,   613,   613,   614,   615,   615,   615,
     615,   616,   616,   617,   617,   618,   618,   619,   619,   619,
     619,   619,   620,   621,   622,   622,   622,   622,   622,   623,
     623,   624,   624,   624,   624,   625,   625,   625,   625,   626,
     626,   627,   627,   628,   629,   630,   630,   630,   631,   632,
     633,   633,   634,   635,   636,   636,   637,   637,   638,   638,
     639,   639,   639,   639,   639,   639,   639,   639,   639,   639,
     639,   639,   640,   640,   641,   641,   641,   642,   642,   643,
     643,   644,   644,   645,   645,   646,   646,   647,   647,   648,
     648,   649,   649,   650,   650,   651,   652,   652,   653,   653,
     654,   654,   655,   655,   656,   656,   656,   657,   658,   658,
     659,   660,   660,   660,   660,   660,   660,   660,   660,   660,
     660,   660,   660,   660,   660,   660,   660,   660,   660,   660,
     660,   660,   660,   660,   660,   661,   662,   662,   662,   662,
     663,   663,   664,   664,   665,   665,   666,   666,   667,   667,
     668,   668,   669,   670,   670,   671,   671,   671,   671,   672,
     673,   674,   675,   676,   676,   677,   677,   678,   678,   679,
     679,   680,   680,   680,   681,   681,   682,   682,   683,   684,
     684,   684,   685,   685,   686,   687,   687,   688,   688,   688,
     689,   689,   690,   690,   690,   690,   690,   691,   691,   692,
     692,   693,   693,   694,   694,   695,   695,   695,   696,   696,
     696,   696,   697,   697,   698,   698,   699,   699,   699,   699,
     699,   699,   700,   700,   701,   701,   702,   702,   703,   704,
     704,   705,   706,   706,   706,   706,   707,   708,   709,   709,
     709,   709,   709,   709,   709,   709,   709,   709,   709,   709,
     709,   709,   710,   711,   711,   712,   712,   713,   713,   713,
     713,   713,   714,   714,   715,   716,   716,   717,   718,   718,
     719,   719,   720,   720,   720,   721,   721,   722,   723,   723,
     724,   724,   724,   724,   724,   725,   725,   726,   726,   727,
     727,   727,   728,   728,   729,   730,   730,   731,   731,   732,
     732,   733,   733,   734,   734,   735,   736,   737,   737,   737,
     737,   738,   738,   738,   738,   738,   738,   738,   738,   738,
     738,   738,   738,   738,   738,   738,   738,   738,   739,   739,
     740,   740,   741,   741,   742,   743,   743,   743,   744,   744,
     744,   744,   744,   744,   744,   744,   744,   744,   744,   744,
     744,   745,   745,   745,   745,   745,   745,   745,   745,   745,
     745,   745,   745,   745,   745,   745,   745,   745,   745,   745,
     745,   745,   745,   745,   746,   746,   747,   747,   747,   747,
     747,   748,   748,   749,   749,   749,   749,   749,   749,   749,
     749,   749,   749,   749,   749,   749,   750,   750,   751,   751,
     751,   751,   751,   751,   751,   751,   751,   751,   751,   752,
     752,   752,   752,   752,   752,   752,   752,   752,   752,   752,
     752,   752,   752,   753,   753,   754,   754,   755,   756,   756,
     757,   757,   757,   757,   757,   758,   758,   759,   759,   759,
     759,   760,   760,   760,   760,   760,   760,   760,   760,   760,
     760,   760,   760,   760,   760,   760,   760,   761,   761,   762,
     762,   763,   763,   764,   764,   765,   766,   767,   767,   768,
     768,   769,   769,   770,   771,   771,   772,   772,   772,   773,
     773,   773,   774,   774,   774,   774,   775,   776,   776,   777,
     777,   778,   778,   779,   779,   780,   780,   781,   781,   781,
     782,   782,   783,   783,   783,   784,   784,   784,   785,   785,
     785,   786,   786,   786,   787,   787,   788,   788,   789,   789,
     790,   790,   791,   791,   792,   792,   792,   792,   792,   793,
     793,   793,   793,   793,   794,   795,   796,   796,   796,   797,
     797,   797,   798,   798,   799,   799,   799,   799,   799,   799,
     799,   799,   799,   799,   799,   799,   799,   799,   799,   800,
     800,   800,   800,   801,   801,   802,   802,   803,   804,   804,
     805,   806,   806,   807,   807,   808,   808,   809,   809,   810,
     810,   811,   811,   811,   811,   812,   812,   813,   814,   814,
     815,   815,   816,   816,   816,   817,   817,   817,   818,   819,
     819,   820,   820,   820,   821,   821,   822,   822,   823,   823,
     823,   823,   823,   823,   823,   823,   823,   823,   823,   823,
     823,   823,   823,   823,   823,   823,   823,   823,   823,   823,
     823,   823,   823,   823,   823,   823,   823,   823,   823,   823,
     823,   823,   823,   823,   823,   823,   823,   823,   823,   823,
     823,   823,   823,   823,   823,   824,   824,   825,   825,   826,
     826,   826,   826,   826,   826,   826,   826,   826,   826,   826,
     826,   826,   826,   826,   826,   826,   826,   826,   826,   826,
     826,   826,   826,   827,   827,   827,   827,   827,   827,   827,
     827,   827,   827,   827,   827,   827,   827,   827,   827,   827,
     827,   827,   828,   829,   829,   829,   830,   830,   831,   831,
     831,   831,   831,   832,   832,   833,   833,   833,   833,   834,
     834,   834,   835,   835,   836,   837,   837,   838,   839,   839,
     840,   840,   840,   840,   840,   840,   840,   840,   840,   840,
     840,   840,   840,   840,   841,   841,   841,   842,   842,   842,
     842,   842,   843,   843,   843,   844,   844,   845,   845,   845,
     845,   846,   846,   846,   846,   847,   848,   849,   849,   850,
     850,   850,   850,   850,   850,   850,   850,   850,   850,   850,
     850,   850,   850,   850,   850,   851,   851,   852,   852,   853,
     854,   854,   855,   856,   856,   857,   858,   858,   858,   858,
     858,   858,   858,   859,   859,   860,   861,   861,   861,   861,
     861,   861,   862,   863,   863,   863,   864,   864,   865,   865,
     865,   865,   865,   866,   866,   867,   867,   867,   867,   868,
     868,   869,   869,   870,   870,   871,   871,   872,   872,   873,
     873,   874,   874,   874,   874,   875,   875,   875,   875,   875,
     875,   875,   875,   875,   876,   876,   877,   878,   878,   879,
     879,   879,   880,   880,   881,   881,   882,   882,   882,   882,
     883,   883,   884,   884,   885,   886,   886,   886,   887,   887,
     888,   889,   889,   890,   891,   891,   892,   893,   893,   894,
     894,   894,   894,   894,   894,   894,   894,   895,   895,   896,
     897,   897,   898,   898,   899,   900,   901,   902,   902,   903,
     904,   904,   905,   905,   905,   905,   905,   906,   906,   906,
     907,   907,   908,   908,   909,   909,   909,   909,   909,   909,
     909,   909,   910,   910,   911,   911,   911,   911,   911,   911,
     912,   912,   913,   913,   914,   915,   915,   916,   916,   916,
     917,   917,   917,   917,   917,   917,   917,   917,   917,   918,
     918,   919,   919,   919,   920,   920,   920,   920,   921,   921,
     922,   923,   923,   924,   924,   925,   925,   925,   925,   926,
     926,   927,   927,   927,   928,   928,   929,   929,   930,   931,
     931,   931,   932,   933,   933,   934,   934,   935,   935,   936,
     936,   937,   937,   938,   938,   939,   939,   940,   941,   941,
     941,   941,   942,   942,   943,   943,   944,   944,   945,   945,
     946,   946,   946,   946,   946,   946,   946,   947,   947,   947,
     947,   947,   947,   948,   948,   948,   948,   949,   949,   950,
     950,   950,   950,   950,   951,   951,   951,   951,   952,   952,
     953,   953,   954,   954,   954,   954,   955,   955,   956,   956,
     956,   957,   958,   958,   959,   959,   959,   960,   960,   961,
     961,   962,   963,   963,   963,   963,   963,   963,   964,   964,
     964,   965,   965,   965,   965,   965,   965,   965,   966,   966,
     966,   966,   967,   967,   968,   968,   969,   969,   969,   969,
     969,   969,   969,   969,   969,   969,   969,   970,   970,   971,
     971,   972,   972,   973,   974,   975,   975,   976,   976,   977,
     978,   979,   979,   979,   979,   979,   979,   980,   980,   981,
     981,   982,   982,   982,   982,   983,   984,   984,   984,   985,
     985,   985,   985,   985,   985,   985,   985,   985,   985,   985,
     985,   985,   985,   986,   986,   987,   987,   987,   987,   987,
     987,   987,   987,   987,   987,   987,   987,   987,   987,   987,
     987,   987,   987,   987,   987,   987,   987,   987,   987,   987,
     987,   987,   987,   987,   987,   987,   987,   987,   987,   987,
     987,   987,   987,   987,   987,   987,   987,   987,   987,   987,
     987,   987,   987,   987,   987,   987,   987,   987,   987,   987,
     987,   987,   987,   987,   988,   988,   988,   988,   988,   988,
     988,   988,   988,   988,   988,   988,   988,   988,   988,   988,
     988,   988,   988,   988,   988,   988,   989,   989,   989,   989,
     989,   989,   989,   989,   989,   989,   989,   989,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   990,   990,   990,
     990,   990,   990,   990,   990,   990,   990,   990,   991,   991,
     992,   992,   992,   992,   993,   994,   994,   995,   995,   996,
     996,   997,   997,   997,   998,   998,   998,   998,   999,   999,
    1000,  1000,  1001,  1002,  1002,  1002,  1003,  1004,  1004,  1005,
    1005,  1006,  1006,  1006,  1007,  1007,  1008,  1008,  1008,  1008,
    1008,  1009,  1009,  1009,  1010,  1010,  1010,  1011,  1011,  1012,
    1012,  1012,  1012,  1012,  1012,  1012,  1012,  1012,  1013,  1013,
    1014,  1014,  1015,  1015,  1015,  1015,  1015,  1015,  1016,  1016,
    1017,  1017,  1018,  1018,  1019,  1019,  1020,  1020,  1020,  1021,
    1021,  1022,  1022,  1023,  1023,  1023,  1023,  1023,  1023,  1023,
    1023,  1024,  1024,  1025,  1026,  1026,  1027,  1027,  1027,  1027,
    1027,  1027,  1028,  1029,  1030,  1030,  1030,  1031,  1031,  1032,
    1033,  1033,  1034,  1035,  1035,  1036,  1036,  1037,  1037,  1038,
    1038,  1038,  1038,  1039,  1039,  1040,  1040,  1041,  1041,  1042,
    1042,  1043,  1043,  1044,  1045,  1045,  1046,  1046,  1046,  1046,
    1047,  1047,  1048,  1048,  1049,  1049,  1050,  1051,  1052,  1053,
    1054,  1055,  1056,  1056,  1057,  1057,  1057,  1057,  1057,  1057,
    1057,  1057,  1057,  1057,  1057,  1057,  1057,  1057,  1057,  1058,
    1059,  1060,  1060,  1060,  1060,  1061,  1061,  1061,  1061,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,  1062,
    1062,  1062,  1062,  1062,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,
    1063,  1063,  1063,  1063,  1063,  1063,  1063,  1063,  1064,  1064,
    1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,
    1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,  1064,
    1064,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,  1065,
    1065,  1065,  1065,  1065,  1065,  1065,  1066,  1066,  1067,  1067,
    1067,  1067,  1067,  1067,  1067,  1067,  1069,  1068,  1070,  1071,
    1071,  1071,  1071,  1072,  1072,  1072,  1072,  1073,  1073,  1074,
    1075,  1076,  1076,  1077,  1077,  1077,  1078,  1078,  1079,  1079,
    1080,  1080,  1081,  1081,  1081,  1081,  1082,  1082,  1082,  1083,
    1084,  1084,  1085,  1085,  1086,  1086,  1086,  1086,  1087,  1087,
    1088,  1089,  1090,  1091,  1091,  1092,  1093,  1093,  1094,  1094,
    1094,  1094,  1094,  1096,  1095,  1097,  1098,  1099,  1099,  1100,
    1100,  1100,  1100,  1101,  1101,  1103,  1102,  1105,  1104,  1106,
    1104,  1104,  1107,  1107,  1108,  1108,  1108,  1109,  1109,  1109,
    1109,  1110,  1110,  1111,  1111,  1111,  1111,  1111,  1111,  1112,
    1112,  1112,  1113,  1115,  1114,  1116,  1117,  1116,  1118,  1118,
    1119,  1119,  1120,  1120,  1121,  1121,  1121,  1121,  1121,  1121,
    1121,  1121,  1121,  1122,  1122,  1122,  1122,  1122,  1122,  1122,
    1122,  1122,  1122,  1123,  1123,  1124,  1124,  1125,  1126,  1126,
    1127,  1127,  1127,  1128,  1129,  1130,  1130,  1130,  1130,  1131,
    1131,  1131,  1132,  1132,  1133,  1133,  1134,  1135,  1135,  1136,
    1136,  1137,  1137,  1138,  1138,  1139,  1140,  1140,  1141,  1141,
    1141,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,  1142,
    1143,  1143,  1143,  1143,  1143,  1144,  1144,  1145,  1146,  1147,
    1148,  1148,  1149,  1150,  1151,  1151,  1152,  1153,  1153,  1154,
    1155,  1156,  1156,  1157,  1158,  1159,  1159,  1160,  1161,  1161,
    1161,  1161,  1161,  1162,  1162,  1162,  1162,  1162,  1162,  1162,
    1162,  1162,  1162,  1162,  1162,  1162,  1162,  1162,  1163,  1163,
    1164,  1164,  1165,  1165,  1165,  1167,  1166,  1168,  1168,  1170,
    1169,  1171,  1171,  1171,  1172,  1172,  1172,  1172,  1172,  1172,
    1172,  1172,  1172,  1173,  1173,  1174,  1174,  1174,  1174,  1174,
    1174,  1174,  1174,  1174,  1174,  1174,  1174,  1174,  1174,  1174,
    1174,  1174,  1174,  1174,  1174,  1174,  1174,  1174,  1174,  1175,
    1175,  1175,  1175,  1175,  1175,  1176,  1176,  1176,  1176,  1176,
    1176,  1176,  1177,  1178,  1178,  1178,  1178,  1178,  1178,  1178,
    1178,  1179,  1179,  1179,  1179,  1179,  1179,  1179,  1180,  1180,
    1180,  1180,  1180,  1180,  1181,  1181,  1181,  1181,  1181,  1181,
    1181,  1181,  1181,  1181,  1181,  1182,  1182,  1182,  1182,  1182,
    1183,  1183,  1183,  1183,  1184,  1184,  1184,  1184,  1184,  1184,
    1184,  1185,  1185,  1185,  1186,  1186,  1186,  1186,  1186,  1186,
    1187,  1187,  1188,  1189,  1189,  1190,  1190,  1191,  1192,  1193,
    1194,  1194,  1194,  1195,  1196,  1197,  1198,  1199,  1199,  1199,
    1199,  1199,  1200,  1201,  1201,  1201,  1202,  1202,  1203,  1203,
    1203,  1204,  1204,  1205,  1205,  1206,  1206,  1207,  1207,  1207,
    1207,  1207,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,
    1208,  1208,  1208,  1208,  1208,  1208,  1208,  1208,  1209,  1209,
    1209,  1209,  1210,  1210,  1210,  1210,  1210,  1210,  1210,  1210,
    1210,  1211,  1211,  1211,  1211,  1211,  1212,  1212,  1213,  1213,
    1214,  1214
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     5,     1,     0,
       2,     0,     2,     0,     2,     2,     3,     3,     1,     3,
       3,     2,     1,     1,     2,     2,     2,     3,     3,     5,
       5,     0,     3,     5,     5,     5,     4,     3,     5,     3,
       5,     5,     6,     1,     1,     3,     5,     6,     4,     9,
       7,     1,     0,     2,     0,     1,     1,     1,     1,     1,
       1,     2,     3,     3,     2,     5,     1,     3,     3,     3,
       3,     3,     3,     2,     2,     2,     2,     3,     3,     3,
       3,     1,     3,     1,     3,     1,     1,     2,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     3,     6,     1,
       1,     1,     1,     1,     0,     1,     1,     2,     3,     4,
       3,     2,     2,     1,     2,     1,     3,     4,     5,     4,
       2,     4,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     4,     6,     4,     6,     4,     6,     4,     6,     5,
       7,     1,     3,     2,     3,     4,     6,     6,     6,     5,
       5,     6,     6,     4,     8,     4,     2,     3,     6,     4,
       3,     3,     3,     3,     3,     4,     4,     3,     3,     3,
       3,     3,     3,     4,     4,     3,     2,     3,     2,     2,
       3,     3,     2,     2,     1,     3,     2,     1,     1,     0,
       2,     0,     2,     0,     3,     2,     0,     1,     3,     3,
       1,     5,     3,     4,     1,     3,     4,     6,     4,     8,
       2,     2,    11,     7,     1,     1,     1,     0,     1,     1,
       1,     1,     3,     2,     0,     1,     1,     1,     3,     3,
       1,     1,     3,     3,     3,     3,     4,     2,     1,     0,
       2,     0,     3,     0,     1,     0,     1,     3,     2,     1,
       1,     1,     3,     0,     1,     3,     1,    11,    14,    10,
      13,     1,     1,     2,     2,     2,     2,     1,     0,     1,
       0,     3,     0,     1,     3,     1,     3,     1,     1,     1,
       1,     1,     4,     4,     2,     0,     3,     1,     1,     2,
       2,     1,     3,     4,     5,     2,     5,     1,     2,     2,
       2,     3,     3,     3,     0,     1,     1,     1,     1,     1,
       1,     3,     1,     5,     7,     3,     8,     4,     9,    11,
       2,     0,     3,     0,     1,     3,     1,     2,     2,     2,
       0,     1,     3,     3,     6,     4,     0,     1,     1,     2,
       2,     0,     3,     3,     2,     1,     1,     2,     2,     4,
       0,     2,     2,     2,     0,     3,     4,     4,     0,     2,
       0,     4,     0,     3,     5,     2,     3,     0,     8,     4,
       1,     0,     5,     5,     4,     6,     1,     0,     1,     2,
       2,     1,     2,     3,     2,     2,     2,     2,     3,     3,
       1,     3,     1,     0,     1,     2,     1,     1,     3,     6,
      10,     1,     0,     1,     2,     2,     0,     2,     2,     1,
       0,     5,     7,     1,     0,     6,     2,     0,     3,     5,
       5,     8,     2,     0,     2,     2,     2,     5,     2,     0,
       2,     7,    10,     6,     6,     6,     6,     7,     7,     9,
       9,     6,     7,     6,     8,     8,     8,     8,     6,     6,
       7,     7,     8,     6,     6,     7,     2,     2,     2,     2,
       1,     2,     1,     0,     6,     8,     7,     6,     4,     0,
       1,     3,     4,     1,     3,     1,     2,     2,     2,     2,
       1,     1,    10,     2,     0,     2,     2,     1,     0,     4,
       6,     5,     4,     4,    10,    13,     5,     7,     8,     1,
       1,     1,     7,     9,     8,    15,    20,     1,     1,     2,
       1,     3,     1,     1,     1,     3,     1,     3,     0,     1,
       0,     1,     1,     4,     0,     1,     3,     0,     1,     1,
       1,     1,     2,     0,     0,     2,     2,     1,     2,     2,
       2,     2,     6,     8,    11,    13,     1,     3,     5,     1,
       3,     5,     1,     2,     2,     1,     8,     4,     5,     4,
       4,     4,     3,     7,     8,     6,     6,     6,     6,     6,
       4,     5,     3,     1,     3,     3,     1,     1,     1,     1,
       1,     1,     3,     3,     3,     1,     3,     3,     1,     0,
       1,     3,     7,     9,     9,     3,     0,    13,     1,     3,
       5,     6,     4,     7,     2,     1,     0,     2,     0,     2,
       4,     0,     1,     0,     6,     8,     8,     1,     3,     5,
       5,     7,     9,     7,     9,     5,     6,     6,     4,     5,
       7,     1,     1,     1,     2,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     3,     3,     3,     3,     1,     3,
       1,     2,     2,     3,     5,     2,     2,     0,     6,     7,
       7,     7,     8,     8,     6,     8,     9,     9,     7,    10,
       7,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     1,     2,     1,     3,     2,
       3,     3,     3,     3,     1,     1,     8,     9,     9,     9,
       9,     2,     0,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     2,     2,
       3,     4,     5,     4,     5,     3,     4,     3,     4,     1,
       2,     3,     3,     3,     3,     4,     4,     3,     3,     4,
       4,     4,     4,     1,     1,     1,     0,     7,     7,    10,
       1,     1,     2,     4,     5,     1,     3,     2,     2,     2,
       2,     1,     2,     2,     4,     3,     2,     2,     2,     2,
       3,     2,     2,     2,     5,     5,     5,     1,     3,     1,
       2,     3,     0,     1,     3,     2,     6,     6,     9,     3,
       0,     3,     0,     5,     2,     0,     3,     3,     3,     7,
       7,    10,     1,     1,     1,     1,    14,     1,     0,     1,
       0,     1,     0,     2,     0,     1,     3,     5,     5,     7,
       2,     0,     1,     2,     0,     1,     1,     0,     1,     1,
       0,     9,    12,     7,     2,     0,     3,     2,     1,     3,
       3,     2,     1,     3,     3,     3,     2,     2,     1,     1,
       1,     1,     2,     1,     1,     1,     1,     4,     5,     1,
       3,     3,     1,     2,     4,     5,     1,     1,     1,     1,
       3,     3,     2,     2,     1,     2,     2,     2,     1,     2,
       2,     1,     1,     1,     3,     2,     0,     2,     1,     3,
       5,     1,     2,     1,     0,     5,     7,     5,     7,     5,
       7,     3,     5,     5,     5,     1,     3,     2,     1,     2,
       1,     2,    11,    10,    10,     2,     2,     0,     9,     2,
       0,     4,     4,     4,     1,     1,     1,     0,     7,     6,
       6,     6,     6,     8,     8,     6,     6,     7,     9,     9,
       6,     6,     6,     8,     6,     8,     6,     8,     7,     9,
       6,     8,     7,     9,     8,    10,     9,    11,     8,     9,
      11,     8,     8,     7,     6,     6,     6,     5,     5,     8,
       8,     8,     8,     6,     9,     1,     0,     2,     0,     7,
       6,     6,     6,     6,     6,     7,     9,     9,     6,     8,
       8,     8,     8,     8,     6,     8,     6,     8,     7,     9,
       7,     9,     6,     7,     6,     6,     6,     6,     6,     7,
       7,     7,     9,     9,     6,     6,     6,     8,     8,     8,
       6,     7,    13,     1,     1,     3,     3,     1,     1,     1,
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     0,     6,     8,     3,     2,     0,     2,     2,     2,
       2,     3,     3,     2,     2,     2,     2,     3,     2,     5,
       4,     3,     3,     3,     1,     1,     0,     3,     2,     2,
       1,     2,     1,     3,     2,     1,     0,     9,    11,    11,
      13,     3,     4,     4,     0,     2,     5,     2,     0,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     4,     3,     3,     1,     0,     5,     6,     4,
       2,     0,     4,     3,     5,     6,     4,     6,     6,     5,
       7,     9,     6,     1,     0,     6,    11,    11,    11,    13,
       9,    11,    10,     4,     2,     5,     2,     0,     4,     5,
       5,     4,     6,     1,     3,     1,     1,     1,     1,     2,
       4,     1,     1,     1,     0,     1,     0,     1,     0,     3,
       0,     2,     4,     3,     5,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     2,     1,     1,     1,
       1,     0,     5,     4,     3,     0,     1,     1,     1,     1,
       4,     9,     3,     0,     6,     1,     4,     2,     1,     3,
       2,     3,     0,     7,     2,     0,     5,     3,     0,     2,
       2,     2,     3,     1,     3,     1,     2,     1,     0,     8,
       1,     3,     1,     1,     3,     5,     2,     1,     3,     7,
       1,     1,     0,     3,     2,     2,     2,     0,     2,     2,
       1,     1,     3,     3,     1,     2,     4,     4,     2,     3,
       5,     5,     1,     1,     9,     1,     2,     4,     4,     4,
       2,     3,     1,     3,     6,     1,     0,     2,     1,     0,
       3,     3,     4,     4,     4,     4,     3,     2,     1,     1,
       0,     1,     1,     0,     1,     5,     1,     0,     1,     0,
       3,     1,     3,     4,     3,     2,     2,     1,     1,     1,
       0,     2,     4,     5,     2,     3,     1,     1,     1,     1,
       3,     0,     1,     1,     1,     1,     1,     3,     0,     2,
       0,     1,     3,     1,     0,     1,     2,     3,     2,     4,
       2,     3,     2,     0,     2,     3,     2,     0,     1,     3,
       2,     2,     3,     2,     3,     1,     4,     3,     4,     5,
       4,     5,     4,     5,     2,     4,     1,     1,     0,     1,
       4,     5,     4,     0,     2,     2,     2,     1,     1,     0,
       4,     2,     1,     2,     2,     4,     1,     3,     1,     2,
       3,     1,     2,     0,     2,     4,     0,     1,     0,     1,
       3,     3,     2,     3,     5,     6,     2,     3,     3,     4,
       0,     1,     1,     1,     1,     1,     2,     5,     1,     1,
       1,     1,     2,     3,     3,     0,     1,     1,     1,     1,
       1,     2,     2,     2,     2,     2,     1,     3,     0,     1,
       1,     1,     1,     5,     2,     1,     1,     1,     1,     5,
       2,     2,     2,     1,     3,     3,     2,     1,     0,     3,
       0,     5,     2,     5,     2,     1,     2,     3,     0,     1,
       1,     1,     1,     1,     1,     3,     3,     3,     3,     3,
       3,     3,     0,     1,     4,     1,     3,     3,     5,     2,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     2,     2,     3,     3,     2,     3,     5,     4,     6,
       3,     5,     4,     6,     4,     6,     5,     7,     3,     2,
       4,     2,     3,     3,     4,     3,     4,     3,     4,     5,
       6,     6,     7,     6,     7,     6,     7,     3,     4,     4,
       6,     2,     3,     4,     1,     3,     2,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
       5,     6,     6,     7,     3,     4,     1,     1,     2,     4,
       1,     1,     1,     2,     2,     2,     2,     1,     4,     5,
       6,     8,     6,     7,     7,     5,     5,     1,     1,     4,
       1,     4,     1,     4,     1,     4,     1,     1,     1,     1,
       1,     1,     6,     4,     4,     4,     4,     6,     5,     5,
       5,     4,     6,     4,     4,     4,     4,     5,     7,     7,
       9,     5,     4,     6,     5,     7,     7,     7,     2,     3,
       3,     3,     4,     0,     4,     1,     3,     3,     1,     1,
       1,     2,     2,     0,     2,     4,     4,     6,     2,     0,
       1,     3,     3,     2,     2,     0,     6,     1,     0,     3,
       0,     2,     2,     0,     1,     4,     2,     2,     2,     2,
       2,     4,     3,     5,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       1,     4,     1,     4,     1,     2,     1,     2,     1,     3,
       1,     3,     1,     3,     1,     3,     3,     3,     2,     1,
       3,     3,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     3,     2,     3,     0,     3,     3,     2,     2,
       1,     0,     2,     2,     3,     2,     1,     1,     3,     5,
       1,     2,     4,     2,     0,     1,     0,     1,     2,     2,
       2,     3,     5,     1,     2,     0,     2,     1,     0,     1,
       1,     1,     3,     3,     1,     3,     3,     2,     1,     1,
       1,     3,     1,     2,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     2,
       5,     2,     3,     6,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     2,     4,     3,
       2,     1,     1,     1,     1,     1,     0,     8,     2,     5,
       3,     2,     2,     3,     7,     1,     1,     1,     0,     2,
       2,     1,     0,     1,     3,     1,     2,     0,     2,     0,
       2,     0,     1,     3,     4,     3,     1,     1,     1,     1,
       2,     0,     2,     4,     0,     2,     2,     2,     1,     1,
       7,     3,     1,     1,     1,     1,     2,     0,     1,     3,
       3,     3,     3,     0,     4,     5,     5,     0,     1,     1,
       1,     2,     2,     1,     2,     0,     7,     0,     5,     0,
       4,     2,     2,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     2,     1,     3,
       2,     2,     3,     0,     5,     1,     0,     5,     2,     2,
       1,     1,     1,     2,     2,     3,     1,     2,     2,     3,
       3,     4,     2,     1,     2,     1,     1,     2,     2,     3,
       1,     1,     1,     1,     0,     1,     3,     5,     0,     2,
       0,     1,     2,     3,     2,     1,     1,     1,     0,     1,
       1,     1,     1,     1,     2,     2,     3,     0,     1,     2,
       1,     4,     3,     4,     3,     2,     1,     3,     1,     1,
       1,     1,     2,     2,     1,     2,     2,     1,     1,     1,
       4,     4,     4,     4,     4,     1,     0,     3,     3,     4,
       1,     3,     3,     4,     1,     3,     3,     1,     1,     1,
       6,     1,     3,     3,     6,     1,     3,     3,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     4,
       1,     1,     4,     4,     3,     0,     7,     1,     0,     0,
       7,     3,     4,     3,     1,     1,     1,     2,     3,     5,
       2,     5,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     0,     1,     2,     1,     2,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       3,     1,     2,     1,     3,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     3,
       2,     3,     1,     3,     3,     3,     3,     3,     3,     1,
       1,     0,     2,     2,     1,     1,     2,     1,     1,     1,
       0,     1
};

/* YYDEFACT[STATE-NAME] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    2316,     0,     2,     1,  2746,  2750,  2754,  2755,  2672,  2756,
    2757,  2722,  2723,  2724,  2725,  2726,  2727,  2728,  2729,  2730,
    2731,  2732,  2733,  2735,  2734,  2736,  2737,  2738,  2739,  2740,
    2741,  2742,  2743,  2745,  2744,  2694,  2323,  2691,  2688,  2689,
    2690,  2695,  2693,  2686,  2687,  1919,  2759,  2747,  2760,  2748,
    2749,  2751,  2752,  2721,  2753,  2761,  2762,  2763,  2758,  2766,
    2717,  2718,  2716,  2719,  2720,  2764,  2765,  2708,  2709,  2710,
    2711,  2767,  2324,  2325,  2713,  2317,  2321,  2383,  2454,  2714,
    2715,  2712,  2322,  2707,  2454,     0,  2575,  2576,  2577,     0,
    2578,  2579,  2580,  2506,  2468,  2581,     0,     0,  2582,  2583,
    2584,  2585,  2586,  2587,  2588,  2589,     0,  2590,  2591,  2592,
    2593,  2453,  2594,  2595,  2596,  2597,  2598,  2430,  2436,  2559,
       0,  2410,  2411,  2407,  2409,  2408,  2412,  2395,  1196,   544,
    1282,  1281,     0,  2218,  1196,  2174,  2175,  2219,  2176,  2177,
    2178,   256,     0,  1284,  2179,  2220,     0,  1196,  2221,   369,
     965,  2222,  2223,  2338,     0,  2180,  2181,     0,     0,     0,
     544,  1196,     0,     0,  2182,  1396,  2183,     0,  2184,  2224,
    2225,     0,  2185,  2226,  2227,  2186,  2187,  2188,  2228,  2229,
    2230,  2189,  2231,  2232,     0,     0,  1410,     0,  2190,  2233,
    2191,  2192,     0,  2234,  2193,  2194,  2195,  2235,  2236,  2237,
    2196,  2197,  2198,     0,  2199,     0,     0,     0,     0,     0,
       0,  2238,  1196,  2200,     0,     0,  1417,     0,  2201,     0,
    2239,  2202,     0,  2203,     0,  2204,  2205,  2206,  2207,  1410,
    2555,  2431,     0,  1286,     0,  2208,  2240,     0,  2209,  2210,
    2211,  2212,  2213,  2214,  2215,  2216,  2217,     0,     0,    57,
      58,    22,    21,    27,    26,    80,    81,    45,    15,    71,
      51,   114,   113,   115,    33,    29,    65,    19,    20,    30,
      34,    53,    46,    92,    52,    18,    50,    75,    54,    78,
      40,     9,    10,    41,    69,    11,    42,    70,    12,    43,
      13,    59,    82,    25,    55,    79,    56,     3,    36,    67,
      63,     8,    47,    48,    49,    72,    73,    74,    97,    77,
     109,    32,   106,    86,    87,   103,    88,   104,     6,    89,
      44,    14,   100,    99,   101,    66,    37,    68,    98,   102,
      16,    17,   105,    76,    95,    91,   110,   108,   116,    93,
      60,     4,     5,    83,    39,     7,    24,    23,    38,    31,
     112,    28,  1284,    85,    96,    84,    90,    64,    94,   111,
      62,   107,  1383,  1370,  1419,  1382,  1395,     0,  1385,  2651,
    2652,    35,  1396,   118,   119,   124,  2320,  2372,  2373,  2374,
    2454,  2405,  2406,  2399,  2415,  2425,  2414,  2418,  2426,  2413,
    2432,     0,   121,   123,   125,   128,   122,   117,   120,   127,
     132,   126,   131,   129,   130,   133,   134,   135,  2653,  1602,
    2650,    61,  2390,  2389,     0,  2454,     0,  2683,  1929,  1930,
    1931,  1932,  1933,  1934,  1935,  1936,  1937,  1938,  1939,  1940,
    1941,  1942,  1943,  1944,  1945,  1946,  1947,  1948,  1949,  1950,
    1951,  1952,  1953,  1954,  1955,  1956,  1957,  1958,  1959,  1960,
    1961,  1962,  1963,  1964,  1965,  1966,  1967,  1968,  1969,  1970,
    1971,  1972,  1973,  1974,  1975,  1976,  1977,  1978,  1979,  1980,
    1981,  1982,  1983,  1984,  1985,  1986,  1987,  1988,  1989,  1990,
    1991,  1992,  1993,  1994,  1995,  1996,  1997,  1998,  1999,  2000,
    2001,  2002,  2003,  2004,  2005,  2006,  2007,  2008,  2009,  2010,
    2011,  2012,  2013,  2014,  2015,  2016,  2017,  2018,  2019,  2020,
    2021,  2022,  2023,  2024,  2025,  2026,  2027,  2028,  2029,  2030,
    2031,  2032,  2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,
    2041,  2042,  2043,  2044,  2045,  2046,  2047,  2048,  2049,  2050,
    2051,  2052,  2053,  2054,  2055,  2056,  2057,  2058,  2059,  2060,
    2061,  2062,  2063,  2064,  2065,  2066,  2067,  2068,  2069,  2070,
    2071,  2072,  2073,  2074,  2075,  2076,  2077,  2080,  2078,  2079,
    2081,  2082,  2083,  2084,  2085,  2086,  2087,  2088,  2089,  2090,
    2091,  2092,  2093,  2094,  2095,  2096,  2097,  2098,  2099,  2100,
    2101,  2102,  2103,  2104,  2105,  2106,  2107,  2108,  2109,  2110,
    2111,  2112,  2113,  2114,  2115,  2116,  2117,  2118,  2119,  2120,
    2121,  2122,  2123,  2124,  2125,  2126,  2127,  2128,  2129,  2130,
    2131,  2132,  2133,  2134,  2135,  2136,  2137,  2138,  2139,  2140,
    2141,  2142,  2338,  2143,  2144,  2145,  2146,  2147,  2148,  2149,
    2150,  2151,  2152,  2153,  2154,  2155,  2156,  2157,  2158,  2159,
    2160,  2161,  2162,  2163,  2164,  2165,  2166,  2167,  2168,  2169,
    2170,  2171,  2172,  2173,  2356,  1920,  1926,  1927,  1928,  2331,
    2352,  2358,  2679,  2357,  1925,  2505,     0,     0,  2599,  2600,
    2601,  2602,  2603,  2604,  2654,  2655,  2656,  2657,  2658,  2660,
    2659,  2467,  2626,  2663,  2466,  2664,  2470,  2665,  2666,  2667,
    2668,  2627,  2669,  2469,  2661,  2623,  2471,  2464,  2465,  2624,
    2573,  2574,  1897,  2625,  2622,  2662,  2359,  2621,  2475,  2474,
    1360,  2678,  1896,  1361,     0,  2477,  2605,  2606,  2607,  2608,
    2610,  2609,  2611,  2241,  2242,  2243,  2244,  2245,  2246,  2247,
    2248,  2249,  2250,  2251,  2252,  2636,  2253,  2254,  2255,  2649,
    2256,  2257,  2637,  2258,  2259,  2260,  2261,  2262,  2263,  2264,
    2265,  2266,  2267,  2268,  2269,  2270,  2271,  2272,  2273,  2274,
    2275,  2276,  2277,  2278,  2279,  2280,  2281,  2638,  2639,  2282,
    2283,  2284,  2285,  2286,  2287,  2288,  2289,  2290,  2291,  2292,
    2293,  2294,  2295,  2296,  2297,  2298,  2299,  2300,  2301,  2302,
    2303,  2304,  2305,  2640,  2306,  2307,  2641,  2308,  2309,  2310,
    2642,  2311,  2312,  2313,  2314,  2315,  2646,  2647,  2648,  2635,
    2428,  2612,  2634,  2645,  2643,  2644,  2438,  2434,  2442,  2437,
       0,     0,     0,     0,  2454,  1195,  1194,  1180,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   543,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2328,     0,  1206,
     341,   340,  1283,  1264,   544,     0,  1183,   368,     0,     0,
       0,     0,     0,     0,     0,     0,   735,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   182,     0,     0,
     392,   391,     0,     0,     0,   937,   397,     0,     0,     0,
       0,     0,   532,  2337,  2332,  2342,     0,  2335,  2336,  2621,
       0,  2770,  2078,  2368,  2369,  2768,  2128,  1362,   257,   260,
     258,   259,     0,  1037,  1038,  1040,     0,     0,  1050,   770,
     771,     0,   769,     0,   773,     0,     0,     0,   765,     0,
       0,     0,     0,     0,   772,   762,     0,   761,     0,     0,
       0,   768,     0,   763,     0,     0,  1184,     0,  2420,  2421,
    2018,  1323,   398,     0,     0,  1396,     0,  1301,  1302,  1284,
    1291,  1303,  1296,  1298,  1297,  1299,  1295,  1300,  1930,   876,
    1944,   876,  2008,   873,   874,   876,   876,   876,  2095,     0,
       0,   848,     0,   859,  1921,   876,  1922,  2679,   881,   453,
     453,   453,     0,   880,   885,   453,  1177,  1215,  1901,  1409,
       0,  1944,  2008,   849,  1176,  2143,  1315,     0,     0,     0,
    1054,     0,  1055,     0,  2110,  1188,   241,  2619,  2119,  2204,
    2143,  2620,   237,  2614,  2615,  2617,   211,  2618,  2616,  2613,
    1934,     0,     0,   880,     0,  1185,  1186,   832,  1416,  1414,
       0,     0,     0,  1952,     0,  1964,  2044,   234,  2106,  2111,
    2119,  2204,  2143,  2171,   191,   196,     0,   250,  2119,  2204,
    2143,     0,  1206,     0,  1386,  1502,  1892,     0,     0,  2429,
    1179,  1178,  1285,     0,  1288,     0,  1464,  2091,  1390,  1392,
    1290,  1383,     0,     0,  2319,  1279,  1413,  1413,     0,  1413,
       0,  1375,  1383,  1378,  1382,     0,     0,     0,     0,  1196,
       0,  2397,  2425,  2404,  2460,  2401,     0,     0,  2450,  2446,
    2443,  2451,  2452,  2445,  2433,  1591,  1592,  1593,  1590,  1603,
    1589,     0,  2378,  1594,  2417,  2384,     0,  2392,  2391,  2696,
    2697,  2507,  2330,  2349,     0,     0,     0,     0,     0,     0,
       0,  2476,  2478,  2480,  2440,  2439,  2435,     0,     0,     0,
       0,  2565,  2566,  2564,     0,  2561,  2563,     0,  2460,     0,
    2630,  2624,  2633,     0,  1902,  2625,  2622,  2621,     0,   780,
       0,   139,   925,     0,     0,     0,     0,  1896,     0,     0,
       0,     0,     0,  2017,     0,     0,     0,  1797,  1956,  2004,
    1807,  1805,  1806,  1799,  1800,  1801,  1802,  1803,  1804,     0,
    1035,  1798,     0,   161,   139,     0,     0,  2017,     0,     0,
    2017,     0,     0,     0,     0,     0,  2047,   139,  2017,     0,
       0,     0,  1200,     0,     0,     0,  1202,  1205,  1181,  1267,
       0,  1892,     0,     0,   811,   801,     0,   812,   802,   807,
       0,   814,     0,     0,   804,     0,     0,     0,   815,     0,
     803,   805,   817,   806,   813,     0,     0,   808,   809,     0,
       0,  1192,   453,   347,     0,     0,     0,     0,     0,   139,
    1254,     0,  2017,   139,     0,     0,   396,   395,   139,   394,
     393,  1956,  2004,     0,   964,   139,  2017,     0,   184,   614,
     547,     0,     0,   692,  2047,   139,     0,     0,     0,     0,
       0,     0,   940,     0,     0,   531,   544,     0,  2341,  2347,
       0,  2339,  2508,  2771,  2769,  2463,     0,  1041,   235,   236,
    1039,  2017,     0,   319,     0,     0,  2017,  1243,   767,     0,
     766,  2017,     0,  2017,   175,  1894,     0,   764,  1956,  2004,
    2017,     0,     0,  2017,   167,  2017,     0,  2017,   319,  2017,
     548,     0,  2017,     0,  2017,  2047,   169,     0,  2017,   319,
     778,     0,     0,  2701,  2705,     0,  2703,  2698,  2419,  2473,
    2472,  2371,     0,  2781,     0,  1362,  1293,  1308,     0,  1304,
    1311,  1307,  1396,   876,   875,     0,   876,     0,  2790,   876,
       0,   876,     0,  2790,   876,     0,     0,     0,   876,  1923,
    1924,     0,     0,  2789,  2787,  2788,   850,   860,     0,   882,
       0,     0,   889,   888,   887,     0,     0,     0,   890,  1506,
    1338,     0,   857,     0,   855,     0,  1174,  1191,     0,     0,
       0,     0,     0,  1057,  1057,  1057,  1187,   240,   238,     0,
       0,     0,     0,     0,     0,  1193,     0,     0,     0,     0,
    2685,  1908,  1808,  2684,     0,  2175,  2176,  2177,  1866,     0,
    2626,  2178,  2179,  2220,  1720,  1707,  1716,  1721,  1708,  1710,
    1717,  2180,  2181,  1988,  2182,  2183,  1915,  2184,  2185,  1546,
    2187,  2188,  2189,  1712,  1714,  2190,  2191,     0,  1916,  2193,
    2194,  2066,  2196,  2197,  2199,  2200,  1718,  2202,  2203,  2204,
    2205,  2206,  2207,  1914,     0,  1719,  2208,  2210,  2211,  2212,
    2213,  2214,  2215,  2216,  2217,     0,     0,  1889,     0,  1692,
       0,  1538,  1539,  1561,  1562,  1540,  1567,  1568,  1580,  1541,
       0,  1888,  1605,  1691,  1697,     0,  1690,  1686,  1399,  1884,
       0,  1687,  1904,  1867,  1918,  1917,  2679,  1875,  1907,  1905,
    1906,     0,     0,     0,   203,     0,     0,  2554,   252,     0,
     253,  1890,  2119,   192,   233,   205,   232,   206,   204,     0,
    1954,   193,     0,     0,   194,     0,     0,     0,     0,     0,
       0,     0,   246,  1182,     0,  1504,  1503,     0,     0,  1873,
    1893,   787,     0,  1277,  1278,  1276,     0,  1273,  1275,  1287,
    1284,  1880,  1879,  1881,     0,  1391,     0,     0,     0,  1373,
    1372,  1290,  1411,  1412,     0,     0,     0,     0,     0,     0,
       0,     0,  1454,  1427,  1428,  1430,  1451,  1455,  1463,     0,
    1379,     0,     0,  1508,     0,  1465,  2318,  2460,  2461,     0,
    2455,     0,  2454,  2454,  2448,  2447,  2444,     0,     0,     0,
       0,     0,     0,     0,  2375,   526,  2377,   524,     0,     0,
    2351,     0,  2355,  2353,     0,  2500,  2503,     0,  2501,  2502,
    2504,     0,  2509,  2510,     0,     0,     0,  2692,     0,     0,
    2491,  2479,  2486,  2488,  2490,  2489,  2498,  2494,  2497,  2499,
    2441,  2454,  2572,     0,  2567,  2570,     0,  2562,     0,     0,
       0,  1903,     0,     0,     0,     0,   781,     0,     0,     0,
       0,     0,     0,   138,  1241,   243,  1239,     0,     0,     0,
       0,     0,     0,     0,  1246,     0,     0,   173,   174,   559,
     544,     0,  2017,     0,     0,     0,     0,   997,  1004,     0,
       0,     0,     0,     0,     0,     0,   998,   996,   999,   245,
    1008,  1021,  1024,     0,   915,     0,     0,     0,     0,  1106,
       0,     0,  1106,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   263,   271,   314,     0,  2017,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   143,     0,
       0,     0,     0,     0,     0,   511,   523,     0,     0,     0,
       0,     0,   520,     0,   139,   265,   504,   508,     0,     0,
       0,   623,   622,     0,  1106,     0,   261,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   333,   334,     0,     0,     0,   143,   166,     0,
       0,     0,   267,     0,  2385,     0,  1201,  1198,  1199,     0,
    1204,     0,  1263,     0,     0,     0,     0,   819,     0,   816,
       0,     0,   810,  1956,  2004,     0,     0,     0,     0,     0,
       0,   371,   346,     0,     0,     0,   689,     0,  1549,  1578,
    1556,  1578,  1578,  1545,  1545,  1558,  1547,  1585,     0,  1578,
    1545,  1550,     0,  1548,  1588,  1588,  1573,     0,  1530,  1531,
    1532,  1533,  1559,  1560,  1534,  1565,  1566,  1535,  1602,  2631,
    1545,  2632,  2629,  2628,     0,     0,   700,     0,  1218,  1253,
       0,     0,     0,   553,     0,  2017,     0,   141,   736,     0,
     690,   397,     0,   141,     0,     0,   178,     0,   618,     0,
       0,     0,     0,     0,     0,   638,   637,     0,     0,     0,
     691,     0,   141,     0,   507,  2017,     0,   453,   453,     0,
       0,   939,   942,     0,     0,     0,  2345,  2340,  2343,     0,
    2333,  2347,  1365,  1367,  1366,     0,  1364,     0,   319,   317,
     318,   687,  1049,     0,     0,     0,     0,   319,     0,     0,
    2017,   319,  2017,     0,  2017,     0,     0,   319,   319,     0,
       0,     0,     0,   619,     0,   777,   775,   774,   776,     0,
       0,     0,     0,     0,  2017,   319,     0,     0,   758,  2699,
       0,     0,  2702,     0,  2422,  1818,     0,  2784,  1320,  2785,
       0,     0,  1396,     0,   222,   223,   221,  1309,   224,  1310,
    1306,  1292,     0,   868,     0,  2790,  2791,   853,     0,   863,
       0,  2790,   851,     0,   864,   861,   862,     0,     0,     0,
    2786,  2670,  2676,   867,     0,     0,   454,   456,     0,     0,
    1974,  1987,     0,  2009,  2035,  2036,  2111,  2115,     0,  2138,
    2147,     0,   891,   920,   886,     0,     0,  1348,   858,   856,
    1175,  1313,  1824,     0,  1396,     0,   497,  1056,  1053,  1052,
    1051,   239,   212,     0,     0,     0,   922,  2110,  1190,   831,
     544,     0,     0,  1695,  1696,  1577,  1564,  1865,     0,     0,
    1572,  1571,     0,     0,     0,     0,     0,  1554,  1553,  1552,
    1694,  1832,     0,  1551,     0,     0,     0,     0,  1578,  1578,
    1576,  1625,     0,  1555,     0,     0,  1845,     0,  1851,     0,
       0,     0,  1584,     0,  1582,     0,     0,  1661,     0,     0,
       0,     0,     0,     0,     0,     0,  1609,  1610,  2627,  1692,
    1818,     0,  1693,  1911,     0,     0,  1570,     0,  1602,  1808,
       0,     0,     0,     0,  1878,     0,  1816,     0,     0,  1639,
    1814,     0,  1641,     0,     0,     0,  1807,  1805,  1806,  1799,
    1800,  1801,  1802,  1803,  1804,  1812,  1622,     0,  1887,     0,
    1621,     0,     0,  1467,  1398,     0,  1909,  1868,     0,  2677,
    2680,  1688,  2551,  2550,  2549,  2548,  2519,     0,  2513,  2514,
       0,  2552,  2553,   254,   255,   251,     0,     0,   208,   207,
       0,   230,   231,   202,   229,     0,   225,   226,   210,  1760,
    1759,   209,   201,   199,   197,   213,   215,   216,   200,   198,
     249,   247,     0,     0,     0,  1870,  1869,  1899,  1874,     0,
       0,   319,  2454,  1271,     0,  1268,  1883,     0,  1393,     0,
       0,  1280,  1389,  1388,  1420,  1421,   957,  1387,  1445,  1446,
    1441,     0,     0,     0,  1460,  1458,  1437,  1431,  1436,  1434,
       0,  1438,  1605,  1453,  1377,  1425,  1426,  1429,  1376,     0,
    1456,     0,  1348,  1454,  1430,  1335,     0,     0,  1509,     0,
       0,  2462,  2460,  2400,  1530,  2454,  2393,  2454,  2449,  2381,
    1596,  1597,  1598,  1599,  1600,  1601,  2382,     0,  2379,  1595,
    2380,   525,     0,     0,     0,  2348,     0,  2329,  2354,  2485,
    2594,  2517,     0,  2518,     0,     0,  2482,     0,  2492,  2495,
    2493,  2496,     0,  1530,  2673,  2568,  2673,  1530,     0,     0,
       0,     0,     0,     0,     0,     0,   782,     0,     0,     0,
       0,     0,     0,  2138,   242,  1237,     0,     0,     0,     0,
     924,   923,     0,     0,   944,     0,     0,     0,  1249,   442,
       0,   316,     0,     0,     0,     0,     0,     0,     0,     0,
     685,   682,     0,     0,   681,     0,   557,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   593,     0,  1106,     0,   626,
       0,  1006,     0,  1005,     0,     0,     0,  1007,  1002,  1003,
    2111,  2119,  2143,   244,  1023,     0,  1022,  1020,   979,   981,
     980,     0,   983,   967,     0,   968,     0,     0,   978,   986,
     984,     0,     0,     0,     0,  1997,   273,   286,     0,  1105,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     306,     0,   309,   308,     0,     0,     0,     0,   313,     0,
       0,     0,   312,     0,     0,     0,     0,  1106,     0,   269,
       0,     0,     0,     0,     0,     0,  1036,     0,   164,     0,
     160,   163,     0,     0,     0,     0,   510,   522,     0,   514,
     515,   512,   516,   517,     0,     0,     0,     0,     0,     0,
     509,     0,     0,   616,   615,   621,     0,     0,     0,     0,
       0,     0,     0,  1098,  1097,     0,     0,     0,     0,     0,
       0,   726,     0,     0,     0,     0,     0,     0,     0,   629,
     630,     0,   631,     0,   165,     0,     0,     0,     0,     0,
       0,     0,   220,  1197,  1203,  1266,  1900,  1265,     0,     0,
       0,   818,     0,     0,     0,     0,     0,     0,     0,   820,
     821,   822,   823,     0,     0,     0,     0,     0,   349,   350,
     139,   348,     0,   715,  2628,   688,     0,  1530,     0,  1526,
    1522,  1591,  1590,  1589,     0,  1536,  1545,  1542,   701,     0,
     703,   706,     0,  1216,   415,     0,     0,   550,   593,     0,
     400,   171,     0,     0,     0,     0,   137,   182,   184,   398,
       0,   183,   185,   187,   188,   189,   186,   190,   613,   617,
       0,   546,     0,     0,     0,     0,     0,   639,   643,   642,
     646,   644,     0,   640,     0,     0,  1518,     0,   159,     0,
     503,   506,     0,  2326,     0,   400,   484,   326,     0,   453,
       0,     0,   941,     0,     0,     0,     0,     0,  2346,     0,
       0,     0,     0,  1363,     0,  1027,     0,  1244,  2017,   319,
       0,  1025,   176,  1895,     0,   759,     0,     0,     0,     0,
       0,  1029,   755,   168,     0,   319,   319,   549,     0,   319,
     170,     0,     0,     0,   541,   319,   779,  2700,  2706,  2704,
    1322,     0,  2782,  2783,   453,  1367,  1294,  1305,   865,   872,
     854,   871,   870,   852,   869,   866,  2484,     0,     0,  2675,
       0,   883,     0,   452,     0,     0,     0,   897,   898,     0,
       0,   896,   913,   899,     0,   901,   893,   892,   902,   903,
       0,     0,   922,     0,  1345,     0,  1343,     0,  1507,  1347,
    1336,  1314,     0,  1312,  1317,  1319,  1318,  1316,     0,     0,
     502,     0,     0,   880,     0,     0,   319,  1189,     0,   833,
     834,   840,     0,     0,     0,     0,     0,   841,   837,   838,
     839,   842,   843,   844,     0,     0,     0,  1828,     0,  1829,
       0,     0,     0,  1864,  1860,     0,     0,     0,     0,     0,
       0,  1836,  1837,  1838,  1835,  1839,  1834,     0,     0,  1840,
    1833,     0,     0,     0,     0,     0,  1575,  1574,     0,     0,
       0,     0,     0,     0,     0,  1664,  1697,     0,     0,  1792,
       0,  1818,  1850,     0,     0,  1586,     0,     0,     0,     0,
       0,     0,     0,  1818,  1856,     0,     0,     0,     0,  1758,
       0,  1755,     0,     0,     0,     0,  1875,     0,     0,     0,
       0,  1912,  1606,  1623,  1886,     0,  1877,     0,     0,  1607,
    1630,     0,  1857,  1657,     0,  1662,  1645,     0,  1638,     0,
    1643,  1647,  1626,  1878,  1817,     0,  1815,     0,     0,  1624,
       0,  1619,  1617,  1618,  1611,  1612,  1613,  1614,  1615,  1616,
    1620,  1796,  1794,  1795,     0,     0,     0,  1642,  2011,  2044,
       0,  1410,  1410,  1410,  1397,  1408,  1885,     0,  1513,     0,
       0,     0,     0,  1775,     0,  1822,     0,  1820,  1902,  2682,
    2681,  1876,     0,     0,     0,  1891,     0,     0,  1602,     0,
     248,  1505,  1871,     0,   785,   786,   784,  1530,  1290,  1274,
    1270,  1269,  1882,  1289,  1396,     0,   955,   956,     0,   960,
       0,     0,  1439,  1461,     0,  1452,     0,  1443,  1444,  1435,
    1462,  1457,  1381,  1380,     0,  1516,     0,     0,  1332,  1325,
    1510,     0,  1467,  1350,  1352,  1353,     0,  1875,  2398,  2456,
    2403,  2424,  2394,  2427,  1604,  2376,  2416,     0,  2350,  2520,
    2521,     0,  2511,  2512,  2481,  2487,  2558,     0,  2674,     0,
       0,   713,   712,     0,     0,     0,  1134,  1059,  1110,   783,
    1135,  1060,  1111,  1136,  1061,  1238,     0,  1240,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   664,  2017,   319,  1247,  1137,     0,  1062,   315,
    1248,  1112,  1252,   684,   683,     0,     0,  1113,     0,   558,
       0,     0,   563,   564,   565,     0,     0,     0,   566,     0,
    1956,  2004,     0,   571,   578,   583,   573,     0,   584,   579,
       0,     0,     0,     0,     0,     0,   590,   592,     0,     0,
       0,     0,     0,     0,  1000,  1001,  1138,  1065,     0,  1114,
     982,  1545,   966,     0,     0,   977,     0,   976,  1545,  1545,
    1066,   172,     0,   264,   274,   599,  1108,   292,   305,   300,
     301,   299,  2017,   319,  2017,   319,     0,     0,     0,     0,
     302,   297,   298,   294,   307,  1933,  1989,  2120,     0,   603,
     605,     0,   610,   310,  1080,     0,   327,   330,   311,   290,
     293,   291,   287,   272,     0,     0,     0,     0,     0,     0,
    1898,     0,     0,  1031,     0,     0,     0,   162,  1094,     0,
       0,   148,     0,     0,     0,     0,   142,   152,     0,  1144,
    1070,     0,     0,   266,   505,   513,   518,  1074,   521,  1124,
     519,  1150,  1071,  1106,     0,   262,     0,  1072,     0,  1118,
    1146,  1096,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1255,     0,     0,     0,     0,     0,   319,     0,     0,
       0,  1108,  2017,   319,  1145,     0,  1103,  1132,     0,   335,
       0,  1095,     0,     0,   268,  1076,  1126,     0,     0,   218,
     217,   219,     0,     0,     0,     0,     0,     0,     0,     0,
     825,   794,   824,     0,     0,     0,   788,   370,   344,   345,
     347,   354,   714,     0,     0,     0,  1527,  1523,     0,     0,
       0,     0,     0,     0,  1543,   702,     0,     0,     0,     0,
    1236,  1236,  1236,  1236,  1236,  1236,  1236,  1217,  1245,     0,
     139,     0,     0,     0,   552,   592,   599,     0,     0,     0,
     399,   403,   407,   408,   409,     0,     0,     0,     0,   153,
     140,     0,   744,     0,   453,     0,   184,   177,     0,     0,
       0,   545,   699,   697,   696,   698,     0,     0,     0,   719,
     695,     0,  1517,  1519,     0,     0,     0,     0,     0,   402,
       0,   456,     0,     0,   488,     0,     0,     0,   326,     0,
       0,   971,     0,   989,   972,     0,     0,     0,  1011,  1016,
    1012,   992,     0,   529,  2344,  2338,  1368,  1369,     0,   319,
       0,     0,   594,   319,   319,     0,   319,     0,   319,   319,
       0,  1172,   620,     0,   672,     0,     0,   319,   757,  1819,
       0,  2483,  2671,   884,   455,     0,     0,     0,     0,   895,
       0,   527,   900,     0,   912,   907,   909,     0,   916,  1346,
    1339,  1341,  1340,     0,     0,  1337,  1825,   756,   495,     0,
       0,     0,   319,     0,   917,     0,   835,   836,     0,     0,
     845,     0,     0,  1415,  1826,  1827,     0,     0,     0,     0,
    1861,     0,     0,  1733,     0,  1709,  1711,  1544,  1723,     0,
    1557,  1734,  1735,  1713,  1715,     0,  1809,     0,     0,  1724,
    1666,  1667,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1679,  1678,  1725,  1791,     0,
       0,  1848,  1849,  1726,  1587,  1588,  1588,     0,     0,  1855,
       0,     0,     0,  1731,  1736,     0,     0,     0,     0,  1742,
       0,  1763,     0,     0,     0,  1689,  1819,  1579,  1580,     0,
       0,     0,     0,     0,     0,     0,     0,  1663,  1646,  1640,
       0,  1644,  1648,     0,     0,     0,     0,  1632,  1658,  1628,
       0,     0,  1634,     0,  1659,  1410,  1410,  1410,  1410,  1407,
       0,     0,     0,     0,     0,  1488,  1466,  1468,  1475,  1488,
    1493,  1511,     0,  1892,     0,  1448,  1419,  1419,     0,  1775,
       0,  1698,     0,  1775,     0,     0,  2533,  2535,  2536,  2537,
    2538,  2539,  2541,  2542,  2544,  2545,  2546,  2534,  2540,  2543,
    2547,  2524,  2525,     0,  2515,  2516,   195,     0,   227,   214,
       0,  2558,  1272,     0,  1422,     0,  1810,   960,   958,   959,
    1424,     0,     0,  1459,  1432,  1334,     0,  1332,  1327,     0,
    1328,  1875,     0,  1324,  1357,     0,     0,  1516,     0,  1356,
       0,  2458,  2386,     0,     0,  2557,  2560,  2571,  2569,  2396,
    1133,  1058,  1109,  1236,   927,   928,     0,   926,     0,     0,
       0,   441,   943,     0,     0,     0,   664,     0,     0,   445,
       0,  1250,     0,  1151,  1093,   560,   561,     0,   572,     0,
     581,   580,     0,     0,   568,     0,     0,     0,     0,   567,
     586,   533,   587,   589,     0,     0,   588,   591,   596,  1106,
       0,   627,  1082,     0,  1130,   994,     0,  1545,   969,   974,
     975,     0,     0,     0,   415,     0,     0,     0,   275,   285,
       0,     0,   289,     0,   283,   303,   295,   304,   296,   607,
     608,   606,   602,     0,   609,   611,   324,     0,     0,     0,
    1140,  1106,     0,   270,  1078,     0,  1128,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1141,  1115,
       0,     0,   145,   144,     0,   151,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   336,
     321,     0,   722,     0,     0,     0,   338,     0,     0,     0,
       0,  1139,  1067,   789,     0,     0,   790,   798,     0,     0,
     791,     0,     0,   800,     0,     0,   343,   351,   716,     0,
    2066,  1799,  1800,   710,   717,   707,   709,   708,   711,   664,
       0,     0,     0,  1528,     0,  2772,  2780,  2779,     0,  1602,
     704,   705,     0,  1236,  1235,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   427,     0,     0,   421,
       0,     0,  1016,   414,   417,   418,     0,     0,   553,   556,
     554,   555,   585,     0,   434,     0,     0,   155,     0,     0,
     156,   154,     0,     0,   326,     0,   180,   398,     0,     0,
     645,   648,   641,     0,   718,   720,   693,     0,   599,     0,
       0,  1323,   497,     0,   484,   480,   482,   481,   483,     0,
     490,   325,     0,   497,   490,     0,   944,   970,     0,     0,
       0,  1009,  1013,  1010,     0,     0,   985,     0,   993,   963,
    1167,  1168,  1165,  1166,     0,     0,  2361,  1359,  2370,  1028,
       0,   319,  1026,   760,     0,   751,     0,   753,  1030,   319,
     319,   632,     0,   542,     0,     0,     0,     0,   894,   914,
       0,   910,     0,     0,   877,   919,  1344,  1342,   496,   922,
       0,   878,   921,     0,     0,     0,     0,     0,  1830,  1563,
       0,  1863,  1859,     0,  1706,  1831,     0,  1843,  1842,  1665,
    1844,     0,  1684,     0,     0,  1676,  1674,  1675,  1668,  1669,
    1670,  1671,  1672,  1673,  1677,  1853,  1852,  1846,  1847,  1583,
    1581,     0,  1728,  1729,  1730,  1854,  1737,     0,  1947,  1764,
    1741,  1757,  1756,     0,     0,     0,  1744,     0,     0,  1753,
       0,  1793,  1569,  1602,  1608,     0,     0,  1631,  1858,  1649,
       0,     0,     0,  1627,     0,     0,     0,     0,  1636,  1809,
       0,     0,     0,     0,     0,     0,  1401,  1400,  1406,  1488,
    1493,  1383,     0,  1475,     0,  1487,  1473,  1486,     0,     0,
    1499,  1497,     0,  1499,     0,  1499,     0,  1470,     0,  1489,
    1471,  1486,     0,  1893,  1512,     0,  1450,     0,     0,  1418,
       0,  1775,  1705,  1778,  1773,  1774,  1823,  1699,  1910,     0,
    1821,  1775,     0,     0,     0,  1872,  2556,  1394,     0,  1423,
    1440,  1433,     0,  1514,  1333,     0,     0,  1330,     0,     0,
       0,  1351,  1332,  1354,  2402,     0,  2457,  2522,  2523,     0,
     933,   934,   932,   935,     0,     0,     0,   664,     0,     0,
     461,     0,   951,   951,     0,     0,   447,   493,  1016,   667,
       0,     0,     0,   665,   319,  1063,     0,   582,     0,     0,
     577,   575,   574,   576,   534,  1149,  1064,     0,     0,     0,
       0,   995,     0,   987,  1081,     0,   412,     0,   280,  1107,
       0,     0,     0,   279,     0,   319,   319,   604,   328,   329,
     332,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   745,   728,     0,     0,   746,   747,     0,     0,     0,
    1033,  1034,  1032,   149,   146,   147,   150,  1091,  1075,  1125,
    1073,     0,  1119,  1088,  1084,     0,     0,     0,     0,     0,
    1148,  1102,  1123,  1147,  1100,  1121,  1099,  1120,  1101,  1122,
    1092,     0,  1521,   725,     0,     0,     0,   319,   319,   634,
    1077,  1127,     0,   792,     0,     0,   793,   795,   373,     0,
     376,   383,   355,   360,  1254,     0,  1254,     0,   357,   361,
    1254,   356,  1254,   353,   686,     0,     0,     0,  1524,     0,
       0,     0,     0,     0,     0,  1529,  1537,   663,     0,  1227,
    1226,  1225,  1229,  1228,  1231,  1230,  1222,  1221,  1234,  1233,
    1220,  1219,  1224,  1223,     0,   419,     0,   425,   429,   430,
     428,   420,  1016,   453,   492,     0,     0,   676,     0,   551,
     400,   431,     0,   404,   158,   157,     0,     0,     0,   184,
       0,     0,   650,   654,   694,     0,  1520,   628,   326,     0,
     400,   497,  2327,     0,   405,   410,   411,     0,   488,     0,
     484,     0,     0,   494,  1214,   498,   499,     0,     0,   973,
     990,   991,     0,     0,  1016,  1015,     0,   536,     0,  2334,
     319,   595,   319,   319,  1173,   673,     0,   906,   905,   904,
     528,     0,   908,   319,     0,     0,     0,     0,     0,   847,
     826,   846,  1862,  1722,  1732,  1841,     0,     0,  1685,     0,
       0,  1727,  2209,     0,     0,     0,     0,  1761,  1762,  1743,
       0,  2057,  1748,     0,     0,     0,  1913,  1655,  1653,  1650,
       0,  1651,     0,     0,  1633,  1629,     0,  1635,  1660,  1405,
    1404,  1403,  1402,  1474,  1472,  1477,  1484,     0,  1469,     0,
    1498,  1494,     0,  1495,     0,     0,  1496,     0,     0,  1484,
       0,     0,     0,     0,  1769,  1775,  1775,  1700,  1780,  1777,
       0,  1702,  2526,     0,  2529,  2527,  2528,  2532,  1602,     0,
       0,  1326,  1329,  1331,     0,  1358,  1349,  2459,  1242,     0,
       0,     0,   443,     0,  1016,     0,     0,     0,   954,   954,
       0,  1016,   492,   669,   668,   671,   666,   670,  1251,     0,
     569,   570,  1083,     0,  1131,  1089,   988,     0,   600,   276,
     277,   278,   281,   321,   288,   282,     0,  1079,     0,  1129,
    1086,  1142,  1068,  1116,     0,     0,   734,     0,     0,     0,
       0,  1143,  1069,  1117,     0,     0,     0,     0,  1260,     0,
     320,   724,   723,   321,   337,  1104,     0,   796,   797,   374,
     139,     0,   352,     0,   381,     0,   379,   378,   380,     0,
     367,     0,     0,     0,     0,     0,  1525,     0,  1047,  1047,
    2773,  2774,  2775,  2776,  2777,  2778,     0,   664,  1232,     0,
       0,   416,   492,   460,     0,   422,     0,     0,     0,     0,
       0,     0,     0,   599,     0,     0,     0,   179,   400,   599,
     649,     0,     0,     0,   721,     0,   402,     0,  1321,   401,
       0,     0,   490,     0,   488,     0,   485,     0,   489,     0,
    1207,     0,     0,  1014,     0,  1018,     0,   984,   961,  1513,
       0,   540,  2360,  2364,  1048,   752,   754,   633,   911,   918,
     319,   827,   828,   829,   830,  1680,     0,     0,     0,     0,
    1738,     0,  1739,  1766,  1765,  1745,  1749,     0,  1746,  1747,
    1652,  1656,  1654,  1637,  1476,     0,     0,  1478,     0,     0,
    1480,  1482,     0,     0,     0,     0,     0,  1896,  1775,  1447,
    1449,     0,  1384,  1703,  1704,     0,  1419,  1775,  2531,  2530,
     228,  1811,  1515,  1355,   912,     0,   319,   951,   492,   462,
    2066,   463,   950,     0,   952,   957,   957,     0,   492,   664,
     562,     0,   598,     0,   323,   331,     0,     0,     0,   741,
     729,     0,     0,   748,  1085,     0,     0,     0,     0,     0,
     319,   799,   354,     0,   377,   386,     0,   384,   358,   363,
       0,   365,   364,   359,   362,  1047,     0,  1044,  1043,   662,
       0,   451,   423,     0,   471,     0,     0,   677,     0,     0,
       0,   440,   439,   436,   435,   437,   438,   433,   432,   624,
     738,   326,  1214,   612,   651,   652,   647,     0,     0,     0,
     484,   480,   406,   415,   389,     0,   490,   486,   487,     0,
       0,     0,  1262,     0,   945,  1017,     0,     0,     0,   535,
       0,     0,   539,   530,     0,  2362,   879,  1681,     0,  1682,
       0,     0,     0,  1751,  1750,     0,  1485,  1501,     0,  1481,
    1479,  1490,     0,  1492,  1768,  1770,     0,     0,  1783,  1701,
     929,     0,   930,   954,   466,     0,   953,   960,   960,   453,
     664,   444,  1090,   601,     0,   284,  1087,     0,   732,     0,
     743,   741,     0,     0,  1256,     0,  1257,  1258,  1261,   339,
     342,   372,   382,     0,   366,  1042,  1046,  1045,     0,     0,
     424,   457,   458,   459,     0,   426,   467,   468,     0,   674,
       0,   679,     0,     0,     0,     0,     0,  1208,     0,     0,
    1209,   488,   484,   413,   479,   387,     0,  1211,     0,   326,
       0,  1016,  1019,  1171,   538,   537,  2365,  2367,  2366,     0,
    1683,  1754,  1740,  1767,  1752,  1483,     0,  1491,     0,     0,
    1779,     0,     0,     0,     0,   957,     0,   664,     0,   948,
     947,   460,   446,   322,     0,     0,   739,   742,   730,   743,
     750,   749,     0,   385,     0,   450,     0,     0,     0,   469,
       0,   470,   491,     0,   678,     0,   599,   737,     0,     0,
     653,     0,   490,   488,  1212,  1213,   490,   946,   962,  1170,
    1169,  1396,  2363,  1500,  1771,  1772,  2174,     0,  2149,     0,
    1781,  1784,  1782,  1776,   319,   960,     0,   448,   464,   471,
       0,     0,   731,  1259,   654,   476,     0,   475,     0,   473,
     472,   675,   680,   625,   727,  1210,   657,   390,   490,  1513,
    1153,  1396,  1152,  1154,  1162,  1159,  1161,  1160,  1158,     0,
    1788,  1787,  1786,  1790,  1789,   931,   949,     0,   664,   733,
     740,     0,   474,   478,   477,     0,   655,   658,   661,   659,
     660,   388,   936,     0,  1163,  1157,  1383,  1370,     0,   465,
     449,     0,   635,     0,  1155,  1396,  1785,     0,   656,  1156,
       0,   657,     0,   636
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   248,   249,  1734,  2661,  2540,  3369,  3370,   250,
     251,  1806,   252,   253,   254,   255,   256,   257,   258,  1750,
     259,   260,  1307,  1956,  2671,   261,  2404,  1075,  1076,  2274,
    2275,  2603,  2276,  2263,  1585,  2058,  1769,  1736,  1770,   263,
     264,  1579,  2255,   265,   266,   267,  1794,  1795,  1744,  2001,
    4282,  4885,  2522,  3406,  3205,  3206,   268,  1852,  1853,   269,
     270,  3320,  1893,  2630,  3856,  3857,  4313,   878,  2627,  4590,
    4591,  4299,  4300,  4597,  4776,  4777,  2672,  1952,  3400,  3944,
    3360,  4383,  3361,  4384,  3362,  4385,  3348,  3903,  3904,  3905,
    3363,  4361,  4807,  3364,  2419,  4910,  2706,  2088,  2086,  4794,
    4179,  4180,  4967,  4915,  4916,  4917,  5039,  4390,  3404,  3950,
    4393,  4625,  3102,  1976,  2820,   977,  2708,   909,   978,  2673,
     275,  2700,  1826,  1827,  2548,  3863,  3462,   276,  1326,  3730,
    4671,  4842,  4843,   277,   866,   278,  1960,   279,   280,  2657,
    3354,   281,  2436,  3119,   282,   283,  3146,  3147,  3148,   284,
     285,  3754,  4547,  1796,  3198,  3199,  3200,  3201,  3774,   286,
    1958,  1832,  2680,   287,   288,   289,   290,   291,  2591,   292,
     293,  2674,  1968,  2692,  2693,  4373,  4641,  4816,  4643,  5075,
    5076,  4617,  3709,  4193,   295,   296,  4356,  4357,  4922,   297,
    2434,   298,   299,   300,  1936,  2649,  2650,  3864,  1720,  1896,
    2632,  2633,  3933,  3934,   301,  3280,   302,  4241,  4242,   910,
    4925,  4890,  4978,   303,   304,  4245,  4246,   305,   306,   307,
     308,   309,   965,  1379,  1380,  1726,   310,  2291,   311,  1280,
    3311,   312,  1468,  2845,  4430,   313,  1001,  1404,  1405,  2675,
     315,  1012,  2823,  1014,  2101,  3464,  3465,  4004,  2791,  1200,
     316,   317,  2802,  2826,   318,  1737,  2410,  2411,  4174,  2676,
     911,  1982,  2711,  3097,  4833,  4181,  4528,  4745,  3019,  3660,
     320,   912,  1774,  2484,  2714,  3412,  3413,  2486,  2984,  3965,
    2488,  3414,  3419,  3420,  3421,  3961,  3969,  4665,  4666,   321,
    1772,  2477,   322,   323,   324,  1803,  1219,   325,   933,   934,
     326,  4787,   327,  1345,   328,  1033,  2118,   329,  2500,  3760,
     330,   331,   332,  5052,  5083,  5084,  5085,  3974,  5011,   333,
    5054,  1446,   335,   336,   337,   869,  1246,  1247,  1248,  2677,
    4660,   339,   340,  2653,  3347,  3885,   341,   342,  2405,  3087,
     343,   344,   345,  1940,   346,   347,   348,   349,  1872,   350,
    1616,  1617,   351,   352,   873,  1094,  1620,  1628,   353,   980,
    1398,  1399,  1400,  2060,   354,  1450,  2813,   981,  1393,   982,
    3038,  3669,  3670,  3673,   983,  3035,   358,  2107,  2807,  2810,
     984,  3042,  3043,  3044,  3045,  3046,  3675,   985,  1003,  1336,
    2722,   986,  1539,   363,   364,   365,  1103,  1098,  1099,   367,
    2233,  2974,  1020,  1634,  1060,  1110,  4129,  2304,  2305,  2327,
    2328,  1643,  1644,  2317,  2319,  3021,  2320,  3029,  2310,  4126,
    4494,  2323,  2324,  1646,  1647,  1648,  2332,   368,  2978,  3606,
    3607,  3608,  4105,  4106,  4120,  4116,  4481,  4710,  3609,  1440,
    1654,  3610,  3615,  3667,  3391,  3392,  3393,  2489,  2640,  1918,
    1540,  1919,  2647,  1541,  2153,  1921,  1542,  1543,  1544,  1924,
    1545,  1546,  1547,  1548,  2136,  2196,  1549,  1550,  2172,  1142,
    1143,  2045,  2884,  1552,  1553,  4069,  4454,  4443,  2910,  2911,
    2271,  4065,  3557,  4722,  4864,  4865,  4137,  4134,  4498,  4726,
    4963,  5020,  5021,  1554,  2964,  2225,  1221,  1555,  3866,  2227,
    2904,  2986,  2987,  2389,  2134,  2850,  2867,  2868,  2881,  3518,
    2888,  2893,  3541,  3542,  2905,  2933,  1556,  2853,  2854,  3501,
    2138,  1557,  1609,  1610,  2241,  2928,  1623,  1624,  1096,  1558,
    1559,  2102,  1085,  4706,  1355,   703,  3219,  2286,  1250,  1017,
    1560,  1561,  1562,  3466,  1675,   665,   704,   705,  1180,   817,
       2,    75,   987,  3398,   372,   373,   914,   915,   916,  1328,
    1329,  1987,  1990,  1680,  2367,   669,   670,   721,  4409,  4672,
    4845,   971,   374,   375,   376,   377,  1676,  2363,  1144,    76,
      84,    77,  1145,   414,   415,  2345,   378,   834,   379,  1657,
    1124,  3681,   380,   381,   382,   383,   384,   968,   385,  1126,
     386,  1127,   387,   388,   389,   390,  1134,   391,  1659,  1660,
    4166,  1661,   392,   393,   707,   708,  1391,   394,   395,  1161,
    1162,  1423,  1424,  1686,  1701,  1702,  1703,   396,   677,   397,
     398,   399,  1692,  1693,   400,  2248,  2249,  2372,  2250,   401,
    3059,  3060,   402,  3641,  3642,  4505,  3643,   403,  2244,   404,
     405,  1088,  3686,   406,   830,   407,  1175,   709,   710,   711,
    1182,   820,  1046,   722,  1184,  3202,   822,   823,   713,   714,
     715,  2080,    78,  3067,  2081,  1564,   723,  1565,  2239,  1566,
    1567,  1568,  1569,  1570,  1709,   717,  1151,  1383,  1384,  3068,
    1386,    82,  1387,   411,  3878,  2048,  1425,  2066,  2067
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4443
static const int yypact[] =
{
   -4443,   356, 13230, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, 25257, -4443,
   -4443, -4443, -4443, -4443, 98267,   434, -4443, -4443, -4443,102672,
   -4443, -4443, -4443,   317, 65219, -4443, 68135,   913, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, 71537, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, 54515,  1269, -4443,
     778, -4443, -4443, -4443, -4443, -4443, -4443, -4443,  1496, 14480,
   -4443, -4443, 68621, -4443,   110, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, 69107,   578, -4443, -4443,   927,  1245, -4443,   100,
   14011, -4443, -4443, 61817, 66191, -4443, -4443, 72023,   452,  2021,
    7527,  1496, 24768, 72509, -4443,   896, -4443, 51071, -4443, -4443,
   -4443, 65705, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, 79313,  2598,  1074, 51566, -4443, -4443,
   -4443, -4443, 79313, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, 72995, -4443,  1295,  1100,  1011, 79799, 80285,
   63275, -4443,  1428, -4443, 79313,  1458,  1167, 53541, -4443, 80771,
   -4443, -4443,  1331, -4443, 73481, -4443, -4443, -4443, -4443,  1074,
   -4443, 54515, 50097,    70,  1277, -4443, -4443, 81257, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443,  1886,  1339, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443,   578, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443,   759, -4443,   685,   765,  1938,   642,  1394, -4443,
   -4443, -4443, 21866, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   23123,  1645, -4443, -4443, -4443,  1482, -4443,  1426, -4443, -4443,
   -4443,  1653, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,   924,
   -4443, -4443, -4443, -4443,  1998, 98750, 71537, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, 61331, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
     178, -4443, -4443, -4443, -4443, -4443, 71537, 71537, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, 71537,  1576, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443,   309,  1844, -4443, -4443,
   54515,  2128,  2128,  2059, 23123, -4443, -4443, -4443, 55489, 79313,
   79313, 79313,  1791, 79313,  1719, 79313,   254, 55489,106437, 81743,
    1867,  1804, 45629, -4443,105601, 79313, 79313, 82229, 79313, 73967,
   79313,  1928, 79313, 79313,106855, 82715,  2002, -4443,  2293,  1674,
   -4443, -4443, -4443, 79313, 14856,  2598, -4443, -4443, 79313,  1851,
   55489, 79313,  1785, 79313,  1903, 79313, -4443, 79313,  1920, 83201,
     513,  1895,106437,  2025, 46128,  2023,106437, 83687, 79313, 79313,
   -4443, -4443,  1985, 79313, 79313, -4443,  2107,107273,  1982,  2115,
    2286,  2168,   724, -4443, -4443,  2372,  1959, -4443, -4443,  2405,
   71537, -4443, 69593, -4443, -4443, -4443,  2203, -4443, -4443, -4443,
   -4443, -4443,103929,  2021, -4443, -4443, 55976, 79313,  2237, -4443,
   -4443, 84173, -4443,  2054, -4443,   646, 56463, 84659,  2345,  2053,
   46627,  2374, 85145, 85631, -4443, -4443, 86117, -4443, 86603,  2148,
   87089, -4443, 87575, -4443,  2295, 88061, -4443, 16076, -4443,  2067,
    2138,  2080,  1091, 71537, 71537,    95,100552, -4443, -4443,   578,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,   139,  1707,
   52061,   730, 52556, -4443, -4443,   817,   843,   911,   139,  2516,
    2516,   558, 71537, -4443, -4443,  1707, -4443,   530,   771,  2111,
    2111,  2111,  2299,   -75, -4443,  2111, -4443, -4443, -4443, -4443,
   73481, 52061, 52556, -4443,  2074,  2598,   182,  2517,  2162, 79313,
   -4443, 79313, -4443, 79313, 79313, -4443, -4443, -4443,  2507,  2142,
    2384, -4443,  2161, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
    2329,  2339,  2366,   109,  2598,  2244, -4443,  2477, -4443,  2396,
   29729,   441, 71537,  2598, 53051, 74453, 95837,   273,103929,  2598,
   88547,  2240,  1563,  2415, -4443, -4443,   681, -4443,  2646,  2265,
    2495,    35,  1674, 43170, -4443,  2264,  1912, 73481, 99716, -4443,
   -4443, -4443, -4443,   189,  2551, 30233, -4443, 79313,  2275, -4443,
    2263,  2281,  2284,  1938, -4443, 79313,  1493,  1493,  2664,  1493,
    1968,  2004, -4443,  2123, -4443,  2566,  2530, 73481,  1277,  1496,
    2288, -4443, -4443, -4443,  2300, -4443,  2314,  2321, -4443,   882,
    2546, -4443, -4443, -4443, -4443,  2413,  2418,  2423,  2430,  2338,
    2443,   192, -4443, -4443, -4443, -4443,  2680, -4443, -4443, -4443,
   -4443, -4443, -4443,  2779,  2769,103093,103093,   723,   726,   154,
     242, -4443, -4443, -4443,  2653, -4443, -4443,  2672, 79313,  2493,
   79313, -4443, -4443, -4443, 89033, -4443, -4443,  2128,  2300,  2464,
   -4443,   313, -4443,  1912, -4443,   329,   348,   357,  1897,  2440,
    2001,  1543, -4443,   574, 79313,  2561,   302,   953,  2513, 74939,
    4641,  2476,   779,  2773,  3870,   192, 89519, -4443, 79313, 79313,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,  2481,
   -4443, -4443,  2489,  2758,  1364,  2701,  1909,  2816,  5604,  1907,
    2821,  4351,  2259,   766,  2713,   933,  2825,  2077,  2839,  4524,
   79313,  2557, -4443,  2776,  2888,    13, -4443,   791, -4443,  2631,
    2764,  1088, 55489,  2583, -4443, -4443, 79313, -4443, -4443, -4443,
    2661, -4443,   665, 55489, -4443,  2786,  2632, 47126, -4443, 79313,
   -4443, -4443, -4443, -4443, -4443,  2718, 79313, -4443, -4443,  2840,
   79313, -4443,  2111,  2759,  2610,  2986, 58898,   296, 79313,  2650,
    3017, 79313,  2814,  2650,  2651, 90005, -4443, -4443,  2650, -4443,
   -4443, 79313, 79313,  2619,  1502,  2650,  2817,  3015,  3018,  2689,
    2797,   880,  1578,   102,  2914,  2650,  2670, 79313, 90491, 79313,
    2671, 79313,  2990, 55489, 79313, -4443,  2785, 75425, -4443,  2629,
    2372, -4443, -4443, -4443, -4443, -4443,  1157, -4443, -4443, -4443,
   -4443,  2938,  2464,   160,  2939,  2644,  2941, -4443, -4443,  2677,
   -4443,  2943,  2476,  2944,  2647, -4443, 90977, -4443, 91463, 91949,
    2947,  2481, 79313,  2951,  2647,  2955,  2842,  2957,   160,  2958,
   -4443,   912,  2959,  2847,  2962,  1797,  2647,104347,  2963,   114,
   -4443, 17198, 16076, -4443, 24225,  1054, -4443, -4443, -4443, -4443,
   -4443, -4443, 33761,   861,  2752, -4443, -4443, -4443,  1977, -4443,
  101825, -4443,    95,  1707, -4443, 71537,  1707, 71537,   558,  1707,
   71537,  1707, 71537,   558,  1707, 71537, 71537, 71537,  1707, -4443,
   -4443,  1756,  1991, -4443, -4443, -4443, -4443, -4443, 71537,  2669,
   79313, 79313, -4443, -4443, -4443, 66677, 79313, 67163, -4443, -4443,
      33, 71537, -4443, 71537, -4443,  2598, -4443, -4443,  2138, 58898,
    3073, 79313, 79313,  2960,  2960,  2960, -4443, -4443, -4443,  2897,
   79313,  2964,  2965, 66677, 79313, -4443, 92435,103929,  2857,  2678,
   -4443, -4443, -4443, -4443,  2003,  2658,   408,  2766, 33761,  2681,
     175,   175,  2682,  2968, -4443, -4443, -4443,   391,  2684,  2688,
   -4443,   435,   435,  2836,  2690,  2691, -4443,   445,  2693, -4443,
    2826,   488,  2694,  2697,  2705,  2068,   175, 33761, -4443,  2706,
     435,  2708,  2710,  2711,  2905,  2723, -4443,  2916,  2724,   286,
     299,  2725,  2727, -4443,  2690, -4443,   427,  2729,  2730,  2731,
    2733,  2735,  2736,  2737,  2738, 33761, 33761, -4443, 28721,  1912,
    2598, -4443, -4443, -4443, -4443, -4443, -4443, -4443,    93, -4443,
     514,  5570, -4443, -4443,  2861, 33761, -4443, -4443,    45, -4443,
     522, -4443, -4443,  1912, -4443, -4443,  1292, -4443, -4443, -4443,
   -4443,  1685,  1685,   196, -4443, 68621, 68621, -4443, -4443,   177,
    2704, -4443,   305, -4443, -4443, -4443, -4443, -4443, -4443,103511,
    3113, -4443,  1001,  2598,   791,  1040,  3071,100973,101399,  2981,
    2981,  2970, -4443, -4443, 79313, -4443, -4443, 33761, 49123, -4443,
    1912,    82,  2984, -4443, -4443, -4443,  2031, -4443, -4443, -4443,
     578, -4443, 13810, -4443,  2100,  2275, 79313, 79313,  3142, -4443,
   -4443,  2263, -4443, -4443,  1938,  1938, 33761,  1938,   676,  1777,
   30737, 33761,  3033,  2933,  1255,  1349,  3035, -4443,  2937,  1968,
    2004, 73481, 79313, 92921,  2859, -4443, -4443,  2300,  2765,  1794,
   -4443, 60845, 99233, 99233,  3002, -4443, -4443,  1627,  1425,  2875,
    2966,  2516,  1110,  1769, -4443, -4443,  2760, -4443,  3090, 68621,
    2818,103093, -4443, -4443, 79313, -4443, -4443, 75911, -4443, -4443,
   -4443,   828,  2761, -4443,  2782, 79313,  3260, -4443,  1769,  1769,
   -4443, -4443,  2768, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, 23123,  2772, 79313, -4443,  2778,  2781, -4443, 99716, 49610,
    2015,  1912,  2853,  2856,  2892, 54515,  2783,  2858,  2860,  2902,
    2862,  2863, 96323, -4443, -4443, -4443, -4443,  1546,  1220,  1391,
    2864,   345,   748,  3149, -4443,  1564,  2917, -4443, -4443, -4443,
    3775, 79313,  3091,  4602,  2982,   192,  2918, -4443, -4443,  3027,
    2876,  2878,  2996,   192,   169, 96809, -4443, -4443, -4443, -4443,
   -4443, -4443,  2542, 27235, -4443,  2880,  2869, 79313, 62303,  3171,
    2991,  1057,  1059,   141, 79313,  3065,  3004, 79313,  2820,  2895,
    2896,  2824,  1812,  3183,  2827, -4443, -4443,  3000,  3128,  5347,
    2885,  2887, 57924,  1271, 47625,  3174,  1670,  2919, -4443,  1670,
   79313,  2920,  2923, 79313,   192, -4443,  3227,   192,   192,  1960,
    3236,  2931,   301,  1878,  2650,  2827,  1279, -4443,  2932,  2934,
    1651, -4443,  3037, 73481,   304,  1918,  2827,  2936,  2940,  2824,
    2824, 79313, 79313, 79313, 79313, 79313,   127,  3258,  3259,  2942,
     180,  2988,  2867, -4443,104765,  2945, 95837, -4443, -4443, 79313,
    2946,  1940,  2827,  1929, -4443,  2008, -4443, -4443, -4443,  1674,
   -4443, 79313, -4443, 79313,  2464, 58898,  3055, -4443,  2907, -4443,
    2476,   192, -4443, 79313, 79313,  2481,   923,  1036,  3061, 79313,
    3119,  2915, -4443,  1124, 49610,  2619, -4443,  2882, -4443,  2930,
   -4443,  2930,  2930,  2890,  2890,  2894, -4443, -4443,  2068,  2930,
    2890, -4443, 59872, -4443,  1664,  1800, -4443,  3292,  3296, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,   986, -4443,
    2102, -4443, -4443, -4443, 79313, 54515, -4443,  3307, -4443, -4443,
   58898,  3081,  3199, -4443, 79313,  3100,  2908, -4443,  3233,  2961,
   -4443, -4443,   -13, -4443,  3206,106437,   210,  2598,  2952, 79313,
    3129, 79313, 79313, 79313, 79313, -4443, -4443,  3102,  1305,   190,
   -4443,104765, -4443, 79313,  1279,  3114,  3319,    -1,  2111, 79313,
    3208, -4443, 79313,  2921,  3324,  3159, -4443, -4443,  2926,  2516,
   -4443,  2629, -4443,  1954, -4443,  3047, -4443, 55489,   160, -4443,
   -4443, -4443, -4443, 58898, 79313, 93407, 55489,   160, 79313, 79313,
    3226,   114,  3228,  2983,  3229,  2987, 47625,   160,   148, 79313,
   79313, 79313, 79313, -4443, 79313, -4443, -4443, -4443, -4443, 79313,
   79313, 79313,104765,  3230,  3234,   160, 79313, 79313, -4443, -4443,
   18899,  1902, -4443, 16076, -4443, 13810,  2134,  2981, -4443,  1576,
   79313,  1479,    95,105183, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, 71537, -4443, 71537,   558, -4443, -4443, 71537, -4443,
   71537,   558, -4443, 71537, -4443, -4443, -4443, 71537, 79313,  3433,
    2949, -4443,  1292, -4443, 79313,  2145, -4443, -4443,  2156,   946,
   79313, 79313,   750, 55489, 79313,  3130, 79313, 79313, 79313, 79313,
   79313,  3016,  2704,  1111, -4443,   454, 73481,  3138, -4443, -4443,
   -4443, -4443, -4443,  2175,  1886,   842,  2995, -4443, -4443, -4443,
   -4443, -4443, -4443, 67163, 65705,  3238,   284, 79313, -4443, -4443,
    3593, 33761, 29225, -4443, -4443, -4443,  2967, 13810,  2985, 33761,
   -4443, -4443, 33761,  2969,  2516,  2516, 33761, -4443, -4443, -4443,
   -4443,  2497,  2516, -4443, 33761, 33761,  2516,  2516,  2930,  2930,
   -4443,  4329, 33761, -4443, 47625, 33761, 35273, 26730, 33761,  3039,
    2989,  2516, -4443,  2516, -4443, 33761, 28217, -4443, 33761,  3168,
   36281, 33761,  1040,  3169, 33761,  1040,  3386,  3386,  1277,  1869,
    7716,  2971,  1912, -4443,  3075,  2516, -4443,  2516,   999,   166,
   58898, 33761, 54515,  3046,   232, 79313, 33761,  2976,  1574, -4443,
   33761,   214, -4443,  2978, 33761,  3045, 33761, 33761, 33761, 33761,
   33761, 33761, 33761, 33761, 33761, -4443, 37261,   237, -4443,   606,
    1835, 67649, 29729,  3262, -4443, 26225, -4443,   208, 71537, -4443,
   -4443,  1912, -4443, -4443, -4443, -4443, -4443,   828,  2994, -4443,
    3003, -4443, -4443, -4443, -4443, -4443, 79313,  3113, -4443, -4443,
    3063, -4443, -4443, -4443, -4443,   635, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443,  2998, -4443, -4443, -4443, -4443,  2998,
   -4443, -4443,  2981,  2993,  5004, -4443, -4443, -4443, -4443,  3269,
    3270,   160, 23123, 79313,   189, 70079, -4443, 30233, -4443,  2184,
    3006, -4443,  3251, -4443,  3007, -4443, 10954,  3251, -4443, -4443,
     150,  3116,  3244,  3196, -4443, -4443, -4443,  3023, 13810, -4443,
    2079, 13810,  2118, -4443, -4443, -4443, -4443, -4443, -4443,  1742,
   -4443, 79313,  3138,  3033,  1349,  3079,   626, 79313, -4443, 43660,
    2024, -4443,  2300, -4443, -4443, 23726, -4443, 25740, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443,  3030, -4443, -4443,
   -4443, -4443,   192,  3031,  3502, -4443,103093, -4443, -4443, -4443,
    3433, -4443,  2405, -4443,  2405,  3532, -4443, 71537, -4443, -4443,
   -4443, -4443,   885, -4443, 16076, -4443, 16076, -4443,  3034,  2199,
    3110,  3112,  3160,106437, 79313, 79313, -4443, 54515,106437, 79313,
   79313,106437, 79313, 79313, -4443,  3400,   827, 65705,  3164, 63761,
   -4443, -4443,  3049, 79313,  3099,  3286,  3287,   940, -4443, -4443,
   93893, -4443,  3245,106437, 79313, 79313, 33761,  3246, 79313, 79313,
   -4443,   375,  3127,  3131, -4443, 79313,  3132, 55489,  3056, 79313,
   79313, 79313,  3134,   668, 55489,  3101, 48124, 79313, 79313, 79313,
   79313,  3176, 79313, 79313,  3295,  1247, 73481,   125,  2019,  2827,
    3257, -4443,   658, -4443,106437, 79313,  3249, -4443, -4443, -4443,
   64247,  3461,  3170, -4443, -4443, 97295, -4443, -4443,  3247, -4443,
   -4443, 59872, -4443, -4443,  2206, -4443, 59385, 56950, -4443, -4443,
     932,106437, 79313,  6919, 79313,  1070, -4443, -4443, 58898, -4443,
   79313, 79313, 79313, 70565, 94379, 94865,  1117,  1188, 79313, 71051,
   -4443, 79313, -4443, -4443, 55002,106437, 79313, 54515, -4443, 79313,
    3252,   831, -4443, 79313,  8592,  3145, 79313,   240,  2042,  2827,
   79313, 79313,  3074,  2249,  3152,  3200, -4443, 79313, -4443,106437,
    1503, -4443,  3218,106437, 79313,  6449, -4443, -4443,   192, -4443,
   -4443, -4443, -4443, -4443, 79313, 79313,   192, 79313,   192,  1024,
   -4443,106437, 79313, -4443, -4443, -4443,  6966, 79313, 79313, 79313,
   79313,106437, 79313, -4443, -4443,  1180,  1540,  1457,  1536,  3221,
   79313,  3351, 79313, 95351,106437, 79313, 79313, 79313,  1776, -4443,
   -4443,  3197, -4443,106437,  1503,  7083, 79313, 79313,  3162,  3163,
     128,  3237, -4443, -4443, -4443, -4443, -4443, -4443,  3330,  3492,
   79313, -4443,  3334,  3335,  3150,  3151,  3336,  2044, 79313, -4443,
   -4443, -4443, -4443, 79313,  3339,  2044,  3284,   499, -4443, -4443,
    2650, -4443,  2253, -4443,  3115, -4443, 33761,  3504, 58898,  3107,
    3108,  3181, -4443,  3184,  2516, -4443,  2262, -4443, -4443,  2276,
   -4443,  3122,  1305,  1733, -4443, 54515, 79313,   556,   775,  3407,
   62789,  3204,  3398, 79313,  3155, 79313,  3204, 79313, -4443,  1468,
   65705, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
    3399, -4443,  2598,  2619,  2619,  2619,  2619, -4443, -4443, -4443,
   -4443,  3303,  1621, -4443,  3120,  2619, 79313,  3232,  3204,  3123,
   -4443,  1279,  3415,  3421, 79313, 62789,  2172,  3165,  3525,  2111,
    2598,  3310, -4443, 27726,  5018,  3311,103929, 75425, -4443,  3136,
    3401,  3404,  3417, -4443,  2464, -4443,  3537, -4443,  3434,   160,
    2476, -4443,  2647, -4443, 79313, -4443, 79313, 79313, 79313, 79313,
    2481, -4443, -4443,  2647,  3322,   160,   160, -4443,  3323,   160,
    2647,  3254,  3427,103929, -4443,   114, -4443, -4443, -4443, -4443,
   -4443, 33761, -4443, -4443,  2111,  1954, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, 71537,  2405, -4443,
    2296, -4443, 79313, -4443,  3408,  3409,  3410,  2647,  3144,  3186,
   79313,  3154, -4443,  2647,   192,  2647,  2704,  2704,  2647,  3144,
  106019,  3564,  3432,   623, -4443,   845,   547,  3366, -4443, -4443,
   -4443, -4443, 58898, -4443, -4443, -4443, -4443, -4443, 79313,   973,
   -4443,   184,  3342,  3161,106019,  3548,   160, -4443, 55489, -4443,
   -4443, -4443,  3239,  3250, 55489,  3354,  3210, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443,  3405, 79313,  2297, -4443,  1963, -4443,
    1976, 33761, 33761,   333, -4443, 12479,  2306, 33761,  3173,  3175,
    2307, -4443, -4443, -4443, -4443, -4443, -4443,  3177,  3459, -4443,
   -4443,  3180,  2312,  2316,  3185,  3187, -4443, -4443,  6298,  3188,
   12516,  3189, 35273, 35273,  1614, -4443, -4443, 35273,  3190, -4443,
    2320, 11549,  3179,  3193,  3201, -4443,  3195,  3202, 12528, 31241,
   33761, 31241, 31241, 12823,  3179,  3203,  2327, 54515,  3352, 13086,
    2342, -4443, 33761, 54515,  7284, 33761, -4443, 33761, 79313,  3207,
    3209, -4443, -4443,  4329, -4443,  3214, -4443, 35273, 35273, -4443,
    2726, 28721, -4443, -4443,  3478, -4443, -4443,   996, -4443,  3205,
   -4443, -4443,  4108,   287, 33761,  2976, 33761,  3274, 47625,  2992,
   33761,  5527,  5019,  5019,  1006,  1006,   158,   158,   158,  1661,
    1835, -4443, -4443, -4443,  3213,  2723, 33761, -4443,  2429,  2433,
   79313,  9086, 10285, 10748, -4443, -4443, -4443, 38759,  3253, 33761,
   33761, 33761,  3217,  3374,  3620, 13810,   890, -4443,  3625, -4443,
   -4443, -4443,   236,  3532,   828, -4443,  1674,  2516,   999,101825,
   -4443, -4443, -4443, 33761, -4443, -4443, -4443, -4443,  2263, -4443,
   -4443, -4443, -4443, -4443,  1886, 33761, -4443, -4443,   621,  2158,
   33761,  2079, -4443, -4443,  3263, -4443, 33761, -4443, -4443, -4443,
    2704, -4443, -4443, -4443, 38759,  3256,  3266, 42680,  3343, -4443,
   -4443, 79313,   297, -4443, -4443, -4443,  3235, -4443, -4443, -4443,
     -92, -4443, -4443, -4443, -4443, -4443, -4443,  3222, -4443,  3224,
   -4443,  3241, -4443, -4443, -4443, -4443,   171,  3231,  3240,  3243,
    1600, -4443, -4443,106437, 79313, 79313, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443,  3450, -4443, 79313, 79313,
    3413, 79313,  3412,  3418, 33761,   794, 79313,  3242,  3261,  1233,
    3494, 79313, -4443,  3531,   160, -4443, -4443,  3312, -4443, 13810,
   -4443, -4443, -4443, -4443, -4443,106437, 79313, -4443,103929, -4443,
    2464, 58898, -4443, -4443, -4443, 79313,  3271, 79313, -4443, 79313,
   79313, 79313,  2481, -4443, -4443, -4443, -4443,  1142, -4443, -4443,
   79313, 79313,   607,  3313,  3315, 79313, -4443,   979,  3037,  8252,
   79313, 79313, 79313,  3495, -4443, -4443, -4443, -4443,  3436, -4443,
   -4443,  2102, -4443, 56950, 59385, -4443, 59385, -4443,  2102,  1633,
   -4443,  2647,  3321,  2827, -4443,  3428,  1300, -4443, -4443, -4443,
   -4443, -4443,  3545,   160,  3547,   160, 79313, 79313, 79313, 79313,
   -4443, -4443, -4443, -4443, -4443, 54515, 54515, 54515,  2352, -4443,
   -4443,  2598, -4443, -4443, -4443,  2367, -4443,   971, -4443, -4443,
   -4443, -4443, -4443, -4443,106437,  8378, 79313, 79313, 79313,  2260,
   -4443,   864, 58898, -4443, 58411,106437, 79313, -4443, -4443,  3477,
    3422, -4443,  2165,  3424, 79313,  3317, -4443, -4443,  3331, -4443,
   -4443,  3338,  2129,  2827,  1279, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443,   253,  2131,  2827,  3340, -4443,  3344, -4443,
   -4443, -4443,  3484,  3485,  3486,  3348,  3349,  3384,  3350,  3353,
    3397, -4443,  3355,  3402,  3356,  3403,  3362,   160, 58898,  3482,
    2598,  3396,  3586,   160, -4443,  3367, -4443, -4443,  3686, -4443,
   79313, -4443,  3368,  2154,  2827, -4443, -4443,106437, 79313, -4443,
   -4443, -4443,  2044, 58898,  3534,  2044,  2044, 79313, 79313,  2044,
   -4443, -4443, -4443,  3535,  3536,  2044, -4443, -4443, -4443, -4443,
    2759,  3298, -4443,  2203, 45130,  7772,  3302,  3108,  3300,  2516,
   41210,  1384,  3508,  3305, -4443, -4443, 54515, 45130,  1751,  3524,
    3320,  3320,  3320,  3320,  3320,  3320,  3320, -4443,  1531,   111,
    2650,103929, 79313,103929, -4443,   775,  3428, 79313, 79313,  3316,
    3301, -4443, -4443, -4443, -4443, 79313,    99, 79313,  2516, -4443,
   -4443,  3379, -4443, 79313,  2111,  3709,  3018,   210,  3454,  2110,
    3656, -4443, -4443, -4443, -4443, -4443, 79313, 79313,  1305,  2598,
   -4443,  3325,  3326, -4443, 79313, 79313, 79313, 79313,  1886,  3327,
    3332, 58898,    22,  3505,  3506,  2824,  3723,  1886,  3165,  3406,
   79313, -4443,  2373,   116, -4443,  2598,103929, 57437, -4443,  4370,
   -4443, -4443,   703,  3596, -4443, 79313, -4443, -4443, 42190,   160,
   58898, 79313, -4443,   160,   114,  3380,   160,  3383,   160,   160,
   79313, -4443, -4443, 79313, -4443, 79313,104765,   160, -4443, 13810,
    3619, -4443, -4443, -4443, -4443,  3455,  3456,  3457, 79313,  2647,
   55489, -4443,  3337,106437,  1451, -4443, -4443,  3514, -4443, -4443,
   -4443, -4443, -4443,  3639,  3640, -4443, -4443, -4443, -4443,  3678,
   79313, 66677,   159,106437, -4443,  2464, -4443, -4443,  2476,   192,
   -4443, 79313,  3583, -4443, -4443, -4443,  3359,  2377, 13280, 33761,
   -4443,  3651, 58898, -4443,  7916, -4443, -4443, -4443, -4443, 33761,
   -4443, -4443, -4443, -4443, -4443, 33761, -4443, 33761,  3630, -4443,
    3778,  3778, 58898, 35273,  1773,  2708, 35273, 35273, 35273, 35273,
   35273, 35273, 35273, 35273, 35273, 37765,   507, -4443, -4443, 33761,
   33761,  3644,  3630, -4443, -4443,   410,   410, 58898,  3361,  3179,
    3363,  3365, 33761, -4443, -4443,  2382, 36771,  3370, 54515, -4443,
   33761, 12149,  2398,  3414, 13543,  1912,  8049, -4443,  3733,  2598,
   33761,  1566,  2280, 33761,  2403, 33761,  3643, -4443, -4443, -4443,
    3372, -4443, -4443, 58898, 33761, 35273, 35273,  6316, -4443,  6625,
   33761,  3373,  6695, 28721, -4443,  1074,  1074,  1074,  1074, -4443,
   79313, 79313, 79313, 39249, 38269, 76397,  3364,  2016, -4443, 76397,
   76883, -4443,  3375,  1912, 33761,  3648,   -23,   -23,  3377,  3374,
   44150, -4443, 33761,  1565, 31745,  3385, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443,  3378, -4443,  3381, -4443, -4443,   791,  3387, -4443, -4443,
   11030,   171, -4443,  3388, -4443,  3390, -4443,  2158, -4443, -4443,
   -4443,  8317,  3565, -4443, -4443,  3364, 32249,  3343, -4443,  2408,
   -4443, -4443, 29729, -4443, -4443,  2412, 43660,  3256, 30233,  1912,
    2516,  3416, -4443,  2405,   236, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443,  3320,  2647,  2647,   739,  2647,  3672,   739,
    8840, -4443, -4443, 39739, 79313, 79313, -4443, 79313,  2421,  1317,
   79313, -4443, 79313, -4443, -4443, -4443, -4443,  3791, -4443, 79313,
   -4443, -4443,  3445,  3446, -4443, 79313, 79313, 79313, 79313, -4443,
   -4443,  2440, -4443, -4443,106437, 79313, -4443, -4443, -4443,   263,
    2231,  2827, -4443,  3469, -4443, -4443,  3645,  1754, -4443, -4443,
   -4443,  3462, 79313,  3423, -4443,  1246,  2824,   929, -4443, -4443,
    3464, 79313, -4443, 79313, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, 55002, -4443, -4443, -4443, 54515, 45130, 54515,
   -4443,   331,  2255,  2827, -4443,  3474, -4443,  3475,  3480,  3523,
    1334,   124,  3481,  3483,  3527,  3426,  3429,  3437, -4443, -4443,
     139,  2598, -4443, -4443,  2598,  2647,  2598, 79313, 79313, 79313,
   79313, 79313, 79313, 79313, 79313,  3695,   781,  1919,106437, 79313,
   79313,106437, 79313, 79313, 79313, 79313, 79313, 79313, 79313, -4443,
    3782,  3721,  2137,  3748,  3498, 79313, -4443, 79313,  3037, 79313,
   79313, -4443, -4443, -4443,  3438,  2044, -4443, -4443,  3668,  3674,
   -4443,  2044,  2044, -4443,  1124, 54515, -4443,  1675, -4443,  3115,
    3390,  2516,  1769, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
    2516,  2251,  3441, -4443, 41700, -4443, -4443, -4443,  2247,   999,
   -4443, -4443, 79313,  3320, -4443,  1899,  2447,  2518,  2539, 77369,
   77855, 78341,  3443, 79313, 79313, 35273, -4443,  1515,   163, -4443,
    3679, 79313,  3471, -4443, -4443, -4443,  3597, 79313, -4443, -4443,
   -4443, -4443, -4443,  3451, -4443,  3555, 62789,  2647, 79313, 79313,
    2647, -4443, 58898,  3452,  3165,106437,   210,  1569, 90491,  3487,
    3458,  3739, -4443,  3463,  3467, -4443, -4443, 79313,  3428,  2425,
     596,  2080,  2995, 64733,  2172,  3713, -4443, -4443, -4443,  3815,
    3542, -4443,  1886,  2995,  3542,  2598,  3099, -4443, 56950, 33761,
   33761, -4443,  3468, -4443,  3466,  5317, -4443,  2619, -4443, -4443,
   -4443, -4443, -4443, -4443,  3541, 79313,  3895, -4443, -4443, -4443,
    3476,   160, -4443, -4443, 79313, -4443, 79313, -4443, -4443,   160,
     160, -4443,  3585, -4443,  1886, 79313, 79313, 79313,  2647, -4443,
     192, -4443,  3751,106019, -4443, -4443, -4443, -4443, -4443,   284,
    3758, -4443, -4443,  3720,  3724,  3726,  3727,  2174, -4443, -4443,
   33761, 13810, -4443,  3488, -4443, 13810,  8980, 13810,  3644, -4443,
    1937,  3762, -4443,  1624,  3490,  1937,  2707,  2707,   243,   243,
     117,   117,   117,  3778,   507, 13810, 13810, -4443, -4443, -4443,
   -4443,  3493, -4443, -4443, -4443,  3179, -4443, 34265,  3626,  3874,
   -4443, -4443, -4443,  3538,  3543,  3497, -4443, 33761, 34769,  3496,
   59872, -4443, -4443,   999,  1143, 35273, 35273,  2564, -4443,   755,
   33761, 58898,  2442,  2564,  2371,  3360, 33761, 33761,  7132,   259,
   33761,  9114, 79313, 79313, 79313, 79313, -4443, -4443, -4443, 76397,
   76883, 40719,  2016,  3500, 79313, -4443, -4443,  3516, 38759,  3741,
    3680, -4443, 38759,  3680,  1802,  3680,  3744, -4443, 44640, -4443,
   -4443,  3517, 26225,  1753, 13810,  3901,  3789, 33761,  3519, -4443,
    3520,  3374, -4443, 97781, -4443, -4443, 13810, -4443, -4443, 33761,
   -4443,  3374,   236,   551,  2598, -4443, -4443, -4443, 47625, -4443,
   -4443, -4443,  3710, 13810, -4443,  1886, 79313,  1912,   620,  3539,
   79313, -4443,  3343, -4443, -4443, 16076, -4443, -4443, -4443,   139,
   -4443, -4443, -4443, -4443,  3599, 65705,  3803, -4443, 33761,  2445,
   -4443,  3561,  3894,    96,  2450,  2454,  1317, -4443,  3471, -4443,
    1527,  3785,   218, -4443,   160, -4443, 58898, -4443, 79313, 79313,
   -4443, -4443, -4443, -4443,  2783, -4443, -4443, 79313, 79313, 79313,
   79313, -4443,  3598, -4443, -4443, 54515,  1531,  3725, -4443, -4443,
    3728,   139, 79313, -4443, 58898,   160,   160, -4443, -4443, -4443,
    3549, 79313, 79313, 79313, 79313,106437, 79313, 79313,  2516,  2516,
   58898,  3529, -4443,  2516,  2516,  3540, -4443,106437, 79313, 79313,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443,  3609, -4443, -4443, -4443, 79313, 79313, 79313, 79313,  3834,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, 79313, -4443, -4443,  2598,  2598, 58898,   160,   160, -4443,
   -4443, -4443,  3779, -4443,  2044,  2044, -4443, -4443,   346,  2458,
   -4443,100134, -4443, -4443,  3017,  2598,  3017,  1548, -4443, -4443,
    3017, -4443,  3017, -4443,  1317,  3546,  1623,  3817, -4443,  2188,
   41700, 41700, 41700, 41700, 41700, -4443, -4443,  3821,   139, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, 33761, -4443,  1408,  1937, -4443, -4443,
   -4443, -4443,  3471,  2111,  3594, 55489,  1139, -4443,  3806,   556,
   62789,   966, 79313, -4443,  2647,  2647,  3600, 79313,  3949, -4443,
     858, 79313,  3860,  3589, -4443,  2598, -4443, -4443,  3165, 79313,
   62789,  2995, -4443,  2462, -4443, -4443, -4443,  3588,  3506,  3556,
    2172,  1447, 79313, -4443,  3595, -4443, -4443,  3835,  3563, -4443,
   13810, 13810,  2598, 60359,  4370, -4443, 79313,  3819, 79313, -4443,
     160, -4443,   160,   160, -4443, -4443, 79313,  2647,  2647,  2647,
   -4443,  3747, -4443,   160,106019,  2174,  2174,  2174,  2174, -4443,
   -4443, -4443, 13810, -4443, -4443, -4443, 35273,  3849, -4443,  3572,
   58898, -4443,  3573,  2491,  2494, 36281,  3717, -4443, -4443, -4443,
    9867,  3628, 13810,  3676,  3582,  3584, -4443,   969,   969,   755,
    2498, -4443, 35273, 35273,  2564,  2564, 33761,  2564, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, 76397,  3587, 79313,  2016, 38759,
   -4443, -4443,  1380, -4443, 38759,  3820, -4443, 38759, 79313,  3590,
   79313,  1012, 33761, 33761,  3624,  3374,  3374, -4443,  3757, -4443,
    3591, -4443, -4443,  1769, -4443, -4443, -4443, -4443,   999,  3592,
   71537, -4443, -4443, -4443,  1277, -4443, -4443, -4443, -4443,106019,
    3776,106019,  1317,  9937,  3471, 39739, 48623, 79313, 78827, 78827,
    3737,  3471,  3594, -4443, -4443, -4443, -4443, -4443, -4443,  3603,
   -4443, -4443, -4443,  3671, -4443, -4443, -4443,  2499, -4443, -4443,
   -4443, -4443, -4443,  3782, -4443, -4443, 45130, -4443,  3673, -4443,
   -4443, -4443, -4443, -4443, 40229, 47625, -4443,  1334,  3601,  3605,
     124, -4443, -4443, -4443, 79313,  1532,   -32,  3641,  2647,  3891,
   -4443, -4443, -4443,  3782, -4443, -4443,  2044, -4443, -4443, -4443,
    2650,  3930, -4443, 54515, -4443,102251, -4443, -4443, -4443,  2598,
   -4443,  2598,  3801, 50584,  2598,  2598, -4443, 55489,  4011,  4011,
   -4443,  2051,  2051, -4443, -4443, -4443, 79313, -4443, -4443, 10067,
    3805, -4443,  3594,  3831,  3879, -4443,  3631, 79313,  3771,  3632,
    3623,   361,   361,  3428, 79313,  2505,  1886,   210, 62789,  3428,
   -4443,  1526,  3633,  3922, -4443,  4026,  3327,  3627, -4443, -4443,
   64733,  3808,  3542, 79313,  3506,  3756, -4443,  3759, -4443,  1082,
   -4443, 79313, 39739, -4443, 59385, -4443,  2508, -4443, -4443,  3253,
   79313,   785, -4443,  3649, -4443, -4443, -4443, -4443, -4443, -4443,
     159, -4443, -4443, -4443, -4443,   669, 35273, 58898,  2511, 33761,
   -4443, 33761, -4443,  4018, -4443, -4443, -4443,   879, -4443, -4443,
   -4443,   969,   969,  2564, -4443, 79313,  2512, -4443, 33761,  3642,
   -4443, -4443, 38759,  1380,  2520, 79313,  2525, 58898,  3374,  3179,
   13810, 79313, -4443, -4443, -4443,  4022,  3816,  3374, -4443, -4443,
   -4443, -4443, -4443, -4443,  1451,   739,   159,  3894,  3594, -4443,
    3646, -4443, -4443, 79313, -4443,   768,   768, 79313,  3594, -4443,
   -4443, 79313, -4443, 54515,  3693, -4443, 79313, 58898,  2476,    75,
   -4443, 58898, 58898, -4443, -4443, 79313, 79313, 79313, 79313, 79313,
     160, -4443,  3298,  2598, -4443, -4443,  2531, -4443, -4443, -4443,
   79313, -4443,  3458, -4443, -4443,  4011,  1049, -4443, -4443, -4443,
    2047,  3841, -4443,  1436,  3826,  3729,  3647, -4443, 55489,  4071,
    3761, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,
    3939,  3165,  3595, -4443, -4443, -4443, -4443, 33761,  3804,  1886,
    2172,  3713, -4443, -4443, -4443,  2534,  3542, -4443, -4443,  4021,
    3837,  4023, -4443,  2535, -4443, -4443,  5317, 60359,  3975, -4443,
    3711, 79313, -4443, -4443,  2641,  4084, -4443,   669,  2538, -4443,
    2541,  2544,  3809,  3716, -4443,  2548, -4443, 13810, 79313, -4443,
   -4443, -4443,  2549, -4443,  3661, -4443,  4066, 33761,  1570, -4443,
   -4443,  3950, -4443, 78827,  3708, 47625, -4443,  2158,  2158,  2111,
   -4443,  1317, -4443, -4443, 33761, -4443, -4443,  2565, -4443,    40,
    3822,  3958,  2570,  2573,  3144,  3714,  3144, -4443,  2647, -4443,
   -4443, -4443, -4443,102251,  3458, -4443, -4443, -4443,  3985,  3931,
   -4443, -4443, -4443, -4443,   363, -4443,  3859,  3861, 79313, -4443,
    3682, -4443,  2574, 79313, 79313,  4083,  4087, -4443, 10432, 55489,
   -4443,  3506,  2172,  1531, -4443, -4443,  3868, -4443,  3872,  3165,
   39739,  4370, -4443,   213, -4443, -4443, -4443, -4443, -4443, 79313,
   -4443, -4443, -4443, -4443, -4443, -4443,  2577, -4443, 79313,  3694,
    3179, 32753, 32753,  3697,106019,   768,  3699, -4443,  3701, -4443,
   -4443,  3831,  1317, 13810, 55489,  4078, -4443, -4443, -4443,  3822,
   -4443, -4443, 79313, -4443,  3823, -4443,  1183,  1183,  4019, -4443,
    3763, -4443, -4443,  3702, -4443,  4130,  3428, -4443,  1334,  1886,
   -4443,  3706,  3542,  3506, -4443, -4443,  3542, -4443, -4443, -4443,
   -4443,  2057, -4443, -4443, -4443, -4443, 35777,  3839,   207, 11879,
   -4443, -4443, -4443, -4443,   159,  2158, 33761,  1317, -4443,  3826,
    2476, 79313, -4443, -4443,  3589, -4443,  4122, -4443,  1066, -4443,
   -4443, -4443, -4443, -4443,  3529, -4443, 54028, -4443,  3542,  3253,
   -4443,  2036, -4443, -4443, -4443, -4443, -4443, -4443, -4443,  4114,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, 10548, -4443, -4443,
   -4443,  4014, -4443, -4443, -4443,  2584, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443,  1581, -4443, -4443,  1619,  2284, 33257, -4443,
    1317,  3869, -4443, 54028, -4443,  2036, -4443, 55489, -4443, -4443,
    3731, 54028,  2587, -4443
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4443, -4443,  3856, -4443, -1181,    65,  2375, -1116, -4443, -4443,
   -4443,  3005, -4443, -4443, -4443, -4443, -4443, -4443, -4443,  3029,
   -4443, -4443,  1567, -2545, -4443, -4443,   -45, -1589,  1579,  2637,
    1238, -4443, -1395, -4443, -4443,  -890,    14, -1040, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -1060,  1716,  1065,  1636,
   -2841, -4443, -1655, -3273, -4443,   467, -4443, -4443,  1659, -4443,
   -4443, -4443,   928,   395,  -522, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443,  -340, -4443, -4443,  -648,   167,  -106, -2555,  -388,
   -4443, -4443,   343,  -390, -1603, -4443, -3599, -4443,   -85, -4443,
   -4443, -4443,  -370, -1704,  1168, -4443,  -991, -1379,  1483,  -707,
   -4443,  -257, -4443,  -760,  -647,  -644,  -714,  -546, -3774, -4198,
   -3785, -3145,  1177, -4443, -3734,   222, -4443, -4443,   324,   337,
   -4443, -4443, -1783, -1707, -4443,  -866, -4443, -4443, -4443, -3046,
   -4443, -4443, -4443, -4443,   -97, -4443, -4443, -4443, -4443,   369,
   -4443, -4443, -4443, -4443, -4443, -4443, -2806,  1622,  1625, -4443,
   -4443, -3265, -4443, -1197, -4443,   508, -3086,  1086, -4443, -4443,
   -4443,  2328, -4443, -4443, -4443, -4443, -4443, -4443, -1870, -4443,
   -4443,   350, -4443,  1635,   897, -4443, -4443, -4443,  -746,  -811,
    -802, -4443, -3565, -4443, -4443, -4443, -4443,  -333, -4443, -4443,
   -4443, -4443, -4443, -4443, -1264, -4443,   960, -3211, -1232, -4443,
   -4443,   974, -4443, -4443, -4443, -4443, -4443,  -700,  -267,  2353,
   -4443,  -589,  -676, -4443, -4443, -4443,  -266, -4443, -4443, -4443,
   -4443, -4443, -4443, -1342,  8981, -1842, -4443, -4443, -4443, -4443,
   -2542, -4443, -4443, -4443, -2114, -4443,  4118,    26,   145,   362,
   -4443,  -202,   -81,  2870, -1398, -2738,   303,  -426, -4443, -2060,
   -4443, -4443, -4443, -2662, -4443, -4443, -4443, -4443, -3538,   368,
   -4443, -4443, -4443,   353, -4443, -4382, -3994, -4268, -4281, -3539,
   -4443, -4443, -1337, -4443, -4443, -4443, -1648,  1823, -1733, -4443,
   -2429,   354, -3798, -1020, -3306, -4443, -3743,  -523, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443, -1354,  -884, -4443, -4443,  3382,
   -4443, -4271, -4443, -4443, -4443, -4443,  1298, -4443, -1703,  1035,
   -4443, -4443, -4443, -4443, -4443,  -693,  -775, -4443, -4443, -4443,
     376, -4443, -4443, -4443, -4443,  2436, -1202, -1005,  3248,   383,
    -491, -4443, -4443, -4443, -4443, -3111, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -1903, -4443, -4443, -4443, -4443, -4443, -4443,
   -4443,  2028,  2029,  -104,  -209, -4443, -4443, -1529, -4443,  -822,
   -4443,  2270, -4443, -4443, -4443, -4443,  1311,   415,   385,   -67,
   -4443, -4443,   172, -3473,   -57, -4443, -4443, -4443, -4443,  1995,
     -56, -4443,   656, -4443, -4443, -2891, -4443,   417,   -80,  2948,
    1571,   -65,   419,  -246,  -227,  -219,   -69,  3264,  2709, -4443,
   -4443, -4443,  -204,  1966, -4443, -1110,  -362, -4443,  1318,  -929,
    2000,  2695,  2698, -4443,  1319, -4443, -4443,  1316, -4443, -4443,
   -4443,  -928,  2011, -4443,  2700, -4443, -4443, -4443,  1306,  1313,
   -3452,   745, -3446, -3411,   250,   241, -1007,  -359,  -140,  3272,
    2712,   754, -4442,   674, -4443, -3506, -2448,  4677, -2167, -1859,
   -4443, -4443, -1432,  4651, -4443, -4443, -4443,  5627, 10677, -4443,
   -4443, 11044, 14829, -4443, -1257,   790, 16568,  3760, -1465, -1890,
   -1547, 17948, -1720,  2582, -2880, -4443, -4443, -4443,  -329,   806,
      12, -4443, -4443, -4443, -4443,  -591, -2894,  -587, -4443, -4443,
   -4443,  -594, -3408, -2073, -4443,  -823, -4443, 19790,  1352, -4443,
   -1320, -2822, -2832, -1402, -2016, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -1672, -3346,  -315,  1429, -4443, -4443,  1520, -4443,
   -4443, -4443, -1556, -1146, -2750,  1432, -2191, -4443, -1106,   704,
    2147, -1061,  5640,  3268, 16120,  -126, -2368, -1537, -1786, -4443,
    1894, -4443,  2122,  3696,  -139,  -926,  4951,  3877,  4551, -3191,
   -4443, -4443,   418, -4443, -4443, -4443,  3752,   955, -4443,  3053,
   -4443,  1669,  2397, -4443, -4443,  2026,  -952,   -59, -4443,  -562,
   -4443,  -123, -4443, -4443, -4443,   156, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443, -4443, -4443,  2732, -4443, -4443, -1476, -4443,
   -4443, -4443, -4443, -4443,  4008,  -305, -4443,  3430,  -282, -4443,
   -4443, -4443, -4443, -4443, -4443, -4443, -4443, -4443,  2739,  2048,
   -4443,  3215, -4443, -4443, -4443,   -51,  2950, -4443, -4443, -4443,
   -1220,  -597,  3267,  3273,  2018, -4443, -4443, -4443, -4443, -4443,
   -4443, -4443, -4443,  2030, -4443, -4443,  1404, -2144,  2027, -4443,
   -4443,   720, -4443, -4443,   264, -4443,   721, -4443,  2835, -4443,
   -4443, -4443,   757, -4443, -4443, -4443,  -502, 13348,   -48,   -94,
     149,  1194, -4443,  7795,  7690,   165,  2748,   -14, 10966, 18244,
     -17, -4443,  3996,  2032,  1634, -1030, -4443,  1568,  2333, 17250,
   -4443, -1022,   146,  1870, -4443,    -2,  -683, -1210,  3038,  -758,
   -1997, -4443,  4409, -4443, -3620, -4443, -1064,  3419, -1201
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2633
static const yytype_int16 yytable[] =
{
      81,  1102,  1111,  1649,  1580,  2057,  1338,  2017,  1052,   366,
    1303,   356,  1655,   361,  2011,  2007,   719,  1602,  1432,  1433,
    1434,   357,   359,   818,  1438,  1087,   725,   913,  1005,  1220,
     408,   925,  1831,  2792,  2418,   706,   408,  1721,  2645,  1950,
    2487,  1159,  1337,  1808,   908,  1870,  2759,  2113,  1005,  1970,
    1401,  2085,  1895,  2637,  2288,  2174,  1857,  3165,  3167,  2147,
    2148,   979,   871,   964,   409,  2125,  1361,  1594,   818,   408,
     409,  1220,  2046,   706,  2497,  1121,   410,   927,  2163,  2505,
    1026,   867,   410,  3316,  1084,  2605,  3482,   674,  2646,  3621,
    1013,  3912,   262,  2886,   917,   924,   366,  3611,  1122,  3736,
     825,  2697,  2301,  2992,   924,  3359,  3012,  2886,  1938,  3769,
    1998,  3771,  1943,  3968,   408,   410,  2849,  1947,  4149,  2560,
    2352,  2354,  2355,  3377,  1953,  2485,  3881,  1220,  1163,  1053,
    1704,  2569,  3277,  3867,  1972,  3954,  2518,   818,  1706,  1113,
    3468,  4186,  1338,  1105,   924,   825,  3867,  1114,    79,  3618,
    3674,   919,  4102,  1396,  3611,  4216,  2967,  3616,  3617,  4354,
     410,  4176,  2751,  3221,  4119,  2288,  3565,  4404,  1825,  4396,
    4388,  1836,  1074,  2047,  2042,  2496,  2473,  3050,  1587,  1862,
    1771,  1642,  1645,   408,  2573,  2574,  2346,  2346,  2396,  4529,
    4652,  2701,  1048,  1002,  4154,  4047,  2712,  1858,  4117,  1154,
    1048,  3685,  1048,  1682,  1683,  3522,  2246,  1049,  4382,  1385,
    1969,   417,  2072,  1002,   825,  1049,  3066,  1049,  2191,  4395,
    3070,   877,   417,  2140,  2141,    45,   417,  4838,  2194,   410,
    3886,  3887,  3888,  3889,  3890,  3891,    45,  1332,  2289,  4527,
     413,  2580,  1999,  2506,  3626,   271,  2200,  3627,  3628,  2160,
   -1578, -1578, -1578, -1578,  4319,   972,  1695, -1578,  3629,  3630,
    3631,  4746,  3632,  3633,   417, -1797,   819,  3634,  3635,  3636,
    2499,  2203, -1797,    43,   973,  1674,  1999,  3299,    45,  1696,
    4834,  2105,   821, -1903, -1903, -1903, -1903,  1999,  1999,   868,
   -1903,  1891,   130,   131,  2585,  3372,  3959,  3679,  4889,  1092,
     272,  2205,  1421,   366,  4314,   356,   974,   361,  2921,  1108,
   -1578,   819,  2231,  5009,   417,   357,   359,    37,    38,    39,
      40,  2704,  3906,    43,    44,  1470,  1697,   821,    45,  2049,
    1176,  3522,   408,  2943,  1164,  3918,  2961,  1464,  4788,  1797,
    1867,  3737,  4766,  2962,  2926,  4350,   675,  3946,    37,    38,
      39,    40,  2664,  2468,  4243,    44,     3,  1150, -1813,  1436,
    2253, -1588, -1588, -1588, -1588, -1813,   409,   408, -1588,  3436,
    2669,  3438,  4975,  -139, -1588, -1588, -1588, -1588,   410,  1573,
     819, -1588,  -139,  1885,  3128,  2499,   262,  -139, -2631, -2631,
   -2631, -2631,  1870,  2192,  2694, -2631,   821,  1747,  2499,  2926,
    4536,   409,   273, -2631, -2632, -2632, -2632, -2632,  2499,  3637,
    1448, -2632,  3480,   410,  3330,   274,  1613,  2237,  1614, -2632,
    1589,  3680,  2254, -2629, -2629, -2629, -2629,  1198,   294,  5061,
   -2629,  4976, -2628, -2628, -2628, -2628,  1437,  2469, -2629, -2628,
     314,  2257,  4767,  2670,  1220,  4532,   319, -2628,   416,  2499,
    2174,  1338,  4244,  1584,   334,  2665,  4826,  2567,  2944,  2290,
    4801,   338,  2945,   206,  4877,  4878, -2223, -2223, -2223, -2223,
    3327,  2147,  2148, -2223,  1338,  5010,  2499,  3113,  2163,  2009,
    4351, -2223,  3919, -1578, -1578, -1578, -1578,  2035,  4127,   216,
   -1578,  1868,  2000,   355,  2234,   360,   371,   362,  2424,  1748,
    2946, -2055, -1573, -1573, -1573, -1573,   913,  2705,  4802, -1573,
   -1545, -1545, -1545, -1545,  4905,  4803,  2507, -1545,  2825,   224,
   -1558, -1558, -1558, -1558,  1934,  2977,  2000, -1558,  2508,  1178,
    2517,  2616,  3499,  -375,  2059,  2280,  2281,  2000,  2000,   271,
    3638,  1338,  4804,  2612,  2106,  1460,   835,  2803,  4986,  3737,
    2695,   928,  1122,  1157,  1158,  5062,  2232,   234,  5007,  3150,
    1685,  1688, -1573, -1585, -1585, -1585, -1585,  4229,   879,   237,
   -1585,  1148,  1165,   917,  3300, -1797,   676,  2129,  1093,  2509,
    2061,  3907,  4169,  1802,   362,  3639,   836,  3867,  2581,    37,
      38,    39,    40,  2106,   272,  3522,    44,    37,    38,    39,
      40,  2195,  1607,   247,    44,  4965,  1608,  5082,   247,  4622,
    1935,  3960,  4522,  4805,  2586,  1691,  4654,   924,   924,  2947,
    1437,  3534,  2637,   417,  2041,  2037,    37,    38,    39,    40,
     919,  2635,    43,    44,  1155,  2565,  2288,    45,   999,  1000,
    2135,  2556,  2608,  2558,  2140,  2141,  2963,  4648,  3169,   999,
    1000,  4368,  2160,  2927,  4119,  1615,  4478,  2247,  3020,  2009,
    4482,  4668,  2224,  1338,  2804,  1150,  1101,  2604, -1813,  1738,
    4003,  1338,  1338,  4377,  3216,  1717,  4537,  3330,  1199,  3640,
    1156,  2288,  4435, -1578,  5025,  2991,  1294,  3810,  4473,  4516,
    1449,   999,  1673,  2459,  2755,  1437,   273,  4207,  2696,  2259,
    4611,  4612,  4613,  4614,  4615,  2780,  1207, -2055,  3585,   274,
      37,    38,    39,    40,  1607,  1191, -1903,    44,  1608,  1231,
    2333,  2334,   294,  3611,  3611,  4132,  2264,  3318,  3702,  2368,
    1102,  2277,  2277,  5002,   314,  3749,   818,  3750,  2568,  2529,
     319,  1698,  1699,  4873,  3531,  3532,  3533,  3534,   334,  2788,
    3114,  1650,  2476,  3164,  3151,   338,  1749,  3522,  2799,  1289,
    3843,  2169,  3244,  3846,  3847,  4231,  2538,  3850, -2055,  2541,
    1402,  1739,  4328,  3853,  2169,  1733,  3524,  1279,  4806,  2425,
    2170,  4738,   408, -2055,  3351,  1112,   408,   355,  4748,   360,
     371,   362,  4140,  2170,  2171,  2009,  1163, -2359,   929,  1334,
    -139,  -139,  4589,  2852,  1935,  5048,  3036,  2173,  3676,  2886,
    2886,  2846,  2848,   825,  2886,  1347,   831,  4987,   832,  1349,
     409, -2631,  2856,  4182,  3217,  1421,  2860,  1115,   410,  2763,
    2042,  3926,   410,  3469,  2872,  2873,  1187, -2632,  1878,  2805,
    3651,  3126,  3154,  2200,  3732,  1187,   674,  2890,  2892,  1403,
    3645,  1409,   674,  1414,  2886,  2886, -2629,  2806,  2906,  1418,
    3079,  1150,   674,   924,  2770, -2628,  1394,  4824,  2203,  3052,
    2773,  3052,  1397,  2135,  1747,  1571,  1113,  3016,  1187,   930,
    1439,   931,  1409,  1414,  1114,  2169,  2473,  1421,  3970,  2461,
     674,  3174,  1106,  1395,   674,  3865,  2308,  2467,  2205, -2223,
     417,  2876,  2877,  1116,  2170,   674,   366,  1664,  3865,  1596,
    1408,  1390,  1413,  1740,    45,   924, -1578,  1841,  4379, -1371,
    2536,  4157,  1427,  2789,  1335, -1374,  3155,   724,  2426,  4407,
     674,  2412,  3473,  3319,  1187, -1573,  1572,  1295, -2633,  3848,
    3849,  1442,  1444,  2146,  1187,  3352,  1741,  1439,  2546,  3655,
    1107,  2549,  2550,  2152,  1323,  1842,  3017,   417,   993,  3790,
      37,    38,    39,    40,  3971,    81,    43,    44,  1470,  1697,
    4170,    45,  3210,  1242,   674,  1742,  1748,  1653,   994,   819,
    2487,  1220,  4714,  2762,  4716,  2309, -2359,  2707,  3966,  1618,
    1684,  2965, -1371,  1687,  2560,  1167, -1585, -2005, -1374,   130,
     131,  3474,  2414,  1150,  4266,   706,  3529,  3530,  3531,  3532,
    3533,  3534,  3141,  1577,  1422,  2613,  1407,  1108,  1412,  2415,
     216,  1583,  2197,  3353, -2633,  1591,  3470,  4707,  1846,  4704,
    2235,  1961,  4711,  1743,  1847,  4713,  2796,  2797,  4941, -1545,
     408,  4935, -2359,  2192,   872,   993,  4931,  1441,  1443,  1048,
     224,  4503,  4790,  1048,  1472,  3471,   972,  3522,  1187,  1753,
    2427,  3791,  1243,  2025,  1049,   994,   674,  3733,  1049,  1962,
    1350,   993,    35,   417,  1612,   973,    37,    38,    39,    40,
      41,    42,    43,    44, -2037,  3142,   410,    45,   234,  1879,
     833,   994,  3127,  1187,  2200,  4840,  1117,  3972,  3968,  1135,
     237,  2026,  4219,  1244,  4380,  4645,  1843,   974,  3648,  2426,
   -2056,  1324, -1545,    79,  2966,  1597,  1210,  1211,  1212,  2203,
    1213,  1214,  1215,  1216,  1217,  1218,  1429,  1401,  1421,  4548,
    1848,  2232,  2740,  1109,  3037,  4171,  1410,  2428, -1371,   993,
    1415,  1416,  1417,  2997, -1374,  1665,  3478,  2416,  2790,  2205,
    1428,  1775,  1245,   674,   674,  4267,  3211,  3973,  5003,   994,
    4906,  2641,  3520,  3521,  4172,  1136,  1325,  3536,  3529,  3530,
    3531,  3532,  3533,  3534,  2641,  4631,  1598,  2784, -2081,  1422,
    2704,  2261,  1422,  4173,  4881,  1029, -2005,  2619,  3576,  4853,
    3577,  1460,  2617,  1220,  1844,  2269,  2551,  4871,  5008,    37,
      38,    39,    40,  3792,  2499,  1735,    44,  3571,  3572,  4862,
    3088,  4829,  2504,  3578,  3334,  4632,  3141,  5047,  3000,  4830,
    1963,  5049,  1108,  1137,  4933,  2620,  1138,  1136,  3611,  1985,
    2766,  2200,  3611, -1371,  2270,  3145,  3793,  4497,  3524, -1374,
    1136,  4220, -2005,  2417,  4627,  4841,  5073,  4501,  3472,  2618,
    1187,  1735,  2027,   874,  2219,  2220,  2221,  2222,  2223,  2224,
    4859,  1187,  1030,  5081,   206,  3794,  1058,  1907, -1371,  4515,
    3030, -1371,  1849, -2037, -1374,  3262,  2818, -1374,  1992,  1430,
    2879,  3263,  3089,  3479,  1933,  1137,  2205,  1677,  2642,  3142,
     216,  2262,  1102,  3725,   826,  4140,  4907,  3525,  1137, -2056,
    4491,  2642,  1869,  4293,   827,  1850,  1707,  4500,  1964,  4296,
    4297,  5035,  3271,  3579,  2238,  4972,  1139,  1160,  3580,  3747,
     224,  1187,  2552,   891,  2553,  2063,  3169,  2065,  1993, -2037,
    2069,  3726,  2071,   366,  1851,  2074,  2075,  2076,  4969,  4970,
    2028,  1220,  2785,  4221,  1108,  4755,  4222,  4423,  2083,  3865,
    4628,  1677,  1704,  2009,  -780, -2056,   969,  2412,   234,  1059,
    1706,  2108,   975,  2109,   417,  3867,  4638, -2081,  4809,  4854,
     237,  2786,  4831,  2413,  4813,   674,  2621,  3264,  1139,    81,
      81,   893,    81,  5074,  1698,  1699,  3439,  4749,  -501,  1390,
    1187,  1139,  3434,  3433,   362,  1101,  3100,  1028,   674,  3623,
    3999,  3624,  5027,   828,   976,  1814,  2383,  2302,  2303,  2358,
    2307,  2295,  2359,  1140, -1900,  1114,  1114,  1994,  1114,  3382,
    3383,  3384,  3385, -2081,  3236,  1089,  2421, -1545,  2414,  1122,
    2487,  3390,  1141,  3173,  1031,  1032,  3581,  2517, -1545,  3145,
    2146, -1545,  1725, -1545,  2502,  2415,  3582,  1933,  3101,  3321,
    2886,  1815,  1163,  2886,  2886,  2886,  2886,  2886,  2886,  2886,
    2886,  2886,  2886,  1725,  2622,   674,  3778,  1995,  3529,  3530,
    3531,  3532,  3533,  3534,  1638,  2643,  1187,  4792,  3236,  3652,
    4018,  3779,  3727,  2886,  3141,  3243,  5066,  4163,  2643,  4376,
    2688,  -597,  3429,  5036,  2644,  2503,  3055,  3755,  1019,  4189,
     999,  1673,  2360,  5090,  3186,  1187,  3255,  2221,  2222,  2223,
    2224,  1653,  2886,  2886,   818,  3748,   706,   706,   900,  3265,
     901,  4718,  1112,  3624,  2251,  2252,  3096,    79,    79,  1816,
      79,  3497,   829,  1187,  1187,  3294,  1187,  2560,  4926,  2628,
    2629,  4109,  1640,   906,  2420,  3892,  1677,  1996,  2062,  2228,
    3811,  2064,  3266,  1187,  2068,  3187,  2070,  3142,  4217,  2073,
     408,  5037,  3132,  2077,  4238,  2043,  2689,   818,  1638,  2044,
    3728,  2421,  4190,  2416,    35,  3188,  3992,  1817,  -944,  1818,
    3549,  3267,    41,    42,  5038,  2801,  3143,   674,  3895,  2559,
    2267,   825,  1632,  4874,  1607,   674,   674,   875,  1608,  3611,
    1992,  4723,  4724,  4880,  3611,  1187,   410,  3611,  5059,  4110,
    2534,  3574,  1805,   408,   408,   408,  4412,  1820,  4413,  3144,
     706,   884,  2009,  1220,  4839,  2350,  3189,  4191,  2365,  4192,
    1788,   818,  4655,  1027,  1187,  3968,  1640,  4111,  1187,  1187,
      37,    38,    39,    40,  4656,  4182,  2191,    44,   409,   409,
    2765,  1472,  4112,  2454,  3522,  3229,  1822,   671,  1128,   410,
     410,   410,  4239,   408,  4113,  4911,  5006,  4883,  3892,  2417,
     408,  4075,  2535,  1641,  3893,  1965,  3756,   408,  1129,   674,
    5096,   835,  3245,  2351,  3894,  1633,  4680,  4114,  1130,  3100,
    3248,  1824,  3250,  2566,  3064,  1966,   122,   409,  4348,  1472,
     891,  3757,  3522,  2422,  2387,  3230,  4708,  3145,   825,   410,
    4533,  3895,  4754,  3896,   126,  1048,   410,  1933,  3408,  -938,
    4620,   836,  3708,   410,  2353,  3899,    37,    38,    39,    40,
    1049,  5043,  1057,    44,   891,  1006,  1807,  3334,  1677,  1994,
    -161,  3705,  4770,  1677,  1677,  1242,  2690,  3947,  1048,  2200,
    3951,  4240,  4587,  4588,  2430,  1006,  3231,   819,   893,  2691,
    4349,  3900,  4115,  1049,  2431,  -161,  2934,  1082,  2935,  2406,
    2078,  1933,  4534,  2287,  2203,  3901,  1139,  4912,  3724,  2407,
    1054,  4734,  4182,  4736,  2352,  1095,  3897,  1131,  1042,  1995,
    1338,  2936,   893,  2079,  2408,  4945,  4302,  4657,  1081,  3378,
    1933,   891,  2349,  4030,  2205,  4630,  4035,  4036,  4037,  4038,
    4039,  4040,  4041,  4042,  4043,  4044,  4437,  1139,  4438,  2361,
    1735,   362,  2886,  1735,  4637,  4647,  3423,  1338,   417,  3272,
    4540,  4541,  3611,  4869,  1243,  3524,  4709,  4303,  1733,  1048,
    1967,   818,  4913,  3898,  2379,  2381,  4028,  3232,  3899,  1132,
      43,  1104,   674,  4607,  1049,    45,  1242,  3902,  3273,   893,
    4602,  4304,  3523,  3447,   835,  4084,  4085,  -398,  2350,  1996,
    4048,  3288,    80,  1933,   819,  1244,  4305,  1847,  2727,  3268,
    4306,  4608,  1730,  3524,  3900,  3339,  2937,   408,  3716,  4204,
    2287,  2938,  2634,  2133,  3525,   900,  2939,   901,  3901,  4307,
    3620,  1677,  4308,  2432,   836,  1118,   903,  4603,  3274,  1677,
    1933,  4814,  3269,  2150,  4309,  1731,  1133,   905,   825,   209,
    1951,  4187,  2822,  2200,  1245,  4002,  2351,  2409,  3461,   900,
    4961,   901,   835,   410,  3340,   993,  2433,  3275,  1933,  4815,
   -2423,  3270,  3525,  2177,  1732,  1243,  4439,  3387,  2203,  1397,
    3233,  3738,  3388,   674,  1951,   994,  4962,  2189,  3234,   673,
    1677,  3235,  4003,  1677,  1677,  4031,  2808,  4032,  2563,   674,
    -398,  1593,   836,  1848,    37,    38,    39,    40,  2205,  3759,
    3902,    44,  2768,   366,  2769,    45,  1244,  3007,  2771,  4326,
    2772,  3646,  4310,  2774,  1125,  1187,   900,  2775,   901,  4504,
    4311,  1933,  2886,  2886,  1187,  1695,  4765,  3930,  2242,  2991,
    1122,  2243,  3341,  3342,  2940,  2311,  3939,  1733,  2666,  1139,
    2032,  1951,  1472,   918,  2941,  3522,  3343,  1677,  1696,   935,
     674,  4110,  1160,  2844,  4312,  1245,  4208,  2698,    81,     8,
    2033,    81,  2821,  2009,  4771,   366,   209,  2814,  1935,  2817,
    2311,   674,  2312,  1112,  1112,  1018,  1112,  2815,  2816,  4111,
    4182,  3526,  3527,  3528,  3591,  3529,  3530,  3531,  3532,  3533,
    3534,  1856,  3344,  1338,  4484,  1177, -1383,  3882,  4232,  4329,
    4049,  4050,  3388,  4010,   819,  4033,  4113,  2312, -1383,  3741,
    5094,  1187, -1383,  5095,  3451,  4034,    37,    38,    39,    40,
    2651,  4218,  4223,    44,  2208,  2209,  3330,  1166,   818,  3526,
    3527,  3528,  3689,  3529,  3530,  3531,  3532,  3533,  3534,    37,
      38,    39,    40,  2991,    74,  1220,    44,  3865,  1629,  1187,
    1187, -1371,  2551,  2277, -1383,  1168,  3751,  1187,  2313,  2169,
    1187,  2146,  4268,  2397,  1187,  2314,  1192,  1169,  1170,  2870,
    2212,  4014,  1187,  1187,   408,  3783, -1383,  1194,  2170,  3345,
    1187,  3346,  4269,  1187,  1187,  1187,  1187,  1171,  4517,  3908,
    1172,  3022,  2171,  1187,  1187,  4347,  1187,  4109,  1187,  1187,
    2314,  4082,  1187,  4456,  4115,   825,    79,  1638,  1205,    79,
    1618,  1639,  1338, -1383,  2912,  3656,  2315,  2915,  1933,  1187,
     410, -1383,  2158,  2159,  1187,  3090,  3524,  3093,  1187,  1389,
     417,  4455,  1187,  2511,  1187,  1187,  1187,  1187,  1187,  1187,
    1187,  1187,  1187, -1418,  1187,  2487,  5024, -1418,  3715,  4189,
    1187,  2315,  4055,  1187,  4284,  4835,  1722,  1788,  2519,  4386,
      37,    38,    39,    40,   408,  4110,  1828,    44,  1811,    37,
      38,    39,    40,  4013,  4285,  1640,    44,  4212,  2552,  1607,
    2553, -1903,  2146,  1608,  2397,  3525,  4810,  2557,  2598,  1723,
    4908,  3039,  1206,  4111,    35,  2169,  3084,  1240,   409,  1829,
     216,  1812,    41,    42,  1173,  1283,  2520,  2521,  4112,  1004,
     410, -1418,  1641,  1286,  2170,  1187,   932,   408,  1724,   408,
    4113,  2599,  4190,   818,  2519,  2342,  2343,  2570,  2173,  1004,
     224,  4681,  4682,  4683,  4684,  3334,  3149, -1383,  1150,  1233,
    2517,  1174,  1296,  4114,  1297,  4184,  4185,  1241, -1418,  2597,
    1106,   409,   216,   409,  2219,  2220,  2221,  2222,  2223,  2224,
    1727,  1288, -1419,   410,  2519,   410, -1419,  1316,   234,   408,
     192,   819,  2520,  2521,  2390,  4457,  4458,  4191,  1291,  4192,
     237,  3310,   224,  2886,   674,  1472,  2519,  2924,  3522,  2600,
    5050,   192,  2886,  1728,  1830,  1607,  1311,  1317,  1629,  1608,
     825,  2601,    81,  3924,    81,  4076,  2517,  2391,  1107,  2886,
    2886,   674,  2520,  2521,   247,   410,   674,  1304,  4115,   674,
     234,  4599,  1729,  4601,  -500,  2602,  1318,  4604,  3152,  4605,
   -1419,  3227,  1320,  2043,  2520,  2521,  2392,  2758,  1607,  1322,
     818,   674,  1608,   818,  1187,  1338,  2517,  1338,  2720,  2721,
     216,  3218,  3526,  3527,  3528,  1187,  3529,  3530,  3531,  3532,
    3533,  3534,  1187,  1321,  1870,  2519,   247, -1419,  2517,  1855,
    1319,   216,  1299,   209,  1300,  1108,  1472,  1327,  1048,  3522,
     224,  3909,   674,  3911,  3027,  3028,   408,  4123,  2519,   408,
    3494,   362,  1330,  1049,  2761,  1316,  4462,   417,  1856,  1933,
    1344,   224,  3802,  3495,  1933,  1933,  2052,  3496,  2053,   674,
    1338,  4429,  1348,  2520,  2521,  1356,  1933,   825,   234,  1362,
     825,  3656,   918, -1442, -1442,  1317,  4128,  4130,  1677,  2132,
     237,   247,   410,   674,  3656,   410,  2520,  2521,  3809,   234,
    3812,  1357,    37,    38,    39,    40,  3963,  2517,  1707,    44,
      79,   237,    79,   362,  3928,  2342,  3048,   674,  3237,  1371,
    2293,   674,  2294,  3840,   247, -1164,   819,  4785, -1164,  3524,
    2517,  1733,  4322,  4323,  4324,  2519,  1006,  2519,  1006,   674,
    1006,   818,  2287,  3379,   837,  5051,  1006,  2288,    35,   674,
    1377,  1109,    37,    38,    39,    40,    41,    42,  1319,    44,
    2519,   967,   674,   876,  3548,  1445,  3550,  3551,  1392,  1006,
    1006,   674,  3237,    37,    38,    39,    40,   966,  1837,  3787,
      44,  2991,    45,  2520,  2521,  2520,  2521,   408,  3525,  2296,
    2146,  2297,  1725,  2886,    37,    38,    39,    40,  4730,  1431,
    4209,    44,  1457,  4015,  3625,  1435,  2932,  4332,  2520,  2521,
    1452,  1838,  3788,  1458,  1187,  1839,  1933,  2517,   825,  2517,
    3524,  4289,  1451,  2760,  4233,  2761,  3402,  3403,  1055,  2199,
    3658,  3659,  2200,   410,  2781,  1459,  2782,  2519,  1461,  3237,
    1840,  3789,  2517,   819,  3237,  2783,   819,  2782,  1462,  1754,
    4664,  1460,  2861,    37,    38,    39,    40,  2203,  1466,  4460,
      44,  2519,  3207,  2204,  2811,  1102,  2812,  4320,  4321,  4322,
    4323,  4324,  1463,  3013,  1677,  2009,  3237,  4610,  4334,  3525,
    1467,  1755,  1677,  4405,  1677,  2520,  2521,  2205,  3072,  1006,
    2812,  1933,    35,   417,   674,  3162,  4685,  3163,  1150,  4336,
      41,    42,  1469,   671,   671,  4316,  4317,    45,  1705,  2520,
    2521,  1592,  1179, -1549, -1549, -1549, -1549,  4444,  2862,  2517,
   -1549,  1201,  4701,  4702,  1595,  1281,  4320,  4321,  4322,  4323,
    4324,   674,  2119,  2120,  4325,   362,  1600,  1756,  3223,  1187,
    3224,  1599,  3322,  2517,  3323,  1606,  1601,  3600,  3601,  3602,
    2146,  1627,  2397,  1006,  1284,  3526,  3527,  3528,  1619,  3529,
    3530,  3531,  3532,  3533,  3534,  3335,  1626,  3336,  1757,  1636,
    1629,  1102,  1472,  1630,  1651,  3522,  2863,  1652,   674,  2864,
    1656,  1658,  1339,   935,   819,  3453,  3493,  2782,  2761,  1666,
    1933,  2199,  2207,   818,  2200,  3503,  3507,  2761,  2761,   818,
    3349,  3511,   674,  2761,  1758,  3512,  1187,  2761,  1662,  3538,
    1342,  2761,  1187,  2208,  2209,  1663,  3554,    80,  2761,  2203,
    1352, -1556, -1556, -1556, -1556,  2204,  1671,  1667, -1556,  1187,
    1187,  3559,  1668,  3560,  1759,  1187,  3595,  1669,  3596,   408,
    3597,  3772,  3598,  3773,  1670,   408,  3526,  3527,  3528,  2205,
    3529,  3530,  3531,  3532,  3533,  3534,  3776,  1672,  3777,  2212,
    1187,  1187,  3957,  1678,  3958,  1187,  4019,  1679,  2761,  2865,
     825,  4056,  2213,  4057,  1681,  1447,   825,  1187,  1187,  1187,
    1187, -1547, -1547, -1547, -1547,   410,  4596,  4066, -1547,  4067,
    1187,   410,  4078,  1187,  2761,  1187,  1710,  4155,   209,  4156,
    2474,  4159,  1762,  4160,  1465,  1187,  1187,  1713,  1763,  1187,
    4188,  3573,  2782,  1574,  4378,  1764,  2782,  1586,  1339,  1588,
    1677,  1711,  1187,  2475,  1187,   366,  4386,  2814,  1187,  2817,
    1725,  4461,  1766,  2812,  4524,  3656,  4525,  2815,  2816,  4530,
    1767,  2782,  1746,  4531,  1187,  2782,  4847,  4592,  1006,  4593,
   -2633,  4649,  1719,  4650,  2207,  1187,  3524,  1187,  1187,  1187,
   -1550, -1550, -1550, -1550,  1773,  1777,  2866, -1550,  4635,  1802,
    1751, -1548, -1548, -1548, -1548,  2208,  2209,   674, -1548,  1804,
    4690,  1187,  4691,  4692,  2023,  2761,  1805,  4700,  4752,  2812,
    4753,  1768, -2633,  1187,  4811,  2038,  2782,  4836,  1187,  4837,
    4849,  4856,  2812,  2009,  1187,   673,   673,  1810,  1813,  4861,
    1708,  3937,  1187,  1833,  4863,  3525,  3937,  1721,  4688,  1845,
    4902,  2212,  4903,  4934,  4939,  2256,  4940,  4950,  1854,  2812,
    4951,  1859,  3560,  4952,  2213,  2761,   819,  4955,  4957,  2009,
    3937,  1865,   819,  2219,  2220,  2221,  2222,  2223,  2224,  1864,
    1866,   674,  3555,  1635,  4974,  1637,  2812,  2199,  3562,  4980,
    2200,  2812,  4981,  4994,  2812,  4995,  5013,  1871,  2009,    74,
    1873,  1875,  1187,  5092,  4513,  5093,  5103,  2201,  5093,  1877,
    1882,   818,   818,   818,  4664,  2203,  4483,  1881,  4486,  1887,
    1004,  2204,  1004,   674,  1004,  1889,   674,  1892,  1894,  1933,
    1004,  1419,  1420,  1897,  1733,  1939,  1942,  1935,  1944,  1954,
    1955, -2633,  1957,  -181,  4420,  2205,  1959,  1971,  1973,  1979,
    1981,   853,  1989,  1004,  1004,  1677,  1874,   408,   408,   408,
    1997,  2002,  2003,  2004,  2005,  2006,  2008,  1880,  2009,  2016,
    1006,  1933,  1933,  2019,  1933,  1006,  1006,  2020,  2021,  2022,
    2024,  2029,  4719,  2030,  2031,  2036,  2050,  2084,   825,   825,
     825,  2114,  2121,  2130,  2117,  2149,  2131,  2123,  2124,  2139,
    2142,  2143,  2144,   410,   410,   410,  2145,  2229,   247,  2151,
    4775,  2154,  2155, -2633, -2633,  2156,  3529,  3530,  3531,  3532,
    3533,  3534,   674,  2157,  2162,  2256,  2164,  1983,  2165,  2166,
    1933,  2260,  1933,   674,  4782,  2219,  2220,  2221,  2222,  2223,
    2224,  2167,  2168,  2175,  2272,  2176,  2206,  2178,  2179,  2180,
    2207,  2181,   818,  2182,  2183,  2184,  2185,  1339,  1421,   671,
    2300,    80,    80,  2292,    80,  2282,  1639,  1641,  2329,  2331,
    2339,  2208,  2209,  1004,  4509,  2348,  2341,  1139,  2356,  2364,
    1339,  2362,  2374,  2366,  2377,    35,  1933,  2375,  2210,  2382,
    2384,  2395,  1700,    41,    42,  4848, -2575,  2393,   408,  2386,
    2394,  2400,  2398,  2397,  2399,   674,  2401,  2402,  2423,   913,
    3365,  1933,  2429,  2456,  2211,  3978,  2435,  2212,  2460,  2463,
    2464,  2462,  2465,  2466,  2491,  2110,  2499,  2501,  2511,   825,
    2213,  3859,  1933,  1006,  2492,  1220,  2512,  1004,  2514,  2515,
    2516,  1006,  2517,  3942,   410,  1933,  2523,  1339,  2524,  2525,
    2526,  2530,  3953,  2531,   819,   819,   819,  1102,  2537,   674,
    2189,   674,  2547,  2539,  2543,  4887,  3229,  2544,  1102,  4892,
    4893,  2554,  4623,  3977,  2932,  2555,  2561,  1788,  2562,   924,
    2571,  4851,  2582,  2583,  2572,  1338,  2584,  2587,  2588,  2593,
    2596,  2610,  1006,  3594,  2611,  1006,  1006,  2623,  2625,  2626,
    2636,  4092,  4093,  4094,  4095,  2135,  3605,  2215,  2146,  1933,
    2638,  4904,  2152,  2639,  2652,  4891,  3230,  2655,  4733,  4772,
    2193,  2656,  2659,   886,   674,  1933,  2660,  2663,  2667,  1830,
    2198,  4888,  2682,  4894,  2687,  4896,  2702,  2703,  1933,  2713,
    2236,  2710,  2715,   362,  2716,  4598,  2717,  2723,  2734,  2737,
    2736,  2738,  2752,  2739,   674,  1472,  2753,  2777,  3522,  1006,
    2800,  2794,  3366,  3605,  2809,  2852,  1101,  3231,  1187,  1339,
    2778,   674,  2266,  2268,   818,  4463,  2824,  1339,  1339,  2819,
    1677,  2894,  2907,  2913,  2200,  2851,  2918,  2857,  2925,  2950,
    2895,   674,  2917,  1677,  2931,   819,  2948,  2216,  2217,  2218,
    2977,  2219,  2220,  2221,  2222,  2223,  2224,  1187,  2994,  2996,
    1933,  2651,  3001,    74,    74,  2993,    74,  1187,  4775,  2999,
     408,  3004,  3005,  1187,  3014,  1187,  1107,  3024,  3015,  3023,
    1933,  1187,  1004,  3025,  1187,  1187,  1187,  1187,  1187,  1187,
    1187,  1187,  1187,  1187,  3026,  3034,  3057,  1187,  1187,  3054,
    3056,   825,  2246,  3071,  3073,  1933,  3074,  4960,  3232,  3075,
    1187,   673,  3086,  3091,  1187,  3096,   410,  3094,  1187,  3098,
    3099,  3115,  3105,  3110,  3121,  3116,  3118,  3137,  1187,  3129,
    3140,  1187,  3125,  1187,  3153,  3158,  1589,  3209,  1593,  3214,
    3160,  1933,  1187,  1187,  1187,  3222,  3225,  3367,  1187,  3226,
    3238,  1187,  4825,  3276,  3279,  3290,  3297,  3298,  3301,  3302,
    3303,  1187,  1187,  3305,  3306,  3309,  3307,  3308,  3315,  3317,
    3324,  3326,  1187,  3329,  3330,  3331,  4868,  3337,  3332,  3357,
    1187,  3371,  1187,  3373,  3380,  3386,  3368,  3396,  3389,  3524,
    3394,  3395,  3397,  3407,  2725,  1677,  3410,  3422,  3425,  3405,
    3428,  3426,  4741,  2731,  3427,  3430,  3431,  2735,  3440,  3443,
    3446,  3233,  3445,  2741,  2742,  2037,  3455,  3456,  3457,  3234,
    3467,  4253,  3235,  3458,  1187,  3460,  2825,  3475,  3481,  1338,
    1187,  2754,  1437,  3483,  3487,  3489,  1187,  3486,  3490,   818,
    3491,  4759,  3505,   818,  3506,   818,  3508,  3509,  3525,  3510,
    2761,  2828,  3544,  5069,  3513,  3556,  3514,  3516,  3519,  3537,
    2564,  1187,  3543,  1220,  3545,  3570,  3575,   819,  3590,  3620,
    3622,  3546,  3553,  3583,  1004,  -984,  3568,  3663,  3569,  1004,
    1004,  3593,  3672,  4061,  3614,   408,  3619,  3666,  3668,   408,
    3678,   408,   674,  3656,  3682,  3683,  3684,  3693,  2829,  3696,
    3687,  3698,  1220,  3710,  3699,  3707,  3712,  3734,  3719,  3735,
    3703,  2043,  3688,  3746,  3745,  3752,   825,  3761,  3753,  3763,
     825,   818,   825,  2631,  3800,  3807,  3801,  2830,  3804,  3704,
    3806,   410,  3808,  3820,  3813,   410,  1933,   410,  3814,  3815,
    3816,  3817,  3818,  3819,  3821,   664,  3823,  3822,  2831,  3824,
    3826,  3825,  3827,  2357,  3831,  1420,  3828,  3833,  3835,  2832,
    2580,  3837,  3839,  3845,  3851,  3852,  3855,   408,  3870,  3871,
    2359,  3883,  3916,  2371,  3879,  3884,   674,   362,  2833,   674,
    2378,  2380,  3922,  2834,  3925,  3915,   362,  2678,  3927,  3929,
    3948,  3952,  3949,  3975,  3936,  3943,  3984,  3937,   825,  3986,
    3955,  3945,  3994,  4005,  3995,  3996,  3997,   362,  4000,  4006,
    4007,  4008,  4017,   410,  4022,  3526,  3527,  3528,  3540,  3529,
    3530,  3531,  3532,  3533,  3534,  2132,  3522,  3539,  2194,  2835,
    4052,  4080,  4053,  2437,  4054,  4108,  4143,  1004,  1006,  4060,
    4081,  4068,  4089,  4122,  4125,  1004,  4131,  4394,  4971,  4142,
    2836,  2724,  4151,  1187,  4141,  4175,  4144,  4147,  4148,  4196,
    2730,  4198,  4199,  4210,  4211,  4213,  2438,  4224,  4234,  4235,
      80,  4165,  4237,    80,  4236,  4247,  4249,  4248,  4265,  2439,
    1933,  4219,   819,   674,  1677,  4281,   819,  3006,   819,  3977,
    1006,  4215,  2440,  4283,   671,  4250,  1004,  4294,  4251,  1004,
    1004,  4286,  3207,  4295,  4230,  3967,  4252,  4292,  4318,   853,
    1705,  4344,  4352,  4362,  4355,   369,  1933,  1187,  1187,  4360,
    4367,   369,  4372,  4391,  4371,  1778,   667,  4389,  4392,  2782,
    2441,  1779,  4374,  4520,  4403,  4406,  2837,  1338,  4375,  4402,
    4408,  2442,  2838,  4416,  4421,  4410,  4424,  1201,  2839,  4425,
    4436,  4968,  4445,  4426,   369,  4427,  4428,  4433,  4440,  4446,
    2443,   674,  4441,  1004,   819,  2444,  4449,  4453,  2361,  4475,
    4447,  1780,  2189,  4479,  4480,  4448,  4487,  2840,  1187,  2841,
    4301,  2869,  4099,  4101,  4477,  4490,  4492,  4493,  4495,  4496,
    4518,  4521,  4510,  4519,  4514,  4526,  2842,  4527,  4535,   369,
    4567,  4546,  4549,  4574,  4556,  4550,  4579,  4609,  4586,  4616,
    4624,  4570,  1220,  4606,  4629,  1187,  4634,  4636,  4640,  4642,
    1781,  2843,  4651,  4661,  4653,  1187,  1187,  1782,  1933,  4659,
    1783,  4662,  2445,  1187,  1187,  4670,  4678,  4686,  1187,  1933,
    4687,  4689,  4551,  4694,  1187,  1187,  1044,  4697,  1187,  4696,
    4511,  4698,  4712,  4699,  1044,  4705,  1044,  4721,  4715,  4725,
    4727,  4731,  4735,  2446,  4747,  4751,  1187,  4756,   369,  4761,
    1187,  2718,  4750,  4762,  4769,  4768,  1006,  4773,  4780,  4786,
    1187,   818,  4351,  1784,  1006,  1187,  1006,  4793,  4798,  3625,
    4795,   853,  4800,  4818,  4819,  2998,  4821,  1187,  4823,  4796,
    4799,  4817,  4827,  4852,  4844,  4828,  1677,  4867,  1108,  4884,
    4858,  4909,  4914,  4921,  4875,  4918,  4919,  4924,  4936,  4923,
    4938,  4929,    74,    81,  2447,    74,  4937,   408,  4943,  4949,
    2448,  4944,  4958,  2449,  4959,  4953,  1187,  4954,  4964,  4966,
    1785,  4889,  1786,  4984,  4985,  4988,  4977,  4990,  4982,  4618,
    4993,  4998,  1787,  2199,  1933,  4999,  2200,  5004,   825,  2450,
    1788,  5005,  4133,  5031,  4986,  2451,  5023,  5026,  5034,  1789,
    5028,  5041,  5042,   410,  5046,  1354,  5072,  4987,  2452,  5088,
    1364,  2203,  1933,  2322,  5060,  5091,  5097,  2204,  1120,  1809,
    1376,  1776,  2594,   674,  3375,  2279,   673,  3649,  1933,  5101,
    3213,  3758,  1790,  2453,  4228,   674,  1791,  3289,  3854,  4298,
    4900,  2205,  1708,  4774,    80,  4983,    80,   369,  4820,  4363,
    4822,  4621,  4808,  3701,  5029,  3454,  2858,  2859,  4739,  5068,
    4991,  1792,  4989,  5040,  2871,  4932,  3706,  4359,  2874,  2875,
    3355,  4227,  3770,  3356,  1933,  3932,  2679,  3338,  5071,  4506,
    5102,  5098,   369,  2896,  4797,  2897,  3880,  3858,  5044,   674,
    4760,  2662,  4979,  5032,  4763,  1023,  4422,  2104,  4870,  4398,
    3166,    79,  4399,  3584,  4942,  1340,  3834,  2919,  5053,  2920,
    5099,  4927,  3009,  2767,  3010,  3653,  4381,  3031,  4512,  1793,
    1603,  3120,  4161,  3654,  3033,  2298,  3450,  3662,  1201,  2326,
    1588,  2325,  1187,  2051,  3032,  3664,  2330,  3665,  3677,  4103,
    4474,  4162, -2633,  1187,  4860,  4485,  2207,  4100,  4072,  1611,
    4850,  1625,  1006,  2335,   819,  3432,  4062,  5014,  5022,  2371,
    3657,   362,  5015,  3500,  3588,  3586,  4158,  2208,  2209,  2976,
    3976,  3441,  3442,  1991,  1153,  3444,  3424,  5012,  2719,  1123,
    3049,  3448,  3058,  1718, -2633,  2347,  2340,  3644,  2111,  1388,
    3065,  1933,  3063,  4167,  3062,  4168,  4502,  2245,  4146,  2344,
    1146,    83,  3452,   362,  2199,  2779,     0,  2200,  3069,  2040,
    1426,     0,   674,  2212,     0,  1689,     0,     0,     0,     0,
    4732,  1690,  1004,     0,  1187,     0,  2213,     0,  1933,     0,
       0,     0,  2203,  1187,     0,     0,  1778,  1677,  2204,     0,
       0,     0,  1779,     0,     0,     0,     0,     0,     0,     0,
    1187,  1187,  3484,     0,  1187,     0,     0,     0,     0,     0,
       0,     0,  2205,     0,     0,     0,     0,  1187,  3415,     0,
       0,     0,  1187,     0,  1004,  1187,     0,  3312,     0,     0,
    1187,  1187,  1780,     0,     0,  3312,     0,  1754,     0,   818,
       0,     0,     0,     0,  1700,     0,    74,     0,    74,     0,
       0,     0,     0, -2633,     0,     0,     0,   674,     0,   674,
       0,     0,     0,  1187,     0,     0,     0,  3605,     0,  1755,
       0,  3605,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1781,     0,     0,  1202,   408,     0,     0,  1782,     0,
    1224,  1783,  3381,     0,  1933,     0,     0,     0,     0,     0,
    1237,     0,  1187,     0,     0,     0,     0,  1006,     0,     0,
       0,  4812,     0,  2206,   362,     0,   825,  2207,     0,     0,
    3409,     0,     0,     0,     0,  1756,  1339,     0,  1298,     0,
       0,   410,  1305,   674,     0,     0,     0,     0,  2208,  2209,
       0,     0,     0,  1315,  1784,  1187,     0,  2219,  2220,  2221,
    2222,  2223,  2224,     0,     0,  2210,  1757,     0,     0,  1778,
       0,     0,     0,  1339,     0,  1779,     0,     0,     0,   370,
    2018,     0,     0,     0,     0,   370,     0,     0,     0,     0,
     668,  2211,     0,     0,  2212,  3416,     0,     0,     0,  4729,
       0,     0,  1758,     0,     0,     0,     0,  2213,     0,   818,
    1187,  1785,  1933,  1786,     0,  1780,     0,     0,   370,     0,
    1004,     0,     0,  1787,     0,     0,     0,     0,  1004,     0,
    1004,  1788,  1759,     0,  1187,  1933,     0,  1187,     0,  1187,
    1789,     0,     0,     0,     0,     0,     0,  1778,     0,     0,
       0,     0,  1677,  1779,  2103,   408,  1187,   369,     0,     0,
    1187,   369,     0,   370,  1781,  1933,     0,     0,     0,  2115,
       0,  1782,  3485,  1834,  1783,   667,     0,  1791,  3488,     0,
       0,   667,  2126,     0,  2215,     0,   825,     0,     0,     0,
    3711,   667,   819,  1780,     0,     0,   209,     0,  2885,     0,
    1762,   410,  1835,     0,  4930,  1933,  1763,     0,  4301,  1933,
    1933,     0,  2908,  1764,     0,     0,  3333,     0,  1754,   667,
       0,  2475,     0,   667,     0,     0,     0,  1784,     0,     0,
    1766,     0,   370,     0,   667,     0,     0,     0,  1767,     0,
       0,     0,  1781,     0,     0,     0,  1187,     0,     0,  1782,
    1755,     0,  1783,     0,     0,  5087,     0,     0,     0,   667,
    1793,     0,     0,     0,     0,  1187,     0,     0,     0,  3762,
       0,  3764,     0,     0,  2216,  2217,  2218,     0,  2219,  2220,
    2221,  2222,  2223,  2224,  1785,  1933,  1786,     0,     0,  1768,
       0,     0,  4948,  3418,  3967,     0,  1787,     0,     0,     0,
       0,   664,   664,   667,  1788,  1784,  1756,     0,     0,     0,
       0,     0,     0,  1789,     0,  1187,     0,     0,     0,  1339,
       0,  3612,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1187,     0,     0,     0,     0,  1757,     0,     0,
       0,     0,  1006,     0,     0,  2299,  1860,     0,  3605,     0,
    1791,   674,   819,  3605,     0,  1006,  3605,     0,     0,     0,
       0,     0,  1785,  3829,  1786,     0,  1004,     0,     0,  3836,
       0,     0,     0,  1758,  1787,  1861,     0,  1187,  3612,     0,
       0,   370,  1788,     0,  5045,     0,     0,     0,  1187,     0,
       0,  1789,   366,  1044,  5055,   667,  5058,  1044,     0,     0,
       0,     0,   818,  1759,  5056,  5057,     0,     0,     0,  1187,
    1187,     0,   674,     0,     0,   369,   370,     0,     0,     0,
       0,     0,  1187,     0,  2457,     0,     0,     0,  1791,     0,
    1760,     0,   366,  1793,  5055,     0,  5058,     0,  1339,     0,
       0,     0,     0,     0,  5056,  5057,     0,     0,   408,   818,
       0,     0,     0,  2458,     0,     0,     0,   818,     0,     0,
       0,     0,     0,  1761,  1187,     0,     0,   209,     0,     0,
       0,  1762,     0,     0,  1187,     0,   366,  1763,  5055,   825,
    5058,     0,   667,   667,  1764,     0,     0,     0,  5056,  5057,
     666,     0,  1765,     0,   410,   408,  1928,     0,     0,     0,
       0,  1766,     0,   408,     0,   362,     0,  1006,     0,  1767,
       0,  1793,     0,     0,     0,  3979,     0,     0,   816,  3982,
    3983,  3775,  3985,     0,  3987,  3988,   825,     0,     0,     0,
       0,     0,     0,  3993,   825,     0,  1187,     0,     0,  2199,
       0,   410,  2200,     0,     0,  1187,     0,     0,     0,   410,
       0,     0,  3803,     0,  2199,     0,     0,  2200,     0,  2201,
    1768,     0,     0,   816,     0,     0,  2371,  2203,  4011,  3647,
       0,  1004,     0,  2204,     0,     0,  3415,     0,     0,     0,
       0,  3605,  2203,     0,     0,     0,     0,     0,  2204,     0,
       0,     0,     0,     0,     0,  1754,     0,  2205,     0,     0,
    3832,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1043,     0,  2205,     0,     0,     0,     0,     0,  1043,     0,
    1043,     0,  3312,     0,     0,  3312,  3312,  1755,     0,  3312,
       0,     0,   816,     0,     0,  3312,     0,     0,     0,     0,
       0,     0,  5079,     0,  3868,   819,     0,     0,     0,     0,
    3877,     0,     0,     0,     0,     0,     0,  3868,     0,  1928,
       0,  5078,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1339,     0,  1339,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1756,     0,     0,     0,     0,   362,  5079,
       0,     0,   819,     0,     0,     0,     0,  5079,  2206,     0,
     819,     0,  2207,     0,   667,     0,     0,     0,  5078,  3935,
       0,     0,     0,  2206,  1757,     0,  5078,  2207,     0,     0,
       0,     0,     0,  2208,  2209,     0,  2732,   667,     0,     0,
       0,     0,     0,     0,     0,  3962,  1339,  2743,  2208,  2209,
    2210,     0,     0,  3416,     0,     0,     0,     0,     0,  2750,
    1758,     0,     0,     0,     0,  2210,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2211,     0,     0,  2212,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1759,     0,  2213,     0,  2212,  2214,     0,     0,     0,     0,
       0,     0,     0,     0,   667,     0,  1006,  2213,     0,     0,
       0,     0,  2265,     0,  1201,     0,     0,     0,  2787,     0,
       0,     0,  2793,     0,  2795,     0,     0,  2798,  1006,     0,
       0,     0,     0,     0,     0,     0,     0,   664,     0,     0,
       0,   370,     0,     0,     0,   370,     0,     0,     0,     0,
       0,     0,     0,     0,   209,     0,     0,     0,  3417,   668,
       0,     0,     0,     0,  1763,   668,     0,     0,     0,  2215,
       0,  1764,     0,     0,     0,   668,     0,     0,   362,  2475,
       0,     0,     0,     0,  2215,  3415,     0,     0,  1766,     0,
     362,     0,     0,     0,     0,     0,  1767,     0,     0,  4073,
       0,     0,  1778,   668,  1754,     0,  1004,   668,  1779,     0,
       0,  3872,  3875,     0,     0,     0,     0,     0,   668,  1004,
       0,     0,     0,     0,  2885,  2885,   667,     0,     0,  2885,
    5086,     0,     0,     0,   667,   667,  1755,     0,     0,  1928,
       0,     0,     0,   668,     0,   369,     0,  1768,  1780,     0,
    3921,  3418,     0,  4138,     0,     0,     0,  3612,  3612,  2216,
    2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,  2224,  2885,
    2885,  3002,     0,     0,   362, -2633, -2633,  3003,  2219,  2220,
    2221,  2222,  2223,  2224,     0,     0,     0,   668,     0,     0,
       0,     0,  1756,  1928,     0,     0,     0,  1781,   369,   369,
     369,     0,     0,     0,  1782,     0,     0,  1783,     0,     0,
    2592,     0,     0,     0,     0,     0,     0,     0,   667,     0,
       0,     0,  1928,  1757,     0,     0,     0,     0,  1006,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   369,     0,
       0,     0,  3416,     0,     0,   369,     0,  3612,     0,  1758,
    1784,     0,   369,     0,     0,     0,     0,     0,     0,  1044,
       0,  1004,  2199,     0,     0,  2200,     0,  4411,     0,   668,
       0,     0,     0,     0,     0,  4414,  4415,     0,     0,  1759,
       0,     0,     0,     0,     0,  1928,     0,     0,     0,   370,
    2203,    35,  1044,     0,     0,     0,  2204,     0,  3868,    41,
      42,  2668,     0,     0,  1928,  2199,     0,  1785,  2200,  1786,
       0,     0,     0,     0,     0,     0,     0,  2592,     0,  1787,
    2205,  4254,  1928,     0,  4255,  2201,  4256,  1788,  2202,     0,
       0,     0,     0,  2203,     0,     0,  1789,     0,     0,  2204,
       0,     0,     0,   209,     0,     0,     0,  1762,     0,  1778,
    1928,     0,     0,  1763,     0,  1779,   668,   668,     0,     0,
    1764,     0,     0,  2205,     0,  3312,     0,     0,  2475,  2527,
       0,  3312,  3312,  1791,  2631,     0,     0,  1766,  2592,     0,
    1814,   667,     0,  1044,     0,  1767,     0,  1006,     0,     0,
       0,     0,     0,     0,  3877,  1780,     0,     0,  2528,     0,
       0,     0,     0,     0,     0,  4331,  4333,  4335,  4337,     0,
    3171,     0,     0,  1928,     0,     0,     0,     0,     0,     0,
       0,  2206,     0,     0,     0,  2207,  1815,     0,     0,     0,
       0,   816,     0,     0,     0,     0,  1768,     0,     0,  1006,
    3418,     0,     0,     0,  1781,     0,  2208,  2209,     0,   666,
       0,  1782,  4164,     0,  1783,   666,  1793,     0,     0,     0,
       0,     0,   369,  2210,  2206,   666,     0,     0,  2207,     0,
       0,     0,     0,     0,     0,  4397,     0,     0,     0,     0,
    4538,     0,   667,     0,     0,     0,     0,     0,     0,  2208,
    2209,     0,  2212,   666,     0,     0,     0,   666,   667,     0,
       0,     0,     0,     0,  1816,  2213,  2210,  1784,   666,     0,
       0,  4554,  4555,     0,     0,     0,     0,     0,     0,  1006,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2211,   666,     0,  2212,     0,  4431,     0,     0,
       0,     0,     0,     0,     0,     0,  1006,     0,  2213,     0,
    1004,  2214,  1817,     0,  1818,     0,     0,     0,     0,   667,
       0,     0,     0,     0,  1819,     0,  1786,     0,     0,     0,
       0,     0,  1004,  4584,  4585,     0,  1787,   666,   668,     0,
     667,     0,  2215,     0,  1788,     0,     0,  1920,     0,     0,
       0,     0,  1820,  1789,     0,     0,     0,     0,     0,     0,
       0,   668,     0,     0,     0,     0,     0,     0,     0,     0,
    1928,     0,     0,  1917,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2215,  1821,     0,     0,     0,
    1791,  1822,     0,  1419,  1420,     0,     0,     0,     0,     0,
       0,     0,  4315,     0,     0,     0,  3875,     0,     0,     0,
       0,     0,  3612,     0,     0,  1823,  3612,  4330,     0,     0,
       0,     0,     0,  4507,  4508,     0,  1824,  1043,   668,   666,
       0,  1043,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,
    2223,  2224,     0,     0,     0,    80,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4674,     0,  4675,  4676,
       0,     0,     0,     0,     0,     0,     0,     0,  3459,  4679,
       0,     0,   664,  1793,     0,  2216,  2217,  2218,     0,  2219,
    2220,  2221,  2222,  2223,  2224,     0,     0,     0,     0,   369,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3076,
       0,     0,     0,     0,  3080,     0,     0,  3083,     0,     0,
    1920,     0,     0,     0,     0,  2885,   666,   666,  2885,  2885,
    2885,  2885,  2885,  2885,  2885,  2885,  2885,  2885,     0,  3106,
       0,     0,  1004,     0,  1006,     0,  2112,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4059,     0,
     668,     0,     0,     0,     0,     0,     0,     0,   668,   668,
       0,     0,     0,     0,  4581,  4582,     0,     0,     0,   370,
    3156,     0,     0,     0,  3312,  3312,     0,  2885,  2885,   369,
       0,  1339,     0,     0,     0,  4600,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3170,     0,     0,
    3877,  3877,  3877,  3877,  3877,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3203,   370,   370,   370,     0,     0,     0,     0,     0,
       0,     0,   369,     0,   369,     0,     0,     0,     0,     0,
       0,     0,   668,     0,     0,  3228,     0,     0,     0,  3239,
       0,  1928,     0,   667,     0,  4644,  1928,  1928,     0,  4626,
       0,     0,     0,     0,     0,     0,     0,  3251,  1928,     0,
       0,     0,   370,     0,     0,  2371,     0,  3260,     0,   370,
     667,     0,  4663,     0,   369,   667,   370,     0,   667,     0,
    3284,     0,     0,     0,     0,     0,     0,    74,     0,  3291,
       0,  1004,     0,     0,     0,  4431,  4431,  4431,  4431,     0,
     667,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4846,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   666,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   667,     0,  1004,     0,     0,     0,     0,     0,     0,
       0,   666,  1044,     0,     0,     0,  3694,  3695,     0,  3697,
    4564,  4565,     0,     0,     0,  4568,  4569,     0,   667,     0,
    1920,     0,  4872,  3612,     0,     0,     0,     0,  3612,     0,
       0,  3612,     0,  2199,     0,     0,  2200,     0,     0,     0,
       0,   369,   667,     0,   369,     0,  2112,     0,  1928,     0,
       0,  2199,     0,  2201,  2200,   668,  4899,     0,     0,     0,
       0,  2203,  4947,     0,     0,     0,   667,  2204,   666,  3612,
     667,     0,     0,  1004,  1920,     0,  3868,     0,     0,  2203,
       0,     0,     0,     0,     0,  2204,     0,     0,   667,     0,
       0,  2205,  3875,  3875,  3875,  3875,  3875,     0,   667,     0,
    1004,     0,     0,  1920,     0,     0,  3312,     0,  4758,  2205,
       0,   667,     0,     0,     0,  1339,     0,     0,     0,  4778,
     667,  4779,     0,  1928,  4783,  4784,     0,  2885,     0,  2533,
       0,     0,     0,     0,     0,     0,   370,     0,     0,  1204,
       0,     0,     0,     0,     0,     0,     0,  1228,     0,     0,
       0,  1201,  3805,     0,     0,  1239,   668,     0,     0,     0,
       0,     0,     0,  1249,     0,     0,     0,     0,  1282,     0,
       0,  4086,   668,     0,     0,     0,  1920,     0,     0,     0,
       0,     0,   369,     0,     0,     0,     0,     0,     0,     0,
     666,     0,  2206,     0,  1778,  1920,  2207,     0,   666,   666,
    1779,     0,  2609,     0,     0,     0,  3612,     0,     0,   816,
   -2633,     0,     0,  1920,  2207,     0,     0,  2208,  2209,     0,
       0,  2112,  1928,     0,     0,  1814,     0,     0,     0,     0,
       0,     0,     0,   668,  2210,  2208,  2209,     0,     0,     0,
    1780,  1920,     0,   667,     0,     0,     0,     0,     0,     0,
       0,     0, -2633,     0,   668,     0,  3612,     0,     0,     0,
    2211,     0,   816,  2212,     0,     0,     0,  2654,     0,     0,
       0,  1815,     0,     0,     0,  4728,  2213,     0,     0,  2214,
     667,  2212,   666,  3917,     0,  3920,     0,     0,     0,  1781,
       0,     0,     0,  4901,  2213,     0,  1782,     0,     0,  1783,
       0,     0,     0,     0,  1920,     0,     0,  2885,  2885,     0,
    5065,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1455,     0,     0,   816,   667,  1004,     0,
    2726,     0,     0,  1043,     0,     0,     0,     0,     0,     0,
       0,     0,  4920,     0,     0,     0,     0,     0,     0,  1816,
       0,   667,  1784,  2215,     0,  1581,     0,     0,     0,     0,
    2199,     0,     0,  2200,     0,     0,  1043,     0,     0,     0,
       0, -2633,     0,  1605,     0,     0,  3998,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2203,     0,
       0,     0,     0,     0,  2204,  1631,     0,  1817,  4009,  1818,
       0,     0,     0,   370,     0,     0,     0,     0,     0,  1819,
       0,  1786,     0,     0,     0,     0,     0,     0,  2205,  3690,
       0,  1787,     0,  1339,     0,     0,     0,     0,     0,  1788,
    2199,     0,     0,  2200,   369,     0,     0,  1820,  1789,     0,
     369,     0,     0,  2216,  2217,  2218,     0,  2219,  2220,  2221,
    2222,  2223,  2224,     0,     0,   666,     0,  1043,  2203,  3515,
       0,  3713,     0,     0,  2204,  2219,  2220,  2221,  2222,  2223,
    2224,  3241,     0,  5001,     0,  1791,  1822,     0,     0,     0,
    4087,     0,     0,     0,  3612,     0,     0,     0,  2205,     0,
       0,     0,     0,   370,     0,     0,  1799,     0,     0,     0,
    3242,  1920,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1824,     0,     0,     0,     0,     0,     0,  5030, -2633,
       0,     0,     0,  2207,     0,     0,   667,  2922,     0,     0,
       0,  1928,     0,     0,     0,     0,   816,     0,     0,     0,
       0,     0,     0,     0,  2208,  2209,   370,     0,   370,     0,
    4090,     0,     0,     0,     0,     0,   666,     0,  1793,     0,
    3780, -2633,     0,  1922,     0,     0,  5080,   668,     0,     0,
       0,  3798,   666,  1928,  1928,     0,  1928,     0,     0,     0,
       0,     0,     0,     0,     0,  1946,     0,     0,     0, -2633,
    2212,     0,     0,  2207,   668,     0,     0,     0,   370,   668,
     667,     0,   668,  2213,     0,     0,     0,  1974,  1977,  1978,
       0,     0,     0,  5080,  2208,  2209,  4946,     0,     0,     0,
       0,  5080,     0,     0,   668,     0,     0,     0,     0,     0,
       0, -2633,  1928,   666,  1928,     0,     0,     0,     0,     0,
       0,  5100,   667,  3841,     0,   667,     0,     0,     0,     0,
       0,     0,     0,     0,   666,     0,     0,     0,     0,     0,
    2212,     0,     0,     0,  1778,   668,     0,     0,  2885,     0,
    1779,     0,     0,  2213,     0,     0,     0,  4693,     0,     0,
   -2633,     0,     0,     0,     0,     0,     0,     0,  1928,     0,
       0,     0,   668,     0,  2885,  2885,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1780,  1778,     0,  1928,     0,   370,   668,  1779,   370,     0,
       0,     0,   369,   369,   369,  1581,  1922,     0,     0,     0,
       0,     0,     0,     0,  1928,     0,     0,     0,     0,     0,
     668,   667,  2116,     0,   668,     0,     0,  1928,     0,     0,
   -2633,     0,   667,  1581,     0,     0,     0,  1780,     0,  1781,
       0,     0,   668,     0,     0,     0,  1782,     0,     0,  1783,
       0,     0,   668,     0,  2219,  2220,  2221,  2222,  2223,  2224,
       0,     0,  1920,     0,     0,   668,     0,  1920,  1920,     0,
       0,     0,  2592,     0,   668,     0,     0,     0,     0,  1920,
       0,     0,     0,   816,     0,     0,  1781,     0,     0,  4001,
       0,  1928,     0,  1782,     0,     0,  1783,     0,  5077,     0,
       0,     0,  1784,     0,   667,  3175,     0,  1928,  1778,  4012,
       0,     0,     0,     0,  1779,     0,  4364,  4365,     0,     0,
    1928,     0,     0,     0,  2219,  2220,  2221,  2222,  2223,  2224,
       0,     0,     0,     0,     0,     0,   370,     0,     0,     0,
       0,     0,     0,   369,     0,  5077,     0,  2199,     0,  1784,
    2200,     0,     0,  5077,  1780,     0,     0,     0,   667,  1785,
     667,  1786,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1787,     0,     0,  2283,  2203,     0,     0,     0,  1788,
       0,  2204,     0,     0,     0,     0,     0,     0,  1789,     0,
       0,     0,  1928,  4417,  4418,  4419,     0,   668,  2885,     0,
       0,     0,     0,  1781,     0,  2205,  1785,     0,  1786,     0,
    1782,     0,  1928,  1783,     0,     0,     0,     0,  1787,  1920,
       0,  3172,  2336,   667,     0,  1791,  1788,     0,     0,     0,
       0,     0,     0,     0,   668,  1789,     0,  1928,     0,     0,
       0,     0,     0,     0,     0,  3328,     0,   666,     0,     0,
    1792,     0,     0,   667,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1784,  4466,  3253,     0,
     667,     0,  1791,  1928,   666,     0,  1922,     0,   816,   666,
       0,   668,   666,     0,     0,     0,     0,     0,     0,     0,
     667,     0,     0,     0,  1920,     0,     0,  3254,     0,  2199,
       0,     0,  2200,     0,   666,   668, -2633,     0,  1793,     0,
    2207,     0,     0,     0,     0,     0,     0,     0,     0,  2201,
       0,     0,     0,  1785,     0,  1786,     0,  2203,     0,     0,
    1922,  2208,  2209,  2204,     0,  1787,     0,     0,     0,     0,
       0,     0,     0,  1788,     0,   666,     0,  2493, -2633,     0,
       0,     0,  1789,     0,  2510,  1793,  1043,  2205,     0,  1922,
    4205,     0,     0,     0,     0,   369,     0,     0,     0,     0,
       0,     0,   666,     0,     0,     0,     0,  2212,     0,     0,
    2542,     0,     0,  2545,     0,  3292,     0,     0,   370,  1791,
    2213,     0,     0,  1920,   370,   816,   666,     0,   816,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3293,  2579,     0,     0,     0,  3476,
     666,     0,     0,     0,   666,     0,     0,     0,     0,  2595,
       0,     0,  1922,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   666,  2607,  4270,     0,     0,  4273,     0,     0,
       0,  1922,   666,     0,     0,     0,     0,     0,  2206,     0,
       0,     0,  2207,  4575,  4576,   666,  4578, -2633,  1928,  1922,
       0,     0,  1793,     0,   666,     0,     0,     0,     0,     0,
     668,     0,     0,  2208,  2209,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1922,     0,     0,
    2210,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2211,     0,     0,  2212,
       0,     0,     0,     0,     0,     0,   816,     0,     0,     0,
       0,   667,  2213,  2699,     0,  2214,     0,     0,     0,  2709,
       0,  4369,     0,     0,   668,   936,     0,     0,     0,     0,
    1922,  2219,  2220,  2221,  2222,  2223,  2224,   937,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     369,     0,     0,     0,   369,     0,   369,     0,   938,     0,
       0,     0,     0,     0,     0,     0,   668,   666,     0,   668,
       0,   939,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1928,     0,   940,     0,     0,     0,     0,  2215,
    2764,     0,     0,     0,     0,   667,     0,     0,   667,     0,
       0,   941,     0,     0,   666,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1928,     0,
       0,     0,   942,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   369,   943,     0,     0,     0,  1581,  1581,     0,
       0,   944,     0,     0,     0,     0,   370,   370,   370,     0,
       0,   666,   945,     0,     0,     0,     0,   946,     0,     0,
       0,     0,     0,   947,     0,   668,     0,     0,     0,     0,
       0,     0,  1920,     0,     0,   666,   668,     0,   948,  2216,
    2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,  2224,     0,
       0,     0,     0,     0,     0,  3563,     0,     0,  3717,     0,
       0,  2199,   667,     0,  2200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1920,  1920,     0,  1920,     0,     0,
       0,  2201,     0,     0,   949,     0,     0,  1922,     0,  2203,
    1928,     0,     0,     0,     0,  2204,     0,     0,     0,     0,
       0,  1928,     0,     0,     0,     0,     0,     0,   668,     0,
       0,     0,     0,     0,     0,   950,     0,  2199,   816,  2205,
    2200,     0,     0,     0,   816,   951,     0,     0,     0,     0,
       0,  2975,     0,  1920,     0,  1920,     0,  2201,     0,     0,
     667,     0,     0,   853,     0,  2203,     0,   370,     0,   712,
       0,  2204,     0,     0,     0,     0,  2995,     0,     0,  3795,
       0,  3797,   668,     0,   668,     0,     0,     0,     0,     0,
     952,     0,     0,     0,   953,  2205,   954,     0,     0,     0,
       0,     0,   955,     0,     0,   956,     0,   712,     0,  1920,
       0,  4561,     0,  3008,     0,  3011,     0,     0,     0,     0,
       0,     0,     0,  4571,     0,     0,     0,     0,   712,     0,
     666,   957,     0,   958,  1920,  3830,  1928,   959,     0,     0,
    2206,     0,     0,     0,  2207,   960,  1015,   668,     0,     0,
     961,  1581,     0,  4855,     0,  1920,     0,     0,     0,  1016,
    3844,     0,   962,  4855,  1928,  2208,  2209,  1024,  1920,     0,
       0,     0,     0,     0,     0,   963,     0,   668,     0,     0,
    1928,  2199,  2210,  1035,  2200,  1015,     0,     0,     0,  1056,
       0,     0,     0,     0,   668,     0,  2206,     0,     0,  1086,
    2207,  2201,     0,     0,   666,     0,     0,  1091,  2211,  2203,
       0,  2212,     0,     0,   668,  2204,     0,  4898,     0,     0,
       0,  2208,  2209,     0,  2213,     0,  1928,  2214,     0,     0,
       0,     0,  1920,     0,     0,     0,     0,     0,  2210,  2205,
       0,     0,     0,     0,     0,     0,   666,     0,  1920,   666,
       0,     0,     0,     0,     0,     0,     0,     0,  3175,     0,
       0,  1920,     0,     0,  2211,     0,     0,  2212,     0,     0,
       0,     0,   369,     0,     0,     0,     0,     0,     0,     0,
    2213,     0,     0,  2214,     0,     0,     0,  3980,  1922,   370,
       0,     0,   667,  1922,  1922,     0,     0,     0,     0,     0,
       0,  2215,     0,     0,   667,  1922,  4956,     0,     0,     0,
       0,     0,     0,     0,  2199,     0,     0,  2200,     0,     0,
       0,     0,     0,     0,     0,     0,   816,   816,   816,     0,
       0,  3194,     0,  1920,  2201,     0,     0,     0,     0,     0,
    2206,     0,  2203,     0,  2207,   666,  3215,     0,  2204,     0,
       0,     0,     0,  1920,     0,     0,   666,  2215,   667,  4023,
       0,     0,     0,     0,     0,  2208,  2209,     0,     0,     0,
       0,     0,  2205,     0,     0,     0,     0,     0,  1920,  4029,
    1928,     0,  2210,     0,     0,     0,     0,     0,     0,     0,
       0,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,
    2224,     0,     0,     0,  4051,  2916,     0,     0,  2211,     0,
       0,  2212,     0,     0,  1920,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2213,     0,     0,  2214,   666,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2112,     0,     0,     0,     0,  1922,     0,  2216,  2217,  2218,
       0,  2219,  2220,  2221,  2222,  2223,  2224,     0,     0,     0,
       0,  3869,     0,     0,     0,   668,     0,   816,     0,     0,
       0,     0,     0,  2206,     0,     0,     0,  2207,     0,     0,
       0,   667,   666,     0,   666,  3374,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1928,     0,  2208,  2209,
       0,  2215,     0,     0,   370,     0,     0,     0,   370,     0,
     370,     0,     0,     0,     0,  2210,     0,     0,     0,     0,
    1922,     0,     0,     0,     0,     0,     0,  1778,     0,     0,
       0,     0,     0,  1779,     0,     0,     0,     0,     0,     0,
       0,  2211,     0,     0,  2212,     0,     0,   666,     0,   668,
       0,     0,   668,     0,     0,     0,     0,  2213,     0,     0,
    2214,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1780,     0,     0,   667,   666,   667,     0,
       0,     0,  2199,     0,     0,  2200,   370,     0,     0,     0,
       0,  2216,  2217,  2218,   666,  2219,  2220,  2221,  2222,  2223,
    2224,     0,  2201,     0,  1928,  4024,     0,   712,     0,  1920,
    2203,     0,     0,     0,   666,     0,  2204,     0,     0,  1922,
       0,     0,  1781,     0,     0,     0,     0,  1928,     0,  1782,
       0,     0,  1783,     0,  2215,     0,     0,     0,     0,     0,
    2205,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     369,     0,   667,  1778,     0,     0,   668,  1928,     0,  1779,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1784,     0,     0,     0,   816,
       0,     0,     0,     0,     0,     0,     0,  1928,     0,  1780,
       0,  1928,  1928,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2216,  2217,  2218,     0,  2219,  2220,
    2221,  2222,  2223,  2224,   668,     0,     0,     0,  4071,     0,
       0,  2206,  1785,     0,  1786,  2207,     0,     0,  1781,     0,
       0,     0,     0,  1920,  1787,  1782,     0,     0,  1783,     0,
       0,     0,  1788,     0,     0,     0,  2208,  2209,     0,     0,
       0,  1789,     0,     0,     0,     0,     0,     0,     0,  4366,
       0,     0,     0,  2210,     0,     0,     0,     0,     0,  1920,
    3599,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3739,     0,     0,     0,  1791,  2211,
     369,  1784,  2212,  1183,  1189,  1189,   712,     0,  1189,     0,
    1197,     0,  1183,     0,  1086,  2213,     0,  1222,  2214,     0,
       0,     0,  1086,  3740,  1086,     0,     0,     0,  1189,     0,
    1086,     0,     0,     0,     0,     0,     0,     0,  1251,     0,
       0,     0,     0,  1086,     0,  1183,     0,     0,  1189,     0,
     712,     0,  1189,     0,     0,   666,     0,  1778,  1785,  1222,
    1786,     0,  1308,  1779,     0,     0,     0,     0,     0,  1189,
    1787,     0,     0,     0,     0,     0,     0,     0,  1788,     0,
       0,  1793,     0,     0,     0,     0,     0,  1789,     0,     0,
       0,  1920,  2215,     0,   816,     0,     0,     0,   816,     0,
     816,  1183,  1920,  1780,     0,     0,   712,     0,     0,     0,
       0,  1183,     0,     0,     0,  1222,     0,     0,  1922,     0,
    3781,     0,     0,     0,  1791,     0,     0,     0,  2112,     0,
    1189,     0,     0,     0,     0,     0,   370,     0,     0,   666,
       0,     0,   666,     0,     0,     0,     0,     0,     0,  3782,
     667,     0,  1781,     0,     0,     0,   668,     0,     0,  1782,
    1922,  1922,  1783,  1922,     0,     0,     0,     0,   668,     0,
       0,     0,     0,     0,     0,     0,   816,     0,     0,     0,
       0,     0,  2216,  2217,  2218,  1086,  2219,  2220,  2221,  2222,
    2223,  2224,     0,     0,     0,     0,  4150,     0,  1086,  1456,
       0,     0,     0,     0,     0,     0,     0,  1793,     0,     0,
       0,   667,     0,     0,     0,  1784,     0,  1920,     0,  1922,
       0,  1922,   668,     0,     0,  1563,     0,     0,     0,   712,
    1086,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4539,     0,  1920,   666,     0,  1086,     0,
       0,     0,  1086,     0,     0,     0,     0,     0,     0,     0,
    1563,  1920,     0,     0,     0,     0,     0,     0,     0,     0,
    1086,  4553,  1785,     0,  1786,  1922,     0,     0,     0,     0,
       0,     0,  1086,     0,  1787,     0,     0,  4566,     0,     0,
       0,     0,  1788,   369,     0,  2199,     0,     0,  2200,     0,
    1922,  1789,     0,     0,     0,     0,     0,  1920,     0,     0,
       0,     0,     0,     0,     0,  2201,     0,     0,     0,     0,
       0,  1922,     0,  2203,   666,     0,     0,     0,     0,  2204,
       0,     0,     0,  4583,  1922,     0,     0,     0,  1791,     0,
     369,     0,     0,     0,     0,   668,  1930,     0,   369,     0,
       0,     0,     0,  2205,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1792,  1086,     0,     0,  3913,  3914,     0,
       0,  1086,     0,  1189,  1189,     0,     0,     0,     0,     0,
       0,     0,     0,  3923,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3931,  1922,     0,
       0,     0,     0,     0,     0,     0,  3940,     0,     0,     0,
       0,     0,     0,     0,  1922,     0,     0,  1183,     0,     0,
    3956,  1793,     0,     0,     0,     0,     0,  1922,  1183,     0,
       0,     0,  1222,     0,     0,  2199,     0,     0,  2200,     0,
     668,     0,   668,     0,     0,  1189,     0,     0,     0,     0,
       0,     0,     0,     0,  2206,  2201,     0,     0,  2207,     0,
    1086,  1920,     0,  2203,     0,     0,  1189,  1189,     0,  2204,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2208,
    2209,     0,  1086,  1086,  1086,     0,  1189,  2112,  1183,     0,
       0,  1581,  1988,  2205,     0,     0,  2210,     0,     0,  1922,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1930,
       0,     0,     0,     0,   370,     0,   668,     0,     0,  1922,
       0,  1189,  2211,  1189,  1189,  2212,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   816,     0,  2213,     0,
       0,  2214,     0,     0,  1922,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   666,  1563,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   666,  2199,
       0,     0,  2200,     0,     0,     0,     0,  1920,     0,     0,
    1922,     0,     0,     0,     0,     0,     0,     0,     0,  2201,
       0,     0,     0,     0,  2206,  2087,  2087,  2203,  2207,     0,
    1086,     0,  1015,  2204,     0,     0,     0,     0,     0,     0,
    4096,  4097,  4098,     0,     0,  2215, -2139,  1086,     0,  2208,
    2209,     0,   666,     0,     0,  2122,     0,  2205,  1086,     0,
       0,  2128,     0,     0,     0,     0,  2210,     0,     0,     0,
       0,     0,     0,  1563,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2211, -2139,     0,  2212,     0,     0,     0,     0,
       0,     0,  1563,     0,   370, -2139,     0,     0,  2213, -2139,
       0,  2214,     0,     0, -2139,  1920,     0,     0,     0, -2139,
       0,     0, -2139,     0, -2139,     0,     0,     0,     0,     0,
    1563,  1563,     0,  1563,     0,  2216,  2217,  2218,  1920,  2219,
    2220,  2221,  2222,  2223,  2224,     0,     0,     0,     0,  4177,
    1563, -2139,     0,     0,     0,     0,     0,     0,  2206,     0,
       0,     0,  2207,     0,  2112,     0,     0,     0,  1920,     0,
     712,   712,     0, -2139,     0,   666,     0,     0,     0,     0,
       0,     0,     0,  2208,  2209,  2215,     0,     0,     0,     0,
       0,     0,     0,     0,  3830,     0,     0,     0,     0,  1086,
    2210,     0,  1563,     0,     0,  1922,     0,     0,  1920,  1930,
   -2139,     0,  1920,  1920,     0,     0,     0,     0, -2139,     0,
       0,     0,     0,     0,     0,     0,  2211,     0,     0,  2212,
       0,  1563,     0,     0,  2112,  1563,  1563,     0,  2112,  2112,
       0,     0,  2213,     0,     0,  2214,  1086,  1086,  2338,     0,
       0,     0,     0,     0,   668,     0,     0,     0,     0,     0,
       0,     0,     0,  2490,     0, -2139,     0,     0,     0,     0,
     666,     0,   666,     0,   712,  2216,  2217,  2218,     0,  2219,
    2220,  2221,  2222,  2223,  2224,     0,     0,     0,     0,  4434,
       0,     0,  1930,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1019,     0,     0,     0,     0,   668,     0,     0,     0,  2215,
       0,     0,  4327,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2139,     0,     0,     0,     0,     0,
       0,  4353,     0,     0,   816,     0,   666,     0,     0,  1922,
       0,     0,     0,     0,     0,     0,     0, -2139,     0, -2139,
   -2139,     0,     0,     0,     0,  1930,     0,     0,  4370,     0,
       0,     0,  1086,  2498,     0,     0,     0,     0,     0,  1086,
       0,     0,  1189,     0,  1930,  1922,     0,     0,     0,     0,
       0,     0, -2139,     0,     0, -2139, -2139,   370, -2139,  1222,
       0,     0,  1930,     0,     0,  1086,     0,     0,  1086,  2216,
    2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,  2224,     0,
       0,     0,     0,  4468,     0,     0,     0,     0,  1086,     0,
    1930,     0,     0,     0,     0,     0,  1189,  1189,  1189,  1189,
    1086,     0,     0,     0,   370,     0,     0,     0,     0,     0,
       0,     0,   370,     0,  1086,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2606,     0,  1086,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1189,  1189,
       0,     0,     0,     0,  1189,     0,     0,     0,     0,     0,
       0,     0,     0,  1930,     0,     0,     0,  1922,     0,     0,
       0,     0,     0,     0,   816,     0,     0,     0,  1922,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1189,
       0,     0,  4469,  4470,  4471,  4472,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1189,  1189,  1189,  1189,
       0,     0,     0,     0,     0,     0,     0,     0,  1086,     0,
       0,     0,     0,     0,  1086,     0,     0,  2606,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1183,     0,     0,     0,     0,     0,     0,   712,
       0,  1183,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1222,     0,     0,     0,     0,  1189,     0,     0,     0,
    1188,  1190,     0,  1922,  1193,  1189,  1195,     0,     0,     0,
       0,  1189,  1189,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1235,  1086,     0,     0,     0,     0,
       0,  1922,     0,     0,   666,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1287,     0,     0,  1922,  1290,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2087,
       0,     0,     0,     0,     0,  1313,  1189,     0,  1183,     0,
    1930,     0,  1086,  1086,     0,  1189,     0,     0,     0,     0,
       0,  1086,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1922,     0,   666,     0,     0,  1015,  1015,
       0,     0,  2827,     0,     0,  2988,  1563,  1563,     0,     0,
       0,     0,     0,     0,  1563,     0,     0,  1563,     0,     0,
       0,  1563,     0,     0,     0,     0,     0,     0,     0,  1563,
    1563,     0,  2199,     0,     0,  2200,     0,  1563,     0,  1222,
    1563,  1563,  1563,  1563,     0,     0,     0,     0,     0,     0,
    1563,  1563,  2201,  1563,     0,  1563,  1563,     0,     0,  1563,
    2203,     0,     0,     0,     0,     0,  2204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1563,   816,     0,     0,
    1189,  1563,     0,     0,     0,  1563,     0,     0,     0,  1563,
    2205,  1563,  1563,  1563,  1563,  1563,  1563,  1563,  1563,  1563,
       0,  1563,  2199,     0,     0,  2200,  1086,  1563,     0,     0,
    1563,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2201,     0,   816,     0,  4669,     0,     0,     0,
    2203,  1086,   816,     0,     0,     0,  2204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1922,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2205,     0,     0,     0,     0,     0,     0,     0,  1086,     0,
    1086,     0,  1563,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2206,     0,     0,     0,  2207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1086,     0,     0,     0,
       0,     0,  3040,     0,  3047,     0,  2208,  2209,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2199,  2210,     0,  2200,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3161,  2201,     0,     0,     0,  2490,  3168,     0,  2211,
    2203,  2206,  2212,  1922,     0,  2207,  2204,     0,  1930,  1800,
    1801,     0,     0,     0,     0,  2213,     0,   712,  2214,     0,
       0,     0,  1015,     0,  1015,     0,  2208,  2209,     0,     0,
    2205,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1563,     0,  2210,     0,     0,     0,     0,     0,     0,
       0,     0,  1183,     0,  1189,  1189,  1189,     0,     0,  1183,
       0,  1222,     0,  1189,     0,  1189,     0,  1189,  1189,  2211,
       0,  1086,  2212,     0,     0,     0,  4789,     0,     0,     0,
       0,  1890,     0,     0,     0,  2213,     0,     0,  2214,     0,
       0,     0,  2215,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1948,  1949,     0,     0,     0,     0,     0,  2498,
       0,  1922,     0,  1581,     0,  3176,     0,     0,     0,     0,
    3185,     0,  1980,     0,     0,     0,  1086,     0,     0,     0,
       0,  2206,     0,     0,  1922,  2207,     0,     0,     0,     0,
       0,  1086,     0,     0,     0,  3220,  3220,     0,  1930,     0,
       0,     0,   712,     0,     0,     0,  2208,  2209,     0,  2013,
    2015,     0,  2215,     0,  1922,     0,     0,     0,     0,  1189,
       0,     0,     0,  2210,     0,     0,     0,     0,     0,     0,
       0,     0,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,
    2223,  2224,     0,     0,     0,  3278,  4695,  3281,  3283,  2211,
       0,     0,  2212,     0,  1922,     0,     0,  4879,  1922,  1922,
       0,     0,     0,     0,     0,  2213,     0,     0,  2214,     0,
       0,     0,     0,  2490,     0,  1189,     0,     0,     0,     0,
       0,     0,     0,  1189,     0,     0,     0,     0,  1189,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1563,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,
    2223,  2224,     0,     0,     0, -2141,  4737,     0,     0,     0,
       0,     0,     0,     0,     0,  2498,     0,     0,  3220,     0,
    1086,     0,  3376,     0,     0,  1015,     0,     0,     0,     0,
       0,     0,  2215,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3278, -2141,     0,     0,     0,     0,     0,     0,  1189,
    3401,     0,  1930,     0, -2141,     0,     0,     0, -2141,     0,
       0,     0,  1988, -2141,     0,     0,     0,  2199, -2141,     0,
    2200, -2141,     0, -2141,     0,     0,     0,     0,     0,  1189,
       0,  1189,  3220,  1189,  3220,     0,     0,  2201,     0,     0,
       0,     0,     0,     0,     0,  2203,     0,     0,     0,     0,
   -2141,  2204,     0,     0,     0,     0,  1563,     0,     0,     0,
       0,     0,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,
    2223,  2224, -2141,     0,     0,  2205,  4791,  2087,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2141,
       0,     0,     0,     0,     0,     0,     0, -2141,     0,     0,
       0,     0,     0,  1183,     0,     0,     0,     0,     0,  1183,
       0,     0,     0,  2199,     0,     0,  2200,     0,     0,     0,
    1189,     0,     0,     0,     0,     0,  1563,  1563,     0,     0,
       0,     0,  1563,  2201,     0,     0,     0,     0,     0,     0,
       0,  2203,     0,     0, -2141,     0,     0,  2204,     0,  2988,
    2988,  2988,     0,     0,     0,     0,  2206,  1563,  1563,     0,
    2207,     0,  1563,     0,     0,     0,     0,     0,     0,     0,
       0,  2205,     0,     0,  1563,  1563,  1563,  1563,     0,     0,
       0,  2208,  2209,     0,     0,     0,     0,  1563,     0,  1019,
    1563,     0,  1563,  3567,     0,     0,     0,     0,  2210,     0,
       0,     0,  1563,  1563,     0,     0,  1563,     0,     0,     0,
       0,     0,     0, -2141,     0,     0,     0,     0,     0,  1563,
       0,  1563,     0,  1222,  2211,  1563,     0,  2212,     0,     0,
       0,     0,     0,     0,     0,     0, -2141,     0, -2141, -2141,
    2213,  1563,     0,  2214,     0,  1086,     0,     0,  2513,     0,
       0,     0,  3613,     0,  1563,  1563,  1563,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2141,  2206,     0, -2141, -2141,  2207, -2141,  1563,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1563,  1930,     0,     0,     0,  1563,     0,  2208,  2209,     0,
       0,  1563,  2575,  2576,  2577,  2578,     0,     0,     0,  3613,
       0,     0,  3671,     0,  2210,     0,  3047,  2215,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2490,  3168,     0,  3168,     0,     0,     0,
    2211,     0,     0,  2212,  2614,  2615,     0,     0,     0,     0,
    2624,     0,     0,     0,     0,     0,  2213,     0,     0,  2214,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1563,
       0,  3220,     0,     0,     0,     0,  2087,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2154,     0,
       0,     0,  1930,     0,  1930,  2648,     0,     0,     0,     0,
       0,     0,  1189,     0,  1189,  1189,  1189,  2216,  2217,  2218,
       0,  2219,  2220,  2221,  2222,  2223,  2224,     0,     0,     0,
       0,  5000,  2683,  2684,  2685,  2686,     0,     0,     0,     0,
       0,     0,     0,  2215,     0, -2154,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2154,  1930,     0,
       0, -2154,     0,     0,     0,     0, -2154,     0,     0,     0,
       0, -2154,     0,     0, -2154,     0, -2154,     0,     0,     0,
       0,     0,     0,  1930,     0,     0,     0,     0,     0,     0,
       0,     0,  2745,     0,     0,     0,     0,     0,     0,     0,
       0,  2749,     0, -2154,  3168,     0,     0,     0,  2756,     0,
       0,     0,     0,     0,     0,     0,     0,  3168,     0,     0,
       0,     0,     0,     0,     0, -2154,     0,     0,     0,  2199,
       0,     0,  2200,  2216,  2217,  2218,     0,  2219,  2220,  2221,
    2222,  2223,  2224,     0,     0,     0,     0,  5089,     0,  2201,
       0,     0,     0,  3016,     0,     0,     0,  2203,     0,     0,
       0,     0, -2154,  2204,     0,     0,     0,     0,     0,     0,
   -2154,     0,     0,   824,     0,     0,     0,     0,     0,     0,
       0,  1930,     0,     0,     0,     0,     0,  2205,     0,     0,
       0,     0,  3220,  3220,     0,     0,     0,  3168,     0,     0,
       0,     0,     0,     0,     0,  2199,     0,     0,  2200,     0,
    1930,     0,     0,     0,     0,  3876,     0, -2154,   824,     0,
       0,     0,     0,     0,     0,  2201,     0,     0,     0,     0,
       0,     0,  3017,  2203,     0,     0,     0,     0,     0,  2204,
       0,     0,  1086,  1086,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1086,     0,
       0,     0,  1019,  2205,     0,  1047,     0,     0,     0,     0,
       0,  2087,  1086,  1047,     0,  1047,  2929,     0,     0,     0,
    2087,  1086,  1930,     0,     0,     0, -2154,   824,  2206,     0,
       0,     0,  2207,     0,     0,  1086,     0,     0,     0,     0,
       0,     0,  1930,     0,     0,     0,     0,     0,     0, -2154,
     712, -2154, -2154,  2208,  2209,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1189,     0,  1930,  1189,     0,
    2210,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2154,  1183,     0, -2154, -2154,     0,
   -2154,     0,     0,     0,     0,     0,  2211,     0,     0,  2212,
       0,     0,     0,  1930,  2206,     0,  1086,     0,  2207,     0,
       0,     0,  2213,     0,     0,  2214,  1189,     0,     0,     0,
       0,     0,     0,     0,  1563,     0,     0,     0,     0,  2208,
    2209,     0,     0,     0,  1563,     0,     0,     0,     0,     0,
    1563,     0,  1563,     0,  2988,     0,  2210,     0,  1563,     0,
       0,  1563,  1563,  1563,  1563,  1563,  1563,  1563,  1563,  1563,
    1563,     0,     0,     0,  1563,  1563,     0,     0,     0,     0,
       0,     0,  2211,     0,     0,  2212,     0,  1563,     0,     0,
       0,  1563,     0,     0,     0,  1563,     0,     0,  2213,  2215,
       0,  2214,     0,     0,     0,  1563,     0,     0,  1563,     0,
    1563,     0,     0,     0,     0,     0,     0,     0,     0,  1563,
    1563,  1563,     0,     0,     0,  1563,     0,     0,  1563,     0,
       0,     0,     0,     0,     0,  1086,  1086,  1086,  1183,  3613,
    4107,     0,     0,     0,  4107,  4121,     0,     0,     0,  1563,
    3018,     0,     0,     0,     0,  4135,     0,  1563,     0,  1563,
    3122,  3123,  3124,     0,     0,     0,     0,     0,     0,  3134,
       0,  3136,     0,  3138,  3139,  2215,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2216,
    2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,  2224,     0,
       0,  1563,     0,     0,     0,     0,     0,  1563,  3168,     0,
       0,  3047,     0,  1563,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4183,  2087,
    2087,     0,  2606,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1189,  1189,  1189,  1189,     0,  2216,  2217,  2218,     0,  2219,
    2220,  2221,  2222,  2223,  2224,  3246,     0,  4145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4226,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3304,     0,     0,     0,     0,     0,     0,     0,  3313,
       0,     0,     0,     0,  3314,     0,     0,     0,     0,     0,
       0,     0,  1930,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4287,     0,     0,     0,  2199,     0,     0,  2200,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2490,     0,
       0,     0,     0,     0,  2201,     0,     0,     0,     0,     0,
       0,     0,  2203,     0,     0,     0,     0,     0,  2204,  3876,
       0,     0,     0,     0,     0,     0,     0,  1086,     0,     0,
       0,     0,     0,     0,     0,  3399,     0,     0,  1189,     0,
    1563,     0,  2205,     0,     0,     0,  1086,     0,     0,     0,
       0,     0,  4358,     0,     0,     0,     0,     0,     0,     0,
       0,  2498,     0,     0,     0,     0,     0,  3435,     0,  3437,
       0,     0,     0,  1086,     0,     0,     0,     0,     0,     0,
       0,     0,  3278,     0,     0,     0,     0,     0,  4387,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1563,  1563,     0,     0,     0,     0,
    1930,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1930,  3539,     0,     0,     0,     0,  3540,     0,  3220,
       0,  3220,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2206,     0,     0,   824,  2207,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,  2988,  1185,     0,  1563,     0,  2988,  2208,  2209,
       0,     0,     0,     0,     0,     0,  3492,     0,     0,  2988,
       0,     0,     0,     0,     0,  2210,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,  1563,     0,     0,     0,     0,     0,     0,     0,
       0,  2211,  1563,  1563,  2212,     0,     0,     0,     0,     0,
    1563,  1563,     0,     0,     0,  1563,     0,  2213,     0,     0,
    2214,  1563,  1563,     0,     0,  1563,  1930,  1086,  1086,  1086,
    1086,     0,     0,     0,  4107,  4121,  4107,     0,     0,  4476,
       0,     0,  1185,  3613,     0,     0,     0,  3613,     0,     0,
       0,     0,  1185,  4489,  1930,     0,     0,  1563,     0,     0,
       0,     0,  1563,     0,     0,     0,     0,     0,  4499,     0,
    1930,     0,     0,     0,  1563,     0,     0,     0,     0,     0,
       0,     0,     0,  1222,     0,     0,     0,     0,     0,     0,
       0,  3671,     0,     0,  2215,  3047,     0,     0,     0,     0,
       0,     0,     0,  1923,  2199,     0,     0,  2200,     0,     0,
    1015,     0,     0,  1563,     0,     0,  1930,     0,     0,     0,
       0,     0,     0,     0,  2201,     0,     0,     0,     0,     0,
       0,     0,  2203,  3220,  3220,     0,     0,     0,  2204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4552,     0,     0,
       0,     0,  2205,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,  1047,     0,     0,     0,  1047,     0,     0,     0,
       0,     0,     0,     0,  2216,  2217,  2218,     0,  2219,  2220,
    2221,  2222,  2223,  2224,     0,     0,     0,     0,     0,     0,
       0,  1185,  1189,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1189,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4667,     0,     0,     0,     0,     0,     0,
       0,  5063,     0,     0,     0,     0,     0,     0,  3720,     0,
    3721,  3722,  3723,     0,     0,  3876,  3876,  3876,  3876,  3876,
       0,     0,     0,  2206,     0,     0,  1923,  2207,     0,     0,
    1930,     0,     0,     0,     0,     0,     0,     0,     0,  1563,
       0,     0,     0,     0,     0,     0,     0,     0,  2208,  2209,
    1183,     0,     0,     0,     0,  2498,     0,     0,     0,     0,
       0,     0,  2087,     0,     0,  2210,     0,     0,     0,     0,
       0,     0,     0,     0,  1189,  2498,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2211,     0,     0,  2212,     0,     0,     0,     0,     0,
       0,  1086,     0,  4673,     0,     0,     0,  2213,     0,     0,
    2214,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,  5064,     0,  1185,
       0,  1563,     0,     0,  2199,     0,     0,  2200,     0,     0,
    1563,     0,     0,     0,     0,     0,  3168,     0,     0,     0,
       0,     0,  1931,     0,  2201,     0,     0,  1563,  1563,     0,
       0,  1563,  2203,     0,     0,     0,     0,     0,  2204,     0,
    4107,     0,     0,     0,  3613,     0,     0,     0,     0,  3613,
       0,     0,  3613,  3278,  2215,  4717,     0,  1563,  1563,  1185,
       0,     0,  2205,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4183,  1222,  1189,  1189,  1189,     0,     0,     0,     0,     0,
    1925,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3168,     0,     0,     0,  1185,  1183,
    1222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2216,  2217,  2218,  1930,  2219,  2220,
    2221,  2222,  2223,  2224,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2206,     0,     0,  1923,  2207,  2087,     0,
       0,     0,  1183,     0,     0,     0,     0,  1930,     0,     0,
       0,  1086,     0,     0,     0,  1931,     0,     0,  2208,  2209,
       0,  3989,  4358,     0,  3990,     0,     0,     0,     0,  3220,
       0,     0,     0,  2498,     0,  2210,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,  4387,     0,  1930,  1086,     0,
    1923,  1930,  1930,     0,     0,     0,  1189,  4183,     0,     0,
       0,  2211,     0,     0,  2212,     0,     0,     0,     0,     0,
       0,     0,  4016,  1185,     0,     0,     0,  2213,     0,  1923,
    2214,  1563,     0,     0,  1563,     0,  1563,     0,     0,     0,
       0,     0,     0,  1925,     0,     0,     0,     0,     0,  4063,
       0,  1185,  1185,  1563,  1185,     0,     0,  3613,     0,     0,
    4717,     0,     0,     0,     0,     0,  4866,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,  4667,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1189,     0,
       0,     0,  1086,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1923,     0,  2215,     0,     0,     0,     0,     0,
    1189,  1189,  1189,  1189,  2199,     0,     0,  2200,  4064,     0,
       0,  1923,     0,  1185,   824,  2087,     0,     0,     0,     0,
       0,     0,     0,     0,  2201,     0,     0,  3502,     0,  1923,
       0,     0,  2203,  1183,     0,     0,     0,     0,  2204,     0,
       0,  2199,  1185,     0,  2200,     0,  1185,  1185,     0,     0,
       0,     0,  1563,  2199,     0,     0,  2200,  1923,     0,     0,
       0,  2201,  2205,     0,     0,     0,     0,     0,     0,  2203,
       0,     0,     0,  2201,     0,  2204,  3547,     0,     0,     0,
       0,  2203,     0,     0,  2216,  2217,  2218,  2204,  2219,  2220,
    2221,  2222,  2223,  2224,     0,     0,     0,     0,     0,  2205,
       0,     0,  1563,     0,     0,     0,     0,     0,  1189,     0,
    1222,  2205,     0,     0,     0,     0,     0,     0,     0,  1563,
    1923,     0,     0,     0,     0,  1931,     0,     0,     0,     0,
       0,   824,     0,     0,     0,     0,     0,     0,  1047,     0,
       0,     0,     0,     0,     0,     0,  4200,  4201,  4202,  4203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1189,
       0,     0,     0,  2206,  1183,     0,     0,  2207,     0,     0,
       0,  1047,     0,     0,     0,  4183,     0,     0,     0,  1931,
       0,     0,     0,     0,  4673,     0,     0,     0,  2208,  2209,
       0,     0,     0,  4866,     0,     0,  1563,  1563,     0,     0,
    2206,     0,     0,  1925,  2207,  2210,     0,     0,  1931,  1183,
       0,     0,  2206,     0,     0,     0,  2207,  1189,     0,     0,
       0,     0,     0,     0,     0,  2208,  2209,     0,     0,     0,
       0,  2211,     0,     0,  2212,     0,     0,  2208,  2209,     0,
       0,     0,  2210,     0,     0,     0,     0,  2213,     0,     0,
    2214,  1563,     0,     0,  2210,     0,     0,  1925,     0,     0,
       0,  1563,  1047,     0,     0,     0,  1189,     0,  2211,     0,
       0,  2212,     0,     0,     0,     0,     0,     0,     0,     0,
    2211,  1931,     0,  2212,  2213,     0,  1925,  2214,     0,     0,
       0,     0,     0,     0,     0,     0,  2213,     0,     0,  2214,
    1931,  3517,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4345,     0,     0,  1923,  1931,     0,
       0,     0,     0,  1563,  2215,     0,     0,     0,     0,     0,
       0,     0,  1183,     0,     0,     0,     0,     0,     0,     0,
       0,   824,     0,     0,     0,     0,  1931,     0,  2199,     0,
       0,  2200,     0,     0,     0,     0,     0,     0,     0,  1925,
       0,  2215,     0,     0,     0,     0,     0,     0,  2201,     0,
       0,     0,     0,  2215,     0,     0,  2203,     0,  1925,     0,
       0,     0,  2204,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1925,     0,     0,     0,
       0,     0,     0,  1185,     0,     0,  2205,     0,     0,  1931,
       0,     0,  1185,     0,  2216,  2217,  2218,     0,  2219,  2220,
    2221,  2222,  2223,  2224,  1925,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,
    2224,     0,     0,  2216,  2217,  2218,     0,  2219,  2220,  2221,
    2222,  2223,  2224,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1925,     0,     0,
       0,  3552,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,  2206,     0,     0,
       0,  2207,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2208,  2209,     0,     0,     0,  1185,  1185,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,  1185,  2210,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
    1185,  1185,     0,     0,     0,     0,     0,     0,  1185,     0,
       0,  1185,  1185,  1185,  1185,  2211,     0,     0,  2212,     0,
       0,  1185,  1185,     0,  1185,     0,  1185,  1185,     0,     0,
    1185,  2213,     0,     0,  2214,     0,     0,     0,  1923,     0,
       0,     0,     0,  1923,  1923,     0,  1931,  1185,   824,     0,
       0,  2199,  1185,     0,  2200,  1923,  1185,     0,     0,     0,
    1185,     0,  1185,  1185,  1185,  1185,  1185,  1185,  1185,  1185,
    1185,  2201,  1185,     0,  3558,     0,     0,     0,  1185,  2203,
       0,  1185,     0,     0,     0,  2204,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2215,  2205,
       0,     0,     0,     0,     0,     4,     0,     0,     0,     0,
       0,     0,     0,     0,  1925,     0,     0,     0,  4577,     0,
       0,     0,     0,     0,     0,     5,     0,     0,     0,     0,
       0,     0,  4580,  1185,     0,     6,     7,     0,     0,     0,
       0,     8,     0,     9,    10,     0,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,    36,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,  1923,    45,     0,  2216,  2217,
    2218,     0,  2219,  2220,  2221,  2222,  2223,  2224,     0,     0,
    2206,     0,     0,     0,  2207,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2208,  2209,     0,     0,     0,
    4646,     0,     0,   824,    46,  2199,     0,     0,  2200,     0,
       0,     0,  2210,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2201,     0,     0,     0,     0,
    1923,     0,  1185,  2203,     0,     0,     0,     0,  2211,  2204,
       0,  2212,     0,  1185,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,     0,  2213,     0,     0,  2214,     0,     0,
       0,     0,     0,  2205,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    47,     0,     0,     0,     0,     0,
       0,  1047,     0,     0,     0,     0,     0,  1931,     0,     0,
       0,    48,  1931,  1931,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1931,     0,     0,     0,     0,     0,
       0,    49,     0,     0,     0,     0,     0,     0,     0,     0,
     824,     0,     0,   824,     0,     0,     0,     0,     0,  1923,
       0,  2215,     0,    50,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4742,  4744,
    4744,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2206,  1925,     0,     0,  2207,    51,
    1925,  1925,    52,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1925,     0,     0,     0,     0,    53,     0,  2208,
    2209,     0,     0,     0,     0,     0,     0,  1045,     0,     0,
       0,     0,     0,     0,     0,  1045,  2210,  1045,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2216,  2217,  2218,     0,  2219,  2220,  2221,  2222,  2223,
    2224,     0,  2211,     0,     0,  2212,     0,     0,     0,     0,
       0,     0,  1185,     0,  1931,     0,     0,     0,  2213,     0,
       0,  2214,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   824,    54,     0,     0,     0,     0,     0,  2199,     0,
       0,  2200,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4832,     0,     0,     0,     0,     0,  2201,     0,
       0,  4070,     0,     0,     0,     0,  2203,     0,     0,     0,
       0,     0,  2204,     0,    55,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    56,  1931,
       0,     0,  1925,     0,     0,  2215,  2205,     0,     0,     0,
       0,     0,     0,    57,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4020,     0,     0,     0,     0,     0,     0,     0,    58,
       0,     0,     0,     0,  4876,    59,     0,  1185,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,    67,    68,
       0,    69,    70,    71,    72,    73,     0,  4895,     0,  4897,
       0,     0,     0,     0,     0,     0,     0,  1925,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2216,  2217,  2218,  1931,  2219,
    2220,  2221,  2222,  2223,  2224,     0,     0,  2206,     0,     0,
       0,  2207,     0,     0,  1185,     0,     0,     0,  1923,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2208,  2209,     0,     0,     0,  1185,  1185,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,  2210,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1923,  1923,     0,  1923,     0,     0,     0,     0,  1185,  1185,
       0,     0,     0,  1185,  4744,  2211,  1925,     0,  2212,     0,
       0,     0,     0,     0,     0,  1185,  1185,  1185,  1185,     0,
       0,  2213,     0,   824,  2214,     0,     0,     0,  1185,   824,
       0,  1185,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,  1185,  2199,     0,  1185,  2200,  1923,
       0,  1923,     0,     0,     0,  4997,     0,     0,     0,     0,
    1185,     0,  1185,     0,     0,  2201,  1185,     0,     0,     0,
       0,     0,     0,  2203,     0,     0,     0,     0,     0,  2204,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,     0,  1185,  1185,  1185,  2215,     0,
       0,     0,     0,  2205,     0,  1923,     0,     0,     0,     0,
       0,     0,     0,  5033,     0,     0,     0,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1923,  1185,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
    1185,  1923,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  5070,     0,  1923,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2216,  2217,
    2218,     0,  2219,  2220,  2221,  2222,  2223,  2224,     0,     0,
       0,     0,     0,     0,  2206,     0,     0,     0,  2207,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1923,  2208,
    2209,     0,     0,     0,     0,     0,     0,  1931,     0,     0,
       0,     0,     0,     0,  1923,     0,  2210,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1923,     0,   880,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   881,  2211,     0,     0,  2212,     0,     0,     0,  1931,
    1931,     0,  1931,     0,     0,     0,     0,     0,  2213,     0,
       0,  2214,   882,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   883,     0,     0,     0,     0,
       0,   824,   824,   824,   884,  1925,     0,     0,  -736,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1923,
       0,     0,     0,     0,     0,   885,  1181,     0,  1931,     0,
    1931,   886,     0,     0,     0,  1181,     0,     0,     0,  1923,
       0,     0,     0,     0,     0,     0,   887,  1925,  1925,     0,
    1925,     0,     0,     0,     0,  2215,     0,   888,     0,     0,
       0,     0,     0,     0,  1923,   889,     0,     0,  1181,     0,
       0,     0,     0,     0,     0,     0,   890,     0,     0,     0,
       0,     0,     0,   891,  1931,     0,     0,   892,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1923,     0,  -938,     0,     0,     0,  1925,     0,  1925,  1931,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
    1931,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,   893,   824,  1931,     0,  2216,  2217,  2218,  -501,  2219,
    2220,  2221,  2222,  2223,  2224,     0,     0,     0,     0,     0,
       0,     0,  1925,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   894,
       0,     0,   895,     0,     0,     0,     0,  1925,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1931,  1925,     0,
       0,     0,     0,     0,     0,     0,  -398,     0,     0,     0,
       0,  1925,     0,  1931,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   896,     0,  1931,     0,     0,     0,
     897,     0,     0,     0,     0,     0,  -398,     0,  1181,   898,
       0,     0,     0,     0,  1045,     0,     0,     0,  1045,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,  -398,     0,   899,   900,     0,
     901,   902,     0,  1181,     0,  1925,     0,     0,     0,   903,
       0,     0,     0,     0,   904,  1923,     0,     0,     0,     0,
     905,  1925,     0,   906,     0,  1185,   907,     0,  1931,     0,
       0,     0,     0,     0,  1925,  1185,     0,     0,     0,  -398,
       0,  1185,     0,  1185,     0,     0,     0,     0,  1931,  1185,
       0,     0,  1185,  1185,  1185,  1185,  1185,  1185,  1185,  1185,
    1185,  1185,     0,     0,     0,  1185,  1185,     0,     0,     0,
       0,     0,     0,  1931,     0,     0,     0,     0,  1185,     0,
       0,     0,  1185,     0,   824,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,  1185,
       0,  1185,     0,     0,     0,     0,  1925,     0,     0,  1931,
    1185,  1185,  1185,     0,     0,     0,  1185,     0,     0,  1185,
       0,     0,     0,     0,     0,     0,  1925,     0,     0,  1185,
    1185,     0,     0,     0,     0,     0,     0,     0,   838,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
    1185,  1925,     0,     0,     0,     0,     0,     0,     0,  1923,
    1181,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   839,     0,     0,  1925,     0,     0,
       0,     0,  1185,     0,  1929,  1923,     0,   840,  1185,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   841,     0,     0,     0,     0,     0,
     842,     0,     0,     0,     0,     0,     0,     0,     0,  1185,
       0,  1181,     0,     0,     0,   843,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   844,     0,     0,     0,
       0,     0,     0,     0,   845,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   846,     0,     0,     0,     0,
     847,     0,     0,     0,     0,     0,   848,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   849,     0,     0,     0,     0,     0,     0,     0,   824,
    1181,     0,     0,   824,  1931,   824,     0,  1923,     0,     0,
       0,     0,     0,     0,     0,     0,   850,     0,  1923,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   851,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1929,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   852,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   824,  1925,     0,     0,     0,  1181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   853,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,  1185,     0,   854,     0,     0,     0,   855,     0,   856,
       0,     0,     0,  1923,     0,   857,     0,     0,   858,     0,
       0,     0,     0,  1181,  1181,     0,  1181,     0,  1931,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1923,     0,  1181,   859,     0,   860,     0,     0,     0,
     861,     0,     0,     0,     0,     0,     0,  1923,   862,     0,
       0,     0,     0,   863,  1931,  1185,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,   864,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   865,     0,
       0,     0,     0,     0,  1252,  1181,     0,     0,     0,     0,
       0,     0,     0,  1923,     0,     0,  1925,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,  1185,  1253,  1181,  1181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1254,  1255,  1925,     0,     0,     0,     0,     0,     0,  1256,
       0,     0,     0,  1257,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
    1258,     0,     0,  1185,  1185,     0,  1931,     0,     0,     0,
       0,  1185,  1185,     0,     0,     0,  1185,  1931,     0,     0,
       0,  1259,  1185,  1185,     0,     0,  1185,     0,     0,     0,
       0,     0,  1260,     0,     0,     0,     0,  1929,     0,     0,
    1261,     0,     0,     0,  1185,     0,     0,     0,  1185,     0,
    1045,  1262,     0,     0,     0,     0,  1263,     0,  1185,     0,
       0,     0,     0,  1185,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,  1264,     0,     0,
       0,     0,     0,  1045,  1925,     0,     0,  1923,     0,     0,
       0,  1929,     0,     0,     0,  1925,     0,     0,     0,     0,
       0,     0,  1265,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
    1929,     0,     0,  1266,     0,     0,     0,     0,     0,     0,
       0,     0,  1931,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   824,     0,     0,  1267,     0,     0,     0,     0,     0,
    1931,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1045,     0,  1931,     0,     0,     0,
       0,     0,   853,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1929,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1923,     0,     0,     0,     0,     0,  1268,
    1925,     0,  1929,  1269,     0,  1270,     0,     0,     0,     0,
       0,  1271,  1931,     0,  1272,     0,     0,     0,     0,     0,
    1929,     0,     0,     0,     0,     0,     0,     0,  1925,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1273,     0,  1274,     0,  1925,     0,  1275,     0,  1929,     0,
       0,     0,     0,     0,  1276,     0,     0,     0,     0,  1277,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1185,     0,     0,  1278,     0,     0,     0,     0,     0,
    1925,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1923,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,  1929,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1923,     0,     0,     0,     0,  1931,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1923,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,  1931,     0,     0,     0,
       0,  1185,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,  1185,
       0,     0,  1185,     0,  1923,     0,     0,     0,  1923,  1923,
       0,  1181,     0,     0,     0,  1185,     0,     0,     0,     0,
    1185,     0,     0,  1185,     0,     0,     0,     0,  1185,  1185,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1181,
    1181,     0,     0,     0,  1925,     0,     0,  1181,     0,     0,
    1181,  1185,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,  1181,  1181,     0,     0,     0,     0,     0,     0,
    1181,     0,     0,  1181,  1181,  1181,  1181,     0,     0,     0,
       0,     0,  1931,  1181,  1181,     0,  1181,     0,  1181,  1181,
    1185,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1929,  1181,
       0,     0,     0,     0,  1181,     0,     0,     0,  1181,   824,
       0,     0,  1181,     0,  1181,  1181,  1181,  1181,  1181,  1181,
    1181,  1181,  1181,  1185,  1181,     0,     0,     0,     0,     0,
    1181,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1925,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1185,     0,
    1931,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,     0,  1185,  1931,     0,  1185,     0,  1185,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,  1185,     0,
       0,     0,     0,  1931,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1925,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   824,
       0,     0,     0,  1931,     0,     0,     0,  1931,  1931,     0,
       0,  1925,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1925,     0,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
       0,     0,     0,  1185,     0,  1181,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,  1925,     0,  1931,     0,  1925,  1925,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1045,     0,     0,     0,     0,     0,  1929,
       0,     0,     0,  1185,  1929,  1929,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1929,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1185,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1185,  1185,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1185,     0,  1181,     0,  1929,     0,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   824,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,   824,
       0,  1929,     0,  1185,     0,     0,     0,   824,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     4,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     0,     0,     0,     0,     0,     0,     0,  1181,
       0,     6,     7,     0,     0,  1926,     0,     0,     0,     9,
      10,     0,     0,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
    1929,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1181,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1181,
    1181,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
      46,     0,     0,     0,     0,     0,   720,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   720,     0,     0,     0,
    1181,  1181,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,  1181,  1181,
    1181,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1181,     0,   720,  1181,     0,  1181,     0,     0,     0,     0,
       0,     0,     0,     0,   923,  1181,  1181,   720,  1926,  1181,
      47,     0,     0,   923,     0,     0,     0,   720,     0,     0,
       0,     0,  1181,     0,  1181,     0,     0,    48,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,   720,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,    49,     0,     0,
       0,     0,     0,   923,     0,  1181,     0,  1181,  1181,  1181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    50,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1181,     0,     0,     0,     0,     0,  1100,     0,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,  1181,     0,
       0,     0,     0,     0,  1181,    51,     0,     0,    52,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    53,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    54,  1929,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      55,  1929,  1929,     0,  1929,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    56,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1149,     0,     0,    57,
       0,     0,     0,     0,     0,     0,     0,     0,  1926,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    58,     0,     0,     0,     0,
    1929,    59,  1929,     0,     0,    60,    61,    62,    63,    64,
       0,     0,    65,    66,  1381,     0,     0,     0,     0,    71,
    1382,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1926,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1929,     0,     0,     0,
       0,  1926,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1929,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1929,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1929,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1926,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1926,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1926,     0,     0,     0,     0,     0,     0,     0,  1929,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1929,     0,     0,     0,  1926,
       0,     0,     0,     0,     0,     0,     0,     0,  1929,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   923,   923,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1926,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1149,     0,     0,  1181,     0,     0,
    1929,     0,     0,     0,     0,     0,     0,  1181,     0,     0,
       0,     0,     0,  1181,     0,  1181,     0,     0,     0,     0,
    1929,  1181,     0,     0,  1181,  1181,  1181,  1181,  1181,  1181,
    1181,  1181,  1181,  1181,     0,     0,     0,  1181,  1181,     0,
       0,     0,     0,     0,     0,  1929,     0,     0,     0,     0,
    1181,     0,     0,     0,  1181,     0,     0,     0,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1181,     0,
       0,  1181,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,  1929,  1181,  1181,  1181,     0,     0,     0,  1181,     0,
       0,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1181,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,  1196,     0,     0,     0,     0,
    1181,     0,  1181,     0,     0,  1225,  1226,     0,  1229,     0,
    1232,     0,  1234,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1285,     0,     0,     0,     0,     0,     0,     0,  1293,
       0,     0,     0,     0,  1181,     0,     0,     0,  1309,  1310,
    1181,     0,     0,  1312,     0,     0,  1181,     0,     0,  1926,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1149,     0,   923,     0,     0,     0,     0,     0,     0,     0,
       0,  1181,     0,     0,     0,     0,     0,  1343,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1366,     0,     0,  1368,     0,  1370,     0,
    1373,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   720,   923,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     720,     0,   720,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   720,     0,     0,     0,  1929,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   720,   720,     0,     0,     0,     0,     0,     0,  1453,
       0,  1454,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1149,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     4,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1100,     0,     0,
       0,     0,     0,     5,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     0,     0,     0,     0,     0,
       0,     9,    10,  1181,     0,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
    1929,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,  1712,     0,
    1714,     0,     0,     0,  1716,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1929,  1181,  1181,     0,
    1926,     0,     0,     0,  1745,  1926,  1926,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1926,     0,     0,
       0,     0,    46,     0,     0,     0,     0,     0,     0,   672,
       0,     0,     0,     0,   716,     0,   716,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   716,     0,     0,     0,
    1863,     0,     0,     0,     0,     0,     0,     0,  1181,     0,
       0,     0,     0,     0,     0,     0,  1876,     0,     0,     0,
       0,     0,   716,     0,     0,     0,     0,     0,     0,  1886,
       0,     0,   716,     0,     0,     0,  1888,     0,     0,     0,
       0,     0,    47,   716,   716,  1181,     0,   716,  1937,     0,
       0,  1941,     0,   716,     0,  1181,  1181,  1007,  1929,    48,
       0,     0,     0,  1181,  1181,     0,     0,     0,  1181,  1929,
       0,     0,     0,     0,  1181,  1181,     0,  1007,  1181,    49,
       0,     0,     0,     0,  1984,     0,     0,     0,     0,     0,
       0,     0,     0,   716,     0,     0,  1181,     0,     0,     0,
    1181,    50,     0,     0,     0,     0,     0,  1926,     0,     0,
    1181,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    51,     0,     0,
      52,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    53,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   720,  1181,   720,     0,     0,
     720,     0,   720,     0,     0,   720,   720,   720,     0,     0,
       0,     0,  1926,     0,  1929,     0,     0,     0,   720,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   720,     0,   720,     0,     0,     0,     0,     0,     0,
       0,     0,  1929,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1929,     0,
      54,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    55,     0,  1929,     0,     0,     0,     0,     0,
       0,  1926,     0,     0,     0,     0,    56,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    57,     0,     0,     0,     0,   716,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    58,     0,     0,
       0,     0,  1181,    59,     0,     0,     0,    60,    61,    62,
      63,    64,     0,  1181,    65,    66,  1381,  2039,     0,     0,
       0,    71,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1100,     0,     0,     0,
       0,  1929,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,  1929,     0,
       0,     0,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2369,     0,     0,  2369,     0,     0,
    1181,  1181,     0,     0,  1181,  2376,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1181,     0,     0,
       0,     0,  1181,  2385,     0,  1181,     0,     0,     0,     0,
    1181,  1181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1927,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2455,     0,  1181,     0,     0,     0,     0,     0,     0,
       0,     0,   716,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1929,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   716,   716,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1926,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   716,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1926,  1926,     0,  1926,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1181,     0,  1929,     0,     0,     0,     0,  1927,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1181,  1929,     0,  1181,     0,  1181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1926,     0,  1926,     0,     0,  1181,     0,     0,     0,
    1181,     0,     0,     0,  2658,  1929,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2681,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1929,     0,  1926,     0,  1929,
    1929,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2729,     0,     0,     0,  2733,
       0,     0,  1926,     0,     0,     0,     0,     0,     0,     0,
    2744,     0,  2746,     0,  2747,     0,  1181,     0,     0,  2748,
       0,     0,     0,  1926,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,  1926,     0,     0,  1331,
     716,     0,   716,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   720,     0,   720,  1929,     0,     0,   720,     0,
     720,     0,     0,   720,     0,     0,     0,   720,  2776,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1181,     0,     0,     0,     0,
     716,     0,     0,   716,   716,     0,     0,     0,     0,     0,
    1926,     0,  1181,     0,     0,     0,     0,     0,   672,     0,
    1007,     0,  1007,     0,     0,     0,  1926,     0,   672,     0,
       0,     0,   716,     0,     0,     0,     0,     0,     0,  1926,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1007,  1007,     0,     0,     0,     0,  1181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1927,  1181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1181,
    1181,     0,   716,     0,   716,     0,     0,     0,     0,     0,
       0,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,  1926,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1927,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1926,     0,     0,     0,     0,     0,     0,  2989,     0,
       0,     0,     0,     0,  1181,     0,     0,     0,     0,     0,
    1927,     0,     0,     0,  1181,     0,  1926,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   672,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   672,   672,     0,     0,  1694,
       0,     0,  1926,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1181,     0,     0,     0,
       0,     0,     0,  1927,     0,  1181,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   672,     0,     0,     0,     0,
       0,     0,  1927,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1927,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1149,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1927,     0,
       0,     0,     0,     0,  3077,  3078,     0,     0,     0,  3081,
    3082,     0,     0,  3085,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3095,     0,     0,     0,     0,     0,     0,
    3104,     0,     0,     0,  3107,  3108,     0,     0,  3111,  3112,
       0,     0,     0,     0,     0,  3117,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3133,     0,  3135,
       0,  1927,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3157,     0,     0,     0,     0,
    3159,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1926,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3177,  3178,  3181,  3183,     0,     0,     0,  3190,  3193,
       0,     0,     0,     0,     0,     0,  3204,     0,     0,  3208,
       0,     0,     0,  3212,     0,     0,     0,     0,     0,     0,
     672,     0,     0,     0,     0,   716,     0,   716,     0,     0,
     716,     0,   716,     0,  3240,   716,   716,   716,     0,     0,
       0,  2082,     0,     0,     0,  3247,     0,  3249,   716,     0,
       0,     0,  3252,     0,     0,     0,     0,  3256,  3257,  3258,
    3259,   716,  3261,   716,     0,     0,     0,     0,   716,     0,
       0,     0,     0,     0,     0,  3285,  3286,  3287,     0,     0,
       0,     0,     0,     0,     0,     0,  3295,  3296,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1926,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1927,     0,
       0,     0,     0,     0,     0,     0,  3350,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1926,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2240,     0,     0,     0,
       0,     0,     0,     0,     0,   716,   716,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   672,     0,     0,     0,     0,   672,   672,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1149,     0,  1926,
       0,     0,     0,     0,     4,     0,     0,     0,     0,     0,
    1926,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     0,     0,     0,     0,   716,
       0,   672,     0,     0,     6,     7,     0,     0,  3477,     0,
       0,  2373,     9,    10,     0,     0,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,     0,    45,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   672,     0,     0,  1551,     0,
       0,     0,     0,   672,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1926,     0,     0,     0,     0,
       0,     0,     0,    46,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1622,     0,     0,     0,     0,     0,  1927,
       0,     0,     0,  1926,  1927,  1927,     0,     0,     0,     0,
       0,     0,     0,     0,   672,     0,  1927,   672,   672,  1926,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1926,     0,     0,     0,     0,
      48,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,   672,     0,     0,     0,     0,     0,     0,     0,     0,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    50,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,  3691,  3692,     0,     0,    51,     0,
       0,    52,     0,     0,     0,     0,  1927,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    53,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3714,     0,     0,     0,
       0,     0,     0,     0,     0,  3718,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3729,  3731,     0,     0,     0,  3731,     0,     0,     0,  1926,
    3742,  3743,  3744,     0,     0,     0,     0,     0,     0,     0,
       0,  1927,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    54,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,  3765,  3766,  3767,  3768,
       0,     0,   716,     0,   716,     0,     0,     0,   716,     0,
     716,     0,     0,   716,     0,     0,     0,   716,     0,     0,
       0,     0,  2240,    55,     0,     0,  3784,  3785,  3786,  1186,
       0,     0,     0,     0,     0,     0,  3799,    56,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    57,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1927,     0,     0,     0,     0,  1926,     0,     0,    58,     0,
       0,     0,     0,     0,    59,     0,     0,     0,    60,    61,
      62,    63,    64,     0,     0,    65,    66,  1381,  2757,     0,
    3838,     0,    71,     0,     0,     0,     0,     0,  3842,     0,
       0,     0,     0,     0,     0,     0,  2137,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2161,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3910,     0,     0,     0,     0,     0,     0,     0,
       0,  2082,     0,  2186,  2187,     0,  2190,     0,  2990,     0,
       0,     0,     0,  1926,     0,     0,  1186,  2373,     0,     0,
       0,     0,     0,  2230,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,  3938,     0,  1926,  3941,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1932,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1926,     0,   923,     0,
       0,  3981,     0,     0,     0,  2284,     0,     0,     0,     0,
     672,     0,     0,     0,     0,  3991,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2306,     0,  1926,     0,  2318,  2321,
    1926,  1926,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   672,     0,     0,     0,   672,     0,     0,     0,
       0,     0,  3061,     0,  1694,     0,     0,   716,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1927,
       0,     0,     0,  1932,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,  1927,  1927,     0,  1927,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
    1186,     0,  1186,     0,     0,     0,     0,     0,     0,     0,
    1927,     0,  1927,     0,     0,     0,     0,     0,   672,  1186,
       0,     0,     0,     0,     0,     0,   672,     0,   672,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4194,     0,  4195,     0,     0,     0,     0,     0,     0,  4197,
       0,     0,     0,     0,     0,     0,  1927,     0,     0,     0,
       0,  1186,     0,     0,     0,  4206,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1927,  4214,     0,     0,     0,     0,     0,     0,     0,
    1186,  4225,     0,     0,  1186,  1186,     0,     0,     0,     0,
       0,     0,  1927,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1927,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4257,  4258,  4259,
    4260,  4261,  4262,  4263,  4264,     0,     0,     0,     0,  4271,
    4272,     0,  4274,  4275,  4276,  4277,  4278,  4279,  4280,     0,
       0,     0,     0,     0,     0,     0,     0,  4288,     0,  4290,
    4291,     0,     0,  1932,     0,     0,     0,     0,     0,  1927,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1927,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4339,
    4341,  4343,     0,     0,  4346,     0,     0,  1932,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   716,  2082,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   672,     0,  1932,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1927,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2855,     0,     0,
    1927,     0,     0,     0,     0,  3731,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2878,     0,     0,  2880,     0,  1927,  2891,     0,     0,  1932,
       0,     0,     0,  2898,  2903,     0,     0,     0,     0,  2909,
       0,     0,  2914,     0,     0,     0,     0,     0,  1932,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2923,
       0,  1927,     0,     0,  2930,     0,  1932,     0,  2942,     0,
       0,     0,  2949,     0,  2951,  2952,  2953,  2954,  2955,  2956,
    2957,  2958,  2959,     0,  2960,     0,     0,     0,     0,     0,
    1551,     0,     0,  2985,  1932,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,     0,  2373,  1622,     0,  1932,     0,   672,
    1186,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4542,  4543,  4544,
    4545,     0,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,  1927,     0,     0,     0,
       0,  4557,  4558,  4559,  4560,     0,  4562,  4563,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4572,  4573,
       0,     0,     0,     0,  3109,  1186,  1186,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,  1186,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,  1186,  1186,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,  1186,
    1186,  1186,  1186,     0,     0,     0,     0,     0,     0,  1186,
    1186,     0,  1186,     0,  1186,  1186,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1932,  1186,     0,     0,     0,     0,
    1186,     0,     0,     0,  1186,     0,     0,     0,  1186,     0,
    1186,  1186,  1186,  1186,  1186,  1186,  1186,  1186,  1186,     0,
    1186,     0,     0,     0,     0,     0,  1186,     0,     0,  1186,
       0,     0,  4633,     0,     0,     0,     0,     0,     0,     0,
    1927,  4639,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4658,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1927,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4677,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   672,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3325,     0,     0,   672,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     720,     0,     0,     0,     0,     0,     0,     0,  1927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1927,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,   716,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,  4764,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3449,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1932,     0,     0,     0,     0,
    1932,  1932,     0,     0,     0,     0,     0,     0,     0,   672,
       0,     0,  1932,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1927,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3731,     0,  1927,     0,     0,     0,     0,     0,     0,     0,
    3498,     0,     0,     0,     0,  3504,     0,     0,  1927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2903,     0,  2903,
    2903,     0,     0,     0,  1927,     0,     0,     0,     0,     0,
    3561,     0,     0,  3564,     0,  3566,     0,     0,     0,     0,
       0,  4882,     0,     0,     0,     0,  4886,     0,     0,     0,
    1186,     0,  1932,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3587,     0,  3589,     0,     0,     0,  3592,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2985,  2985,  2985,
       0,     0,     0,  3061,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3650,     0,     0,     0,     0,     0,  1932,     0,     0,
       0,  3731,     0,  2306,     0,     0,     0,     0,  3661,     0,
       0,     0,     0,     0,  2321,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,     0,     0,  1927,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   672,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4992,     0,
       0,     0,  3700,  4996,     0,     0,     0,     0,     0,     0,
     672,     0,     0,     0,     0,     0,  1932,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1186,  1186,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1927,     0,  1186,  1186,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,  1186,  1186,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,  1186,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,  1186,     0,     0,  1186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
    1186,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,  1186,  1186,  1186,     0,     0,     0,     0,
       0,     0,  1927,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,     0,
     672,     0,     0,     0,     0,  1927,     0,     0,     0,  1186,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
    1186,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,  1927,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1927,     0,     0,     0,  1927,
    1927,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,  2226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1932,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2373,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1932,  1932,     0,
    1932,     0,  2226,     0,     0,     0,     0,     0,     0,   672,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4021,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4025,     0,     0,
       0,     0,     0,  4026,     0,  4027,  1932,     0,  1932,     0,
       0,   672,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4045,  4046,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2909,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4074,     0,
       0,  4077,  1932,  4079,     0,     0,     0,     0,     0,     0,
       0,     0,  4083,     0,     0,     0,     0,     0,  4088,     0,
       0,  4091,     0,     0,     0,     0,     0,  1932,     0,     0,
       0,   672,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4124,     0,     0,     0,     0,     0,  1932,     0,
    4136,     0,  2985,     0,     0,     0,     0,     0,   672,     0,
       0,  1932,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4153,     0,     0,     0,     0,     0,
    1551,     0,     0,     0,     0,     0,  1622,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1932,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1932,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1932,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,  1932,     0,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,  1186,
     716,  1186,     0,     0,     0,     0,  1932,  1186,     0,     0,
    1186,  1186,  1186,  1186,  1186,  1186,  1186,  1186,  1186,  1186,
       0,     0,     0,  1186,  1186,     0,     0,     0,     0,     0,
       0,  1932,     0,     0,     0,     0,  1186,     0,     0,     0,
    1186,     0,     0,     0,  1186,     0,   672,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,  1186,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,  1932,  1186,  1186,
    1186,     0,     0,     0,  1186,  2226,     0,  1186,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,  1186,    85,
       0,     0,     0,     0,     0,    89,     0,     0,     0,    93,
       0,    94,     0,    96,    97,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   106,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4400,  4401,     0,
    1186,   119,   120,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,     0,  2226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1186,     0,     0,
       0,  2226,     0,     0,     0,     0,  2887,   128,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   129,  4432,   130,
     131,     0,     0,     0,     0,     0,  2226,  2226,     0,     0,
    2226,     0,     0,     0,  1119,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   141,     0,   142,   143,     0,     0,
       0,     0,   146,     0,   147,  4450,  4452,     0,     0,     0,
    2226,     0,  1932,     0,   149,     0,   150,     0,  4459,     0,
       0,     0,     0,     0,  4464,  4465,     0,     0,  4467,     0,
     153,     0,   154,     0,     0,   157,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   158,     0,   159,
       0,     0,     0,   160,     0,     0,     0,     0,     0,   161,
    2985,     0,     0,     0,  2226,  2985,     0,   163,     0,   165,
       0,     0,     0,     0,     0,   167,     0,  2985,     0,     0,
       0,     0,     0,     0,   672,     0,  2226,     0,     0,   171,
       0,     0,     0,     0,     0,     0,     0,     0,  2226,     0,
       0,  2226,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4523,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   184,   185,     0,     0,     0,     0,
     186,     0,     0,     0,     0,     0,  1932,     0,     0,   187,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     192,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1932,  1186,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,     0,     0,   206,   207,     0,   208,     0,     0,
       0,     0,   209,     0,     0,     0,     0,   210,     0,     0,
     212,     0,     0,     0,   214,     0,     0,     0,     0,   215,
     216,     0,     0,     0,  1186,     0,     0,   217,     0,     0,
     219,     0,     0,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     224,     0,  4619,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,   229,     0,   230,
       0,  1186,  1186,     0,  1932,     0,     0,   232,     0,  1186,
    1186,     0,     0,   233,  1186,  1932,     0,     0,   234,     0,
    1186,  1186,     0,     0,  1186,     0,     0,     0,     0,     0,
     237,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1186,     0,     0,     0,
       0,  1186,     0,     0,   247,     0,     0,     0,  -136,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4703,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1932,  4720,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1932,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1932,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1932,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1186,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2909,     0,     0,
       0,     0,     0,     0,     0,  2226,     0,  1932,     0,     0,
       0,     0,     0,     0,     0,     0,  4857,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2226,     0,
    2226,     0,  2887,  2887,  3535,     0,     0,  2887,     0,     0,
    1186,  2226,     0,     0,  1932,     0,     0,     0,  2226,  1186,
       0,     0,     0,  2226,     0,     0,     0,     0,     0,  2226,
       0,     0,     0,     0,  2226,     0,  1186,  1186,     0,     0,
    1186,     0,     0,  2226,     0,     0,     0,  2887,  2887,     0,
    2226,     0,     0,  1186,     0,     0,     0,     0,  1186,     0,
       0,  1186,  2226,     0,     0,     0,  1186,  1186,     0,  2226,
       0,  2226,  2226,  2226,  2226,  2226,  2226,  2226,  2226,  2226,
    2226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4928,     0,     0,     0,  1186,
       0,     0,     0,     0,     0,  2226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1932,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4973,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2226,
       0,     0,     0,     0,     0,     0,  1186,     0,  1932,  5019,
    5019,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1186,  1932,     0,  1186,     0,  1186,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,  1186,     0,     0,     0,
       0,  1932,     0,     0,  5019,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  5067,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1932,     0,     0,     0,  1932,  1932,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  5019,     0,     0,     0,
       0,     0,  1186,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1932,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1186,     0,     0,     0,  2226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,     0,     0,
       0,     0,     0,  1186,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1186,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,  1186,  1186,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1186,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,  2226,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
    1186,     0,     0,     0,     0,   144,     0,   145,     0,     0,
    1186,     0,     0,   148,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   151,     0,     0,     0,  2226,     0,
     152,     0,     0,     0,  2226,     0,     0,     0,     0,     0,
     155,   156,     0,     0,     0,     0,     0,     0,     0,     0,
    3535,  3535,     0,  2887,     0,     0,  2887,  2887,  2887,  2887,
    2887,  2887,  2887,  2887,  2887,  2887,  3535,   162,     0,     0,
       0,     0,  1186,     0,     0,   164,     0,     0,     0,   166,
       0,  1186,     0,     0,   168,     0,     0,     0,     0,     0,
     169,  2226,   170,     0,  2226,     0,  2226,     0,   172,     0,
       0,  3535,  3535,     0,     0,     0,     0,   173,     0,     0,
       0,     0,     0,     0,     0,  2887,  2887,  2226,     0,  2226,
     174,   175,  2226,     0,     0,     0,     0,   176,     0,   177,
       0,     0,   178,   179,     0,   180,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   181,   182,     0,   183,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,   193,     0,
    2226,   194,     0,   195,     0,     0,     0,     0,     0,     0,
       0,  2226,     0,     0,     0,     0,   196,   197,   198,   199,
     200,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   204,     0,     0,     0,     0,
    2226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   211,     0,     0,   213,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   218,     0,     0,   220,     0,
     221,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   223,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   225,   226,     0,     0,     0,
     227,     0,   228,     0,     0,     0,     0,     0,     0,     0,
       0,   231,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   235,     0,     0,   236,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   238,   239,   240,   241,   242,   243,   244,
     245,   246,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2887,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    86,    87,    88,     0,    90,    91,    92,     0,
       0,     0,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,     0,     0,     0,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115,     0,   116,   117,
     118,     0,     0,     0,     0,     0,   121,   122,     0,     0,
       0,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   125,     0,   126,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  2226,     0,     0,     0,  2226,  2226,  2226,     0,     0,
    3535,     0,     0,     0,     0,  3535,  3535,  3535,  3535,  3535,
    3535,  3535,  3535,  3535,  3535,  2226,  2226,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,  2226,  2887,  2887,  2226,   144,  2226,
     145,     0,     0,  2226,  3535,  3535,   148,     0,  2226,     0,
       0,  2226,     0,     0,     0,     0,     0,   151,     0,     0,
       0,     0,     0,   152,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   155,   156,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2226,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2226,     0,     0,     0,
     162,     0,     0,     0,     0,     0,     0,     0,   164,     0,
       0,     0,   166,  2226,     0,     0,     0,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,   175,     0,     0,     0,     0,     0,
     176,     0,   177,     0,     0,   178,   179,     0,   180,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   181,
     182,     0,   183,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   188,   189,   190,     0,     0,   191,     0,     0,
       0,   193,     0,     0,   194,     0,   195,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   196,
     197,   198,   199,   200,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   201,     0,   202,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   211,     0,
       0,   213,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   218,     0,
       0,   220,     0,   221,     0,     0,     0,  3535,     0,     0,
       0,     0,     0,     0,     0,     0,   223,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   225,   226,
       0,     0,     0,   227,     0,   228,     0,     0,     0,     0,
       0,     0,     0,     0,   231,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   235,
    2226,  2226,   236,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   238,   239,   240,   241,
     242,   243,   244,   245,   246,     0,     0,     0,     0,     0,
       0,     0,  2226,     0,     0,     0,  2887,     0,     0,     0,
       4,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2226,  3051,  2226,     0,     0,     0,     0,  3535,  3535,  2226,
       5,     0,  2887,  2887,  2226,  2226,     0,  2226,     0,     0,
       6,     7,     0,     0,     0,     0,     0,     0,     9,    10,
       0,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,  2226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2226,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    48,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,     0,     0,     0,
       0,     0,     0,     0,     0,  3535,  2887,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    50,     0,
       0,  3535,  3535,  2226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2226,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    51,     0,     0,    52,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    53,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    54,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3535,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2226,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    56,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    57,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    58,     0,     0,     0,  2226,     0,
      59,     0,     0,     0,    60,    61,    62,    63,    64,     0,
       0,    65,    66,  1381,     0,     0,     0,     0,    71,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2226,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,  2226,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,  2226,     0,   418,
     419,   420,   421,   422,   423,   424,   425,   733,   426,   427,
     428,   734,   735,   736,   737,   738,   739,   740,   429,   430,
     741,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,   742,   436,   437,   438,   439,   440,   743,   744,
     441,   442,   745,   140,   443,   746,   444,   445,   446,   447,
     144,   747,   145,   748,   448,   449,   450,   451,   148,   452,
     749,   750,   453,   454,   455,   456,   457,   458,   751,   151,
     459,   752,   753,   754,   755,   152,   756,   757,   758,   460,
     461,   462,   463,   695,   464,   155,   156,   465,   759,   466,
     760,   467,   468,   469,   470,   471,   761,   472,   473,   474,
     762,   763,   475,   476,   477,   478,   479,   764,   480,   481,
     482,   765,   483,   484,   485,   766,   486,   487,   488,   489,
     164,   490,   491,   492,   166,   767,   493,   768,   494,   168,
     495,   769,   496,   770,   497,   169,   771,   170,   498,   499,
     500,   772,   501,   172,   773,   502,   774,   503,   504,   697,
     505,   506,   173,   507,   508,   509,   775,   510,   511,   512,
     513,   514,   515,   776,   516,   174,   175,   777,   517,   518,
     519,   778,   176,   779,   177,   780,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,   781,   527,   528,   782,
     529,   181,   182,   530,   183,   783,   531,   532,   533,   784,
     785,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,   189,   190,   545,   546,   191,
     786,   547,   548,   193,   549,   787,   194,   550,   195,   551,
     552,   553,   788,   554,   789,   790,   555,   556,   557,   791,
     792,   196,   197,   198,   199,   200,   558,   559,   560,   561,
     562,   563,   564,   793,   565,   201,   566,   202,   567,   568,
     569,   794,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,   795,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,   796,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,   797,   604,   605,   606,   607,   608,   798,   609,
     218,   610,   611,   220,   612,   221,   613,   799,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,   800,
     624,   625,   801,   626,   627,   628,   629,   630,   631,   802,
     225,   226,   803,   804,   633,   227,   634,   228,   805,   635,
     636,   637,   638,   639,   640,   641,   806,   807,   642,   643,
     644,   645,   646,   808,   809,   647,   648,   649,   650,   651,
     810,   235,   811,   652,   236,   653,   654,   655,   812,   813,
     656,   814,   815,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
      85,     0,     0,    86,    87,    88,    89,    90,    91,    92,
      93,     0,    94,    95,    96,    97,    98,    99,   100,   101,
     102,   103,   967,   104,   105,   106,     0,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,     0,   116,
     117,   118,   119,   120,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,   127,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   128,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   129,     0,
     130,   131,     0,     0,     0,     0,     0,     0,     0,     0,
     132,     0,   133,     0,     0,   134,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,   141,     0,   142,   143,   144,
       0,   145,     0,   146,     0,   147,     0,   148,     0,     0,
       0,     0,     0,     0,     0,   149,     0,   150,   151,     0,
       0,     0,     0,     0,   152,     0,     0,     0,     0,     0,
       0,   153,     0,   154,   155,   156,   157,     0,     0,     0,
       0,     0, -1396,     0,     0,     0,     0,     0,   158,     0,
     159,     0,     0,     0,   160,     0,     0,     0,     0,     0,
     161,   162,     0,     0,     0,     0,     0,     0,   163,   164,
     165,     0,     0,   166,     0,     0,   167,     0,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
     171,     0,   172,     0,     0,     0,     0,     0,     0,     0,
       0,   173,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   174,   175,     0,     0, -1396,     0,
       0,   176,     0,   177,     0,     0,   178,   179,     0,   180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     181,   182,     0,   183,     0,   184,   185,     0,     0,     0,
       0,   186,     0,     0,     0,     0,     0,     0,     0,     0,
     187,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,   192,   193,     0,     0,   194,     0,   195,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     196,   197,   198,   199,   200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   201,     0,   202,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   204,
     205,     0,     0,     0,     0,   206,   207,     0,   208,     0,
       0,     0,     0,   209,     0,     0,     0,     0,   210,   211,
       0,   212,   213,     0,     0,   214,     0,     0,     0,     0,
     215,   216,     0,     0,     0,     0,     0,     0,   217,   218,
       0,   219,   220,     0,   221,     0,     0,     0,     0,   222,
       0,     0,     0,     0,     0,     0,     0,   223,     0,     0,
       0,   224,     0,     0,     0,     0,     0,     0,     0,   225,
     226,     0,     0,     0,   227,     0,   228,     0,   229,     0,
     230,     0,     0,     0,     0,   231,     0,     0,   232,     0,
       0, -1396,     0,     0,   233,     0,     0,     0,     0,   234,
     235,     0,     0,   236,     0,     0,     0,     0,     0,     0,
       0,   237,     0,     0,     0,     0,     0,   238,   239,   240,
     241,   242,   243,   244,   245,   246,    86,    87,    88,     0,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   247,   104,   105,     0,  -136,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115,     0,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,   145,     0,     0,     0,     0,     0,
     148,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   151,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   155,   156,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,     0,   164,     0,     0,     0,   166,     0,     0,     0,
       0,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   172,     0,     0,     0,     0,
       0,     0,     0,     0,   173,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   174,   175,     0,
       0,     0,     0,     0,   176,     0,   177,     0,     0,   178,
     179,     0,   180,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,     0,   183,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   188,   189,   190,     0,
       0,   191,     0,     0,     0,   193,     0,     0,   194,     0,
     195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   196,   197,   198,   199,   200,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   201,     0,   202,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   204,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   211,     0,     0,   213,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   218,     0,     0,   220,     0,   221,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     223,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   225,   226,     0,     0,     0,   227,     0,   228,
       0,     0,     0,     0,     0,     0,     0,     0,   231,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   235,     0,     0,   236,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     238,   239,   240,   241,   242,   243,   244,   245,   246,     0,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,  3053,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1470,  1471,
    1472,    45,  1473,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,  2979,   426,   427,   428,     0,     0,
       0,     0,  1474,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,  1475,   137,  1476,  1477,     0,
     436,   437,   438,   439,   440,  1478,  1479,   441,   442,  1480,
    1481,   443,     0,   444,   445,   446,   447,  1482,     0,  1483,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,  1484,
    1485,  1486,  1487,  1488,  1489,  1490,   460,   461,   462,   463,
     695,   464,  1491,  1492,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,  2980,     0,   475,
     476,  1493,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,  1494,   490,   491,
     492,  1495,  1496,   493,     0,   494,  1497,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
    1498,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,  1499,  1500,
       0,  1501,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,  1502,   182,
     530,   183,     0,   531,   532,   533,  1503,  1504,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,  1505,   189,  1506,   545,   546,   191,  1507,   547,   548,
     193,   549,  1508,  1509,   550,  1510,   551,   552,   553,     0,
     554,     0,     0,  1511,   556,   557,     0,     0,   196,   197,
     198,   199,  1512,   558,   559,   560,   561,   562,   563,   564,
       0,   565,  1513,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,  1514,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
    1515,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,  1516,   609,   218,   610,   611,
     220,   612,  1517,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,  1518,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1519,  1520,     0,
       0,   633,  1521,   634,  1522,  1523,   635,   636,   637,   638,
     639,   640,   641,     0,  1524,   642,   643,   644,   645,   646,
    1525,     0,   647,   648,   649,   650,   651,   701,  1526,  2981,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,  1527,  1528,  1529,  1530,
    1531,  1532,  1533,  1534,   702,   662,   663,     0,     0,     0,
       0,     0,     0,     0,  1535,  1536,  2982,     0,     0,     0,
       0,     0,     0,  1538,  2983,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1470,  1471,  1472,    45,  1473,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,  1474,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,   135,
    1475,   137,  1476,  1477,     0,   436,   437,   438,   439,   440,
    1478,  1479,   441,   442,  1480,  1481,   443,     0,   444,   445,
     446,   447,  1482,     0,  1483,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,
    1490,   460,   461,   462,   463,   695,   464,  1491,  1492,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1493,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,  1494,   490,   491,   492,  1495,  1496,   493,     0,
     494,  1497,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,  1498,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,   175,     0,
     517,   518,   519,  1499,  1500,     0,  1501,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,  1502,   182,   530,   183,     0,   531,   532,
     533,  1503,  1504,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1505,   189,  1506,   545,
     546,   191,  1507,   547,   548,   193,   549,  1508,  1509,   550,
    1510,   551,   552,   553,     0,   554,     0,     0,  1511,   556,
     557,     0,     0,   196,   197,   198,   199,  1512,   558,   559,
     560,   561,   562,   563,   564,     0,   565,  1513,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1514,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,  1515,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
    1516,   609,   218,   610,   611,   220,   612,  1517,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
    1518,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1519,  1520,     0,     0,   633,  1521,   634,  1522,
    1523,   635,   636,   637,   638,   639,   640,   641,     0,  1524,
     642,   643,   644,   645,   646,  1525,     0,   647,   648,   649,
     650,   651,   701,  1526,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,
     662,   663,     0,     0,     0,     0,     0,     0,     0,  1535,
    1536,     0,     0,     0,     0,     0,     0,     0,  1538,  2889,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,     0,  1898,   137,  1899,  1900,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,  1901,
    1902,   443,     0,   444,   445,   446,   447,     0,     0,   145,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,     0,
       0,     0,   152,     0,     0,     0,   460,   461,   462,   463,
     695,   464,  1903,  1904,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,  1493,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,     0,   490,   491,
     492,     0,     0,   493,     0,   494,  1905,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
       0,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,  2478,   510,   511,   512,   513,   514,   515,
       0,   516,   174,  2479,     0,   517,   518,   519,  1499,  1906,
       0,  1907,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,     0,   182,
     530,   183,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,  1908,   189,  1909,   545,   546,     0,     0,   547,   548,
     193,   549,     0,     0,   550,  1910,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,  2480,   197,
     198,   199,     0,   558,   559,   560,   561,   562,   563,   564,
       0,   565,     0,   566,     0,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,  1911,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
       0,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,  2481,   610,   611,
     220,   612,  1913,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,     0,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1914,  1915,     0,
       0,   633,     0,   634,     0,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,     0,  1916,  2482,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   702,   662,   663,     0,     0,     0,
       0,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,  2483,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,     0,  1898,   137,  1899,  1900,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
    1901,  1902,   443,     0,   444,   445,   446,   447,     0,     0,
     145,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
       0,     0,     0,   152,     0,     0,     0,   460,   461,   462,
     463,   695,   464,  1903,  1904,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,  1493,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,     0,   490,
     491,   492,     0,     0,   493,     0,   494,  1905,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,     0,     0,   502,     0,   503,   504,   697,   505,   506,
     173,   507,   508,   509,  2478,   510,   511,   512,   513,   514,
     515,     0,   516,   174,  2479,     0,   517,   518,   519,  1499,
    1906,     0,  1907,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,     0,
     182,   530,   183,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,  1908,   189,  1909,   545,   546,     0,     0,   547,
     548,   193,   549,     0,     0,   550,  1910,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,  2480,
     197,   198,   199,     0,   558,   559,   560,   561,   562,   563,
     564,     0,   565,     0,   566,     0,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,  1911,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,     0,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,  2481,   610,
     611,   220,   612,  1913,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,     0,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,  1914,  1915,
       0,     0,   633,     0,   634,     0,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,     0,  1916,
    2482,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   702,   662,   663,     0,     0,
       0,     0,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,  3411,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1470,  1471,  1472,    45,  1473,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,  1474,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,   135,  1475,   137,  1476,
    1477,  2899,   436,   437,   438,   439,   440,  1478,  1479,   441,
     442,  1480,  1481,   443,     0,   444,   445,   446,   447,  1482,
       0,  1483,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,   461,
     462,   463,   695,   464,  1491,  1492,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1493,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,  1494,
     490,   491,   492,  1495,  1496,   493,     0,   494,  1497,   495,
       0,   496,     0,   497,   169,  2900,   170,   498,   499,   500,
       0,   501,  1498,     0,   502,     0,   503,   504,   697,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
    1499,  1500,     0,  1501,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,  2901,   529,
    1502,   182,   530,   183,     0,   531,   532,   533,  1503,  1504,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1505,   189,  1506,   545,   546,   191,  1507,
     547,   548,   193,   549,  1508,  1509,   550,  1510,   551,   552,
     553,     0,   554,     0,     0,  1511,   556,   557,     0,     0,
     196,   197,   198,   199,  1512,   558,   559,   560,   561,   562,
     563,   564,     0,   565,  1513,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1514,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,  1515,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,  1516,   609,   218,
     610,   611,   220,   612,  1517,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,  1518,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1519,
    1520,     0,  2902,   633,  1521,   634,  1522,  1523,   635,   636,
     637,   638,   639,   640,   641,     0,  1524,   642,   643,   644,
     645,   646,  1525,     0,   647,   648,   649,   650,   651,   701,
    1526,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,  1527,  1528,
    1529,  1530,  1531,  1532,  1533,  1534,   702,   662,   663,     0,
       0,     0,     0,     0,     0,     0,  1535,  1536,     0,     0,
       0,     0,     0,     0,     0,  1538,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1470,  1471,  1472,    45,  1473,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,  1474,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
     135,  1475,   137,  1476,  1477,     0,   436,   437,   438,   439,
     440,  1478,  1479,   441,   442,  1480,  1481,   443,     0,   444,
     445,   446,   447,  1482,     0,  1483,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,  1484,  1485,  1486,  1487,  1488,
    1489,  1490,   460,   461,   462,   463,   695,   464,  1491,  1492,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1493,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,  1494,   490,   491,   492,  1495,  1496,   493,
       0,   494,  1497,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,  1498,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,  1499,  1500,     0,  1501,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,  1502,   182,   530,   183,     0,   531,
     532,   533,  1503,  1504,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1505,   189,  1506,
     545,   546,   191,  1507,   547,   548,   193,   549,  1508,  1509,
     550,  1510,   551,   552,   553,     0,   554,     0,     0,  1511,
     556,   557,     0,     0,   196,   197,   198,   199,  1512,   558,
     559,   560,   561,   562,   563,   564,     0,   565,  1513,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1514,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,  1515,   597,   598,   599,
     600,   601,   602,   700,   603,   216,   604,   605,   606,   607,
     608,  1516,   609,   218,   610,   611,   220,   612,  1517,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,  1518,     0,   624,   625,   224,   626,   627,   628,   629,
     630,   631,     0,  1519,  1520,     0,     0,   633,  1521,   634,
    1522,  1523,   635,   636,   637,   638,   639,   640,   641,     0,
    1524,   642,   643,   644,   645,   646,  1525,     0,   647,   648,
     649,   650,   651,  2188,  1526,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,   237,   657,   658,   659,   660,
     661,   238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,
     702,   662,   663,     0,     0,     0,     0,     0,     0,     0,
    1535,  1536,     0,     0,     0,     0,     0,     0,     0,  1538,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1470,  1471,
    1472,    45,  1473,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,  1474,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,  1475,   137,  1476,  1477,     0,
     436,   437,   438,   439,   440,  1478,  1479,   441,   442,  1480,
    1481,   443,     0,   444,   445,   446,   447,  1482,     0,  1483,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,  1484,
    1485,  1486,  1487,  1488,  1489,  1490,   460,   461,   462,   463,
     695,   464,  1491,  1492,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,  1493,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,  1494,   490,   491,
     492,  1495,  1496,   493,     0,   494,  1497,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
    1498,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,  1499,  1500,
       0,  1501,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,  1502,   182,
     530,   183,     0,   531,   532,   533,  1503,  1504,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,  1505,   189,  1506,   545,   546,   191,  1507,   547,   548,
     193,   549,  1508,  1509,   550,  1510,   551,   552,   553,     0,
     554,     0,     0,  1511,   556,   557,     0,     0,   196,   197,
     198,   199,  1512,   558,   559,   560,   561,   562,   563,   564,
       0,   565,  1513,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,  1514,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
    1515,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,  1516,   609,   218,   610,   611,
     220,   612,  1517,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,  1518,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1519,  1520,     0,
       0,   633,  1521,   634,  1522,  1523,   635,   636,   637,   638,
     639,   640,   641,     0,  1524,   642,   643,   644,   645,   646,
    1525,     0,   647,   648,   649,   650,   651,   701,  1526,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,  1527,  1528,  1529,  1530,
    1531,  1532,  1533,  1534,   702,   662,   663,     0,     0,     0,
       0,     0,     0,     0,  1535,  1536,     0,     0,     0,     0,
       0,  2132,  2847,  1538,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1470,  1471,  1472,    45,  1473,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,  1474,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,  1475,
     137,  1476,  1477,     0,   436,   437,   438,   439,   440,  1478,
    1479,   441,   442,  1480,  1481,   443,     0,   444,   445,   446,
     447,  1482,     0,  1483,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,
     460,   461,   462,   463,   695,   464,  1491,  1492,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,  1493,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,  1494,   490,   491,   492,  1495,  1496,   493,     0,   494,
    1497,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,  1498,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,  1499,  1500,     0,  1501,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,  1502,   182,   530,   183,     0,   531,   532,   533,
    1503,  1504,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,  1505,   189,  1506,   545,   546,
     191,  1507,   547,   548,   193,   549,  1508,  1509,   550,  1510,
     551,   552,   553,     0,   554,     0,     0,  1511,   556,   557,
       0,     0,   196,   197,   198,   199,  1512,   558,   559,   560,
     561,   562,   563,   564,     0,   565,  1513,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,  1514,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,  1515,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,  1516,
     609,   218,   610,   611,   220,   612,  1517,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,  1518,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,  1519,  1520,     0,     0,   633,  1521,   634,  1522,  1523,
     635,   636,   637,   638,   639,   640,   641,     0,  1524,   642,
     643,   644,   645,   646,  1525,     0,   647,   648,   649,   650,
     651,   701,  1526,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
    1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,
     663,     0,     0,     0,     0,     0,     0,     0,  1535,  1536,
    1537,     0,     0,     0,     0,     0,     0,  1538,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,   417,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1470,  1471,  1472,    45,
    1473,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
    1474,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,   135,  1475,   137,  1476,  1477,     0,   436,   437,
     438,   439,   440,  1478,  1479,   441,   442,  1480,  1481,   443,
       0,   444,   445,   446,   447,  1482,     0,  1483,     0,   448,
     449,   450,   451,   148,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,  1484,  1485,  1486,
    1487,  1488,  1489,  1490,   460,   461,   462,   463,   695,   464,
    1491,  1492,   465,  1621,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,  1493,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,  1494,   490,   491,   492,  1495,
    1496,   493,     0,   494,  1497,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,  1498,     0,
     502,     0,   503,   504,   697,   505,   506,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,  1499,  1500,     0,  1501,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,  1502,   182,   530,   183,
       0,   531,   532,   533,  1503,  1504,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,  1505,
     189,  1506,   545,   546,   191,  1507,   547,   548,   193,   549,
    1508,  1509,   550,  1510,   551,   552,   553,     0,   554,     0,
       0,  1511,   556,   557,     0,     0,   196,   197,   198,   199,
    1512,   558,   559,   560,   561,   562,   563,   564,     0,   565,
    1513,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,  1514,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,  1515,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,  1516,   609,   218,   610,   611,   220,   612,
    1517,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,  1518,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,  1519,  1520,     0,     0,   633,
    1521,   634,  1522,  1523,   635,   636,   637,   638,   639,   640,
     641,     0,  1524,   642,   643,   644,   645,   646,  1525,     0,
     647,   648,   649,   650,   651,   701,  1526,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,  1527,  1528,  1529,  1530,  1531,  1532,
    1533,  1534,   702,   662,   663,     0,     0,     0,     0,     0,
       0,     0,  1535,  1536,     0,     0,     0,     0,     0,     0,
       0,  1538,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1470,  1471,  1472,    45,  1473,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,  2316,   426,   427,   428,
       0,     0,     0,     0,  1474,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,   135,  1475,   137,  1476,
    1477,     0,   436,   437,   438,   439,   440,  1478,  1479,   441,
     442,  1480,  1481,   443,     0,   444,   445,   446,   447,  1482,
       0,  1483,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,   461,
     462,   463,   695,   464,  1491,  1492,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1493,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,  1494,
     490,   491,   492,  1495,  1496,   493,     0,   494,  1497,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,  1498,     0,   502,     0,   503,   504,   697,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
    1499,  1500,     0,  1501,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
    1502,   182,   530,   183,     0,   531,   532,   533,  1503,  1504,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1505,   189,  1506,   545,   546,   191,  1507,
     547,   548,   193,   549,  1508,  1509,   550,  1510,   551,   552,
     553,     0,   554,     0,     0,  1511,   556,   557,     0,     0,
     196,   197,   198,   199,  1512,   558,   559,   560,   561,   562,
     563,   564,     0,   565,  1513,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1514,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,  1515,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,  1516,   609,   218,
     610,   611,   220,   612,  1517,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,  1518,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1519,
    1520,     0,     0,   633,  1521,   634,  1522,  1523,   635,   636,
     637,   638,   639,   640,   641,     0,  1524,   642,   643,   644,
     645,   646,  1525,     0,   647,   648,   649,   650,   651,   701,
    1526,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,  1527,  1528,
    1529,  1530,  1531,  1532,  1533,  1534,   702,   662,   663,     0,
       0,     0,     0,     0,     0,     0,  1535,  1536,     0,     0,
       0,     0,     0,     0,     0,  1538,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1470,  1471,  1472,    45,  1473,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,  1474,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
     135,  1475,   137,  1476,  1477,     0,   436,   437,   438,   439,
     440,  1478,  1479,   441,   442,  1480,  1481,   443,     0,   444,
     445,   446,   447,  1482,     0,  1483,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,  1484,  1485,  1486,  1487,  1488,
    1489,  1490,   460,   461,   462,   463,   695,   464,  1491,  1492,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1493,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,  1494,   490,   491,   492,  1495,  1496,   493,
       0,   494,  1497,   495,     0,   496,     0,   497,   169,  2900,
     170,   498,   499,   500,     0,   501,  1498,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,  1499,  1500,     0,  1501,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,  1502,   182,   530,   183,     0,   531,
     532,   533,  1503,  1504,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1505,   189,  1506,
     545,   546,   191,  1507,   547,   548,   193,   549,  1508,  1509,
     550,  1510,   551,   552,   553,     0,   554,     0,     0,  1511,
     556,   557,     0,     0,   196,   197,   198,   199,  1512,   558,
     559,   560,   561,   562,   563,   564,     0,   565,  1513,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1514,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,  1515,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,  1516,   609,   218,   610,   611,   220,   612,  1517,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,  1518,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1519,  1520,     0,     0,   633,  1521,   634,
    1522,  1523,   635,   636,   637,   638,   639,   640,   641,     0,
    1524,   642,   643,   644,   645,   646,  1525,     0,   647,   648,
     649,   650,   651,   701,  1526,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,
     702,   662,   663,     0,     0,     0,     0,     0,     0,     0,
    1535,  1536,     0,     0,     0,     0,     0,     0,     0,  1538,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1470,  1471,
    1472,    45,  1473,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,  1474,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,  1475,   137,  1476,  1477,     0,
     436,   437,   438,   439,   440,  1478,  1479,   441,   442,  1480,
    1481,   443,     0,   444,   445,   446,   447,  1482,     0,  1483,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,  1484,
    1485,  1486,  1487,  1488,  1489,  1490,   460,   461,   462,   463,
     695,   464,  1491,  1492,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,  1493,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,  1494,   490,   491,
     492,  1495,  1496,   493,     0,   494,  1497,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
    1498,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,  1499,  1500,
       0,  1501,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,  1502,   182,
     530,   183,     0,   531,   532,   533,  1503,  1504,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,  1505,   189,  1506,   545,   546,   191,  1507,   547,   548,
     193,   549,  1508,  1509,   550,  1510,   551,   552,   553,     0,
     554,     0,     0,  1511,   556,   557,     0,     0,   196,   197,
     198,   199,  1512,   558,   559,   560,   561,   562,   563,   564,
       0,   565,  1513,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,  1514,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
    1515,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,  1516,   609,   218,   610,   611,
     220,   612,  1517,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,  1518,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1519,  1520,     0,
       0,   633,  1521,   634,  1522,  1523,   635,   636,   637,   638,
     639,   640,   641,     0,  1524,   642,   643,   644,   645,   646,
    1525,     0,   647,   648,   649,   650,   651,   701,  1526,  4139,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,  1527,  1528,  1529,  1530,
    1531,  1532,  1533,  1534,   702,   662,   663,     0,     0,     0,
       0,     0,     0,     0,  1535,  1536,     0,     0,     0,     0,
       0,     0,     0,  1538,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1470,  1471,  1472,    45,  1473,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,  1474,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,  1475,
     137,  1476,  1477,     0,   436,   437,   438,   439,   440,  1478,
    1479,   441,   442,  1480,  1481,   443,     0,   444,   445,   446,
     447,  1482,     0,  1483,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,  4152,  1484,  1485,  1486,  1487,  1488,  1489,  1490,
     460,   461,   462,   463,   695,   464,  1491,  1492,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,  1493,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,  1494,   490,   491,   492,  1495,  1496,   493,     0,   494,
    1497,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,  1498,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,  1499,  1500,     0,  1501,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,  1502,   182,   530,   183,     0,   531,   532,   533,
    1503,  1504,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,  1505,   189,  1506,   545,   546,
     191,  1507,   547,   548,   193,   549,  1508,  1509,   550,  1510,
     551,   552,   553,     0,   554,     0,     0,  1511,   556,   557,
       0,     0,   196,   197,   198,   199,  1512,   558,   559,   560,
     561,   562,   563,   564,     0,   565,  1513,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,  1514,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,  1515,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,  1516,
     609,   218,   610,   611,   220,   612,  1517,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,  1518,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,  1519,  1520,     0,     0,   633,  1521,   634,  1522,  1523,
     635,   636,   637,   638,   639,   640,   641,     0,  1524,   642,
     643,   644,   645,   646,  1525,     0,   647,   648,   649,   650,
     651,   701,  1526,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
    1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,
     663,     0,     0,     0,     0,     0,     0,     0,  1535,  1536,
       0,     0,     0,     0,     0,     0,     0,  1538,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,   417,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1470,  1471,  1472,    45,
    1473,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
    1474,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,  5016,  1475,   137,  1476,  1477,     0,   436,   437,
     438,   439,   440,  1478,  1479,   441,   442,  1480,  1481,   443,
       0,   444,   445,   446,   447,  1482,     0,  1483,     0,   448,
     449,   450,   451,   148,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,  5017,  1484,  1485,  1486,
    1487,  1488,  1489,  1490,   460,   461,   462,   463,   695,   464,
    1491,  1492,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,  1493,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,  1494,   490,   491,   492,  1495,
    1496,   493,     0,   494,  1497,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,  1498,     0,
     502,     0,   503,   504,   697,   505,   506,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,  1499,  1500,     0,  1501,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,  1502,   182,   530,   183,
       0,   531,   532,   533,  1503,  1504,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,  1505,
     189,  1506,   545,   546,   191,  1507,   547,   548,   193,   549,
    1508,  1509,   550,  1510,   551,   552,   553,     0,   554,     0,
       0,  1511,   556,   557,     0,     0,   196,   197,   198,   199,
    1512,   558,   559,   560,   561,   562,   563,   564,     0,   565,
    1513,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,  1514,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,  1515,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,  1516,   609,   218,   610,   611,   220,   612,
    1517,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,  1518,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,  1519,  1520,     0,     0,   633,
    1521,   634,  1522,  1523,   635,   636,   637,   638,  5018,   640,
     641,     0,  1524,   642,   643,   644,   645,   646,  1525,     0,
     647,   648,   649,   650,   651,   701,  1526,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,  1527,  1528,  1529,  1530,  1531,  1532,
    1533,  1534,   702,   662,   663,     0,     0,     0,     0,     0,
       0,     0,  1535,  1536,     0,     0,     0,     0,     0,     0,
       0,  1538,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1470,  1471,  1472,    45,  1473,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,  1474,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,   135,  1475,   137,  1476,
    1477,     0,   436,   437,   438,   439,   440,  1478,  1479,   441,
     442,  1480,  1481,   443,     0,   444,   445,   446,   447,  1482,
       0,  1483,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
    5017,  1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,   461,
     462,   463,   695,   464,  1491,  1492,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1493,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,  1494,
     490,   491,   492,  1495,  1496,   493,     0,   494,  1497,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,  1498,     0,   502,     0,   503,   504,   697,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
    1499,  1500,     0,  1501,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
    1502,   182,   530,   183,     0,   531,   532,   533,  1503,  1504,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1505,   189,  1506,   545,   546,   191,  1507,
     547,   548,   193,   549,  1508,  1509,   550,  1510,   551,   552,
     553,     0,   554,     0,     0,  1511,   556,   557,     0,     0,
     196,   197,   198,   199,  1512,   558,   559,   560,   561,   562,
     563,   564,     0,   565,  1513,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1514,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,  1515,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,  1516,   609,   218,
     610,   611,   220,   612,  1517,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,  1518,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1519,
    1520,     0,     0,   633,  1521,   634,  1522,  1523,   635,   636,
     637,   638,  5018,   640,   641,     0,  1524,   642,   643,   644,
     645,   646,  1525,     0,   647,   648,   649,   650,   651,   701,
    1526,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,  1527,  1528,
    1529,  1530,  1531,  1532,  1533,  1534,   702,   662,   663,     0,
       0,     0,     0,     0,     0,     0,  1535,  1536,     0,     0,
       0,     0,     0,     0,     0,  1538,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1470,  1471,  1472,    45,  1473,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,  1474,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
     135,  1475,   137,  1476,  1477,     0,   436,   437,   438,   439,
     440,  1478,  1479,   441,   442,  1480,  1481,   443,     0,   444,
     445,   446,   447,  1482,     0,  1483,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,  1484,  1485,  1486,  1487,  1488,
    1489,  1490,   460,   461,   462,   463,   695,   464,  1491,  1492,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1493,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,  1494,   490,   491,   492,  1495,  1496,   493,
       0,   494,  1497,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,  1498,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,  1499,  1500,     0,  1501,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,  1502,   182,   530,   183,     0,   531,
     532,   533,  1503,  1504,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1505,   189,  1506,
     545,   546,   191,  1507,   547,   548,   193,   549,  1508,  1509,
     550,  1510,   551,   552,   553,     0,   554,     0,     0,  1511,
     556,   557,     0,     0,   196,   197,   198,   199,  1512,   558,
     559,   560,   561,   562,   563,   564,     0,   565,  1513,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1514,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,  1515,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,  1516,   609,   218,   610,   611,   220,   612,  1517,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,  1518,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1519,  1520,     0,     0,   633,  1521,   634,
    1522,  1523,   635,   636,   637,   638,   639,   640,   641,     0,
    1524,   642,   643,   644,   645,   646,  1525,     0,   647,   648,
     649,   650,   651,   701,  1526,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,
     702,   662,   663,     0,     0,     0,     0,     0,     0,     0,
    1535,  1536,     0,     0,     0,     0,     0,     0,     0,  1538,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1470,  1471,
    1472,    45,  1473,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,  1474,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,   135,  1475,   137,  1476,  1477,     0,
     436,   437,   438,   439,   440,  1478,  1479,   441,   442,  1480,
    1481,   443,     0,   444,   445,   446,   447,  1482,     0,  1483,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,  1484,
    1485,  1486,  1487,  1488,  1489,  1490,   460,   461,   462,   463,
     695,   464,  1491,  1492,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,  1493,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,  1494,   490,   491,
     492,  1495,  1496,   493,     0,   494,  1497,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
    1498,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,  1499,  1500,
       0,  1501,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,  1502,   182,
     530,   183,     0,   531,   532,   533,  1503,  1504,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,  1505,   189,  1506,   545,   546,   191,  1507,   547,   548,
     193,   549,  1508,  1509,   550,  1510,   551,   552,   553,     0,
     554,     0,     0,  1511,   556,   557,     0,     0,   196,   197,
     198,   199,  1512,   558,   559,   560,   561,   562,   563,   564,
       0,   565,  1513,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,  1514,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
    1515,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,  1516,   609,   218,   610,   611,
     220,   612,  1517,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,  1518,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1519,  1520,     0,
       0,   633,  1521,   634,  1522,  1523,   635,   636,   637,   638,
     639,   640,   641,     0,  1524,   642,   643,   644,   645,   646,
    1525,     0,   647,   648,   649,   650,   651,   701,  1526,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,  4442,  1527,  1528,  1529,  1530,
    1531,  1532,  1533,  1534,   702,   662,   663,     0,     0,     0,
       0,     0,     0,     0,  1535,  1536,     0,     0,     0,     0,
       0,     0,     0,  1538,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1470,  1471,  1472,    45,  1473,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,  1474,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,  1475,
     137,  1476,  1477,     0,   436,   437,   438,   439,   440,  1478,
    1479,   441,   442,  1480,  1481,   443,     0,   444,   445,   446,
     447,  1482,     0,  1483,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,
     460,   461,   462,   463,   695,   464,  1491,  1492,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,  1493,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,  1494,   490,   491,   492,  1495,  1496,   493,     0,   494,
    1497,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,  1498,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,  1499,  1500,     0,  1501,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,  1502,   182,   530,   183,     0,   531,   532,   533,
    1503,  1504,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,  1505,   189,  1506,   545,  4451,
     191,  1507,   547,   548,   193,   549,  1508,  1509,   550,  1510,
     551,   552,   553,     0,   554,     0,     0,  1511,   556,   557,
       0,     0,   196,   197,   198,   199,  1512,   558,   559,   560,
     561,   562,   563,   564,     0,   565,  1513,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,  1514,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,  1515,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,  1516,
     609,   218,   610,   611,   220,   612,  1517,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,  1518,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,  1519,  1520,     0,     0,   633,  1521,   634,  1522,  1523,
     635,   636,   637,   638,   639,   640,   641,     0,  1524,   642,
     643,   644,   645,   646,  1525,     0,   647,   648,   649,   650,
     651,   701,  1526,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
    1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,
     663,     0,     0,     0,     0,     0,     0,     0,  1535,  1536,
       0,     0,     0,     0,     0,     0,     0,  1538,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,   417,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1470,  1471,  1472,    45,
    1473,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
    1474,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,   135,  1475,   137,  1476,  1477,     0,   436,   437,
     438,   439,   440,  1478,  1479,   441,   442,  1480,  1481,   443,
       0,   444,   445,   446,   447,  1482,     0,  1483,     0,   448,
     449,   450,   451,   148,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,  1484,  1485,  1486,
    1487,  1488,  1489,  1490,   460,   461,   462,   463,   695,   464,
    1491,  1492,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,  1493,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,  1494,   490,   491,   492,  1495,
    1496,   493,     0,   494,  1497,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,  1498,     0,
     502,     0,   503,   504,   697,   505,   506,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,  1499,  1500,     0,  1501,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,  1502,   182,   530,   183,
       0,   531,   532,   533,  1503,  1504,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,  1505,
     189,  1506,   545,   546,   191,     0,   547,   548,   193,   549,
    1508,  1509,   550,  1510,   551,   552,   553,     0,   554,     0,
       0,  1511,   556,   557,     0,     0,   196,   197,   198,   199,
    1512,   558,   559,   560,   561,   562,   563,   564,     0,   565,
    1513,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,  1514,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,  1515,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,  1516,   609,   218,   610,   611,   220,   612,
    1517,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,  1518,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,  1519,  1520,     0,     0,   633,
    1521,   634,  1522,  1523,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,  1525,     0,
     647,   648,   649,   650,   651,   701,  1526,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,  1527,  1528,  1529,  1530,  1531,  1532,
    1533,  1534,   702,   662,   663,     0,     0,     0,     0,     0,
       0,     0,  2882,  2883,     0,     0,     0,     0,     0,     0,
       0,  1538,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1470,  1471,  1472,    45,  1473,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,  1474,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435, -2633,  1475,   137,  1476,
    1477,     0,   436,   437,   438,   439,   440,  1478,  1479,   441,
     442,  1480,  1481,   443,     0,   444,   445,   446,   447,  1482,
       0,  1483,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
    5017,  1484,  1485,  1486,  1487,  1488,  1489,  1490,   460,   461,
     462,   463,   695,   464,  1491,  1492,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1493,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,  1494,
     490,   491,   492,  1495,  1496,   493,     0,   494,  1497,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,  1498,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,   175,     0,   517,   518,   519,
    1499,  1500,     0,  1501,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
    1502,   182,   530,     0,     0,   531,   532,   533,  1503,  1504,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1505,   189,  1506,   545,   546,   191,     0,
     547,   548,   193,   549,  1508,  1509,   550,  1510,   551,   552,
     553,     0,   554,     0,     0,  1511,   556,   557,     0,     0,
     196,   197,   198,   199,  1512,   558,   559,   560,   561,   562,
     563,   564,     0,   565,  1513,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1514,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,  1515,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,  1516,   609,   218,
     610,   611,     0,   612,  1517,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,  1518,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1519,
    1520,     0,     0,   633,  1521,   634,  1522,  1523,   635,   636,
     637,   638,  5018,   640,   641,     0,  1524,   642,   643,   644,
     645,   646,  1525,     0,   647,   648,   649,   650,   651,   701,
    1526,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,  1527,  1528,
    1529,  1530,  1531,  1532,  1533,  1534,   702,   662,   663,     0,
       0,     0,     0,     0,     0,     0,  1535,  1536,     0,     0,
       0,     0,     0,     0,     0,  1538,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1470,  1471,     0,    45,  1473,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,  1474,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
     135,  1475,   137,  1476,  1477,     0,   436,   437,   438,   439,
     440,  1478,  1479,   441,   442,  1480,  1481,   443,     0,   444,
     445,   446,   447,  1482,     0,  1483,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,  1484,  1485,  1486,  1487,  1488,
    1489,  1490,   460,   461,   462,   463,   695,   464,  1491,  1492,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1493,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,  1494,   490,   491,   492,  1495,  1496,   493,
       0,   494,  1497,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,  1498,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,  1499,  1500,     0,  1501,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,  1502,   182,   530,   183,     0,   531,
     532,   533,  1503,  1504,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1505,   189,  1506,
     545,   546,   191,     0,   547,   548,   193,   549,  1508,  1509,
     550,  1510,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,   197,   198,   199,  1512,   558,
     559,   560,   561,   562,   563,   564,     0,   565,  1513,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1514,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,  1515,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,  1516,   609,   218,   610,   611,   220,   612,  1517,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,  1518,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1519,  1520,     0,     0,   633,  1521,   634,
    1522,  1523,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,  1525,     0,   647,   648,
     649,   650,   651,   701,  1526,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,
     702,   662,   663,     0,     0,     0,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,  1538,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1470,  1471,     0,    45,  1473,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,  1474,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
     135,  1475,   137,  1476,  1477,     0,  4058,   437,   438,   439,
     440,  1478,  1479,   441,   442,  1480,  1481,   443,     0,   444,
     445,   446,   447,  1482,     0,  1483,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,  1484,  1485,  1486,  1487,  1488,
    1489,  1490,   460,   461,   462,   463,   695,   464,  1491,  1492,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1493,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,  1494,   490,   491,   492,  1495,  1496,   493,
       0,   494,  1497,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,  1498,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,  1499,  1500,     0,  1501,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,  1502,   182,   530,   183,     0,   531,
     532,   533,  1503,  1504,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1505,   189,  1506,
     545,   546,   191,     0,   547,   548,   193,   549,  1508,  1509,
     550,  1510,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,   197,   198,   199,  1512,   558,
     559,   560,   561,   562,   563,   564,     0,   565,  1513,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1514,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,  1515,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,  1516,   609,   218,   610,   611,   220,   612,  1517,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,  1518,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1519,  1520,     0,     0,   633,  1521,   634,
    1522,  1523,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,  1525,     0,   647,   648,
     649,   650,   651,   701,  1526,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,
     702,   662,   663,     0,     0,     0,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,  1538,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1470,  1471,  1472,    45,  1473,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,  1474,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
       0,  1475,   137,  1476,  1477,     0,   436,   437,   438,   439,
     440,  1478,  1479,   441,   442,  1480,  1481,   443,     0,   444,
     445,   446,   447,  1482,     0,  1483,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,  1484,  1485,  1486,  1487,  1488,
    1489,  1490,   460,   461,   462,   463,   695,   464,  1491,  1492,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1493,   478,   479,
       0,   480,   481,   482,     0,   483,     0,   485,     0,   486,
     487,   488,   489,  1494,   490,   491,   492,  1495,  1496,   493,
       0,   494,  1497,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,  1498,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,   175,
       0,   517,   518,   519,  1499,  1500,     0,  1501,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,  1502,   182,   530,     0,     0,   531,
     532,   533,  1503,  1504,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1505,   189,  1506,
     545,   546,   191,     0,   547,   548,   193,   549,  1508,  1509,
     550,  1510,   551,   552,   553,     0,   554,     0,     0,  1511,
     556,   557,     0,     0,   196,   197,   198,   199,  1512,   558,
     559,   560,   561,   562,   563,   564,     0,   565,  1513,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1514,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,  1515,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,  1516,   609,   218,   610,   611,     0,   612,  1517,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,  1518,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1519,  1520,     0,     0,   633,  1521,   634,
    1522,  1523,   635,   636,   637,   638,   639,   640,   641,     0,
    1524,   642,   643,   644,   645,   646,  1525,     0,   647,   648,
     649,   650,   651,   701,  1526,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,  1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,
     702,   662,   663,     0,     0,     0,     0,     0,     0,     0,
    1535,  1536,     0,     0,     0,     0,     0,     0,     0,  1538,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1470,  1471,
    1472,    45,  1473,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,  1474,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,     0,  1475,   137,  1476,  1477,     0,
     436,   437,   438,   439,   440,  1478,  1479,   441,   442,  1480,
    1481,   443,     0,   444,   445,   446,   447,  1482,     0,  1483,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,  1484,
    1485,  1486,  1487,  1488,  1489,  1490,   460,   461,   462,   463,
     695,   464,  1491,  1492,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,  1493,   478,   479,     0,   480,   481,   482,     0,   483,
       0,   485,     0,   486,   487,   488,   489,  1494,   490,   491,
     492,  1495,  1496,   493,     0,   494,  1497,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
    1498,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,   175,     0,   517,   518,   519,  1499,  1500,
       0,  1501,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,  1502,   182,
     530,     0,     0,   531,   532,   533,  1503,  1504,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,  1505,   189,  1506,   545,   546,   191,     0,   547,   548,
     193,   549,  1508,  1509,   550,  1510,   551,   552,   553,     0,
     554,     0,     0,  1511,   556,   557,     0,     0,   196,   197,
     198,   199,  1512,   558,   559,   560,   561,   562,   563,   564,
       0,   565,  1513,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,  1514,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
    1515,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,  1516,   609,   218,   610,   611,
       0,   612,  1517,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,  1518,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1519,  1520,     0,
       0,   633,  1521,   634,  1522,  1523,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
    1525,     0,   647,   648,   649,   650,   651,   701,  1526,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,  1527,  1528,  1529,  1530,
    1531,  1532,  1533,  1534,   702,   662,   663,     0,     0,     0,
       0,     0,     0,     0,  2882,  2883,     0,     0,     0,     0,
       0,     0,     0,  1538,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,   136,
     137,   138,   139,     0,   436,   437,   438,   439,   440,     0,
    1479,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,  1482,     0,  1483,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,  1495,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,  1498,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,  3603,   527,   528,
       0,   529,  1502,   182,   530,   183,     0,   531,   532,   533,
    1503,  1504,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,   189,   190,   545,   546,
     191,     0,   547,   548,   193,   549,     0,  1509,   550,   195,
     551,   552,   553,     0,   554,     0,  1083,   555,   556,   557,
       0,     0,   196,   197,   198,   199,  1512,   558,   559,   560,
     561,   562,   563,   564,     0,   565,  1513,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,   216,   604,   605,   606,   607,   608,  1516,
     609,   218,   610,   611,   220,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,  1518,
       0,   624,   625,   224,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,  1521,   634,  1522,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,  1525,     0,   647,   648,   649,   650,
     651,  2188,   235,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,   237,   657,   658,   659,   660,   661,   238,
    1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,
     663,     0,     0,     0,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,  3604,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,   136,
     137,   138,   139,     0,   436,   437,   438,   439,   440,     0,
    1479,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,  1482,     0,  1483,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,  1495,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,  1498,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,  3603,   527,   528,
       0,   529,  1502,   182,   530,   183,     0,   531,   532,   533,
    1503,  1504,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,   189,   190,   545,   546,
     191,     0,   547,   548,   193,   549,     0,  1509,   550,   195,
     551,   552,   553,     0,   554,     0,  1083,   555,   556,   557,
       0,     0,   196,   197,   198,   199,  1512,   558,   559,   560,
     561,   562,   563,   564,     0,   565,  1513,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,  1516,
     609,   218,   610,   611,   220,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,  1518,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,  1521,   634,  1522,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,  1525,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
    1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,
     663,     0,     0,     0,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,  3604,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,   136,
     137,   138,   139,     0,   436,   437,   438,   439,   440,     0,
    1479,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,  1482,     0,  1483,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,  1495,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,  1498,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,  1502,   182,   530,   183,     0,   531,   532,   533,
    1503,  1504,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,   189,   190,   545,   546,
     191,     0,   547,   548,   193,   549,     0,  1509,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,   197,   198,   199,  1512,   558,   559,   560,
     561,   562,   563,   564,     0,   565,  1513,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,  1516,
     609,   218,   610,   611,   220,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,  1518,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,  1521,   634,  1522,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,  1525,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
    1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,
     663,     0,     0,     0,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,   247,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,   136,
     137,   138,   139,     0,   436,   437,   438,   439,   440,     0,
    1479,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,  1482,     0,  1483,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,  1484,  1485,  1486,  1487,  1488,  1489,  1490,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,  1495,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,  1498,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,  1502,   182,   530,   183,     0,   531,   532,   533,
    1503,  1504,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,   189,   190,   545,   546,
     191,     0,   547,   548,   193,   549,     0,  1509,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,   197,   198,   199,  1512,   558,   559,   560,
     561,   562,   563,   564,     0,   565,  1513,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,  1516,
     609,   218,   610,   611,   220,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,  1518,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,  1521,   634,  1522,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,  1525,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
    1527,  1528,  1529,  1530,  1531,  1532,  1533,  1534,   702,   662,
     663,     0,     0,     0,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,  4178,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,   136,
     137,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,   145,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,     0,     0,     0,   152,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,   182,   530,   183,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,   189,   190,   545,   546,
     191,     0,   547,   548,   193,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,   197,   198,   199,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,   220,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,     0,     0,     0,     0,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,  4757,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,  4104,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
   -1488,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0, -1488,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516, -1488,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521, -1488,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181, -1488,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188, -1488,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594, -1488,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,     0,     0,     0,     0,     0,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,  1629,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,     0,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,  3873,  3874,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,     0,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,  3874,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,   216,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,   224,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,  2188,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,   237,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,     0,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,   247,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,   216,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,   224,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,  2188,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,   237,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,     0,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,   247,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,     0,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,  1604,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,     0,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,  3041,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,     0,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,  4133,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   681,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,     0,   433,   434,   435,   135,
     136,     0,   138,   139,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,   692,   140,   443,     0,   444,   445,
     446,   447,   144,     0,     0,     0,   448,   449,   450,   451,
       0,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,     0,   459,     0,     0,     0,     0,     0,     0,     0,
       0,   460,   461,   462,   463,   695,   464,   155,   156,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,   477,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,   164,   490,   491,   492,   166,     0,   493,     0,
     494,   168,   495,     0,   496,     0,   497,     0,     0,     0,
     498,   499,   500,     0,   501,   172,     0,   502,     0,   503,
     504,   697,   505,   506,     0,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,     0,   175,     0,
     517,   518,   519,     0,   176,     0,   177,     0,   520,     0,
       0,   521,     0,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,   181,     0,   530,     0,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,   188,     0,   190,   545,
     546,   191,     0,   547,   548,     0,   549,     0,   194,   550,
     195,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,   196,     0,     0,     0,   200,   558,   559,
     560,   561,   562,   563,   564,     0,   565,   201,   566,   202,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,   204,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,     0,   595,   596,   213,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,   218,   610,   611,     0,   612,   221,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
     223,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,   225,   226,     0,     0,   633,   227,   634,   228,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,   701,   235,     0,   652,     0,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
     238,   239,   240,   241,   242,   243,   244,   245,   246,   702,
     662,   663,     0,     0,     0,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,  4488,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,   417,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,  1207,    45,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,   733,
     426,   427,   428,   734,   735,   736,   737,   738,   739,   740,
     429,   430,   741,   431,   432,   133,   433,   434,   435,     0,
    1898,   137,  1899,  1900,   742,   436,   437,   438,   439,   440,
     743,   744,   441,   442,  1901,  1902,   443,   746,   444,   445,
     446,   447,     0,   747,   145,   748,   448,   449,   450,   451,
     148,   452,   693,   750,   453,   454,   455,   456,   457,   458,
     751,   151,   459,     0,   753,   754,   755,   152,   756,   757,
     758,   460,   461,   462,   463,   695,   464,  1903,  1904,   465,
     759,   466,   760,   467,   468,   469,   470,   471,   761,   472,
     473,   474,   762,   763,   475,   476,  1493,   478,   479,   764,
     480,   481,   482,   765,   483,   484,   485,   766,   486,   487,
     488,   489,     0,   490,   491,   492,     0,   767,   493,   768,
     494,  1905,   495,   769,   496,   770,   497,   169,   771,   170,
     498,   499,   500,   772,   501,     0,   773,   502,   774,   503,
     504,   697,   505,   506,   173,   507,   508,   509,   775,   510,
     511,   512,   513,   514,   515,   776,   516,   174,     0,     0,
     517,   518,   519,  1499,  1906,   779,  1907,   780,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,   781,   527,
     528,   782,   529,     0,   182,   530,   183,   783,   531,   532,
     533,   784,   785,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1908,   189,  1909,   545,
     546,     0,   786,   547,   548,   193,   549,   787,     0,   550,
    1910,   551,   552,   553,   788,   554,   789,   790,  3860,   556,
     557,   791,   792,     0,   197,   198,   199,     0,   558,   559,
     560,   561,   562,   563,   564,   793,   565,     0,   566,     0,
     567,   568,   569,   794,   570,   571,   572,   573,   574,   575,
     576,   577,  1911,   578,   579,   580,   581,   795,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,   796,
     593,   594,   211,   595,   596,     0,   597,   598,   599,   600,
     601,   602,   700,   603,   797,   604,   605,   606,   607,   608,
     798,   609,  2481,   610,   611,   220,   612,  1913,   613,   799,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
       0,   800,   624,   625,   801,   626,   627,   628,   629,   630,
     631,   802,  1914,  1915,     0,   804,   633,     0,   634,     0,
     805,   635,   636,   637,   638,   639,   640,   641,     0,   807,
     642,   643,   644,   645,   646,   808,   809,   647,   648,   649,
     650,   651,     0,  1916,   811,   652,   236,   653,   654,   655,
     812,   813,   656,   814,   815,   657,   658,   659,   660,   661,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   702,
     662,   663,     0,     0,     0,  1210,  1211,  1212,     0,  3861,
    3862,  1215,  1216,  1217,  1218,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1207,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,  1208,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,  1209,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,     0,     0,     0,  1210,  1211,  1212,     0,  1213,  1214,
    1215,  1216,  1217,  1218,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   681,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,  1207,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,     0,   433,   434,   435,   135,   136,     0,
     138,   139,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,   692,   140,   443,     0,   444,  1301,   446,   447,
     144,     0,     0,     0,   448,   449,   450,   451,     0,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,     0,
     459,     0,     0,     0,     0,     0,     0,     0,     0,   460,
     461,   462,   463,   695,   464,   155,   156,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,   477,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
     164,   490,   491,   492,   166,     0,  1302,     0,   494,   168,
     495,     0,   496,     0,   497,     0,     0,     0,   498,   499,
     500,     0,   501,   172,     0,   502,     0,   503,   504,   697,
     505,   506,     0,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,     0,   175,     0,   517,   518,
     519,     0,   176,     0,   177,     0,   520,     0,     0,   521,
       0,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,   181,     0,   530,     0,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,     0,   190,   545,   546,   191,
       0,   547,   548,     0,   549,     0,   194,   550,   195,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,   196,     0,     0,     0,   200,   558,   559,   560,   561,
     562,   563,   564,     0,   565,   201,   566,   202,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
       0,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
     218,   610,   611,     0,   612,   221,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
     225,   226,     0,     0,   633,   227,   634,   228,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
     701,   235,     0,   652,     0,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
       0,     0,     0,  1210,  1211,  1212,     0,  1213,  1214,  1215,
    1216,  1217,  1218,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1207,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,  1358,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,  1359,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
    1360,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,     0,
       0,     0,  1210,  1211,  1212,     0,  1213,  1214,  1215,  1216,
    1217,  1218,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  1207,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,  1883,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,  1884,     0,   494,   168,   495,     0,
     496,     0,   497,     0,     0,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,     0,
       0,  1210,  1211,  1212,     0,  1213,  1214,  1215,  1216,  1217,
    1218,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    1207,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,     0,     0,     0,
    1210,  1211,  1212,     0,  1213,  1214,  1215,  1216,  1217,  1218,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,  1207,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,  3130,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,  3131,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,     0,     0,     0,  1210,
    1211,  1212,     0,  1213,  1214,  1215,  1216,  1217,  1218,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1207,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,  4740,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,     0,     0,     0,  1210,  1211,
    1212,     0,  1213,  1214,  1215,  1216,  1217,  1218,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,   733,   426,   427,   428,   734,   735,   736,   737,
     738,   739,   740,   429,   430,   741,   431,   432,   133,   433,
     434,   435,   135,   136,   137,   138,   139,   742,   436,   437,
     438,   439,   440,   743,   744,   441,   442,   745,   140,   443,
     746,   444,   445,   446,   447,   144,   747,   145,   748,   448,
     449,   450,   451,   148,   452,   749,   750,   453,   454,   455,
     456,   457,   458,   751,   151,   459,   752,   753,   754,   755,
     152,   756,   757,   758,   460,   461,   462,   463,   695,   464,
     155,   156,   465,   759,   466,   760,   467,   468,   469,   470,
     471,   761,   472,   473,   474,   762,   763,   475,   476,   477,
     478,   479,   764,   480,   481,   482,   765,   483,   484,   485,
     766,   486,   487,   488,   489,   164,   490,   491,   492,   166,
     767,   493,   768,   494,   168,   495,   769,   496,   770,   497,
     169,   771,   170,   498,   499,   500,   772,   501,   172,   773,
     502,   774,   503,   504,   697,   505,   506,   173,   507,   508,
     509,   775,   510,   511,   512,   513,   514,   515,   776,   516,
     174,   175,   777,   517,   518,   519,   778,   176,   779,   177,
     780,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,   781,   527,   528,   782,   529,   181,   182,   530,   183,
     783,   531,   532,   533,   784,   785,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
     189,   190,   545,   546,   191,   786,   547,   548,   193,   549,
     787,   194,   550,   195,   551,   552,   553,   788,   554,   789,
     790,   555,   556,   557,   791,   792,   196,   197,   198,   199,
     200,   558,   559,   560,   561,   562,   563,   564,   793,   565,
     201,   566,   202,   567,   568,   569,   794,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
     795,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,   796,   593,   594,   211,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,   797,   604,   605,
     606,   607,   608,   798,   609,   218,   610,   611,   220,   612,
     221,   613,   799,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,   800,   624,   625,   801,   626,   627,
     628,   629,   630,   631,   802,   225,   226,   803,   804,   633,
     227,   634,   228,   805,   635,   636,   637,   638,   639,   640,
     641,   806,   807,   642,   643,   644,   645,   646,   808,   809,
     647,   648,   649,   650,   651,   810,   235,   811,   652,   236,
     653,   654,   655,   812,   813,   656,   814,   815,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,   726,    86,    87,    88,   678,
      90,    91,    92,   679,  2285,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,     0,
    1898,   137,  1899,  1900,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,  1901,  1902,   443,     0,   444,   445,
     446,   447,     0,     0,   145,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,     0,     0,     0,   152,     0,     0,
       0,   460,   461,   462,   463,   695,   464,  1903,  1904,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1493,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,     0,   490,   491,   492,     0,     0,   493,     0,
     494,  1905,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,     0,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,     0,   510,
     511,   512,   513,   514,   515,     0,   516,   174,     0,     0,
     517,   518,   519,  1499,  1906,     0,  1907,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,     0,   182,   530,   183,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1908,   189,  1909,   545,
     546,     0,     0,   547,   548,   193,   549,     0,     0,   550,
    1910,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,     0,   197,   198,   199,     0,   558,   559,
     560,   561,   562,   563,   564,     0,   565,     0,   566,     0,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1911,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,     0,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,  1912,   610,   611,   220,   612,  1913,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
       0,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1914,  1915,     0,     0,   633,     0,   634,     0,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,     0,  1916,     0,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   702,
     662,   663,     0,    86,    87,    88,   678,    90,    91,    92,
     679,  2388,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,     0,
      86,    87,    88,   678,    90,    91,    92,   679,  1090,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   681,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,     0,
     433,   434,   435,   135,   136,     0,   138,   139,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,   692,   140,
     443,     0,   444,   445,   446,   447,   144,     0,     0,     0,
     448,   449,   450,   451,     0,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,     0,   459,     0,     0,     0,
       0,     0,     0,     0,     0,   460,   461,   462,   463,   695,
     464,   155,   156,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
     477,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,   164,   490,   491,   492,
     166,     0,   493,     0,   494,   168,   495,     0,   496,     0,
     497,     0,     0,     0,   498,   499,   500,     0,   501,   172,
       0,   502,     0,   503,   504,   697,   505,   506,     0,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,     0,   175,     0,   517,   518,   519,     0,   176,     0,
     177,     0,   520,     0,     0,   521,     0,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,   181,     0,   530,
       0,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
     188,     0,   190,   545,   546,   191,     0,   547,   548,     0,
     549,     0,   194,   550,   195,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,   196,     0,     0,
       0,   200,   558,   559,   560,   561,   562,   563,   564,     0,
     565,   201,   566,   202,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,   204,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,     0,   595,   596,   213,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,   218,   610,   611,     0,
     612,   221,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,   223,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,   225,   226,     0,     0,
     633,   227,   634,   228,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,   701,   235,     0,   652,
       0,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,   238,   239,   240,   241,   242,   243,
     244,   245,   246,   702,   662,   663,     0,    86,    87,    88,
     678,    90,    91,    92,   679,  4781,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,   418,   988,   420,   421,   422,   423,   424,   425,
     989,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   990,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   991,   168,   495,     0,   496,     0,   992,     0,   993,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,   994,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   995,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     996,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   997,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   998,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,     0,     0,     0,     0,     0,     0,     0,
     999,  1000,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   418,   988,   420,
     421,   422,   423,   424,   425,   989,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,  1021,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   991,   168,   495,     0,
     496,     0,  1022,     0,   993,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,   994,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   995,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   996,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     997,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   998,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,     0,
       0,     0,     0,     0,     0,   999,  1000,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
    1406,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,   993,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,   994,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,     0,     0,     0,     0,     0,     0,     0,
     999,  1000,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   681,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,   417,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,  1411,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,     0,   433,   434,   435,   135,   136,     0,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
       0,     0,   448,   449,   450,   451,     0,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,     0,   459,     0,
       0,     0,     0,     0,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,     0,   993,     0,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,   506,
       0,   507,   508,   509,   994,   510,   511,   512,   513,   514,
     515,     0,   516,     0,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,     0,     0,   521,     0,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
       0,   530,     0,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,     0,   190,   545,   546,   191,     0,   547,
     548,     0,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
       0,     0,     0,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,     0,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,     0,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,     0,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,     0,     0,
       0,     0,     0,     0,     0,   999,  1000,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,   696,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,  1575,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,     0,     0,  1061,  1576,    86,    87,    88,
     678,    90,    91,    92,   679,  1062,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,  1063,   442,  1037,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,  1064,     0,  1065,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,  1066,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,  1067,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,  1068,   596,   213,   597,   598,   599,
    1069,   601,   602,   700,   603,     0,   604,   605,   606,   607,
    1070,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1071,   226,     0,     0,  1072,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,  1041,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
    1073,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,   733,   426,   427,
     428,   734,   735,   736,   737,   738,   739,   740,   429,   430,
     741,   431,   432,   133,   433,   434,   435,   135,   136,   137,
     138,   139,   742,   436,   437,   438,   439,   440,   743,   744,
     441,   442,   745,   140,   443,   746,   444,   445,   446,   447,
     144,   747,   145,   748,   448,   449,   450,   451,   148,   452,
     749,   750,   453,   454,   455,   456,   457,   458,   751,   151,
     459,   752,   753,   754,   755,   152,   756,   757,   758,   460,
     461,   462,   463,   695,   464,   155,   156,   465,   759,   466,
     760,   467,   468,   469,   470,   471,   761,   472,   473,   474,
     762,   763,   475,   476,   477,   478,   479,   764,   480,   481,
     482,   765,   483,   484,   485,   766,   486,   487,   488,   489,
     164,   490,   491,   492,   166,   767,   493,   768,   494,   168,
     495,   769,   496,   770,   497,   169,   771,   170,   498,   499,
     500,   772,   501,   172,   773,   502,   774,   503,   504,   697,
     505,   506,   173,   507,   508,   509,   775,   510,   511,   512,
     513,   514,   515,   776,   516,   174,   175,   777,   517,   518,
     519,   778,   176,   779,   177,   780,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,   781,   527,   528,   782,
     529,   181,   182,   530,   183,   783,   531,   532,   533,   784,
     785,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,   188,   189,   190,   545,   546,   191,
     786,   547,   548,   193,   549,   787,   194,   550,   195,   551,
     552,   553,   788,   554,   789,   790,   555,   556,   557,   791,
     792,   196,   197,   198,   199,   200,   558,   559,   560,   561,
     562,   563,   564,   793,   565,   201,   566,   202,   567,   568,
     569,   794,   570,   571,   572,   573,   574,   575,   576,   577,
     204,   578,   579,   580,   581,   795,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,   796,   593,   594,
     211,   595,   596,   213,   597,   598,   599,   600,   601,   602,
     700,   603,   797,   604,   605,   606,   607,   608,   798,   609,
     218,   610,   611,   220,   612,   221,   613,   799,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,   223,   800,
     624,   625,   801,   626,   627,   628,   629,   630,   631,   802,
     225,   226,   803,   804,   633,   227,   634,   228,   805,   635,
     636,   637,   638,   639,   640,   641,   806,   807,   642,   643,
     644,   645,   646,   808,   809,   647,   648,   649,   650,   651,
     810,   235,   811,   652,   236,   653,   654,   655,   812,   813,
     656,   814,   815,   657,   658,   659,   660,   661,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   702,   662,   663,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,   733,   426,   427,   428,   734,   735,
     736,   737,   738,   739,   740,   429,   430,   741,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,   742,
     436,   437,   438,   439,   440,   743,   744,   441,   442,   745,
     140,   443,   746,   444,   445,   446,   447,   144,   747,   145,
     748,   448,   449,   450,   451,   148,   452,   749,   750,   453,
     454,   455,   456,   457,   458,   751,   151,   459,   752,   753,
     754,   755,   152,   756,   757,   758,   460,   461,   462,   463,
     695,   464,   155,   156,   465,   759,   466,   760,   467,   468,
     469,   470,   471,   761,   472,   473,   474,   762,   763,   475,
     476,   477,   478,   479,   764,   480,   481,   482,   765,   483,
     484,   485,   766,   486,   487,   488,   489,   164,   490,   491,
     492,   166,   767,   493,   768,   494,   168,   495,   769,   496,
     770,   497,   169,   771,   170,   498,   499,   500,   772,   501,
     172,   773,   502,   774,   503,   504,   697,   505,   506,   173,
     507,   508,   509,   775,   510,   511,   512,   513,   514,   515,
     776,   516,   174,   175,   777,   517,   518,   519,   778,   176,
     779,   177,   780,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,   781,   527,   528,   782,   529,   181,   182,
     530,   183,   783,   531,   532,   533,   784,   785,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,   189,   190,   545,   546,   191,   786,   547,   548,
     193,   549,   787,   194,   550,   195,   551,   552,   553,   788,
     554,   789,   790,   555,   556,   557,   791,   792,   196,   197,
     198,   199,   200,   558,   559,   560,   561,   562,   563,   564,
     793,   565,   201,   566,   202,   567,   568,   569,   794,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,   795,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,   796,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,   797,
     604,   605,   606,   607,   608,   798,   609,   218,   610,   611,
     220,   612,   221,   613,   799,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,   800,   624,   625,   801,
     626,   627,   628,   629,   630,   631,   802,   225,   226,   803,
     804,   633,   227,   634,   228,   805,   635,   636,   637,   638,
     639,   640,   641,   806,   807,   642,   643,   644,   645,   646,
     808,   809,   647,   648,   649,   650,   651,   810,   235,   811,
     652,   236,   653,   654,   655,   812,   813,   656,   814,   815,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,  3195,   423,   424,
     425,   733,   426,   427,   428,   734,   735,   736,   737,   738,
     739,   740,   429,   430,   741,   431,   432,   133,   433,   434,
     435,   135,   136,   137,   138,   139,   742,   436,   437,   438,
     439,   440,   743,   744,   441,   442,   745,   140,   443,   746,
     444,   445,   446,   447,   144,   747,   145,   748,   448,   449,
     450,   451,   148,   452,   749,   750,   453,   454,   455,   456,
     457,   458,   751,   151,   459,   752,   753,   754,   755,   152,
     756,   757,   758,   460,   461,   462,   463,   695,   464,   155,
     156,   465,   759,   466,   760,   467,   468,   469,   470,   471,
     761,   472,   473,   474,   762,   763,   475,   476,   477,  3196,
     479,   764,   480,   481,   482,   765,   483,   484,   485,   766,
     486,   487,   488,   489,   164,   490,   491,   492,   166,   767,
     493,   768,   494,   168,   495,   769,   496,   770,   497,   169,
     771,   170,   498,   499,   500,   772,   501,   172,   773,   502,
     774,   503,   504,   697,   505,   506,   173,   507,   508,   509,
     775,   510,   511,   512,   513,   514,   515,   776,   516,   174,
     175,   777,   517,   518,   519,   778,   176,   779,   177,   780,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
     781,   527,   528,   782,   529,   181,   182,   530,   183,   783,
     531,   532,   533,   784,   785,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,   188,   189,
     190,   545,   546,   191,   786,   547,   548,   193,   549,   787,
     194,   550,   195,   551,   552,   553,   788,   554,   789,   790,
     555,   556,   557,   791,   792,   196,   197,   198,   199,   200,
     558,   559,   560,   561,   562,   563,   564,   793,   565,   201,
     566,   202,   567,   568,   569,   794,   570,   571,   572,   573,
     574,   575,   576,   577,   204,   578,   579,   580,   581,   795,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,   796,   593,   594,   211,   595,   596,   213,   597,   598,
     599,   600,   601,   602,   700,   603,   797,   604,   605,   606,
     607,   608,   798,  3197,   218,   610,   611,   220,   612,   221,
     613,   799,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,   223,   800,   624,   625,   801,   626,   627,   628,
     629,   630,   631,   802,   225,   226,   803,   804,   633,   227,
     634,   228,   805,   635,   636,   637,   638,   639,   640,   641,
     806,   807,   642,   643,   644,   645,   646,   808,   809,   647,
     648,   649,   650,   651,   810,   235,   811,   652,   236,   653,
     654,   655,   812,   813,   656,   814,   815,   657,   658,   659,
     660,   661,   238,   239,   240,   241,   242,   243,   244,   245,
     246,   702,   662,   663,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,   135,   136,
     137,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,   145,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,     0,     0,     0,   152,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,   182,   530,   183,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,   189,   190,   545,   546,
     191,     0,   547,   548,   193,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,   197,   198,   199,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,   220,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,   726,    86,    87,    88,   678,    90,    91,    92,   679,
       0,   680,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   727,   104,   105,   681,   728,     0,   107,   108,   109,
     110,   729,   730,   112,   113,   114,   115,     0,   116,   731,
     732,   682,   683,     0,     0,     0,   684,   685,     0,     0,
       0,     0,   686,     0,     0,     0,     0,     0,     0,     0,
       0,   687,     0,   688,     0,   689,   690,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   418,   419,   420,
     421,   422,   423,   424,   425,     0,   426,   427,   428,     0,
       0,     0,     0,     0,     0,     0,   429,   430,     0,   431,
     432,   133,   433,   434,   435,   135,   136,   137,   138,   139,
       0,   436,   437,   438,   439,   440,     0,     0,   441,   442,
     692,   140,   443,     0,   444,   445,   446,   447,   144,     0,
     145,     0,   448,   449,   450,   451,   148,   452,   693,     0,
     453,   454,   455,   456,   457,   458,     0,   151,   459,     0,
       0,     0,     0,   152,     0,     0,     0,   460,   461,   462,
     463,   695,   464,   155,   156,   465,     0,   466,     0,   467,
     468,   469,   470,   471,     0,   472,   473,   474,     0,     0,
     475,   476,   477,   478,   479,     0,   480,   481,   482,     0,
     483,   484,   485,     0,   486,   487,   488,   489,   164,   490,
     491,   492,   166,     0,   493,     0,   494,   168,   495,     0,
     496,     0,   497,   169,     0,   170,   498,   499,   500,     0,
     501,   172,     0,   502,     0,   503,   504,   697,   505,  1341,
     173,   507,   508,   509,     0,   510,   511,   512,   513,   514,
     515,     0,   516,   174,   175,     0,   517,   518,   519,     0,
     176,     0,   177,     0,   520,   178,   179,   521,   180,   522,
     523,   524,   525,   526,     0,   527,   528,     0,   529,   181,
     182,   530,   183,     0,   531,   532,   533,     0,     0,   534,
     535,   536,   537,   538,   539,   698,   540,   541,   699,   542,
     543,   544,   188,   189,   190,   545,   546,   191,     0,   547,
     548,   193,   549,     0,   194,   550,   195,   551,   552,   553,
       0,   554,     0,     0,   555,   556,   557,     0,     0,   196,
     197,   198,   199,   200,   558,   559,   560,   561,   562,   563,
     564,     0,   565,   201,   566,   202,   567,   568,   569,     0,
     570,   571,   572,   573,   574,   575,   576,   577,   204,   578,
     579,   580,   581,     0,   582,   583,   584,   585,   586,   587,
     588,   589,   590,   591,   592,     0,   593,   594,   211,   595,
     596,   213,   597,   598,   599,   600,   601,   602,   700,   603,
       0,   604,   605,   606,   607,   608,     0,   609,   218,   610,
     611,   220,   612,   221,   613,     0,   614,   615,   616,   617,
     618,   619,   620,   621,   622,   623,   223,     0,   624,   625,
       0,   626,   627,   628,   629,   630,   631,     0,   225,   226,
       0,     0,   633,   227,   634,   228,     0,   635,   636,   637,
     638,   639,   640,   641,     0,     0,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,   651,   701,   235,
       0,   652,   236,   653,   654,   655,     0,     0,   656,     0,
       0,   657,   658,   659,   660,   661,   238,   239,   240,   241,
     242,   243,   244,   245,   246,   702,   662,   663,   726,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   727,   104,
     105,   681,   728,     0,   107,   108,   109,   110,   729,   730,
     112,   113,   114,   115,     0,   116,   731,   732,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,   133,   433,
     434,   435,   135,   136,   137,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,   145,     0,   448,
     449,   450,   451,   148,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,   151,   459,     0,     0,     0,     0,
     152,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
     169,     0,   170,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,  1351,   173,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
     174,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,   178,   179,   521,   180,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,   182,   530,   183,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
     189,   190,   545,   546,   191,     0,   547,   548,   193,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,   197,   198,   199,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,   211,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,   220,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,   236,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,   726,    86,    87,    88,   678,
      90,    91,    92,   679,     0,   680,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   727,   104,   105,   681,   728,
       0,   107,   108,   109,   110,   729,   730,   112,   113,   114,
     115,     0,   116,   731,   732,   682,   683,     0,     0,     0,
     684,   685,     0,     0,     0,     0,   686,     0,     0,     0,
       0,     0,     0,     0,     0,   687,     0,   688,     0,   689,
     690,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   418,   419,   420,   421,   422,   423,   424,   425,     0,
     426,   427,   428,     0,     0,     0,     0,     0,     0,     0,
     429,   430,     0,   431,   432,   133,   433,   434,   435,     0,
    1898,   137,  1899,  1900,     0,   436,   437,   438,   439,   440,
       0,     0,   441,   442,  1901,  1902,   443,     0,   444,   445,
     446,   447,     0,     0,   145,     0,   448,   449,   450,   451,
     148,   452,   693,     0,   453,   454,   455,   456,   457,   458,
       0,   151,   459,     0,     0,     0,     0,   152,     0,     0,
       0,   460,   461,   462,   463,   695,   464,  1903,  1904,   465,
       0,   466,     0,   467,   468,   469,   470,   471,     0,   472,
     473,   474,     0,     0,   475,   476,  1493,   478,   479,     0,
     480,   481,   482,     0,   483,   484,   485,     0,   486,   487,
     488,   489,     0,   490,   491,   492,     0,     0,   493,     0,
     494,  1905,   495,     0,   496,     0,   497,   169,     0,   170,
     498,   499,   500,     0,   501,     0,     0,   502,     0,   503,
     504,   697,   505,   506,   173,   507,   508,   509,  2478,   510,
     511,   512,   513,   514,   515,     0,   516,   174,  2479,     0,
     517,   518,   519,  1499,  1906,     0,  1907,     0,   520,   178,
     179,   521,   180,   522,   523,   524,   525,   526,     0,   527,
     528,     0,   529,     0,   182,   530,   183,     0,   531,   532,
     533,     0,     0,   534,   535,   536,   537,   538,   539,   698,
     540,   541,   699,   542,   543,   544,  1908,   189,  1909,   545,
     546,     0,     0,   547,   548,   193,   549,     0,     0,   550,
    1910,   551,   552,   553,     0,   554,     0,     0,   555,   556,
     557,     0,     0,  2480,   197,   198,   199,     0,   558,   559,
     560,   561,   562,   563,   564,     0,   565,     0,   566,     0,
     567,   568,   569,     0,   570,   571,   572,   573,   574,   575,
     576,   577,  1911,   578,   579,   580,   581,     0,   582,   583,
     584,   585,   586,   587,   588,   589,   590,   591,   592,     0,
     593,   594,   211,   595,   596,     0,   597,   598,   599,   600,
     601,   602,   700,   603,     0,   604,   605,   606,   607,   608,
       0,   609,  2481,   610,   611,   220,   612,  1913,   613,     0,
     614,   615,   616,   617,   618,   619,   620,   621,   622,   623,
       0,     0,   624,   625,     0,   626,   627,   628,   629,   630,
     631,     0,  1914,  1915,     0,     0,   633,     0,   634,     0,
       0,   635,   636,   637,   638,   639,   640,   641,     0,     0,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,   651,     0,  1916,  2482,   652,   236,   653,   654,   655,
       0,     0,   656,     0,     0,   657,   658,   659,   660,   661,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   702,
     662,   663,   726,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   727,   104,   105,   681,   728,     0,   107,   108,
     109,   110,   729,   730,   112,   113,   114,   115,     0,   116,
     731,   732,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,   133,   433,   434,   435,     0,  1898,   137,  1899,
    1900,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,  1901,  1902,   443,     0,   444,   445,   446,   447,     0,
       0,   145,     0,   448,   449,   450,   451,   148,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,   151,   459,
       0,     0,     0,     0,   152,     0,     0,     0,   460,   461,
     462,   463,   695,   464,  1903,  1904,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,  1493,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,     0,
     490,   491,   492,     0,     0,   493,     0,   494,  1905,   495,
       0,   496,     0,   497,   169,     0,   170,   498,   499,   500,
       0,   501,     0,     0,   502,     0,   503,   504,   697,   505,
     506,   173,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,   174,     0,     0,   517,   518,   519,
    1499,  1906,     0,  1907,     0,   520,   178,   179,   521,   180,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
       0,   182,   530,   183,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,  1908,   189,  1909,   545,   546,     0,     0,
     547,   548,   193,   549,  2466,     0,   550,  1910,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
       0,   197,   198,   199,     0,   558,   559,   560,   561,   562,
     563,   564,     0,   565,     0,   566,     0,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,  1911,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,   211,
     595,   596,     0,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,  2481,
     610,   611,   220,   612,  1913,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,     0,     0,   624,
     625,  3964,   626,   627,   628,   629,   630,   631,     0,  1914,
    1915,     0,     0,   633,     0,   634,     0,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,     0,
    1916,     0,   652,   236,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   702,   662,   663,   726,
      86,    87,    88,   678,    90,    91,    92,   679,     0,   680,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   727,
     104,   105,   681,   728,     0,   107,   108,   109,   110,   729,
     730,   112,   113,   114,   115,     0,   116,   731,   732,   682,
     683,     0,     0,     0,   684,   685,     0,     0,     0,     0,
     686,     0,     0,     0,     0,     0,     0,     0,     0,   687,
       0,   688,     0,   689,   690,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   418,   419,   420,   421,   422,
     423,   424,   425,     0,   426,   427,   428,     0,     0,     0,
       0,     0,     0,     0,   429,   430,     0,   431,   432,   133,
     433,   434,   435,     0,  1898,   137,  1899,  1900,     0,   436,
     437,   438,   439,   440,     0,     0,   441,   442,  1901,  1902,
     443,     0,   444,   445,   446,   447,     0,     0,   145,     0,
     448,   449,   450,   451,   148,   452,   693,     0,   453,   454,
     455,   456,   457,   458,     0,   151,   459,     0,     0,     0,
       0,   152,     0,     0,     0,   460,   461,   462,   463,   695,
     464,  1903,  1904,   465,     0,   466,     0,   467,   468,   469,
     470,   471,     0,   472,   473,   474,     0,     0,   475,   476,
    1493,   478,   479,     0,   480,   481,   482,     0,   483,   484,
     485,     0,   486,   487,   488,   489,     0,   490,   491,   492,
       0,     0,   493,     0,   494,  1905,   495,     0,   496,     0,
     497,   169,     0,   170,   498,   499,   500,     0,   501,     0,
       0,   502,     0,   503,   504,   697,   505,   506,   173,   507,
     508,   509,     0,   510,   511,   512,   513,   514,   515,     0,
     516,   174,     0,     0,   517,   518,   519,  1499,  1906,     0,
    1907,     0,   520,   178,   179,   521,   180,   522,   523,   524,
     525,   526,     0,   527,   528,     0,   529,     0,   182,   530,
     183,     0,   531,   532,   533,     0,     0,   534,   535,   536,
     537,   538,   539,   698,   540,   541,   699,   542,   543,   544,
    1908,   189,  1909,   545,   546,  2532,     0,   547,   548,   193,
     549,     0,     0,   550,  1910,   551,   552,   553,     0,   554,
       0,     0,   555,   556,   557,     0,     0,     0,   197,   198,
     199,     0,   558,   559,   560,   561,   562,   563,   564,     0,
     565,     0,   566,     0,   567,   568,   569,     0,   570,   571,
     572,   573,   574,   575,   576,   577,  1911,   578,   579,   580,
     581,     0,   582,   583,   584,   585,   586,   587,   588,   589,
     590,   591,   592,     0,   593,   594,   211,   595,   596,     0,
     597,   598,   599,   600,   601,   602,   700,   603,     0,   604,
     605,   606,   607,   608,     0,   609,  1912,   610,   611,   220,
     612,  1913,   613,     0,   614,   615,   616,   617,   618,   619,
     620,   621,   622,   623,     0,     0,   624,   625,     0,   626,
     627,   628,   629,   630,   631,     0,  1914,  1915,     0,     0,
     633,     0,   634,     0,     0,   635,   636,   637,   638,   639,
     640,   641,     0,     0,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,   651,     0,  1916,     0,   652,
     236,   653,   654,   655,     0,     0,   656,     0,     0,   657,
     658,   659,   660,   661,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   702,   662,   663,   726,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   727,   104,   105,   681,
     728,     0,   107,   108,   109,   110,   729,   730,   112,   113,
     114,   115,     0,   116,   731,   732,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,   133,   433,   434,   435,
       0,  1898,   137,  1899,  1900,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,  1901,  1902,   443,     0,   444,
     445,   446,   447,     0,     0,   145,     0,   448,   449,   450,
     451,   148,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,   151,   459,     0,     0,     0,     0,   152,     0,
       0,     0,   460,   461,   462,   463,   695,   464,  1903,  1904,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,  1493,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,     0,   490,   491,   492,     0,     0,   493,
       0,   494,  1905,   495,     0,   496,     0,   497,   169,     0,
     170,   498,   499,   500,     0,   501,     0,     0,   502,     0,
     503,   504,   697,   505,   506,   173,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,   174,     0,
       0,   517,   518,   519,  1499,  1906,     0,  1907,     0,   520,
     178,   179,   521,   180,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,     0,   182,   530,   183,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,  1908,   189,  1909,
     545,   546,  3796,     0,   547,   548,   193,   549,     0,     0,
     550,  1910,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,     0,   197,   198,   199,     0,   558,
     559,   560,   561,   562,   563,   564,     0,   565,     0,   566,
       0,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,  1911,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,   211,   595,   596,     0,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,  1912,   610,   611,   220,   612,  1913,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,     0,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1914,  1915,     0,     0,   633,     0,   634,
       0,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,     0,  1916,     0,   652,   236,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     702,   662,   663,   726,    86,    87,    88,   678,    90,    91,
      92,   679,     0,   680,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   727,   104,   105,   681,   728,     0,   107,
     108,   109,   110,   729,   730,   112,   113,   114,   115,     0,
     116,   731,   732,   682,   683,     0,     0,     0,   684,   685,
       0,     0,     0,     0,   686,     0,     0,     0,     0,     0,
       0,     0,     0,   687,     0,   688,     0,   689,   690,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   418,
     419,   420,   421,   422,   423,   424,   425,     0,   426,   427,
     428,     0,     0,     0,     0,     0,     0,     0,   429,   430,
       0,   431,   432,   133,   433,   434,   435,     0,  1898,   137,
    1899,  1900,     0,   436,   437,   438,   439,   440,     0,     0,
     441,   442,  1901,  1902,   443,     0,   444,   445,   446,   447,
       0,     0,   145,     0,   448,   449,   450,   451,   148,   452,
     693,     0,   453,   454,   455,   456,   457,   458,     0,   151,
     459,     0,     0,     0,     0,   152,     0,     0,     0,   460,
     461,   462,   463,   695,   464,  1903,  1904,   465,     0,   466,
       0,   467,   468,   469,   470,   471,     0,   472,   473,   474,
       0,     0,   475,   476,  1493,   478,   479,     0,   480,   481,
     482,     0,   483,   484,   485,     0,   486,   487,   488,   489,
       0,   490,   491,   492,     0,     0,   493,     0,   494,  1905,
     495,     0,   496,     0,   497,   169,     0,   170,   498,   499,
     500,     0,   501,     0,     0,   502,     0,   503,   504,   697,
     505,   506,   173,   507,   508,   509,     0,   510,   511,   512,
     513,   514,   515,     0,   516,   174,     0,     0,   517,   518,
     519,  1499,  1906,     0,  1907,     0,   520,   178,   179,   521,
     180,   522,   523,   524,   525,   526,     0,   527,   528,     0,
     529,     0,   182,   530,   183,     0,   531,   532,   533,     0,
       0,   534,   535,   536,   537,   538,   539,   698,   540,   541,
     699,   542,   543,   544,  1908,   189,  1909,   545,   546,     0,
       0,   547,   548,   193,   549,     0,     0,   550,  1910,   551,
     552,   553,     0,   554,     0,     0,   555,   556,   557,     0,
       0,     0,   197,   198,   199,     0,   558,   559,   560,   561,
     562,   563,   564,     0,   565,     0,   566,     0,   567,   568,
     569,     0,   570,   571,   572,   573,   574,   575,   576,   577,
    1911,   578,   579,   580,   581,     0,   582,   583,   584,   585,
     586,   587,   588,   589,   590,   591,   592,     0,   593,   594,
     211,   595,   596,     0,   597,   598,   599,   600,   601,   602,
     700,   603,     0,   604,   605,   606,   607,   608,     0,   609,
    1912,   610,   611,   220,   612,  1913,   613,     0,   614,   615,
     616,   617,   618,   619,   620,   621,   622,   623,     0,     0,
     624,   625,     0,   626,   627,   628,   629,   630,   631,     0,
    1914,  1915,     0,     0,   633,     0,   634,     0,     0,   635,
     636,   637,   638,   639,   640,   641,     0,     0,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,   651,
       0,  1916,     0,   652,   236,   653,   654,   655,     0,     0,
     656,     0,     0,   657,   658,   659,   660,   661,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   702,   662,   663,
     726,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     727,   104,   105,   681,   728,     0,   107,   108,   109,   110,
     729,   730,   112,   113,   114,   115,     0,   116,   731,   732,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
     133,   433,   434,   435,     0,  1898,   137,  1899,  1900,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,  1901,
    1902,   443,     0,   444,   445,   446,   447,     0,     0,   145,
       0,   448,   449,   450,   451,   148,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,   151,   459,     0,     0,
       0,     0,   152,     0,     0,     0,   460,   461,   462,   463,
     695,   464,  1903,  1904,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,  1493,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,     0,   490,   491,
     492,     0,     0,   493,     0,   494,  1905,   495,     0,   496,
       0,   497,   169,     0,   170,   498,   499,   500,     0,   501,
       0,     0,   502,     0,   503,   504,   697,   505,   506,   173,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,   174,     0,     0,   517,   518,   519,  1499,  1906,
       0,  1907,     0,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,     0,   182,
     530,   183,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,  1908,   189,  1909,   545,   546,     0,     0,   547,   548,
     193,   549,     0,     0,   550,  1910,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,     0,   197,
     198,   199,     0,   558,   559,   560,   561,   562,   563,   564,
       0,   565,     0,   566,     0,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,  1911,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,   211,   595,   596,
       0,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,  2481,   610,   611,
     220,   612,  1913,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,     0,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1914,  1915,     0,
       0,   633,     0,   634,     0,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,     0,  1916,     0,
     652,   236,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   702,   662,   663,   726,    86,    87,
      88,   678,    90,    91,    92,   679,     0,   680,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   727,   104,   105,
     681,   728,     0,   107,   108,   109,   110,   729,   730,   112,
     113,   114,   115,     0,   116,   731,   732,   682,   683,     0,
       0,     0,   684,   685,     0,     0,     0,     0,   686,     0,
       0,     0,     0,     0,     0,     0,     0,   687,     0,   688,
       0,   689,   690,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   418,   419,   420,   421,   422,   423,   424,
     425,     0,   426,   427,   428,     0,     0,     0,     0,     0,
       0,     0,   429,   430,     0,   431,   432,   133,   433,   434,
     435,     0,  1898,   137,  1899,  1900,     0,   436,   437,   438,
     439,   440,     0,     0,   441,   442,  1901,  1902,   443,     0,
     444,   445,   446,   447,     0,     0,   145,     0,   448,   449,
     450,   451,   148,   452,   693,     0,   453,   454,   455,   456,
     457,   458,     0,   151,   459,     0,     0,     0,     0,   152,
       0,     0,     0,   460,   461,   462,   463,   695,   464,  1903,
    1904,   465,     0,   466,     0,   467,   468,   469,   470,   471,
       0,   472,   473,   474,     0,     0,   475,   476,  1493,   478,
     479,     0,   480,   481,   482,     0,   483,   484,   485,     0,
     486,   487,   488,   489,     0,   490,   491,   492,     0,     0,
     493,     0,   494,  1905,   495,     0,   496,     0,   497,   169,
       0,   170,   498,   499,   500,     0,   501,     0,     0,   502,
       0,   503,   504,   697,   505,   506,   173,   507,   508,   509,
       0,   510,   511,   512,   513,   514,   515,     0,   516,   174,
       0,     0,   517,   518,   519,  1499,  1906,     0,  1907,     0,
     520,   178,   179,   521,   180,   522,   523,   524,   525,   526,
       0,   527,   528,     0,   529,     0,   182,   530,   183,     0,
     531,   532,   533,     0,     0,   534,   535,   536,   537,   538,
     539,   698,   540,   541,   699,   542,   543,   544,  1908,   189,
    1909,   545,   546,     0,     0,   547,   548,   193,   549,     0,
       0,   550,  1910,   551,   552,   553,     0,   554,     0,     0,
     555,   556,   557,     0,     0,     0,   197,   198,   199,     0,
     558,   559,   560,   561,   562,   563,   564,     0,   565,     0,
     566,     0,   567,   568,   569,     0,   570,   571,   572,   573,
     574,   575,   576,   577,  1911,   578,   579,   580,   581,     0,
     582,   583,   584,   585,   586,   587,   588,   589,   590,   591,
     592,     0,   593,   594,   211,   595,   596,     0,   597,   598,
     599,   600,   601,   602,   700,   603,     0,   604,   605,   606,
     607,   608,     0,   609,     0,   610,   611,   220,   612,  1913,
     613,     0,   614,   615,   616,   617,   618,   619,   620,   621,
     622,   623,     0,     0,   624,   625,     0,   626,   627,   628,
     629,   630,   631,     0,  1914,  1915,     0,     0,   633,     0,
     634,     0,     0,   635,   636,   637,   638,   639,   640,   641,
       0,     0,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,   651,     0,  1916,     0,   652,   236,   653,
     654,   655,     0,     0,   656,     0,     0,   657,   658,   659,
     660,   661,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   702,   662,   663,   726,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   727,   104,   105,   681,   728,     0,
     107,   108,   109,   110,   729,   730,   112,   113,   114,   115,
       0,   116,   731,   732,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,   133,   433,   434,   435,     0,     0,
     137,     0,     0,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,     0,     0,   443,     0,   444,   445,   446,
     447,     0,     0,   145,     0,   448,   449,   450,   451,   148,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
     151,   459,     0,     0,     0,     0,   152,     0,     0,     0,
     460,   461,   462,   463,   695,   464,     0,     0,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,     0,   490,   491,   492,     0,     0,   493,     0,   494,
       0,   495,     0,   496,     0,   497,   169,     0,   170,   498,
     499,   500,     0,   501,     0,     0,   502,     0,   503,   504,
     697,   505,   506,   173,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,   174,     0,     0,   517,
     518,   519,     0,     0,     0,     0,     0,   520,   178,   179,
     521,   180,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,     0,   182,   530,   183,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,     0,   189,     0,   545,   546,
       0,     0,   547,   548,   193,   549,     0,     0,   550,     0,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,     0,   197,   198,   199,     0,   558,   559,   560,
     561,   562,   563,   564,     0,   565,     0,   566,     0,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,     0,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,   211,   595,   596,     0,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,     0,   610,   611,   220,   612,     0,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,     0,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,     0,     0,     0,     0,   633,     0,   634,     0,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,     0,     0,     0,   652,   236,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,   733,   426,   427,   428,   734,   735,
     736,   737,   738,   739,   740,   429,   430,   741,   431,   432,
     133,   433,   434,   435,   135,   136,   137,   138,   139,   742,
     436,   437,   438,   439,   440,   743,   744,   441,   442,     0,
     140,   443,   746,   444,   445,   446,   447,   144,   747,   145,
     748,   448,   449,   450,   451,   148,   452,   749,   750,   453,
     454,   455,   456,   457,   458,   751,   151,   459,     0,   753,
     754,   755,   152,   756,   757,   758,   460,   461,   462,   463,
       0,   464,   155,   156,   465,   759,   466,   760,   467,   468,
     469,   470,   471,   761,   472,   473,   474,   762,   763,   475,
     476,   477,   478,   479,   764,   480,   481,   482,   765,   483,
     484,   485,   766,   486,   487,   488,   489,   164,   490,   491,
     492,   166,   767,   493,   768,   494,   168,   495,   769,   496,
     770,   497,   169,   771,   170,   498,   499,   500,   772,   501,
     172,   773,   502,   774,   503,   504,     0,   505,   506,   173,
     507,   508,   509,   775,   510,   511,   512,   513,   514,   515,
     776,   516,   174,   175,     0,   517,   518,   519,     0,   176,
     779,   177,   780,   520,   178,   179,   521,   180,   522,   523,
     524,   525,   526,   781,   527,   528,   782,   529,   181,   182,
     530,   183,   783,   531,   532,   533,   784,   785,   534,   535,
     536,   537,   538,   539,     0,   540,   541,     0,   542,   543,
     544,   188,   189,   190,   545,   546,   191,   786,   547,   548,
     193,   549,   787,   194,   550,   195,   551,   552,   553,   788,
     554,   789,   790,   555,   556,   557,   791,   792,   196,   197,
     198,   199,   200,   558,   559,   560,   561,   562,   563,   564,
     793,   565,   201,   566,   202,   567,   568,   569,   794,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,   795,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,   796,   593,   594,   211,   595,   596,
     213,   597,   598,   599,   600,   601,   602,     0,   603,   797,
     604,   605,   606,   607,   608,   798,   609,   218,   610,   611,
     220,   612,   221,   613,   799,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,   800,   624,   625,   801,
     626,   627,   628,   629,   630,   631,   802,   225,   226,     0,
     804,   633,   227,   634,   228,   805,   635,   636,   637,   638,
     639,   640,   641,     0,   807,   642,   643,   644,   645,   646,
     808,   809,   647,   648,   649,   650,   651,     0,   235,   811,
     652,   236,   653,   654,   655,   812,   813,   656,   814,   815,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,     0,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,    37,    38,    39,    40,
      41,    42,     0,    44,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,  1152,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,    37,    38,    39,    40,    41,    42,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
    2412,   444,   445,   446,   447,   144,     0,     0,  2494,   448,
     449,   450,   451,     0,   452,   693,  2413,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,  2495,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,  2415,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,  2416,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,  2417,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,  2412,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,  2413,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,  2495,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,  2415,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,  3358,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,  2416,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,  2417,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,  1050,   424,   425,  1008,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,  1009,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,  1051,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,  1010,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,  1011,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
    1008,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,  1009,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,  3092,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,  1010,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,  1011,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
    2412,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,  2413,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,  2495,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,  2415,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,  2416,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,  2417,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,   691,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,   694,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,   696,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,  1008,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,  1009,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,  1010,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,  1011,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,   920,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
     921,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   922,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,  2089,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,  2090,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,  2091,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,  2092,   497,     0,     0,     0,  2093,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,  2094,  2095,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,  2096,   601,   602,   700,
     603,     0,  2097,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,  2098,   626,  2099,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
    2100,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,  1009,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
    1010,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,  1011,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,  2078,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,  2370,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,  2968,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,  2969,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,  2970,   626,   627,  2971,   629,  2972,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,  2973,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,   718,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,   417,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,   696,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,   870,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,   417,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,  1333,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,   130,   131,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,  3179,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
    3180,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
    3191,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,  3192,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,   417,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,   417,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   926,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,   417,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   970,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,   417,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,  1025,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,  1083,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
    1230,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,  1083,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,  1578,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,  1752,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,  1083,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,  1986,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,  2078,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,  2370,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,  4104,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,  4118,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,  4338,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,  4340,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,  4342,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,  4743,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,   506,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,  1034,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,  1036,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,  1037,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,     0,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,  1038,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,  1039,   226,     0,
       0,  1040,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,  1041,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
    1077,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,  1037,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,     0,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
    1078,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,  1079,   226,     0,     0,  1080,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,  1041,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,  1097,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,  1203,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,  1227,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,  1238,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,  1292,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
    1306,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,  1346,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,  1353,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,  1363,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,  1365,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
    1367,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,  1369,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,  1372,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,  1374,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
    1375,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,  1378,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,  1589,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,  1063,
     442,  1037,   140,  1590,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,     0,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
     506,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,  1067,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
    1068,   596,   213,   597,   598,   599,  1069,   601,   602,   700,
     603,     0,   604,   605,   606,   607,  1582,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,  1071,
     226,     0,     0,  1072,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,  1041,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,  1073,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,  1715,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,   506,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,  1798,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,  1945,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,  1975,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,   609,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
    2010,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,  2012,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,  2014,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,   506,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,  2127,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,  2337,
       0,   429,   430,     0,   431,   432,     0,   433,   434,   435,
     135,   136,     0,   138,   139,     0,   436,   437,   438,   439,
     440,     0,     0,   441,   442,   692,   140,   443,     0,   444,
     445,   446,   447,   144,     0,     0,     0,   448,   449,   450,
     451,     0,   452,   693,     0,   453,   454,   455,   456,   457,
     458,     0,     0,   459,     0,     0,     0,     0,     0,     0,
       0,     0,   460,   461,   462,   463,   695,   464,   155,   156,
     465,     0,   466,     0,   467,   468,   469,   470,   471,     0,
     472,   473,   474,     0,     0,   475,   476,   477,   478,   479,
       0,   480,   481,   482,     0,   483,   484,   485,     0,   486,
     487,   488,   489,   164,   490,   491,   492,   166,     0,   493,
       0,   494,   168,   495,     0,   496,     0,   497,     0,     0,
       0,   498,   499,   500,     0,   501,   172,     0,   502,     0,
     503,   504,   697,   505,   506,     0,   507,   508,   509,     0,
     510,   511,   512,   513,   514,   515,     0,   516,     0,   175,
       0,   517,   518,   519,     0,   176,     0,   177,     0,   520,
       0,     0,   521,     0,   522,   523,   524,   525,   526,     0,
     527,   528,     0,   529,   181,     0,   530,     0,     0,   531,
     532,   533,     0,     0,   534,   535,   536,   537,   538,   539,
     698,   540,   541,   699,   542,   543,   544,   188,     0,   190,
     545,   546,   191,     0,   547,   548,     0,   549,     0,   194,
     550,   195,   551,   552,   553,     0,   554,     0,     0,   555,
     556,   557,     0,     0,   196,     0,     0,     0,   200,   558,
     559,   560,   561,   562,   563,   564,     0,   565,   201,   566,
     202,   567,   568,   569,     0,   570,   571,   572,   573,   574,
     575,   576,   577,   204,   578,   579,   580,   581,     0,   582,
     583,   584,   585,   586,   587,   588,   589,   590,   591,   592,
       0,   593,   594,     0,   595,   596,   213,   597,   598,   599,
     600,   601,   602,   700,   603,     0,   604,   605,   606,   607,
     608,     0,     0,   218,   610,   611,     0,   612,   221,   613,
       0,   614,   615,   616,   617,   618,   619,   620,   621,   622,
     623,   223,     0,   624,   625,     0,   626,   627,   628,   629,
     630,   631,     0,   225,   226,     0,     0,   633,   227,   634,
     228,     0,   635,   636,   637,   638,   639,   640,   641,     0,
       0,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,   651,   701,   235,     0,   652,     0,   653,   654,
     655,     0,     0,   656,     0,     0,   657,   658,   659,   660,
     661,   238,   239,   240,   241,   242,   243,   244,   245,   246,
     702,   662,   663,    86,    87,    88,   678,    90,    91,    92,
     679,     0,   680,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   681,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   682,   683,     0,     0,     0,   684,   685,     0,
       0,     0,     0,   686,     0,     0,     0,     0,     0,     0,
       0,     0,   687,     0,   688,     0,   689,   690,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   418,   419,
     420,   421,   422,   423,   424,   425,     0,   426,   427,   428,
       0,     0,     0,     0,     0,     0,     0,   429,   430,     0,
     431,   432,     0,   433,   434,   435,   135,   136,     0,   138,
     139,     0,   436,   437,   438,   439,   440,     0,     0,   441,
     442,   692,   140,   443,     0,   444,   445,   446,   447,   144,
       0,     0,     0,   448,   449,   450,   451,     0,   452,   693,
       0,   453,   454,   455,   456,   457,   458,     0,     0,   459,
       0,     0,     0,     0,     0,     0,     0,     0,   460,   461,
     462,   463,   695,   464,   155,   156,   465,     0,   466,     0,
     467,   468,   469,   470,   471,     0,   472,   473,   474,     0,
       0,   475,   476,   477,   478,   479,     0,   480,   481,   482,
       0,   483,   484,   485,     0,   486,   487,   488,   489,   164,
     490,   491,   492,   166,     0,   493,     0,   494,   168,   495,
       0,   496,     0,   497,     0,     0,     0,   498,   499,   500,
       0,   501,   172,     0,   502,     0,   503,   504,   697,   505,
    2728,     0,   507,   508,   509,     0,   510,   511,   512,   513,
     514,   515,     0,   516,     0,   175,     0,   517,   518,   519,
       0,   176,     0,   177,     0,   520,     0,     0,   521,     0,
     522,   523,   524,   525,   526,     0,   527,   528,     0,   529,
     181,     0,   530,     0,     0,   531,   532,   533,     0,     0,
     534,   535,   536,   537,   538,   539,   698,   540,   541,   699,
     542,   543,   544,   188,     0,   190,   545,   546,   191,     0,
     547,   548,     0,   549,     0,   194,   550,   195,   551,   552,
     553,     0,   554,     0,     0,   555,   556,   557,     0,     0,
     196,     0,     0,     0,   200,   558,   559,   560,   561,   562,
     563,   564,     0,   565,   201,   566,   202,   567,   568,   569,
       0,   570,   571,   572,   573,   574,   575,   576,   577,   204,
     578,   579,   580,   581,     0,   582,   583,   584,   585,   586,
     587,   588,   589,   590,   591,   592,     0,   593,   594,     0,
     595,   596,   213,   597,   598,   599,   600,   601,   602,   700,
     603,     0,   604,   605,   606,   607,   608,     0,   609,   218,
     610,   611,     0,   612,   221,   613,     0,   614,   615,   616,
     617,   618,   619,   620,   621,   622,   623,   223,     0,   624,
     625,     0,   626,   627,   628,   629,   630,   631,     0,   225,
     226,     0,     0,   633,   227,   634,   228,     0,   635,   636,
     637,   638,   639,   640,   641,     0,     0,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,   651,   701,
     235,     0,   652,     0,   653,   654,   655,     0,     0,   656,
       0,     0,   657,   658,   659,   660,   661,   238,   239,   240,
     241,   242,   243,   244,   245,   246,   702,   662,   663,    86,
      87,    88,   678,    90,    91,    92,   679,     0,   680,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   681,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   682,   683,
       0,     0,     0,   684,   685,     0,     0,     0,     0,   686,
       0,     0,     0,     0,     0,     0,     0,     0,   687,     0,
     688,     0,   689,   690,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   418,   419,   420,   421,   422,   423,
     424,   425,     0,   426,   427,   428,     0,     0,     0,     0,
       0,     0,     0,   429,   430,     0,   431,   432,     0,   433,
     434,   435,   135,   136,     0,   138,   139,     0,   436,   437,
     438,   439,   440,     0,     0,   441,   442,   692,   140,   443,
       0,   444,   445,   446,   447,   144,     0,     0,     0,   448,
     449,   450,   451,     0,   452,   693,     0,   453,   454,   455,
     456,   457,   458,     0,     0,   459,     0,     0,     0,     0,
       0,     0,     0,     0,   460,   461,   462,   463,   695,   464,
     155,   156,   465,     0,   466,     0,   467,   468,   469,   470,
     471,     0,   472,   473,   474,     0,     0,   475,   476,   477,
     478,   479,     0,   480,   481,   482,     0,   483,   484,   485,
       0,   486,   487,   488,   489,   164,   490,   491,   492,   166,
       0,   493,     0,   494,   168,   495,     0,   496,     0,   497,
       0,     0,     0,   498,   499,   500,     0,   501,   172,     0,
     502,     0,   503,   504,   697,   505,  3103,     0,   507,   508,
     509,     0,   510,   511,   512,   513,   514,   515,     0,   516,
       0,   175,     0,   517,   518,   519,     0,   176,     0,   177,
       0,   520,     0,     0,   521,     0,   522,   523,   524,   525,
     526,     0,   527,   528,     0,   529,   181,     0,   530,     0,
       0,   531,   532,   533,     0,     0,   534,   535,   536,   537,
     538,   539,   698,   540,   541,   699,   542,   543,   544,   188,
       0,   190,   545,   546,   191,     0,   547,   548,     0,   549,
       0,   194,   550,   195,   551,   552,   553,     0,   554,     0,
       0,   555,   556,   557,     0,     0,   196,     0,     0,     0,
     200,   558,   559,   560,   561,   562,   563,   564,     0,   565,
     201,   566,   202,   567,   568,   569,     0,   570,   571,   572,
     573,   574,   575,   576,   577,   204,   578,   579,   580,   581,
       0,   582,   583,   584,   585,   586,   587,   588,   589,   590,
     591,   592,     0,   593,   594,     0,   595,   596,   213,   597,
     598,   599,   600,   601,   602,   700,   603,     0,   604,   605,
     606,   607,   608,     0,   609,   218,   610,   611,     0,   612,
     221,   613,     0,   614,   615,   616,   617,   618,   619,   620,
     621,   622,   623,   223,     0,   624,   625,     0,   626,   627,
     628,   629,   630,   631,     0,   225,   226,     0,     0,   633,
     227,   634,   228,     0,   635,   636,   637,   638,   639,   640,
     641,     0,     0,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,   651,   701,   235,     0,   652,     0,
     653,   654,   655,     0,     0,   656,     0,     0,   657,   658,
     659,   660,   661,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   702,   662,   663,    86,    87,    88,   678,    90,
      91,    92,   679,     0,   680,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   681,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   682,   683,     0,     0,     0,   684,
     685,     0,     0,     0,     0,   686,     0,     0,     0,     0,
       0,     0,     0,     0,   687,     0,   688,     0,   689,   690,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     418,   419,   420,   421,   422,   423,   424,   425,     0,   426,
     427,   428,     0,     0,     0,     0,     0,     0,     0,   429,
     430,     0,   431,   432,     0,   433,   434,   435,   135,   136,
       0,   138,   139,     0,   436,   437,   438,   439,   440,     0,
       0,   441,   442,   692,   140,   443,     0,   444,   445,   446,
     447,   144,     0,     0,     0,   448,   449,   450,   451,     0,
     452,   693,     0,   453,   454,   455,   456,   457,   458,     0,
       0,   459,     0,     0,     0,     0,     0,     0,     0,     0,
     460,   461,   462,   463,   695,   464,   155,   156,   465,     0,
     466,     0,   467,   468,   469,   470,   471,     0,   472,   473,
     474,     0,     0,   475,   476,   477,   478,   479,     0,   480,
     481,   482,     0,   483,   484,   485,     0,   486,   487,   488,
     489,   164,   490,   491,   492,   166,     0,   493,     0,   494,
     168,   495,     0,   496,     0,   497,     0,     0,     0,   498,
     499,   500,     0,   501,   172,     0,   502,     0,   503,   504,
     697,   505,  3182,     0,   507,   508,   509,     0,   510,   511,
     512,   513,   514,   515,     0,   516,     0,   175,     0,   517,
     518,   519,     0,   176,     0,   177,     0,   520,     0,     0,
     521,     0,   522,   523,   524,   525,   526,     0,   527,   528,
       0,   529,   181,     0,   530,     0,     0,   531,   532,   533,
       0,     0,   534,   535,   536,   537,   538,   539,   698,   540,
     541,   699,   542,   543,   544,   188,     0,   190,   545,   546,
     191,     0,   547,   548,     0,   549,     0,   194,   550,   195,
     551,   552,   553,     0,   554,     0,     0,   555,   556,   557,
       0,     0,   196,     0,     0,     0,   200,   558,   559,   560,
     561,   562,   563,   564,     0,   565,   201,   566,   202,   567,
     568,   569,     0,   570,   571,   572,   573,   574,   575,   576,
     577,   204,   578,   579,   580,   581,     0,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,     0,   593,
     594,     0,   595,   596,   213,   597,   598,   599,   600,   601,
     602,   700,   603,     0,   604,   605,   606,   607,   608,     0,
     609,   218,   610,   611,     0,   612,   221,   613,     0,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   223,
       0,   624,   625,     0,   626,   627,   628,   629,   630,   631,
       0,   225,   226,     0,     0,   633,   227,   634,   228,     0,
     635,   636,   637,   638,   639,   640,   641,     0,     0,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
     651,   701,   235,     0,   652,     0,   653,   654,   655,     0,
       0,   656,     0,     0,   657,   658,   659,   660,   661,   238,
     239,   240,   241,   242,   243,   244,   245,   246,   702,   662,
     663,    86,    87,    88,   678,    90,    91,    92,   679,     0,
     680,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   681,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     682,   683,     0,     0,     0,   684,   685,     0,     0,     0,
       0,   686,     0,     0,     0,     0,     0,     0,     0,     0,
     687,     0,   688,     0,   689,   690,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   418,   419,   420,   421,
     422,   423,   424,   425,     0,   426,   427,   428,     0,     0,
       0,     0,     0,     0,     0,   429,   430,     0,   431,   432,
       0,   433,   434,   435,   135,   136,     0,   138,   139,     0,
     436,   437,   438,   439,   440,     0,     0,   441,   442,   692,
     140,   443,     0,   444,   445,   446,   447,   144,     0,     0,
       0,   448,   449,   450,   451,     0,   452,   693,     0,   453,
     454,   455,   456,   457,   458,     0,     0,   459,     0,     0,
       0,     0,     0,     0,     0,     0,   460,   461,   462,   463,
     695,   464,   155,   156,   465,     0,   466,     0,   467,   468,
     469,   470,   471,     0,   472,   473,   474,     0,     0,   475,
     476,   477,   478,   479,     0,   480,   481,   482,     0,   483,
     484,   485,     0,   486,   487,   488,   489,   164,   490,   491,
     492,   166,     0,   493,     0,   494,   168,   495,     0,   496,
       0,   497,     0,     0,     0,   498,   499,   500,     0,   501,
     172,     0,   502,     0,   503,   504,   697,   505,  3184,     0,
     507,   508,   509,     0,   510,   511,   512,   513,   514,   515,
       0,   516,     0,   175,     0,   517,   518,   519,     0,   176,
       0,   177,     0,   520,     0,     0,   521,     0,   522,   523,
     524,   525,   526,     0,   527,   528,     0,   529,   181,     0,
     530,     0,     0,   531,   532,   533,     0,     0,   534,   535,
     536,   537,   538,   539,   698,   540,   541,   699,   542,   543,
     544,   188,     0,   190,   545,   546,   191,     0,   547,   548,
       0,   549,     0,   194,   550,   195,   551,   552,   553,     0,
     554,     0,     0,   555,   556,   557,     0,     0,   196,     0,
       0,     0,   200,   558,   559,   560,   561,   562,   563,   564,
       0,   565,   201,   566,   202,   567,   568,   569,     0,   570,
     571,   572,   573,   574,   575,   576,   577,   204,   578,   579,
     580,   581,     0,   582,   583,   584,   585,   586,   587,   588,
     589,   590,   591,   592,     0,   593,   594,     0,   595,   596,
     213,   597,   598,   599,   600,   601,   602,   700,   603,     0,
     604,   605,   606,   607,   608,     0,   609,   218,   610,   611,
       0,   612,   221,   613,     0,   614,   615,   616,   617,   618,
     619,   620,   621,   622,   623,   223,     0,   624,   625,     0,
     626,   627,   628,   629,   630,   631,     0,   225,   226,     0,
       0,   633,   227,   634,   228,     0,   635,   636,   637,   638,
     639,   640,   641,     0,     0,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,   651,   701,   235,     0,
     652,     0,   653,   654,   655,     0,     0,   656,     0,     0,
     657,   658,   659,   660,   661,   238,   239,   240,   241,   242,
     243,   244,   245,   246,   702,   662,   663,    86,    87,    88,
     678,    90,    91,    92,   679,     0,   680,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   681,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   682,   683,     0,     0,
       0,   684,   685,     0,     0,     0,     0,   686,     0,     0,
       0,     0,     0,     0,     0,     0,   687,     0,   688,     0,
     689,   690,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   418,   419,   420,   421,   422,   423,   424,   425,
       0,   426,   427,   428,     0,     0,     0,     0,     0,     0,
       0,   429,   430,     0,  