/* A Bison parser, made by GNU Bison 3.0.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2013 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.0.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1


/* Substitute the variable and function names.  */
#define yyparse         base_yyparse
#define yylex           base_yylex
#define yyerror         base_yyerror
#define yydebug         base_yydebug
#define yynerrs         base_yynerrs

#define yylval          base_yylval
#define yychar          base_yychar
#define yylloc          base_yylloc

/* Copy the first part of user declarations.  */
#line 5 "preproc.y" /* yacc.c:339  */

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
		if (N)						\
			(Current) = (Rhs)[1];	\
		else						\
			(Current) = (Rhs)[0];	\
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char	pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, base_yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (base_yyin)
				fclose(base_yyin);
			if (base_yyout)
				fclose(base_yyout);

			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
				fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(base_yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essentially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), mm_strdup(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in another functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn't cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = EMPTY;
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char var_text[20];
			char *original_var;
			bool skip_set_var = false;
			bool var_ptr = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(var_text, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable)
					 && (strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement")) == 0))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar
					  && ptr->variable->type->type != ECPGt_char
					  && ptr->variable->type->type != ECPGt_unsigned_char
					  && ptr->variable->type->type != ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																			   mm_strdup("1"),
																			   ptr->variable->type->u.element->counter),
														  ptr->variable->type->size),
									  0);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar
					  || ptr->variable->type->type == ECPGt_char
					  || ptr->variable->type->type == ECPGt_unsigned_char
					  || ptr->variable->type->type == ECPGt_string)
					 && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, mm_strdup("("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				if (ptr->variable->type->type == ECPGt_varchar)
					var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_struct
					 || ptr->variable->type->type == ECPGt_union)
			{
				newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
									  ECPGmake_struct_type(ptr->variable->type->u.members,
														   ptr->variable->type->type,
														   ptr->variable->type->type_name,
														   ptr->variable->type->struct_sizeof),
									  0);
				var_ptr = true;
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct
					|| ptr->variable->type->u.element->type == ECPGt_union)
				{
					newvar = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->variable->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->variable->type->u.element->u.members,
															   ptr->variable->type->u.element->type,
															   ptr->variable->type->u.element->type_name,
															   ptr->variable->type->u.element->struct_sizeof),
										  0);
				}
				else
				{
					newvar = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type,
																				   ptr->variable->type->u.element->size,
																				   ptr->variable->type->u.element->counter),
															  ptr->variable->type->size),
										  0);
					var_ptr = true;
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, mm_strdup("*("),
											  mm_strdup(ecpg_type_name(ptr->variable->type->type)),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text)),
									  ECPGmake_simple_type(ptr->variable->type->type,
														   ptr->variable->type->size,
														   ptr->variable->type->counter),
									  0);
				var_ptr = true;
			}

			/* create call to "ECPGset_var(<counter>, <connection>, <pointer>. <line number>)" */
			if (!skip_set_var)
			{
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(var_text, "%d))", ecpg_internal_var);
				var_ptr = false;

				if (ptr->indicator->type->type == ECPGt_struct
					|| ptr->indicator->type->type == ECPGt_union)
				{
					newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
										  ECPGmake_struct_type(ptr->indicator->type->u.members,
															   ptr->indicator->type->type,
															   ptr->indicator->type->type_name,
															   ptr->indicator->type->struct_sizeof),
										  0);
					var_ptr = true;
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct
						|| ptr->indicator->type->u.element->type == ECPGt_union)
					{
						newind = new_variable(cat_str(5, mm_strdup("(*("),
											  mm_strdup(ptr->indicator->type->u.element->type_name),
											  mm_strdup(" *)(ECPGget_var("),
											  mm_strdup(var_text),
											  mm_strdup(")")),
											  ECPGmake_struct_type(ptr->indicator->type->u.element->u.members,
																   ptr->indicator->type->u.element->type,
																   ptr->indicator->type->u.element->type_name,
																   ptr->indicator->type->u.element->struct_sizeof),
											  0);
					}
					else
					{
						newind = new_variable(cat_str(4, mm_strdup("("),
													  mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)),
													  mm_strdup(" *)(ECPGget_var("), mm_strdup(var_text)),
											  ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type,
																					   ptr->indicator->type->u.element->size,
																					   ptr->indicator->type->u.element->counter),
																  ptr->indicator->type->size),
											  0);
						var_ptr = true;
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, mm_strdup("("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
				}
				else
				{
					newind = new_variable(cat_str(4, mm_strdup("*("),
												  mm_strdup(ecpg_type_name(ptr->indicator->type->type)),
												  mm_strdup(" *)(ECPGget_var("),
												  mm_strdup(var_text)),
										  ECPGmake_simple_type(ptr->indicator->type->type,
															   ptr->indicator->type->size,
															   ptr->variable->type->counter),
										  0);
					var_ptr = true;
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				sprintf(var_text, "%d, %s", ecpg_internal_var++, var_ptr ? "&(" : "(");
				result = cat_str(5, result, mm_strdup("ECPGset_var("),
								 mm_strdup(var_text), mm_strdup(original_var),
								 mm_strdup("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && strcmp(cur->function, current_function) == 0))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;
	int (* strcmp_fn)(const char *, const char *) = ((name[0] == ':' || name[0] == '"') ? strcmp : pg_strcasecmp);

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp_fn(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char *dimension, char *length, enum ECPGttype type_enum,
			char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
		 type_enum == ECPGt_union) &&
		initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}

#line 630 "preproc.c" /* yacc.c:339  */

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* In a future release of Bison, this section will be replaced
   by #include "preproc.h".  */
#ifndef YY_BASE_YY_PREPROC_H_INCLUDED
# define YY_BASE_YY_PREPROC_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int base_yydebug;
#endif

/* Token type.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    SQL_ALLOCATE = 258,
    SQL_AUTOCOMMIT = 259,
    SQL_BOOL = 260,
    SQL_BREAK = 261,
    SQL_CALL = 262,
    SQL_CARDINALITY = 263,
    SQL_CONNECT = 264,
    SQL_COUNT = 265,
    SQL_DATETIME_INTERVAL_CODE = 266,
    SQL_DATETIME_INTERVAL_PRECISION = 267,
    SQL_DESCRIBE = 268,
    SQL_DESCRIPTOR = 269,
    SQL_DISCONNECT = 270,
    SQL_FOUND = 271,
    SQL_FREE = 272,
    SQL_GET = 273,
    SQL_GO = 274,
    SQL_GOTO = 275,
    SQL_IDENTIFIED = 276,
    SQL_INDICATOR = 277,
    SQL_KEY_MEMBER = 278,
    SQL_LENGTH = 279,
    SQL_LONG = 280,
    SQL_NULLABLE = 281,
    SQL_OCTET_LENGTH = 282,
    SQL_OPEN = 283,
    SQL_OUTPUT = 284,
    SQL_REFERENCE = 285,
    SQL_RETURNED_LENGTH = 286,
    SQL_RETURNED_OCTET_LENGTH = 287,
    SQL_SCALE = 288,
    SQL_SECTION = 289,
    SQL_SHORT = 290,
    SQL_SIGNED = 291,
    SQL_SQL = 292,
    SQL_SQLERROR = 293,
    SQL_SQLPRINT = 294,
    SQL_SQLWARNING = 295,
    SQL_START = 296,
    SQL_STOP = 297,
    SQL_STRUCT = 298,
    SQL_UNSIGNED = 299,
    SQL_VAR = 300,
    SQL_WHENEVER = 301,
    S_ADD = 302,
    S_AND = 303,
    S_ANYTHING = 304,
    S_AUTO = 305,
    S_CONST = 306,
    S_DEC = 307,
    S_DIV = 308,
    S_DOTPOINT = 309,
    S_EQUAL = 310,
    S_EXTERN = 311,
    S_INC = 312,
    S_LSHIFT = 313,
    S_MEMPOINT = 314,
    S_MEMBER = 315,
    S_MOD = 316,
    S_MUL = 317,
    S_NEQUAL = 318,
    S_OR = 319,
    S_REGISTER = 320,
    S_RSHIFT = 321,
    S_STATIC = 322,
    S_SUB = 323,
    S_VOLATILE = 324,
    S_TYPEDEF = 325,
    CSTRING = 326,
    CVARIABLE = 327,
    CPP_LINE = 328,
    IP = 329,
    DOLCONST = 330,
    ECONST = 331,
    NCONST = 332,
    UCONST = 333,
    UIDENT = 334,
    IDENT = 335,
    FCONST = 336,
    SCONST = 337,
    BCONST = 338,
    XCONST = 339,
    Op = 340,
    ICONST = 341,
    PARAM = 342,
    TYPECAST = 343,
    DOT_DOT = 344,
    COLON_EQUALS = 345,
    ABORT_P = 346,
    ABSOLUTE_P = 347,
    ACCESS = 348,
    ACTION = 349,
    ADD_P = 350,
    ADMIN = 351,
    AFTER = 352,
    AGGREGATE = 353,
    ALL = 354,
    ALSO = 355,
    ALTER = 356,
    ALWAYS = 357,
    ANALYSE = 358,
    ANALYZE = 359,
    AND = 360,
    ANY = 361,
    ARRAY = 362,
    AS = 363,
    ASC = 364,
    ASSERTION = 365,
    ASSIGNMENT = 366,
    ASYMMETRIC = 367,
    AT = 368,
    ATTRIBUTE = 369,
    AUTHORIZATION = 370,
    BACKWARD = 371,
    BEFORE = 372,
    BEGIN_P = 373,
    BETWEEN = 374,
    BIGINT = 375,
    BINARY = 376,
    BIT = 377,
    BOOLEAN_P = 378,
    BOTH = 379,
    BY = 380,
    CACHE = 381,
    CALLED = 382,
    CASCADE = 383,
    CASCADED = 384,
    CASE = 385,
    CAST = 386,
    CATALOG_P = 387,
    CHAIN = 388,
    CHAR_P = 389,
    CHARACTER = 390,
    CHARACTERISTICS = 391,
    CHECK = 392,
    CHECKPOINT = 393,
    CLASS = 394,
    CLOSE = 395,
    CLUSTER = 396,
    COALESCE = 397,
    COLLATE = 398,
    COLLATION = 399,
    COLUMN = 400,
    COMMENT = 401,
    COMMENTS = 402,
    COMMIT = 403,
    COMMITTED = 404,
    CONCURRENTLY = 405,
    CONFIGURATION = 406,
    CONNECTION = 407,
    CONSTRAINT = 408,
    CONSTRAINTS = 409,
    CONTENT_P = 410,
    CONTINUE_P = 411,
    CONVERSION_P = 412,
    COPY = 413,
    COST = 414,
    CREATE = 415,
    CROSS = 416,
    CSV = 417,
    CURRENT_P = 418,
    CURRENT_CATALOG = 419,
    CURRENT_DATE = 420,
    CURRENT_ROLE = 421,
    CURRENT_SCHEMA = 422,
    CURRENT_TIME = 423,
    CURRENT_TIMESTAMP = 424,
    CURRENT_USER = 425,
    CURSOR = 426,
    CYCLE = 427,
    DATA_P = 428,
    DATABASE = 429,
    DAY_P = 430,
    DEALLOCATE = 431,
    DEC = 432,
    DECIMAL_P = 433,
    DECLARE = 434,
    DEFAULT = 435,
    DEFAULTS = 436,
    DEFERRABLE = 437,
    DEFERRED = 438,
    DEFINER = 439,
    DELETE_P = 440,
    DELIMITER = 441,
    DELIMITERS = 442,
    DESC = 443,
    DICTIONARY = 444,
    DISABLE_P = 445,
    DISCARD = 446,
    DISTINCT = 447,
    DO = 448,
    DOCUMENT_P = 449,
    DOMAIN_P = 450,
    DOUBLE_P = 451,
    DROP = 452,
    EACH = 453,
    ELSE = 454,
    ENABLE_P = 455,
    ENCODING = 456,
    ENCRYPTED = 457,
    END_P = 458,
    ENUM_P = 459,
    ESCAPE = 460,
    EXCEPT = 461,
    EXCLUDE = 462,
    EXCLUDING = 463,
    EXCLUSIVE = 464,
    EXECUTE = 465,
    EXISTS = 466,
    EXPLAIN = 467,
    EXTENSION = 468,
    EXTERNAL = 469,
    EXTRACT = 470,
    FALSE_P = 471,
    FAMILY = 472,
    FETCH = 473,
    FIRST_P = 474,
    FLOAT_P = 475,
    FOLLOWING = 476,
    FOR = 477,
    FORCE = 478,
    FOREIGN = 479,
    FORWARD = 480,
    FREEZE = 481,
    FROM = 482,
    FULL = 483,
    FUNCTION = 484,
    FUNCTIONS = 485,
    GLOBAL = 486,
    GRANT = 487,
    GRANTED = 488,
    GREATEST = 489,
    GROUP_P = 490,
    HANDLER = 491,
    HAVING = 492,
    HEADER_P = 493,
    HOLD = 494,
    HOUR_P = 495,
    IDENTITY_P = 496,
    IF_P = 497,
    ILIKE = 498,
    IMMEDIATE = 499,
    IMMUTABLE = 500,
    IMPLICIT_P = 501,
    IN_P = 502,
    INCLUDING = 503,
    INCREMENT = 504,
    INDEX = 505,
    INDEXES = 506,
    INHERIT = 507,
    INHERITS = 508,
    INITIALLY = 509,
    INLINE_P = 510,
    INNER_P = 511,
    INOUT = 512,
    INPUT_P = 513,
    INSENSITIVE = 514,
    INSERT = 515,
    INSTEAD = 516,
    INT_P = 517,
    INTEGER = 518,
    INTERSECT = 519,
    INTERVAL = 520,
    INTO = 521,
    INVOKER = 522,
    IS = 523,
    ISNULL = 524,
    ISOLATION = 525,
    JOIN = 526,
    KEY = 527,
    LABEL = 528,
    LANGUAGE = 529,
    LARGE_P = 530,
    LAST_P = 531,
    LC_COLLATE_P = 532,
    LC_CTYPE_P = 533,
    LEADING = 534,
    LEAKPROOF = 535,
    LEAST = 536,
    LEFT = 537,
    LEVEL = 538,
    LIKE = 539,
    LIMIT = 540,
    LISTEN = 541,
    LOAD = 542,
    LOCAL = 543,
    LOCALTIME = 544,
    LOCALTIMESTAMP = 545,
    LOCATION = 546,
    LOCK_P = 547,
    MAPPING = 548,
    MATCH = 549,
    MAXVALUE = 550,
    MINUTE_P = 551,
    MINVALUE = 552,
    MODE = 553,
    MONTH_P = 554,
    MOVE = 555,
    NAME_P = 556,
    NAMES = 557,
    NATIONAL = 558,
    NATURAL = 559,
    NCHAR = 560,
    NEXT = 561,
    NO = 562,
    NONE = 563,
    NOT = 564,
    NOTHING = 565,
    NOTIFY = 566,
    NOTNULL = 567,
    NOWAIT = 568,
    NULL_P = 569,
    NULLIF = 570,
    NULLS_P = 571,
    NUMERIC = 572,
    OBJECT_P = 573,
    OF = 574,
    OFF = 575,
    OFFSET = 576,
    OIDS = 577,
    ON = 578,
    ONLY = 579,
    OPERATOR = 580,
    OPTION = 581,
    OPTIONS = 582,
    OR = 583,
    ORDER = 584,
    OUT_P = 585,
    OUTER_P = 586,
    OVER = 587,
    OVERLAPS = 588,
    OVERLAY = 589,
    OWNED = 590,
    OWNER = 591,
    PARSER = 592,
    PARTIAL = 593,
    PARTITION = 594,
    PASSING = 595,
    PASSWORD = 596,
    PLACING = 597,
    PLANS = 598,
    POSITION = 599,
    PRECEDING = 600,
    PRECISION = 601,
    PRESERVE = 602,
    PREPARE = 603,
    PREPARED = 604,
    PRIMARY = 605,
    PRIOR = 606,
    PRIVILEGES = 607,
    PROCEDURAL = 608,
    PROCEDURE = 609,
    QUOTE = 610,
    RANGE = 611,
    READ = 612,
    REAL = 613,
    REASSIGN = 614,
    RECHECK = 615,
    RECURSIVE = 616,
    REF = 617,
    REFERENCES = 618,
    REINDEX = 619,
    RELATIVE_P = 620,
    RELEASE = 621,
    RENAME = 622,
    REPEATABLE = 623,
    REPLACE = 624,
    REPLICA = 625,
    RESET = 626,
    RESTART = 627,
    RESTRICT = 628,
    RETURNING = 629,
    RETURNS = 630,
    REVOKE = 631,
    RIGHT = 632,
    ROLE = 633,
    ROLLBACK = 634,
    ROW = 635,
    ROWS = 636,
    RULE = 637,
    SAVEPOINT = 638,
    SCHEMA = 639,
    SCROLL = 640,
    SEARCH = 641,
    SECOND_P = 642,
    SECURITY = 643,
    SELECT = 644,
    SEQUENCE = 645,
    SEQUENCES = 646,
    SERIALIZABLE = 647,
    SERVER = 648,
    SESSION = 649,
    SESSION_USER = 650,
    SET = 651,
    SETOF = 652,
    SHARE = 653,
    SHOW = 654,
    SIMILAR = 655,
    SIMPLE = 656,
    SMALLINT = 657,
    SNAPSHOT = 658,
    SOME = 659,
    STABLE = 660,
    STANDALONE_P = 661,
    START = 662,
    STATEMENT = 663,
    STATISTICS = 664,
    STDIN = 665,
    STDOUT = 666,
    STORAGE = 667,
    STRICT_P = 668,
    STRIP_P = 669,
    SUBSTRING = 670,
    SYMMETRIC = 671,
    SYSID = 672,
    SYSTEM_P = 673,
    TABLE = 674,
    TABLES = 675,
    TABLESPACE = 676,
    TEMP = 677,
    TEMPLATE = 678,
    TEMPORARY = 679,
    TEXT_P = 680,
    THEN = 681,
    TIME = 682,
    TIMESTAMP = 683,
    TO = 684,
    TRAILING = 685,
    TRANSACTION = 686,
    TREAT = 687,
    TRIGGER = 688,
    TRIM = 689,
    TRUE_P = 690,
    TRUNCATE = 691,
    TRUSTED = 692,
    TYPE_P = 693,
    TYPES_P = 694,
    UNBOUNDED = 695,
    UNCOMMITTED = 696,
    UNENCRYPTED = 697,
    UNION = 698,
    UNIQUE = 699,
    UNKNOWN = 700,
    UNLISTEN = 701,
    UNLOGGED = 702,
    UNTIL = 703,
    UPDATE = 704,
    USER = 705,
    USING = 706,
    VACUUM = 707,
    VALID = 708,
    VALIDATE = 709,
    VALIDATOR = 710,
    VALUE_P = 711,
    VALUES = 712,
    VARCHAR = 713,
    VARIADIC = 714,
    VARYING = 715,
    VERBOSE = 716,
    VERSION_P = 717,
    VIEW = 718,
    VOLATILE = 719,
    WHEN = 720,
    WHERE = 721,
    WHITESPACE_P = 722,
    WINDOW = 723,
    WITH = 724,
    WITHOUT = 725,
    WORK = 726,
    WRAPPER = 727,
    WRITE = 728,
    XML_P = 729,
    XMLATTRIBUTES = 730,
    XMLCONCAT = 731,
    XMLELEMENT = 732,
    XMLEXISTS = 733,
    XMLFOREST = 734,
    XMLPARSE = 735,
    XMLPI = 736,
    XMLROOT = 737,
    XMLSERIALIZE = 738,
    YEAR_P = 739,
    YES_P = 740,
    ZONE = 741,
    NULLS_FIRST = 742,
    NULLS_LAST = 743,
    WITH_TIME = 744,
    POSTFIXOP = 745,
    UMINUS = 746
  };
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union YYSTYPE YYSTYPE;
union YYSTYPE
{
#line 564 "preproc.y" /* yacc.c:355  */

	double	dval;
	char	*str;
	int		ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;

#line 1177 "preproc.c" /* yacc.c:355  */
};
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE YYLTYPE;
struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


extern YYSTYPE base_yylval;
extern YYLTYPE base_yylloc;
int base_yyparse (void);

#endif /* !YY_BASE_YY_PREPROC_H_INCLUDED  */

/* Copy the second part of user declarations.  */

#line 1206 "preproc.c" /* yacc.c:358  */

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef YY_ATTRIBUTE
# if (defined __GNUC__                                               \
      && (2 < __GNUC__ || (__GNUC__ == 2 && 96 <= __GNUC_MINOR__)))  \
     || defined __SUNPRO_C && 0x5110 <= __SUNPRO_C
#  define YY_ATTRIBUTE(Spec) __attribute__(Spec)
# else
#  define YY_ATTRIBUTE(Spec) /* empty */
# endif
#endif

#ifndef YY_ATTRIBUTE_PURE
# define YY_ATTRIBUTE_PURE   YY_ATTRIBUTE ((__pure__))
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# define YY_ATTRIBUTE_UNUSED YY_ATTRIBUTE ((__unused__))
#endif

#if !defined _Noreturn \
     && (!defined __STDC_VERSION__ || __STDC_VERSION__ < 201112)
# if defined _MSC_VER && 1200 <= _MSC_VER
#  define _Noreturn __declspec (noreturn)
# else
#  define _Noreturn YY_ATTRIBUTE ((__noreturn__))
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN \
    _Pragma ("GCC diagnostic push") \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")\
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif


#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYSIZE_T yynewbytes;                                            \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / sizeof (*yyptr);                          \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, (Count) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYSIZE_T yyi;                         \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   106643

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  511
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  688
/* YYNRULES -- Number of rules.  */
#define YYNRULES  2736
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  4954

/* YYTRANSLATE[YYX] -- Symbol number corresponding to YYX as returned
   by yylex, with out-of-bounds checking.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   746

#define YYTRANSLATE(YYX)                                                \
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, without out-of-bounds checking.  */
static const yytype_uint16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   498,     2,     2,
     503,   504,   496,   494,   506,   495,   505,   497,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   508,   507,
     491,   490,   492,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   501,     2,   502,   499,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   509,     2,   510,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   493,   500
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_uint16 yyrline[] =
{
       0,  1466,  1466,  1469,  1471,  1473,  1475,  1477,  1479,  1481,
    1483,  1485,  1487,  1489,  1491,  1493,  1495,  1497,  1499,  1501,
    1503,  1505,  1507,  1509,  1511,  1513,  1515,  1517,  1519,  1521,
    1539,  1541,  1543,  1545,  1547,  1549,  1551,  1553,  1555,  1557,
    1559,  1561,  1563,  1565,  1567,  1569,  1571,  1573,  1575,  1577,
    1579,  1581,  1583,  1585,  1587,  1589,  1591,  1593,  1595,  1599,
    1601,  1603,  1605,  1607,  1609,  1611,  1613,  1615,  1617,  1619,
    1621,  1623,  1625,  1627,  1629,  1631,  1633,  1635,  1637,  1639,
    1641,  1643,  1645,  1647,  1649,  1651,  1653,  1655,  1657,  1659,
    1661,  1663,  1665,  1672,  1674,  1676,  1678,  1680,  1682,  1684,
    1686,  1688,  1690,  1692,  1694,  1700,  1702,  1704,  1706,  1708,
    1710,  1712,  1714,  1716,  1722,  1732,  1736,  1742,  1746,  1756,
    1766,  1767,  1781,  1788,  1794,  1805,  1811,  1820,  1827,  1833,
    1842,  1849,  1857,  1862,  1870,  1875,  1881,  1886,  1892,  1897,
    1903,  1907,  1911,  1915,  1919,  1923,  1927,  1931,  1935,  1943,
    1947,  1951,  1955,  1959,  1963,  1971,  1979,  1988,  1990,  1998,
    2006,  2014,  2022,  2026,  2034,  2038,  2046,  2054,  2062,  2066,
    2074,  2078,  2086,  2090,  2098,  2103,  2109,  2114,  2120,  2124,
    2128,  2132,  2136,  2140,  2148,  2152,  2156,  2164,  2168,  2172,
    2180,  2184,  2188,  2192,  2196,  2200,  2204,  2209,  2213,  2217,
    2221,  2225,  2229,  2233,  2241,  2245,  2253,  2257,  2265,  2269,
    2283,  2287,  2291,  2295,  2303,  2307,  2311,  2315,  2323,  2327,
    2331,  2335,  2339,  2343,  2347,  2355,  2359,  2364,  2370,  2374,
    2382,  2386,  2390,  2394,  2398,  2406,  2410,  2418,  2422,  2430,
    2434,  2438,  2442,  2446,  2455,  2463,  2467,  2475,  2479,  2487,
    2495,  2499,  2503,  2507,  2515,  2519,  2523,  2527,  2531,  2535,
    2539,  2543,  2551,  2555,  2563,  2567,  2571,  2575,  2579,  2583,
    2587,  2591,  2595,  2599,  2603,  2607,  2611,  2615,  2619,  2623,
    2627,  2631,  2635,  2639,  2643,  2647,  2651,  2655,  2659,  2663,
    2667,  2671,  2675,  2679,  2683,  2687,  2691,  2695,  2699,  2703,
    2707,  2711,  2715,  2719,  2723,  2727,  2735,  2739,  2747,  2751,
    2756,  2762,  2767,  2773,  2778,  2784,  2792,  2797,  2803,  2807,
    2815,  2819,  2823,  2827,  2835,  2843,  2847,  2855,  2859,  2863,
    2867,  2875,  2880,  2888,  2899,  2910,  2914,  2922,  2926,  2930,
    2938,  2942,  2950,  2955,  2961,  2965,  2969,  2973,  2977,  2981,
    2985,  2989,  2993,  2997,  3001,  3005,  3013,  3018,  3024,  3029,
    3035,  3040,  3046,  3051,  3057,  3061,  3069,  3077,  3081,  3085,
    3089,  3094,  3100,  3104,  3112,  3120,  3124,  3128,  3132,  3140,
    3144,  3148,  3152,  3156,  3160,  3164,  3169,  3175,  3180,  3186,
    3191,  3197,  3201,  3209,  3213,  3221,  3225,  3229,  3237,  3241,
    3249,  3257,  3265,  3270,  3276,  3280,  3284,  3288,  3296,  3300,
    3304,  3308,  3312,  3316,  3320,  3328,  3332,  3336,  3340,  3348,
    3356,  3360,  3365,  3371,  3375,  3379,  3383,  3387,  3391,  3399,
    3403,  3411,  3415,  3419,  3423,  3427,  3431,  3435,  3443,  3448,
    3454,  3459,  3465,  3469,  3477,  3485,  3489,  3494,  3499,  3505,
    3509,  3517,  3521,  3529,  3534,  3540,  3544,  3548,  3552,  3557,
    3563,  3571,  3579,  3583,  3587,  3591,  3595,  3603,  3608,  3614,
    3618,  3622,  3627,  3633,  3637,  3641,  3646,  3652,  3657,  3663,
    3668,  3674,  3682,  3690,  3694,  3699,  3705,  3713,  3717,  3725,
    3730,  3736,  3740,  3748,  3752,  3756,  3760,  3764,  3768,  3772,
    3776,  3780,  3784,  3788,  3792,  3800,  3805,  3811,  3815,  3819,
    3823,  3831,  3835,  3843,  3847,  3855,  3860,  3866,  3870,  3878,
    3883,  3889,  3893,  3901,  3906,  3912,  3916,  3924,  3929,  3935,
    3943,  3948,  3954,  3958,  3966,  3970,  3978,  3983,  3989,  3993,
    3997,  4005,  4013,  4018,  4024,  4032,  4036,  4040,  4044,  4048,
    4052,  4056,  4060,  4064,  4068,  4072,  4076,  4080,  4084,  4088,
    4092,  4096,  4100,  4104,  4108,  4112,  4116,  4124,  4132,  4136,
    4140,  4144,  4152,  4156,  4164,  4169,  4175,  4179,  4187,  4191,
    4199,  4204,  4210,  4214,  4222,  4230,  4234,  4242,  4246,  4250,
    4254,  4262,  4270,  4278,  4286,  4294,  4299,  4305,  4309,  4317,
    4322,  4328,  4332,  4340,  4344,  4348,  4356,  4360,  4368,  4372,
    4380,  4384,  4392,  4400,  4404,  4412,  4420,  4424,  4428,  4436,
    4440,  4448,  4456,  4460,  4468,  4472,  4476,  4484,  4488,  4496,
    4500,  4504,  4508,  4512,  4520,  4525,  4531,  4536,  4542,  4546,
    4554,  4559,  4565,  4569,  4574,  4580,  4584,  4588,  4592,  4600,
    4605,  4612,  4614,  4622,  4626,  4630,  4634,  4638,  4642,  4650,
    4654,  4662,  4671,  4680,  4684,  4688,  4692,  4696,  4700,  4704,
    4708,  4712,  4716,  4720,  4724,  4728,  4732,  4740,  4748,  4752,
    4760,  4764,  4772,  4776,  4780,  4784,  4788,  4796,  4800,  4808,
    4816,  4820,  4828,  4836,  4841,  4847,  4851,  4859,  4863,  4867,
    4875,  4883,  4887,  4895,  4899,  4903,  4907,  4911,  4919,  4924,
    4930,  4935,  4941,  4945,  4950,  4956,  4962,  4968,  4976,  4980,
    4988,  4992,  5000,  5004,  5012,  5016,  5024,  5028,  5036,  5044,
    5052,  5056,  5060,  5064,  5072,  5076,  5080,  5084,  5088,  5092,
    5096,  5100,  5104,  5108,  5112,  5116,  5120,  5124,  5128,  5136,
    5140,  5148,  5152,  5160,  5164,  5172,  5180,  5184,  5189,  5195,
    5199,  5203,  5207,  5211,  5215,  5219,  5223,  5227,  5231,  5235,
    5239,  5243,  5247,  5251,  5255,  5259,  5267,  5271,  5275,  5279,
    5283,  5287,  5291,  5295,  5299,  5303,  5307,  5311,  5315,  5319,
    5323,  5327,  5331,  5339,  5343,  5351,  5355,  5359,  5363,  5367,
    5375,  5380,  5386,  5390,  5394,  5398,  5402,  5406,  5410,  5414,
    5418,  5422,  5426,  5434,  5438,  5446,  5450,  5454,  5458,  5464,
    5470,  5476,  5482,  5488,  5494,  5500,  5510,  5521,  5532,  5543,
    5554,  5565,  5576,  5592,  5608,  5624,  5635,  5651,  5662,  5678,
    5693,  5697,  5705,  5710,  5716,  5724,  5728,  5736,  5740,  5744,
    5748,  5752,  5760,  5764,  5772,  5776,  5780,  5784,  5792,  5796,
    5800,  5804,  5808,  5812,  5816,  5820,  5824,  5828,  5832,  5836,
    5840,  5844,  5848,  5852,  5860,  5864,  5872,  5876,  5884,  5889,
    5895,  5899,  5907,  5915,  5923,  5927,  5935,  5940,  5946,  5951,
    5957,  5965,  5970,  5976,  5980,  5984,  5992,  5996,  6000,  6008,
    6012,  6016,  6020,  6028,  6036,  6041,  6047,  6052,  6058,  6063,
    6069,  6074,  6080,  6084,  6092,  6096,  6100,  6108,  6113,  6119,
    6123,  6128,  6134,  6138,  6143,  6149,  6153,  6158,  6164,  6168,
    6172,  6180,  6185,  6191,  6195,  6203,  6207,  6215,  6219,  6227,
    6231,  6239,  6243,  6247,  6251,  6255,  6263,  6267,  6271,  6275,
    6279,  6287,  6295,  6303,  6307,  6311,  6319,  6323,  6327,  6335,
    6339,  6347,  6351,  6355,  6359,  6363,  6367,  6371,  6375,  6379,
    6383,  6387,  6391,  6395,  6399,  6403,  6411,  6415,  6419,  6423,
    6431,  6435,  6443,  6448,  6454,  6462,  6466,  6474,  6482,  6486,
    6494,  6499,  6505,  6509,  6517,  6521,  6529,  6533,  6541,  6545,
    6549,  6553,  6561,  6565,  6573,  6581,  6585,  6593,  6597,  6605,
    6609,  6613,  6621,  6625,  6630,  6636,  6644,  6649,  6655,  6659,
    6663,  6671,  6675,  6683,  6688,  6694,  6698,  6702,  6706,  6710,
    6714,  6718,  6722,  6726,  6730,  6734,  6738,  6742,  6746,  6750,
    6754,  6758,  6762,  6766,  6770,  6774,  6778,  6782,  6786,  6790,
    6794,  6798,  6802,  6806,  6810,  6814,  6818,  6822,  6826,  6830,
    6834,  6838,  6842,  6846,  6850,  6854,  6862,  6867,  6873,  6878,
    6884,  6888,  6892,  6896,  6900,  6904,  6908,  6912,  6916,  6920,
    6924,  6928,  6932,  6936,  6940,  6944,  6948,  6952,  6956,  6960,
    6964,  6968,  6976,  6980,  6984,  6988,  6992,  6996,  7000,  7004,
    7008,  7012,  7016,  7020,  7024,  7028,  7032,  7036,  7040,  7044,
    7052,  7060,  7064,  7068,  7076,  7080,  7088,  7092,  7096,  7100,
    7104,  7112,  7117,  7123,  7127,  7131,  7135,  7143,  7147,  7152,
    7158,  7162,  7170,  7178,  7183,  7189,  7197,  7201,  7209,  7213,
    7217,  7221,  7225,  7229,  7233,  7237,  7241,  7245,  7249,  7253,
    7257,  7261,  7269,  7273,  7278,  7284,  7288,  7292,  7296,  7300,
    7308,  7312,  7316,  7324,  7329,  7335,  7339,  7347,  7352,  7357,
    7363,  7369,  7377,  7385,  7390,  7396,  7400,  7404,  7408,  7412,
    7416,  7420,  7424,  7428,  7432,  7436,  7440,  7444,  7448,  7452,
    7456,  7464,  7469,  7475,  7479,  7487,  7495,  7500,  7506,  7514,
    7518,  7526,  7534,  7538,  7542,  7546,  7550,  7554,  7558,  7566,
    7571,  7577,  7585,  7589,  7593,  7597,  7601,  7605,  7613,  7621,
    7625,  7629,  7637,  7642,  7648,  7652,  7656,  7660,  7664,  7672,
    7676,  7684,  7688,  7692,  7696,  7704,  7708,  7716,  7720,  7728,
    7733,  7739,  7744,  7750,  7755,  7761,  7766,  7772,  7776,  7780,
    7784,  7792,  7796,  7800,  7804,  7808,  7812,  7816,  7824,  7828,
    7836,  7844,  7848,  7856,  7860,  7865,  7871,  7877,  7887,  7892,
    7898,  7902,  7906,  7910,  7918,  7920,  7928,  7933,  7939,  7947,
    7951,  7955,  7963,  7967,  7975,  7983,  7988,  7994,  8002,  8007,
    8013,  8021,  8026,  8032,  8036,  8040,  8044,  8048,  8052,  8056,
    8060,  8068,  8073,  8079,  8087,  8091,  8099,  8103,  8111,  8119,
    8127,  8135,  8139,  8147,  8200,  8204,  8217,  8219,  8223,  8227,
    8231,  8240,  8246,  8250,  8258,  8262,  8270,  8274,  8282,  8286,
    8290,  8294,  8298,  8302,  8306,  8310,  8318,  8322,  8330,  8334,
    8338,  8342,  8346,  8350,  8358,  8362,  8370,  8374,  8382,  8390,
    8395,  8401,  8406,  8408,  8414,  8418,  8422,  8426,  8430,  8434,
    8438,  8442,  8446,  8454,  8459,  8465,  8469,  8474,  8480,  8484,
    8488,  8493,  8499,  8504,  8510,  8518,  8522,  8530,  8534,  8542,
    8546,  8550,  8554,  8562,  8567,  8573,  8577,  8582,  8590,  8594,
    8602,  8606,  8614,  8622,  8626,  8631,  8637,  8645,  8649,  8657,
    8661,  8669,  8674,  8680,  8685,  8691,  8695,  8703,  8708,  8714,
    8718,  8726,  8730,  8738,  8743,  8749,  8753,  8761,  8766,  8772,
    8776,  8784,  8788,  8792,  8796,  8800,  8804,  8808,  8812,  8818,
    8822,  8826,  8834,  8838,  8842,  8846,  8850,  8854,  8862,  8866,
    8870,  8874,  8882,  8886,  8890,  8894,  8902,  8907,  8913,  8917,
    8925,  8929,  8933,  8937,  8945,  8949,  8957,  8961,  8965,  8973,
    8981,  8986,  8992,  8996,  9002,  9008,  9013,  9019,  9023,  9031,
    9039,  9041,  9043,  9047,  9051,  9055,  9063,  9073,  9084,  9093,
    9097,  9101,  9105,  9109,  9113,  9117,  9125,  9129,  9133,  9137,
    9145,  9149,  9157,  9162,  9168,  9172,  9176,  9180,  9184,  9188,
    9192,  9196,  9200,  9204,  9208,  9216,  9221,  9227,  9231,  9239,
    9243,  9251,  9259,  9267,  9271,  9279,  9283,  9291,  9299,  9307,
    9311,  9315,  9319,  9323,  9327,  9335,  9340,  9346,  9351,  9357,
    9361,  9365,  9369,  9377,  9385,  9389,  9394,  9400,  9404,  9408,
    9412,  9416,  9420,  9424,  9428,  9432,  9436,  9440,  9444,  9448,
    9453,  9459,  9463,  9471,  9475,  9479,  9483,  9487,  9491,  9495,
    9499,  9503,  9507,  9511,  9515,  9519,  9523,  9527,  9531,  9535,
    9539,  9543,  9547,  9551,  9555,  9559,  9563,  9567,  9571,  9575,
    9579,  9583,  9587,  9591,  9595,  9599,  9603,  9607,  9611,  9615,
    9619,  9623,  9627,  9631,  9635,  9639,  9643,  9647,  9651,  9655,
    9659,  9663,  9667,  9671,  9675,  9679,  9683,  9687,  9691,  9695,
    9700,  9704,  9712,  9716,  9720,  9724,  9728,  9732,  9736,  9740,
    9744,  9748,  9752,  9756,  9760,  9764,  9768,  9772,  9776,  9780,
    9784,  9788,  9792,  9796,  9804,  9808,  9812,  9816,  9820,  9824,
    9828,  9832,  9836,  9840,  9844,  9848,  9856,  9860,  9864,  9868,
    9872,  9876,  9880,  9884,  9888,  9892,  9896,  9900,  9904,  9908,
    9912,  9916,  9920,  9924,  9928,  9932,  9936,  9940,  9944,  9948,
    9952,  9956,  9960,  9964,  9968,  9972,  9976,  9980,  9984,  9988,
    9992,  9996, 10000, 10004, 10008, 10012, 10016, 10020, 10024, 10028,
   10032, 10036, 10040, 10044, 10048, 10052, 10060, 10064, 10072, 10076,
   10080, 10085, 10091, 10099, 10103, 10111, 10115, 10123, 10127, 10135,
   10139, 10144, 10150, 10154, 10158, 10162, 10170, 10175, 10181, 10185,
   10193, 10201, 10205, 10210, 10216, 10224, 10228, 10235, 10240, 10246,
   10251, 10256, 10262, 10266, 10274, 10278, 10282, 10286, 10290, 10298,
   10302, 10306, 10314, 10318, 10322, 10330, 10334, 10342, 10346, 10350,
   10354, 10358, 10362, 10366, 10370, 10374, 10382, 10386, 10394, 10398,
   10406, 10410, 10414, 10418, 10422, 10426, 10434, 10438, 10446, 10450,
   10458, 10462, 10470, 10474, 10482, 10486, 10490, 10498, 10502, 10510,
   10515, 10521, 10525, 10529, 10533, 10537, 10541, 10545, 10549, 10557,
   10561, 10569, 10577, 10582, 10588, 10592, 10596, 10600, 10604, 10609,
   10615, 10623, 10631, 10635, 10639, 10647, 10651, 10659, 10667, 10671,
   10679, 10687, 10692, 10698, 10703, 10709, 10713, 10721, 10725, 10729,
   10733, 10741, 10745, 10754, 10756, 10764, 10769, 10775, 10779, 10787,
   10791, 10799, 10807, 10811, 10819, 10823, 10827, 10831, 10839, 10843,
   10851, 10855, 10863, 10867, 10875, 10883, 10891, 10899, 10907, 10915,
   10923, 10927, 10935, 10939, 10943, 10947, 10951, 10955, 10959, 10963,
   10967, 10971, 10975, 10979, 10983, 10987, 10988, 10993, 10999, 11007,
   11011, 11019, 11023, 11024, 11028, 11036, 11040, 11044, 11048, 11056,
   11060, 11064, 11068, 11072, 11076, 11080, 11084, 11088, 11092, 11096,
   11100, 11104, 11108, 11112, 11116, 11120, 11124, 11128, 11132, 11136,
   11140, 11144, 11148, 11152, 11156, 11160, 11164, 11168, 11172, 11176,
   11180, 11184, 11188, 11192, 11196, 11200, 11204, 11208, 11212, 11216,
   11220, 11224, 11228, 11232, 11236, 11240, 11244, 11248, 11252, 11256,
   11260, 11264, 11268, 11272, 11276, 11280, 11284, 11288, 11292, 11296,
   11300, 11304, 11308, 11312, 11316, 11320, 11324, 11328, 11332, 11336,
   11340, 11344, 11348, 11352, 11356, 11360, 11364, 11368, 11372, 11376,
   11380, 11384, 11388, 11392, 11396, 11400, 11404, 11408, 11412, 11416,
   11420, 11424, 11428, 11432, 11436, 11440, 11444, 11448, 11452, 11456,
   11460, 11464, 11468, 11472, 11476, 11480, 11484, 11488, 11492, 11496,
   11500, 11504, 11508, 11512, 11516, 11520, 11524, 11528, 11532, 11536,
   11540, 11544, 11548, 11552, 11556, 11560, 11564, 11568, 11572, 11576,
   11580, 11584, 11588, 11592, 11596, 11600, 11604, 11608, 11612, 11616,
   11620, 11624, 11628, 11632, 11636, 11640, 11644, 11648, 11652, 11656,
   11660, 11664, 11668, 11672, 11676, 11680, 11684, 11688, 11692, 11696,
   11700, 11704, 11708, 11712, 11716, 11720, 11724, 11728, 11732, 11736,
   11740, 11744, 11748, 11752, 11756, 11760, 11764, 11768, 11772, 11776,
   11780, 11784, 11788, 11792, 11796, 11800, 11804, 11808, 11812, 11816,
   11820, 11824, 11828, 11832, 11836, 11840, 11844, 11848, 11852, 11856,
   11860, 11864, 11868, 11872, 11876, 11880, 11884, 11888, 11892, 11896,
   11900, 11904, 11908, 11912, 11916, 11920, 11924, 11928, 11932, 11936,
   11940, 11944, 11948, 11952, 11956, 11960, 11964, 11968, 11972, 11976,
   11980, 11984, 11988, 11992, 11996, 12000, 12004, 12008, 12012, 12016,
   12024, 12028, 12032, 12036, 12040, 12044, 12048, 12052, 12056, 12060,
   12064, 12068, 12072, 12076, 12080, 12084, 12088, 12092, 12096, 12100,
   12104, 12108, 12112, 12116, 12120, 12124, 12128, 12132, 12136, 12140,
   12144, 12148, 12152, 12156, 12160, 12164, 12168, 12172, 12176, 12180,
   12184, 12188, 12192, 12196, 12204, 12208, 12212, 12216, 12220, 12224,
   12228, 12232, 12236, 12240, 12244, 12248, 12252, 12256, 12260, 12264,
   12268, 12272, 12276, 12280, 12284, 12288, 12292, 12300, 12304, 12308,
   12312, 12316, 12320, 12324, 12328, 12332, 12336, 12340, 12344, 12348,
   12352, 12356, 12360, 12364, 12368, 12372, 12376, 12380, 12384, 12388,
   12392, 12396, 12400, 12404, 12408, 12412, 12416, 12420, 12424, 12428,
   12432, 12436, 12440, 12444, 12448, 12452, 12456, 12460, 12464, 12468,
   12472, 12476, 12480, 12484, 12488, 12492, 12496, 12500, 12504, 12508,
   12512, 12516, 12520, 12524, 12528, 12532, 12536, 12540, 12544, 12548,
   12552, 12556, 12560, 12564, 12568, 12572, 12576, 12580, 12584, 12588,
   12592, 12602, 12603, 12606, 12607, 12608, 12614, 12615, 12616, 12617,
   12618, 12631, 12631, 12640, 12655, 12657, 12660, 12662, 12666, 12678,
   12694, 12698, 12709, 12710, 12713, 12725, 12734, 12735, 12738, 12739,
   12740, 12743, 12744, 12747, 12748, 12751, 12752, 12755, 12757, 12759,
   12761, 12765, 12772, 12779, 12795, 12829, 12839, 12842, 12846, 12859,
   12860, 12862, 12864, 12868, 12882, 12889, 12950, 12959, 12961, 12962,
   12965, 12967, 12968, 12971, 12972, 12973, 12974, 12975, 12982, 12981,
   12991, 12993, 12995, 12996, 12999, 13000, 13001, 13002, 13005, 13006,
   13010, 13009, 13026, 13024, 13040, 13039, 13053, 13059, 13060, 13063,
   13065, 13066, 13069, 13070, 13071, 13072, 13075, 13076, 13079, 13087,
   13104, 13112, 13135, 13241, 13275, 13277, 13279, 13283, 13287, 13286,
   13337, 13339, 13338, 13353, 13359, 13366, 13371, 13377, 13378, 13381,
   13382, 13383, 13384, 13385, 13386, 13387, 13395, 13403, 13406, 13407,
   13408, 13409, 13410, 13411, 13419, 13427, 13428, 13429, 13432, 13433,
   13436, 13438, 13447, 13535, 13536, 13543, 13544, 13545, 13551, 13560,
   13563, 13564, 13565, 13566, 13569, 13570, 13571, 13574, 13576, 13584,
   13585, 13591, 13599, 13600, 13603, 13604, 13607, 13612, 13619, 13624,
   13631, 13638, 13638, 13640, 13647, 13648, 13651, 13652, 13653, 13654,
   13655, 13656, 13657, 13658, 13659, 13665, 13672, 13684, 13690, 13697,
   13705, 13706, 13718, 13729, 13740, 13744, 13745, 13748, 13753, 13757,
   13758, 13761, 13767, 13775, 13781, 13788, 13792, 13793, 13796, 13799,
   13803, 13804, 13807, 13813, 13822, 13827, 13837, 13847, 13859, 13860,
   13861, 13862, 13863, 13864, 13865, 13866, 13867, 13868, 13869, 13870,
   13871, 13872, 13873, 13880, 13881, 13884, 13885, 13892, 13893, 13894,
   13901, 13900, 13917, 13918, 13925, 13924, 13994, 14000, 14006, 14014,
   14020, 14026, 14032, 14038, 14044, 14050, 14056, 14062, 14073, 14074,
   14077, 14078, 14079, 14080, 14081, 14082, 14083, 14084, 14085, 14086,
   14087, 14088, 14089, 14090, 14091, 14092, 14093, 14094, 14095, 14096,
   14097, 14098, 14099, 14100, 14103, 14104, 14105, 14106, 14107, 14108,
   14112, 14113, 14114, 14115, 14116, 14117, 14118, 14121, 14124, 14125,
   14126, 14127, 14128, 14129, 14130, 14131, 14144, 14145, 14146, 14147,
   14148, 14149, 14150, 14155, 14156, 14157, 14158, 14159, 14160, 14166,
   14167, 14168, 14169, 14170, 14171, 14172, 14173, 14174, 14175, 14176,
   14179, 14180, 14181, 14182, 14183, 14186, 14187, 14188, 14189, 14192,
   14193, 14194, 14195, 14196, 14197, 14198, 14215, 14216, 14217, 14220,
   14221, 14222, 14223, 14224, 14225, 14229, 14229, 14232, 14238, 14239,
   14242, 14244, 14249, 14259, 14270, 14277, 14278, 14279, 14282, 14315,
   14317, 14319, 14322, 14332, 14342, 14352, 14353, 14356, 14358, 14359,
   14360, 14363, 14365, 14373, 14374, 14375, 14379, 14380, 14384, 14385,
   14388, 14389, 14392, 14393, 14394, 14395, 14396, 14399, 14400, 14401,
   14402, 14403, 14404, 14405, 14406, 14407, 14408, 14409, 14410, 14411,
   14412, 14413, 14414, 14415, 14416, 14417, 14418, 14419, 14420, 14421,
   14422, 14423, 14424, 14425, 14426, 14427, 14428, 14429, 14430, 14431,
   14432, 14433, 14434, 14435, 14436, 14437, 14438, 14439, 14440, 14441,
   14442, 14443, 14444, 14445, 14446, 14447, 14448, 14449, 14450, 14451,
   14452, 14453, 14454, 14457, 14458, 14459, 14460, 14463, 14464, 14465,
   14466, 14467, 14468, 14469, 14470, 14471, 14474, 14475, 14476, 14477,
   14478, 14481, 14482, 14485, 14486, 14497, 14498
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || 0
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT",
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT",
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE",
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR",
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO",
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER",
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", "SQL_OPEN",
  "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH",
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT",
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT",
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED",
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO",
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN",
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL",
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB",
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP",
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST",
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST",
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION",
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", "ALWAYS",
  "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "ASSERTION",
  "ASSIGNMENT", "ASYMMETRIC", "AT", "ATTRIBUTE", "AUTHORIZATION",
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT",
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED",
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER",
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER",
  "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMENT", "COMMENTS",
  "COMMIT", "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION",
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P",
  "COPY", "COST", "CREATE", "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG",
  "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME",
  "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P",
  "DATABASE", "DAY_P", "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE",
  "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P",
  "DELIMITER", "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD",
  "DISTINCT", "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH",
  "ELSE", "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE",
  "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE", "EXISTS",
  "EXPLAIN", "EXTENSION", "EXTERNAL", "EXTRACT", "FALSE_P", "FAMILY",
  "FETCH", "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", "FOREIGN",
  "FORWARD", "FREEZE", "FROM", "FULL", "FUNCTION", "FUNCTIONS", "GLOBAL",
  "GRANT", "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING",
  "HEADER_P", "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE",
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX",
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P",
  "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P",
  "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL",
  "ISOLATION", "JOIN", "KEY", "LABEL", "LANGUAGE", "LARGE_P", "LAST_P",
  "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAKPROOF", "LEAST", "LEFT",
  "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME",
  "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "MAPPING", "MATCH", "MAXVALUE",
  "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAME_P", "NAMES",
  "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NONE", "NOT", "NOTHING",
  "NOTIFY", "NOTNULL", "NOWAIT", "NULL_P", "NULLIF", "NULLS_P", "NUMERIC",
  "OBJECT_P", "OF", "OFF", "OFFSET", "OIDS", "ON", "ONLY", "OPERATOR",
  "OPTION", "OPTIONS", "OR", "ORDER", "OUT_P", "OUTER_P", "OVER",
  "OVERLAPS", "OVERLAY", "OWNED", "OWNER", "PARSER", "PARTIAL",
  "PARTITION", "PASSING", "PASSWORD", "PLACING", "PLANS", "POSITION",
  "PRECEDING", "PRECISION", "PRESERVE", "PREPARE", "PREPARED", "PRIMARY",
  "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "QUOTE", "RANGE",
  "READ", "REAL", "REASSIGN", "RECHECK", "RECURSIVE", "REF", "REFERENCES",
  "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", "REPEATABLE", "REPLACE",
  "REPLICA", "RESET", "RESTART", "RESTRICT", "RETURNING", "RETURNS",
  "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW", "ROWS", "RULE",
  "SAVEPOINT", "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", "SECURITY",
  "SELECT", "SEQUENCE", "SEQUENCES", "SERIALIZABLE", "SERVER", "SESSION",
  "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE",
  "SMALLINT", "SNAPSHOT", "SOME", "STABLE", "STANDALONE_P", "START",
  "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P",
  "STRIP_P", "SUBSTRING", "SYMMETRIC", "SYSID", "SYSTEM_P", "TABLE",
  "TABLES", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", "TEXT_P",
  "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRANSACTION", "TREAT",
  "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", "TYPES_P",
  "UNBOUNDED", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN",
  "UNLISTEN", "UNLOGGED", "UNTIL", "UPDATE", "USER", "USING", "VACUUM",
  "VALID", "VALIDATE", "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR",
  "VARIADIC", "VARYING", "VERBOSE", "VERSION_P", "VIEW", "VOLATILE",
  "WHEN", "WHERE", "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT", "WORK",
  "WRAPPER", "WRITE", "XML_P", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT",
  "XMLEXISTS", "XMLFOREST", "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE",
  "YEAR_P", "YES_P", "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_TIME",
  "'='", "'<'", "'>'", "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'",
  "'^'", "UMINUS", "'['", "']'", "'('", "')'", "'.'", "','", "';'", "':'",
  "'{'", "'}'", "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with",
  "OptRoleList", "AlterOptRoleList", "AlterOptRoleElem",
  "CreateOptRoleElem", "CreateUserStmt", "AlterRoleStmt",
  "opt_in_database", "AlterRoleSetStmt", "AlterUserStmt",
  "AlterUserSetStmt", "DropRoleStmt", "DropUserStmt", "CreateGroupStmt",
  "AlterGroupStmt", "add_drop", "DropGroupStmt", "CreateSchemaStmt",
  "OptSchemaName", "OptSchemaEltList", "schema_stmt", "VariableSetStmt",
  "set_rest", "set_rest_more", "var_name", "var_list", "var_value",
  "iso_level", "opt_boolean_or_string", "zone_value", "opt_encoding",
  "NonReservedWord_or_Sconst", "VariableResetStmt", "SetResetClause",
  "FunctionSetResetClause", "VariableShowStmt", "ConstraintsSetStmt",
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt",
  "DiscardStmt", "AlterTableStmt", "alter_table_cmds", "alter_table_cmd",
  "alter_column_default", "opt_drop_behavior", "opt_collate_clause",
  "alter_using", "reloptions", "opt_reloptions", "reloption_list",
  "reloption_elem", "AlterCompositeTypeStmt", "alter_type_cmds",
  "alter_type_cmd", "ClosePortalStmt", "CopyStmt", "copy_from",
  "copy_file_name", "copy_options", "copy_opt_list", "copy_opt_item",
  "opt_binary", "opt_oids", "copy_delimiter", "opt_using",
  "copy_generic_opt_list", "copy_generic_opt_elem", "copy_generic_opt_arg",
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item",
  "CreateStmt", "OptTemp", "OptTableElementList",
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList",
  "TableElement", "TypedTableElement", "columnDef", "columnOptions",
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr",
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption",
  "TableConstraint", "ConstraintElem", "opt_no_inherit", "opt_column_list",
  "columnList", "columnElem", "key_match", "ExclusionConstraintList",
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions",
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith",
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", "ExistingIndex",
  "create_as_target", "opt_with_data", "CreateSeqStmt", "AlterSeqStmt",
  "OptSeqOptList", "SeqOptList", "SeqOptElem", "opt_by", "NumericOnly",
  "NumericOnly_list", "CreatePLangStmt", "opt_trusted", "handler_name",
  "opt_inline_handler", "validator_clause", "opt_validator",
  "DropPLangStmt", "opt_procedural", "CreateTableSpaceStmt",
  "OptTableSpaceOwner", "DropTableSpaceStmt", "CreateExtensionStmt",
  "create_extension_opt_list", "create_extension_opt_item",
  "AlterExtensionStmt", "alter_extension_opt_list",
  "alter_extension_opt_item", "AlterExtensionContentsStmt",
  "CreateFdwStmt", "fdw_option", "fdw_options", "opt_fdw_options",
  "DropFdwStmt", "AlterFdwStmt", "create_generic_options",
  "generic_option_list", "alter_generic_options",
  "alter_generic_option_list", "alter_generic_option_elem",
  "generic_option_elem", "generic_option_name", "generic_option_arg",
  "CreateForeignServerStmt", "opt_type", "foreign_server_version",
  "opt_foreign_server_version", "DropForeignServerStmt",
  "AlterForeignServerStmt", "CreateForeignTableStmt",
  "OptForeignTableElementList", "ForeignTableElementList",
  "ForeignTableElement", "AlterForeignTableStmt", "CreateUserMappingStmt",
  "auth_ident", "DropUserMappingStmt", "AlterUserMappingStmt",
  "CreateTrigStmt", "TriggerActionTime", "TriggerEvents",
  "TriggerOneEvent", "TriggerForSpec", "TriggerForOptEach",
  "TriggerForType", "TriggerWhen", "TriggerFuncArgs", "TriggerFuncArg",
  "OptConstrFromTable", "ConstraintAttributeSpec",
  "ConstraintAttributeElem", "DropTrigStmt", "CreateAssertStmt",
  "DropAssertStmt", "DefineStmt", "definition", "def_list", "def_elem",
  "def_arg", "aggr_args", "old_aggr_definition", "old_aggr_list",
  "old_aggr_elem", "opt_enum_val_list", "enum_val_list", "AlterEnumStmt",
  "CreateOpClassStmt", "opclass_item_list", "opclass_item", "opt_default",
  "opt_opfamily", "opclass_purpose", "opt_recheck", "CreateOpFamilyStmt",
  "AlterOpFamilyStmt", "opclass_drop_list", "opclass_drop",
  "DropOpClassStmt", "DropOpFamilyStmt", "DropOwnedStmt",
  "ReassignOwnedStmt", "DropStmt", "drop_type", "any_name_list",
  "any_name", "attrs", "TruncateStmt", "opt_restart_seqs", "CommentStmt",
  "comment_type", "comment_text", "SecLabelStmt", "opt_provider",
  "security_label_type", "security_label", "FetchStmt", "fetch_args",
  "from_in", "opt_from_in", "GrantStmt", "RevokeStmt", "privileges",
  "privilege_list", "privilege", "privilege_target", "grantee_list",
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list",
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt",
  "opt_grant_admin_option", "opt_granted_by", "AlterDefaultPrivilegesStmt",
  "DefACLOptionList", "DefACLOption", "DefACLAction",
  "defacl_privilege_target", "IndexStmt", "opt_unique", "opt_concurrently",
  "opt_index_name", "access_method_clause", "index_params", "index_elem",
  "opt_collate", "opt_class", "opt_asc_desc", "opt_nulls_order",
  "CreateFunctionStmt", "opt_or_replace", "func_args", "func_args_list",
  "func_args_with_defaults", "func_args_with_defaults_list", "func_arg",
  "arg_class", "param_name", "func_return", "func_type",
  "func_arg_with_default", "createfunc_opt_list", "common_func_opt_item",
  "createfunc_opt_item", "func_as", "opt_definition", "table_func_column",
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list",
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt",
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list",
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt",
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force",
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt",
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti",
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead",
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt",
  "UnlistenStmt", "TransactionStmt", "opt_transaction",
  "transaction_mode_item", "transaction_mode_list",
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option",
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item",
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt",
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", "CreateDomainStmt",
  "AlterDomainStmt", "opt_as", "AlterTSDictionaryStmt",
  "AlterTSConfigurationStmt", "CreateConversionStmt", "ClusterStmt",
  "cluster_index_specification", "VacuumStmt", "vacuum_option_list",
  "vacuum_option_elem", "AnalyzeStmt", "analyze_keyword", "opt_verbose",
  "opt_full", "opt_freeze", "opt_name_list", "ExplainStmt",
  "ExplainableStmt", "explain_option_list", "explain_option_elem",
  "explain_option_name", "explain_option_arg", "PrepareStmt",
  "prep_type_clause", "PreparableStmt", "ExecuteStmt",
  "execute_param_clause", "InsertStmt", "insert_rest",
  "insert_column_list", "insert_column_item", "returning_clause",
  "DeleteStmt", "using_clause", "LockStmt", "opt_lock", "lock_type",
  "opt_nowait", "UpdateStmt", "set_clause_list", "set_clause",
  "single_set_clause", "multiple_set_clause", "set_target",
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options",
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens",
  "select_clause", "simple_select", "with_clause", "cte_list",
  "common_table_expr", "opt_with_clause", "into_clause",
  "OptTempTableName", "opt_table", "opt_all", "opt_distinct",
  "opt_sort_clause", "sort_clause", "sortby_list", "sortby",
  "select_limit", "opt_select_limit", "limit_clause", "offset_clause",
  "select_limit_value", "select_offset_value",
  "opt_select_fetch_first_value", "select_offset_value2", "row_or_rows",
  "first_or_next", "group_clause", "having_clause", "for_locking_clause",
  "opt_for_locking_clause", "for_locking_items", "for_locking_item",
  "locked_rels_list", "values_clause", "from_clause", "from_list",
  "table_ref", "joined_table", "alias_clause", "join_type", "join_outer",
  "join_qual", "relation_expr", "relation_expr_list",
  "relation_expr_opt_alias", "func_table", "where_clause",
  "where_or_current_clause", "OptTableFuncElementList",
  "TableFuncElementList", "TableFuncElement", "Typename",
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType",
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit",
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter",
  "CharacterWithLength", "CharacterWithoutLength", "character",
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval",
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr",
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone",
  "xml_attributes", "xml_attribute_list", "xml_attribute_el",
  "document_or_content", "xml_whitespace_option", "xmlexists_argument",
  "window_clause", "window_definition_list", "window_definition",
  "over_clause", "window_specification", "opt_existing_window_name",
  "opt_partition_clause", "opt_frame_clause", "frame_extent",
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op",
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list",
  "func_arg_expr", "type_list", "array_expr", "array_expr_list",
  "extract_list", "extract_arg", "overlay_list", "overlay_placing",
  "position_list", "substr_list", "substr_from", "substr_for", "trim_list",
  "in_expr", "case_expr", "when_clause_list", "when_clause",
  "case_default", "case_arg", "columnref", "indirection_el", "indirection",
  "opt_indirection", "opt_asymmetric", "ctext_expr", "ctext_expr_list",
  "ctext_row", "target_list", "target_el", "qualified_name_list",
  "qualified_name", "name_list", "name", "database_name", "access_method",
  "attr_name", "index_name", "file_name", "func_name", "AexprConst",
  "Iconst", "RoleId", "role_list", "SignedIconst", "NonReservedWord",
  "unreserved_keyword", "col_name_keyword", "type_func_name_keyword",
  "reserved_keyword", "statements", "statement", "CreateAsStmt", "$@1",
  "at", "ECPGConnect", "connection_target", "opt_database_name",
  "db_prefix", "server", "opt_server", "server_name", "opt_port",
  "opt_connection_name", "opt_user", "ora_user", "user_name",
  "char_variable", "opt_options", "connect_options", "opt_opt_value",
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt",
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale",
  "ecpg_interval", "ECPGDeclaration", "$@2", "sql_startdeclare",
  "sql_enddeclare", "var_type_declarations", "vt_declarations",
  "variable_declarations", "type_declaration", "$@3", "var_declaration",
  "$@4", "$@5", "opt_bit_field", "storage_declaration", "storage_clause",
  "storage_modifier", "var_type", "enum_type", "enum_definition",
  "struct_union_type_with_symbol", "$@6", "struct_union_type", "$@7",
  "s_struct_union_symbol", "s_struct_union", "simple_type",
  "unsigned_type", "signed_type", "opt_signed", "variable_list",
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare",
  "ECPGDisconnect", "dis_name", "connection_object", "execstring",
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using",
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list",
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output",
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader",
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem",
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems",
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item",
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem",
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem",
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off",
  "ECPGSetConnection", "ECPGTypedef", "$@8", "opt_reference", "ECPGVar",
  "$@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames",
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId",
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon",
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval",
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind",
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param",
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", "ecpg_ident",
  "quoted_ident_stringvar", "c_stuff_item", "c_stuff", "c_list", "c_term",
  "c_thing", "c_anything", "DeallocateStmt", "Iresult", "execute_rest",
  "ecpg_into", "ecpg_fetch_into", "opt_ecpg_fetch_into", YY_NULLPTR
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
      61,    60,    62,   745,    43,    45,    42,    47,    37,    94,
     746,    91,    93,    40,    41,    46,    44,    59,    58,   123,
     125
};
# endif

#define YYPACT_NINF -4544

#define yypact_value_is_default(Yystate) \
  (!!((Yystate) == (-4544)))

#define YYTABLE_NINF -2578

#define yytable_value_is_error(Yytable_value) \
  (!!((Yytable_value) == (-2578)))

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const int yypact[] =
{
   -4544,   371, 16401, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, 25034, -4544,
   -4544, -4544, -4544, -4544, 95952,   387, -4544, -4544, -4544,100785,
   -4544, -4544, -4544,   248, 65649, -4544, 68535,   445, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, 71902, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, 55055,  1317, -4544,
     380, -4544, -4544, -4544, -4544, -4544, -4544, -4544,  1234, 11616,
   -4544, -4544, 69016, -4544,    67, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, 69497,   297, -4544, -4544,   623,  1189, -4544,    97,
   11477, -4544, -4544, 62282, 66611, -4544, -4544, 72383,   144,  1781,
    9241,  1234, 24550, 72864, -4544,  3578, -4544, 51646, -4544, -4544,
   -4544, 66130, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, 79598,  2811,   690, 52136, -4544, -4544,
   -4544, -4544, 79598, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, 73345, -4544,   783,   785, 80079, 80560, 63725,
   -4544,  1192, -4544, 79598,  1029,   537, 54091, -4544, 81041, -4544,
   -4544,   836, -4544, 73826, -4544, -4544, -4544, -4544,   690, -4544,
   55055, 50682,   165,   972, -4544, -4544, 81522, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544,  1591,  1114, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544,   297, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544,   592, -4544,  1215,
     748,  1791,   128,   895, -4544, -4544, -4544, 23750, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, 97386,  1495, -4544, -4544, -4544,
    1226, -4544,  1258, -4544, -4544, -4544,   285, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544,   759, -4544, -4544, -4544, -4544,  1802,
   96430, 71902, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, 61801, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544,   187, -4544, -4544, -4544, -4544, -4544, 71902, 71902, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, 71902,  1401, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544,   719,  1621, -4544, -4544,
   55055,  2195,  2195,  1936, 97386, -4544, -4544, -4544, 56019, 79598,
   79598, 79598,  1693, 79598, 79598,   234, 56019,104092, 82003,  1682,
   46259, -4544,104092, 79598, 82484, 79598, 74307, 79598,  1671, 79598,
   79598,104505, 82965,  1790, -4544,  2052,  1341, -4544, -4544, -4544,
   79598,  7452,  2811, -4544, -4544, 79598,  1669, 56019, 79598,  1657,
   79598,  1735, 79598, -4544, 79598, 83446,   256,  1248,104092,  1567,
   46753,  1836,104092, 79598, 79598, 79598, -4544, -4544,  1837, 79598,
   79598, -4544, -4544,104918,  1311,  2092,  2011,  1124, -4544, -4544,
    2188,  1806, -4544, -4544,  2214, 71902, -4544, 69978, -4544, -4544,
   -4544,  2211, -4544, -4544, -4544, -4544, -4544,102027,  1781, -4544,
   -4544, 56501, 79598,  2108, -4544, -4544, 83927, -4544, -4544,   264,
   56983,105331,  2208, 47247,  2254,105744, 84408, -4544, -4544, 84889,
   -4544, 85370,  1996, 85851, -4544,106157, -4544,  2141, 86332, -4544,
   13686, -4544,  1917,   896,  1929,  1324, 71902, 71902,  1055, 98690,
     297, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,   363,
    1732, 52626,  1109, 53116, -4544, -4544,  1173,  1231,  1312,   363,
    2352,  2352,    62, 71902, -4544, -4544,  1732, -4544,   734,   -26,
    1942,  1942,  1942,  2129,   525, -4544,  1942, -4544, -4544, -4544,
   -4544, 73826, 52626, 53116, -4544,  1971,  2811,   138,  2346, 79598,
   -4544, 79598, -4544, 79598, 79598, -4544, -4544, -4544,  2348,  1995,
    2235, -4544,  2037, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
    2186,  2220,  2240,    64,  2811,  2147, -4544,  2362, -4544,  2265,
   30518,   -60, 71902,  2811, 53606, 74788, 93547,   266,102027,  2811,
   86813,  2111,  1545,  2268, -4544, -4544,   228, -4544,  2485,  2122,
    2344,   444,  1341, 43825, -4544,  2138,  1690, 73826, 97864, -4544,
   -4544, -4544, -4544,   296,  2392, 31017, -4544, 79598,  2140, -4544,
    2146,  2192,  2212,  1791, -4544, 79598,   647,   647,  2574,   647,
    1588,  1619, -4544,  2024, -4544,  2493,  2468, 73826,   972,  1234,
    2283, -4544, -4544, -4544,  2257, -4544,  2290,  2296, -4544,   791,
    2519, -4544, -4544, -4544, -4544,  2380,  2384,  2385,  2389,  2288,
    2390,   237, -4544, -4544, -4544, -4544,  2623, -4544, -4544, -4544,
   -4544, -4544, -4544,  2723,  2711,101201,101201,   182,   392,   141,
     350, -4544, -4544, -4544,  2584, -4544, -4544,  2589, 79598,  2434,
   79598, -4544, -4544, -4544, 87294, -4544, -4544,  2195,  2257,  2365,
   -4544,   225, -4544,  1690, -4544,   334,   375,   398,  1450,  2374,
    1546,  1548, -4544,   667,  2495,   160,   -67,  2420, 75269,  2342,
    2403,   765,  2684,  4125,   237, -4544, 79598, 79598, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544,  2416, -4544, -4544,
    2431,  1648,  1395,  2714,  6800,  1186,  2730,  5125,  2118,   731,
    2631,   944,  2733,  1663,  2753,  5694, 79598,  2460, -4544,  2685,
    2795,   471, -4544,   753, -4544,  2530,  2666,   863, 56019,  2487,
   -4544, -4544, 79598, -4544, -4544, -4544, -4544,   290, 56019, -4544,
    2680, 47741, -4544, 79598, -4544, -4544, -4544, -4544, -4544,  2617,
   79598, -4544, -4544,  2734, 79598, -4544,  1942,  1171,  2520,  2887,
   59393,   164, 79598,  2559,  2921,  2726,  2559,  2568, 87775, -4544,
   -4544,  2559, -4544, -4544, 79598, 79598,  2533,  1257,  2559,  2928,
    2938,  2616,  2722,   771,  1313,   107,  2844,  2559, 79598, 88256,
   79598, 79598,  2919, 56019, 79598, -4544,  2728, 75750, -4544,  2575,
    2188, -4544, -4544, -4544, -4544, -4544,  1155, -4544, -4544, -4544,
   -4544,  2871,  2365,   354,  2873,  2586,  2876, -4544,  2618, -4544,
    2881,  2403,  2882, -4544,  2588, 88737, 89218, 89699,  2884,  2416,
  104092,  2886,  2588,  2888,  2775,  2889,   354,  2895, -4544,   786,
    2902,  2791,  2904,  1868,  2588,102440,  2905,    83, -4544, 18710,
   13686, -4544, 26545,  1698, -4544, -4544, -4544, -4544, -4544, -4544,
   34510,   476,  2701, -4544, -4544, -4544,  1532, -4544, 99948, -4544,
    1055,  1732, -4544, 71902,  1732, 71902,    62,  1732, 71902,  1732,
   71902,    62,  1732, 71902, 71902, 71902,  1732, -4544, -4544,  1739,
    2038, -4544, -4544, -4544, -4544, -4544, 71902,  2621, 79598, 79598,
   -4544, -4544, -4544, 67092,104092, 67573, -4544, -4544,     4, 71902,
   -4544, 71902, -4544,  2811, -4544, -4544,   896, 59393,  3020,104092,
    2906,  2906,  2906, -4544, -4544, -4544,  2847, 79598,  2909,  2911,
   67092,104092, -4544, 90180,102027,  2809,  2632, -4544, -4544, -4544,
   -4544,  1611,  2822,   427,  2883, 34510,  2634,   257,   257,  2635,
    2912, -4544, -4544, -4544,   439,  2636,  2638, -4544,   481,   481,
    2798,  2642,  2648, -4544,   504,  2650, -4544,  2910,   729,  2652,
    2653,  2654,   875,   257, 34510, -4544,  2655,   481,  2656,  2657,
    2658,  2918,  2660, -4544,  2956,  2661,   300,   414,  2664,  2665,
   -4544,  2642, -4544,   517,  2667,  2668,  2669,  2670,  2671,  2673,
    2674,  2678, 34510, 34510, -4544, 29520,  1690,  2811, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544,    88, -4544,   737,  3575, -4544,
   -4544,  2836, 34510, -4544, -4544,   179, -4544,   894, -4544, -4544,
    1690, -4544, -4544,  1572, -4544, -4544, -4544, -4544,  1916,  1916,
     195, -4544, 69016, 69016, -4544, -4544,   869,  2679, -4544,  1667,
   -4544, -4544, -4544, -4544, -4544, -4544,101614,  3078, -4544,  2001,
    2811,   753,  1680,  3026, 99106, 99527,  2925,  2925,  2913, -4544,
   -4544, 79598, -4544, -4544, 34510, 49718, -4544,  1690,    68,  2924,
   -4544, -4544, -4544,  1799, -4544, -4544, -4544,   297, -4544, 11252,
   -4544,  1937,  2140, 79598, 79598,  3085, -4544, -4544,  2146, -4544,
   -4544,  1791,  1791, 34510,  1791,   137,  1120, 31516, 34510,  2972,
    2879,  1181,  1371,  2979, -4544,  1588,  1619, 73826, 79598, 90661,
    2806, -4544, -4544,  2257,  2709,  1636, -4544, 61320, 96908, 96908,
    2947, -4544, -4544,  1076,  1061,  2823,  2915,  2352,  1569,  2007,
    2007, -4544, -4544,  2705, -4544,  3033, 69016,  2766,101201, -4544,
   -4544, 79598, -4544, -4544, 76231, -4544, -4544, -4544,  1703,  2712,
   -4544,  2727, 79598,  3206, -4544,  2007,  2007, -4544, -4544,  2715,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, 97386,  2720,
   79598, -4544,  2721,  2724, -4544, 97864, 50200,  1769,  1690,  2796,
    2799,  2848, 55055,  2729,  2807,  2808,  2851,  2813,  2814, 94028,
   -4544, -4544, -4544, -4544,  1640,  1011,   716,  2821,   249,   898,
    3087, -4544,  2854, -4544, -4544, -4544,  3754, 79598,  3043,  5797,
    2932,   237,  2868, -4544, -4544,  2977,  2831,  2833,  2949,   237,
     953, 94509, -4544, -4544, -4544, -4544, -4544, -4544,  4514, 28049,
   -4544,  2835,  2816, 79598, 62763,  3124,  2948,  1026,  1733,   236,
   79598,  3018,  2958, 79598,  2778,  2853,  2856,  2780,  1563,  3135,
    2784, -4544, -4544,  2955,  2841,  2843, 58429,  1040, 48235,  3122,
    2870, -4544,  1596,  2872,  2874, 79598,   237, -4544,  3172,   237,
     237,  1973,  3175,  2875,   298,  1843,  2559,  2784,  1483, -4544,
    2880,  2885,  1329, -4544,  2978, 73826,   161,  1890,  2784,  2891,
    2894,  2780,  2780, 79598, 79598, 79598, 79598, 79598,   115,  3196,
    3197,  2896,   156,  2929,  2818, -4544,102853,  2897, -4544,  1596,
   79598,  2899,  1941,  2784,  1509, -4544,  1678, -4544, -4544, -4544,
    1341, -4544, 79598, -4544, 79598,  2365, 59393,  2989,  2860, -4544,
    2403,   237, 79598, 79598,  2416,   934,  1042,  3006, 79598,  3066,
    2877, -4544, -4544,  2559, -4544, 50200,  2533, -4544,  2838, -4544,
    2892, -4544,  2892,  2892,  2839,  2839,  2840, -4544, -4544,   875,
    2892,  2839, -4544, 60357, -4544,  1551,  1646, -4544,  3236,  3238,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,  1063,
   -4544,  1957, -4544, -4544, -4544, 79598, 55055, -4544,  3251, -4544,
   -4544, 59393,  3140, -4544, 79598,  3046,  2855, -4544,  3176,  2908,
   -4544,  2898, -4544,104092,   787,  2811,  2900, 79598,  3069, 79598,
   79598, 79598, 79598, -4544, -4544,  3044,  1239,    34, -4544,102853,
   -4544,  1483,  3055,  3258,   569,  1942,  3145, -4544, 79598,  2890,
    3263,  3104, -4544, -4544,  2893,  2352, -4544,  2575, -4544,  1759,
   -4544,  2999, -4544, 56019,   354, -4544, -4544, -4544, -4544, 59393,
   79598, 91142, 56019,   354,104092,104092,  3174,    83,  3178,  2935,
    3179,  2936, 48235,   354,    98,104092, 79598, 79598, 79598, -4544,
   79598, -4544, -4544, -4544, -4544, 79598, 79598,104092,102853,  3180,
    3183,   354, 79598, 79598, -4544, -4544, 26456,  1737, -4544, 13686,
   -4544, 11252,  2009,  2925, -4544,  1401, 79598,  1166,  1055,103266,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, 71902, -4544,
   71902,    62, -4544, -4544, 71902, -4544, 71902,    62, -4544, 71902,
   -4544, -4544, -4544, 71902, 79598,  3381,  2917, -4544,  1572, -4544,
   79598,  2020, -4544, -4544,  2039,   617, 79598, 79598,   151, 56019,
   79598,  3081, 79598, 79598, 79598, 79598, 79598,  2967,  2679,   505,
   -4544,   232, 73826,  3088, -4544, -4544, -4544, -4544, -4544,  2045,
    1591,   998, -4544, -4544, -4544, -4544, -4544, -4544, 67573, 66130,
    3188,   184, 79598, -4544, -4544,  4087, 34510, 30019, -4544, -4544,
   -4544,  2922, 11252,  2937, 34510, -4544, -4544, 34510,  2923,  2352,
    2352, 34510, -4544, -4544, -4544, -4544,  2121,  2352, -4544, 34510,
   34510,  2352,  2352,  2892,  2892, -4544,  5370, 34510, -4544, 48235,
   34510, 36007, 27549, 34510,  2976,  2930,  2352, -4544,  2352, -4544,
   34510, 29021, -4544, 34510,  3117, 37005, 34510,  1680,  3119, 34510,
    1680,  3333,  3333,   972,  1708,  3530,  2927,  1690, -4544,  3031,
    2352, -4544,  2352,   857,   268, 59393, 34510, 55055,  3001,   159,
   79598, 34510,  2926,  2071, -4544, 34510,   582, -4544,  2931, 34510,
    3002, 34510, 34510, 34510, 34510, 34510, 34510, 34510, 34510, 34510,
   -4544, 37975,   299, -4544,   910,   606, 68054, 30518,  3209, -4544,
   27049, -4544,   203, 71902, -4544, -4544,  1690, -4544, -4544, -4544,
   -4544, -4544,  1703,  2933, -4544,  2950, -4544, -4544, -4544, -4544,
   -4544, 79598,  3078, -4544, -4544,  3021, -4544, -4544, -4544, -4544,
     965, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,  2945,
   -4544, -4544, -4544, -4544,  2945, -4544, -4544,  2925,  2952,  5302,
   -4544, -4544, -4544, -4544,  3212,  3216,   354, 97386, 79598,   296,
   70459, -4544, 31017, -4544,  2048, -4544,  2957, -4544,  3194, -4544,
    2953, -4544,  8775,  3194, -4544, -4544,   145,  3137,  3144,  3144,
   -4544,  2959, 11252, -4544,  1912, 11252,  1952, -4544, -4544, -4544,
   -4544, -4544, -4544,  1058, -4544,  2972,  1371,  3015,   670, 79598,
   -4544, 44310,  2170, -4544,  2257, -4544, -4544, 25512, -4544, 25992,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,  2964,
   -4544, -4544, -4544, -4544, -4544,   237,  2965,  3436, -4544,101201,
   -4544, -4544, -4544,  3381, -4544,  2214, -4544,  2214,  3462, -4544,
   71902, -4544, -4544, -4544, -4544,   999, -4544, 13686, -4544, 13686,
   -4544,  2970,  2049,  3047,  3054,  3100,104092, 79598, 79598, -4544,
   55055,104092, 79598, 79598,104092, 79598, 79598, -4544,  3335,  1250,
   66130,  3102, 64206, -4544, -4544,  2986, 79598,  3040,  3220,  3221,
     920, -4544, -4544, 91623, -4544,  3181,104092, 79598, 79598, 34510,
    3182, 79598, 79598, 79598,  3065, 56019,  2994, 79598, 79598, 79598,
     293, 56019, 48729, 79598, 79598, 79598, 79598,  3118, 79598, 79598,
    3229,  1306, 73826,   102,  1954,  2784,  3192, -4544,   994, -4544,
  104092, 79598,  3184, -4544, -4544, -4544, 64687,  3395,  3108, -4544,
   -4544, 94990, -4544, -4544,  3185, -4544, -4544, 60357, -4544, -4544,
    2066, -4544, 59875, 57465, -4544, -4544,  1218,104092,104092,  7394,
   79598,  1361, -4544, -4544, 59393, -4544, 79598, 79598, 79598, 70940,
   92104, 92585,  1137,  1270, 79598, 71421, -4544, 79598, -4544, -4544,
   55537,104092, 79598, 55055, -4544, 79598,  3190,   178, -4544, 79598,
    6303,  3084, 79598, 79598,  3010,  2079,  3090,  3133, -4544, 79598,
  104092,  1809, 93547, -4544,104092, 79598, 10746, -4544, -4544,   237,
   -4544, -4544, -4544, -4544, -4544, 79598, 79598,   237, 79598,   237,
    1336, -4544,104092, 79598, -4544, -4544, -4544,  8374, 79598, 79598,
   79598, 79598,104092, 79598, -4544, -4544,  1351,  1255,  1339,  1500,
    3153, 79598,  2811, 79598, 93066,104092, 79598, 79598, 79598,  1590,
   -4544, -4544,  3128, -4544,104092,  1809, -4544,  8915, 79598, 79598,
    3093,  3094,    95,  3167, -4544, -4544, -4544, -4544, -4544, -4544,
    3257,  3419, 79598, -4544,  3261,  3262,  3080,  3089,  3271,  1508,
   79598, 79598, 79598, 79598, 79598, 79598,  3274,  1508,  3224,   227,
    3048,  2089, -4544,  3057, -4544, 34510,  3442, 59393,  3049,  3051,
    3125, -4544,  3126,  2352, -4544,  2101, -4544, -4544,  2097, -4544,
    3067,  1239,  1477, -4544, 79598,   760,   824,  3345, 41399,  3168,
    4031,  3338, 79598, 79598,  4031, -4544,  2145, 66130, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544,  3339, -4544,  2811,
    2533,  2533,  2533,  2533, -4544, -4544, -4544, -4544,  3245,  1993,
   -4544,  3062,  2533, 79598,  3177,  4031, -4544,  1483,  3358,  3361,
   79598, 63244,  1930,  3106,  2811,  3250, -4544, 28535,  2412,  3253,
  102027, 75750, -4544,  3082,  3341,  3342,  3355, -4544,  2365, -4544,
    3474, -4544,  3373,   354,  2403, -4544,  2588, -4544, 79598, -4544,
   79598, 79598, 79598, 79598,  2416, -4544, -4544,  2588,  3264,   354,
     354, -4544,  3265,   354,  2588,  3193,  3363,102027, -4544,    83,
   -4544, -4544, -4544, -4544, -4544, 34510, -4544, -4544,  1942,  1759,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, 71902,  2214, -4544,  2103, -4544, 79598, -4544,  3343,  3344,
    3346,  3086,  3097,  3132, 79598,  3099, -4544,  3086,   237,  3086,
    2679,  2679,  3086,  3097,103679,  3500,  3375,    74, -4544,   113,
     778,  3308, -4544, -4544, -4544, -4544, 59393, -4544, -4544, -4544,
   -4544, -4544, 79598,   154,  3286,  3105,103679,  3487,   354, -4544,
   56019, -4544, -4544, -4544,  3195, 56019,  3295, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544,  3348, 79598,  2115, -4544,  1595, -4544,
    1778, 34510, 34510,    42, -4544,  9066,  2119, 34510,  3112,  3113,
    2124, -4544, -4544, -4544, -4544, -4544, -4544,  3115,  3396, -4544,
   -4544,  3120,  2125,  2150,  3121,  3123, -4544, -4544,  5631,  3129,
    9789,  3130, 36007, 36007,  2565, -4544, -4544, 36007,  3134, -4544,
    2196,  8825,  3131,  3136,  3143, -4544,  3138,  3141,  9840, 32015,
   34510, 32015, 32015, 10337,  3131,  3146,  2221, 55055,  3290, 10612,
    2229, -4544, 34510, 55055,  6174, 34510, -4544, 34510, 79598,  3147,
    3148, -4544, -4544,  5370, -4544,  3155, -4544, 36007, 36007, -4544,
    2983, 29520, -4544, -4544,  3399, -4544, -4544,  1875, -4544,  3150,
   -4544, -4544,  5154,   199, 34510,  2926, 34510,  3203, 48235,  2878,
   34510,  5104,  4285,  4285,   678,   678,   124,   124,   124,  2098,
     606, -4544, -4544, -4544,  3154,  2660, 34510, -4544,  2237,  2315,
   79598, 11913, 12025, 12166, -4544, -4544, -4544, 39458,  3173, 34510,
   34510, 34510,  3152,  3312,  3558, 11252,   692, -4544,  3568, -4544,
   -4544, -4544,   242,  3462,  1703, -4544,  1341,  2352,   857, 99948,
   -4544, -4544, -4544, 34510, -4544, -4544, -4544, -4544,  2146, -4544,
   -4544, -4544, -4544, -4544, 79598,  1591, 34510, -4544, -4544,   596,
    2203, 34510,  1912, -4544, -4544, 79598,  3088,  3088, 34510, -4544,
   -4544, -4544, -4544, -4544, 39458,  3199,  3204, 43340,  3288, -4544,
   -4544, 79598,   196, -4544, -4544, -4544,  3186, -4544, -4544, -4544,
    1384, -4544, -4544, -4544, -4544, -4544, -4544,  3159, -4544,  3161,
   -4544,  3189, -4544, -4544, -4544, -4544,   173,  3164,  3165,  3166,
    1645, -4544, -4544,104092, 79598, 79598, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544,  3387, -4544,104092,104092,
    3351, 79598,  3349,  3364, 34510,   321, 79598,  3200,  3205,  1465,
    3434, 79598, -4544,  3478,   354, -4544, -4544,  3267, -4544, 11252,
   -4544, -4544, -4544, -4544,102027, -4544,  2365, 59393, -4544, -4544,
   -4544,  3227, 79598, -4544, 79598, 79598,  2416, -4544, -4544, -4544,
   -4544,  1048, -4544, -4544, 79598, 79598,    46,  3273,  3277, 79598,
   -4544,   831,  2978,  9288, 79598, 79598, 79598,  3449, -4544, -4544,
   -4544, -4544,  3386, -4544, -4544,  1957, -4544, 57465, 59875, -4544,
   59875, -4544,  1957,  1893, -4544,  2588,  3281,  2784, -4544,  3384,
     799, -4544, -4544, -4544, -4544, -4544,  3501,   354,  3502,   354,
   79598, 79598, 79598, 79598, -4544, -4544, -4544, -4544, -4544, 55055,
   55055, 55055,  2246, -4544, -4544,  2811, -4544, -4544, -4544,  2255,
   -4544,  1584, -4544, -4544, -4544, -4544, -4544, -4544,104092,  1885,
   -4544,   815, 59393, -4544, 58911,104092, 79598, -4544, -4544,  3429,
    3374, -4544,  1830,  3378,104092,  3268, -4544, -4544, -4544, -4544,
    3293,  2018,  2784,  1483, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544,   191,  2034,  2784,  3294, -4544,  3296, -4544, -4544,
   -4544,  3433,  3435,  3437,  3300,  3302,  3350,  3303,  3307,  3353,
   -4544,  3311,  3357,  3313,  3359,  3315,   354, 59393,  2030,  3354,
    3534,   354, -4544,  3317, -4544, -4544,  3638, -4544, 79598, -4544,
    3325,  2065,  2784, -4544, -4544,104092, 79598, -4544, -4544, -4544,
    1508, 59393,  3488,  1508,  1508, 79598, 79598,  1508, -4544, -4544,
   -4544,  3490,  3491,  3492,  3493,  3494,  3497,  1508, -4544, -4544,
   -4544, -4544,  1171, 55055, -4544,  2615, -4544,  2211, 45765,  6460,
    3254,  3051,  3276,  2352, 41885,   923,  3469,  3278, -4544, -4544,
   55055, 45765,  2019,  3484,  3297,  3297,  3297,  3297,  3297,  3297,
    3297, -4544,  3596,  2559,102027, 79598,102027, -4544,   824,  3384,
   79598, -4544, -4544,  2256, -4544, 79598,104092,   769,104092,  2352,
   -4544, -4544,  3347, -4544,  1942,   787,  3402,  1719,  3610, -4544,
   -4544, -4544, -4544, -4544, 79598, 79598,  1239,  2811, -4544,  3280,
    3283, -4544, 79598, 79598, 79598,  1591,  3287, 79598,  3282,  3285,
   -4544, -4544, -4544, -4544, 59393,   162,  3471,  3472,  2780,  3686,
    3367, 79598, -4544,  2266,    77, -4544,  2811,102027, 57947, -4544,
    4049, -4544, -4544,   635,  3564, -4544, 79598, -4544, -4544, 42855,
     354, 59393, 79598, -4544,   354,    83,  3352,   354,  3356,   354,
     354, 79598, -4544, -4544, 79598, -4544, 79598,102853,   354, -4544,
   11252,  3579, -4544, -4544, -4544, -4544,  3418,  3420,  3421, 79598,
    3086, 56019, -4544,  3304,104092,  1452, -4544, -4544,  3480, -4544,
   -4544, -4544, -4544, -4544,  3599,  3602, -4544, -4544, -4544,104092,
   67092,   105,104092, -4544,  2365, -4544,  2403,   237, 79598,  3547,
   -4544, -4544, -4544,  3316,  2269, 10758, 34510, -4544,  3616, 59393,
   -4544,  6539, -4544, -4544, -4544, -4544, 34510, -4544, -4544, -4544,
   -4544, -4544, 34510, -4544, 34510,  3593, -4544,  3735,  3735, 59393,
   36007,  1291,  2656, 36007, 36007, 36007, 36007, 36007, 36007, 36007,
   36007, 36007, 38474,   693, -4544, -4544, 34510, 34510,  3605,  3593,
   -4544, -4544,   794,   794, 59393,  3331,  3131,  3332,  3336, 34510,
   -4544, -4544,  2272, 37490,  3360, 55055, -4544, 34510,  9424,  2278,
    3383, 11055,  1690,  7035, -4544,  3711,  2811, 34510,  1832,  2172,
   34510,  2282, 34510,  3620, -4544, -4544, -4544,  3362, -4544, -4544,
   59393, 34510, 36007, 36007,  6027, -4544,  6072, 34510,  3365,  6607,
   29520, -4544,   690,   690,   690,   690, -4544, 79598, 79598, 79598,
   38973, 76712,  3366,  2236, -4544, 76712, 77193, -4544,  3368,  1690,
   34510,  3613,    43,    43,  3372,  3312, 44795, -4544, 34510,  1900,
   32514,  3377, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544,  3371, -4544,  3370,
   -4544, -4544,   753,  3382, -4544, -4544,  8499,   173, -4544, -4544,
    3385, -4544,  3376, -4544,  2203, -4544, -4544, -4544,  7074,  3527,
    2679, -4544, -4544, -4544,  3366, 33013,  3288, -4544,  2291, -4544,
   -4544, 30518, -4544, -4544,  2292, 44310,  3199, 31017,  1690,  2352,
    3380, -4544,  2214,   242, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544,  3297,  2588,  2588,   723,  3086,  3631,   723,  7124,
   -4544, -4544, 39943, 79598, 79598, -4544, 79598,  2317,  1711, 79598,
   -4544, 79598, -4544, -4544,  3746, 79598, -4544,  3405,  3406, -4544,
   79598, 79598, 79598, 79598, -4544, -4544,  2374, -4544, -4544,104092,
   79598, -4544, -4544, -4544,   221,  2088,  2784, -4544,  3432, -4544,
   -4544,  3604,  1924, -4544, -4544, -4544,  3425, 79598,  3379, -4544,
     170,  2780,   821, -4544, -4544,  3428, 79598, -4544, 79598, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, 55537, -4544,
   -4544, -4544, 55055, 45765, 55055, -4544,  3438,  3439,  3504,   580,
     630,  3463,  3464,  3507,  3390,  3391,  3393, -4544, -4544,   363,
    2811, -4544, -4544,  2811,  2588,  2811, 79598, 79598, 79598, 79598,
   79598, 79598, 79598,  3656,    75,  1965,104092, 79598, 79598,104092,
   79598, 79598, 79598, 79598, 79598, 79598, 79598, -4544,  3756,  2811,
    2811,  3728,  3466, 79598, -4544, 79598,  2978, 79598, 79598, -4544,
   -4544, -4544,  3398,  1508, -4544, -4544,  3639,  3641, -4544,  1508,
    1508,  1508,  1508,  1508,  1508, -4544,    61,  2318, -4544, 98277,
   -4544, -4544,  2921,  2811,  2921,  1132, -4544,  2921, -4544,  2921,
   -4544, -4544,  3057,  3376,  2007,  2007, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544,  2352,  2242,  3413, -4544, 42370, -4544, -4544,
   -4544,  2185,   857, -4544, -4544, 79598,  3297, -4544,  2772,  2224,
    2504,  2857, 77674, 78155, 78636,  3417, 79598, 79598, 36007, -4544,
    1266,   750, -4544,  3649, 79598,  3453, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544,  2855, -4544, 79598,  3384,  2588,104092,
  104092,  2588, -4544, 59393,  3106,  1324, 88256,  3451,  3422,  3702,
   -4544,  3423,  3427, -4544, -4544, 79598,  3384,   639,  1929,  3457,
   65168,  1930, -4544,  3676, 63244, -4544, -4544, -4544,  3783,  3514,
   -4544,  1591,  2811,  3040, -4544, 57465, 34510, 34510, -4544,  3430,
   -4544,  3440,  4890, -4544,  2533, -4544, -4544, -4544, -4544, -4544,
   -4544,  3508, 79598,  3853, -4544, -4544, -4544,  3443,   354, -4544,
   -4544, 79598, -4544, 79598, -4544, -4544,   354,   354, -4544,  3546,
   -4544,  1591, 79598, 79598, 79598,  3086, -4544,   237, -4544,  3709,
  103679, -4544, -4544, -4544, -4544,   184,  3715, -4544, -4544,  3680,
    3682,  3683,  3684,  1847, -4544, -4544, 34510, 11252, -4544,  3450,
   -4544, 11252,  7569, 11252,  3605, -4544,  3334,  3717, -4544,  1519,
    3452,  3334,  1334,  1334,   200,   200,   103,   103,   103,  3735,
     693, 11252, 11252, -4544, -4544, -4544, -4544,  3454, -4544, -4544,
   -4544,  3131, -4544, 35009,  3591,  3831, -4544, -4544, -4544,  3498,
    3499,  3456, -4544, 34510, 35508,  3455, 60357, -4544, -4544,   857,
    1553, 36007, 36007,  2477, -4544,  1141, 34510, 59393,  2328,  2477,
    2613,  2914, 34510, 34510,  8963,   307, 34510,  7620, 79598, 79598,
   79598, 79598, -4544, -4544, -4544, 40913,  2236,  3460, 79598, -4544,
    3465, 39458,  3698,  3626, -4544, 39458,  3626,  1348,  3626,  3699,
   -4544, 45280, -4544,  3470, 27049,  1766, 11252,  3847,  3737, 34510,
    3475, -4544,  3476,  3312, -4544, 95471, -4544, -4544, 11252, -4544,
   -4544, 34510, -4544,  3312,   242,   277,  2811, -4544, -4544, -4544,
   48235, -4544, -4544, -4544,  3657, 11252, -4544,  1591, 79598,  1690,
     181,  3495, 79598, -4544,  3288, -4544, -4544, 13686, -4544, -4544,
   -4544,   363, -4544, -4544, -4544, -4544,  3557, 66130,  3760, -4544,
   34510,  2333, -4544,  3519,  3848,    82,  2338,  2356,  1711, -4544,
    3453, -4544,  1352,  3741,   239, -4544,   354, -4544, 59393, -4544,
   79598, 79598, -4544, -4544, -4544, -4544,  2729, -4544, -4544, 79598,
   79598, 79598, 79598, -4544,  3560, -4544, -4544, 55055,  3596,  3685,
   -4544, -4544,  3689,   363, 79598, -4544, 59393,   354,   354, -4544,
   -4544, -4544,  3506,104092, 79598, 79598,  2352,  2352, 59393,  3503,
   -4544,  2352,  2352,  3505, -4544,104092, 79598, 79598, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,  3577, -4544,
   -4544, -4544, 79598, 79598, 79598, 79598,  3796, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, 79598, -4544,
   -4544, -4544, 59393,   354,   354, -4544, -4544, -4544,  3742, -4544,
    1508,  1508, -4544, -4544, -4544, -4544, -4544, -4544, -4544,  2559,
    3825, -4544, 55055, -4544,100369, -4544, -4544, -4544,  2811, -4544,
    2811,  3700, 51164,  2811,  2811,  1711,  3511,  1183,  3786, -4544,
    2270, 42370, 42370, 42370, 42370, 42370, -4544, -4544,  3789,   363,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, 34510, -4544,   756,  3334, -4544,
   -4544, -4544, -4544,  3453,  1942,  3567,   760,  3637, -4544, -4544,
    2588,  2588,  3580,  3930,   654, 79598,  3843,  3581, -4544,  2811,
   -4544, -4544, 79598, 63244,  3457,   963, -4544,  2363, -4544, -4544,
   -4544,  3573,  3472,  1518,  3540,  1930, -4544,  1241, 79598, -4544,
    3582,  3817,  3545, -4544, 11252, 11252,  2811, 60839,  4049, -4544,
   79598,  3795, 79598, -4544,   354, -4544,   354,   354, -4544, -4544,
   79598,  3086,  3086,  3086, -4544,  3726, -4544,   354,103679,  1847,
    1847,  1847,  1847, -4544, -4544, -4544, 11252, -4544, -4544, -4544,
   36007,  3826, -4544,  3551, 59393, -4544,  3552,  2378,  2397, 37005,
    3694, -4544, -4544, -4544,  7670,  3601, 11252,  3652,  3555,  3556,
   -4544,  1246,  1246,  1141,  2406, -4544, 36007, 36007,  2477,  2477,
   34510,  2477, -4544, -4544, -4544, -4544, -4544, 76712,  3559, 79598,
    2236, 39458, -4544, -4544,  1446, -4544, 39458,  3790, -4544, 39458,
   79598,  3561, 79598,   927, 34510, 34510,  3595,  3312,  3312, -4544,
    3729, -4544,  3572, -4544, -4544,  2007, -4544, -4544, -4544, -4544,
     857,  3574, 71902, -4544, -4544, -4544,   972, -4544, -4544, -4544,
   -4544,103679,  3757,103679,  1711,  7934,  3453, 39943, 49223, 79598,
   79117, 79117,  3714,  3453,  3567, -4544, -4544, -4544, -4544, -4544,
   -4544,  3583, -4544, -4544, -4544,  3653, -4544, -4544, -4544,  2407,
   -4544, -4544, -4544, -4544, -4544,  3756, -4544, -4544, 45765, -4544,
   -4544, -4544, 40428, 48235, -4544,   580,  3586,  3587,   630, -4544,
   -4544, -4544, 79598,  1463,   802,  3615,  3086,  3863, -4544,  3756,
   -4544, -4544,  1508, -4544, -4544,  3048,  2811, -4544, -4544,  2422,
   -4544, -4544, -4544, 79598, -4544,  3422, -4544, -4544, -4544, 56019,
    3978,  3978, -4544,  2032,  2032, -4544, -4544, -4544, 79598, -4544,
   -4544,  8071,  3777, -4544,  3567,  3798,  3844, -4544, 79598, 79598,
    1591, 63244,  3384, -4544,  1462,  3590,  3885, -4544,  3287,  3592,
   -4544, -4544,  3924, -4544, 65168,  3772,  3514,   798,   798, 79598,
    3472,  3719, -4544,  3720, -4544,  1079, -4544, 79598, 39943, -4544,
   59875, -4544,  2436, -4544, -4544,  3173, 79598,   657, -4544,  3614,
   -4544, -4544, -4544, -4544, -4544, -4544,   105, -4544, -4544, -4544,
   -4544,  1032, 36007, 59393,  2441, 34510, -4544, 34510, -4544,  3983,
   -4544, -4544, -4544,    33, -4544, -4544, -4544,  1246,  1246,  2477,
   -4544, 79598,  2444, -4544, 34510,  3600, -4544, -4544, 39458,  1446,
    2447, 79598,  2474, 59393,  3312,  3131, 11252, 79598, -4544, -4544,
   -4544,  3984,  3784,  3312, -4544, -4544, -4544, -4544, -4544, -4544,
    1452,   723,   105,  3848,  3567, -4544,  3609, -4544, -4544, 79598,
   -4544,  1119,  1119, 79598,  3567, -4544, -4544, 79598, -4544, 55055,
    3663, -4544, 59393,  2403,    50, -4544, 59393, 59393, -4544, -4544,
   79598, 79598, 79598, 79598, 79598,   354, -4544, -4544, -4544, -4544,
  100369,  3422,  3978,   240, -4544, -4544, -4544,  1817,  3808, -4544,
     841,  3793,  3701,  3384,  3902,  3582, -4544, -4544, -4544, -4544,
   34510,  3766,  1930,  3676, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544,  2478,  3514, -4544, -4544,
    3987,  3800,  3993, -4544,  2503, -4544, -4544,  4890, 60839,  3928,
   -4544,  3677, 79598, -4544, -4544,  2404,  4046, -4544,  1032,  2508,
   -4544,  2509,  2514,  3771,  3679, -4544,  2535, -4544, 11252, 79598,
   -4544, -4544, -4544,  2540, -4544,  3630, -4544,  4029, 34510,  1650,
   -4544, -4544,  3912, -4544, 79117,  3674, 48235, -4544,  2203,  2203,
    1942, -4544,  1711, -4544, -4544, 34510, -4544,  2545, -4544,    17,
    3782,  3921,  2546,  2561,  3097,  3681,  3097, -4544,  3086, -4544,
   -4544, -4544, -4544, -4544,  3947,  3896, -4544, -4544, -4544, -4544,
     212, -4544,  3828,  3829, 79598, -4544, 79598,  4041, -4544,  8180,
   56019,  3472,  1930,  3596, -4544, -4544,  3830, -4544,  3833,  3106,
   39943,  4049, -4544,   752, -4544, -4544, -4544, -4544, -4544, 79598,
   -4544, -4544, -4544, -4544, -4544, -4544,  2566, -4544, 79598,  3651,
    3131, 33512, 33512,  3658,103679,  1119,  3660, -4544,  3661, -4544,
   -4544,  3798,  1711, 11252, 56019,  4030, -4544, -4544, -4544,  3782,
   -4544, -4544, 79598,  3780, -4544,   877,   877,  3976, -4544,  3718,
   -4544, -4544, -4544,   580, -4544,  3665,  3514,  3472, -4544, -4544,
    3514, -4544, -4544, -4544, -4544,  2155, -4544, -4544, -4544, -4544,
   36506,  3791,   805,  9754, -4544, -4544, -4544, -4544,   105,  2203,
   34510,  1711, -4544,  3793,  2403, 79598, -4544, -4544,  3581, -4544,
    4072, -4544,  1021, -4544, -4544,  3503, 54573, -4544,  3514,  3173,
   -4544,  2300, -4544, -4544, -4544, -4544, -4544, -4544, -4544,  4065,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544,  8378, -4544, -4544,
   -4544,  3962, -4544, -4544, -4544,  2569, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544,  1800, -4544, -4544,  1811,  2212, 34011, -4544,
    1711,  3820, -4544, 54573, -4544,  2300, -4544, 56019, -4544, -4544,
    3672, 54573,  2570, -4544
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_uint16 yydefact[] =
{
    2261,     0,     2,     1,  2691,  2695,  2699,  2700,  2617,  2701,
    2702,  2667,  2668,  2669,  2670,  2671,  2672,  2673,  2674,  2675,
    2676,  2677,  2678,  2680,  2679,  2681,  2682,  2683,  2684,  2685,
    2686,  2687,  2688,  2690,  2689,  2639,  2268,  2636,  2633,  2634,
    2635,  2640,  2638,  2631,  2632,  1867,  2704,  2692,  2705,  2693,
    2694,  2696,  2697,  2666,  2698,  2706,  2707,  2708,  2703,  2711,
    2662,  2663,  2661,  2664,  2665,  2709,  2710,  2653,  2654,  2655,
    2656,  2712,  2269,  2270,  2658,  2262,  2266,  2328,  2399,  2659,
    2660,  2657,  2267,  2652,  2399,     0,  2520,  2521,  2522,     0,
    2523,  2524,  2525,  2451,  2413,  2526,     0,     0,  2527,  2528,
    2529,  2530,  2531,  2532,  2533,  2534,     0,  2535,  2536,  2537,
    2538,  2398,  2539,  2540,  2541,  2542,  2543,  2375,  2381,  2504,
       0,  2355,  2356,  2352,  2354,  2353,  2357,  2340,  1154,   528,
    1238,  1237,     0,  2164,  1154,  2120,  2121,  2165,  2122,  2123,
    2124,   249,     0,  1240,  2125,  2166,     0,  1154,  2167,   357,
     932,  2168,  2169,  2283,     0,  2126,  2127,     0,     0,     0,
     528,  1154,     0,     0,  2128,  1350,  2129,     0,  2130,  2170,
    2171,     0,  2131,  2172,  2173,  2132,  2133,  2134,  2174,  2175,
    2176,  2135,  2177,  2178,     0,     0,  1364,     0,  2136,  2179,
    2137,  2138,     0,  2180,  2139,  2140,  2141,  2181,  2182,  2183,
    2142,  2143,  2144,     0,  2145,     0,     0,     0,     0,     0,
    2184,  1154,  2146,     0,     0,  1371,     0,  2147,     0,  2185,
    2148,     0,  2149,     0,  2150,  2151,  2152,  2153,  1364,  2500,
    2376,     0,  1242,     0,  2154,  2186,     0,  2155,  2156,  2157,
    2158,  2159,  2160,  2161,  2162,  2163,     0,     0,    54,    55,
      21,    20,    26,    25,    77,    78,    44,    14,    68,    49,
     110,   109,   111,    32,    28,    62,    18,    19,    29,    33,
      51,    50,    17,    48,    72,    52,    75,    39,     8,     9,
      40,    66,    10,    41,    67,    11,    42,    12,    56,    79,
      24,    53,    76,    35,    64,    60,     7,    45,    46,    47,
      69,    70,    71,    93,    74,   105,    31,   102,    83,    84,
      99,    85,   100,     5,    86,    43,    13,    96,    95,    97,
      63,    36,    65,    94,    98,    15,    16,   101,    73,    91,
      88,   106,   104,   112,    89,    57,     3,     4,    80,    38,
       6,    23,    22,    37,    30,   108,    27,  1240,    82,    92,
      81,    87,    61,    90,   107,    59,   103,  1337,  1324,  1373,
    1336,  1349,     0,  1339,  2596,  2597,    34,  1350,   114,   115,
     120,  2265,  2317,  2318,  2319,  2399,  2350,  2351,  2344,  2360,
    2370,  2359,  2363,  2371,  2358,  2377,     0,   117,   119,   121,
     124,   118,   113,   116,   123,   128,   122,   127,   125,   126,
     129,   130,   131,  2598,  1550,  2595,    58,  2335,  2334,     0,
    2399,     0,  2628,  1879,  1880,  1881,  1882,  1883,  1884,  1885,
    1886,  1887,  1888,  1889,  1890,  1891,  1892,  1893,  1894,  1895,
    1896,  1897,  1898,  1899,  1900,  1901,  1902,  1903,  1904,  1905,
    1906,  1907,  1908,  1909,  1910,  1911,  1912,  1913,  1914,  1915,
    1916,  1917,  1918,  1919,  1920,  1921,  1922,  1923,  1924,  1925,
    1926,  1927,  1928,  1929,  1930,  1931,  1932,  1933,  1934,  1935,
    1936,  1937,  1938,  1939,  1940,  1941,  1942,  1943,  1944,  1945,
    1946,  1947,  1948,  1949,  1950,  1951,  1952,  1953,  1954,  1955,
    1956,  1957,  1958,  1959,  1960,  1961,  1962,  1963,  1964,  1965,
    1966,  1967,  1968,  1969,  1970,  1971,  1972,  1973,  1974,  1975,
    1976,  1977,  1978,  1979,  1980,  1981,  1982,  1983,  1984,  1985,
    1986,  1987,  1988,  1989,  1990,  1991,  1992,  1993,  1994,  1995,
    1996,  1997,  1998,  1999,  2000,  2001,  2002,  2003,  2004,  2005,
    2006,  2007,  2008,  2009,  2010,  2011,  2012,  2013,  2014,  2015,
    2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,  2024,  2025,
    2028,  2026,  2027,  2029,  2030,  2031,  2032,  2033,  2034,  2035,
    2036,  2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,  2045,
    2046,  2047,  2048,  2049,  2050,  2051,  2052,  2053,  2054,  2055,
    2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,  2065,
    2066,  2067,  2068,  2069,  2070,  2071,  2072,  2073,  2074,  2075,
    2076,  2077,  2078,  2079,  2080,  2081,  2082,  2083,  2084,  2085,
    2086,  2087,  2088,  2283,  2089,  2090,  2091,  2092,  2093,  2094,
    2095,  2096,  2097,  2098,  2099,  2100,  2101,  2102,  2103,  2104,
    2105,  2106,  2107,  2108,  2109,  2110,  2111,  2112,  2113,  2114,
    2115,  2116,  2117,  2118,  2119,  2301,  1868,  1876,  1877,  1878,
    2276,  2297,  2303,  2624,  2302,  1875,  2450,     0,     0,  2544,
    2545,  2546,  2547,  2548,  2549,  2599,  2600,  2601,  2602,  2603,
    2605,  2604,  2412,  2571,  2608,  2411,  2609,  2415,  2610,  2611,
    2612,  2613,  2572,  2614,  2414,  2606,  2568,  2416,  2409,  2410,
    2569,  2518,  2519,  1845,  2570,  2567,  2607,  2304,  2566,  2420,
    2419,  1314,  2623,  1844,  1315,     0,  2422,  2550,  2551,  2552,
    2553,  2555,  2554,  2556,  2187,  2188,  2189,  2190,  2191,  2192,
    2193,  2194,  2195,  2196,  2197,  2198,  2581,  2199,  2200,  2201,
    2594,  2202,  2203,  2582,  2204,  2205,  2206,  2207,  2208,  2209,
    2210,  2211,  2212,  2213,  2214,  2215,  2216,  2217,  2218,  2219,
    2220,  2221,  2222,  2223,  2224,  2225,  2226,  2227,  2583,  2584,
    2228,  2229,  2230,  2231,  2232,  2233,  2234,  2235,  2236,  2237,
    2238,  2239,  2240,  2241,  2242,  2243,  2244,  2245,  2246,  2247,
    2248,  2249,  2250,  2585,  2251,  2252,  2586,  2253,  2254,  2255,
    2587,  2256,  2257,  2258,  2259,  2260,  2591,  2592,  2593,  2580,
    2373,  2557,  2579,  2590,  2588,  2589,  2383,  2379,  2387,  2382,
       0,     0,     0,     0,  2399,  1153,  1152,  1138,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   527,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2273,     0,  1164,   332,   331,  1239,
    1220,   528,     0,  1141,   356,     0,     0,     0,     0,     0,
       0,     0,     0,   708,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   175,     0,     0,   380,   379,     0,     0,
       0,   904,   385,     0,     0,     0,     0,   516,  2282,  2277,
    2287,     0,  2280,  2281,  2566,     0,  2715,  2026,  2313,  2314,
    2713,  2074,  1316,   250,   253,   251,   252,     0,  1004,  1005,
    1007,     0,     0,  1017,   741,   742,     0,   740,   744,     0,
       0,     0,   737,     0,     0,     0,     0,   743,   735,     0,
     734,     0,     0,     0,   739,     0,   736,     0,     0,  1142,
       0,  2365,  2366,  1967,  1277,   386,     0,     0,  1350,     0,
    1240,  1247,  1257,  1252,  1254,  1253,  1255,  1251,  1256,  1880,
     843,  1894,   843,  1957,   840,   841,   843,   843,   843,  2041,
       0,     0,   815,     0,   826,  1871,   843,  1872,  2624,   848,
     441,   441,   441,     0,   847,   852,   441,  1135,  1171,  1849,
    1363,     0,  1894,  1957,   816,  1134,  2089,  1269,     0,     0,
    1021,     0,  1022,     0,  2056,  1146,   234,  2564,  2065,  2150,
    2089,  2565,   230,  2559,  2560,  2562,   204,  2563,  2561,  2558,
    1884,     0,     0,   847,     0,  1143,  1144,   801,  1370,  1368,
       0,     0,     0,  1902,     0,  1914,  1993,   227,  2052,  2057,
    2065,  2150,  2089,  2117,   184,   189,     0,   243,  2065,  2150,
    2089,     0,  1164,     0,  1340,  1450,  1840,     0,     0,  2374,
    1137,  1136,  1241,     0,  1244,     0,  1415,  2038,  1344,  1346,
    1246,  1337,     0,     0,  2264,  1235,  1367,  1367,     0,  1367,
       0,  1329,  1337,  1332,  1336,     0,     0,     0,     0,  1154,
       0,  2342,  2370,  2349,  2405,  2346,     0,     0,  2395,  2391,
    2388,  2396,  2397,  2390,  2378,  1539,  1540,  1541,  1538,  1551,
    1537,     0,  2323,  1542,  2362,  2329,     0,  2337,  2336,  2641,
    2642,  2452,  2275,  2294,     0,     0,     0,     0,     0,     0,
       0,  2421,  2423,  2425,  2385,  2384,  2380,     0,     0,     0,
       0,  2510,  2511,  2509,     0,  2506,  2508,     0,  2405,     0,
    2575,  2569,  2578,     0,  1850,  2570,  2567,  2566,     0,   751,
       0,   135,   892,     0,     0,     0,  1844,     0,     0,     0,
       0,     0,  1966,     0,     0,  1745,  1906,  1953,  1755,  1753,
    1754,  1747,  1748,  1749,  1750,  1751,  1752,     0,  1002,  1746,
       0,   135,     0,  1966,     0,     0,  1966,     0,     0,     0,
       0,     0,  1996,   135,  1966,     0,     0,     0,  1158,     0,
       0,     0,  1160,  1163,  1139,  1223,     0,  1840,     0,     0,
     785,   776,     0,   786,   777,   782,   788,     0,     0,   779,
       0,     0,   789,     0,   778,   780,   791,   781,   787,     0,
       0,   783,   784,     0,     0,  1150,   441,     0,     0,     0,
       0,     0,     0,   135,  1210,  1966,   135,     0,     0,   384,
     383,   135,   382,   381,  1906,  1953,     0,   931,   135,     0,
     177,   596,   531,     0,     0,   667,  1996,   135,     0,     0,
       0,     0,   907,     0,     0,   515,   528,     0,  2286,  2292,
       0,  2284,  2453,  2716,  2714,  2408,     0,  1008,   228,   229,
    1006,  1966,     0,   310,     0,     0,  1966,  1199,     0,   738,
    1966,     0,  1966,  1869,   170,     0,  1906,  1953,  1966,     0,
       0,  1966,   162,  1966,     0,  1966,   310,  1966,   532,     0,
    1966,     0,  1966,  1996,   164,     0,  1966,   310,   749,     0,
       0,  2646,  2650,     0,  2648,  2643,  2364,  2418,  2417,  2316,
       0,  2726,     0,  1316,  1249,  1262,     0,  1258,  1265,  1261,
    1350,   843,   842,     0,   843,     0,  2735,   843,     0,   843,
       0,  2735,   843,     0,     0,     0,   843,  1873,  1874,     0,
       0,  2734,  2732,  2733,   817,   827,     0,   849,     0,     0,
     856,   855,   854,     0,     0,     0,   857,  1454,  1292,     0,
     824,     0,   822,     0,  1132,  1149,     0,     0,     0,     0,
    1024,  1024,  1024,  1145,   233,   231,     0,     0,     0,     0,
       0,     0,  1151,     0,     0,     0,     0,  2630,  1856,  1756,
    2629,     0,  2121,  2122,  2123,  1814,     0,  2571,  2124,  2125,
    2166,  1668,  1655,  1664,  1669,  1656,  1658,  1665,  2126,  2127,
    1938,  2128,  2129,  1863,  2130,  2131,  1494,  2133,  2134,  2135,
    1660,  1662,  2136,  2137,     0,  1864,  2139,  2140,  2014,  2142,
    2143,  2145,  2146,  1666,  2148,  2149,  2150,  2151,  2152,  2153,
    1862,     0,  1667,  2154,  2156,  2157,  2158,  2159,  2160,  2161,
    2162,  2163,     0,     0,  1837,     0,  1640,     0,  1486,  1487,
    1509,  1510,  1488,  1515,  1516,  1528,  1489,     0,  1836,  1553,
    1639,  1645,     0,  1638,  1634,  1353,  1832,     0,  1635,  1852,
    1815,  1866,  1865,  2624,  1823,  1855,  1853,  1854,     0,     0,
       0,   196,     0,     0,  2499,   245,     0,   246,  1838,  2065,
     185,   226,   198,   225,   199,   197,     0,  1904,   186,     0,
       0,   187,     0,     0,     0,     0,     0,     0,     0,   239,
    1140,     0,  1452,  1451,     0,     0,  1821,  1841,   758,     0,
    1233,  1234,  1232,     0,  1229,  1231,  1243,  1240,  1828,  1827,
    1829,     0,  1345,     0,     0,     0,  1327,  1326,  1246,  1365,
    1366,     0,     0,     0,     0,     0,     0,     0,     0,  1408,
    1381,  1382,  1384,  1405,  1409,     0,  1333,     0,     0,  1456,
       0,  1416,  2263,  2405,  2406,     0,  2400,     0,  2399,  2399,
    2393,  2392,  2389,     0,     0,     0,     0,     0,     0,     0,
       0,  2320,   510,  2322,   507,     0,     0,  2296,     0,  2300,
    2298,     0,  2445,  2448,     0,  2446,  2447,  2449,     0,  2454,
    2455,     0,     0,     0,  2637,     0,     0,  2436,  2424,  2431,
    2433,  2435,  2434,  2443,  2439,  2442,  2444,  2386,  2399,  2517,
       0,  2512,  2515,     0,  2507,     0,     0,     0,  1851,     0,
       0,     0,     0,   752,     0,     0,     0,     0,     0,     0,
     134,  1197,   236,  1195,     0,     0,     0,     0,     0,     0,
       0,  1202,     0,   168,   169,   543,   528,     0,  1966,     0,
       0,     0,     0,   964,   971,     0,     0,     0,     0,     0,
       0,     0,   965,   963,   966,   238,   975,   988,   991,     0,
     882,     0,     0,     0,     0,  1067,     0,     0,  1067,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     256,   262,   305,     0,     0,     0,     0,     0,     0,     0,
       0,   139,     0,     0,     0,     0,     0,   494,   506,     0,
       0,     0,     0,     0,   503,     0,   135,   258,   487,   491,
       0,     0,     0,   605,   604,     0,  1067,     0,   254,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   324,   325,     0,     0,   139,     0,
       0,     0,     0,   260,     0,  2330,     0,  1159,  1156,  1157,
       0,  1162,     0,  1219,     0,     0,     0,     0,     0,   790,
       0,     0,  1906,  1953,     0,     0,     0,     0,     0,     0,
     359,   338,   339,   135,   337,     0,     0,   664,     0,  1497,
    1526,  1504,  1526,  1526,  1493,  1493,  1506,  1495,  1533,     0,
    1526,  1493,  1498,     0,  1496,  1536,  1536,  1521,     0,  1478,
    1479,  1480,  1481,  1507,  1508,  1482,  1513,  1514,  1483,  1550,
    2576,  1493,  2577,  2574,  2573,     0,     0,   675,     0,  1174,
    1209,     0,     0,   537,     0,  1966,     0,   137,   709,     0,
     665,     0,   137,     0,   173,     0,   600,     0,     0,     0,
       0,     0,     0,   625,   624,     0,     0,     0,   666,     0,
     137,   490,  1966,     0,   441,   441,     0,   906,   909,     0,
       0,     0,  2290,  2285,  2288,     0,  2278,  2292,  1319,  1321,
    1320,     0,  1318,     0,   310,   308,   309,   662,  1016,     0,
       0,     0,     0,   310,     0,     0,  1966,   310,  1966,     0,
    1966,     0,     0,   310,   310,     0,     0,     0,     0,   601,
       0,   748,   746,   745,   747,     0,     0,     0,     0,     0,
    1966,   310,     0,     0,   731,  2644,     0,     0,  2647,     0,
    2367,  1766,     0,  2729,  1274,  2730,     0,     0,  1350,     0,
     215,   216,   214,  1263,   217,  1264,  1260,  1248,     0,   835,
       0,  2735,  2736,   820,     0,   830,     0,  2735,   818,     0,
     831,   828,   829,     0,     0,     0,  2731,  2615,  2621,   834,
       0,     0,   442,   444,     0,     0,  1924,  1937,     0,  1958,
    1984,  1985,  2057,  2061,     0,  2084,  2093,     0,   858,   887,
     853,     0,     0,  1302,   825,   823,  1133,  1267,  1772,     0,
    1350,     0,  1023,  1020,  1019,  1018,   232,   205,     0,     0,
       0,   889,  2056,  1148,   800,   528,     0,     0,  1643,  1644,
    1525,  1512,  1813,     0,     0,  1520,  1519,     0,     0,     0,
       0,     0,  1502,  1501,  1500,  1642,  1780,     0,  1499,     0,
       0,     0,     0,  1526,  1526,  1524,  1573,     0,  1503,     0,
       0,  1793,     0,  1799,     0,     0,     0,  1532,     0,  1530,
       0,     0,  1609,     0,     0,     0,     0,     0,     0,     0,
       0,  1557,  1558,  2572,  1640,  1766,     0,  1641,  1859,     0,
       0,  1518,     0,  1550,  1756,     0,     0,     0,     0,  1826,
       0,  1764,     0,     0,  1587,  1762,     0,  1589,     0,     0,
       0,  1755,  1753,  1754,  1747,  1748,  1749,  1750,  1751,  1752,
    1760,  1570,     0,  1835,     0,  1569,     0,     0,  1418,  1352,
       0,  1857,  1816,     0,  2622,  2625,  1636,  2496,  2495,  2494,
    2493,  2464,     0,  2458,  2459,     0,  2497,  2498,   247,   248,
     244,     0,     0,   201,   200,     0,   223,   224,   195,   222,
       0,   218,   219,   203,  1708,  1707,   202,   194,   192,   190,
     206,   208,   209,   193,   191,   242,   240,     0,     0,     0,
    1818,  1817,  1847,  1822,     0,     0,   310,  2399,  1227,     0,
    1224,  1831,     0,  1347,     0,  1842,     0,  1236,  1343,  1342,
    1374,  1375,   924,  1341,  1399,  1400,  1395,     0,  1414,  1414,
    1391,  1385,  1390,  1388,     0,  1392,  1553,  1407,  1331,  1379,
    1380,  1383,  1330,     0,  1410,  1408,  1384,  1289,     0,     0,
    1457,     0,     0,  2407,  2405,  2345,  1478,  2399,  2338,  2399,
    2394,  2326,  1544,  1545,  1546,  1547,  1548,  1549,  2327,     0,
    2324,  1543,  2325,   508,   509,     0,     0,     0,  2293,     0,
    2274,  2299,  2430,  2539,  2462,     0,  2463,     0,     0,  2427,
       0,  2437,  2440,  2438,  2441,     0,  1478,  2618,  2513,  2618,
    1478,     0,     0,     0,     0,     0,     0,     0,     0,   753,
       0,     0,     0,     0,     0,     0,  2084,   235,  1193,     0,
       0,     0,     0,   891,   890,     0,     0,   911,     0,     0,
       0,  1205,   430,     0,   307,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   541,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   575,     0,  1067,     0,   613,     0,   973,     0,   972,
       0,     0,     0,   974,   969,   970,  2057,  2065,  2089,   237,
     990,     0,   989,   987,   946,   948,   947,     0,   950,   934,
       0,   935,     0,     0,   945,   953,   951,     0,     0,     0,
       0,  1946,   264,   277,     0,  1066,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   297,     0,   300,   299,
       0,     0,     0,     0,   304,     0,     0,     0,   303,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1003,     0,
       0,   156,     0,   159,     0,     0,     0,   493,   505,     0,
     497,   498,   495,   499,   500,     0,     0,     0,     0,     0,
       0,   492,     0,     0,   598,   597,   603,     0,     0,     0,
       0,     0,     0,     0,  1059,  1058,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     616,   617,     0,   618,     0,   160,   161,     0,     0,     0,
       0,     0,     0,     0,   213,  1155,  1161,  1222,  1848,  1221,
       0,     0,     0,   792,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     343,     0,   690,  2573,   663,     0,  1478,     0,  1474,  1470,
    1539,  1538,  1537,     0,  1484,  1493,  1490,   676,     0,   678,
     681,     0,  1172,   403,     0,   534,   575,     0,     0,     0,
     166,     0,     0,     0,   133,   177,   386,     0,   176,   178,
     180,   181,   182,   179,   183,   595,   599,     0,   530,     0,
       0,     0,     0,     0,   626,   630,   629,   633,   631,     0,
     627,     0,     0,  1466,     0,   155,   486,   489,     0,  2271,
       0,   388,   472,   317,     0,     0,   908,     0,     0,     0,
       0,     0,  2291,     0,     0,     0,     0,  1317,     0,   994,
       0,  1200,  1966,   310,     0,   992,   171,  1870,     0,   732,
       0,     0,     0,     0,     0,   996,   728,   163,     0,   310,
     310,   533,     0,   310,   165,     0,     0,     0,   525,   310,
     750,  2645,  2651,  2649,  1276,     0,  2727,  2728,   441,  1321,
    1250,  1259,   832,   839,   821,   838,   837,   819,   836,   833,
    2429,     0,     0,  2620,     0,   850,     0,   440,     0,     0,
       0,   864,   865,     0,     0,   863,   880,   866,     0,   868,
     860,   859,   869,   870,     0,     0,   889,     0,  1299,     0,
    1297,     0,  1455,  1301,  1290,  1268,     0,  1266,  1271,  1273,
    1272,  1270,     0,     0,     0,   847,     0,     0,   310,  1147,
       0,   802,   803,   808,     0,     0,     0,   809,   805,   806,
     807,   810,   811,   812,     0,     0,     0,  1776,     0,  1777,
       0,     0,     0,  1812,  1808,     0,     0,     0,     0,     0,
       0,  1784,  1785,  1786,  1783,  1787,  1782,     0,     0,  1788,
    1781,     0,     0,     0,     0,     0,  1523,  1522,     0,     0,
       0,     0,     0,     0,     0,  1612,  1645,     0,     0,  1740,
       0,  1766,  1798,     0,     0,  1534,     0,     0,     0,     0,
       0,     0,     0,  1766,  1804,     0,     0,     0,     0,  1706,
       0,  1703,     0,     0,     0,     0,  1823,     0,     0,     0,
       0,  1860,  1554,  1571,  1834,     0,  1825,     0,     0,  1555,
    1578,     0,  1805,  1605,     0,  1610,  1593,     0,  1586,     0,
    1591,  1595,  1574,  1826,  1765,     0,  1763,     0,     0,  1572,
       0,  1567,  1565,  1566,  1559,  1560,  1561,  1562,  1563,  1564,
    1568,  1744,  1742,  1743,     0,     0,     0,  1590,  1960,  1993,
       0,  1364,  1364,  1364,  1351,  1362,  1833,     0,  1461,     0,
       0,     0,     0,  1723,     0,  1770,     0,  1768,  1850,  2627,
    2626,  1824,     0,     0,     0,  1839,     0,     0,  1550,     0,
     241,  1453,  1819,     0,   756,   757,   755,  1478,  1246,  1230,
    1226,  1225,  1830,  1245,     0,  1350,     0,   922,   923,     0,
     927,     0,     0,  1393,  1406,     0,  1302,  1302,     0,  1397,
    1398,  1389,  1335,  1334,     0,  1464,     0,     0,  1286,  1279,
    1458,     0,  1418,  1304,  1306,  1307,     0,  1823,  2343,  2401,
    2348,  2369,  2339,  2372,  1552,  2321,  2361,     0,  2295,  2465,
    2466,     0,  2456,  2457,  2426,  2432,  2503,     0,  2619,     0,
       0,   688,   687,     0,     0,     0,  1093,  1026,  1071,   754,
    1094,  1027,  1072,  1095,  1028,  1194,     0,  1196,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   651,  1966,   310,  1203,  1096,     0,  1029,   306,
    1204,  1073,  1208,  1074,     0,   542,     0,     0,   547,   548,
     549,     0,     0,   550,  1906,  1953,     0,   555,   561,   565,
     556,     0,   566,   562,     0,     0,     0,     0,     0,     0,
     572,   574,     0,     0,     0,     0,     0,     0,   967,   968,
    1097,  1032,     0,  1075,   949,  1493,   933,     0,     0,   944,
       0,   943,  1493,  1493,  1033,   167,     0,   257,   265,   581,
    1069,   283,   296,   291,   292,   290,  1966,   310,  1966,   310,
       0,     0,     0,     0,   293,   288,   289,   285,   298,  1883,
    1939,  2066,     0,   585,   587,     0,   592,   301,  1045,     0,
     318,   321,   302,   281,   284,   282,   278,   263,     0,     0,
    1846,     0,     0,   998,     0,     0,     0,   158,  1055,     0,
       0,   144,     0,     0,     0,     0,   138,   148,  1103,  1037,
       0,     0,   259,   488,   496,   501,  1041,   504,  1085,   502,
    1109,  1038,  1067,     0,   255,     0,  1039,     0,  1079,  1105,
    1057,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1211,     0,     0,     0,     0,     0,   310,     0,   697,  1069,
    1966,   310,  1104,     0,  1064,  1091,     0,   326,     0,  1056,
       0,     0,   261,  1043,  1087,     0,     0,   211,   210,   212,
       0,     0,     0,     0,     0,     0,     0,     0,   794,   765,
     793,     0,     0,     0,     0,     0,     0,     0,   759,   358,
     335,   336,     0,     0,   334,   340,   689,     0,     0,     0,
    1475,  1471,     0,     0,     0,     0,     0,     0,  1491,   677,
       0,     0,     0,     0,  1192,  1192,  1192,  1192,  1192,  1192,
    1192,  1173,  1201,   135,     0,     0,     0,   536,   574,   581,
       0,   609,   612,     0,   610,     0,     0,     0,     0,     0,
     149,   136,     0,   717,   441,   172,     0,     0,     0,   529,
     674,   672,   671,   673,     0,     0,     0,   694,   670,     0,
    1465,  1467,     0,     0,     0,     0,   390,     0,     0,   387,
     391,   395,   396,   397,   444,     0,     0,   476,     0,     0,
       0,     0,   938,     0,   956,   939,     0,     0,     0,   978,
     983,   979,   959,     0,   513,  2289,  2283,  1322,  1323,     0,
     310,     0,     0,   576,   310,   310,     0,   310,     0,   310,
     310,     0,  1130,   602,     0,   659,     0,     0,   310,   730,
    1767,     0,  2428,  2616,   851,   443,     0,     0,     0,     0,
     862,     0,   511,   867,     0,   879,   874,   876,     0,   883,
    1300,  1293,  1295,  1294,     0,     0,  1291,  1773,   729,     0,
       0,   310,     0,   884,     0,   804,     0,     0,     0,     0,
    1369,  1774,  1775,     0,     0,     0,     0,  1809,     0,     0,
    1681,     0,  1657,  1659,  1492,  1671,     0,  1505,  1682,  1683,
    1661,  1663,     0,  1757,     0,     0,  1672,  1614,  1615,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1627,  1626,  1673,  1739,     0,     0,  1796,  1797,
    1674,  1535,  1536,  1536,     0,     0,  1803,     0,     0,     0,
    1679,  1684,     0,     0,     0,     0,  1690,     0,  1711,     0,
       0,     0,  1637,  1767,  1527,  1528,     0,     0,     0,     0,
       0,     0,     0,     0,  1611,  1594,  1588,     0,  1592,  1596,
       0,     0,     0,     0,  1580,  1606,  1576,     0,     0,  1582,
       0,  1607,  1364,  1364,  1364,  1364,  1361,     0,     0,     0,
       0,  1428,  1417,  1419,  1430,  1421,  1423,  1459,     0,  1840,
       0,  1402,  1373,  1373,     0,  1723,     0,  1646,     0,  1723,
       0,     0,  2478,  2480,  2481,  2482,  2483,  2484,  2486,  2487,
    2489,  2490,  2491,  2479,  2485,  2488,  2492,  2469,  2470,     0,
    2460,  2461,   188,     0,   220,   207,     0,  2503,  1228,  1843,
       0,  1376,     0,  1758,   927,   925,   926,  1378,     0,     0,
    1413,  1412,  1411,  1386,  1288,     0,  1286,  1281,     0,  1282,
    1823,     0,  1278,  1311,     0,     0,  1464,     0,  1310,     0,
    2403,  2331,     0,     0,  2502,  2505,  2516,  2514,  2341,  1092,
    1025,  1070,  1192,   894,   895,     0,   893,     0,     0,     0,
     429,   910,     0,     0,     0,   651,     0,     0,   433,     0,
    1206,     0,   544,   545,     0,     0,   563,     0,     0,   552,
       0,     0,     0,     0,   551,   568,   517,   569,   571,     0,
       0,   570,   573,   578,  1067,     0,   614,  1047,     0,  1089,
     961,     0,  1493,   936,   941,   942,     0,     0,     0,   403,
       0,     0,     0,   266,   276,     0,     0,   280,     0,   274,
     294,   286,   295,   287,   589,   590,   588,   584,     0,   591,
     593,   315,     0,     0,     0,  1099,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1100,  1076,     0,
       0,   141,   140,     0,   147,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   327,   312,     0,
       0,     0,     0,     0,   329,     0,     0,     0,     0,  1098,
    1034,   760,     0,     0,   761,   769,     0,     0,   762,     0,
       0,     0,     0,     0,     0,   771,   361,     0,   364,   371,
     344,   348,  1210,     0,  1210,     0,   349,  1210,   345,  1210,
     342,   691,     0,  2014,  1747,  1748,   685,   692,   682,   684,
     683,   686,   651,     0,     0,     0,  1476,     0,  2717,  2725,
    2724,     0,  1550,   679,   680,     0,  1192,  1191,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   415,
       0,     0,   409,     0,     0,   983,   402,   405,   406,   537,
     540,   538,   539,   567,     0,   608,     0,   581,   151,     0,
       0,   152,   150,     0,   317,   386,     0,     0,   632,   635,
     628,     0,   693,   695,   668,     0,   581,     0,  1277,   485,
       0,   472,   422,   468,     0,   470,   469,   471,     0,   478,
     316,     0,     0,   911,   937,     0,     0,     0,   976,   980,
     977,     0,     0,   952,     0,   960,   930,  1125,  1126,  1123,
    1124,     0,     0,  2306,  1313,  2315,   995,     0,   310,   993,
     733,     0,   724,     0,   726,   997,   310,   310,   619,     0,
     526,     0,     0,     0,     0,   861,   881,     0,   877,     0,
       0,   844,   886,  1298,  1296,   889,     0,   845,   888,     0,
       0,     0,     0,     0,  1778,  1511,     0,  1811,  1807,     0,
    1654,  1779,     0,  1791,  1790,  1613,  1792,     0,  1632,     0,
       0,  1624,  1622,  1623,  1616,  1617,  1618,  1619,  1620,  1621,
    1625,  1801,  1800,  1794,  1795,  1531,  1529,     0,  1676,  1677,
    1678,  1802,  1685,     0,  1897,  1712,  1689,  1705,  1704,     0,
       0,     0,  1692,     0,     0,  1701,     0,  1741,  1517,  1550,
    1556,     0,     0,  1579,  1806,  1597,     0,     0,     0,  1575,
       0,     0,     0,     0,  1584,  1757,     0,     0,     0,     0,
       0,     0,  1355,  1354,  1360,  1337,     0,  1430,     0,  1429,
    1441,     0,     0,  1447,  1445,     0,  1447,     0,  1447,     0,
    1422,     0,  1424,  1441,     0,  1841,  1460,     0,  1404,     0,
       0,  1372,     0,  1723,  1653,  1726,  1721,  1722,  1771,  1647,
    1858,     0,  1769,  1723,     0,     0,     0,  1820,  2501,  1348,
       0,  1377,  1394,  1387,     0,  1462,  1287,     0,     0,  1284,
       0,     0,     0,  1305,  1286,  1308,  2347,     0,  2402,  2467,
    2468,     0,   900,   901,   899,   902,     0,     0,     0,   651,
       0,     0,   449,     0,   918,   918,     0,     0,   435,   481,
     983,   654,     0,     0,     0,   652,   310,  1030,     0,   564,
       0,     0,   560,   558,   557,   559,   518,  1108,  1031,     0,
       0,     0,     0,   962,     0,   954,  1046,     0,   400,     0,
     271,  1068,     0,     0,     0,   270,     0,   310,   310,   586,
     319,   320,   323,     0,     0,     0,     0,     0,     0,   718,
     701,     0,     0,   719,   720,     0,     0,     0,  1000,  1001,
     999,   145,   142,   143,   146,  1042,  1086,  1040,     0,  1080,
    1051,  1049,     0,     0,     0,     0,     0,  1107,  1063,  1084,
    1106,  1061,  1082,  1060,  1081,  1062,  1083,  1054,     0,  1469,
     699,   698,     0,   310,   310,   621,  1044,  1088,     0,   763,
       0,     0,   764,   775,   773,   772,   774,   766,   362,   135,
       0,   341,     0,   369,     0,   367,   366,   368,     0,   355,
       0,     0,     0,     0,     0,   661,     0,     0,     0,  1472,
       0,     0,     0,     0,     0,     0,  1477,  1485,   650,     0,
    1183,  1182,  1181,  1185,  1184,  1187,  1186,  1178,  1177,  1190,
    1189,  1176,  1175,  1180,  1179,     0,   407,     0,   413,   417,
     418,   416,   408,   983,   441,   480,   535,     0,   611,   606,
     154,   153,     0,     0,     0,     0,   637,   641,   669,     0,
    1468,   615,     0,   388,   485,     0,  2272,     0,   393,   398,
     399,     0,   476,   419,     0,   472,   392,     0,     0,   482,
    1170,     0,     0,   940,   957,   958,     0,     0,   983,   982,
       0,   520,     0,  2279,   310,   577,   310,   310,  1131,   660,
       0,   873,   872,   871,   512,     0,   875,   310,     0,     0,
       0,     0,     0,   814,   795,   813,  1810,  1670,  1680,  1789,
       0,     0,  1633,     0,     0,  1675,  2155,     0,     0,     0,
       0,  1709,  1710,  1691,     0,  2005,  1696,     0,     0,     0,
    1861,  1603,  1601,  1598,     0,  1599,     0,     0,  1581,  1577,
       0,  1583,  1608,  1359,  1358,  1357,  1356,  1432,  1439,     0,
    1420,     0,  1446,  1442,     0,  1443,     0,     0,  1444,     0,
       0,  1439,     0,     0,     0,     0,  1717,  1723,  1723,  1648,
    1728,  1725,     0,  1650,  2471,     0,  2474,  2472,  2473,  2477,
    1550,     0,     0,  1280,  1283,  1285,     0,  1312,  1303,  2404,
    1198,     0,     0,     0,   431,     0,   983,     0,     0,     0,
     921,   921,     0,   983,   480,   656,   655,   658,   653,   657,
    1207,     0,   553,   554,  1048,     0,  1090,  1052,   955,     0,
     582,   267,   268,   269,   272,   312,   279,   273,     0,  1101,
    1035,  1077,     0,     0,   707,     0,     0,     0,     0,  1102,
    1036,  1078,     0,     0,     0,     0,  1216,     0,   311,   312,
     328,  1065,     0,   767,   768,   343,     0,   365,   374,     0,
     372,   346,   351,     0,   353,   352,   347,   350,  1473,     0,
    1014,  1014,  2718,  2719,  2720,  2721,  2722,  2723,     0,   651,
    1188,     0,     0,   404,   480,   448,     0,   410,     0,     0,
       0,   388,   581,   636,     0,     0,     0,   696,   390,     0,
    1275,   483,     0,   389,     0,     0,   478,     0,     0,     0,
     476,     0,   473,     0,   477,     0,  1165,     0,     0,   981,
       0,   985,     0,   951,   928,  1461,     0,   524,  2305,  2309,
    1015,   725,   727,   620,   878,   885,   310,   796,   797,   798,
     799,  1628,     0,     0,     0,     0,  1686,     0,  1687,  1714,
    1713,  1693,  1697,     0,  1694,  1695,  1600,  1604,  1602,  1585,
    1431,     0,     0,  1433,     0,     0,  1435,  1437,     0,     0,
       0,     0,     0,  1844,  1723,  1401,  1403,     0,  1338,  1651,
    1652,     0,  1373,  1723,  2476,  2475,   221,  1759,  1463,  1309,
     879,     0,   310,   918,   480,   450,  2014,   451,   917,     0,
     919,   924,   924,     0,   480,   651,   546,     0,   580,     0,
     314,   322,     0,     0,   714,   702,     0,     0,   721,  1050,
       0,     0,     0,     0,     0,   310,   770,   333,   360,   370,
       0,   354,  1014,     0,  1011,  1010,   649,     0,   439,   411,
       0,   459,     0,   581,   711,  1170,   594,   638,   639,   634,
       0,     0,   472,   468,   484,   394,   403,   377,   428,   427,
     424,   423,   425,   426,   421,   420,     0,   478,   474,   475,
       0,     0,     0,  1218,     0,   912,   984,     0,     0,     0,
     519,     0,     0,   523,   514,     0,  2307,   846,  1629,     0,
    1630,     0,     0,     0,  1699,  1698,     0,  1440,  1449,     0,
    1436,  1434,  1425,     0,  1427,  1716,  1718,     0,     0,  1731,
    1649,   896,     0,   897,   921,   454,     0,   920,   927,   927,
     441,   651,   432,  1053,   583,     0,   275,     0,   705,     0,
     716,   714,     0,     0,  1212,     0,  1213,  1214,  1217,   330,
     373,  1009,  1013,  1012,     0,     0,   412,   445,   446,   447,
       0,   414,   455,   456,     0,   607,     0,     0,  1166,     0,
       0,   476,   472,   401,   467,   375,     0,  1167,     0,   317,
       0,   983,   986,  1129,   522,   521,  2310,  2312,  2311,     0,
    1631,  1702,  1688,  1715,  1700,  1438,     0,  1426,     0,     0,
    1727,     0,     0,     0,     0,   924,     0,   651,     0,   915,
     914,   448,   434,   313,     0,     0,   712,   715,   703,   716,
     723,   722,     0,     0,   438,     0,     0,     0,   457,     0,
     458,   479,   710,     0,   640,     0,   478,   476,  1168,  1169,
     478,   913,   929,  1128,  1127,  1350,  2308,  1448,  1719,  1720,
    2120,     0,  2095,     0,  1729,  1732,  1730,  1724,   310,   927,
       0,   436,   452,   459,     0,     0,   704,  1215,   641,   464,
       0,   463,     0,   461,   460,   700,   644,   378,   478,  1461,
    1111,  1350,  1110,  1112,  1120,  1117,  1119,  1118,  1116,     0,
    1736,  1735,  1734,  1738,  1737,   898,   916,     0,   651,   706,
     713,     0,   462,   466,   465,     0,   642,   645,   648,   646,
     647,   376,   903,     0,  1121,  1115,  1337,  1324,     0,   453,
     437,     0,   622,     0,  1113,  1350,  1733,     0,   643,  1114,
       0,   644,     0,   623
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4544, -4544,  3810, -4544, -1162,  -378,  2360,  -849, -4544, -4544,
   -4544,  2968, -4544, -4544, -4544, -4544, -4544, -4544, -4544,  3003,
   -4544, -4544, -4544,  1575, -4544, -4544,   -48, -1551,  1835,  2622,
    1253, -4544, -1353, -4544, -4544,  -806,     1,  -551, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -1070,  1718,  1089,  2274,
   -2674, -4544, -1659, -3688, -4544,   499, -4544, -4544,  1664, -4544,
   -4544, -4544,   952,  -290, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544,   -16, -4544, -4544,  -462, -1834,  -132,   -84,  -328, -4544,
   -4544,   338,  -327, -1672, -4544, -3519, -4544,   -46, -4544, -4544,
   -4544,  -332, -1670,  1184, -4544,  -958, -1370,  1497,  -616, -4544,
    -211, -4544,  -665,  -564,  -561,  -622,  -458, -3694, -4098, -4174,
   -3016,  1198, -4544,   -53, -1819, -4544, -4544, -1749, -1681, -4544,
    -790, -4544, -4544, -4544, -2976, -4544, -4544, -4544, -4544,   -71,
   -4544, -4544, -4544, -4544,   405, -4544, -4544, -4544, -4544, -4544,
   -4544, -2784,  1639,  1642, -4544, -4544, -3183, -4544, -1169, -4544,
     548, -2992,  1123, -4544, -4544, -4544,  2323, -4544, -4544, -4544,
   -4544,   406, -4544,   408, -4544, -4544, -1830, -4544, -4544, -1809,
   -4544,  1654,   940, -4544, -4544, -4544,  -639,  -701,  -692, -4544,
   -3476, -4544, -4544, -4544, -4544, -4544, -1229, -4544,   992, -3129,
   -1198, -4544, -4544,  1007, -4544, -4544, -4544, -4544,  -598,  -209,
    2350, -4544,  -502,  -579, -4544, -4544, -4544,  -206, -4544, -4544,
   -4544, -4544, -4544, -4544, -1313,  4494, -1807, -4544, -4544, -4544,
   -4544, -2441, -4544, -4544, -4544, -1959, -4544,  4077,    12,  -105,
   -1793, -4544,  -204,  -112,  2862, -1372, -2711,   349,  -350, -4544,
   -2008, -4544, -4544, -4544, -2579, -4544, -4544, -4544, -4544, -3455,
   -1790, -4544, -4544, -4544,   399, -4544, -4292, -3907, -4196, -3718,
   -3434, -4544, -4544, -1310, -4544, -4544, -4544, -1653,  1841, -1697,
   -4544, -2310,   400, -3712,  -993, -3252, -4544, -3632,  -431, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -1304,  -856, -4544, -4544,
    3389, -4544, -3612, -4544, -4544, -4544, -4544,  1307, -4544, -1683,
    1080, -4544, -4544, -4544, -4544, -4544,  -585,  -664, -4544, -4544,
   -4544,   158, -4544, -4544, -4544, -4544,  1895, -1175,  -991,  3222,
   -1786,  -389, -4544, -4544, -4544, -4544, -3007, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544, -1555, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544,  2040,  2041,  -108,  -199, -4544, -4544, -1468, -4544,
    -794, -4544,  2286, -4544, -4544, -4544, -4544,  1347,   206,   442,
     -74, -4544, -4544,   235, -3397,   -72, -4544, -4544, -4544, -4544,
    -216,   -68, -4544,   707, -4544, -4544, -2827, -4544,   252,   -79,
    2941,  1609,   -62,   386,  -245,  -220,  -215,   -75,  3232,  2719,
   -4544, -4544, -4544,  -197,  1990, -4544, -1086,  -357, -4544,  1367,
    -894,  2031,  2707,  2710, -4544,  1366, -4544, -4544,  1375, -4544,
   -4544, -4544,  -893,  2043, -4544,  2706,  2061, -4544,  1359,  1368,
   -3359,   814, -3348,   308,  -948,  -263,   -61,  3270,  2731, -4544,
   -4345,   743, -4544, -3544, -2401,  1862, -2106, -1824, -4544, -4544,
   -1404, 10466, -4544, -4544, -4544, 12089, 14368, -4544, -4544, 16274,
   19272, -4544, -1228,   856, 19392, 11225, -1437, -1849, -1516, 18844,
    1542,  -808, -2732, -4544, -4544, -4544,  -230,   873,   241, -4544,
   -4544, -4544, -4544,  -472, -2830,  -468, -4544, -4544, -4544,  -470,
   -4543, -1652, -4544,  -827, -4544, 19718,  1404, -4544, -1346, -2736,
   -2742, -1398, -1956, -4544, -4544, -4544, -4544, -4544, -4544, -4544,
   -1489, -3256,  -475,  1481, -4544, -4544,  1574, -4544, -4544, -4544,
   -1533, -1126, -2665,  1487, -2144, -4544, -1089,   770,  2176, -1037,
    6228, -1500, 16158,  -124, -2326, -1509, -1766, -4544,  -113, -4544,
    2564,  2827,  -835,  -141,  -826,  6377,  4080,  5257, -3095, -4544,
   -4544,   259, -4544, -4544, -4544,  3743,  1023, -4544,  3071, -4544,
    1716,  2427, -4544, -4544,  2056,  -935,   -51, -4544,  -433, -4544,
    -134, -4544, -4544, -4544,   155, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544, -4544, -4544,  2749, -4544, -4544, -1444, -4544, -4544,
   -4544, -4544, -4544,  4004,  -304, -4544,  3431,  -283, -4544, -4544,
   -4544, -4544, -4544, -4544, -4544, -4544, -4544,  2758,  2091, -4544,
    3230, -4544, -4544, -4544,   -47,  2966, -4544, -4544, -4544, -1163,
    -577,  3252,  3256,  2054, -4544, -4544, -4544, -4544, -4544, -4544,
   -4544, -4544,  2064, -4544, -4544,  1472, -2127,  2068, -4544, -4544,
     795, -4544, -4544,   347, -4544,   800, -4544,  2867, -4544, -4544,
   -4544,   843, -4544, -4544, -4544,  -595, 13800,    87,   -94,    59,
    1302, -4544,  8573,  7866,   -95,  2781,   -14, 11450, 18684,    78,
   -4544,  4003,  2074,  1702, -1002, -4544,  4134,  2377, 17315, -4544,
    -986,    28,  1358, -4544,    -2,  -653, -1160,  3068,  -743, -1947,
   -4544,  4414, -4544, -3588, -4544, -1040,  3441, -1194
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
      -1,     1,   247,   248,  1701,  2600,  2481,  3290,  3291,   249,
     250,  1772,   251,   252,   253,   254,   255,   256,   257,  1716,
     258,   259,  1279,  1914,  2608,   260,  2357,  1055,  1056,  2229,
    2230,  2545,  2231,  2218,  1552,  2014,  1735,  1703,  1736,   262,
     263,  1546,  2210,   264,   265,   266,  1760,  1761,  1711,  1957,
    4189,  4756,  2468,  3329,  3129,  3130,   267,  1814,  1815,   268,
     269,  3242,  1853,  3244,  3245,  3780,   865,  2569,  4209,  4210,
    3767,  3768,  4216,  4489,  4490,   270,  1911,  3318,  3861,  3319,
    4287,  3320,  4288,  3321,  4289,  3272,  3826,  3827,  3828,  3322,
    4293,  4694,  3323,  2372,  4776,  2642,  2044,  2042,  4671,  4091,
    4092,  4827,  4781,  4782,  4783,  4893,  4295,  3327,  3869,  4299,
    4517,  3032,  1933,  4286,   271,   272,  2636,  1788,  1789,  2489,
    3786,  3383,   273,  1296,  3645,  4557,  4713,  4714,   274,   853,
     275,  1918,   276,   277,  2595,  3277,   278,  2384,  3045,   279,
     280,  3070,  3071,  3072,   281,   282,  3669,  4449,  1762,  3122,
    3123,  3124,  3125,  3689,   283,  1916,  1794,  2617,   284,   285,
     286,  2599,  3283,  3284,   287,   288,  2532,   289,   290,   291,
    1926,  2629,  2630,  4277,  4524,  4679,  4526,  4925,  4926,  4509,
    3628,  4105,   292,   293,   294,   295,  1897,  2588,  2589,  3787,
    1687,  1857,  2571,  2572,  3851,  3852,   296,   297,  4149,  4150,
     895,  4787,  4760,  4838,   298,   299,  4153,  4154,   300,   301,
     302,   303,   304,   948,  1347,  1348,  1693,   305,  2246,   306,
    1254,  3229,   307,  1435,  2775,  4334,   308,   982,  1372,  1373,
     309,   310,   993,  2755,   995,  2057,  3385,  3386,  3921,  2725,
    1179,   311,   312,  2736,  2758,   313,  1704,  2363,  2364,  4086,
     314,   896,  1938,  2645,  3027,  4704,  4093,  4430,  4631,  2950,
    3577,   315,   897,  1740,  2430,  2648,  3333,  3334,  2432,  2914,
    3882,  2434,  3335,  3340,  3341,  3342,  3878,  3886,  4551,  4552,
     316,  1738,  2423,   317,   318,   319,  1767,  1197,   320,   918,
     919,   321,  4664,   322,  1315,   323,  1013,  2073,   324,  2446,
    3675,   325,   326,   327,  4902,  4933,  4934,  4935,  3891,  4865,
     328,  4904,  1414,   330,   331,   332,   856,  1222,  1223,  1224,
     333,  4546,   334,   335,  2592,  3271,  3808,   336,   337,  2358,
    3017,   338,   339,   340,  1901,   341,   342,   343,   344,  1833,
     345,  1583,  1584,   346,   347,   860,  1074,  1587,  1595,   348,
     961,  1366,  1367,  1368,  2016,   349,  1418,  2747,   962,  1361,
     963,  2968,  3588,  3589,  3592,   964,  2965,   353,  2063,  2741,
    2744,   965,  2972,  2973,  2974,  2975,  2976,  3594,   966,   984,
    1306,  2656,   967,  1506,   358,   359,   360,  1083,  1078,  1079,
     362,  2188,  2904,  1001,  1601,  1040,  1090,  4041,  2260,  2261,
    2281,  2282,  1610,  1611,  2271,  2273,  2952,  2274,  2961,  2266,
    4038,  4396,  2277,  2278,  1613,  1614,  2956,   363,  2908,  3522,
    3523,  3524,  4019,  4029,  4383,  4596,  3525,  1408,  1620,  3526,
    3531,  3586,  3309,  3310,  3311,  2435,  2579,  1879,  1507,  1880,
    2586,  1508,  2108,  1882,  1509,  1510,  1511,  1885,  1512,  1513,
    1514,  1515,  2091,  2151,  1516,  1517,  2127,  1122,  1123,  2001,
    2814,  1519,  1520,  3985,  4358,  4347,  2840,  2841,  2226,  3981,
    3474,  4608,  4735,  4736,  4049,  4046,  4400,  4612,  4823,  4874,
    4875,  1521,  2894,  2180,  1199,  1522,  3789,  2182,  2834,  2916,
    2917,  2342,  2089,  2780,  2797,  2798,  2811,  3435,  2818,  2823,
    3458,  3459,  2835,  2863,  1523,  2783,  2784,  3418,  2093,  1524,
    1576,  1577,  2196,  2858,  1590,  1591,  1076,  1525,  1526,  2058,
    1065,  4592,   711,   694,  3139,  2241,  1226,   998,  1527,  1528,
    1529,  1323,  1324,  1642,   656,   695,   696,  1160,   807,     2,
      75,   968,  3315,   367,   368,   899,   900,   901,  1298,  1299,
    1943,  1946,  1647,  2320,   660,   661,   712,  4313,  4558,  4716,
     954,   369,   370,   371,   372,  1643,  2316,  1124,    76,    84,
      77,  1125,   409,   410,  2297,   373,   824,   374,  1623,  1104,
    3600,   375,   376,   377,   378,   379,   951,   380,  1106,   381,
    1107,   382,   383,   384,   385,  1114,   386,  1625,  1626,  4078,
    1627,   387,   388,   698,   699,  1359,   389,   390,  1141,  1142,
    1391,  1392,  1653,  1668,  1669,  1670,   391,   668,   392,   393,
     394,  1659,  1660,   395,  2203,  2204,  2325,  2205,   396,  2989,
    2990,   397,  3557,  3558,  4407,  3559,   398,  2199,   399,   400,
    1068,  3605,   401,   820,   402,  1155,   700,   701,   702,  1162,
     810,  1026,   713,  1164,  3126,   812,   813,   704,   705,   706,
    2036,    78,  2997,  2037,  1531,   714,  1532,  2194,  1533,  1534,
    1535,  1536,  1537,  1676,   708,  1131,  1351,  1352,  2998,  1354,
      82,  1355,   406,  3801,  2004,  1393,  2022,  2023
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      81,  1082,  1091,   361,   351,  1032,   352,  1615,  1547,  1621,
     354,  1963,  1967,  1198,  2002,  2013,   356,   710,   894,  2069,
     910,  1569,   811,   808,  1276,  1973,   986,   716,  2041,   898,
      79,  1067,  1400,  1401,  1402,  2371,  1793,  1688,  1406,  1771,
    2584,  2726,  2433,   697,  2243,  3401,   986,  1910,  1831,  2576,
    2129,  1818,  2693,  1198,  2102,  2103,  1928,   960,  2080,   994,
    1856,  1561,  1139,   858,   404,  2451,  2547,   811,   808,  1007,
     404,  1101,  2442,  2118,  2443,  2922,   405,  1329,   912,   261,
    2609,   697,   405,  3537,  2585,   854,  2431,   665,  3885,   947,
     361,  1308,  1102,  3651,  2254,  2610,  3833,  1033,  2464,  2634,
    1332,  1899,   902,   909,  1903,  2611,  1198,  2501,  2942,  1907,
    1344,  1307,   909,  2510,  1954,   405,  1912,  2304,  2306,  2307,
    3196,  2612,  3089,  3091,  2613,  1930,  3238,  3684,  2614,  3686,
    2257,  2779,  3804,  1369,  1787,   811,   808,  1798,  1671,  1143,
    4061,  1093,  2514,  2515,  3593,  1823,  1094,  3141,  1085,  4098,
    4128,   904,   909,  3790,  1673,  2243,  4273,  3389,  2685,  2146,
     405,  4016,  1064,  4088,  1364,   403,  3790,  4292,  1054,  3534,
    4308,   403,  2646,  3532,  3533,  3527,   809,  4030,  4032,   983,
    2419,  3482,  2637,  2349,  2298,  2298,  1737,  2028,  4431,  4066,
    2980,  3439,  1998,  4265,  4536,   815,  1609,  1612,  2003,   983,
    1649,  1650,  3963,  3604,   403,  2201,  1029,  1353,  1134,  4230,
    4709,  1955,  2155,   412,  1029,  1927,  1029,   412,   864,  2095,
    2096,   809,  1308,  2149,  2244,  4429,  1955,  1156,   405,  2521,
    2996,    45,  3527,  1955,  3000,  4632,   329,  2158,  2631,   408,
     815,  3416,  1554,   913,  3217,  2115,   855,  2445,  -363,   403,
    3542,  2061,  1302,  3543,  3544,  1713,  4705,  3876,  3809,  3810,
    3811,  3812,  3813,  3814,  3545,  3546,  3547,  2160,  3548,  3549,
    2526,  2856,  4759,  3550,  3551,  3552,  3293,   666, -1851, -1851,
   -1851, -1851,  3647,  3390,   350, -1851,  1028,  3652,  3439,   809,
    1108,  1431,   361,   351,  1028,   352,  1028,  4173,  1850,   354,
   -2576, -2576, -2576, -2576,  2851,   356,  2445, -2576,   815,   412,
    1109,  2856,  3598,  1095,  2508, -2576,  4225,   403,    43,  3134,
    1110,  2005,  3392,    45,  2723,  2737,  1397,  4909,  1389,  -751,
     355,  1641, -1526, -1526, -1526, -1526,  2445,   366,  2452, -1526,
    4724,    37,    38,    39,    40,  3357,  4835,  3359,    44,   412,
    2374,  4772,    37,    38,    39,    40,  2264,  1714,    43,    44,
    1130,   404,  4687,    45,  1662,  1416,  2445, -1745,   261,  1538,
    -135,     3,  1088,   405, -1745, -1536, -1536, -1536, -1536,  -135,
    2147,  3399, -1536,  3053,  -135,  1844,  1831,  1663,  1096,  1540,
    2632,  1895, -1526,  1072,  1763,  4946,   404,  4845,  2891,   130,
     131,   411,  2377,  4836,  2192,  2892, -1761,  1177,   405, -2577,
   -2577, -2577, -2577, -1761,  1198,  3553, -2577,  2757,   821,  1111,
     822,  4438,   412,  2907, -2577,    37,    38,    39,    40,  1267,
    1539,    43,    44,  1437,  1664,   412,    45,  1318,  1692,  2129,
    2245,  2738,  4697,  2265,  4174,  2186,  1551,  1389,  1651,    45,
   -2574, -2574, -2574, -2574,  3240,  1563,  1956, -2574,  2365,   715,
    2102,  2103,   403,  1838,   357, -2574,  3051,  2118,  4434,  2816,
    3251,  1956,  3391, -2573, -2573, -2573, -2573,  1398,  1956,  4129,
   -2573,  1112,  1955,  2816,  3865,  2189,  4773,   914, -2573, -1536,
   -1536, -1536, -1536, -2003,  3652,  1974, -1536,   403,   825,   898,
    3135,  3648, -1526, -1526, -1526, -1526,   667,  2782,  4861, -1526,
    2062,  3393,  4208,  1390, -2169, -2169, -2169, -2169,  4725,  1308,
    1158, -2169,  1580,  4795,  1581,   329,  2235,  2236,  2367, -2169,
    2554,  3074,  2897,  1137,  1138,   866,  3218,  2633,   826,  1991,
    2558,  1102,  1308,  3554,  2724,  2368,  2721,  1113,  4825,  4039,
    2727,   357,  2729,  1766,  4932,  2732, -1493, -1493, -1493, -1493,
    1652,  1655,  1684, -1493,  4141,  1128,   915,  3877,   916,  2059,
    1405,  2522,   902,   350,  2062,  2857,  2017,  1097,  2015, -1506,
   -1506, -1506, -1506,  1574,  2071,  2527, -1506,  1575,  3555,  1993,
    2509,  2150, -1521, -1521, -1521, -1521,  2081,  1658,  3790, -1521,
     246,  4540,  3451,  2576,  1965,  4081,  2453,  1997,  1308,  1715,
    1896,  3920,  2739,  4424,  2243,  3502,   909,   909,  2454,   355,
    3718,   904,  2497,  2179,  2499,  2506,   366,  2574,  2084,  3093,
    2740,  4514,  1081,  1390,  2095,  2096,  1038,  2550,  1135,   980,
     981,  1417,  2115,  4503,  4504,  4505,  4506,  4507,  2951,  2405,
    4119,  2202, -1521,  1178,  4269,  2546,  3241,  1564,  1654,  2243,
    1405,  4846,  4380,  2921,  1130,  2463,  4384,  1896,  1073,  2455,
    2714,  2369, -1745,  4281,  3254,  1268,  4554,  4418,  2378,  2689,
    3556,  1185,  4897,  1319,  1136,  2187,  4899,  2187,  4339,   823,
    1965,  2570,  4439,  4856,  2155, -2003,  3448,  3449,  3450,  3451,
    3621,  2873,  3595,  2893,  1574,  4044, -1851,  1171,  1575,  1839,
    1389, -1761,  3052,  2321,  1082,  1159,  4744,  2090,  1565,  2158,
    3075,  2285,  2286,  1180,  4931,  1147,   808,  1956, -2576,  1039,
    1308,  1639,  1640,  1427,  2722,  3088,  1616,  3163,  1308,  1308,
    2776,  2778,  1389,  2733,  1144,  2422,  1599,  1092,  1263,  2160,
    2214,  2786, -1325,   357,  1258,  2790, -2003,  1582,   859,  4898,
   -1526,  1370,  1705,  2802,  2803,  2370,  2155,  1700,  3098,  2219,
    2124, -2003,  4405,  1304,  2232,  2232,  2820,  2822,  3664,  3751,
    3665,  3439,  3754,  3755,  1143,  1207,  3758,  2836,  3527,  2125,
    1253,  2158,  -135,  -135,  4624,  1828,  3765,  3561,  4052,  4239,
    2276,  4634,  1317,  2126, -1533, -1533, -1533, -1533,  1312,  4146,
     404, -1533,    37,    38,    39,    40,  1630,  1321,   405,    44,
    3887,  2160,   405,  1362, -1325,  2874,  1167,  2704,  1371,  2875,
    1377,  3567,  1382,  2707,  1167,   665,  1998, -2577,  1386,  1600,
     665,  3009,  2697,  1390,  1665,  1666,  4600,  2718,  4602,   665,
    2966,  1365,  4863,  2982,  1130,  2982,   909,   980,   981,  4151,
    1713,  1377,  1382,  1093,  1706,  1167,  2876,  1378,  1094,  2373,
    2419,  1383,  1384,  1385,  2163,  2164,   665,  1363, -2574,   809,
     665,  1396,  1803,   361,  2124,  2806,  2807,  2090,  2640,  4665,
    4094,   665,  1376,  3815,  1381,  3888,  2374,  4688,   815,  3756,
    3757, -2573,  1358,  2125,  1395,  4147,   909,   403, -1328,  1305,
    3699,   403,  2478,  4748,  4749,   665,  4311,  2128,  2167,  1167,
    1804,  3572,  1919,  1410,  1412,  4069,  3282,  1140,  1167,   665,
   -1526,  2407,  4261,   665,  1115,  1218,  3818,  1981,  3788,  2413,
    1407,  1198, -2169,   665,  1829,  4689,   861,  2606,    81,  1427,
    2433,  3788,  4690,  4082,  1404,  4152,  2501,   665,  4282,  1009,
    1920,  3441,  1714,  2696,  4711,  1585, -1325,  1357,   412,    37,
      38,    39,    40,  2640,  2735,  1982,    44,  2643,    79,  4691,
   -1328,  1145,  2877,  1375,  2101,  1380,  2487,  3274,  4791,  2490,
    2491,  1130,  4148,   697,  4131,  4801,  3670,  1544,  1550,  1116,
   -2304,  2379,  1558,  1707,  3839,  4889,  1407,  2107,  2719,  2113,
    2114,  1965,  3700,  4864,  1409,  1411,  2730,  2731,  2147,  2607,
   -1521,  1088,  4593,  1219,  3889,  2375,  4911,  4597,  3883,  4590,
    4599,  1405,  2580,  4667,  1708,  1010,  1619,  2720,  1167,  1808,
      37,    38,    39,    40,  1029,  1809,   665,    44,  1029,  4692,
    4771,  2555,  2208,  1631,  1579,  1117,  3885,  4733,  1118,   215,
    3065, -1325,  1220,  1709,  4262,  4512,   405,  3065,  1805,  4777,
    3822,   412,  2641,  1167,    37,    38,    39,    40,  2379,  3564,
      43,    44,  1437,  1664,  3890,    45,  1188,  1189,  1190,   223,
    1191,  1192,  1193,  1194,  1195,  1196, -1325,  1116,  4857, -1325,
    2174,  2175,  2176,  2177,  2178,  2179,  3823,  4879,  1921,  1000,
    1221,  4860,  4712,  2209,  4083,  1835,  2674,  1719,  1008,  3824,
    3439,  1710, -1328,  1983,  1028,  1840,  1754,   233,  1028,  2666,
    4132,  3066,  1741,   665,   665,  4450,  4531,  2414,  3066,   236,
    2677,  1810,  4283,  4084,  3275,  1198,  1119,  3840,  2365,  1644,
    4912,  3701,  2684,  1117,  1806,   403,  2581,  4521,  3394,  4752,
    2816,  2816,  4085,  2302,  2366,  2816,  4742,  4793,  1674,  4862,
    3671,  4651,  1702,  2967,  2176,  2177,  2178,  2179,  3078,  4778,
    1939,  3258,  3702,  1369,  4890, -2304, -1848,  3446,  3447,  3448,
    3449,  3450,  3451,  2561,  1922,  3672,  3539,  2930,  3540,  3640,
    3825,  4923,  2559,  1011,  1012,  2816,  2816,  2380,  4700,  1984,
    4693,  3703,  1644,  4399,  2700,   955,  4701, -1328,  2367,  2303,
    2415,  2483,  3276,  4403,  3380,  1941,  1167,  3395,  2947,  2155,
    4133,  2562, -1533,  4134,   956,  2368,  1167,  3641,  2580,  4730,
    2152, -2304,  4779,  1120,  1119,  4417,    37,    38,    39,    40,
    4891,  2301, -1328,    44,  2158, -1328,  1088,  2560,  1894,  1830,
    1082,  3079,  1121,  2809,  2124,   957,  2018,  1062,  2536,  2020,
    4532,  4652,  2024,  4892,  2026,  4832,  1948,  2029,  3662,  3069,
    1811,  2033,  2381,  2125,  2160,  3093,  3069,  1948,  3190,  3527,
    2895,  1167,  1198,  3527,  2019,   361,  2021,  4052,  4393,  2025,
   -2578,  2027,  1037,  1116,  2030,  2031,  2032,  2948,  2944,  4402,
    1119,  1812,  4199,  2815,  4829,  4830,  2302,  2039,  4202,  4203,
    4204,  4205,  4206,  4207,  2463, -1493,  1949,  2838,   665,  4641,
    2064,  1439,  2065,  1671,  3439,  4924,   974,  2699,  -579,  4676,
    1813,  2582,   816,   665,   357,  1081,  4327,    81,    81,  1673,
      81,  4881,   817,  1293,  3354,  3355,   975,  2305,  1167,  1117,
      80,  2369,  2581,  3790,  1574,  1358,   665,  4702,  1575,  3097,
    3360,  3030,  2303,  3916,  2336, -1954,  2476,    79,    79,  2563,
      79,  2258,  2259,  3788,  2263,  3642,  1094,  1094,  2250,  1094,
    2433,  3300,  3301,  3302,  3303,  1102,  1644,  2190, -1493,  1605,
     974,  1098,   665,  3308,    37,    38,    39,    40,  2448, -2578,
    1923,    44,  4499,  2896,  1950,  1894,  3162,   665,  4635,  1439,
     975,  1086,  3439,  3031,  2625,  1950,  4541,  2752,  1143,   665,
    1924,  4604,   665,  3540,  3663,  3414,  2477,  3174,  4542, -1986,
    4500,  4221,  4940,  1167,   215,  4916,  3181,   664,  1119,  4259,
    1119,   818,  3182,  4075,  4280,  2370,  2268,  3934,   974,  2449,
    3350,  2609,  1951,  1119,   952,  2564,  1607,  3212,  2927,  1092,
    3568,  3643,  1167,  1951,   223,  1075,  2610,  2267,   975,  1087,
    2242,   808,  2501,  3947,  3466,  3948,  2611,  4222,   877,  3719,
    4785,   697,   697,  1665,  1666,  2206,  2207, -2004,  4669,  2626,
    1167,  1167,  2612,  1167,  1965,  2613,  1294,  2269,  2492,  2614,
    4260,   903,   233,  1754,  3441,  3491,  2183,   920,  2268,  3110,
    1167,  3616,  1790,  1218,   236,  2985,  3446,  3447,  3448,  3449,
    3450,  3451,  1069,   808,  2604,  4435,  3056,  3909,   862,   974,
    1952,  1034,  3065,   999,  1088,   879,   122,  2582,  3183,  3885,
    2146,  1952,  2635,  1791,   665,   877,  1619,  2222,   246,   975,
   -1954,  1295,   665,   665,   126,  1198,  2583,  4609,  4610,  2269,
    3111,  3442,  1167,   405,  1925,  4316,  4023,  4317, -2029,   819,
    4710,  1851,  1852,    37,    38,    39,    40,  1644,  4543,  1605,
      44,  3187,  1644,  1644,  2193,   697,  4436,  2242,   808,  2318,
    3949,  1167,  3441,  3095,  4024,  1167,  1167,  4022,  4745,  1776,
    3950,  1219,   879,  3066,   404,   404, -1954,  4566,  4751,  4386,
     825,  1084,  3188,   825, -1986,   405,   405,   405,  3018,  3263,
    4026,  2493,  3156,  2494,   809,  2174,  2175,  2176,  2177,  2178,
    2179,  2155,  3067,  2504,   412,  2400,   665,  4754,  1792,  3527,
    1220,  3189,  3112,   815,  3527,  1777,  1607,  3527,  1089,  3442,
     826,  3627,   403,   826,   404,   825,  3866,  2313,  2314,  3870,
    1269,  2340,  1270,  3068,  4023,  2627,   405,  2994,  3264,   886,
   -1986,   887, -2004,   405,  1894,  3206,  3156,  3184,  2628,  3258,
     405,  1809,  1608,  2332,  2334,  4094,  2160,  1029,  1221,  3164,
    3019,  1288,  4024,  3113,   892,   826,  3191,  3167, -1493,  3169,
    4620,  4341,  4622,  4342,   403,   403,   403,  4025,  3185, -1493,
    -386,  2101, -1493,  1692, -1493,  4028,  4537,  1218,  4026,  1029,
    1289,  1773,  1778,  1105,  2507,  3192,  4805,  1894, -2004,  2304,
    3446,  3447,  3448,  3449,  3450,  3451,   886,  3186,   887,  1644,
    4027,   809,  3639,  2034,  3265,  3266,   357,  1644,  1896,  4483,
    4484,  3069,  1774, -2029,  1894,   403,  4538, -2368,  3267,  4594,
     815,   892,   403,  1702,  1290,   412,  2035,  1028,  1779,   403,
    1780,  4640,  1556,  4740,  4442,  4443,  1689,  1810,  2816,    45,
    2500,  2816,  2816,  2816,  2816,  2816,  2816,  2816,  2816,  2816,
    2816,  2590,   808,  2212,  1644,  4655,  1605,  1644,  1644,  1028,
    1606,   412,  3026,  3268,   665,  1219,  4094,  1690,  1782, -2029,
    1702,  2816,  3228,  4028,  1308, -2578, -2578,  2088,  3446,  3447,
    3448,  3449,  3450,  3451,  1894,  2224,  2661, -1372,  4343,  4116,
    2658, -1372,  4677,     8,  3344,  2540,  1691,  2105,  3633,  2664,
    2816,  2816,  1140,  2573,  1220,  1784,    37,    38,    39,    40,
    4099,  1308,  2359,    44,  -911,  2310,  3527,  3193,  2311,  1644,
    4678,  1894,  2360,  1607,  2225,  2754,  2541,  2132,  2445,  3915,
      35,  3368,  1694,  1146,  1697,  3254,  2450,  2361,    41,    42,
    1786,  2144,  3599,  4101,   405,  1769,  3194,  4595,  3269,  1894,
    3270,  1365,  1221,  3653, -1372,    37,    38,    39,    40,  1608,
    1769,   665,    44,  1695, -1337,  1698,  3030,  1439,  3580,   208,
    3439,  3919,    37,    38,    39,    40, -1337,   665,  4406,    44,
   -1337,  3674,  4650,   361,  3848,  3562,  1180,  3991,  3382,  2702,
   -1372,  2703,  1696,  2937,  1699,  2705,  3944,  2706,  1560,  2921,
    2708,  1167,  1157,  4237,  2709,   809,  2312,  1894,  3920,   974,
    1167,  3149,   665,   665,  1102,  4102,  2753,   208,  3624,  2944,
    3964,  4120, -1337,   665,   815,    37,    38,    39,    40,   975,
     215,   903,    44,   403,  2465,   665,   665,  1092,  1092,  1272,
    1092,  1273,  2482, -1337,    81,   361,  2748,    81,  2749,  4101,
    1184,  2742,  2750,  3656,  2815,  2815,  4821,   665,  2751,  2815,
     223,  3150,  4130,  4135,  2774,  1770,  2362,  1700,  4103,  -157,
    4104,  2124,  3508,   827,    79,  3965,  3966,    79,  3926, -1337,
    1817,  4822,  2466,  2467,  -157,  2542,  2008, -1337,  2009,  4774,
    2125,  4656,   863,  1022,  -157,  1172,  2543,  1167,   233,  2815,
    2815,  1198,  1662,  1061,  2126,   917,   949,  1209,  3372,  -157,
     236,  3151,  2854,   808,  1216,  2921,  2463,  3493,  4094,  3494,
    2544,  4102,    35,   412,  3693,  1663,    37,    38,    39,    40,
      41,    42,    43,    44,  1167,  1167,  1217,    45,    43,  3694,
    1988,  3495,  1167,    45,   246,  1167,  3930,  3411,  1257,  1167,
    3441,  2695,  3998,  1308,  2800,  2343,  1035,  1167,  1167,  1288,
    1989,  3829,  2087,  4878,   246,  1167,  2124,  1700,  1167,  1167,
    1167,  1167,  3573,  3971,  4103,  2953,  4104,  3739,  1167,  1167,
    4419,  1167,  1700,  1167,  1167,  2125,  2344,  1167,  3846,  2232,
    4360,  1585,  2294,  2295,  3711,  2492,  3254,  3740,  3788,  2128,
    3152, -1337,  3608,  1894,  1167,   405,  3020,  3442,  3023,  1167,
    1260,  4333,  4359,  1167,  3282,  2345,  2816,  1167,  1262,  1167,
    1167,  1167,  1167,  1167,  1167,  1167,  1167,  1167,  2433,  1167,
     215,  2216,  1290,  3613,  3614,  1167,  2155,  4175,  1167,  3496,
    4290,  1574,    35,  4674,  3497,  1575,    37,    38,    39,    40,
      41,    42,  1148,    44,  1999,  1277,  3929,  4176,  2000,  1574,
     223,  2158,  1596,  1575,  1149,  1150,   809,  4218,  1308,  4220,
    1255,  3696,  4223,  1283,  4224,  2457,  2969,  2498,  2654,  2655,
    1086,  3014,  3536,   404,  1151,   815,  2197,  1152,  3632,  2198,
    4706,  2160, -1373,  1999,   403,   405, -1373,  2692,   233,  1291,
    1167,  3153,  3697,  4096,  4097,  2242,   808,  1439,  3258,  3154,
    3439,  1292,  3155,  2864,  2465,  2865,  1868,  1574,  2493, -1851,
    2494,  1575,  3046,  1297,  2511,  1309,   920,  3992,  1180,  1130,
    3412,  3698,    35,   404,  3413,   404,   412,  2866,  1087,  2217,
      41,    42,  2959,  2960,   246,   405,  2791,   405,   871,    37,
      38,    39,    40,  2248,  4944,  2249,    44,  4945,    80, -1373,
    3498,  2465,  2466,  2467,  1300,  1596,  3305,   665, -1325,  3714,
    3499,  3306,  3443,  3444,  3445,  2539,  3446,  3447,  3448,  3449,
    3450,  3451, -1396, -1396,   403,    81,  3844,    81,  3076,  2816,
    2816,  3073,  3805,  1644,   665, -1373,  2463,  3306,   405,   665,
    1314,  1153,   665,  1088,  3465,  3147,  3467,  3468,  1325,  2466,
    2467,  2792,  2465,  1674,  1415,    79,   808,    79,  3131,   808,
    4567,  4568,  4569,  4570,   665,  2465,   877,  1167,  2842,  1330,
    2867,  2845,  1339,  1167,   403,  2868,   403,  1831,  1154,  1167,
    2869,  3666,  1432,  2463,   357,  -905,  2101,  4022,  2350,  3325,
    3326,  1541,  3717,  4035,  4243,  1553,  1309,  1555,   665,   809,
    2466,  2467,  4321,  4322,  4323,  1345,  4215,  2793,  3720,  1029,
    2794,  3573,  4124,  2466,  2467,  1894,   950,  2101,   815,  2350,
    1894,  1894,  1360,   879,  3573,   665,   665,   403,    45,  2465,
    3441,  2251,  1894,  2252,  2463,  1399,  4040,  4042,  1308,  3748,
    1308,  3838,  1403,  3841,  1799,  2465,   357,  2463,   405,   665,
    2101,   405,  1692,  1424,  4023,  4900,   192,  1089,  3830,  1720,
    3832,  1419,  4121,  3296,  3297,    35,   412,  1413,   665,  3157,
    1029,  1425,   665,    41,    42,  1800,  2465,  2466,  2467,  1801,
      45,  4662,  4024,   664,   664,  1639,  1640,  3442,  1675,  1028,
     665,  1721,  2243,  2466,  2467,  1426,  2870,  4025,  2795,  2465,
     665,  1308,  1428,  2694,  1802,  2695,  2871,  1644,  4026,   809,
    3336,  2463,   809,   665,  2715,  1644,  2716,  1644,  4233,  4234,
    4235,  3880,   665,  3157,  2466,  2467,  2921,  2463,   815,  1720,
    4027,   815,  1427,  2717,   215,  2716,  1429,   403,  2862,  2745,
     403,  2746,  2943,  3002,  2944,  2746,  1722,  2466,  2467,  3541,
    1028,  4616,  2154,  1430,  3925,  2155,    74,   886,  2463,   887,
    3086,  1721,  3087,  1167,   223,  1894,  1433,  4195,   889,    37,
      38,    39,    40,  3143,  1434,  3144,    44,  1723,  1436,   891,
    2158,  2463,   892,  3246,  1562,  3247,  2159,  1559,  3157,  4364,
    1566,  3259,  3157,  3260,  2101,  2796,  2350,  3374,  1567,  2716,
    4550,   192,   233,  4028,  1568,  1854,  1082,  3931,  1586,  3410,
    2160,  2695,  1724,  3420,   236,  2695,  1722,  4348,  3424,  3428,
    2695,  2695,  2815,  3157,  1573,  2815,  2815,  2815,  2815,  2815,
    2815,  2815,  2815,  2815,  2815,  1894,  1593,  3404,   665,  1594,
    1439,  1725,  3406,  3439,  3429,  4309,  2695,  1723,  4901,  3512,
    1130,  3513,  3443,  3444,  3445,  3975,  3446,  3447,  3448,  3449,
    3450,  3451,  4473,  4474,   357,  4476,  2294,  2978,  1726,  4231,
    4232,  4233,  4234,  4235,  4245,   665,  3337,  4236,  2816,   215,
    3575,  3576,  1724,  1167,  2815,  2815,  1596,  2816,  1439,  1603,
    3455,  3439,  2695,  1309,  3517,  3518,  3519,    80,    80,  1727,
      80,  4227,  4228,   208,  2816,  2816,  1597,  1728,  4366,   223,
    1617,  1725,  1082,  1729,  2162,  3471,  1309,  2695,  2074,  2075,
    1730,   985,   665,  3476,  1618,  3477,  3770,  3514,  1731,  3515,
    3581,  3582,  3472,   808,  1894,  2163,  2164,  1732,  3479,   808,
    3687,   985,  3688,  1624,   665,  1733,  1644,   233,  1167,  3691,
    3835,  3692,  3836,  1167,  4231,  4232,  4233,  4234,  4235,   236,
    3874,  2066,  3875,  3935,  4502,  2695,  3972,  3771,  3973,  1167,
    1167,  1632,  3982,   208,  3983,  1167,  3994,  3338,  2695,  2167,
    1622,  1637,  1309,  1729,  3528,  4067,  4071,  4068,  4072,  1628,
    1730,  3772,  2168,   246, -1122,  1629,  1734, -1122,  2421,  1633,
    1167,  1167,  3440,  1634,  1635,  1167,  3773,  1732,  1636,  1638,
    3774,  4100,  4211,  2716,  4212,  1733,  1645,  1167,  1167,  1167,
    1167,  1646,  4365,  3441,  2746,   405,  1648,  4426,  3775,  4427,
    1167,   405,  4432,  1167,  2716,  1167,  1677,    37,    38,    39,
      40,  3528,  4495,  3776,    44,  1167,  1167,  1678,    45,  1167,
    4433,  4488,  2716,  1680,  4290,  2148,  3573,  4533,  1686,  4534,
     361,  2748,  1167,  2749,  1167,  2153,  1734,  2750,  1167,  1692,
    3339,  3441,  4576,  2751,  4577,  2191,    37,    38,    39,    40,
    3442,  1712,  1717,    44,  1167,  1743,   809, -1497, -1497, -1497,
   -1497,  4578,   809,  2695, -1497,  1167,  1739,  1167,  1167,  1167,
    4586,  4638,  2746,  4639,  1309,   815,   655,  2221,  2223,  1766,
    2816,   815,  1309,  1309,   403,  1775,  4659,   665,  4660,  3777,
     403,  1167,    37,    38,    39,    40,  1768,  3778,  3442,    44,
    4707,  1795,  4708,  1308,  1167,  4720,  4574,  2746,  4727,  1167,
    2944,  4732,  4240,  3855,  1807,  1816,  1167,  1644, -1504, -1504,
   -1504, -1504,  1167,  2154,  1820, -1504,  2155,  1825,  1826,  1688,
    3779,  2174,  2175,  2176,  2177,  2178,  2179,  1827,  4734,  4217,
    3855,  1832,  4794,  2156,  2211, -1495, -1495, -1495, -1495,  1834,
    1836,  2158, -1495, -1498, -1498, -1498, -1498,  2159,  1841,  1439,
   -1498,   665,  3439,  1846,  4270,  4271,   664,  4799,  1848,  4800,
    2815,  4550,  4810,  4811,  2746,  3477,   665,   665,  4812,  4367,
    2695,  2160,  1167,  1855,  1858,   808,   808,   808,  1700,  1900,
    4415, -1496, -1496, -1496, -1496,  1902,  1896,  4247, -1496,  4815,
    1904,  2944,   665,  1913,  4817,  1894,  3855,  4485,  4605,  4834,
    4840,  2746,  2746,  -174,  1915,  3443,  3444,  3445,  1917,  3446,
    3447,  3448,  3449,  3450,  3451,  4841,  1929,  2746,  2154,  1937,
    4867,  2155,  2944,  4942,  4953,  4943,  4943,  1602,  4385,  1604,
    4388,   841,  1953,  1945,  1958,  1894,  1894,  1960,  1894,  1959,
    1961,  4726,  1962,  1964,  1965,  1972,  2158,  1975,  1977,  1976,
    1978,  4726,  2159,  3443,  3444,  3445,  1980,  3446,  3447,  3448,
    3449,  3450,  3451,  1985,  1986,  1987,  1992,   405,   405,   405,
    2006,  2161,  1878,  4661,  2040,  2162,  2160,  4324,  2070,  2072,
    2076,  2078,  2085,  2079,  2098,  2086,   665,  2094,  2097,  2099,
    1894,  2100,  1894,   665,  2104,   246,  2163,  2164,  3769,   808,
    2505,  2106,   665,  2109,  4768,  2110,  2111,  2112,  2117,  2119,
    2120,  2121,  2165,  2122,  2123,  2590,   808,  2130,  2131,  2184,
    2133,  2134,  2135,  2136,  2137,  4719,  2138,  2139,   809,   809,
     809,  2140,  3441,  2815,  2815,  2211,  2215,  2166,  3490,  2227,
    2167,  1389,  2247,  2256,  1606,  1894,  2237,   815,   815,   815,
    1608,  2283,  2291,  2168,  4411,  2293,   403,   403,   403,  2300,
    1119,  2315,  2317,   665,  2308,  3895,  2319,  2328,  2327,  1894,
    2330,  2335,   898,  2337, -2520,  2346, -2578,  2339,  2347,  4816,
    2162,  4722,  2348,  1198,  2350,  2353,  2351,  2352,  2383,  3442,
    2382,   405,  2354,  2355,  4757,  3782,  1894,  2144,  4762,  4763,
    2376,  2163,  2164,  3859,  2402,  2406,  2408,  2409,   405,  1894,
    2410,  2862,  2411,  2412,  2437,  1082,  2438, -2578,  1180,  2445,
    2457,  2447,   665,  2615,   665,  1082,  1644,  2458,  2170,  2068,
    3511,  2460,  2461,  2463,   665,  2462,   665,  3894,  2469,  1644,
    2470,  2471,  2472,  3521,  2473,  2167,  2479,  2488,   909,  2480,
    2495,  2484,   809,  2485,  2496,  1754,  4515,  4488,  2168,  2502,
    2523,  2524,  2552,  2528,  2503,  4008,  4009,  4010,  4011,   809,
    2512,   815,  1894,  2513,  2529,  2525,  2534,  4619,  2538,  2565,
     403,   357,  2553,  4758,  2567,   665,  1894,  4764,   815,  4766,
    4761,  2575,  2101,  2107,  2577,  2578,  2568,   403,  2591,  1894,
    3521,  2594,  2090,  1081,    80,  2597,   873,    80,  2598,  2602,
    2619,  2603,  1792,  2624,  2638,   665,  2639,  2644,  2171,  2172,
    2173,  2649,  2174,  2175,  2176,  2177,  2178,  2179,  2650,  1167,
    3977,   808,   665, -2578,  2657,  2668,  2671,  2673,  1308,  2670,
    2672,  2686,  4820,  2647,  2687,  2711,  2734,   665,  2651,  2728,
     665,  2743,  2782,  2824,  3443,  3444,  3445,  3528,  3446,  3447,
    3448,  3449,  3450,  3451,  1167,  2756,  2825,  1894,  2837,  1439,
    2843,  2155,  3439,  2712,  1167,  2781,  2787,  2848,  2855,  2861,
    1167,  2880,  1167,  2847,  2878,  1644,  2907,  1894,  1167,  2923,
    2924,  1167,  1167,  1167,  1167,  1167,  1167,  1167,  1167,  1167,
    1167,  2929,  2926,  2934,  1167,  1167,  2931,  2935,  1087,  2946,
    2945,  2954,  1894,  2955,  2799,  2958,  2964,  1167,  2984,  2986,
    2987,  1167,  2201,   405,  3001,  1167,  3003,  2174,  2175,  2176,
    2177,  2178,  2179,  3004,  3005,  1167,  3021,  3016,  1167,  3024,
    1167,  3026,  3028,  3029,  3044,  3035,  3040,  3047,  1894,  1167,
    1167,  1167,  4696,  3064,  3061,  1167,  3077,  3082,  1167,  3528,
    1556,  1560,  3133,  3138,    74,  3084,  3142,  3146,  1167,  3145,
    3195,  3208,  3215,  3216,  3219,  3220,  4739,  3221,  1167,  3223,
    3224,  3225,  2815,   985,   809,   985,  1167,   985,  1167,  3227,
    3226,  4579,  3237,   985,  1387,  1388,  3239,  3248,  2068,  3250,
    3253,  3243,  3254,   815,  3255,  3256,  3280,  3261,  2815,  2815,
    3292,  3285,   403,  3298,  3304,  3307,   985,   985,  4161,  3313,
    3312,  3314,  4627,  3331,  4919,  3328,  3343,  3349,  2928,  3346,
    3347,  3348,  3351,  1167,  3352,  3367,  3366,  3361,  3364,  1167,
    3376,  3377,  2944,  3378,   808,  1167,  3388,  3131,   808,  4142,
     808,  1198,  3441,  1993,  3379,  3381,  3396,  4644,  2757,  3400,
    1979,  1405,  3402,  3407,  3405,  2154,  3422,  3423,  2155,  3425,
    1167,  1994,  3408,  3426,  3427,  3430,  3492,  3431,  2475,  3461,
    3473,  3573,  3507,  3433,  3436,  2156,  1198,  2695,  3454,  3530,
    3460,  3487,  3462,  2158,  3536,  3463,    35,   665,  3538,  2159,
    3470,  3485,  3486,  3500,    41,    42,  3535,  3510,  -951,  3442,
    2154,  3587,  3591,  2155,  1181,  3585,  3601,  3602,  3606,  1201,
    3607,  1999,  3612,  2160,  3615,  3617,  3597,   664,  1213,  3603,
    2156,   130,   131,  2157,  3626,   985,   405,  3618,  2158,  3629,
     405,  1894,   405,  1675,  2159,    80,  3631,    80,  2551,  3635,
    3661,   357,  3649,  3622,  1667,  1271,  3650,  3660,  3623,  1278,
    3667,  3668,  3676,  3678,  3709,  3710,  3715,  2068,  2160,  3713,
    1287,  1644,  3716,  3721,   665,  3722,  3723,   665,  3724,  3726,
    3725,  3727,  3729,  3815,  3728,   357,  3730,  3731,   955,  3816,
    3732,  3733,  3734,  3735,  3736,  3743,  3745,   809,   985,  3817,
    3741,   809,  2521,   809,  3747,  3793,  3753,   956,  3759,  3760,
    3761,  3762,  3763,  2593,  2815,  3764,   815,   665,  2311,  3806,
     815,  3845,   815,  2161,  1555,   403,  3818,  2162,  3819,   403,
    3794,   403,  3802,  3847,  3854,  3843,  3863,  3807,   957,  3855,
    3860,  3864,  4831,  3867,  3871,  3868,  3872,  1644,  2163,  2164,
    3892,  3911,  3912,  3901,  3913,  3914,  3922,  3903,  3923,  4300,
    3917,  3924,  2313,  2314,  2165,  3933,  1167,  2087,  2161,  3938,
    3457,  2660,  2162,  3439,  3443,  3444,  3445,  3456,  3446,  3447,
    3448,  3449,  3450,  3451,  1308,  3968,  3969,   665,   665,  2166,
    3970,  1894,  2167,  2163,  2164,  3984,  2149,  3996,  4037,  3894,
    3820,  4063,  2385,  4087,  4108,  2168,  4110,  4111,  2169,  2165,
    4055,  4122,  4123,  4125,  3976,  3997,  4136,  4143,  4144,  4005,
    4077,  4034,  4021,  1894,  1167,  1167,  4043,  4054,  4172,  4060,
    3198,  4053,  4127,  4422,  2166,  2386,  4056,  2167,  4145,  4059,
    4828,  4157,  4155,  4156,  4158,  4159,  2144,  4160,  2387,  4188,
    2168,  4131,  4198,  2169,  4192,  3821,  4015,  4200,  3528,  4201,
    3822,  2388,  3528,    74,    74,  4229,    74,  3230,   665,  1198,
    4255,  4263,  3884,  4275,  4276,  3230,  4285,  4278,  2716,  4294,
    2170,  4297,   985,  4279,  1167,  4298,  4306,  4310,  4312,  4320,
    4420,  4325,  4328,  4307,  4340,  1644,  3823,  4314,  4329,  2389,
    4330,  4331,  4332,  4349,  4337,  4344,  4350,  4382,  4345,  3824,
    4353,  4357,   655,   655,  4377,  4351,  4352,   215,  4379,  4381,
    4389,  1167,  4394,  4392,  4395,  2170,  4412,  3299,  2390,  4397,
    4398,  1167,  1167,  2391,  1894,  4416,  4421,  4423,  4428,  1167,
    1167,  4429,  4453,  4437,  1167,  1894,  4458,   223,  4448,  4451,
    1167,  1167,  3330,  4452,  1167,  4413,  4472,  4477,  1309,  4465,
    4482,  4468,  4486,  4498,  4493,  4501,  4508,  2852,  4516,  1167,
    2171,  2172,  2173,  1167,  2174,  2175,  2176,  2177,  2178,  2179,
    4518,  4519,  1167,   808,  2846,   233,  3541,  1167,  4520,   958,
    3825,  4523,  4535,  4539,  4547,  1309,  4525,   236,  4548,  1167,
    4556,  4545,  4564,  4572,  4573,  4575,  4580,  4582,  4583,  4584,
    4585,  4598,  4591,  4607,  4601,  2171,  2172,  2173,  4611,  2174,
    2175,  2176,  2177,  2178,  2179,    81,  4613,  4633,  4617,  2392,
    4621,   959,  4637,  4408,  4653,  4654,  4663,  4636,  1167,  4646,
    4647,  4262,  4670,  4680,  4672,  4681,  4683,  4684,  4510,  4686,
    4698,  4699,    35,  4729,  4715,    79,  1894,   841,  4723,  4738,
      41,    42,  4746,  1088,  4755,  4775,  4780,  3769,   808,  4786,
    4790,  4803,  4784,   985,  4796,   405,  4797,  3286,   985,   985,
    4798,  4809,  4804,  4813,  1894,  4814,  4818,  4819,  2393,  4824,
    4826,   665,  4837,  4759,  2394,  4843,  1894,  2395,  4844,  4853,
    4842,  4847,  4849,   665,  4045,  4885,  4858,  3336,   364,  4859,
    4888,  4845,  4877,  4880,   364,  4882,  4922,  4846,  4896,   658,
    4938,  4910,  4941,  2396,  4947,  4951,  1720,  1100,  2535,  2397,
    3295,  1819,  3565,  3149,  1742,  2760,   809,  2234,  3137,  3673,
    1894,  4140,  2398,  3207,  3766,  4657,  4487,   364,  4770,  4529,
    4682,  2309,  4296,  1387,  1388,   815,  4695,  4685,  1721,  3620,
     405,  4513,   665,  3375,   403,  4883,  4625,  2399,  4918,  4850,
    1744,  4848,  2324,   662,  4894,  4792,  1745,  3625,  2659,  2331,
    2333,  4530,  2761,  3150,  4266,  3278,  4139,  2665,  3279,  2616,
    4267,  2669,   364,  3685,  4268,  3262,  3850,  2675,  2676,  4921,
    4952,  4948,  3803,  1167,  3781,  4895,  4645,   357,  2601,  4839,
    4886,  2762,  4648,  1722,  1004,  2688,  1746,  2060,  3528,  4326,
    4741,   809,  4302,  3528,  3090,  4303,  3528,  4802,  3287,  3742,
    4903,  4949,  2763,  3151,  1570,   985,  4788,  1309,  1024,  2939,
     815,  2940,  3570,   985,  1723,  2701,  1024,   357,  1024,   403,
    4284,   987,  4073,  4414,  2007,  1894,  3099,  1310,  3371,  1592,
     364,  2764,  2253,  3571,  3528,  1747,  2765,  2963,  2280,  2284,
    2279,   987,  1748,  3337,  3583,  1749,   665,  3579,  2962,  1724,
    2957,  3596,  3584,  4618,  4017,  4387,  4731,  1578,  1167,  4074,
     985,  3988,  1894,   985,   985,  4721,  4868,  1167,  2287,  4643,
    3978,  4869,  4876,  3574,  3437,  3438,  3505,  3417,  1725,  3453,
    3503,  4070,  2766,  2906,  1167,  1167,  1133,  3345,  1167,  3893,
    2154,  1947,  3152,  2155,  2653,  2988,  4866,  1750,  2299,  1167,
    1103,  2292,  2067,  1356,  1167,  2979,  1180,  1167,  1685,  2995,
    1656,  2992,  1167,  1167,  1657,  3560,  2993,  4079,  2158,  3488,
    3489,  4404,  1309,  4080,  2159,   985,  2200,  3521,  2296,  3288,
    4058,  3521,  1126,  2999,  3373,  2713,    83,  1996,     0,   665,
     208,   665,     0,  1394,  1728,  1167,     0,     0,  2160,     0,
    1729,     0,  1751,  4615,  1752,  3528,     0,  1730,     0,  3252,
     841,     0,     0,     0,  1753,  2421,     0,     0,  3289,     0,
       0,     0,  1754,   357,  1732,   364,  1894,     0,  4675,     0,
    1167,  1755,  1733,     0,     0,  2767,     0,     0,     0,     0,
       0,  2768,     0,  3153,     0,   655,     0,  2769,     0,     0,
       0,  3154,     0,  3690,  3155,  3528,  1644,     0,     0,     0,
     364,     0,  1756,     0,     0,     0,  1757,  1167,     0,     0,
       0,     0,     0,     0,     0,     0,  2770,     0,  2771,  2652,
    3712,     0,     0,  1734,     0,     0,     0,  3339,  3884,     0,
    2936,  1758,     0,     0,     0,  2772,     0,     0,  2161,     0,
       0,     0,  2162,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   808,  1167,     0,  1894,     0,
    2773,     0,     0,  2163,  2164,     0,     0,     0,     0,     0,
      74,     0,     0,    74,     0,     0,     0,     0,     0,  2165,
    1167,  1894,     0,  1167,     0,  1167,     0,     0,  3230,  1759,
       0,  3230,  3230,     0,     0,  3230,     0,     0,     0,     0,
       0,     0,  1167,     0,     0,  3230,  1167,  2167,     0,     0,
    1854,  1894,     0,     0,     0,     0,  3791,     0,  3397,     0,
    2168,     0,  3800,     0,     0,     0,     0,     0,     0,  3791,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1309,     0,  1309,     0,     0,   405,     0,     0,
    1894,  1720,     0,  2533,  1894,  1894,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4937,     0,   665,     0,
       0,     0,     0,  2788,  2789,  3853,     0,     0,     0,     0,
       0,  2801,     0,  1721,     0,  2804,  2805,  4855,  1167,     0,
       0,     0,     0,     0,     0,  2170,     0,  3528,     0,     0,
    2826,     0,  2827,     0,  3879,  1309,     0,     0,   809,     0,
       0,     0,     0,     0,     0,     0,  1894,     0,     0,     0,
       0,     0,     0,  4808,  2849,     0,  2850,   815,     0,     0,
       0,  4884,     0,     0,     0,     0,   403,     0,  1722,     0,
       0,     0,     0,     0,     0,     0,  1167,     0,     0,     0,
    2605,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1167,     0,     0,  2533,     0,     0,  1723,
       0,     0,     0,     0,     0,     0,  2324,  3521,     0,     0,
       0,     0,  3521,     0,     0,  3521, -2578, -2578,     0,  2174,
    2175,  2176,  2177,  2178,  2179,     0,     0,     0,  1167,     0,
     361,  4905,  2667,  4906,  1724,     0,     0,  4907,  1167,     0,
       0,  4928,   808,  4908,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2533,     0,     0,     0,  1167,
    1167,     0,   665,  1725,     0,     0,   361,  4905,     0,  4906,
     985,     0,  1167,  4907,  4950,     0,     0,     0,     0,  4908,
       0,     0,     0,     0,  3989,     0,     0,     0,  4928,   808,
       0,     0,     0,     0,     0,     0,  4928,   808,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1167,     0,
     361,  4905,     0,  4906,     0,     0,     0,  4907,  1167,   985,
       0,     0,     0,  4908,     0,   208,     0,  2420,     0,  1728,
       0,     0,     0,     0,   405,  1729,     0,  4050,     0,  1667,
     364,    74,  1730,    74,   364,     0,   357,     0,     0,  3634,
    2421,     0,     0,     0,     0,     0,     0,   658,     0,  1732,
       0,     0,   658,     0,  4929,     0,     0,  1733,     0,     0,
       0,   658,     0,     0,     0,     0,  1167,  3353,     0,     0,
       0,   405,     0,     0,     0,  1167,     0,     0,     0,   405,
       0,     0,     0,  3362,  3363,   809,     0,  3365,   658,     0,
       0,     0,   658,  3369,     0,     0,     0,     0,     0,     0,
       0,  4929,     0,   658,   815,     0,     0,     0,  1734,  4929,
       0,     0,  3946,   403,  3521,  3951,  3952,  3953,  3954,  3955,
    3956,  3957,  3958,  3959,  3960,     0,     0,   658,  3336,     0,
       0,     0,   809,     0,  3704,     0,  3706,     0,     0,     0,
     809,   658,     0,     0,     0,   658,     0,  1720,     0,     0,
       0,   815,     0,     0,     0,   658,     0,     0,     0,   815,
     403,     0,  3403,     0,     0,     0,     0,     0,   403,   658,
       0,     0,     0,     0,  4000,  4001,     0,     0,     0,  1721,
       0,  3791,     0,   985,     0,     0,     0,     0,     0,  3738,
       0,   985,     0,   985,     0,     0,     0,     0,  4162,     0,
       0,  4163,     0,  4164,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3752,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4190,  4191,     0,
       0,     0,     0,   987,  1722,   987,     0,   987,     0,     0,
       0,  3230,     0,   987,     0,     0,     0,  3230,  3230,  3230,
    3230,  3230,  3230,     0,     0,     0,  1024,  1309,   658,     0,
    1024,  4219,     0,     0,     0,  1723,   987,   987,     0,     0,
       0,     0,     0,     0,     0,     0,   655,  3257,   364,     0,
       0,     0,     0,     0,     0,  3800,     0,     0,     0,     0,
       0,     0,     0,     0,  3337,     0,  4242,  4244,  4246,  4248,
    1724,     0,     0,  3006,     0,     0,     0,     0,  3010,     0,
       0,  3013,     0,     0,     0,     0,  3099,     0,     0,  2154,
       0,     0,  2155,     0,     0,     0,     0,     0,     0,  1725,
       0,     0,     0,  3036,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3897,     0,   658,   658,  2158,     0,     0,
    1744,     0,     0,  2159,     0,     0,  1745,     0,     0,     0,
    4301,     0,     0,     0,     0,     0,     0,  3080,     0,  2154,
       0,     0,  2155,     0,     0,     0,     0,  2160,     0,     0,
       0,   357,     0,     0,     0,   987,     0,     0,     0,     0,
       0,   208,     0,     0,  3094,  1728,  1746,  2158,     0,   662,
     662,  1729,     0,  2159,  1672,     0,     0,     0,  1730,     0,
       0,  3939,     0,     0,     0,     0,  2421,  4936,  3127,     0,
       0,  4335,   985,     0,     0,  1732,     0,  2160,     0,     0,
       0,  3945,     0,  1733,     0,     0,     0,  3148,  3630,     0,
       0,  3158,     0,     0,     0,  1747,     0,     0,   987,     0,
       0,     0,  1748,  1168,  1170,  1749,  3967,  1173,  1174,  3170,
       0,   357,     0,     0,     0,   365,     0,     0,     0,  3179,
       0,   365,     0,     0,  1211,     0,   659,  2161,     0,     0,
       0,  2162,  3202,     0,  1734,     0,     0,     0,  3339,  3501,
    4258,  3209,  2068,     0,  1261,     0,     0,     0,  1264,     0,
       0,     0,  2163,  2164,   365,     0,     0,  1750,     0,     0,
       0,  3677,     0,  3679,  1285,     0,     0,  2154,  2165,     0,
    2155,     0,     0,     0,     0,     0,     0, -2578,     0,     0,
       0,  2162,     0,     0,     0,     0,     0,  2156,     0,     0,
     658,     0,     0,  4409,  4410,  2158,  2167,     0,     0,   365,
       0,  2159,  2163,  2164,     0,   658,     0,     0,     0,  2168,
       0,     0,  1751,     0,  1752,    80,     0,     0, -2578,     0,
       0,     0,     0,     0,  1753,  2160,     0,     0,   658,     0,
       0,     0,  1754,     0,     0,  2154,     0,     0,  2155,     0,
       0,  1755,     0,     0,     0,     0,  2167,     0,     0,     0,
    3737,     0,     0,     0,     0,  3744,     0,     0,     0,  2168,
       0,     0,     0,  2158,   658,     0,     0,   365,  2324,  2159,
       0,  3563,  1796,   985,     0,     0,  1757,     0,     0,   658,
       0,     0,   987,     0,  2170,     0,     0,     0,     0,     0,
       0,   658,     0,  2160,   658,     0,     0,     0,     0,     0,
       0,  1797,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4361,  4362,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2161,     0,     0,     0,  2162,
       0,     0,     0,     0, -2578,     0,     0,     0,  3230,  3230,
       0,  3387,     0,     0,     0,     0,     0,     0,     0,     0,
    2163,  2164,  1309,     0,     0,     0,  4491,     0,  4492,  1759,
       0,  4496,  4497,  3387,     0,     0,  2165,     0,     0,  3800,
    3800,  3800,  3800,  3800,  2171,  2172,  2173,     0,  2174,  2175,
    2176,  2177,  2178,  2179,     0,     0,     0,     0,     0,     0,
       0,  2166,     0,  2161,  2167,     0,     0,  2162,     0,     0,
       0,     0,     0,     0,  3896,     0,     0,  2168,  3899,  3900,
    2169,  3902,   365,  3904,  3905,     0,   658,  4527,  2163,  2164,
       0,     0,  3910,     0,   658,   658,     0,     0,  2174,  2175,
    2176,  2177,  2178,  2179,  2165,   364,     0,     0,     0,     0,
       0,     0,     0,     0,  4549,     0,     0,   365,     0,     0,
       0,     0,     0,     0,     0,  3927,     0,     0,     0,  2166,
    1764,  1765,  2167,     0,     0,     0,     0,  4335,  4335,  4335,
    4335,     0,     0,   987,     0,  2168,     0,     0,   987,   987,
       0,     0,  2170,     0,     0,  4272,     0,   364,   364,   364,
       0,     0,     0,     0,     0,     0,  2154,     0,     0,  2155,
       0,     0,     0,     0,     0,     0,     0,     0,   658,     0,
       0,     0,     0,     0,     0,     0,  2156,     0,     0,     0,
       0,     0,     0,     0,  2158,     0,     0,     0,  1849,     0,
    2159,     0,     0,     0,     0,     0,     0,     0,   364,     0,
       0,     0,     0,     0,     0,   364,     0,     0,  1908,  1909,
    2170,     0,   364,     0,  2160,     0,     0,     0,     0,  1024,
       0,     0,   662,     0,     0,  1936,     0,     0,     0,  1744,
       0,     0,  2171,  2172,  2173,  1745,  2174,  2175,  2176,  2177,
    2178,  2179,     0,     0,  2932,     0,     0,     0,     0,     0,
    2933,  1024,   985,     0,     0,     0,  3791,  3795,  3798,     0,
    1969,  1971,     0,     0,     0,   985,     0,     0,     0,     0,
    3609,     0,     0,     0,     0,  1746,     0,     0,     0,     0,
    3230,     0,     0,     0,  4658,     0,     0,     0,     0,     0,
       0,     0,     0,  3842,     0,   987,     0,     0,     0,  2068,
    2171,  2172,  2173,   987,  2174,  2175,  2176,  2177,  2178,  2179,
       0,     0,     0,     0,  2161,     0,     0,     0,  2162,     0,
       0,     0,  4571,     0,  1747,     0,     0,     0,     0,     0,
       0,  1748,  1744,     0,  1749,     0,   658,     0,  1745,  2163,
    2164,     0,     0,     0,     0,     0,     0,     0,  4587,  4588,
     987,     0,     0,   987,   987,  2165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1746,     0,
    2166,     0,     0,  2167,     0,     0,  1750,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2168,     0,     0,  2169,
       0,     0,     0,     0,     0,  3695,     0,     0,     0,     0,
    4441,   985,  3707,     0,     0,   987,   364,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1747,     0,     0,
       0,     0,     0,   658,  1748,     0,     0,  1749,  4455,     0,
       0,  1751,     0,  1752,     0,     0,     0,     0,     0,   658,
    4464,     0,     0,  1753,     0,     0,     0,     0,  1309,     0,
       0,  1754,     0,     0,     0,     0,     0,     0,     0,     0,
    1755,  2170,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3749,     0,   658,   658,     0,     0,     0,  1750,
       0,     0,     0,     0,  4479,   658,     0,     0,     0,     0,
       0,  1821,     0,     0,     0,  1757,     0,   658,   658,     0,
       0,     0,     0,     0,     0,     0,     0,   365,     0,     0,
       0,   365,     0,     0,     0,     0,     0,     0,     0,   658,
    1822,     0,     0,     0,   659,     0,     0,     0,     0,   659,
       0,     0,     0,     0,  1751,     0,  1752,     0,   659,     0,
       0,     0,  2154,     0,  4718,  2155,  1753,     0,     0,     0,
       0,  2171,  2172,  2173,  1754,  2174,  2175,  2176,  2177,  2178,
    2179,     0,     0,  1755,     0,   659,     0,  3432,     0,   659,
    2158,     0,     0,     0,     0,     0,  2159,     0,  1759,     0,
     659,     0,     0,     0,     0,     0,     0,  2154,     0,     0,
    2155,     0,     0,  4076,  2403,     0,     0,     0,  1757,     0,
    2160,     0,  4315,     0,   659,     0,     0,     0,     0,     0,
    4318,  4319,     0,     0,     0,  2158,     0,     0,   659,     0,
       0,  2159,   659,  2404,  2533,     0,     0,     0,     0,     0,
       0,     0,   659,     0,     0,     0,  2068,     0,     0,     0,
       0,  3918,     0,     0,     0,  2160,   659,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3928,
       0,     0,  4002,     0,     0,     0,     0,   364,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2459,     0,     0,
       0,  1759,     0,     0,  4930,     0,     0,   985,     0,  2154,
       0,     0,  2155,     0,     0,     0,     0,     0,     0,     0,
   -2578,     0,     0,   985,  2162,     0,     0,  4003,     0,  2156,
       0,     0,     0,     0,     0,     0,     0,  2158,     0,     0,
       0,     0,     0,  2159,     0,  2163,  2164,  2516,  2517,  2518,
    2519,  4930,     0,     0,     0,   659,     0,     0,     0,  4930,
       0, -2578,     0,     0,     0, -2578,     0,  2160,     0,  2162,
       0,     0,     0,     0,     0,   365,     0,   364,     0,     0,
       0,     0,     0,   985,     0,     0,  2556,  2557,     0,  2167,
    2163,  2164,  2566,     0,     0,     0,     0,     0,  1387,  1388,
       0,     0,  2168,     0,     0,     0, -2578,  4226,     0,     0,
       0,  3798,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4241,     0,     0,     0,     0,   364,     0,   364,
    4440,     0,     0,     0,  2167,     0,     0,     0,     0,  2587,
       0,     0,   659,   659,     0,     0,     0,  2168,  1744,   658,
     987,     0,     0,     0,  1745,     0,     0,     0,     0,     0,
       0,  4456,  4457,  2620,  2621,  2622,  2623,  2161,     0,     0,
       0,  2162,     0,     0,     0,     0,   658, -2578,     0,     0,
     364,   658,     0,     0,   658,  2068,     0,     0,     0,     0,
       0,     0,  2163,  2164,  1746,     0,     0,     0,     0,   987,
       0,     0,     0,   662,     0,     0,   658,     0,  2165,     0,
       0,     0,     0,     0,     0,  3738,   657,  4480,  4481,  1672,
       0,  2679, -2578,     0,     0,     0,  4117,     0,     0,     0,
    2683,   985,     0,  2166,     0,     0,  2167,  2690,     0,     0,
     658,     0,     0,  1747,   806,     0,     0,     0,     0,  2168,
    1748,  1024,  2169,  1749,  2068,     0,     0,     0,  2068,  2068,
       0,     0,     0,     0,     0,     0,     0,   658,   658,     0,
       0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   806,
     364,   658,     0,   364,     0,  2154,     0,     0,  2155,     0,
       0,     0,     0,  4177,     0,  1750,  4180,     0,     0,     0,
     658,     0,  1024,     0,   658,  2156,  2174,  2175,  2176,  2177,
    2178,  2179,     0,  2158,  2170,     0,     0,     0,     0,  2159,
       0,     0,   658,     0,     0,  1023,     0,   659,  4560,     0,
    4561,  4562,   658,  1023,     0,  1023,     0,     0,     0,     0,
       0,  4565,   659,  2160,     0,   658,     0,   806,     0,     0,
    1751,     0,  1752,     0,   658,     0,     0,     0,     0,  2324,
       0,     0,  1753,   987,  2154,   659,     0,  2155,     0,     0,
    1754,   987,     0,   987,     0,     0,     0,     0,     0,  1755,
       0,    74,     0,     0,  2156,   985,     0,     0,     0,     0,
       0,     0,  2158,     0,  2859,     0,     0,     0,  2159,     0,
       0,   659,     0,     0,  2171,  2172,  2173,     0,  2174,  2175,
    2176,  2177,  2178,  2179,  1757,     0,   659,     0,     0,     0,
    3480,     0,  2160,     0,     0,     0,     0,     0,   659,     0,
       0,   659,  2154,     0,     0,  2155,     0,   985,     0,  1758,
       0,     0,     0,  2161,     0,     0,     0,  2162,     0,     0,
    4462,  4463,     0,     0,     0,  4466,  4467,     0,     0,     0,
    2158,     0,     0,     0,     0,     0,  2159,     0,  2163,  2164,
     658,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2165,     0,     0,  3387,     0,     0,
    2160,     0,     0,     0,     0,     0,     0,  1759,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   658,     0,  2166,
       0,     0,  2167,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2161,     0,     0,  2168,  2162,     0,  2169,     0,
       0,     0,     0,     0,     0,  3798,  3798,  3798,  3798,  3798,
       0,     0,     0,   985,     0,     0,     0,  2163,  2164,     0,
       0,     0,  4006,   659,   658,     0,     0,     0,     0,     0,
       0,   659,   659,  2165,     0,     0,     0,     0,     0,     0,
       0,     0,   365,     0,     0,     0,   658,     0,     0,     0,
    4717,     0,     0,     0,     0,     0,     0,     0,  2166,     0,
   -2578,  2167,     0,     0,  2162,     0,     0,     0,     0,     0,
    2170,     0,   987,     0,  2168,     0,     0,  2169,     0,     0,
       0,     0,     0,     0,     0,  2163,  2164,     0,     0,     0,
       0,  3048,  3049,  3050,   365,   365,   365,     0,  3058,     0,
    3060, -2578,  3062,  3063,     0,  1744,  4743,     0,     0,     0,
       0,  1745,     0,     0,     0,   659,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   364,     0,  2167,
       0,     0,     0,   364,     0,     0,  1776,     0,     0,  4769,
       0,     0,  2168,     0,     0,   365,     0,     0,     0,  2170,
       0,  1746,   365,     0,     0,     0,     0,     0,     0,   365,
    2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,
       0,     0,     0,     0,  3792,     0,     0,     0,     0,  4614,
    4459,     0,  1777,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4469,     0,     0,     0,     0,     0,     0,  3165,
    1747,     0,     0,     0,     0,     0,     0,  1748,     0,     0,
    1749,     0,     0,     0,     0,     0,     0, -2578,     0,   658,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   985,     0,     0,     0,     0,     0,     0,  2171,
    2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,
       0,     0,     0,  3940,     0,     0,  3222,     0,     0,  1778,
       0,     0,  1750,     0,  3231,  3232,  3233,  3234,  3235,  3236,
       0,     0,     0,   987,     0,     0,  1183,     0,     0,     0,
       0,     0,  1204,   659,     0,     0,     0,     0,     0,     0,
    1215,     0,     0,   658,     0,     0,     0,     0,  1225,     0,
       0,     0,     0,  1256,     0,  1779,     0,  1780,   658,   658,
       0,  2174,  2175,  2176,  2177,  2178,  2179,  1781,     0,  1752,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1753,
    2154,     0,     0,  2155,   658,     0,     0,  1754,     0,     0,
       0,     0,     0,     0,  3316,  1782,  1755,     0,     0,     0,
    2156,     0,     0,     0,     0,     0,     0,     0,  2158,     0,
       0,     0,  4915,   365,  2159,  3387,     0,     0,     0,  2154,
       0,     0,  2155,     0,  3356,     0,  3358,  1783,     0,     0,
     659,  1757,  1784,     0,     0,     0,     0,     0,  2160,  2156,
       0,     0,     0,     0,     0,     0,   659,  2158,     0,     0,
       0,     0,     0,  2159,     0,     0,  1785,   806,     0,   364,
     364,   364,     0,     0,     0,     0,     0,  1786,     0,  2154,
       0,     0,  2155,     0,   657,     0,     0,  2160,   658,   657,
       0,   659,   659,     0,     0,   658,     0,     0,   657,  2156,
       0,     0,   659,     0,   658,     0,     0,  2158,     0,     0,
       0,  1422,     0,  2159,   659,   659,     0,     0,  3387,     0,
    3387,     0,     0,     0,  1759,   657,     0,     0,     0,   657,
       0,     0,     0,     0,     0,     0,   659,  2160,     0,  3409,
     657,     0,     0,  1548,     0,     0,     0,     0,  2161,  4806,
       0,     0,  2162,     0,     0,     0,     0,     0,     0,     0,
       0,  1572,     0,     0,   657,   658,     0,     0,     0,     0,
       0,     0,     0,  2163,  2164,     0,     0,     0,   657,     0,
       0,     0,   657,  1598,     0,     0,     0,  2161,     0,  2165,
       0,  2162,   657,   364,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   657,     0,     0,     0,
     364,     0,  2163,  2164,  2166,     0,     0,  2167,     0,     0,
       0,     0,     0,     0,   658,     0,   658,     0,  2165,     0,
    2168,     0,     0,  2169,     0,     0,   658,  2161,   658,     0,
       0,  2162,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   987,  2166,     0,     0,  2167,     0,     0,     0,
       0,     0,  2163,  2164,     0,   987,     0,     0,     0,  2168,
       0,     0,  2169,     0,     0,     0,     0,     0,  2165,     0,
       0,     0,     0,     0,   365,     0,     0,   658,     0,     0,
       0,     0,     0,  1023,     0,   657,     0,  1023,     0,     0,
       0,     0,     0,  2166,     0,  2170,  2167,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   658,     0,  2168,
       0,     0,  2169,     0,     0,     0,     0,     0,     0,     0,
    4927,     0,     0,     0,   658,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2170,     0,     0,     0,     0,   658,
       0,     0,   658,     0,     0,     0,     0,     0,     0,  1744,
       0,     0,     0,     0,     0,  1745,  1906,     0,     0,     0,
       0,     0,     0,     0,   365,     0,     0,  4927,     0,     0,
       0,     0,   657,   657,     0,  4927,  1931,  1934,  1935,     0,
       0,     0,     0,     0,  2170,  2171,  2172,  2173,     0,  2174,
    2175,  2176,  2177,  2178,  2179,  1746,     0,     0,     0,  3987,
       0,   987,     0,     0,     0,     0,  3636,     0,  3637,  3638,
    1228,     0,     0,     0,   365,   364,   365,     0,     0,     0,
       0,     0,     0,     0,  2171,  2172,  2173,     0,  2174,  2175,
    2176,  2177,  2178,  2179,     0,     0,   659,     0,  4062,     0,
       0,     0,     0,  1229,  1747,     0,     0,     0,     0,     0,
       0,  1748,     0,     0,  1749,     0,  1230,  1231,     0,     0,
       0,     0,     0,   659,     0,  1232,     0,   365,   659,  1233,
       0,   659,     0,     0,  2171,  2172,  2173,     0,  2174,  2175,
    2176,  2177,  2178,  2179,     0,     0,  1234,     0,  4089,     0,
       0,  1548,     0,   659,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1750,  1235,     0,     0,
       0,  3387,     0,     0,  2154,     0,     0,  2155,  1548,     0,
       0,     0,     0,     0,     0,  1236,     0,   659,     0,     0,
       0,     0,     0,     0,  2156,     0,  1237,     0,     0,     0,
       0,  1238,  2158,     0,     0,     0,     0,     0,  2159,     0,
       0,     0,     0,     0,   659,   659,     0,     0,     0,     0,
       0,  1751,  1239,  1752,     0,  2154,     0,   657,  2155,     0,
       0,     0,  2160,  1753,     0,     0,     0,   365,   659,     0,
     365,  1754,   657,     0,     0,  2156,     0,  1240,     0,   658,
    1755,     0,     0,  2158,     0,     0,     0,   659,     0,  2159,
       0,   659,     0,     0,     0,   657,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2154,     0,     0,  2155,   659,
       0,  3096,     0,  2160,     0,  1757,     0,     0,   364,   659,
       0,     0,   364,     0,   364,  2156,     0,  1241,     0,     0,
       0,   657,   659,  2158,     0,     0,     0,     0,     0,  2159,
    1758,   659,     0,     0,     0,     0,   657,     0,     0,  2238,
       0,     0,     0,     0,     0,   841,   658,     0,   657,   658,
       0,   657,  2161,  2160,     0,     0,  2162,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   987,     0,     0,
    1242,     0,     0,     0,  1243,     0,  1244,  2163,  2164,     0,
       0,     0,  1245,   987,     0,  1246,  2288,     0,  1759,   658,
       0,     0,     0,  2165,     0,  3906,     0,     0,  3907,     0,
       0,     0,     0,  2161,     0,     0,     0,  2162,     0,     0,
       0,  1247,     0,  1248,     0,     0,     0,  1249,  2166,     0,
       0,  2167,     0,     0,     0,  1250,     0,     0,  2163,  2164,
    1251,     0,     0,     0,  2168,     0,     0,  2169,     0,     0,
       0,     0,  3932,   987,  2165,     0,     0,   659,     0,     0,
       0,     0,     0,  2161,     0,  1252,     0,  2162,     0,   658,
     658,     0,     0,     0,     0,     0,     0,     0,     0,  2166,
       0,     0,  2167,   657,     0,     0,     0,     0,  2163,  2164,
       0,   657,   657,     0,   659,  2168,     0,     0,  2169,     0,
       0,     0,   806,     0,  2165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2170,
       0,  2439,     0,     0,     0,     0,     0,     0,  2456,  2166,
       0,     0,  2167,     0,     0,     0,     0,     0,     0,     0,
       0,   659,     0,     0,     0,  2168,     0,     0,  2169,     0,
     658,     0,     0,  2486,   806,     0,     0,     0,     0,     0,
       0,     0,     0,   659,     0,     0,     0,     0,     0,  2154,
    2170,     0,  2155,     0,     0,   657,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2520,     0,     0,     0,  2156,
       0,     0,     0,     0,     0,     0,     0,  2158,  2537,     0,
       0,   987,     0,  2159,     0,     0,     0,     0,     0,  2171,
    2172,  2173,  2549,  2174,  2175,  2176,  2177,  2178,  2179,   806,
    2170,     0,     0,  4338,     0,     0,  1023,  2160,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   365,     0,     0,     0,     0,     0,
     365,     0,     0,     0,     0,     0,     0,     0,  1023,     0,
    2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,
       0,     0,     0,     0,  4372,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4112,  4113,  4114,  4115,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2154,     0,     0,  2155,
    2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,
       0,     0,     0,     0,  4581,     0,  2156,  2161,     0,     0,
       0,  2162,     0,     0,  2158,     0,   659,     0,     0,     0,
    2159,     0,     0,   657,     0,     0,     0,     0,     0,     0,
       0,     0,  2163,  2164,     0,     0,     0,   364,     0,     0,
       0,     0,     0,     0,  2160,   987,     0,     0,  2165,     0,
       0,     0,     0,   658,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2698,   658,     0,     0,     0,     0,
       0,     0,     0,  2166,     0,     0,  2167,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2168,
     659,     0,  2169,     0,     0,  2154,     0,   987,  2155,     0,
       0,     0,     0,   806,     0,   659,   659,     0,     0,     0,
       0,  1548,  1548,     0,     0,  2156,     0,     0,     0,     0,
     657,     0,   364,  2158,   658,     0,     0,     0,     0,  2159,
       0,   659,     0,     0,     0,     0,   657,     0,     0,     0,
    4256,     0,     0,     0,  2161,     0,     0,     0,  2162,     0,
       0,     0,     0,  2160,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2170,     0,     0,     0,     0,  2163,
    2164,   657,   657,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   657,     0,     0,  2165,     0,     0,     0,     0,
       0,     0,     0,     0,   657,   657,     0,     0,     0,     0,
       0,     0,     0,   987,     0,     0,   365,   365,   365,     0,
    2166,     0,     0,  2167,     0,     0,   657,     0,     0,     0,
       0,     0,     0,     0,     0,   659,  2168,     0,     0,  2169,
       0,     0,   659,     0,     0,     0,     0,     0,   658,     0,
       0,   659,     0,     0,  2905,     0,     0,     0,     0,     0,
       0,     0,     0,  2161,  2171,  2172,  2173,  2162,  2174,  2175,
    2176,  2177,  2178,  2179,     0,     0,     0,     0,  4623,  2925,
       0,     0,     0,     0,     0,     0,     0,     0,  2163,  2164,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2154,  2165,     0,  2155,     0,     0,  1744,
       0,  2170,   659,     0,     0,  1745,  2938,     0,  2941,     0,
       0,     0,     0,  2156,     0,     0,     0,     0,     0,  2166,
       0,  2158,  2167,     0,     0,     0,     0,  2159,     0,     0,
     365,   658,     0,   658,     0,  2168,     0,     0,  2169,     0,
       0,     0,     0,     0,     0,  1746,     0,   365,     0,     0,
       0,  2160,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   659,     0,   659,   806,     0,     0,     0,     0,     0,
       0,     0,     0,   659,     0,   659,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2171,  2172,  2173,  1747,  2174,  2175,  2176,  2177,  2178,
    2179,  1748,     0,     0,  1749,  4668,     0,     0,     0,     0,
    2170,     0,     0,     0,  2154,     0,     0,  2155,     0,     0,
       0,     0,   987,     0,   659,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2156,     0,     0,     0,     0,     0,
       0,     0,  2158,     0,     0,     0,     0,     0,  2159,     0,
       0,  2161,     0,     0,   659,  2162,  1750,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   659,  2160,     0,     0,     0,  2163,  2164,     0,     0,
       0,     0,     0,     0,     0,     0,   659,     0,     0,   659,
       0,     0,  2165,     0,     0,     0,     0,   703,  4475,     0,
    2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,
       0,  1751,  4478,  1752,  4854,  3118,     0,  2166,     0,     0,
    2167,     0,     0,  1753,     0,     0,   657,     0,     0,     0,
       0,  1754,     0,  2168,     0,   703,  2169,     0,     0,     0,
    1755,     0,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,     0,   657,     0,     0,   703,   806,   657,     0,
       0,   657,   365,     0,     0,     0,     0,     0,     0,     0,
     658,  3172,  2161,     0,   996,  1757,  2162,     0,     0,     0,
       0,     0,     0,   657,     0,     0,     0,   997,     0,     0,
       0,     0,     0,     0,     0,  1005,     0,  2163,  2164,     0,
    3173,     0,     0,     0,     0,     0,  4528,     0,  2170,     0,
    1015,     0,   996,  2165,     0,     0,  1036,   657,     0,     0,
       0,     0,     0,     0,     0,     0,  1066,     0,  1023,     0,
       0,     0,     0,     0,  1071,     0,     0,     0,  2166,     0,
       0,  2167,     0,     0,   657,   657,     0,     0,     0,     0,
       0,     0,     0,     0,  2168,     0,     0,  2169,  1759,     0,
       0,  3294,     0,     0,     0,     0,     0,   806,   657,     0,
     806,     0,     0,     0,     0,     0,     0,     0,     0,  4807,
       0,     0,     0,     0,     0,     0,     0,   657,     0,  1023,
    2154,   657,     0,  2155,     0,     0,     0,     0,  2171,  2172,
    2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,   657,
    2156,     0,  4939,     0,  2947,     0,     0,     0,  2158,   657,
       0,     0,     0,     0,  2159,     0,     0,     0,     0,  2170,
       0,     0,   657,     0,   658,     0,   659,     0,     0,     0,
    2154,   657,     0,  2155,     0,     0,     0,     0,  2160,     0,
       0,     0,     0,  4628,  4630,  4630,     0,     0,     0,     0,
    2156,     0,     0,     0,     0,     0,     0,     0,  2158,     0,
       0,     0,     0,     0,  2159,   365,     0,     0,     0,   365,
       0,   365,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2948,     0,     0,     0,     0,  2160,     0,
       0,     0,     0,     0,     0,     0,   364,     0,     0,     0,
       0,     0,     0,   659,     0,     0,   659,     0,     0,  2171,
    2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,
       0,  4057,     0,     0,     0,     0,     0,     0,     0,     0,
    1744,     0,     0,     0,     0,     0,  1745,     0,  2161,     0,
       0,     0,  2162,   364,     0,     0,   659,   657,     0,     0,
       0,   364,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4703,     0,  2163,  2164,     0,     0,  3456,  2154,     0,
       0,  2155,  3457,     0,     0,     0,  1746,     0,     0,  2165,
       0,     0,     0,     0,   657,     0,     0,     0,  2161,     0,
       0,     0,  2162,     0,     0,     0,  2158,     0,     0,     0,
       0,     0,  2159,     0,  2166,     0,     0,  2167,     0,     0,
       0,     0,     0,  2163,  2164,     0,   659,   659,     0,     0,
    2168,     0,     0,  2169,     0,  1747,  2160,     0,     0,  2165,
       0,   657,  1748,     0,     0,  1749,     0,     0,     0,     0,
       0,     0,     0,  4747,     0,     0,  1891,     0,  3516,     0,
       0,     0,     0,   657,  2166,     0,     0,  2167,     0,     0,
       0,     0,     0,     0,     0,  4765,     0,  4767,     0,     0,
    2168,  2154,     0,  2169,  2155,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1750,  4370,     0,
       0,  2156,     0,     0,  3419,  2170,     0,   659,     0,  2158,
       0,     0,     0,  1548,     0,  2159,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   703,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2578,     0,     0,  2160,
    2162,     0,     0,     0,   806,     0,     0,     0,     0,     0,
     806,     0,  1751,     0,  1752,  2170,  2949,     0,     0,     0,
       0,  2163,  2164,     0,  1753,     0,     0,     0,  4630,     0,
       0,     0,  1754,     0,     0,     0,     0, -2578,     0,     0,
       0,  1755,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2171,  2172,  2173,     0,  2174,
    2175,  2176,  2177,  2178,  2179,  2167,     0,     0,     0,     0,
    4852,     0,  3210,  1891,     0,     0,  1757,     0,  2168,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   657,     0,     0,  2161,
       0,  3211,     0,  2162,     0,  2171,  2172,  2173,     0,  2174,
    2175,  2176,  2177,  2178,  2179,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2163,  2164,  4887,     0,     0,   921,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2165,   922,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2578,     0,     0,     0,     0,     0,  1759,
       0,     0,   923,     0,     0,  2166,     0,     0,  2167,  4920,
     657,     0,     0,  1744,   365,   924,     0,     0,     0,  1745,
       0,  2168,     0,     0,  2169,   657,   657,     0,   925,     0,
     659,  1163,  1169,  1169,   703,     0,  1169,  1176,     0,  1163,
       0,  1066,   659,  1200,     0,   926,     0,  1066,     0,  1066,
       0,   657,     0,  1169,     0,  1066,     0,     0,     0,  1746,
       0,     0,     0,  1227,     0,     0,   927,     0,  1066,     0,
    1163,     0,     0,  1169,     0,   703,     0,  1169,     0,     0,
       0,     0,     0,  1200,   928,     0,  1280,  2174,  2175,  2176,
    2177,  2178,  2179,  1169,     0,   929,  2170,     0,     0,   365,
     930,   659,     0,     0,     0,     0,   931,     0,  1747,     0,
       0,     0,     0,     0,     0,  1748,     0,     0,  1749,     0,
       0,   932,     0,     0,  1163,     0,   806,   806,   806,   703,
       0,     0,     0,  1163,     0,     0,  1200,     0,  3834,  2154,
       0,     0,  2155,     0,     0,   657,     0,     0,     0,     0,
       0,  1169,   657,     0,     0,     0,     0,     0,     0,  2156,
       0,   657,     0,  3849,     0,     0,     0,  2158,     0,     0,
    1750,  3857,     0,  2159,     0,  3862,     0,     0,     0,     0,
       0,     0,  1891,     0,     0,     0,  2171,  2172,  2173,  3873,
    2174,  2175,  2176,  2177,  2178,  2179,   933,  2160,     0,     0,
       0,     0,     0,     0,  1066,     0,   934,     0,     0,     0,
       0,     0,     0,     0,     0,   659,  1066,  1423,     0,     0,
       0,     0,   657,     0,   841,  1751,     0,  1752,     0,     0,
       0,     0,     0,     0,     0,  2436,     0,  1753,     0,     0,
       0,     0,     0,  1530,     0,  1754,     0,   703,  1066,   935,
     806,     0,     0,   936,  1755,   937,     0,     0,  1548,     0,
       0,   938,  1891,     0,   939,     0,  1066,   806,     0,     0,
    1066,     0,     0,     0,     0,     0,     0,     0,  1530,     0,
       0,   657,     0,   657,     0,  3654,     0,     0,  1066,  1757,
     940,     0,   941,   657,     0,   657,   942,  2161,     0,     0,
    1066,  2162,     0,     0,   943,     0,     0,     0,   659,   944,
     659,     0,     0,     0,  3655,     0,     0,     0,     0,     0,
       0,   945,  2163,  2164,     0,     0,     0,     0,     0,     0,
       0,     0,  1891,     0,   946,     0,     0,     0,  2165,     0,
       0,     0,     0,     0,   657,     0,     0,     0,     0,     0,
       0,  1891,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2166,     0,     0,  2167,     0,     0,  1891,
       0,     0,  1759,     0,   657,  4012,  4013,  4014,     0,  2168,
       0,  1066,  2169,     0,     0,     0,     0,     0,     0,  1169,
    1169,   657,     0,     0,     0,     0,     0,  1891,     0,     0,
       0,  3979,     0,     0,     0,     0,   657,     0,     0,   657,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1163,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1163,     0,     0,  1200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2170,  1891,     0,  1169,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3980,  2154,
       0,  1066,  2155,     0,     0,     0,     0,  1169,  1169,     0,
       0,     0,   806,     0,     0,     0,     0,     0,     0,  2156,
       0,  1066,  1066,  1066,  1169,     0,  1163,  2158,     0,     0,
    1944,     0,     0,  2159,  2154,     0,     0,  2155,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2156,     0,   365,  2160,  1169,  1169,
    1169,     0,  2158,     0,     0,     0,     0,     0,  2159,     0,
       0,     0,     0,     0,  2171,  2172,  2173,   659,  2174,  2175,
    2176,  2177,  2178,  2179,     0,  2154,     0,     0,  2155,     0,
       0,     0,  2160,  1530,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2156,     0,     0,  3464,     0,
       0,     0,     0,  2158,     0,     0,     0,     0,     0,  2159,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2043,  2043,     0,     0,  4913,  1066,     0,   996,     0,
       0,     0,     0,  2160,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2161,     0,     0,
    2077,  2162,     0,  1066,     0,     0,  2083,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1530,     0,
       0,  1891,  2163,  2164,     0,     0,   657,     0,     0,     0,
       0,     0,  2161,  4238,     0,     0,  2162,     0,  2165,     0,
       0,     0,     0,     0,     0,     0,     0,  1530,     0,     0,
       0,     0,  4264,     0,     0,     0,  2918,  2163,  2164,     0,
       0,     0,     0,  2166,     0,   806,  2167,     0,     0,   806,
       0,   806,     0,  2165,  4274,  1530,  1530,     0,  1530,  2168,
       0,   659,  2169,  2161,     0,     0,     0,  2162,     0,     0,
       0,     0,     0,     0,     0,  1530,     0,     0,  2166,  4914,
       0,  2167,     0,   657,     0,     0,   657,     0,  2163,  2164,
       0,     0,     0,     0,  2168,   703,   703,  2169,     0,     0,
       0,     0,     0,     0,  2165,     0,     0,     0,     0,     0,
       0,  3434,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1066,     0,   657,  1530,     0,  2166,
       0,     0,  2167,   365,  2170,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2168,     0,     0,  2169,     0,
       0,     0,     0,     0,     0,     0,  1530,     0,     0,     0,
    1530,  1530,     0,     0,     0,     0,     0,     0,     0,  2170,
    1066,  1066,  2290,     0,     0,     0,     0,     0,     0,     0,
     365,     0,     0,     0,     0,     0,     0,     0,   365,     0,
       0,     0,     0,     0,     0,     0,   657,   657,     0,   703,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4373,  4374,  4375,  4376,
    2170,     0,     0,     0,  2171,  2172,  2173,     0,  2174,  2175,
    2176,  2177,  2178,  2179,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2171,
    2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,
       0,     0,     0,  3085,     0,     0,     0,   657,  2436,  3092,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1891,     0,     0,     0,     0,     0,  1066,  2444,     0,     0,
       0,     0,     0,  1066,     0,     0,  1169,     0,     0,     0,
    2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,
       0,  1200,     0,     0,     0,     0,     0,     0,  1066,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1066,     0,
       0,     0,     0,     0,     0,     0,  1169,  1169,  1169,  1169,
    1066,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1066,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2548,     0,  1066,     0,     0,
       0,     0,     0,     0,     0,  1169,  1169,     0,     0,     0,
       0,  1169,  2154,     0,     0,  2155,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2156,  1891,     0,     0,     0,     0,     0,     0,
    2158,     0,     0,     0,     0,     0,  2159,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1169,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2160,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1169,  1169,  1169,  1169,     0,     0,     0,     0,
       0,     0,     0,     0,   806,     0,     0,     0,     0,     0,
       0,  2548,     0,  2436,     0,     0,     0,     0,     0,     0,
     657,     0,     0,     0,     0,     0,  1163,     0,     0,     0,
       0,     0,   657,   703,     0,  1163,     0,     0,  4555,     0,
       0,     0,     0,     0,     0,  1200,     0,     0,     0,     0,
    1169,     0,     0,     0,     0,     0,     0,     0,     0,  1169,
       0,     0,     0,     0,  3469,  1169,  1169,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1066,
    2161,     0,     0,     0,  2162,     0,     0,     0,     0,   806,
       0,   657,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2163,  2164,     0,     0,     0,
       0,     0,  1891,  2043,     0,     0,     0,     0,     0,     0,
    1169,  2165,  1163,     0,     0,     0,  1066,  1066,     0,  1169,
       0,     0,     0,     0,     0,  1066,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2166,     0,     0,  2167,
       0,   996,   996,     0,     0,  2759,     0,     0,     0,  1530,
    1530,     0,  2168,     0,     0,  2169,     0,  1530,     0,     0,
    1530,     0,     0,     0,  1530,     0,     0,     0,     0,     0,
       0,     0,  1530,  1530,     0,     0,     0,     0,     0,     0,
    1530,     0,  1200,  1530,  1530,  1530,  1530,  2154,     0,     0,
    2155,     0,     0,  1530,  1530,   657,  1530,     0,  1530,  1530,
       0,     0,  1530,     0,     0,     0,     0,  2156,     0,     0,
    3475,     0,     0,     0,     0,  2158,     0,     0,     0,  1530,
       0,  2159,     0,  1169,  1530,     0,  4666,  2170,  1530,     0,
       0,     0,  1530,     0,  1530,  1530,  1530,  1530,  1530,  1530,
    1530,  1530,  1530,     0,  1530,  2160,     0,     0,     0,  1066,
    1530,     0,     0,  1530,     0,     0,     0,  1548,     0,     0,
       0,     0,     0,     0,     0,  2918,  2918,  2918,     0,     0,
       0,     0,     0,     0,  1066,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   657,     0,
     657,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1066,     0,  1066,     0,  1530,     0,  2171,  2172,  2173,
       0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,     0,
       0,  1744,     0,  2154,     0,     0,  2155,  1745,     0,     0,
       0,     0,     0,     0,     0,  2161,     0,     0,     0,  2162,
       0,  4750,  2970,  2156,  2977,     0,     0,     0,     0,     0,
       0,  2158,  1776,     0,     0,     0,     0,  2159,     0,     0,
    2163,  2164,     0,     0,     0,     0,     0,  1746,     0,     0,
       0,     0,     0,     0,     0,     0,  2165,     0,     0,     0,
       0,  2160,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1891,     0,     0,     0,     0,  1777,     0,
       0,  2166,     0,     0,  2167,     0,     0,     0,   703,     0,
       0,     0,     0,   996,     0,   996,  1747,  2168,     0,     0,
    2169,     0,     0,  1748,     0,     0,  1749,     0,     0,     0,
       0,     0,  1530,  2436,  3092,     0,  3092,     0,  1163,     0,
    1169,  1169,  1169,     0,  1163,  1200,     0,  1169,     0,  1169,
       0,  1169,  1169,     0,     0,  1066,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1778,     0,     0,  1750,     0,
       0,  2161,     0,     0,     0,  2162,     0,     0,  1891,     0,
    1891,     0,  2170,  2444,     0,     0,   806,     0,     0,  3100,
       0,     0,     0,     0,  3109,     0,  2163,  2164,     0,     0,
    1066,     0,     0,     0,     0,     0,     0,   657,     0,     0,
       0,  1779,  2165,  1780,     0,  3140,  3140,     0,     0,     0,
       0,     0,   703,  1781,     0,  1752,     0,     0,     0,     0,
       0,     0,     0,  1891,     0,  1753,     0,  2166,  1169,     0,
    2167,     0,     0,  1754,     0,     0,     0,     0,     0,     0,
       0,  1782,  1755,  2168,     0,     0,  2169,  1891,     0,     0,
       0,     0,     0,     0,  3197,     0,  3199,  3201,     0,     0,
       0,     0,  2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,
    2178,  2179,     0,  3160,  3092,     0,     0,  1757,  1784,     0,
       0,     0,     0,     0,     0,  1169,     0,  3092,     0,     0,
       0,     0,     0,  1169,  1169,  1169,  1169,  1169,  1169,     0,
    2154,     0,  3161,  2155,     0,     0,     0,     0,  1530,     0,
       0,     0,     0,  1786,     0,     0,     0,     0,  2170,     0,
    2156,     0,     0,  3986,     0,     0,     0,     0,  2158,     0,
       0,  2444,     0,     0,  2159,  3140,  1066,     0,     0,     0,
     996,     0,     0,     0,  3936,     0,     0,     0,     0,     0,
    1891,     0,     0,     0,     0,     0,     0,     0,  2160,     0,
    1759,   657,     0,     0,  3092,     0,  3197,     0,     0,     0,
       0,     0,     0,  1169,  3324,     0,     0,  1891,     0,     0,
       0,     0,     0,     0,  1944,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1169,     0,  1169,  3140,  1169,  3140,     0,  2171,  2172,
    2173,     0,  2174,  2175,  2176,  2177,  2178,  2179,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1530,     0,
       0,     0,     0,   806,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1891,     0,     0,     0,  2043,
       0,     0,     0,     0,     0,     0,     0,     0,  2161,     0,
       0,     0,  2162,     0,     0,  1891,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     806,     0,     0,  2163,  2164,     0,     0,     0,   806,     0,
    1891,     0,     0,  1163,     0,     0,     0,  2154,  1163,  2165,
    2155,     0,     0,     0,     0,     0,     0,     0,  1169,     0,
       0,     0,     0,     0,  1530,  1530,     0,  2156,     0,     0,
    1530,     0,     0,     0,  2166,  2158,  1891,  2167,     0,     0,
       0,  2159,     0,     0,     0,     0,     0,     0,     0,     0,
    2168,     0,     0,  2169,     0,  1530,  1530,     0,     0,     0,
    1530,     0,     0,     0,     0,  2160,     0,     0,     0,     0,
       0,     0,  1530,  1530,  1530,  1530,  2918,     0,     0,     0,
       0,     0,     0,     0,     0,  1530,     0,     0,  1530,     0,
    1530,  3484,     0,     0,     0,     0,     0,     0,     0,     0,
    1530,  1530,     0,     0,  1530,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1530,     0,  1530,
       0,  1200,     0,  1530,     0,  2170,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1530,
       0,     0,     0,  1066,     0,     0,     0,     0,     0,     0,
    3529,     0,  1530,  1530,  1530,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2161,     0,     0,     0,  2162,
       0,     0,     0,     0,     0,     0,  1530,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1530,
    2163,  2164,     0,     0,  1530,     0,     0,     0,  1066,     0,
       0,  1530,     0,     0,     0,     0,  2165,  3529,     0,     0,
    3590,     0,     0,     0,  2977,  2171,  2172,  2173,     0,  2174,
    2175,  2176,  2177,  2178,  2179,     0,     0,     0,     0,  3092,
       0,  2166,     0,     0,  2167,     0,     0,   814,     0,     0,
       0,     0,     0,     0,     0,   867,     0,  2168,     0,     0,
    2169,     0,     0,     0,     0,     0,     0,   868,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1530,     0,  3140,
       0,     0,     0,     0,  2043,     0,     0,     0,   869,     0,
       0,     0,   814,     0,     0,     0,     0,     0,     0,     0,
       0,   870,     0,     0,     0,  1169,     0,  1169,  1169,     0,
     871,     0,     0,     0,  -709,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   872,  2170,     0,     0,     0,     0,   873,  1027,     0,
       0,     0,     0,     0,     0,     0,  1027,     0,  1027,     0,
       0,     0,   874,     0,     0,     0,     0,     0,     0,     0,
     814,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     875,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   876,     0,     0,     0,     0,     0,     0,   877,  1891,
       0,     0,   878,     0,   828,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1881,  -905,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2436,  2171,  2172,  2173,     0,  2174,  2175,  2176,  2177,
    2178,  2179,     0,     0,     0,     0,     0,     0,     0,     0,
     829,     0,     0,     0,     0,   879,     0,     0,     0,     0,
       0,     0,     0,   830,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     831,     0,     0,     0,     0,     0,   832,     0,  3140,  3140,
       0,     0,   880,     0,     0,   881,     0,     0,     0,     0,
       0,   833,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3799,     0,   834,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     835,     0,     0,     0,     0,   836,     0,     0,     0,     0,
       0,   837,  1891,  1066,     0,   882,     0,     0,     0,     0,
       0,   883,     0,  1891,     0,     0,   838,  -386,     0,     0,
     884,     0,     0,     0,     0,     0,     0,  2043,  1066,     0,
       0,     0,     0,  1881,     0,     0,  1066,     0,     0,     0,
    1066,   839,     0,     0,     0,     0,  -386,     0,   885,   886,
    2918,   887,   888,     0,  1066,  2918,     0,     0,     0,     0,
     889,     0,     0,     0,     0,   890,     0,  2918,     0,   703,
       0,   891,     0,     0,   892,     0,     0,   893,     0,     0,
       0,     0,     0,     0,  1169,     0,     0,  1169,     0,     0,
    -386,   840,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1163,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   841,
       0,     0,     0,  1066,  1891,     0,     0,     0,     0,     0,
       0,  1169,     0,     0,     0,     0,     0,     0,     0,  1530,
       0,     0,     0,     0,   842,     0,     0,     0,     0,  1530,
     843,     0,  1891,     0,     0,  1530,   844,  1530,     0,   845,
       0,     0,     0,  1530,  1891,     0,  1530,  1530,  1530,  1530,
    1530,  1530,  1530,  1530,  1530,  1530,     0,     0,     0,  1530,
    1530,     0,     0,     0,     0,   846,     0,   847,     0,     0,
       0,   848,  1530,     0,     0,     0,  1530,     0,     0,   849,
    1530,     0,     0,     0,   850,     0,     0,     0,  1891,     0,
    1530,     0,     0,  1530,     0,  1530,   851,     0,     0,     0,
       0,     0,     0, -2085,  1530,  1530,  1530,     0,     0,   852,
    1530,     0,     0,  1530,     0,     0,     0,     0,     0,     0,
    1066,  1066,  1066,  3529,  4020,     0,     0,     0,  4020,  4033,
       0,     0,     0,  1530,     0,     0,     0,     0,     0,  4047,
       0,  1530,     0,  1530,     0,     0,     0,     0,     0, -2085,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2085,     0,     0,     0, -2085,     0,     0,     0,     0,
   -2085,     0,     0,     0,     0, -2085,     0,     0, -2085,     0,
   -2085,     0,  1881,     0,     0,     0,     0,     0,  1530,     0,
       0,     0,     0,     0,  1530,     0,     0,     0,  2977,     0,
    1530,     0,     0,  4553,     0,     0,     0, -2085,     0,     0,
       0,     0,     0,     0,     0, -2087,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4095,  2043,  2043, -2085,  2548,
       0,     0,     0,     0,     0,  1881,     0,     0,     0,     0,
    1891,     0,     0,  1169,  1169,  1169,  1169,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2087,  1881,     0, -2085,     0,     0,     0,     0,     0,
       0,     0, -2085, -2087,     0,     0,     0, -2087,     0,     0,
       0,  4138, -2087,     0,     0,     0,     0, -2087,     0,     0,
   -2087,     0, -2087,     0,     0,     0,     0,     0,     0,     0,
     814,     0,     0,     0,     0,     0,     0,     0,  1165,     0,
       0,     0,     0,     0,     0,     0,  1165, -2085,     0, -2087,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1881,     0,     0,     0,     0,     0,     0,     0,
   -2087,     0,     0,     0,     0,     0,  4193,  1165,     0,     0,
       0,  1881,     0,     0,  3092,     0, -2100,     0,     0,     0,
       0,     0,  1000,     0,     0,     0,     0,     0,     0,  1881,
       0,     0,     0,     0,     0,     0, -2087,     0,     0,     0,
       0,     0,     0,     0, -2087,     0, -2085,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1881,     0,     0,
    3799,  1165, -2100,     0,     0,     0,     0,     0,  1066, -2085,
    1165, -2085, -2085,     0, -2100,     0,     0,     0, -2100,  1169,
       0,  1530,     0, -2100,     0,     0,     0,  1066, -2100, -2087,
       0, -2100,     0, -2100,     0,     0,     0,     0,     0,  2444,
       0,     0,     0,     0, -2085,     0,  3092, -2085, -2085,  1066,
   -2085,     0,     0,     0,     0,  1881,     0,     0,  3197,     0,
   -2100,     0,     0,  4291,     0,     0,     0,  2444,     0,  1891,
       0,     0,     0,     0,  1000,     0,     0,     0,     0,  1530,
    1530, -2100,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2087,  1891,
       0,     0,     0,     0,  3140,     0,  3140,     0,     0,     0,
       0,     0,     0,     0,     0,  1889,     0, -2100,     0,     0,
    1165, -2087,     0, -2087, -2087, -2100,  1027,     0,     0,     0,
    1027,     0,     0,     0,     0,     0,     0,     0,  1891,  1530,
       0,     0,  1891,  1891,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1165, -2087,     0,     0, -2087,
   -2087,     0, -2087,     0,     0,     0,     0,     0,     0,     0,
   -2100,     0,     0,     0,     0,     0,  1530,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1530,  1530,     0,     0,
       0,     0,     0,     0,  1530,  1530,     0,     0,     0,  1530,
       0,     0,     0,     0,  4553,  1530,  1530,     0,     0,  1530,
       0,  1066,  1066,  1066,  1066,  1000,     0,     0,  4020,     0,
       0,  4378,     0,     0,  3529,     0,     0,     0,  3529,     0,
       0,     0,     0,     0,  4391,     0,     0,  1530,     0, -2100,
       0,     0,  1530,     0,     0,     0,     0,     0,  4401,     0,
       0,  1881,     0,     0,  1530,     0,     0,     0,     0,     0,
       0,     0, -2100,  1200, -2100, -2100,     0,     0,     0,     0,
       0,  3590,  1889,     0,     0,  2977,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     996,     0,     0,  1530,     0,     0,     0, -2100,     0,     0,
   -2100, -2100,     0, -2100,     0,     0,     0,     0,  1165,     0,
       0,     0,     0,  3140,  3140,     0,     0,     0,  1165,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4454,     0,     0,
    1892,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1165,     0,     0,     0,  1169,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1169,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2043,     0,     0,     0,     0,
       0,     0,     0,     0,  3799,  3799,  3799,  3799,  3799,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1530,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1169,  2444,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1892,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1066,     0,  4559,     0,     0,     0,     0,
       0,     0,     0,  1881,     0,  1165,     0,     0,  1881,  1881,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1881,  1889,     0,  1530,     0,     0,     0,     0,     0,     0,
       0,     0,  1530,     0,  1165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1530,
    1530,     0,     0,  1530,     0,     0,     0,     0,     0,     0,
    4020,     0,  1165,  1165,  3529,  1165,     0,     0,     0,  3529,
       0,     0,  3529,  3197,  1889,  4603,     0,  1530,  1530,     0,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1889,     0,     0,     0,     0,     0,     0,     0,     0,
    4095,  1200,  1169,  1169,  1169,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1165,   814,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1163,  1200,     0,     0,     0,
       0,     0,     0,  1881,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1165,     0,     0,     0,  1165,  1165,     0,
       0,  1889,     0,     0,     0,     0,  2043,     0,     0,     0,
       0,     0,  1163,     0,     0,     0,     0,     0,     0,     0,
    1889,  1066,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3140,     0,  2444,     0,     0,     0,  1889,     0,
       0,     0,     0,     0,     0,     0,     0,  4291,     0,     0,
       0,     0,  1066,  1881,     0,     0,     0,     0,     0,     0,
    1169,  4095,     0,     0,     0,     0,  1889,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1892,     0,     0,     0,
       0,     0,   814,     0,     0,  1530,     0,     0,  1530,  1027,
    1530,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1530,     0,     0,
       0,  3529,     0,     0,  4603,     0,     0,     0,     0,     0,
    4737,  1027,     0,     0,  1889,     0,     0,     0,     0,  1892,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1169,     0,     0,     0,  1066,     0,     0,     0,
       0,     0,  1881,     0,     0,     0,  1892,     0,     0,     0,
       0,     0,     0,  1169,  1169,  1169,  1169,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1530,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1892,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1892,     0,     0,     0,     0,
       0,  1530,     0,     0,     0,     0,     0,  1169,     0,  1200,
       0,     0,     0,  1892,     0,     0,     0,     0,  1530,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   814,     0,     0,  1883,
       0,  1892,     0,     0,     0,     0,     0,     0,     0,  1169,
       0,     0,     0,  1163,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4095,     0,     0,     0,     0,     0,     0,
    1889,     0,  4559,     0,     0,     0,     0,     0,     0,     0,
       0,  4737,     0,     0,  1530,  1530,     0,     0,     0,     0,
       0,     0,     0,  1165,     0,     0,     0,  1163,     0,  1892,
       0,     0,  1165,     0,     0,  1169,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1530,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1530,     0,     0,     0,     0,  1169,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1165,
       0,     0,     0,     0,     0,     0,  1883,     0,     0,     0,
       0,  1530,     0,  1881,     0,     0,     0,     0,     0,     0,
    1163,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1165,  1165,     0,     0,
       0,     0,     0,     0,  1165,     0,     0,  1165,     0,     0,
       0,  1165,     0,  1881,  1881,     0,  1881,     0,     0,  1165,
    1165,     0,     0,     0,     0,     0,     0,  1165,     0,     0,
    1165,  1165,  1165,  1165,     0,     0,     0,     0,     0,     0,
    1165,  1165,     0,  1165,     0,  1165,  1165,     0,     0,  1165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1892,  1165,   814,  1881,     0,
    1881,  1165,     0,     0,     0,  1165,     0,     0,     0,  1165,
       0,  1165,  1165,  1165,  1165,  1165,  1165,  1165,  1165,  1165,
       0,  1165,     0,     0,     0,     0,     0,  1165,     0,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1889,     0,     0,     0,     0,  1889,  1889,     0,
       0,     0,     0,  1881,     0,     0,     0,     0,     0,  1889,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1881,     0,     0,
       0,     4,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     0,     0,  1881,     0,     0,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,  1881,     0,     9,
      10,     0,     0,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,  1883,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1881,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     814,     0,  1889,     0,  1881,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1881,     0,     0,
      46,     0,     0,     0,     0,     0,     0,     0,  1883,  1165,
       0,     0,     0,     0,     0,  1165,     0,     0,     0,     0,
       0,  1165,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1883,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1027,  1889,     0,     0,     0,     0,  1892,     0,     0,
       0,     0,  1892,  1892,     0,  1881,     0,     0,     0,     0,
      47,     0,     0,     0,  1892,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1881,    48,     0,     0,     0,
     814,     0,     0,   814,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1883,    49,     0,     0,     0,
    1881,     0,  1027,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1883,     0,     0,     0,    50,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1883,     0,     0,     0,  1881,     0,     0,     0,
       0,  1889,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    51,     0,     0,    52,     0,     0,     0,     0,
    1883,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      53,     0,     0,     0,     0,     0,     0,     0,  1025,     0,
       0,     0,     0,     0,     0,     0,  1025,     0,  1025,     0,
       0,     0,     0,     0,     0,  1165,     0,  1892,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1883,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    54,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1892,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    56,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    57,  1165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1881,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      58,     0,     0,     0,     0,     0,    59,     0,     0,     0,
      60,    61,    62,    63,    64,     0,     0,    65,    66,  1349,
       0,     0,     0,     0,    71,  1350,  1892,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1165,     0,     0,     0,     0,  1165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1165,  1165,     0,     0,     0,     0,  1165,     0,     0,
       0,     0,     0,     0,  1883,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1165,  1165,     0,     0,     0,  1165,     0,     0,
       0,     0,  1889,     0,     0,     0,     0,     0,     0,  1165,
    1165,  1165,  1165,     0,     0,     0,     0,   814,     0,     0,
       0,     0,  1165,   814,     0,  1165,     0,  1165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1165,  1165,  1881,
       0,  1165,  1889,  1889,     0,  1889,     0,     0,     0,     0,
       0,     0,     0,     0,  1165,     0,  1165,     0,     0,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1881,     0,     0,     0,     0,  1165,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1165,     0,  1165,
    1165,  1165,     0,     0,     0,     0,     0,  1889,     0,  1889,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1165,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1165,     0,     0,     0,
       0,  1165,     0,     0,     0,     0,     0,     0,  1165,     0,
       0,     0,     0,     0,  1165,     0,     0,     0,     0,     0,
       0,     0,  1889,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1889,     0,     0,     0,
       0,     0,  1881,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1881,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1889,  1165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1889,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1892,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1883,     0,     0,     0,
       0,  1883,  1883,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1883,     0,     0,     0,  1892,  1892,     0,
    1892,     0,     0,     0,     0,     0,     0,     0,     0,  1889,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1889,     0,     0,     0,     0,     0,   814,
     814,   814,     0,     0,  1881,     0,  1889,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1892,     0,  1892,     0,     0,     0,     0,     0,
       0,     0,  1881,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1881,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1161,     0,
       0,     0,     0,     0,     0,     0,  1161,     0,     0,     0,
       0,     0,     0,     0,  1889,     0,     0,  1892,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1881,     0,
       0,     0,     0,     0,  1889,     0,  1883,  1161,     0,     0,
       0,  1892,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1889,
       0,     0,     0,   814,     0,     0,     0,     0,  1892,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     814,  1892,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1161,     0,     0,     0,  1889,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,  1883,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1892,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1892,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1892,     0,     0,     0,     0,     0,     0,     0,     0,
    1881,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1165,     0,     0,     0,  1883,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,  1025,     0,     0,     0,
    1025,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1165,     0,     0,  1892,
       0,     0,     0,     0,     0,  1161,  1165,     0,     0,     0,
       0,     0,  1165,     0,  1165,     0,     0,     0,     0,  1892,
    1165,     0,     0,  1165,  1165,  1165,  1165,  1165,  1165,  1165,
    1165,  1165,  1165,     0,     0,     0,  1165,  1165,     0,     0,
       0,     0,     0,     0,  1892,     0,     0,     0,  1889,  1165,
       0,     0,     0,  1165,  1881,   814,     0,  1165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1165,     0,     0,
    1165,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
    1892,  1165,  1165,  1165,     0,     0,     0,  1165,     0,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,  1165,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1881,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1161,     0,
       0,     0,     0,     0,     0,  1165,     0,     0,  1161,  1881,
       0,  1165,     0,     0,     0,     0,     0,  1165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1890,     0,     0,     0,     0,     0,     0,     0,  1889,  1881,
       0,     0,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1161,     0,     0,     0,     0,     0,     0,
    1889,     0,     0,     0,     0,     0,     0,     0,  1881,     0,
       0,     0,  1881,  1881,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1883,     0,   814,     0,
       0,     0,   814,  1892,   814,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1883,  1883,     0,  1883,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1889,     0,     0,     0,     0,     0,  1890,     0,     0,
       0,     0,  1889,     0,     0,     0,     0,     0,     0,     0,
       0,  1883,     0,  1883,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1165,     0,
       0,     0,     0,     0,  1161,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1883,     0,     0,     0,
       0,     0,     0,  1892,     0,     0,     0,     0,     0,     0,
       0,     0,  1161,  1161,     0,  1161,     0,     0,     0,     0,
    1883,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1161,     0,     0,  1892,  1165,  1165,     0,     0,
       0,     0,     0,  1889,     0,     0,     0,  1883,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1883,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1889,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1889,  1161,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1165,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1161,     0,     0,     0,  1161,  1161,     0,
       0,     0,     0,  1883,     0,     0,     0,  1889,     0,     0,
       0,     0,     0,  1165,     0,     0,     0,  1883,     0,     0,
       0,     0,     0,  1165,  1165,     0,  1892,     0,     0,     0,
    1883,  1165,  1165,     0,     0,     0,  1165,  1892,     0,     0,
       0,     0,  1165,  1165,     0,     0,  1165,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1165,     0,     0,     0,  1165,     0,     0,     0,     0,
       0,     0,     0,     0,  1165,     0,  1890,     0,     0,  1165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1025,
       0,  1165,     0,     0,     0,     0,     0,     0,  1883,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1883,     0,
       0,  1025,     0,     0,     0,     0,     0,     0,     0,  1890,
    1165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1883,     0,     0,     0,     0,  1892,     0,
       0,     0,     0,     0,     0,     0,  1890,     0,     0,  1889,
       0,     0,     0,     0,     0,     0,     0,   814,     0,     0,
       0,     0,     0,     0,     0,     0,  1892,     0,     0,  1883,
       0,     0,     0,     0,     0,     0,     0,     0,  1892,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1884,     0,
       0,     0,     0,     0,     0,     0,  1890,     0,     0,     0,
       0,     0,  1892,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1890,     0,     0,     0,     0,
       0,     0,   814,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1890,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1889,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1890,     0,     0,     0,  1165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1161,     0,     0,     0,  1892,     0,  1890,
       0,     0,  1161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1889,     0,     0,     0,     0,
       0,     0,  1883,     0,     0,  1884,     0,     0,     0,     0,
    1165,     0,     0,     0,  1892,     0,     0,     0,  1889,  1165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1165,  1165,     0,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,  1889,     0,
       0,  1165,     0,     0,     0,     0,  1165,     0,     0,  1165,
       0,     0,     0,     0,  1165,  1165,     0,     0,     0,  1161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1889,     0,     0,
       0,  1889,  1889,     0,     0,     0,     0,  1165,     0,     0,
       0,     0,     0,     0,     0,     0,  1161,  1161,     0,     0,
       0,     0,     0,     0,  1161,     0,     0,  1161,     0,     0,
       0,  1161,     0,     0,     0,     0,     0,     0,  1892,  1161,
    1161,     0,  1165,     0,     0,     0,     0,  1161,     0,     0,
    1161,  1161,  1161,  1161,     0,     0,     0,     0,     0,     0,
    1161,  1161,  1883,  1161,     0,  1161,  1161,     0,     0,  1161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1165,
       0,     0,     0,     0,     0,  1890,  1161,     0,     0,     0,
       0,  1161,     0,     0,  1883,  1161,     0,     0,     0,  1161,
       0,  1161,  1161,  1161,  1161,  1161,  1161,  1161,  1161,  1161,
       0,  1161,     0,     0,     0,     0,     0,  1161,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,  1165,     0,
    1892,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1165,  1892,     0,  1165,     0,  1165,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1165,     0,     0,     0,  1165,     0,
       0,     0,  1161,  1892,  1884,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1883,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1883,     0,     0,   814,
       0,     0,  1892,     0,     0,     0,  1892,  1892,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1884,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1165,     0,     0,     0,  1884,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1892,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1161,
       0,     0,     0,     0,     0,  1161,     0,     0,  1165,     0,
       0,  1161,     0,     0,     0,     0,     0,  1883,     0,     0,
       0,     0,     0,     0,  1884,  1165,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1025,     0,  1884,     0,  1883,     0,  1890,     0,     0,
       0,     0,  1890,  1890,     0,     0,     0,  1883,     0,     0,
    1165,  1884,     0,     0,  1890,     0,     0,     0,     0,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1884,
       0,  1165,  1165,     0,     0,     0,     0,     0,     0,     0,
       0,  1883,  1025,     0,  1165,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   908,     0,     0,     0,     0,     0,     0,     0,
    1165,   908,     0,     0,     0,     0,     0,  1884,     0,     0,
    1165,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   814,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   908,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,  1890,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1165,     0,
       0,     0,     0,   814,  1080,     0,     0,  1165,     0,     0,
       0,   814,     0,     0,     0,     0,     4,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     0,     0,     0,
       0,     0,     0,  1883,     0,     0,     6,     7,     0,     0,
       0,     0,     8,     0,     9,    10,     0,  1890,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,    36,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1884,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1890,  1883,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,  1161,     0,     0,     0,  1129,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1161,  1161,     0,     0,     0,     0,  1161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    47,     0,     0,     0,     0,
       0,     0,  1161,  1161,     0,     0,     0,  1161,     0,     0,
       0,    48,     0,     0,     0,     0,     0,     0,     0,  1161,
    1161,  1161,  1161,     0,     0,     0,     0,     0,     0,  1883,
       0,    49,  1161,     0,     0,  1161,     0,  1161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,  1161,     0,
       0,  1161,  1883,    50,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1161,     0,  1161,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1883,     0,     0,     0,  1161,    51,     0,     0,
      52,     0,     0,     0,     0,     0,     0,  1161,     0,  1161,
    1161,  1161,     0,     0,     0,    53,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1883,     0,  1161,     0,  1883,  1883,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1161,     0,     0,     0,
       0,  1161,     0,     0,     0,     0,     0,     0,  1161,     0,
       0,     0,     0,     0,  1161,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    54,     0,
       0,     0,     0,     0,     0,  1884,     0,     0,     0,     0,
    1884,  1884,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1884,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1161,   908,   908,     0,     0,     0,
      55,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    56,     0,     0,  1890,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    57,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1129,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    58,     0,  1890,  1890,     0,
    1890,    59,     0,     0,     0,    60,    61,    62,    63,    64,
       0,     0,    65,    66,    67,    68,     0,    69,    70,    71,
      72,    73,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1890,     0,  1890,  1884,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1175,     0,     0,     0,     0,  1890,     0,     0,
       0,  1202,     0,  1205,     0,  1208,     0,  1210,     0,     0,
       0,     0,     0,     0,     0,  1884,     0,     0,     0,     0,
       0,  1890,     0,     0,     0,     0,  1259,     0,     0,     0,
       0,     0,     0,  1266,     0,     0,     0,     0,     0,     0,
       0,     0,  1281,  1282,     0,     0,     0,  1284,  1890,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1890,     0,  1129,     0,   908,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1313,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1334,     0,     0,  1336,     0,  1338,
       0,  1341,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1884,   908,     0,     0,     0,     0,
       0,     0,     0,     0,  1890,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1890,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1890,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1420,     0,  1421,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1161,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1129,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1161,     0,     0,  1890,
       0,     0,     0,     0,     0,     0,  1161,     0,     0,     0,
       0,     0,  1161,     0,  1161,  1080,     0,     0,     0,  1890,
    1161,     0,     0,  1161,  1161,  1161,  1161,  1161,  1161,  1161,
    1161,  1161,  1161,     0,     0,     0,  1161,  1161,     0,     0,
       0,     0,     0,     0,  1890,     0,     0,     0,     0,  1161,
       0,     0,     0,  1161,     0,     0,     0,  1161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1161,     0,     0,
    1161,     0,  1161,     0,     0,     0,     0,     0,     0,     0,
    1890,  1161,  1161,  1161,     0,     0,  1679,  1161,  1681,     0,
    1161,     0,  1683,     0,     0,     0,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,  1161,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1824,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,     0,
    1837,  1161,     0,     0,     0,     0,     0,  1161,     0,     0,
       0,  1845,     0,     0,   663,     0,     0,     0,  1847,   707,
       0,   707,     0,     0,     0,  1884,     0,     0,     0,     0,
    1898,   707,  1161,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   707,     0,     0,
       0,     0,  1940,     0,     0,  1884,  1884,   707,  1884,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   707,   707,
       0,     0,   707,     0,     0,     0,     0,     0,   707,     0,
       0,     0,   988,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1890,     0,     0,     0,     0,     0,     0,
       0,     0,   988,     0,     0,     0,     0,     0,     0,     0,
    1884,     0,  1884,     0,     0,     0,     0,     0,   707,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1886,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1884,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1884,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1884,     0,  1161,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1884,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1890,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1890,  1161,  1161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1886,  1884,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1884,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1884,
       0,     0,     0,     0,     0,     0,   707,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1161,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1080,  2255,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1161,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1161,  1161,     0,  1890,  1884,     0,     0,
       0,  1161,  1161,     0,     0,     0,  1161,  1890,     0,     0,
       0,     0,  1161,  1161,     0,     0,  1161,  1884,     0,  2322,
       0,     0,  2322,     0,     0,     0,     0,     0,     0,     0,
    2329,  1161,     0,     0,     0,  1161,     0,     0,     0,     0,
       0,     0,  1884,     0,  1161,     0,     0,     0,  2338,  1161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1161,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1884,     0,
       0,     0,     0,     0,     0,  2401,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1890,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1890,     0,   707,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1890,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1886,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   707,   707,     0,     0,     0,     0,     0,     0,
       0,     0,  1890,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1886,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     707,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1886,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1161,     0,     0,     0,     0,
       0,  1884,  2596,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2618,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1890,     0,     0,
    1886,     0,     0,     0,     0,     0,     0,     0,     0,  2663,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1886,
       0,     0,     0,     0,  2678,     0,  2680,     0,  2681,     0,
    1161,     0,     0,  2682,  1890,     0,     0,  1886,     0,  1161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1161,  1161,     0,     0,
    1161,     0,     0,     0,     0,  1886,     0,     0,     0,     0,
       0,  1161,     0,     0,     0,     0,  1161,     0,     0,  1161,
       0,     0,  2710,     0,  1161,  1161,     0,     0,     0,     0,
       0,     0,     0,     0,  2255,     0,     0,     0,  2255,     0,
    2255,  1884,     0,  2255,     0,     0,     0,     0,     0,  1301,
     707,     0,   707,     0,     0,     0,     0,  1161,     0,     0,
       0,     0,     0,  1886,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1884,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1890,     0,
       0,     0,  1161,     0,     0,     0,     0,     0,   707,     0,
       0,   707,   707,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   663,     0,   988,     0,   988,     0,
       0,     0,     0,     0,   663,     0,     0,     0,   707,  1161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   988,   988,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1161,     0,
    1890,  2919,     0,     0,  1884,     0,     0,   707,     0,   707,
       0,     0,     0,     0,     0,  1884,     0,     0,     0,     0,
       0,     0,  1161,  1890,     0,  1161,     0,  1161,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1161,     0,     0,     0,  1161,     0,
       0,     0,     0,  1890,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1886,
       0,     0,     0,     0,     0,     0,   663,     0,     0,     0,
       0,     0,  1890,     0,     0,     0,  1890,  1890,     0,     0,
     663,   663,     0,     0,  1661,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1884,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,  1129,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   663,
       0,     0,     0,     0,  1884,  3007,  3008,     0,  1890,     0,
    3011,  3012,     0,     0,  3015,     0,  1884,     0,     0,     0,
       0,     0,     0,     0,  3025,     0,     0,     0,     0,     0,
       0,  3034,     0,     0,     0,  3037,  3038,     0,  1161,  3041,
    3042,  3043,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3057,     0,  3059,     0,  1161,     0,     0,     0,     0,
    1884,     0,     0,     0,     0,     0,     0,     0,     0,  3081,
       0,     0,     0,     0,  3083,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,     0,     0,     0,     0,  3101,  3102,  3105,  3107,     0,
       0,     0,  3114,  3117,     0,     0,     0,     0,     0,     0,
    3128,  1161,  1161,  3132,     0,     0,     0,  3136,     0,     0,
       0,     0,     0,     0,  1161,     0,     0,     0,     0,     0,
       0,     0,     0,  3159,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3166,     0,  3168,     0,     0,     0,
       0,  3171,     0,     0,     0,     0,  3175,  3176,  3177,  3178,
    1161,  3180,     0,     0,     0,     0,     0,     0,     0,     0,
    1161,     0,     0,   663,  3203,  3204,  3205,     0,   707,     0,
     707,     0,     0,   707,     0,   707,  3213,  3214,   707,   707,
     707,  1886,     0,     0,  2038,     0,  1886,  1886,     0,     0,
       0,   707,  1884,     0,     0,     4,     0,     0,  1886,     0,
       0,     0,     0,     0,   707,     0,   707,     0,     0,     0,
       0,   707,     0,     0,     0,     5,     0,     0,  1161,     0,
       0,     0,     0,     0,     0,     6,     7,  1161,     0,     0,
       0,     0,  3273,     9,    10,     0,     0,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1884,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,  2195,     0,
       0,  1886,     0,     0,     0,     0,     0,   707,   707,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1129,
       0,     0,     0,     0,   663,     0,     0,     0,     0,   663,
     663,     0,  2255,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3398,     0,     0,     0,    47,     0,     0,     0,  1884,     0,
       0,  1886,     0,     0,     0,     0,     0,     0,     0,     0,
      48,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1884,     0,     0,     0,     0,     0,     0,     0,     0,
      49,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   707,     0,   663,     0,     0,     0,     0,     0,     0,
       0,  1884,    50,  2326,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    51,     0,     0,    52,
    1884,     0,     0,     0,  1884,  1884,     0,     0,     0,     0,
    1886,     0,     0,     0,    53,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   663,     0,     0,     0,
       0,     0,     0,     0,   663,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   663,     0,     0,   663,   663,     0,    54,     0,     0,
       0,     0,  3569,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    55,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    56,     0,     0,   663,     0,     0,     0,
       0,     0,  3610,  3611,     0,     0,     0,     0,    57,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2255,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    58,     0,     0,     0,     0,     0,
      59,     0,     0,     0,    60,    61,    62,    63,    64,     0,
       0,    65,    66,  1349,  1995,     0,     0,     0,    71,     0,
       0,     0,  3644,  3646,     0,     0,     0,  3646,     0,     0,
       0,     0,  3657,  3658,  3659,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3680,  3681,
    3682,  3683,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3708,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1886,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   707,     0,   707,     0,     0,     0,   707,
       0,   707,     0,     0,   707,     0,     0,     0,   707,     0,
       0,     0,     0,  2195,     0,     0,     0,     0,     0,     0,
       0,  1886,  1886,     0,  1886,     0,  3746,     0,     0,     0,
       0,     0,     0,     0,  3750,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1886,     0,  1886,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3831,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3837,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3856,  1886,  3858,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1886,     0,     0,     0,     0,
       0,  2038,     0,     0,     0,     0,     0,   908,  2920,     0,
    3898,     0,  1166,     0,     0,     0,     0,  2326,     0,     0,
    1166,     0,  1886,     0,  3908,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1886,     0,  2255,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   663,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1886,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,  1886,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1886,     0,     0,     0,     0,
     663,     0,     0,     0,   663,     0,     0,     0,     0,     0,
    2991,     0,  1661,     0,     0,   707,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1886,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1886,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1886,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1886,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  4106,     0,  4107,
       0,     0,     0,  4109,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   663,     0,     0,     0,  4118,     0,
       0,     0,   663,     0,   663,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4126,     0,     0,     0,     0,
       0,     0,     0,     0,  4137,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4165,  4166,  4167,  4168,  4169,  4170,
    4171,     0,     0,     0,  1518,  4178,  4179,     0,  4181,  4182,
    4183,  4184,  4185,  4186,  4187,     0,     0,     0,     0,     0,
       0,     0,     0,  4194,     0,  4196,  4197,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,     0,     0,     0,  1589,
       0,     0,  1166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1893,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1886,     0,     0,
    4250,  4252,  4254,     0,     0,  4257,     0,  1166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   707,  2038,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   663,  1166,     0,     0,     0,     0,     0,
    3646,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2255,  2255,  2255,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1893,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1886,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1886,
       0,     0,     0,     0,     0,     0,     0,     0,  1166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,  1166,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2326,
       0,     0,     0,     0,   663,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1166,     0,
    1886,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1886,     0,     0,     0,     0,     0,  4444,  4445,  4446,
    4447,     0,     0,     0,     0,     0,     0,  1166,     0,  2092,
       0,  1166,  1166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4460,  4461,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4470,  4471,     0,     0,  2116,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2255,  2255,     0,  2255,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2141,  2142,     0,  2145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2185,     0,     0,     0,
    1893,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1886,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1886,     0,     0,     0,     0,     0,     0,     0,  2239,     0,
       0,     0,  1886,  1893,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4522,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2262,     0,     0,
    1893,  2272,  2275,     0,     0,     0,  4544,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1886,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4563,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1893,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1887,     0,     0,     0,     0,  2255,     0,  1893,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2255,     0,     0,     0,     0,     0,     0,  1893,     0,     0,
       0,     0,     0,   663,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   663,     0,     0,     0,
       0,     0,     0,     0,     0,  1893,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1886,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4649,     0,     0,     0,     0,     0,     0,  1166,     0,     0,
       0,     0,     0,  1893,     0,     0,  1166,     0,     0,     0,
       0,     0,  1888,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   707,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4673,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1887,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3646,     0,     0,     0,     0,     0,
       0,     0,   663,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1886,  1166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2255,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2255,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1166,  1166,     0,     0,     0,     0,     0,     0,  1166,     0,
       0,  1166,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,     0,  1166,  1166,  4753,     0,     0,     0,     0,
       0,  1166,     0,     0,  1166,  1166,  1166,  1166,     0,  1888,
       0,     0,  2255,     0,  1166,  1166,     0,  1166,     0,  1166,
    1166,     0,     0,  1166,  1886,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1893,
    1166,     0,     0,     0,     0,  1166,     0,  1886,     0,  1166,
       0,     0,     0,  1166,     0,  1166,  1166,  1166,  1166,  1166,
    1166,  1166,  1166,  1166,     0,  1166,     0,     0,     0,     0,
    3646,  1166,     0,     0,  1166,     0,     0,  1886,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2255,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1886,  2991,     0,     0,
    1886,  1886,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,     0,  2785,     0,
       0,     0,  4851,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1887,     0,
       0,  2808,     0,     0,  2810,     0,     0,  2821,     0,     0,
       0,     0,     0,     0,  2828,  2833,     0,     0,     0,     0,
    2839,     0,     0,  2844,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2853,     0,     0,     0,     0,  2860,     0,     0,   663,  2872,
       0,  1887,     0,  2879,     0,  2881,  2882,  2883,  2884,  2885,
    2886,  2887,  2888,  2889,   663,  2890,     0,     0,     0,     0,
       0,  1518,     0,     0,  2915,     0,     0,     0,  1887,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1166,     0,     0,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,  1166,     0,     0,  1888,     0,
       0,     0,     0,     0,   663,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1589,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1887,     0,
       0,  1893,     0,     0,     0,     0,  1893,  1893,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1887,  1893,     0,
       0,  1888,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1887,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1888,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1887,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3039,     0,     0,     0,     0,  1888,     0,
       0,  1887,   663,     0,     0,     0,  2181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1888,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
       0,  1893,     0,     0,     0,  1888,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1888,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1893,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1888,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2326,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   663,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3249,
       0,     0,     0,     0,     0,     0,     0,  1887,     0,     0,
    1893,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,   663,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,  1166,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,  1166,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1166,  1166,  1166,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,     0,     0,  1166,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,  3370,
       0,  1166,  1166,     0,     0,  1166,     0,  1888,     0,     0,
       0,     0,     0,     0,   663,     0,     0,     0,  1166,     0,
    1166,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,  1166,  1166,  1166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1166,     0,     0,
       0,     0,     0,     0,     0,     0,  3415,     0,     0,     0,
    1166,  3421,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,     0,     0,  1166,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2833,     0,  2833,  2833,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3478,     0,     0,  3481,
       0,  3483,     0,     0,     0,     0,     0,     0,     0,  1887,
       0,     0,     0,     0,  1887,  1887,     0,     0,  1166,     0,
       0,     0,     0,     0,     0,     0,  1887,     0,  3504,  2181,
    3506,     0,     0,     0,  3509,     0,     0,   707,     0,     0,
       0,  1893,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2915,  2915,  2915,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1893,  1893,   663,  1893,     0,     0,  3566,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2262,     0,     0,     0,     0,  3578,     0,     0,     0,     0,
       0,     0,  2275,     0,     0,     0,     0,     0,     0,     0,
    2181,     0,     0,     0,     0,     0,     0,     0,     0,  1888,
       0,     0,     0,     0,  1888,  1888,  1893,     0,  1893,     0,
       0,     0,     0,     0,  2181,     0,  1888,     0,     0,  2817,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1887,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2181,
    2181,     0,     0,  2181,     0,     0,     0,     0,  3619,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1893,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2181,     0,  1893,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1887,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1893,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1893,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2181,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2181,     0,     0,  2181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1893,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1887,     0,
       0,     0,  1893,     0,     0,     0,     0,     0,     0,     0,
     663,     0,     0,     0,     0,  1893,     0,     0,     0,  1888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1166,     0,     0,  1893,     0,     0,     0,     0,     0,     0,
    1166,     0,     0,     0,     0,     0,  1166,     0,  1166,     0,
       0,     0,     0,  1893,  1166,     0,     0,  1166,  1166,  1166,
    1166,  1166,  1166,  1166,  1166,  1166,  1166,     0,  1888,     0,
    1166,  1166,     0,     0,     0,     0,     0,     0,  1893,     0,
       0,     0,     0,  1166,     0,     0,     0,  1166,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,  1166,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,  1893,  1166,  1166,  1166,     0,     0,
       0,  1166,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,  1166,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3937,     0,     0,     0,     0,     0,     0,     0,     0,  1166,
    3941,     0,     0,     0,     0,  1166,  3942,     0,  3943,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3961,  3962,     0,     0,     0,     0,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1887,
       0,  2839,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3990,     0,     0,  3993,     0,  3995,     0,     0,     0,
       0,     0,     0,     0,     0,  3999,     0,     0,     0,     0,
       0,  4004,     0,     0,  4007,     0,     0,     0,     0,  1887,
    1887,     0,  1887,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4036,     0,     0,  1893,     0,     0,
       0,     0,  4048,     0,  2915,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1887,     0,  1887,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4065,
       0,     0,     0,     0,     0,  1518,     0,     0,     0,  1888,
       0,  1589,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1887,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1888,
    1888,     0,  1888,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1887,     0,     0,     0,     0,     0,     0,
       0,     0,  1166,  2181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1887,     0,     0,     0,     0,     0,  2181,  1893,  2181,     0,
    2817,  2817,  3452,  1887,  1888,  2817,  1888,     0,     0,  2181,
       0,     0,     0,     0,     0,     0,  2181,     0,     0,     0,
       0,  2181,     0,     0,     0,     0,     0,  2181,     0,  1893,
    1166,  1166,  2181,     0,     0,     0,     0,     0,     0,     0,
       0,  2181,     0,     0,     0,  2817,  2817,     0,  2181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1888,
    2181,     0,     0,     0,     0,     0,  1887,  2181,     0,  2181,
    2181,  2181,  2181,  2181,  2181,  2181,  2181,  2181,  2181,     0,
    1887,     0,     0,  1888,     0,     0,     0,     0,     0,     0,
    1166,     0,     0,  1887,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2181,     0,     0,     0,     0,     0,     0,
    1888,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1888,     0,     0,     0,  1166,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1166,  1166,     0,
    1893,     0,     0,     0,     0,  1166,  1166,     0,     0,     0,
    1166,  1893,     0,     0,     0,     0,  1166,  1166,     0,     0,
    1166,  1887,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,  1166,
       0,  1887,     0,     0,     0,     0,  1888,     0,  1166,     0,
    4304,  4305,     0,  1166,     0,     0,     0,     0,     0,     0,
    1888,     0,     0,     0,     0,  1166,  1887,     0,     0,     0,
       0,     0,     0,  1888,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1887,     0,  1166,     0,     0,     0,     0,     0,
    4336,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1893,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1888,     0,     0,     0,     0,     0,     0,     0,     0,
    1893,     0,     0,     0,     0,     0,     0,  4354,  4356,     0,
       0,  1888,  1893,     0,     0,     0,     0,     0,     0,     0,
    4363,     0,     0,     0,     0,     0,  4368,  4369,     0,     0,
    4371,     0,     0,     0,     0,     0,  1888,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1893,     0,  2915,     0,
       0,     0,     0,  2915,     0,     0,     0,     0,     0,     0,
       0,     0,  1888,     0,     0,  2915,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4425,     0,     0,     0,     0,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1887,     0,  2181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1893,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,  1893,     0,
       0,     0,     0,  1166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1166,  1166,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1166,     0,     0,     0,     0,
    1166,     0,     0,  1166,     0,     0,     0,     0,  1166,  1166,
       0,     0,     0,     0,     0,  1888,     0,     0,  2181,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4511,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,  1887,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2181,     0,     0,     0,     0,     0,  2181,
       0,     0,  1893,     0,     0,     0,  1166,  1887,     0,     0,
       0,     0,     0,     0,     0,  3452,  3452,     0,  2817,     0,
       0,  2817,  2817,  2817,  2817,  2817,  2817,  2817,  2817,  2817,
    2817,  3452,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1166,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2181,     0,     0,  2181,
       0,  2181,     0,     0,     0,     0,  3452,  3452,     0,     0,
       0,     0,     0,     0,  4589,     0,     0,     0,     0,     0,
    2817,  2817,  2181,     0,  2181,     0,     0,  2181,     0,     0,
       0,     0,  1166,     0,  1893,  1888,     0,     0,     0,  4606,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1166,  1893,  1887,  1166,
       0,  1166,     0,     0,     0,     0,     0,  1888,     0,  1887,
       0,     0,     0,     0,     0,     0,     0,     0,  1166,     0,
       0,     0,  1166,     0,  2181,     0,     0,  1893,     0,     0,
       0,     0,     0,     0,     0,     0,  2181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1893,     0,     0,     0,
    1893,  1893,     0,     0,     0,     0,     0,  2181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1888,     0,
    1887,     0,     0,     0,     0,     0,     0,     0,     0,  1888,
       0,     0,  1893,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1887,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2839,
    1887,     0,  1166,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4728,  1166,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1887,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1888,     0,     0,     0,     0,  1166,  1166,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1166,     0,
       0,     0,     0,     0,  4789,     0,     0,     0,  1888,     0,
       0,     0,     0,     0,     0,     0,  2817,     0,     0,     0,
    1888,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1166,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1888,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4833,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1887,     0,     0,     0,
       0,     0,  1166,     0,     0,     0,     0,     0,     0,     0,
       0,  1166,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2181,     0,     0,     0,  2181,
    2181,  2181,     0,     0,  3452,  4873,  4873,     0,     0,  3452,
    3452,  3452,  3452,  3452,  3452,  3452,  3452,  3452,  3452,  2181,
    2181,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2181,  2817,
    2817,  2181,     0,  2181,  4873,     0,     0,  2181,  3452,  3452,
       0,     0,  2181,     0,  4917,  2181,     0,     0,     0,     0,
    1887,     0,     0,     0,     0,     0,  1888,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    85,  2181,     0,     0,     0,     0,    89,
       0,     0,     0,    93,     0,    94,  2181,    96,    97,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   106,     0,
       0,     0,  4873,  2181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   119,   120,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1887,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   128,     0,     0,     0,  1887,     0,     0,     0,     0,
    1888,   129,     0,   130,   131,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1099,     0,
       0,     0,     0,     0,     0,  1887,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   141,     0,
     142,   143,     0,     0,     0,     0,   146,     0,   147,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   149,     0,
     150,     0,     0,     0,  1887,     0,     0,     0,  1887,  1887,
       0,     0,     0,     0,   153,     0,   154,     0,     0,   157,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   158,  1888,   159,     0,     0,     0,   160,     0,     0,
       0,     0,     0,   161,     0,     0,     0,     0,     0,     0,
     163,     0,   165,     0,     0,  1888,     0,     0,   167,     0,
       0,     0,     0,     0,     0,     0,  3452,     0,     0,     0,
       0,     0,   171,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1888,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2181,  2181,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1888,     0,   184,   185,  1888,  1888,
       0,     0,   186,     0,     0,     0,     0,     0,     0,     0,
     187,     0,     0,     0,  2181,     0,     0,     0,  2817,     0,
       0,   192,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2181,     0,  2181,     0,     0,     0,     0,  3452,
    3452,  2181,     0,     0,  2817,  2817,  2181,  2181,     0,  2181,
       0,     0,     0,     0,     0,     0,     0,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,     0,     0,   206,     0,   207,     0,     0,     0,
       0,   208,     0,     0,     0,     0,   209,     0,     0,   211,
       0,     0,     0,   213,     0,     0,     0,     0,   214,   215,
       0,     0,     0,  2181,     0,     0,   216,     0,     0,   218,
       0,     0,     0,     0,     0,     0,     0,   221,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   223,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   228,     0,   229,     0,
       0,     0,     0,     0,     0,     0,   231,     0,     0,     0,
       0,     0,   232,     0,     0,     0,     0,   233,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   236,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2181,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   246,     0,     0,     0,  -132,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3452,
    2817,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3452,  3452,  2181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2181,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3452,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2181,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2181,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2181,     0,     0,     0,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,  2181,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,  2181,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   724,
     421,   422,   423,   725,   726,   727,   728,   729,   730,   731,
     424,   425,   732,   426,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,   733,   431,   432,   433,   434,   435,
     734,   735,   436,   437,   736,   140,   438,   737,   439,   440,
     441,   442,   144,   738,   145,   739,   443,   444,   445,   446,
     148,   447,   740,   741,   448,   449,   450,   451,   452,   453,
     742,   151,   454,   743,   744,   745,   746,   152,   747,   748,
     749,   455,   456,   457,   458,   686,   459,   155,   156,   460,
     750,   461,   751,   462,   463,   464,   465,   466,   752,   467,
     468,   469,   753,   754,   470,   471,   472,   473,   474,   755,
     475,   476,   477,   756,   478,   479,   757,   480,   481,   482,
     483,   164,   484,   485,   486,   166,   758,   487,   759,   488,
     168,   489,   760,   490,   761,   491,   169,   762,   170,   492,
     493,   494,   763,   495,   172,   764,   496,   765,   497,   498,
     688,   499,   500,   173,   501,   502,   503,   766,   504,   505,
     506,   507,   508,   509,   767,   510,   174,   175,   768,   511,
     512,   513,   769,   176,   770,   177,   771,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,   772,
     523,   181,   182,   524,   183,   773,   525,   526,   527,   774,
     775,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,   189,   190,   538,   539,   191,   776,
     540,   541,   193,   542,   777,   194,   543,   195,   544,   545,
     546,   778,   547,   779,   780,   548,   549,   550,   781,   782,
     196,   197,   198,   199,   200,   551,   552,   553,   554,   555,
     556,   557,   783,   558,   201,   559,   202,   560,   561,   562,
     784,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,   785,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,   786,   584,   585,   210,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,   787,
     595,   596,   597,   598,   599,   788,   600,   217,   601,   602,
     219,   603,   220,   604,   789,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,   790,   615,   616,   791,
     617,   618,   619,   620,   621,   622,   792,   224,   225,   793,
     794,   624,   226,   625,   227,   795,   626,   627,   628,   629,
     630,   631,   632,   796,   797,   633,   634,   635,   636,   637,
     798,   799,   638,   639,   640,   641,   642,   800,   234,   801,
     643,   235,   644,   645,   646,   802,   803,   647,   804,   805,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    85,     0,     0,
      86,    87,    88,    89,    90,    91,    92,    93,     0,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   950,
     104,   105,   106,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,   119,
     120,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,   127,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   128,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   129,     0,   130,   131,     0,
       0,     0,     0,     0,     0,     0,     0,   132,     0,   133,
       0,     0,   134,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,   141,     0,   142,   143,   144,     0,   145,     0,
     146,     0,   147,     0,   148,     0,     0,     0,     0,     0,
       0,     0,   149,     0,   150,   151,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,     0,   153,     0,
     154,   155,   156,   157,     0,     0,     0,     0,     0, -1350,
       0,     0,     0,     0,     0,   158,     0,   159,     0,     0,
       0,   160,     0,     0,     0,     0,     0,   161,   162,     0,
       0,     0,     0,     0,   163,   164,   165,     0,     0,   166,
       0,     0,   167,     0,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,   171,     0,   172,     0,
       0,     0,     0,     0,     0,     0,     0,   173,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     174,   175,     0,     0, -1350,     0,     0,   176,     0,   177,
       0,     0,   178,   179,     0,   180,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   181,   182,     0,   183,     0,
     184,   185,     0,     0,     0,     0,   186,     0,     0,     0,
       0,     0,     0,     0,   187,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,   192,   193,     0,     0,   194,
       0,   195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   196,   197,   198,   199,   200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   201,     0,
     202,     0,   203,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   204,   205,     0,     0,     0,     0,   206,     0,
     207,     0,     0,     0,     0,   208,     0,     0,     0,     0,
     209,   210,     0,   211,   212,     0,     0,   213,     0,     0,
       0,     0,   214,   215,     0,     0,     0,     0,     0,     0,
     216,   217,     0,   218,   219,     0,   220,     0,     0,     0,
       0,   221,     0,     0,     0,     0,     0,     0,     0,   222,
       0,     0,     0,   223,     0,     0,     0,     0,     0,     0,
       0,   224,   225,     0,     0,     0,   226,     0,   227,     0,
     228,     0,   229,     0,     0,     0,     0,   230,     0,     0,
     231,     0,     0, -1350,     0,     0,   232,     0,     0,     0,
       0,   233,   234,     0,     0,   235,     0,     0,     0,     0,
       0,     0,     0,   236,     0,     0,     0,     0,     0,   237,
     238,   239,   240,   241,   242,   243,   244,   245,    86,    87,
      88,     0,    90,    91,    92,     0,     0,     0,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   246,   104,   105,
       0,  -132,     0,   107,   108,   109,   110,     0,   111,   112,
     113,   114,   115,     0,   116,   117,   118,     0,     0,     0,
       0,     0,   121,   122,     0,     0,     0,     0,   123,     0,
       0,     0,     0,     0,     0,     0,     0,   124,     0,   125,
       0,   126,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,   145,     0,     0,     0,
       0,     0,   148,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   151,     0,     0,     0,     0,     0,   152,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   155,
     156,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   162,     0,     0,     0,
       0,     0,     0,   164,     0,     0,     0,   166,     0,     0,
       0,     0,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   172,     0,     0,     0,
       0,     0,     0,     0,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   174,   175,
       0,     0,     0,     0,     0,   176,     0,   177,     0,     0,
     178,   179,     0,   180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,     0,   183,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,   193,     0,     0,   194,     0,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,   198,   199,   200,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   210,
       0,     0,   212,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   217,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   224,
     225,     0,     0,     0,   226,     0,   227,     0,     0,     0,
       0,     0,     0,     0,     0,   230,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     234,     0,     0,   235,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   237,   238,   239,
     240,   241,   242,   243,   244,   245,     0,     0,    86,    87,
      88,     0,    90,    91,    92,     0,     0,     0,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
       0,     0,  2981,   107,   108,   109,   110,     0,   111,   112,
     113,   114,   115,     0,   116,   117,   118,     0,     0,     0,
       0,     0,   121,   122,     0,     0,     0,     0,   123,     0,
       0,     0,     0,     0,     0,     0,     0,   124,     0,   125,
       0,   126,     0,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,   145,     0,     0,     0,
       0,     0,   148,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   151,     0,     0,     0,     0,     0,   152,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   155,
     156,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   162,     0,     0,     0,
       0,     0,     0,   164,     0,     0,     0,   166,     0,     0,
       0,     0,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   172,     0,     0,     0,
       0,     0,     0,     0,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   174,   175,
       0,     0,     0,     0,     0,   176,     0,   177,     0,     0,
     178,   179,     0,   180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,     0,   183,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,   193,     0,     0,   194,     0,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,   198,   199,   200,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   210,
       0,     0,   212,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   217,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   224,
     225,     0,     0,     0,   226,     0,   227,     0,     0,     0,
       0,     0,     0,     0,     0,   230,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     234,     0,     0,   235,     0,     0,     0,     0,     0,     0,
       0,     4,     0,     0,     0,     0,     0,   237,   238,   239,
     240,   241,   242,   243,   244,   245,     0,     0,     0,     0,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,     0,     0,     9,
      10,     0,  2983,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       4,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       5,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       6,     7,     0,     0,     0,     0,     0,     0,     9,    10,
      46,     0,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      47,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    48,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    49,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    50,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    47,
       0,     0,    51,     0,     0,    52,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    48,     0,     0,     0,     0,
      53,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    49,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    50,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    51,     0,    54,    52,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    53,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    55,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    56,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    57,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    54,     0,     0,     0,     0,     0,     0,     0,
      58,     0,     0,     0,     0,     0,    59,     0,     0,     0,
      60,    61,    62,    63,    64,     0,     0,    65,    66,  1349,
    2691,     0,     0,     0,    71,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    55,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    56,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    57,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    58,
       0,     0,     0,     0,     0,    59,     0,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,  1349,     0,
       0,     0,     0,    71,   717,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,  2909,   421,
     422,   423,     0,     0,     0,     0,  1441,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,  1442,
     137,  1443,  1444,     0,   431,   432,   433,   434,   435,  1445,
    1446,   436,   437,  1447,  1448,   438,     0,   439,   440,   441,
     442,  1449,     0,  1450,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,
     455,   456,   457,   458,   686,   459,  1458,  1459,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,  2910,     0,   470,   471,  1460,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
    1461,   484,   485,   486,  1462,  1463,   487,     0,   488,  1464,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,  1465,     0,   496,     0,   497,   498,   688,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,  1466,  1467,     0,  1468,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
    1469,   182,   524,   183,     0,   525,   526,   527,  1470,  1471,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,  1472,   189,  1473,   538,   539,   191,  1474,   540,
     541,   193,   542,  1475,  1476,   543,  1477,   544,   545,   546,
       0,   547,     0,     0,  1478,   549,   550,     0,     0,   196,
     197,   198,   199,  1479,   551,   552,   553,   554,   555,   556,
     557,     0,   558,  1480,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,  1481,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,  1482,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,  1483,   600,   217,   601,   602,   219,
     603,  1484,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,  1485,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1486,  1487,     0,     0,
     624,  1488,   625,  1489,  1490,   626,   627,   628,   629,   630,
     631,   632,     0,  1491,   633,   634,   635,   636,   637,  1492,
       0,   638,   639,   640,   641,   642,   692,  1493,  2911,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,
    1499,  1500,  1501,   693,   653,   654,     0,     0,     0,     0,
       0,     0,     0,  1502,  1503,  2912,     0,     0,     0,     0,
       0,     0,  1505,  2913,   717,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,  1441,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,  1442,
     137,  1443,  1444,     0,   431,   432,   433,   434,   435,  1445,
    1446,   436,   437,  1447,  1448,   438,     0,   439,   440,   441,
     442,  1449,     0,  1450,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,
     455,   456,   457,   458,   686,   459,  1458,  1459,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,  1460,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
    1461,   484,   485,   486,  1462,  1463,   487,     0,   488,  1464,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,  1465,     0,   496,     0,   497,   498,   688,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,  1466,  1467,     0,  1468,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
    1469,   182,   524,   183,     0,   525,   526,   527,  1470,  1471,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,  1472,   189,  1473,   538,   539,   191,  1474,   540,
     541,   193,   542,  1475,  1476,   543,  1477,   544,   545,   546,
       0,   547,     0,     0,  1478,   549,   550,     0,     0,   196,
     197,   198,   199,  1479,   551,   552,   553,   554,   555,   556,
     557,     0,   558,  1480,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,  1481,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,  1482,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,  1483,   600,   217,   601,   602,   219,
     603,  1484,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,  1485,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1486,  1487,     0,     0,
     624,  1488,   625,  1489,  1490,   626,   627,   628,   629,   630,
     631,   632,     0,  1491,   633,   634,   635,   636,   637,  1492,
       0,   638,   639,   640,   641,   642,   692,  1493,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,
    1499,  1500,  1501,   693,   653,   654,     0,     0,     0,     0,
       0,     0,     0,  1502,  1503,     0,     0,     0,     0,     0,
       0,     0,  1505,  2819,   717,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,     0,  1859,
     137,  1860,  1861,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,  1862,  1863,   438,     0,   439,   440,   441,
     442,     0,     0,   145,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,     0,     0,     0,   152,     0,     0,     0,
     455,   456,   457,   458,   686,   459,  1864,  1865,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,  1460,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
       0,   484,   485,   486,     0,     0,   487,     0,   488,  1866,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,     0,     0,   496,     0,   497,   498,   688,
     499,   500,   173,   501,   502,   503,  2424,   504,   505,   506,
     507,   508,   509,     0,   510,   174,  2425,     0,   511,   512,
     513,  1466,  1867,     0,  1868,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
       0,   182,   524,   183,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,  1869,   189,  1870,   538,   539,     0,     0,   540,
     541,   193,   542,     0,     0,   543,  1871,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,  2426,
     197,   198,   199,     0,   551,   552,   553,   554,   555,   556,
     557,     0,   558,     0,   559,     0,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,  1872,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,     0,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,  2427,   601,   602,   219,
     603,  1874,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,     0,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1875,  1876,     0,     0,
     624,     0,   625,     0,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,     0,  1877,  2428,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   693,   653,   654,     0,     0,     0,     0,
     717,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,  2429,    98,    99,   100,   101,   102,   103,
     718,   104,   105,   672,   719,     0,   107,   108,   109,   110,
     720,   721,   112,   113,   114,   115,     0,   116,   722,   723,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430,     0,  1859,   137,  1860,  1861,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,  1862,
    1863,   438,     0,   439,   440,   441,   442,     0,     0,   145,
       0,   443,   444,   445,   446,   148,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,     0,     0,
       0,     0,   152,     0,     0,     0,   455,   456,   457,   458,
     686,   459,  1864,  1865,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,  1460,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,     0,   484,   485,   486,
       0,     0,   487,     0,   488,  1866,   489,     0,   490,     0,
     491,   169,     0,   170,   492,   493,   494,     0,   495,     0,
       0,   496,     0,   497,   498,   688,   499,   500,   173,   501,
     502,   503,  2424,   504,   505,   506,   507,   508,   509,     0,
     510,   174,  2425,     0,   511,   512,   513,  1466,  1867,     0,
    1868,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,     0,   182,   524,   183,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,  1869,   189,
    1870,   538,   539,     0,     0,   540,   541,   193,   542,     0,
       0,   543,  1871,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,  2426,   197,   198,   199,     0,
     551,   552,   553,   554,   555,   556,   557,     0,   558,     0,
     559,     0,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,  1872,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,     0,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,  2427,   601,   602,   219,   603,  1874,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
       0,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,  1875,  1876,     0,     0,   624,     0,   625,     0,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,     0,  1877,  2428,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   693,
     653,   654,     0,     0,     0,     0,   717,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,  3332,
      98,    99,   100,   101,   102,   103,   718,   104,   105,   672,
     719,     0,   107,   108,   109,   110,   720,   721,   112,   113,
     114,   115,     0,   116,   722,   723,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,   412,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1437,  1438,  1439,    45,  1440,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,  1441,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
     135,  1442,   137,  1443,  1444,  2829,   431,   432,   433,   434,
     435,  1445,  1446,   436,   437,  1447,  1448,   438,     0,   439,
     440,   441,   442,  1449,     0,  1450,     0,   443,   444,   445,
     446,   148,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,     0,  1451,  1452,  1453,  1454,  1455,
    1456,  1457,   455,   456,   457,   458,   686,   459,  1458,  1459,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,  1460,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,  1461,   484,   485,   486,  1462,  1463,   487,     0,
     488,  1464,   489,     0,   490,     0,   491,   169,  2830,   170,
     492,   493,   494,     0,   495,  1465,     0,   496,     0,   497,
     498,   688,   499,   500,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,   175,     0,
     511,   512,   513,  1466,  1467,     0,  1468,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
    2831,   523,  1469,   182,   524,   183,     0,   525,   526,   527,
    1470,  1471,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,  1472,   189,  1473,   538,   539,   191,
    1474,   540,   541,   193,   542,  1475,  1476,   543,  1477,   544,
     545,   546,     0,   547,     0,     0,  1478,   549,   550,     0,
       0,   196,   197,   198,   199,  1479,   551,   552,   553,   554,
     555,   556,   557,     0,   558,  1480,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,  1481,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,  1482,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,  1483,   600,   217,   601,
     602,   219,   603,  1484,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,  1485,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,  1486,  1487,
       0,  2832,   624,  1488,   625,  1489,  1490,   626,   627,   628,
     629,   630,   631,   632,     0,  1491,   633,   634,   635,   636,
     637,  1492,     0,   638,   639,   640,   641,   642,   692,  1493,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,  1494,  1495,  1496,
    1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,     0,
       0,     0,     0,     0,     0,  1502,  1503,     0,     0,     0,
       0,     0,     0,     0,  1505,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,   412,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,  1441,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
    1442,   137,  1443,  1444,     0,   431,   432,   433,   434,   435,
    1445,  1446,   436,   437,  1447,  1448,   438,     0,   439,   440,
     441,   442,  1449,     0,  1450,     0,   443,   444,   445,   446,
     148,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,
    1457,   455,   456,   457,   458,   686,   459,  1458,  1459,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,  1460,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,  1461,   484,   485,   486,  1462,  1463,   487,     0,   488,
    1464,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,  1465,     0,   496,     0,   497,   498,
     688,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,  1466,  1467,     0,  1468,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,  1469,   182,   524,   183,     0,   525,   526,   527,  1470,
    1471,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,  1472,   189,  1473,   538,   539,   191,  1474,
     540,   541,   193,   542,  1475,  1476,   543,  1477,   544,   545,
     546,     0,   547,     0,     0,  1478,   549,   550,     0,     0,
     196,   197,   198,   199,  1479,   551,   552,   553,   554,   555,
     556,   557,     0,   558,  1480,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,  1481,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
    1482,   588,   589,   590,   591,   592,   593,   691,   594,   215,
     595,   596,   597,   598,   599,  1483,   600,   217,   601,   602,
     219,   603,  1484,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,  1485,     0,   615,   616,   223,
     617,   618,   619,   620,   621,   622,     0,  1486,  1487,     0,
       0,   624,  1488,   625,  1489,  1490,   626,   627,   628,   629,
     630,   631,   632,     0,  1491,   633,   634,   635,   636,   637,
    1492,     0,   638,   639,   640,   641,   642,  2143,  1493,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,   236,
     648,   649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,
    1498,  1499,  1500,  1501,   693,   653,   654,     0,     0,     0,
       0,     0,     0,     0,  1502,  1503,     0,     0,     0,     0,
       0,     0,     0,  1505,   717,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,  1441,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,  1442,
     137,  1443,  1444,     0,   431,   432,   433,   434,   435,  1445,
    1446,   436,   437,  1447,  1448,   438,     0,   439,   440,   441,
     442,  1449,     0,  1450,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,
     455,   456,   457,   458,   686,   459,  1458,  1459,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,  1460,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
    1461,   484,   485,   486,  1462,  1463,   487,     0,   488,  1464,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,  1465,     0,   496,     0,   497,   498,   688,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,  1466,  1467,     0,  1468,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
    1469,   182,   524,   183,     0,   525,   526,   527,  1470,  1471,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,  1472,   189,  1473,   538,   539,   191,  1474,   540,
     541,   193,   542,  1475,  1476,   543,  1477,   544,   545,   546,
       0,   547,     0,     0,  1478,   549,   550,     0,     0,   196,
     197,   198,   199,  1479,   551,   552,   553,   554,   555,   556,
     557,     0,   558,  1480,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,  1481,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,  1482,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,  1483,   600,   217,   601,   602,   219,
     603,  1484,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,  1485,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1486,  1487,     0,     0,
     624,  1488,   625,  1489,  1490,   626,   627,   628,   629,   630,
     631,   632,     0,  1491,   633,   634,   635,   636,   637,  1492,
       0,   638,   639,   640,   641,   642,   692,  1493,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,
    1499,  1500,  1501,   693,   653,   654,     0,     0,     0,     0,
       0,     0,     0,  1502,  1503,     0,     0,     0,     0,     0,
    2087,  2777,  1505,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,  1441,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,  1442,   137,
    1443,  1444,     0,   431,   432,   433,   434,   435,  1445,  1446,
     436,   437,  1447,  1448,   438,     0,   439,   440,   441,   442,
    1449,     0,  1450,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,
     456,   457,   458,   686,   459,  1458,  1459,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,  1461,
     484,   485,   486,  1462,  1463,   487,     0,   488,  1464,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,  1465,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
    1466,  1467,     0,  1468,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,  1469,
     182,   524,   183,     0,   525,   526,   527,  1470,  1471,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1472,   189,  1473,   538,   539,   191,  1474,   540,   541,
     193,   542,  1475,  1476,   543,  1477,   544,   545,   546,     0,
     547,     0,     0,  1478,   549,   550,     0,     0,   196,   197,
     198,   199,  1479,   551,   552,   553,   554,   555,   556,   557,
       0,   558,  1480,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1481,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,  1482,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,  1483,   600,   217,   601,   602,   219,   603,
    1484,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,  1485,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1486,  1487,     0,     0,   624,
    1488,   625,  1489,  1490,   626,   627,   628,   629,   630,   631,
     632,     0,  1491,   633,   634,   635,   636,   637,  1492,     0,
     638,   639,   640,   641,   642,   692,  1493,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,
    1500,  1501,   693,   653,   654,     0,     0,     0,     0,     0,
       0,     0,  1502,  1503,  1504,     0,     0,     0,     0,     0,
       0,  1505,   717,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   718,   104,   105,   672,   719,     0,   107,   108,
     109,   110,   720,   721,   112,   113,   114,   115,     0,   116,
     722,   723,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,   412,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,  1441,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,  1442,   137,  1443,
    1444,     0,   431,   432,   433,   434,   435,  1445,  1446,   436,
     437,  1447,  1448,   438,     0,   439,   440,   441,   442,  1449,
       0,  1450,     0,   443,   444,   445,   446,   148,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,
     457,   458,   686,   459,  1458,  1459,   460,  1588,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,  1460,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,  1461,   484,
     485,   486,  1462,  1463,   487,     0,   488,  1464,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,  1465,     0,   496,     0,   497,   498,   688,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,  1466,
    1467,     0,  1468,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,  1469,   182,
     524,   183,     0,   525,   526,   527,  1470,  1471,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
    1472,   189,  1473,   538,   539,   191,  1474,   540,   541,   193,
     542,  1475,  1476,   543,  1477,   544,   545,   546,     0,   547,
       0,     0,  1478,   549,   550,     0,     0,   196,   197,   198,
     199,  1479,   551,   552,   553,   554,   555,   556,   557,     0,
     558,  1480,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,  1481,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,  1482,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,  1483,   600,   217,   601,   602,   219,   603,  1484,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,  1485,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,  1486,  1487,     0,     0,   624,  1488,
     625,  1489,  1490,   626,   627,   628,   629,   630,   631,   632,
       0,  1491,   633,   634,   635,   636,   637,  1492,     0,   638,
     639,   640,   641,   642,   692,  1493,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,
    1501,   693,   653,   654,     0,     0,     0,     0,     0,     0,
       0,  1502,  1503,     0,     0,     0,     0,     0,     0,     0,
    1505,   717,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   718,   104,   105,   672,   719,     0,   107,   108,   109,
     110,   720,   721,   112,   113,   114,   115,     0,   116,   722,
     723,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,   412,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1437,
    1438,  1439,    45,  1440,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,  2270,   421,   422,   423,     0,
       0,     0,     0,  1441,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,  1442,   137,  1443,  1444,
       0,   431,   432,   433,   434,   435,  1445,  1446,   436,   437,
    1447,  1448,   438,     0,   439,   440,   441,   442,  1449,     0,
    1450,     0,   443,   444,   445,   446,   148,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
    1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,   457,
     458,   686,   459,  1458,  1459,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,  1460,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,  1461,   484,   485,
     486,  1462,  1463,   487,     0,   488,  1464,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
    1465,     0,   496,     0,   497,   498,   688,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,  1466,  1467,
       0,  1468,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,  1469,   182,   524,
     183,     0,   525,   526,   527,  1470,  1471,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,  1472,
     189,  1473,   538,   539,   191,  1474,   540,   541,   193,   542,
    1475,  1476,   543,  1477,   544,   545,   546,     0,   547,     0,
       0,  1478,   549,   550,     0,     0,   196,   197,   198,   199,
    1479,   551,   552,   553,   554,   555,   556,   557,     0,   558,
    1480,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,  1481,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,  1482,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,  1483,   600,   217,   601,   602,   219,   603,  1484,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,  1485,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,  1486,  1487,     0,     0,   624,  1488,   625,
    1489,  1490,   626,   627,   628,   629,   630,   631,   632,     0,
    1491,   633,   634,   635,   636,   637,  1492,     0,   638,   639,
     640,   641,   642,   692,  1493,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,
     693,   653,   654,     0,     0,     0,     0,     0,     0,     0,
    1502,  1503,     0,     0,     0,     0,     0,     0,     0,  1505,
     717,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     718,   104,   105,   672,   719,     0,   107,   108,   109,   110,
     720,   721,   112,   113,   114,   115,     0,   116,   722,   723,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1437,  1438,
    1439,    45,  1440,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,  1441,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430,   135,  1442,   137,  1443,  1444,     0,
     431,   432,   433,   434,   435,  1445,  1446,   436,   437,  1447,
    1448,   438,     0,   439,   440,   441,   442,  1449,     0,  1450,
       0,   443,   444,   445,   446,   148,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,     0,  1451,
    1452,  1453,  1454,  1455,  1456,  1457,   455,   456,   457,   458,
     686,   459,  1458,  1459,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,  1460,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,  1461,   484,   485,   486,
    1462,  1463,   487,     0,   488,  1464,   489,     0,   490,     0,
     491,   169,  2830,   170,   492,   493,   494,     0,   495,  1465,
       0,   496,     0,   497,   498,   688,   499,   500,   173,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,   174,   175,     0,   511,   512,   513,  1466,  1467,     0,
    1468,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,  1469,   182,   524,   183,
       0,   525,   526,   527,  1470,  1471,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,  1472,   189,
    1473,   538,   539,   191,  1474,   540,   541,   193,   542,  1475,
    1476,   543,  1477,   544,   545,   546,     0,   547,     0,     0,
    1478,   549,   550,     0,     0,   196,   197,   198,   199,  1479,
     551,   552,   553,   554,   555,   556,   557,     0,   558,  1480,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,  1481,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,  1482,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
    1483,   600,   217,   601,   602,   219,   603,  1484,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
    1485,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,  1486,  1487,     0,     0,   624,  1488,   625,  1489,
    1490,   626,   627,   628,   629,   630,   631,   632,     0,  1491,
     633,   634,   635,   636,   637,  1492,     0,   638,   639,   640,
     641,   642,   692,  1493,     0,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,
     653,   654,     0,     0,     0,     0,     0,     0,     0,  1502,
    1503,     0,     0,     0,     0,     0,     0,     0,  1505,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1437,  1438,  1439,
      45,  1440,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,  1441,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,   135,  1442,   137,  1443,  1444,     0,   431,
     432,   433,   434,   435,  1445,  1446,   436,   437,  1447,  1448,
     438,     0,   439,   440,   441,   442,  1449,     0,  1450,     0,
     443,   444,   445,   446,   148,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,  1451,  1452,
    1453,  1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,
     459,  1458,  1459,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
    1460,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,  1461,   484,   485,   486,  1462,
    1463,   487,     0,   488,  1464,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,  1465,     0,
     496,     0,   497,   498,   688,   499,   500,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,  1466,  1467,     0,  1468,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,  1469,   182,   524,   183,     0,
     525,   526,   527,  1470,  1471,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,  1472,   189,  1473,
     538,   539,   191,  1474,   540,   541,   193,   542,  1475,  1476,
     543,  1477,   544,   545,   546,     0,   547,     0,     0,  1478,
     549,   550,     0,     0,   196,   197,   198,   199,  1479,   551,
     552,   553,   554,   555,   556,   557,     0,   558,  1480,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,  1481,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,  1482,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,  1483,
     600,   217,   601,   602,   219,   603,  1484,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,  1485,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,  1486,  1487,     0,     0,   624,  1488,   625,  1489,  1490,
     626,   627,   628,   629,   630,   631,   632,     0,  1491,   633,
     634,   635,   636,   637,  1492,     0,   638,   639,   640,   641,
     642,   692,  1493,  4051,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
    1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,
     654,     0,     0,     0,     0,     0,     0,     0,  1502,  1503,
       0,     0,     0,     0,     0,     0,     0,  1505,   717,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   718,   104,
     105,   672,   719,     0,   107,   108,   109,   110,   720,   721,
     112,   113,   114,   115,     0,   116,   722,   723,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,   412,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,  1437,  1438,  1439,    45,
    1440,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
    1441,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,   135,  1442,   137,  1443,  1444,     0,   431,   432,
     433,   434,   435,  1445,  1446,   436,   437,  1447,  1448,   438,
       0,   439,   440,   441,   442,  1449,     0,  1450,     0,   443,
     444,   445,   446,   148,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,  4064,  1451,  1452,  1453,
    1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,   459,
    1458,  1459,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,  1460,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,  1461,   484,   485,   486,  1462,  1463,
     487,     0,   488,  1464,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,  1465,     0,   496,
       0,   497,   498,   688,   499,   500,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,  1466,  1467,     0,  1468,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,  1469,   182,   524,   183,     0,   525,
     526,   527,  1470,  1471,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,  1472,   189,  1473,   538,
     539,   191,  1474,   540,   541,   193,   542,  1475,  1476,   543,
    1477,   544,   545,   546,     0,   547,     0,     0,  1478,   549,
     550,     0,     0,   196,   197,   198,   199,  1479,   551,   552,
     553,   554,   555,   556,   557,     0,   558,  1480,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,  1481,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,  1482,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,  1483,   600,
     217,   601,   602,   219,   603,  1484,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,  1485,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
    1486,  1487,     0,     0,   624,  1488,   625,  1489,  1490,   626,
     627,   628,   629,   630,   631,   632,     0,  1491,   633,   634,
     635,   636,   637,  1492,     0,   638,   639,   640,   641,   642,
     692,  1493,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,  1494,
    1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,
       0,     0,     0,     0,     0,     0,     0,  1502,  1503,     0,
       0,     0,     0,     0,     0,     0,  1505,   717,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   718,   104,   105,
     672,   719,     0,   107,   108,   109,   110,   720,   721,   112,
     113,   114,   115,     0,   116,   722,   723,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,   412,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1437,  1438,  1439,    45,  1440,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,  1441,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,  4870,  1442,   137,  1443,  1444,     0,   431,   432,   433,
     434,   435,  1445,  1446,   436,   437,  1447,  1448,   438,     0,
     439,   440,   441,   442,  1449,     0,  1450,     0,   443,   444,
     445,   446,   148,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,  4871,  1451,  1452,  1453,  1454,
    1455,  1456,  1457,   455,   456,   457,   458,   686,   459,  1458,
    1459,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,  1460,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,  1461,   484,   485,   486,  1462,  1463,   487,
       0,   488,  1464,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,  1465,     0,   496,     0,
     497,   498,   688,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,  1466,  1467,     0,  1468,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,  1469,   182,   524,   183,     0,   525,   526,
     527,  1470,  1471,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,  1472,   189,  1473,   538,   539,
     191,  1474,   540,   541,   193,   542,  1475,  1476,   543,  1477,
     544,   545,   546,     0,   547,     0,     0,  1478,   549,   550,
       0,     0,   196,   197,   198,   199,  1479,   551,   552,   553,
     554,   555,   556,   557,     0,   558,  1480,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
    1481,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,  1482,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,  1483,   600,   217,
     601,   602,   219,   603,  1484,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,  1485,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,  1486,
    1487,     0,     0,   624,  1488,   625,  1489,  1490,   626,   627,
     628,   629,  4872,   631,   632,     0,  1491,   633,   634,   635,
     636,   637,  1492,     0,   638,   639,   640,   641,   642,   692,
    1493,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,  1494,  1495,
    1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,
       0,     0,     0,     0,     0,     0,  1502,  1503,     0,     0,
       0,     0,     0,     0,     0,  1505,   717,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   718,   104,   105,   672,
     719,     0,   107,   108,   109,   110,   720,   721,   112,   113,
     114,   115,     0,   116,   722,   723,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,   412,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1437,  1438,  1439,    45,  1440,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,  1441,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
     135,  1442,   137,  1443,  1444,     0,   431,   432,   433,   434,
     435,  1445,  1446,   436,   437,  1447,  1448,   438,     0,   439,
     440,   441,   442,  1449,     0,  1450,     0,   443,   444,   445,
     446,   148,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,  4871,  1451,  1452,  1453,  1454,  1455,
    1456,  1457,   455,   456,   457,   458,   686,   459,  1458,  1459,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,  1460,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,  1461,   484,   485,   486,  1462,  1463,   487,     0,
     488,  1464,   489,     0,   490,     0,   491,   169,     0,   170,
     492,   493,   494,     0,   495,  1465,     0,   496,     0,   497,
     498,   688,   499,   500,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,   175,     0,
     511,   512,   513,  1466,  1467,     0,  1468,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
       0,   523,  1469,   182,   524,   183,     0,   525,   526,   527,
    1470,  1471,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,  1472,   189,  1473,   538,   539,   191,
    1474,   540,   541,   193,   542,  1475,  1476,   543,  1477,   544,
     545,   546,     0,   547,     0,     0,  1478,   549,   550,     0,
       0,   196,   197,   198,   199,  1479,   551,   552,   553,   554,
     555,   556,   557,     0,   558,  1480,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,  1481,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,  1482,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,  1483,   600,   217,   601,
     602,   219,   603,  1484,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,  1485,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,  1486,  1487,
       0,     0,   624,  1488,   625,  1489,  1490,   626,   627,   628,
     629,  4872,   631,   632,     0,  1491,   633,   634,   635,   636,
     637,  1492,     0,   638,   639,   640,   641,   642,   692,  1493,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,  1494,  1495,  1496,
    1497,  1498,  1499,  1500,  1501,   693,   653,   654,     0,     0,
       0,     0,     0,     0,     0,  1502,  1503,     0,     0,     0,
       0,     0,     0,     0,  1505,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,   412,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,  1441,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
    1442,   137,  1443,  1444,     0,   431,   432,   433,   434,   435,
    1445,  1446,   436,   437,  1447,  1448,   438,     0,   439,   440,
     441,   442,  1449,     0,  1450,     0,   443,   444,   445,   446,
     148,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,
    1457,   455,   456,   457,   458,   686,   459,  1458,  1459,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,  1460,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,  1461,   484,   485,   486,  1462,  1463,   487,     0,   488,
    1464,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,  1465,     0,   496,     0,   497,   498,
     688,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,  1466,  1467,     0,  1468,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,  1469,   182,   524,   183,     0,   525,   526,   527,  1470,
    1471,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,  1472,   189,  1473,   538,   539,   191,  1474,
     540,   541,   193,   542,  1475,  1476,   543,  1477,   544,   545,
     546,     0,   547,     0,     0,  1478,   549,   550,     0,     0,
     196,   197,   198,   199,  1479,   551,   552,   553,   554,   555,
     556,   557,     0,   558,  1480,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,  1481,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
    1482,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,  1483,   600,   217,   601,   602,
     219,   603,  1484,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,  1485,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1486,  1487,     0,
       0,   624,  1488,   625,  1489,  1490,   626,   627,   628,   629,
     630,   631,   632,     0,  1491,   633,   634,   635,   636,   637,
    1492,     0,   638,   639,   640,   641,   642,   692,  1493,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,
    1498,  1499,  1500,  1501,   693,   653,   654,     0,     0,     0,
       0,     0,     0,     0,  1502,  1503,     0,     0,     0,     0,
       0,     0,     0,  1505,   717,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,  1441,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,  1442,
     137,  1443,  1444,     0,   431,   432,   433,   434,   435,  1445,
    1446,   436,   437,  1447,  1448,   438,     0,   439,   440,   441,
     442,  1449,     0,  1450,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,
     455,   456,   457,   458,   686,   459,  1458,  1459,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,  1460,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
    1461,   484,   485,   486,  1462,  1463,   487,     0,   488,  1464,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,  1465,     0,   496,     0,   497,   498,   688,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,  1466,  1467,     0,  1468,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
    1469,   182,   524,   183,     0,   525,   526,   527,  1470,  1471,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,  1472,   189,  1473,   538,   539,   191,  1474,   540,
     541,   193,   542,  1475,  1476,   543,  1477,   544,   545,   546,
       0,   547,     0,     0,  1478,   549,   550,     0,     0,   196,
     197,   198,   199,  1479,   551,   552,   553,   554,   555,   556,
     557,     0,   558,  1480,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,  1481,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,  1482,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,  1483,   600,   217,   601,   602,   219,
     603,  1484,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,  1485,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1486,  1487,     0,     0,
     624,  1488,   625,  1489,  1490,   626,   627,   628,   629,   630,
     631,   632,     0,  1491,   633,   634,   635,   636,   637,  1492,
       0,   638,   639,   640,   641,   642,   692,  1493,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,  4346,  1494,  1495,  1496,  1497,  1498,
    1499,  1500,  1501,   693,   653,   654,     0,     0,     0,     0,
       0,     0,     0,  1502,  1503,     0,     0,     0,     0,     0,
       0,     0,  1505,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,  1441,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,  1442,   137,
    1443,  1444,     0,   431,   432,   433,   434,   435,  1445,  1446,
     436,   437,  1447,  1448,   438,     0,   439,   440,   441,   442,
    1449,     0,  1450,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,
     456,   457,   458,   686,   459,  1458,  1459,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,  1460,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,  1461,
     484,   485,   486,  1462,  1463,   487,     0,   488,  1464,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,  1465,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
    1466,  1467,     0,  1468,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,  1469,
     182,   524,   183,     0,   525,   526,   527,  1470,  1471,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,  1472,   189,  1473,   538,  4355,   191,  1474,   540,   541,
     193,   542,  1475,  1476,   543,  1477,   544,   545,   546,     0,
     547,     0,     0,  1478,   549,   550,     0,     0,   196,   197,
     198,   199,  1479,   551,   552,   553,   554,   555,   556,   557,
       0,   558,  1480,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,  1481,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,  1482,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,  1483,   600,   217,   601,   602,   219,   603,
    1484,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,  1485,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,  1486,  1487,     0,     0,   624,
    1488,   625,  1489,  1490,   626,   627,   628,   629,   630,   631,
     632,     0,  1491,   633,   634,   635,   636,   637,  1492,     0,
     638,   639,   640,   641,   642,   692,  1493,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,
    1500,  1501,   693,   653,   654,     0,     0,     0,     0,     0,
       0,     0,  1502,  1503,     0,     0,     0,     0,     0,     0,
       0,  1505,   717,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   718,   104,   105,   672,   719,     0,   107,   108,
     109,   110,   720,   721,   112,   113,   114,   115,     0,   116,
     722,   723,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,   412,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1437,  1438,  1439,    45,  1440,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,  1441,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,  1442,   137,  1443,
    1444,     0,   431,   432,   433,   434,   435,  1445,  1446,   436,
     437,  1447,  1448,   438,     0,   439,   440,   441,   442,  1449,
       0,  1450,     0,   443,   444,   445,   446,   148,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,
     457,   458,   686,   459,  1458,  1459,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,  1460,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,  1461,   484,
     485,   486,  1462,  1463,   487,     0,   488,  1464,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,  1465,     0,   496,     0,   497,   498,   688,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,  1466,
    1467,     0,  1468,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,  1469,   182,
     524,   183,     0,   525,   526,   527,  1470,  1471,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
    1472,   189,  1473,   538,   539,   191,     0,   540,   541,   193,
     542,  1475,  1476,   543,  1477,   544,   545,   546,     0,   547,
       0,     0,  1478,   549,   550,     0,     0,   196,   197,   198,
     199,  1479,   551,   552,   553,   554,   555,   556,   557,     0,
     558,  1480,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,  1481,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,  1482,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,  1483,   600,   217,   601,   602,   219,   603,  1484,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,  1485,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,  1486,  1487,     0,     0,   624,  1488,
     625,  1489,  1490,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,  1492,     0,   638,
     639,   640,   641,   642,   692,  1493,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,
    1501,   693,   653,   654,     0,     0,     0,     0,     0,     0,
       0,  2812,  2813,     0,     0,     0,     0,     0,     0,     0,
    1505,   717,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   718,   104,   105,   672,   719,     0,   107,   108,   109,
     110,   720,   721,   112,   113,   114,   115,     0,   116,   722,
     723,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,   412,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1437,
    1438,  1439,    45,  1440,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,  1441,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430, -2578,  1442,   137,  1443,  1444,
       0,   431,   432,   433,   434,   435,  1445,  1446,   436,   437,
    1447,  1448,   438,     0,   439,   440,   441,   442,  1449,     0,
    1450,     0,   443,   444,   445,   446,   148,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,  4871,
    1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,   456,   457,
     458,   686,   459,  1458,  1459,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,  1460,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,  1461,   484,   485,
     486,  1462,  1463,   487,     0,   488,  1464,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
    1465,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,  1466,  1467,
       0,  1468,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,  1469,   182,   524,
       0,     0,   525,   526,   527,  1470,  1471,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,  1472,
     189,  1473,   538,   539,   191,     0,   540,   541,   193,   542,
    1475,  1476,   543,  1477,   544,   545,   546,     0,   547,     0,
       0,  1478,   549,   550,     0,     0,   196,   197,   198,   199,
    1479,   551,   552,   553,   554,   555,   556,   557,     0,   558,
    1480,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,  1481,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,  1482,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,  1483,   600,   217,   601,   602,     0,   603,  1484,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,  1485,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,  1486,  1487,     0,     0,   624,  1488,   625,
    1489,  1490,   626,   627,   628,   629,  4872,   631,   632,     0,
    1491,   633,   634,   635,   636,   637,  1492,     0,   638,   639,
     640,   641,   642,   692,  1493,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,
     693,   653,   654,     0,     0,     0,     0,     0,     0,     0,
    1502,  1503,     0,     0,     0,     0,     0,     0,     0,  1505,
     717,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     718,   104,   105,   672,   719,     0,   107,   108,   109,   110,
     720,   721,   112,   113,   114,   115,     0,   116,   722,   723,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1437,  1438,
       0,    45,  1440,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,  1441,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430,   135,  1442,   137,  1443,  1444,     0,
     431,   432,   433,   434,   435,  1445,  1446,   436,   437,  1447,
    1448,   438,     0,   439,   440,   441,   442,  1449,     0,  1450,
       0,   443,   444,   445,   446,   148,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,     0,  1451,
    1452,  1453,  1454,  1455,  1456,  1457,   455,   456,   457,   458,
     686,   459,  1458,  1459,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,  1460,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,  1461,   484,   485,   486,
    1462,  1463,   487,     0,   488,  1464,   489,     0,   490,     0,
     491,   169,     0,   170,   492,   493,   494,     0,   495,  1465,
       0,   496,     0,   497,   498,   688,   499,   500,   173,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,   174,   175,     0,   511,   512,   513,  1466,  1467,     0,
    1468,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,  1469,   182,   524,   183,
       0,   525,   526,   527,  1470,  1471,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,  1472,   189,
    1473,   538,   539,   191,     0,   540,   541,   193,   542,  1475,
    1476,   543,  1477,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,   197,   198,   199,  1479,
     551,   552,   553,   554,   555,   556,   557,     0,   558,  1480,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,  1481,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,  1482,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
    1483,   600,   217,   601,   602,   219,   603,  1484,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
    1485,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,  1486,  1487,     0,     0,   624,  1488,   625,  1489,
    1490,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,  1492,     0,   638,   639,   640,
     641,   642,   692,  1493,     0,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,
     653,   654,     0,     0,     0,   717,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,  1505,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,   412,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1437,  1438,     0,    45,  1440,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,  1441,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
    1442,   137,  1443,  1444,     0,  3974,   432,   433,   434,   435,
    1445,  1446,   436,   437,  1447,  1448,   438,     0,   439,   440,
     441,   442,  1449,     0,  1450,     0,   443,   444,   445,   446,
     148,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,  1451,  1452,  1453,  1454,  1455,  1456,
    1457,   455,   456,   457,   458,   686,   459,  1458,  1459,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,  1460,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,  1461,   484,   485,   486,  1462,  1463,   487,     0,   488,
    1464,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,  1465,     0,   496,     0,   497,   498,
     688,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,  1466,  1467,     0,  1468,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,  1469,   182,   524,   183,     0,   525,   526,   527,  1470,
    1471,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,  1472,   189,  1473,   538,   539,   191,     0,
     540,   541,   193,   542,  1475,  1476,   543,  1477,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,   197,   198,   199,  1479,   551,   552,   553,   554,   555,
     556,   557,     0,   558,  1480,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,  1481,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
    1482,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,  1483,   600,   217,   601,   602,
     219,   603,  1484,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,  1485,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1486,  1487,     0,
       0,   624,  1488,   625,  1489,  1490,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
    1492,     0,   638,   639,   640,   641,   642,   692,  1493,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,  1494,  1495,  1496,  1497,
    1498,  1499,  1500,  1501,   693,   653,   654,     0,     0,     0,
     717,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,  1505,    98,    99,   100,   101,   102,   103,
     718,   104,   105,   672,   719,     0,   107,   108,   109,   110,
     720,   721,   112,   113,   114,   115,     0,   116,   722,   723,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,  1437,  1438,
    1439,    45,  1440,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,  1441,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430,     0,  1442,   137,  1443,  1444,     0,
     431,   432,   433,   434,   435,  1445,  1446,   436,   437,  1447,
    1448,   438,     0,   439,   440,   441,   442,  1449,     0,  1450,
       0,   443,   444,   445,   446,   148,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,     0,  1451,
    1452,  1453,  1454,  1455,  1456,  1457,   455,   456,   457,   458,
     686,   459,  1458,  1459,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,  1460,   473,   474,     0,   475,   476,   477,     0,   478,
       0,     0,   480,   481,   482,   483,  1461,   484,   485,   486,
    1462,  1463,   487,     0,   488,  1464,   489,     0,   490,     0,
     491,   169,     0,   170,   492,   493,   494,     0,   495,  1465,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,   174,   175,     0,   511,   512,   513,  1466,  1467,     0,
    1468,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,  1469,   182,   524,     0,
       0,   525,   526,   527,  1470,  1471,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,  1472,   189,
    1473,   538,   539,   191,     0,   540,   541,   193,   542,  1475,
    1476,   543,  1477,   544,   545,   546,     0,   547,     0,     0,
    1478,   549,   550,     0,     0,   196,   197,   198,   199,  1479,
     551,   552,   553,   554,   555,   556,   557,     0,   558,  1480,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,  1481,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,  1482,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
    1483,   600,   217,   601,   602,     0,   603,  1484,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
    1485,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,  1486,  1487,     0,     0,   624,  1488,   625,  1489,
    1490,   626,   627,   628,   629,   630,   631,   632,     0,  1491,
     633,   634,   635,   636,   637,  1492,     0,   638,   639,   640,
     641,   642,   692,  1493,     0,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,  1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,
     653,   654,     0,     0,     0,     0,     0,     0,     0,  1502,
    1503,     0,     0,     0,     0,     0,     0,     0,  1505,   717,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   718,
     104,   105,   672,   719,     0,   107,   108,   109,   110,   720,
     721,   112,   113,   114,   115,     0,   116,   722,   723,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1437,  1438,  1439,
      45,  1440,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,  1441,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,     0,  1442,   137,  1443,  1444,     0,   431,
     432,   433,   434,   435,  1445,  1446,   436,   437,  1447,  1448,
     438,     0,   439,   440,   441,   442,  1449,     0,  1450,     0,
     443,   444,   445,   446,   148,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,  1451,  1452,
    1453,  1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,
     459,  1458,  1459,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
    1460,   473,   474,     0,   475,   476,   477,     0,   478,     0,
       0,   480,   481,   482,   483,  1461,   484,   485,   486,  1462,
    1463,   487,     0,   488,  1464,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,  1465,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,  1466,  1467,     0,  1468,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,  1469,   182,   524,     0,     0,
     525,   526,   527,  1470,  1471,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,  1472,   189,  1473,
     538,   539,   191,     0,   540,   541,   193,   542,  1475,  1476,
     543,  1477,   544,   545,   546,     0,   547,     0,     0,  1478,
     549,   550,     0,     0,   196,   197,   198,   199,  1479,   551,
     552,   553,   554,   555,   556,   557,     0,   558,  1480,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,  1481,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,  1482,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,  1483,
     600,   217,   601,   602,     0,   603,  1484,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,  1485,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,  1486,  1487,     0,     0,   624,  1488,   625,  1489,  1490,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,  1492,     0,   638,   639,   640,   641,
     642,   692,  1493,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
    1494,  1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,
     654,     0,     0,     0,     0,     0,     0,     0,  2812,  2813,
       0,     0,     0,     0,     0,     0,     0,  1505,   717,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   718,   104,
     105,   672,   719,     0,   107,   108,   109,   110,   720,   721,
     112,   113,   114,   115,     0,   116,   722,   723,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,     0,   431,   432,
     433,   434,   435,     0,  1446,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,  1449,     0,  1450,     0,   443,
     444,   445,   446,   148,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,  1451,  1452,  1453,
    1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,  1462,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,  1465,     0,   496,
       0,   497,   498,   688,   499,   500,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,  1469,   182,   524,   183,     0,   525,
     526,   527,  1470,  1471,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,   189,   190,   538,
     539,   191,     0,   540,   541,   193,   542,     0,  1476,   543,
     195,   544,   545,   546,     0,   547,     0,  1063,   548,   549,
     550,     0,     0,   196,   197,   198,   199,  1479,   551,   552,
     553,   554,   555,   556,   557,     0,   558,  1480,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,   215,   595,   596,   597,   598,   599,  1483,   600,
     217,   601,   602,   219,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,  1485,     0,
     615,   616,   223,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,  1488,   625,  1489,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,  1492,     0,   638,   639,   640,   641,   642,
    2143,   234,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,   236,   648,   649,   650,   651,   652,   237,  1494,
    1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,
       0,     0,     0,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,  3520,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,   433,   434,   435,     0,  1446,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
    1449,     0,  1450,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,  1451,  1452,  1453,  1454,  1455,  1456,  1457,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,  1462,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,  1465,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,  1469,
     182,   524,   183,     0,   525,   526,   527,  1470,  1471,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,   189,   190,   538,   539,   191,     0,   540,   541,
     193,   542,     0,  1476,   543,   195,   544,   545,   546,     0,
     547,     0,  1063,   548,   549,   550,     0,     0,   196,   197,
     198,   199,  1479,   551,   552,   553,   554,   555,   556,   557,
       0,   558,  1480,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,  1483,   600,   217,   601,   602,   219,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,  1485,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
    1488,   625,  1489,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,  1492,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,  1494,  1495,  1496,  1497,  1498,  1499,
    1500,  1501,   693,   653,   654,     0,     0,     0,   717,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,  3520,    98,    99,   100,   101,   102,   103,   718,   104,
     105,   672,   719,     0,   107,   108,   109,   110,   720,   721,
     112,   113,   114,   115,     0,   116,   722,   723,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,     0,   431,   432,
     433,   434,   435,     0,  1446,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,  1449,     0,  1450,     0,   443,
     444,   445,   446,   148,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,  1451,  1452,  1453,
    1454,  1455,  1456,  1457,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,  1462,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,  1465,     0,   496,
       0,   497,   498,   688,   499,   500,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,  1469,   182,   524,   183,     0,   525,
     526,   527,  1470,  1471,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,   189,   190,   538,
     539,   191,     0,   540,   541,   193,   542,     0,  1476,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,   197,   198,   199,  1479,   551,   552,
     553,   554,   555,   556,   557,     0,   558,  1480,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,  1483,   600,
     217,   601,   602,   219,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,  1485,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,  1488,   625,  1489,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,  1492,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,  1494,
    1495,  1496,  1497,  1498,  1499,  1500,  1501,   693,   653,   654,
       0,     0,     0,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,  4090,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,   145,     0,   443,   444,   445,   446,   148,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,   189,   190,   538,   539,   191,     0,   540,   541,
     193,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,   197,
     198,   199,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,   219,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,     0,     0,     0,     0,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,  4642,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,  4018,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0, -1428,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0, -1428,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510, -1428,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515, -1428,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181, -1428,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188, -1428,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
   -1428,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
       0,     0,     0,     0,     0,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,  1596,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,     0,     0,     0,     0,
       0,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,  3281,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
      37,    38,    39,    40,    41,    42,     0,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,     0,     0,     0,     0,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,  3796,  3797,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,     0,     0,     0,
       0,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,  3797,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,   215,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,   223,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,  2143,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,   236,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,     0,     0,     0,     0,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,   246,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,   215,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,   223,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,  2143,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,   236,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,     0,     0,     0,
       0,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,   246,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,     0,     0,     0,     0,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,  1571,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,     0,     0,     0,
       0,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,  2971,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,     0,     0,     0,     0,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,  4045,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,     0,     0,     0,
     717,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,  4390,    98,    99,   100,   101,   102,   103,
     718,   104,   105,   672,   719,     0,   107,   108,   109,   110,
     720,   721,   112,   113,   114,   115,     0,   116,   722,   723,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
    1185,    45,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,   724,   421,   422,   423,   725,   726,
     727,   728,   729,   730,   731,   424,   425,   732,   426,   427,
     133,   428,   429,   430,     0,  1859,   137,  1860,  1861,   733,
     431,   432,   433,   434,   435,   734,   735,   436,   437,  1862,
    1863,   438,   737,   439,   440,   441,   442,     0,   738,   145,
     739,   443,   444,   445,   446,   148,   447,   684,   741,   448,
     449,   450,   451,   452,   453,   742,   151,   454,     0,   744,
     745,   746,   152,   747,   748,   749,   455,   456,   457,   458,
     686,   459,  1864,  1865,   460,   750,   461,   751,   462,   463,
     464,   465,   466,   752,   467,   468,   469,   753,   754,   470,
     471,  1460,   473,   474,   755,   475,   476,   477,   756,   478,
     479,   757,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   758,   487,   759,   488,  1866,   489,   760,   490,   761,
     491,   169,   762,   170,   492,   493,   494,   763,   495,     0,
     764,   496,   765,   497,   498,   688,   499,   500,   173,   501,
     502,   503,   766,   504,   505,   506,   507,   508,   509,   767,
     510,   174,     0,     0,   511,   512,   513,  1466,  1867,   770,
    1868,   771,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,   772,   523,     0,   182,   524,   183,
     773,   525,   526,   527,   774,   775,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,  1869,   189,
    1870,   538,   539,     0,   776,   540,   541,   193,   542,   777,
       0,   543,  1871,   544,   545,   546,   778,   547,   779,   780,
    3783,   549,   550,   781,   782,     0,   197,   198,   199,     0,
     551,   552,   553,   554,   555,   556,   557,   783,   558,     0,
     559,     0,   560,   561,   562,   784,   563,   564,   565,   566,
     567,   568,   569,  1872,   570,   571,   572,   573,   785,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   786,
     584,   585,   210,   586,   587,     0,   588,   589,   590,   591,
     592,   593,   691,   594,   787,   595,   596,   597,   598,   599,
     788,   600,  2427,   601,   602,   219,   603,  1874,   604,   789,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
       0,   790,   615,   616,   791,   617,   618,   619,   620,   621,
     622,   792,  1875,  1876,     0,   794,   624,     0,   625,     0,
     795,   626,   627,   628,   629,   630,   631,   632,     0,   797,
     633,   634,   635,   636,   637,   798,   799,   638,   639,   640,
     641,   642,     0,  1877,   801,   643,   235,   644,   645,   646,
     802,   803,   647,   804,   805,   648,   649,   650,   651,   652,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   693,
     653,   654,     0,     0,     0,  1188,  1189,  1190,     0,  3784,
    3785,  1193,  1194,  1195,  1196,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,  1186,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,  1187,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,     0,     0,     0,  1188,
    1189,  1190,     0,  1191,  1192,  1193,  1194,  1195,  1196,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1185,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,  1274,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
    1275,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
       0,     0,     0,  1188,  1189,  1190,     0,  1191,  1192,  1193,
    1194,  1195,  1196,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1185,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,  1326,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,  1327,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,  1328,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,     0,     0,     0,  1188,  1189,  1190,
       0,  1191,  1192,  1193,  1194,  1195,  1196,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,  1185,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
    1842,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,  1843,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,     0,     0,
       0,  1188,  1189,  1190,     0,  1191,  1192,  1193,  1194,  1195,
    1196,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    1185,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,     0,     0,     0,  1188,  1189,  1190,     0,  1191,
    1192,  1193,  1194,  1195,  1196,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1185,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,  3054,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,  3055,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,     0,     0,     0,  1188,
    1189,  1190,     0,  1191,  1192,  1193,  1194,  1195,  1196,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1185,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,  4626,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
       0,     0,     0,  1188,  1189,  1190,     0,  1191,  1192,  1193,
    1194,  1195,  1196,   717,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   718,   104,   105,   672,   719,     0,   107,
     108,   109,   110,   720,   721,   112,   113,   114,   115,     0,
     116,   722,   723,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,   724,   421,   422,
     423,   725,   726,   727,   728,   729,   730,   731,   424,   425,
     732,   426,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,   733,   431,   432,   433,   434,   435,   734,   735,
     436,   437,   736,   140,   438,   737,   439,   440,   441,   442,
     144,   738,   145,   739,   443,   444,   445,   446,   148,   447,
     740,   741,   448,   449,   450,   451,   452,   453,   742,   151,
     454,   743,   744,   745,   746,   152,   747,   748,   749,   455,
     456,   457,   458,   686,   459,   155,   156,   460,   750,   461,
     751,   462,   463,   464,   465,   466,   752,   467,   468,   469,
     753,   754,   470,   471,   472,   473,   474,   755,   475,   476,
     477,   756,   478,   479,   757,   480,   481,   482,   483,   164,
     484,   485,   486,   166,   758,   487,   759,   488,   168,   489,
     760,   490,   761,   491,   169,   762,   170,   492,   493,   494,
     763,   495,   172,   764,   496,   765,   497,   498,   688,   499,
     500,   173,   501,   502,   503,   766,   504,   505,   506,   507,
     508,   509,   767,   510,   174,   175,   768,   511,   512,   513,
     769,   176,   770,   177,   771,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,   772,   523,   181,
     182,   524,   183,   773,   525,   526,   527,   774,   775,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,   189,   190,   538,   539,   191,   776,   540,   541,
     193,   542,   777,   194,   543,   195,   544,   545,   546,   778,
     547,   779,   780,   548,   549,   550,   781,   782,   196,   197,
     198,   199,   200,   551,   552,   553,   554,   555,   556,   557,
     783,   558,   201,   559,   202,   560,   561,   562,   784,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,   785,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,   786,   584,   585,   210,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,   787,   595,   596,
     597,   598,   599,   788,   600,   217,   601,   602,   219,   603,
     220,   604,   789,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,   790,   615,   616,   791,   617,   618,
     619,   620,   621,   622,   792,   224,   225,   793,   794,   624,
     226,   625,   227,   795,   626,   627,   628,   629,   630,   631,
     632,   796,   797,   633,   634,   635,   636,   637,   798,   799,
     638,   639,   640,   641,   642,   800,   234,   801,   643,   235,
     644,   645,   646,   802,   803,   647,   804,   805,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,   717,    86,    87,    88,   669,
      90,    91,    92,   670,  2240,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   718,   104,   105,   672,   719,
       0,   107,   108,   109,   110,   720,   721,   112,   113,   114,
     115,     0,   116,   722,   723,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,     0,
    1859,   137,  1860,  1861,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,  1862,  1863,   438,     0,   439,   440,
     441,   442,     0,     0,   145,     0,   443,   444,   445,   446,
     148,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,     0,     0,     0,   152,     0,     0,
       0,   455,   456,   457,   458,   686,   459,  1864,  1865,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,  1460,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,     0,   484,   485,   486,     0,     0,   487,     0,   488,
    1866,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,     0,     0,   496,     0,   497,   498,
     688,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,     0,     0,   511,
     512,   513,  1466,  1867,     0,  1868,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,     0,   182,   524,   183,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,  1869,   189,  1870,   538,   539,     0,     0,
     540,   541,   193,   542,     0,     0,   543,  1871,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
       0,   197,   198,   199,     0,   551,   552,   553,   554,   555,
     556,   557,     0,   558,     0,   559,     0,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,  1872,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
       0,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,  1873,   601,   602,
     219,   603,  1874,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,     0,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1875,  1876,     0,
       0,   624,     0,   625,     0,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,     0,  1877,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   693,   653,   654,     0,    86,    87,
      88,   669,    90,    91,    92,   670,  2341,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,     0,
      86,    87,    88,   669,    90,    91,    92,   670,  1070,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,     0,    86,    87,    88,   669,    90,    91,    92,   670,
    4494,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,   412,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   413,   969,   415,
     416,   417,   418,   419,   420,   970,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   971,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   972,   168,   489,     0,   490,
       0,   973,     0,   974,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,   975,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   976,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   977,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   978,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   979,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,     0,     0,     0,     0,     0,     0,     0,
     980,   981,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,   412,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   413,   969,   415,
     416,   417,   418,   419,   420,   970,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,  1002,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   972,   168,   489,     0,   490,
       0,  1003,     0,   974,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,   975,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   976,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   977,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   978,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   979,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,     0,     0,     0,     0,     0,     0,     0,
     980,   981,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,   412,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,  1374,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,   974,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,   975,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,     0,     0,     0,     0,     0,     0,     0,
     980,   981,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,   412,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,  1379,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,   974,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,   975,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,     0,     0,     0,     0,     0,     0,     0,
     980,   981,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,   412,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,   687,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,  1542,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,     0,     0,  1041,  1543,    86,    87,    88,
     669,    90,    91,    92,   670,  1042,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,  1043,   437,  1017,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,  1044,     0,  1045,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,  1046,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,  1047,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,  1048,
     587,   212,   588,   589,   590,  1049,   592,   593,   691,   594,
       0,   595,   596,   597,   598,  1050,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,  1051,   225,
       0,     0,  1052,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,  1021,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,  1053,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,   717,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   718,   104,
     105,   672,   719,     0,   107,   108,   109,   110,   720,   721,
     112,   113,   114,   115,     0,   116,   722,   723,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,     0,     0,     0,    45,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,   724,   421,   422,   423,   725,   726,   727,   728,
     729,   730,   731,   424,   425,   732,   426,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,   733,   431,   432,
     433,   434,   435,   734,   735,   436,   437,   736,   140,   438,
     737,   439,   440,   441,   442,   144,   738,   145,   739,   443,
     444,   445,   446,   148,   447,   740,   741,   448,   449,   450,
     451,   452,   453,   742,   151,   454,   743,   744,   745,   746,
     152,   747,   748,   749,   455,   456,   457,   458,   686,   459,
     155,   156,   460,   750,   461,   751,   462,   463,   464,   465,
     466,   752,   467,   468,   469,   753,   754,   470,   471,   472,
     473,   474,   755,   475,   476,   477,   756,   478,   479,   757,
     480,   481,   482,   483,   164,   484,   485,   486,   166,   758,
     487,   759,   488,   168,   489,   760,   490,   761,   491,   169,
     762,   170,   492,   493,   494,   763,   495,   172,   764,   496,
     765,   497,   498,   688,   499,   500,   173,   501,   502,   503,
     766,   504,   505,   506,   507,   508,   509,   767,   510,   174,
     175,   768,   511,   512,   513,   769,   176,   770,   177,   771,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,   772,   523,   181,   182,   524,   183,   773,   525,
     526,   527,   774,   775,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,   189,   190,   538,
     539,   191,   776,   540,   541,   193,   542,   777,   194,   543,
     195,   544,   545,   546,   778,   547,   779,   780,   548,   549,
     550,   781,   782,   196,   197,   198,   199,   200,   551,   552,
     553,   554,   555,   556,   557,   783,   558,   201,   559,   202,
     560,   561,   562,   784,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,   785,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,   786,   584,   585,
     210,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,   787,   595,   596,   597,   598,   599,   788,   600,
     217,   601,   602,   219,   603,   220,   604,   789,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,   790,
     615,   616,   791,   617,   618,   619,   620,   621,   622,   792,
     224,   225,   793,   794,   624,   226,   625,   227,   795,   626,
     627,   628,   629,   630,   631,   632,   796,   797,   633,   634,
     635,   636,   637,   798,   799,   638,   639,   640,   641,   642,
     800,   234,   801,   643,   235,   644,   645,   646,   802,   803,
     647,   804,   805,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
     717,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     718,   104,   105,   672,   719,     0,   107,   108,   109,   110,
     720,   721,   112,   113,   114,   115,     0,   116,   722,   723,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,   724,   421,   422,   423,   725,   726,
     727,   728,   729,   730,   731,   424,   425,   732,   426,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,   733,
     431,   432,   433,   434,   435,   734,   735,   436,   437,   736,
     140,   438,   737,   439,   440,   441,   442,   144,   738,   145,
     739,   443,   444,   445,   446,   148,   447,   740,   741,   448,
     449,   450,   451,   452,   453,   742,   151,   454,   743,   744,
     745,   746,   152,   747,   748,   749,   455,   456,   457,   458,
     686,   459,   155,   156,   460,   750,   461,   751,   462,   463,
     464,   465,   466,   752,   467,   468,   469,   753,   754,   470,
     471,   472,   473,   474,   755,   475,   476,   477,   756,   478,
     479,   757,   480,   481,   482,   483,   164,   484,   485,   486,
     166,   758,   487,   759,   488,   168,   489,   760,   490,   761,
     491,   169,   762,   170,   492,   493,   494,   763,   495,   172,
     764,   496,   765,   497,   498,   688,   499,   500,   173,   501,
     502,   503,   766,   504,   505,   506,   507,   508,   509,   767,
     510,   174,   175,   768,   511,   512,   513,   769,   176,   770,
     177,   771,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,   772,   523,   181,   182,   524,   183,
     773,   525,   526,   527,   774,   775,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,   189,
     190,   538,   539,   191,   776,   540,   541,   193,   542,   777,
     194,   543,   195,   544,   545,   546,   778,   547,   779,   780,
     548,   549,   550,   781,   782,   196,   197,   198,   199,   200,
     551,   552,   553,   554,   555,   556,   557,   783,   558,   201,
     559,   202,   560,   561,   562,   784,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,   785,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   786,
     584,   585,   210,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,   787,   595,   596,   597,   598,   599,
     788,   600,   217,   601,   602,   219,   603,   220,   604,   789,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,   790,   615,   616,   791,   617,   618,   619,   620,   621,
     622,   792,   224,   225,   793,   794,   624,   226,   625,   227,
     795,   626,   627,   628,   629,   630,   631,   632,   796,   797,
     633,   634,   635,   636,   637,   798,   799,   638,   639,   640,
     641,   642,   800,   234,   801,   643,   235,   644,   645,   646,
     802,   803,   647,   804,   805,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,   717,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   718,   104,   105,   672,   719,     0,   107,   108,
     109,   110,   720,   721,   112,   113,   114,   115,     0,   116,
     722,   723,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,  3119,   418,   419,   420,   724,   421,   422,   423,
     725,   726,   727,   728,   729,   730,   731,   424,   425,   732,
     426,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,   733,   431,   432,   433,   434,   435,   734,   735,   436,
     437,   736,   140,   438,   737,   439,   440,   441,   442,   144,
     738,   145,   739,   443,   444,   445,   446,   148,   447,   740,
     741,   448,   449,   450,   451,   452,   453,   742,   151,   454,
     743,   744,   745,   746,   152,   747,   748,   749,   455,   456,
     457,   458,   686,   459,   155,   156,   460,   750,   461,   751,
     462,   463,   464,   465,   466,   752,   467,   468,   469,   753,
     754,   470,   471,   472,  3120,   474,   755,   475,   476,   477,
     756,   478,   479,   757,   480,   481,   482,   483,   164,   484,
     485,   486,   166,   758,   487,   759,   488,   168,   489,   760,
     490,   761,   491,   169,   762,   170,   492,   493,   494,   763,
     495,   172,   764,   496,   765,   497,   498,   688,   499,   500,
     173,   501,   502,   503,   766,   504,   505,   506,   507,   508,
     509,   767,   510,   174,   175,   768,   511,   512,   513,   769,
     176,   770,   177,   771,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,   772,   523,   181,   182,
     524,   183,   773,   525,   526,   527,   774,   775,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,   189,   190,   538,   539,   191,   776,   540,   541,   193,
     542,   777,   194,   543,   195,   544,   545,   546,   778,   547,
     779,   780,   548,   549,   550,   781,   782,   196,   197,   198,
     199,   200,   551,   552,   553,   554,   555,   556,   557,   783,
     558,   201,   559,   202,   560,   561,   562,   784,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
     785,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,   786,   584,   585,   210,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,   787,   595,   596,   597,
     598,   599,   788,  3121,   217,   601,   602,   219,   603,   220,
     604,   789,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,   790,   615,   616,   791,   617,   618,   619,
     620,   621,   622,   792,   224,   225,   793,   794,   624,   226,
     625,   227,   795,   626,   627,   628,   629,   630,   631,   632,
     796,   797,   633,   634,   635,   636,   637,   798,   799,   638,
     639,   640,   641,   642,   800,   234,   801,   643,   235,   644,
     645,   646,   802,   803,   647,   804,   805,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,   717,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,   145,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,     0,     0,     0,   152,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,   182,   524,   183,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,   189,   190,   538,   539,   191,     0,   540,
     541,   193,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
     197,   198,   199,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,   219,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,   717,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   718,   104,   105,   672,
     719,     0,   107,   108,   109,   110,   720,   721,   112,   113,
     114,   115,     0,   116,   722,   723,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,   145,     0,   443,   444,   445,
     446,   148,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,     0,     0,     0,     0,   152,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,   169,     0,   170,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,  1311,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,   182,   524,   183,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,   189,   190,   538,   539,   191,
       0,   540,   541,   193,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,   197,   198,   199,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,   219,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,   717,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   718,   104,
     105,   672,   719,     0,   107,   108,   109,   110,   720,   721,
     112,   113,   114,   115,     0,   116,   722,   723,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,   145,     0,   443,
     444,   445,   446,   148,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,     0,     0,     0,
     152,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,  1320,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,   182,   524,   183,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,   189,   190,   538,
     539,   191,     0,   540,   541,   193,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,   197,   198,   199,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,   219,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
     717,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     718,   104,   105,   672,   719,     0,   107,   108,   109,   110,
     720,   721,   112,   113,   114,   115,     0,   116,   722,   723,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430,     0,  1859,   137,  1860,  1861,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,  1862,
    1863,   438,     0,   439,   440,   441,   442,     0,     0,   145,
       0,   443,   444,   445,   446,   148,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,     0,     0,
       0,     0,   152,     0,     0,     0,   455,   456,   457,   458,
     686,   459,  1864,  1865,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,  1460,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,     0,   484,   485,   486,
       0,     0,   487,     0,   488,  1866,   489,     0,   490,     0,
     491,   169,     0,   170,   492,   493,   494,     0,   495,     0,
       0,   496,     0,   497,   498,   688,   499,   500,   173,   501,
     502,   503,  2424,   504,   505,   506,   507,   508,   509,     0,
     510,   174,  2425,     0,   511,   512,   513,  1466,  1867,     0,
    1868,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,     0,   182,   524,   183,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,  1869,   189,
    1870,   538,   539,     0,     0,   540,   541,   193,   542,     0,
       0,   543,  1871,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,  2426,   197,   198,   199,     0,
     551,   552,   553,   554,   555,   556,   557,     0,   558,     0,
     559,     0,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,  1872,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,     0,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,  2427,   601,   602,   219,   603,  1874,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
       0,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,  1875,  1876,     0,     0,   624,     0,   625,     0,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,     0,  1877,  2428,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   693,
     653,   654,   717,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   718,   104,   105,   672,   719,     0,   107,   108,
     109,   110,   720,   721,   112,   113,   114,   115,     0,   116,
     722,   723,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,     0,  1859,   137,  1860,
    1861,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,  1862,  1863,   438,     0,   439,   440,   441,   442,     0,
       0,   145,     0,   443,   444,   445,   446,   148,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,     0,     0,     0,   152,     0,     0,     0,   455,   456,
     457,   458,   686,   459,  1864,  1865,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,  1460,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,     0,   484,
     485,   486,     0,     0,   487,     0,   488,  1866,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,     0,     0,   496,     0,   497,   498,   688,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,     0,     0,   511,   512,   513,  1466,
    1867,     0,  1868,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,     0,   182,
     524,   183,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
    1869,   189,  1870,   538,   539,     0,     0,   540,   541,   193,
     542,  2412,     0,   543,  1871,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,     0,   197,   198,
     199,     0,   551,   552,   553,   554,   555,   556,   557,     0,
     558,     0,   559,     0,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,  1872,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,     0,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,  2427,   601,   602,   219,   603,  1874,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,     0,     0,   615,   616,  3881,   617,   618,   619,
     620,   621,   622,     0,  1875,  1876,     0,     0,   624,     0,
     625,     0,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,     0,  1877,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   693,   653,   654,   717,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,     0,  1859,
     137,  1860,  1861,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,  1862,  1863,   438,     0,   439,   440,   441,
     442,     0,     0,   145,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,     0,     0,     0,   152,     0,     0,     0,
     455,   456,   457,   458,   686,   459,  1864,  1865,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,  1460,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
       0,   484,   485,   486,     0,     0,   487,     0,   488,  1866,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,     0,     0,   496,     0,   497,   498,   688,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,     0,     0,   511,   512,
     513,  1466,  1867,     0,  1868,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
       0,   182,   524,   183,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,  1869,   189,  1870,   538,   539,  2474,     0,   540,
     541,   193,   542,     0,     0,   543,  1871,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,     0,
     197,   198,   199,     0,   551,   552,   553,   554,   555,   556,
     557,     0,   558,     0,   559,     0,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,  1872,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,     0,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,  1873,   601,   602,   219,
     603,  1874,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,     0,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1875,  1876,     0,     0,
     624,     0,   625,     0,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,     0,  1877,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   693,   653,   654,   717,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   718,   104,   105,   672,
     719,     0,   107,   108,   109,   110,   720,   721,   112,   113,
     114,   115,     0,   116,   722,   723,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
       0,  1859,   137,  1860,  1861,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,  1862,  1863,   438,     0,   439,
     440,   441,   442,     0,     0,   145,     0,   443,   444,   445,
     446,   148,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,     0,     0,     0,     0,   152,     0,
       0,     0,   455,   456,   457,   458,   686,   459,  1864,  1865,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,  1460,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,     0,   484,   485,   486,     0,     0,   487,     0,
     488,  1866,   489,     0,   490,     0,   491,   169,     0,   170,
     492,   493,   494,     0,   495,     0,     0,   496,     0,   497,
     498,   688,   499,   500,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,     0,     0,
     511,   512,   513,  1466,  1867,     0,  1868,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
       0,   523,     0,   182,   524,   183,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,  1869,   189,  1870,   538,   539,  3705,
       0,   540,   541,   193,   542,     0,     0,   543,  1871,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,     0,   197,   198,   199,     0,   551,   552,   553,   554,
     555,   556,   557,     0,   558,     0,   559,     0,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,  1872,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,     0,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,  1873,   601,
     602,   219,   603,  1874,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,     0,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,  1875,  1876,
       0,     0,   624,     0,   625,     0,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,     0,  1877,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   693,   653,   654,   717,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   718,   104,
     105,   672,   719,     0,   107,   108,   109,   110,   720,   721,
     112,   113,   114,   115,     0,   116,   722,   723,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,     0,  1859,   137,  1860,  1861,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,  1862,  1863,   438,
       0,   439,   440,   441,   442,     0,     0,   145,     0,   443,
     444,   445,   446,   148,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,     0,     0,     0,
     152,     0,     0,     0,   455,   456,   457,   458,   686,   459,
    1864,  1865,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,  1460,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,     0,   484,   485,   486,     0,     0,
     487,     0,   488,  1866,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,     0,     0,   496,
       0,   497,   498,   688,   499,   500,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
       0,     0,   511,   512,   513,  1466,  1867,     0,  1868,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,     0,   182,   524,   183,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,  1869,   189,  1870,   538,
     539,     0,     0,   540,   541,   193,   542,     0,     0,   543,
    1871,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,     0,   197,   198,   199,     0,   551,   552,
     553,   554,   555,   556,   557,     0,   558,     0,   559,     0,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,  1872,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,     0,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
    1873,   601,   602,   219,   603,  1874,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,     0,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
    1875,  1876,     0,     0,   624,     0,   625,     0,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
       0,  1877,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   693,   653,   654,
     717,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     718,   104,   105,   672,   719,     0,   107,   108,   109,   110,
     720,   721,   112,   113,   114,   115,     0,   116,   722,   723,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430,     0,  1859,   137,  1860,  1861,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,  1862,
    1863,   438,     0,   439,   440,   441,   442,     0,     0,   145,
       0,   443,   444,   445,   446,   148,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,     0,     0,
       0,     0,   152,     0,     0,     0,   455,   456,   457,   458,
     686,   459,  1864,  1865,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,  1460,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,     0,   484,   485,   486,
       0,     0,   487,     0,   488,  1866,   489,     0,   490,     0,
     491,   169,     0,   170,   492,   493,   494,     0,   495,     0,
       0,   496,     0,   497,   498,   688,   499,   500,   173,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,   174,     0,     0,   511,   512,   513,  1466,  1867,     0,
    1868,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,     0,   182,   524,   183,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,  1869,   189,
    1870,   538,   539,     0,     0,   540,   541,   193,   542,     0,
       0,   543,  1871,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,     0,   197,   198,   199,     0,
     551,   552,   553,   554,   555,   556,   557,     0,   558,     0,
     559,     0,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,  1872,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,     0,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,  2427,   601,   602,   219,   603,  1874,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
       0,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,  1875,  1876,     0,     0,   624,     0,   625,     0,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,     0,  1877,     0,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   693,
     653,   654,   717,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   718,   104,   105,   672,   719,     0,   107,   108,
     109,   110,   720,   721,   112,   113,   114,   115,     0,   116,
     722,   723,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,     0,  1859,   137,  1860,
    1861,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,  1862,  1863,   438,     0,   439,   440,   441,   442,     0,
       0,   145,     0,   443,   444,   445,   446,   148,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,     0,     0,     0,   152,     0,     0,     0,   455,   456,
     457,   458,   686,   459,  1864,  1865,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,  1460,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,     0,   484,
     485,   486,     0,     0,   487,     0,   488,  1866,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,     0,     0,   496,     0,   497,   498,   688,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,     0,     0,   511,   512,   513,  1466,
    1867,     0,  1868,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,     0,   182,
     524,   183,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
    1869,   189,  1870,   538,   539,     0,     0,   540,   541,   193,
     542,     0,     0,   543,  1871,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,     0,   197,   198,
     199,     0,   551,   552,   553,   554,   555,   556,   557,     0,
     558,     0,   559,     0,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,  1872,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,     0,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,     0,   601,   602,   219,   603,  1874,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,     0,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,  1875,  1876,     0,     0,   624,     0,
     625,     0,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,     0,  1877,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   693,   653,   654,   717,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   718,   104,   105,   672,   719,     0,
     107,   108,   109,   110,   720,   721,   112,   113,   114,   115,
       0,   116,   722,   723,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,     0,     0,
     137,     0,     0,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,     0,   438,     0,   439,   440,   441,
     442,     0,     0,   145,     0,   443,   444,   445,   446,   148,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,     0,     0,     0,   152,     0,     0,     0,
     455,   456,   457,   458,   686,   459,     0,     0,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
       0,   484,   485,   486,     0,     0,   487,     0,   488,     0,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,     0,     0,   496,     0,   497,   498,   688,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,     0,     0,   511,   512,
     513,     0,     0,     0,     0,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
       0,   182,   524,   183,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,     0,   189,     0,   538,   539,     0,     0,   540,
     541,   193,   542,     0,     0,   543,     0,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,     0,
     197,   198,   199,     0,   551,   552,   553,   554,   555,   556,
     557,     0,   558,     0,   559,     0,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,     0,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,     0,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,     0,   601,   602,   219,
     603,     0,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,     0,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,     0,     0,     0,     0,
     624,     0,   625,     0,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,     0,     0,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   724,
     421,   422,   423,   725,   726,   727,   728,   729,   730,   731,
     424,   425,   732,   426,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,   733,   431,   432,   433,   434,   435,
     734,   735,   436,   437,     0,   140,   438,   737,   439,   440,
     441,   442,   144,   738,   145,   739,   443,   444,   445,   446,
     148,   447,   740,   741,   448,   449,   450,   451,   452,   453,
     742,   151,   454,     0,   744,   745,   746,   152,   747,   748,
     749,   455,   456,   457,   458,     0,   459,   155,   156,   460,
     750,   461,   751,   462,   463,   464,   465,   466,   752,   467,
     468,   469,   753,   754,   470,   471,   472,   473,   474,   755,
     475,   476,   477,   756,   478,   479,   757,   480,   481,   482,
     483,   164,   484,   485,   486,   166,   758,   487,   759,   488,
     168,   489,   760,   490,   761,   491,   169,   762,   170,   492,
     493,   494,   763,   495,   172,   764,   496,   765,   497,   498,
       0,   499,   500,   173,   501,   502,   503,   766,   504,   505,
     506,   507,   508,   509,   767,   510,   174,   175,     0,   511,
     512,   513,     0,   176,   770,   177,   771,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,   772,
     523,   181,   182,   524,   183,   773,   525,   526,   527,   774,
     775,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   537,   188,   189,   190,   538,   539,   191,   776,
     540,   541,   193,   542,   777,   194,   543,   195,   544,   545,
     546,   778,   547,   779,   780,   548,   549,   550,   781,   782,
     196,   197,   198,   199,   200,   551,   552,   553,   554,   555,
     556,   557,   783,   558,   201,   559,   202,   560,   561,   562,
     784,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,   785,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,   786,   584,   585,   210,   586,   587,
     212,   588,   589,   590,   591,   592,   593,     0,   594,   787,
     595,   596,   597,   598,   599,   788,   600,   217,   601,   602,
     219,   603,   220,   604,   789,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,   790,   615,   616,   791,
     617,   618,   619,   620,   621,   622,   792,   224,   225,     0,
     794,   624,   226,   625,   227,   795,   626,   627,   628,   629,
     630,   631,   632,     0,   797,   633,   634,   635,   636,   637,
     798,   799,   638,   639,   640,   641,   642,     0,   234,   801,
     643,   235,   644,   645,   646,   802,   803,   647,   804,   805,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,     0,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,   412,     0,     0,    37,    38,    39,    40,
      41,    42,     0,    44,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,  1132,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,   412,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
    2365,   439,   440,   441,   442,   144,     0,     0,  2440,   443,
     444,   445,   446,     0,   447,   684,  2366,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
    2441,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,  2368,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,  2369,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,  2370,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,  2365,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,  2366,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,  2441,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,  2368,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,  3317,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,  2369,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,  2370,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,  1030,   419,   420,   989,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,   990,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,  1031,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,   991,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,   992,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,   989,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,   990,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,  3022,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,   991,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,   992,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,    37,    38,    39,    40,    41,    42,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,  2365,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,  2366,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,  2441,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,  2368,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,  2369,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,  2370,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,   412,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,   682,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,   685,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,   687,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,   989,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
     990,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,   991,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,   992,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,   905,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,   412,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
     906,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   907,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,  2045,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,  2046,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,  2047,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,  2048,   491,     0,     0,
       0,  2049,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,  2050,  2051,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,  2052,   592,   593,   691,
     594,     0,  2053,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,  2054,   617,  2055,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
    2056,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,   990,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,   991,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,   992,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,  2034,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,  2323,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,  2898,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,  2899,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,  2900,   617,   618,  2901,   620,  2902,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,  2903,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,   709,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,   412,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,   687,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,   412,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,   857,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
     412,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,  1303,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,   130,   131,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,  3103,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
    3104,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
    3115,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,  3116,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,   412,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,   412,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   911,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,   412,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   953,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,   412,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,  1006,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
    1063,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,  1206,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,  1063,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,  1545,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,  1718,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,  1063,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,  1942,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,  2034,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,  2323,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
    4018,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,  4031,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,  4249,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,  4251,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,   500,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,  4253,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,   500,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,  4629,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,  1014,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,  1016,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,  1017,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,     0,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,  1018,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1019,   225,     0,
       0,  1020,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,  1021,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
    1057,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,  1017,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,     0,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,  1058,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,  1059,   225,
       0,     0,  1060,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,  1021,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,   500,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,  1077,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,  1182,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,  1203,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,  1214,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,  1265,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,  1316,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
    1333,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,  1335,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,  1337,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,   590,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,  1340,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,  1346,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,  1556,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,  1043,   437,  1017,   140,  1557,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,     0,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,   500,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,  1047,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,  1048,   587,   212,   588,   589,   590,  1049,   592,   593,
     691,   594,     0,   595,   596,   597,   598,  1549,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
    1051,   225,     0,     0,  1052,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
    1021,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,  1053,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
    1682,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,   500,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,  1905,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,  1932,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,   683,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,   684,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,  1966,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,   537,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,   586,   587,   212,   588,   589,
     590,   591,   592,   593,   691,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,   692,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,   683,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
     684,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
    1968,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
     537,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,   586,   587,   212,   588,
     589,   590,   591,   592,   593,   691,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,   692,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,   683,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,   684,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,  1970,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,   537,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,   586,   587,   212,
     588,   589,   590,   591,   592,   593,   691,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,   692,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,   683,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,   684,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,   537,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,   586,   587,
     212,   588,   589,  2082,   591,   592,   593,   691,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   692,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,  2289,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,   588,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,     0,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,   669,    90,    91,    92,   670,     0,   671,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     672,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   673,   674,     0,
       0,     0,   675,   676,     0,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     0,   678,     0,   679,
       0,   680,   681,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,     0,   428,   429,
     430,   135,   136,     0,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,   683,   140,   438,     0,
     439,   440,   441,   442,   144,     0,     0,     0,   443,   444,
     445,   446,     0,   447,   684,     0,   448,   449,   450,   451,
     452,   453,     0,     0,   454,     0,     0,     0,     0,     0,
       0,     0,     0,   455,   456,   457,   458,   686,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,     0,     0,
       0,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,   688,   499,  2662,     0,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,     0,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
       0,     0,   515,     0,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,     0,   524,     0,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,   689,   533,
     534,   690,   535,   536,   537,   188,     0,   190,   538,   539,
     191,     0,   540,   541,     0,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,     0,     0,     0,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,     0,
     586,   587,   212,   588,   589,   590,   591,   592,   593,   691,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,     0,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,   692,
     234,     0,   643,     0,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   693,   653,   654,    86,
      87,    88,   669,    90,    91,    92,   670,     0,   671,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   672,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   673,   674,
       0,     0,     0,   675,   676,     0,     0,     0,     0,   677,
       0,     0,     0,     0,     0,     0,     0,     0,   678,     0,
     679,     0,   680,   681,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,     0,   428,
     429,   430,   135,   136,     0,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,   683,   140,   438,
       0,   439,   440,   441,   442,   144,     0,     0,     0,   443,
     444,   445,   446,     0,   447,   684,     0,   448,   449,   450,
     451,   452,   453,     0,     0,   454,     0,     0,     0,     0,
       0,     0,     0,     0,   455,   456,   457,   458,   686,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,     0,
       0,     0,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,   688,   499,  3033,     0,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,     0,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,     0,     0,   515,     0,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,     0,   524,     0,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,   689,
     533,   534,   690,   535,   536,   537,   188,     0,   190,   538,
     539,   191,     0,   540,   541,     0,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,     0,     0,     0,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
       0,   586,   587,   212,   588,   589,   590,   591,   592,   593,
     691,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,     0,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,     0,     0,   638,   639,   640,   641,   642,
     692,   234,     0,   643,     0,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,   693,   653,   654,
      86,    87,    88,   669,    90,    91,    92,   670,     0,   671,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   672,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   673,
     674,     0,     0,     0,   675,   676,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,   678,
       0,   679,     0,   680,   681,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,     0,
     428,   429,   430,   135,   136,     0,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,   683,   140,
     438,     0,   439,   440,   441,   442,   144,     0,     0,     0,
     443,   444,   445,   446,     0,   447,   684,     0,   448,   449,
     450,   451,   452,   453,     0,     0,   454,     0,     0,     0,
       0,     0,     0,     0,     0,   455,   456,   457,   458,   686,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
       0,     0,     0,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,   688,   499,  3106,     0,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
       0,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,     0,     0,   515,     0,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,     0,   524,     0,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
     689,   533,   534,   690,   535,   536,   537,   188,     0,   190,
     538,   539,   191,     0,   540,   541,     0,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,     0,     0,     0,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,     0,   586,   587,   212,   588,   589,   590,   591,   592,
     593,   691,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,     0,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,   692,   234,     0,   643,     0,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,   693,   653,
     654,    86,    87,    88,   669,    90,    91,    92,   670,     0,
     671,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   672,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     673,   674,     0,     0,     0,   675,   676,     0,     0,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
     678,     0,   679,     0,   680,   681,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
       0,   428,   429,   430,   135,   136,     0,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,   683,
     140,   438,     0,   439,   440,   441,   442,   144,     0,     0,
       0,   443,   444,   445,   446,     0,   447,   684,     0,   448,
     449,   450,   451,   452,   453,     0,     0,   454,     0,     0,
       0,     0,     0,     0,     0,     0,   455,   456,   457,   458,
     686,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,     0,     0,     0,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,   688,   499,  3108,     0,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,     0,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,     0,     0,   515,     0,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,     0,   524,     0,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,   689,   533,   534,   690,   535,   536,   537,   188,     0,
     190,   538,   539,   191,     0,   540,   541,     0,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,     0,     0,     0,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,     0,   586,   587,   212,   588,   589,   590,   591,
     592,   593,   691,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,     0,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,   692,   234,     0,   643,     0,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,   693,
     653,   654,    86,    87,    88,   669,    90,    91,    92,   670,
       0,   671,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   672,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   673,   674,     0,     0,     0,   675,   676,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,   678,     0,   679,     0,   680,   681,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,     0,   428,   429,   430,   135,   136,     0,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
     683,   140,   438,     0,   439,   440,   441,   442,   144,     0,
       0,     0,   443,   444,   445,   446,     0,   447,   684,     0,
     448,   449,   450,   451,   452,   453,     0,     0,   454,     0,
       0,     0,     0,     0,     0,     0,     0,   455,   456,   457,
     458,   686,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,     0,     0,     0,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,   688,   499,  3200,     0,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,     0,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,     0,     0,   515,     0,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,     0,   524,
       0,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,   689,   533,   534,   690,   535,   536,   537,   188,
       0,   190,   538,   539,   191,     0,   540,   541,     0,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,     0,     0,     0,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,     0,   586,   587,   212,   588,   589,   590,
     591,   592,   593,   691,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,     0,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,   692,   234,     0,   643,     0,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
     693,   653,   654,    86,    87,    88,   669,    90,    91,    92,
     670,     0,   671,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   672,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   673,   674,     0,     0,     0,   675,   676,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
       0,     0,   678,     0,   679,     0,   680,   681,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,     0,   428,   429,   430,   135,   136,     0,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,  1043,
     437,  1017,   140,   438,     0,   439,   440,   441,   442,   144,
       0,     0,     0,   443,   444,   445,   446,     0,   447,     0,
       0,   448,   449,   450,   451,   452,   453,     0,     0,   454,
       0,     0,     0,     0,     0,     0,     0,     0,   455,   456,
     457,   458,   686,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,     0,     0,     0,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,   688,   499,   500,
       0,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,     0,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,     0,     0,   515,     0,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,     0,
     524,     0,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,   689,   533,   534,   690,   535,   536,  1047,
     188,     0,   190,   538,   539,   191,     0,   540,   541,     0,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,     0,     0,
       0,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,     0,  1048,   587,   212,   588,   589,
     590,  1049,   592,   593,   691,   594,     0,   595,   596,   597,
     598,  1549,     0,   600,   217,   601,   602,     0,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,  1051,   225,     0,     0,  1052,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,  1021,   234,     0,   643,     0,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,  1053,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   693,   653,   654,    86,    87,    88,   669,    90,    91,
      92,   670,     0,   671,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   672,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   673,   674,     0,     0,     0,   675,   676,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
       0,     0,     0,   678,     0,   679,     0,   680,   681,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,     0,   428,   429,   430,   135,   136,     0,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
    1043,   437,  1017,   140,   438,     0,   439,   440,   441,   442,
     144,     0,     0,     0,   443,   444,   445,   446,     0,   447,
       0,     0,   448,   449,   450,   451,   452,   453,     0,     0,
     454,     0,     0,     0,     0,     0,     0,     0,     0,   455,
     456,   457,   458,   686,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,     0,     0,     0,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,   688,   499,
     500,     0,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,     0,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,     0,     0,   515,     0,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
       0,   524,     0,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,   689,   533,   534,   690,   535,   536,
    1047,   188,     0,   190,   538,   539,   191,     0,   540,   541,
       0,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,     0,
       0,     0,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,     0,  1048,   587,   212,   588,
     589,   590,  1049,   592,   593,   691,   594,     0,   595,   596,
     597,   598,  1549,     0,   600,   217,   601,   602,     0,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,  2356,
     619,   620,   621,   622,     0,  1051,   225,     0,     0,  1052,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,  1021,   234,     0,   643,     0,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,  1053,   237,   238,   239,   240,   241,   242,   243,
     244,   245,   693,   653,   654,    86,    87,    88,   669,    90,
      91,    92,   670,     0,   671,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   672,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   673,   674,     0,     0,     0,   675,
     676,     0,     0,     0,     0,   677,     0,     0,     0,     0,
       0,     0,     0,     0,   678,     0,   679,     0,   680,   681,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,     0,   428,   429,   430,   135,   136,
       0,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,  1043,   437,  1017,   140,   438,     0,   439,   440,   441,
     442,   144,     0,     0,     0,   443,   444,   445,   446,     0,
     447,     0,     0,   448,   449,   450,   451,   452,   453,     0,
       0,   454,     0,     0,     0,     0,     0,     0,     0,     0,
     455,   456,   457,   458,   686,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,     0,     0,     0,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,   688,
     499,   500,     0,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,     0,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,     0,     0,   515,
       0,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,     0,   524,     0,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,   689,   533,   534,   690,   535,
     536,  1047,   188,     0,   190,   538,   539,   191,     0,   540,
     541,     0,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
       0,     0,     0,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,     0,  1048,   587,   212,
     588,   589,   590,  2416,   592,   593,   691,   594,     0,   595,
     596,   597,   598,  2417,     0,   600,   217,   601,   602,     0,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,  1051,   225,     0,     0,
    2418,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,  1021,   234,     0,   643,
       0,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,  1053,   237,   238,   239,   240,   241,   242,
     243,   244,   245,   693,   653,   654,    86,    87,    88,   669,
      90,    91,    92,   670,     0,   671,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   672,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   673,   674,     0,     0,     0,
     675,   676,     0,     0,     0,     0,   677,     0,     0,     0,
       0,     0,     0,     0,     0,   678,     0,   679,     0,   680,
     681,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,     0,   428,   429,   430,   135,
     136,     0,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,  1043,   437,  1017,   140,   438,     0,   439,   440,
     441,   442,   144,     0,     0,     0,   443,   444,   445,   446,
       0,   447,     0,     0,   448,   449,   450,   451,   452,   453,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,   455,   456,   457,   458,   686,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,     0,     0,     0,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
     688,   499,   500,     0,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,     0,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,     0,     0,
     515,     0,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,     0,   524,     0,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,   689,   533,   534,   690,
     535,   536,  1047,   188,     0,   190,   538,   539,   191,     0,
     540,   541,     0,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,     0,     0,     0,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,     0,  1048,   587,
     212,   588,   589,   590,  1049,   592,   593,   691,   594,     0,
     595,   596,   597,   598,  2417,     0,   600,   217,   601,   602,
       0,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,  1051,   225,     0,
       0,  2418,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,  1021,   234,     0,
     643,     0,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,  1053,   237,   238,   239,   240,   241,
     242,   243,   244,   245,   693,   653,   654,    86,    87,    88,
     669,    90,    91,    92,   670,     0,   671,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   672,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   673,   674,     0,     0,
       0,   675,   676,     0,     0,     0,     0,   677,     0,     0,
       0,     0,     0,     0,     0,     0,   678,     0,   679,     0,
     680,   681,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,     0,   428,   429,   430,
     135,   136,     0,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,   683,   140,   438,     0,   439,
     440,   441,   442,   144,     0,     0,     0,   443,   444,   445,
     446,     0,   447,   684,     0,   448,   449,   450,   451,   452,
     453,     0,     0,   454,     0,     0,     0,     0,     0,     0,
       0,     0,   455,   456,   457,   458,   686,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,     0,     0,     0,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,   688,   499,   500,     0,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,     0,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,     0,
       0,   515,     0,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,     0,   524,     0,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,   689,   533,   534,
     690,   535,   536,   537,   188,     0,   190,   538,   539,   191,
       0,   540,   541,     0,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,     0,     0,     0,   200,   551,   552,   553,   554,
       0,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,     0,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,     0,   586,
     587,   212,     0,   589,   590,   591,   592,   593,   691,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,     0,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,   692,   234,
       0,   643,     0,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,   693,   653,   654,    86,    87,
      88,     0,    90,    91,    92,     0,     0,     0,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
       0,     0,     0,   107,   108,   109,   110,     0,   111,   112,
     113,   114,   115, -2332,   116,   117,   118,     0,     0,     0,
       0,     0,   121,   122,     0,     0,     0,     0,   123,     0,
       0,     0,     0,     0,     0,     0,     0,   124,     0,   125,
       0,   126,   127,    35,     0,   407,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,   145,     0,     0,     0,
       0,     0,   148,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   151,     0,     0,     0,     0,     0,   152,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   155,
     156,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   162,     0,     0,     0,
       0,     0,     0,   164,     0,     0,     0,   166,     0,     0,
       0,     0,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,     0,     0,   172,     0,     0,     0,
       0,     0,     0,     0,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   174,   175,
       0,     0,     0,     0,     0,   176,     0,   177,     0,     0,
     178,   179,     0,   180,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   181,   182,     0,   183,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   188,   189,   190,     0,     0,
     191,     0,     0,     0,   193,     0,     0,   194,     0,   195,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   196,   197,   198,   199,   200,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   201,     0,   202,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     204,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   210,
       0,     0,   212,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   217,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   224,
     225,     0,     0,     0,   226,     0,   227,     0,     0,     0,
       0,     0,     0,     0,     0,   230,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     234,     0,     0,   235,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   237,   238,   239,
     240,   241,   242,   243,   244,   245,    86,    87,    88,     0,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115, -2333,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
     127,    35,     0,  1127,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,   145,     0,     0,     0,     0,     0,
     148,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   151,     0,     0,     0,     0,     0,   152,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   155,   156,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,   164,     0,     0,     0,   166,     0,     0,     0,     0,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
       0,     0,     0,   176,     0,   177,     0,     0,   178,   179,
       0,   180,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   181,   182,     0,   183,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   188,   189,   190,     0,     0,   191,     0,
       0,     0,   193,     0,     0,   194,     0,   195,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     196,   197,   198,   199,   200,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   201,     0,   202,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   210,     0,     0,
     212,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,     0,     0,
     219,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   224,   225,     0,
       0,     0,   226,     0,   227,     0,     0,     0,     0,     0,
       0,     0,     0,   230,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   234,     0,
       0,   235,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   237,   238,   239,   240,   241,
     242,   243,   244,   245,    86,    87,    88,     0,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,     0,     0,     0,   107,
     108,   109,   110,     0,   111,   112,   113,   114,   115,     0,
     116,   117,   118,     0,     0,     0,     0,     0,   121,   122,
       0,     0,     0,     0,   123,     0,     0,     0,     0,     0,
       0,     0,     0,   124,     0,   125,     0,   126,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
     144,     0,   145,     0,     0,     0,     0,     0,   148,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   151,
       0,     0,     0,     0,     0,   152,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   155,   156,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   162,     0,     0,     0,     0,     0,     0,   164,
       0,     0,     0,   166,     0,     0,     0,     0,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   172,     0,     0,     0,     0,     0,     0,     0,
       0,   173,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   174,   175,     0,     0,     0,     0,
       0,   176,     0,   177,     0,     0,   178,   179,     0,   180,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   181,
     182,     0,   183,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   188,   189,   190,     0,     0,   191,     0,     0,     0,
     193,     0,     0,   194,     0,   195,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   196,   197,
     198,   199,   200,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   201,     0,   202,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   204,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   210,     0,     0,   212,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   217,     0,     0,   219,     0,
     220,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   224,   225,     0,     0,     0,
     226,     0,   227,     0,     0,     0,     0,     0,     0,     0,
       0,   230,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   234,     0,     0,   235,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   237,   238,   239,   240,   241,   242,   243,
     244,   245,    86,    87,    88,     0,    90,    91,    92,     0,
       0,     0,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,     0,     0,     0,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115,     0,   116,   117,
     118,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
     145,     0,     0,     0,     0,     0,   148,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   151,     0,     0,
       0,     0,     0,   152,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   155,   156,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     162,     0,     0,     0,     0,     0,     0,   164,     0,     0,
       0,   166,     0,     0,     0,     0,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     172,     0,     0,     0,     0,     0,     0,     0,     0,   173,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   174,   175,     0,     0,     0,     0,     0,   176,
       0,   177,     0,     0,   178,   179,     0,   180,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   181,   182,     0,
     183,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   188,
     189,   190,     0,     0,   191,     0,     0,     0,   193,     0,
       0,   194,     0,   195,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   196,   197,   198,   199,
     200,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     201,     0,   202,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   204,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   210,     0,     0,   212,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   217,     0,     0,   219,     0,   220,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   224,   225,     0,     0,     0,   226,     0,
     227,     0,     0,     0,     0,     0,     0,     0,     0,   230,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   234,     0,     0,   235,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   237,   238,   239,   240,   241,   242,   243,   244,   245,
      86,    87,    88,     0,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   133,
       0,     0,     0,   135,   136,   137,   138,   139,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,   144,     0,   145,     0,
       0,     0,     0,     0,   148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,   152,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   155,   156,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   164,     0,     0,     0,   166,
       0,     0,     0,     0,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   172,     0,
       0,     0,     0,     0,     0,     0,     0,   173,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     174,   175,     0,     0,     0,     0,     0,   176,     0,   177,
       0,     0,   178,   179,     0,   180,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   181,   182,     0,   183,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   188,   189,   190,
       0,     0,   191,     0,     0,     0,   193,     0,     0,   194,
       0,   195,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   196,   197,   198,   199,   200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   201,     0,
     202,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   204,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   210,     0,     0,   212,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   217,     0,     0,   219,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   222,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   224,   225,     0,     0,     0,   226,     0,   227,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   234,     0,     0,   235,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   237,
     238,   239,   240,   241,   242,   243,   244,   245,    35,   412,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,     0,   140,   438,     0,   439,   440,   441,   442,   144,
       0,   145,     0,   443,   444,   445,   446,   148,   447,     0,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,     0,     0,     0,   152,     0,     0,     0,   455,   456,
     457,   458,     0,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,  2010,   487,     0,   488,   168,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,     0,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,   182,
     524,   183,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   537,
     188,   189,   190,   538,   539,   191,     0,   540,   541,   193,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
    2011,     0,   548,   549,   550,     0,     0,   196,   197,   198,
     199,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,   212,   588,   589,
     590,   591,   592,   593,     0,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,   219,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,  2012,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,     0,   234,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   653,   654,     0,     0,     0,     0,     0,    41,
      42,  1639,  1640,  4213,     0,     0,     0,     0,     0,     0,
    4214,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,   130,   131,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,     0,   140,   438,     0,   439,   440,
     441,   442,   144,     0,   145,     0,   443,   444,   445,   446,
     148,   447,     0,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,     0,     0,     0,   152,     0,     0,
       0,   455,   456,   457,   458,     0,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
       0,   499,   500,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,   182,   524,   183,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   537,   188,   189,   190,   538,   539,   191,     0,
     540,   541,   193,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,   197,   198,   199,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
     212,   588,   589,   590,   591,   592,   593,     0,   594,   215,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
     219,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,   223,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,   233,   234,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,   236,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,     0,   653,   654,    35,   412,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,   246,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,     0,
       0,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
       0,   140,   438,     0,   439,   440,   441,   442,   144,     0,
     145,     0,   443,   444,   445,   446,   148,   447,     0,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
       0,     0,     0,   152,     0,     0,     0,   455,   456,   457,
     458,     0,   459,   155,   156,   460,  2228,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,  2010,   487,     0,   488,   168,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,     0,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,   182,   524,
     183,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   537,   188,
     189,   190,   538,   539,   191,     0,   540,   541,   193,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,  2011,
       0,   548,   549,   550,     0,     0,   196,   197,   198,   199,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,   212,   588,   589,   590,
     591,   592,   593,     0,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,   219,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,  2012,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,     0,   234,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
       0,   653,   654,     0,     0,     0,     0,     0,    35,   412,
    1639,  1640,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,     0,   140,   438,     0,   439,   440,   441,   442,   144,
       0,   145,     0,   443,   444,   445,   446,   148,   447,     0,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,     0,     0,     0,   152,     0,     0,     0,   455,   456,
     457,   458,     0,   459,   155,   156,   460,  2233,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,  2010,   487,     0,   488,   168,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,     0,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,   182,
     524,   183,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   537,
     188,   189,   190,   538,   539,   191,     0,   540,   541,   193,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
    2011,     0,   548,   549,   550,     0,     0,   196,   197,   198,
     199,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,   212,   588,   589,
     590,   591,   592,   593,     0,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,   219,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,  2012,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,     0,   234,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,     0,   653,   654,     0,     0,     0,     0,     0,    35,
     412,  1639,  1640,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,     0,   140,   438,     0,   439,   440,   441,   442,
     144,     0,   145,     0,   443,   444,   445,   446,   148,   447,
       0,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,     0,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,  2010,   487,     0,   488,   168,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,     0,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,   530,   531,   532,     0,   533,   534,     0,   535,   536,
     537,   188,   189,   190,   538,   539,   191,     0,   540,   541,
     193,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,  2011,     0,   548,   549,   550,     0,     0,   196,   197,
     198,   199,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,   212,   588,
     589,   590,   591,   592,   593,     0,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,   219,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,  2012,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,     0,   234,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,     0,   653,   654,     0,     0,     0,     0,     0,
      35,     0,  1639,  1640,    37,    38,    39,    40,    41,    42,
       0,    44,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   140,   438,     0,   439,   440,   441,
     442,   144,     0,   145,     0,   443,   444,   445,   446,   148,
     447,     0,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,     0,     0,     0,   152,     0,     0,     0,
     455,   456,   457,   458,     0,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,  2010,   487,     0,   488,   168,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,   172,     0,   496,     0,   497,   498,     0,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,   182,   524,   183,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   537,   188,   189,   190,   538,   539,   191,     0,   540,
     541,   193,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,  2011,     0,   548,   549,   550,     0,     0,   196,
     197,   198,   199,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,   212,
     588,   589,   590,   591,   592,   593,     0,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,   219,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,  2012,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,     0,   234,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,     0,   653,   654,    35,   412,     0,     0,
      37,    38,    39,    40,    41,    42,     0,    44,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,     0,
     140,   438,     0,   439,   440,   441,   442,   144,     0,   145,
       0,   443,   444,   445,   446,   148,   447,     0,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,     0,     0,
       0,     0,   152,     0,     0,     0,   455,   456,   457,   458,
       0,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,   169,     0,   170,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,     0,   499,   500,   173,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,   174,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,   182,   524,   183,
       0,   525,   526,   527,     0,     0,   528,   529,   530,   531,
     532,     0,   533,   534,     0,   535,   536,   537,   188,   189,
     190,   538,   539,   191,     0,   540,   541,   193,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,   197,   198,   199,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,   212,   588,   589,   590,   591,
     592,   593,     0,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,   219,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,   623,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,     0,   234,     0,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,     0,
     653,   654,    35,   412,     0,     0,    37,    38,    39,    40,
      41,    42,     0,    44,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,     0,   140,   438,     0,   439,
     440,   441,   442,   144,     0,   145,     0,   443,   444,   445,
     446,   148,   447,     0,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,     0,     0,     0,     0,   152,     0,
       0,     0,   455,   456,   457,   458,     0,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,   169,     0,   170,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,     0,   499,   500,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,   182,   524,   183,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   537,   188,   189,   190,   538,   539,   191,
       0,   540,   541,   193,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,   197,   198,   199,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,   212,   588,   589,   590,   591,   592,   593,     0,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,   219,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,     0,   234,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    35,   653,   654,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,   135,   136,   137,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   140,
     438,     0,   439,   440,   441,   442,   144,     0,   145,     0,
     443,   444,   445,   446,   148,   447,     0,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,     0,     0,
       0,   152,     0,     0,     0,   455,   456,   457,   458,     0,
     459,   155,   156,   460,  2213,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,     0,   499,   500,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,   182,   524,   183,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   537,   188,   189,   190,
     538,   539,   191,     0,   540,   541,   193,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,   197,   198,   199,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,   212,   588,   589,   590,   591,   592,
     593,     0,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,   219,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,     0,   234,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,    35,   653,
     654,     0,    37,    38,    39,    40,    41,    42,     0,    44,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,     0,   140,   438,     0,   439,   440,   441,   442,   144,
       0,   145,     0,   443,   444,   445,   446,   148,   447,     0,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,     0,     0,     0,   152,     0,     0,     0,   455,   456,
     457,   458,     0,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,     0,   499,   500,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,   182,
     524,   183,     0,   525,   526,   527,     0,     0,   528,   529,
     530,   531,   532,     0,   533,   534,     0,   535,   536,   537,
     188,   189,   190,   538,   539,   191,     0,   540,   541,   193,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,   197,   198,
     199,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,   212,   588,   589,
     590,   591,   592,   593,     0,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,   219,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,     0,   234,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,    35,   653,   654,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   413,   414,   415,   416,   417,   418,   419,   420,     0,
     421,   422,   423,     0,     0,     0,     0,     0,     0,     0,
     424,   425,     0,   426,   427,   133,   428,   429,   430,   135,
     136,   137,   138,   139,     0,   431,   432,   433,   434,   435,
       0,     0,   436,   437,     0,   140,   438,     0,   439,   440,
     441,   442,   144,     0,   145,     0,   443,   444,   445,   446,
     148,   447,     0,     0,   448,   449,   450,   451,   452,   453,
       0,   151,   454,     0,     0,     0,     0,   152,     0,     0,
       0,   455,   456,   457,   458,     0,   459,   155,   156,   460,
       0,   461,     0,   462,   463,   464,   465,   466,     0,   467,
     468,   469,     0,     0,   470,   471,   472,   473,   474,     0,
     475,   476,   477,     0,   478,   479,     0,   480,   481,   482,
     483,   164,   484,   485,   486,   166,     0,   487,     0,   488,
     168,   489,     0,   490,     0,   491,   169,     0,   170,   492,
     493,   494,     0,   495,   172,     0,   496,     0,   497,   498,
       0,   499,  1990,   173,   501,   502,   503,     0,   504,   505,
     506,   507,   508,   509,     0,   510,   174,   175,     0,   511,
     512,   513,     0,   176,     0,   177,     0,   514,   178,   179,
     515,   180,   516,   517,   518,   519,   520,   521,   522,     0,
     523,   181,   182,   524,   183,     0,   525,   526,   527,     0,
       0,   528,   529,   530,   531,   532,     0,   533,   534,     0,
     535,   536,   537,   188,   189,   190,   538,   539,   191,     0,
     540,   541,   193,   542,     0,   194,   543,   195,   544,   545,
     546,     0,   547,     0,     0,   548,   549,   550,     0,     0,
     196,   197,   198,   199,   200,   551,   552,   553,   554,   555,
     556,   557,     0,   558,   201,   559,   202,   560,   561,   562,
       0,   563,   564,   565,   566,   567,   568,   569,   204,   570,
     571,   572,   573,     0,   574,   575,   576,   577,   578,   579,
     580,   581,   582,   583,     0,   584,   585,   210,   586,   587,
     212,   588,   589,   590,   591,   592,   593,     0,   594,     0,
     595,   596,   597,   598,   599,     0,   600,   217,   601,   602,
     219,   603,   220,   604,     0,   605,   606,   607,   608,   609,
     610,   611,   612,   613,   614,   222,     0,   615,   616,     0,
     617,   618,   619,   620,   621,   622,     0,   224,   225,     0,
       0,   624,   226,   625,   227,     0,   626,   627,   628,   629,
     630,   631,   632,     0,     0,   633,   634,   635,   636,   637,
       0,     0,   638,   639,   640,   641,   642,     0,   234,     0,
     643,   235,   644,   645,   646,     0,     0,   647,     0,     0,
     648,   649,   650,   651,   652,   237,   238,   239,   240,   241,
     242,   243,   244,   245,    35,   653,   654,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   413,   414,   415,   416,   417,   418,
     419,   420,     0,   421,   422,   423,     0,     0,     0,     0,
       0,     0,     0,   424,   425,     0,   426,   427,   133,   428,
     429,   430,   135,   136,   137,   138,   139,     0,   431,   432,
     433,   434,   435,     0,     0,   436,   437,     0,   140,   438,
       0,   439,   440,   441,   442,   144,     0,   145,     0,   443,
     444,   445,   446,   148,   447,     0,     0,   448,   449,   450,
     451,   452,   453,     0,   151,   454,     0,     0,     0,     0,
     152,     0,     0,  2530,   455,   456,   457,   458,     0,   459,
     155,   156,   460,     0,   461,     0,   462,   463,   464,   465,
     466,     0,   467,   468,   469,     0,     0,   470,   471,   472,
     473,   474,     0,   475,   476,   477,     0,   478,   479,     0,
     480,   481,   482,   483,   164,   484,   485,   486,   166,     0,
     487,     0,   488,   168,   489,     0,   490,     0,   491,   169,
       0,   170,   492,   493,   494,     0,   495,   172,     0,   496,
       0,   497,   498,     0,   499,   500,   173,   501,   502,   503,
       0,   504,   505,   506,   507,   508,   509,     0,   510,   174,
     175,     0,   511,   512,   513,     0,   176,     0,   177,     0,
     514,   178,   179,   515,   180,   516,   517,   518,   519,   520,
     521,   522,     0,   523,   181,   182,   524,   183,     0,   525,
     526,   527,     0,     0,   528,   529,   530,   531,   532,     0,
     533,   534,     0,   535,   536,   537,   188,   189,   190,   538,
     539,   191,     0,   540,   541,   193,   542,     0,   194,   543,
     195,   544,   545,   546,     0,   547,     0,     0,   548,   549,
     550,     0,     0,   196,   197,   198,   199,   200,   551,   552,
     553,   554,   555,   556,   557,     0,   558,   201,   559,   202,
     560,   561,   562,     0,   563,   564,   565,   566,   567,   568,
     569,   204,   570,   571,   572,   573,     0,   574,   575,   576,
     577,   578,   579,   580,   581,   582,   583,     0,   584,   585,
     210,   586,   587,   212,   588,   589,   590,   591,   592,   593,
       0,   594,     0,   595,   596,   597,   598,   599,     0,   600,
     217,   601,   602,   219,   603,   220,   604,     0,   605,   606,
     607,   608,   609,   610,   611,   612,   613,   614,   222,     0,
     615,   616,     0,   617,   618,   619,   620,   621,   622,     0,
     224,   225,     0,     0,   624,   226,   625,   227,     0,   626,
     627,   628,   629,   630,   631,   632,     0,     0,   633,   634,
     635,   636,   637,  2531,     0,   638,   639,   640,   641,   642,
       0,   234,     0,   643,   235,   644,   645,   646,     0,     0,
     647,     0,     0,   648,   649,   650,   651,   652,   237,   238,
     239,   240,   241,   242,   243,   244,   245,    35,   653,   654,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   413,   414,   415,
     416,   417,   418,   419,   420,     0,   421,   422,   423,   130,
     131,     0,     0,     0,     0,     0,   424,   425,     0,   426,
     427,   133,   428,   429,   430,   135,   136,   137,   138,   139,
       0,   431,   432,   433,   434,   435,     0,     0,   436,   437,
       0,   140,   438,     0,   439,   440,   441,   442,   144,     0,
     145,     0,   443,   444,   445,   446,   148,   447,     0,     0,
     448,   449,   450,   451,   452,   453,     0,   151,   454,     0,
       0,     0,     0,   152,     0,     0,     0,   455,   456,   457,
     458,     0,   459,   155,   156,   460,     0,   461,     0,   462,
     463,   464,   465,   466,     0,   467,   468,   469,     0,     0,
     470,   471,   472,   473,   474,     0,   475,   476,   477,     0,
     478,   479,     0,   480,   481,   482,   483,   164,   484,   485,
     486,   166,     0,   487,     0,   488,   168,   489,     0,   490,
       0,   491,   169,     0,   170,   492,   493,   494,     0,   495,
     172,     0,   496,     0,   497,   498,     0,   499,   500,   173,
     501,   502,   503,     0,   504,   505,   506,   507,   508,   509,
       0,   510,   174,   175,     0,   511,   512,   513,     0,   176,
       0,   177,     0,   514,   178,   179,   515,   180,   516,   517,
     518,   519,   520,   521,   522,     0,   523,   181,   182,   524,
     183,     0,   525,   526,   527,     0,     0,   528,   529,   530,
     531,   532,     0,   533,   534,     0,   535,   536,   537,   188,
     189,   190,   538,   539,   191,     0,   540,   541,   193,   542,
       0,   194,   543,   195,   544,   545,   546,     0,   547,     0,
       0,   548,   549,   550,     0,     0,   196,   197,   198,   199,
     200,   551,   552,   553,   554,   555,   556,   557,     0,   558,
     201,   559,   202,   560,   561,   562,     0,   563,   564,   565,
     566,   567,   568,   569,   204,   570,   571,   572,   573,     0,
     574,   575,   576,   577,   578,   579,   580,   581,   582,   583,
       0,   584,   585,   210,   586,   587,   212,   588,   589,   590,
     591,   592,   593,     0,   594,     0,   595,   596,   597,   598,
     599,     0,   600,   217,   601,   602,   219,   603,   220,   604,
       0,   605,   606,   607,   608,   609,   610,   611,   612,   613,
     614,   222,     0,   615,   616,     0,   617,   618,   619,   620,
     621,   622,     0,   224,   225,     0,     0,   624,   226,   625,
     227,     0,   626,   627,   628,   629,   630,   631,   632,     0,
       0,   633,   634,   635,   636,   637,     0,     0,   638,   639,
     640,   641,   642,     0,   234,     0,   643,   235,   644,   645,
     646,     0,     0,   647,     0,     0,   648,   649,   650,   651,
     652,   237,   238,   239,   240,   241,   242,   243,   244,   245,
      35,   653,   654,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     413,   414,   415,   416,   417,   418,   419,   420,     0,   421,
     422,   423,     0,     0,     0,     0,     0,     0,     0,   424,
     425,     0,   426,   427,   133,   428,   429,   430,   135,   136,
     137,   138,   139,     0,   431,   432,   433,   434,   435,     0,
       0,   436,   437,     0,   140,   438,     0,   439,   440,   441,
     442,   144,     0,   145,     0,   443,   444,   445,   446,   148,
     447,     0,     0,   448,   449,   450,   451,   452,   453,     0,
     151,   454,     0,     0,     0,     0,   152,     0,     0,     0,
     455,   456,   457,   458,     0,   459,   155,   156,   460,     0,
     461,     0,   462,   463,   464,   465,   466,     0,   467,   468,
     469,     0,     0,   470,   471,   472,   473,   474,     0,   475,
     476,   477,     0,   478,   479,     0,   480,   481,   482,   483,
     164,   484,   485,   486,   166,     0,   487,     0,   488,   168,
     489,     0,   490,     0,   491,   169,     0,   170,   492,   493,
     494,     0,   495,   172,  3384,   496,     0,   497,   498,     0,
     499,   500,   173,   501,   502,   503,     0,   504,   505,   506,
     507,   508,   509,     0,   510,   174,   175,     0,   511,   512,
     513,     0,   176,     0,   177,     0,   514,   178,   179,   515,
     180,   516,   517,   518,   519,   520,   521,   522,     0,   523,
     181,   182,   524,   183,     0,   525,   526,   527,     0,     0,
     528,   529,   530,   531,   532,     0,   533,   534,     0,   535,
     536,   537,   188,   189,   190,   538,   539,   191,     0,   540,
     541,   193,   542,     0,   194,   543,   195,   544,   545,   546,
       0,   547,     0,     0,   548,   549,   550,     0,     0,   196,
     197,   198,   199,   200,   551,   552,   553,   554,   555,   556,
     557,     0,   558,   201,   559,   202,   560,   561,   562,     0,
     563,   564,   565,   566,   567,   568,   569,   204,   570,   571,
     572,   573,     0,   574,   575,   576,   577,   578,   579,   580,
     581,   582,   583,     0,   584,   585,   210,   586,   587,   212,
     588,   589,   590,   591,   592,   593,     0,   594,     0,   595,
     596,   597,   598,   599,     0,   600,   217,   601,   602,   219,
     603,   220,   604,     0,   605,   606,   607,   608,   609,   610,
     611,   612,   613,   614,   222,     0,   615,   616,     0,   617,
     618,   619,   620,   621,   622,     0,   224,   225,     0,     0,
     624,   226,   625,   227,     0,   626,   627,   628,   629,   630,
     631,   632,     0,     0,   633,   634,   635,   636,   637,     0,
       0,   638,   639,   640,   641,   642,     0,   234,     0,   643,
     235,   644,   645,   646,     0,     0,   647,     0,     0,   648,
     649,   650,   651,   652,   237,   238,   239,   240,   241,   242,
     243,   244,   245,    35,   653,   654,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   413,   414,   415,   416,   417,   418,   419,
     420,     0,   421,   422,   423,     0,     0,     0,     0,     0,
       0,     0,   424,   425,     0,   426,   427,   133,   428,   429,
     430,   135,   136,   137,   138,   139,     0,   431,   432,   433,
     434,   435,     0,     0,   436,   437,     0,   140,   438,     0,
     439,   440,   441,   442,   144,     0,   145,     0,   443,   444,
     445,   446,   148,   447,     0,     0,   448,   449,   450,   451,
     452,   453,     0,   151,   454,     0,     0,     0,     0,   152,
       0,     0,     0,   455,   456,   457,   458,     0,   459,   155,
     156,   460,     0,   461,     0,   462,   463,   464,   465,   466,
       0,   467,   468,   469,     0,     0,   470,   471,   472,   473,
     474,     0,   475,   476,   477,     0,   478,   479,     0,   480,
     481,   482,   483,   164,   484,   485,   486,   166,     0,   487,
       0,   488,   168,   489,     0,   490,     0,   491,   169,     0,
     170,   492,   493,   494,     0,   495,   172,     0,   496,     0,
     497,   498,     0,   499,   500,   173,   501,   502,   503,     0,
     504,   505,   506,   507,   508,   509,     0,   510,   174,   175,
       0,   511,   512,   513,     0,   176,     0,   177,     0,   514,
     178,   179,   515,   180,   516,   517,   518,   519,   520,   521,
     522,     0,   523,   181,   182,   524,   183,     0,   525,   526,
     527,     0,     0,   528,   529,   530,   531,   532,     0,   533,
     534,     0,   535,   536,   537,   188,   189,   190,   538,   539,
     191,     0,   540,   541,   193,   542,     0,   194,   543,   195,
     544,   545,   546,     0,   547,     0,     0,   548,   549,   550,
       0,     0,   196,   197,   198,   199,   200,   551,   552,   553,
     554,   555,   556,   557,     0,   558,   201,   559,   202,   560,
     561,   562,     0,   563,   564,   565,   566,   567,   568,   569,
     204,   570,   571,   572,   573,     0,   574,   575,   576,   577,
     578,   579,   580,   581,   582,   583,     0,   584,   585,   210,
     586,   587,   212,   588,   589,   590,   591,   592,   593,     0,
     594,     0,   595,   596,   597,   598,   599,     0,   600,   217,
     601,   602,   219,   603,   220,   604,     0,   605,   606,   607,
     608,   609,   610,   611,   612,   613,   614,   222,     0,   615,
     616,     0,   617,   618,   619,   620,   621,   622,     0,   224,
     225,     0,     0,   624,   226,   625,   227,     0,   626,   627,
     628,   629,   630,   631,   632,     0,     0,   633,   634,   635,
     636,   637,     0,     0,   638,   639,   640,   641,   642,     0,
     234,     0,   643,   235,   644,   645,   646,     0,     0,   647,
       0,     0,   648,   649,   650,   651,   652,   237,   238,   239,
     240,   241,   242,   243,   244,   245,    35,   653,   654,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   413,   414,   415,   416,
     417,   418,   419,   420,     0,   421,   422,   423,     0,     0,
       0,     0,     0,     0,     0,   424,   425,     0,   426,   427,
     133,   428,   429,   430,   135,   136,   137,   138,   139,     0,
     431,   432,   433,   434,   435,     0,     0,   436,   437,     0,
     140,   438,     0,   439,   440,   441,   442,   144,     0,   145,
       0,   443,   444,   445,   446,   148,   447,     0,     0,   448,
     449,   450,   451,   452,   453,     0,   151,   454,     0,     0,
       0,     0,   152,     0,     0,     0,   455,   456,   457,   458,
       0,   459,   155,   156,   460,     0,   461,     0,   462,   463,
     464,   465,   466,     0,   467,   468,   469,     0,     0,   470,
     471,   472,   473,   474,     0,   475,   476,   477,     0,   478,
     479,     0,   480,   481,   482,   483,   164,   484,   485,   486,
     166,     0,   487,     0,   488,   168,   489,     0,   490,     0,
     491,   169,     0,   170,   492,   493,   494,     0,   495,   172,
       0,   496,     0,   497,   498,     0,   499,   500,   173,   501,
     502,   503,     0,   504,   505,   506,   507,   508,   509,     0,
     510,   174,   175,     0,   511,   512,   513,     0,   176,     0,
     177,     0,   514,   178,   179,   515,   180,   516,   517,   518,
     519,   520,   521,   522,     0,   523,   181,   182,   524,   183,
       0,   525,   526,   527,     0,     0,   528,   529,  1212,   531,
     532,     0,   533,   534,     0,   535,   536,   537,   188,   189,
     190,   538,   539,   191,     0,   540,   541,   193,   542,     0,
     194,   543,   195,   544,   545,   546,     0,   547,     0,     0,
     548,   549,   550,     0,     0,   196,   197,   198,   199,   200,
     551,   552,   553,   554,   555,   556,   557,     0,   558,   201,
     559,   202,   560,   561,   562,     0,   563,   564,   565,   566,
     567,   568,   569,   204,   570,   571,   572,   573,     0,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,     0,
     584,   585,   210,   586,   587,   212,   588,   589,   590,   591,
     592,   593,     0,   594,     0,   595,   596,   597,   598,   599,
       0,   600,   217,   601,   602,   219,   603,   220,   604,     0,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     222,     0,   615,   616,     0,   617,   618,   619,   620,   621,
     622,     0,   224,   225,     0,     0,   624,   226,   625,   227,
       0,   626,   627,   628,   629,   630,   631,   632,     0,     0,
     633,   634,   635,   636,   637,     0,     0,   638,   639,   640,
     641,   642,     0,   234,     0,   643,   235,   644,   645,   646,
       0,     0,   647,     0,     0,   648,   649,   650,   651,   652,
     237,   238,   239,   240,   241,   242,   243,   244,   245,    35,
     653,   654,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   413,
     414,   415,   416,   417,   418,   419,   420,     0,   421,   422,
     423,     0,     0,     0,     0,     0,     0,     0,   424,   425,
       0,   426,   427,   133,   428,   429,   430,   135,   136,   137,
     138,   139,     0,   431,   432,   433,   434,   435,     0,     0,
     436,   437,     0,   140,   438,     0,   439,   440,   441,   442,
     144,     0,   145,     0,   443,   444,   445,   446,   148,   447,
       0,     0,   448,   449,   450,   451,   452,   453,     0,   151,
     454,     0,     0,     0,     0,   152,     0,     0,     0,   455,
     456,   457,   458,     0,   459,   155,   156,   460,     0,   461,
       0,   462,   463,   464,   465,   466,     0,   467,   468,   469,
       0,     0,   470,   471,   472,   473,   474,     0,   475,   476,
     477,     0,   478,   479,     0,   480,   481,   482,   483,   164,
     484,   485,   486,   166,     0,   487,     0,   488,   168,   489,
       0,   490,     0,   491,   169,     0,   170,   492,   493,   494,
       0,   495,   172,     0,   496,     0,   497,   498,     0,   499,
     500,   173,   501,   502,   503,     0,   504,   505,   506,   507,
     508,   509,     0,   510,   174,   175,     0,   511,   512,   513,
       0,   176,     0,   177,     0,   514,   178,   179,   515,   180,
     516,   517,   518,   519,   520,   521,   522,     0,   523,   181,
     182,   524,   183,     0,   525,   526,   527,     0,     0,   528,
     529,  1286,   531,   532,     0,   533,   534,     0,   535,   536,
     537,   188,   189,   190,   538,   539,   191,     0,   540,   541,
     193,   542,     0,   194,   543,   195,   544,   545,   546,     0,
     547,     0,     0,   548,   549,   550,     0,     0,   196,   197,
     198,   199,   200,   551,   552,   553,   554,   555,   556,   557,
       0,   558,   201,   559,   202,   560,   561,   562,     0,   563,
     564,   565,   566,   567,   568,   569,   204,   570,   571,   572,
     573,     0,   574,   575,   576,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   210,   586,   587,   212,   588,
     589,   590,   591,   592,   593,     0,   594,     0,   595,   596,
     597,   598,   599,     0,   600,   217,   601,   602,   219,   603,
     220,   604,     0,   605,   606,   607,   608,   609,   610,   611,
     612,   613,   614,   222,     0,   615,   616,     0,   617,   618,
     619,   620,   621,   622,     0,   224,   225,     0,     0,   624,
     226,   625,   227,     0,   626,   627,   628,   629,   630,   631,
     632,     0,     0,   633,   634,   635,   636,   637,     0,     0,
     638,   639,   640,   641,   642,     0,   234,     0,   643,   235,
     644,   645,   646,     0,     0,   647,     0,     0,   648,   649,
     650,   651,   652,   237,   238,   239,   240,   241,   242,   243,
     244,   245,    35,   653,   654,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   413,   414,   415,   416,   417,   418,   419,   420,
       0,   421,   422,   423,     0,     0,     0,     0,     0,     0,
       0,   424,   425,     0,   426,   427,   133,   428,   429,   430,
     135,   136,   137,   138,   139,     0,   431,   432,   433,   434,
     435,     0,     0,   436,   437,     0,   140,   438,     0,   439,
     440,   441,   442,   144,     0,   145,     0,   443,   444,   445,
     446,   148,   447,     0,     0,   448,   449,   450,   451,   452,
     453,     0,   151,   454,     0,     0,     0,     0,   152,     0,
       0,     0,   455,   456,   457,   458,     0,   459,   155,   156,
     460,     0,   461,     0,   462,   463,   464,   465,   466,     0,
     467,   468,   469,     0,     0,   470,   471,   472,   473,   474,
       0,   475,   476,   477,     0,   478,   479,     0,   480,   481,
     482,   483,   164,   484,   485,   486,   166,     0,   487,     0,
     488,   168,   489,     0,   490,     0,   491,   169,     0,   170,
     492,   493,   494,     0,   495,   172,     0,   496,     0,   497,
     498,     0,   499,  1322,   173,   501,   502,   503,     0,   504,
     505,   506,   507,   508,   509,     0,   510,   174,   175,     0,
     511,   512,   513,     0,   176,     0,   177,     0,   514,   178,
     179,   515,   180,   516,   517,   518,   519,   520,   521,   522,
       0,   523,   181,   182,   524,   183,     0,   525,   526,   527,
       0,     0,   528,   529,   530,   531,   532,     0,   533,   534,
       0,   535,   536,   537,   188,   189,   190,   538,   539,   191,
       0,   540,   541,   193,   542,     0,   194,   543,   195,   544,
     545,   546,     0,   547,     0,     0,   548,   549,   550,     0,
       0,   196,   197,   198,   199,   200,   551,   552,   553,   554,
     555,   556,   557,     0,   558,   201,   559,   202,   560,   561,
     562,     0,   563,   564,   565,   566,   567,   568,   569,   204,
     570,   571,   572,   573,     0,   574,   575,   576,   577,   578,
     579,   580,   581,   582,   583,     0,   584,   585,   210,   586,
     587,   212,   588,   589,   590,   591,   592,   593,     0,   594,
       0,   595,   596,   597,   598,   599,     0,   600,   217,   601,
     602,   219,   603,   220,   604,     0,   605,   606,   607,   608,
     609,   610,   611,   612,   613,   614,   222,     0,   615,   616,
       0,   617,   618,   619,   620,   621,   622,     0,   224,   225,
       0,     0,   624,   226,   625,   227,     0,   626,   627,   628,
     629,   630,   631,   632,     0,     0,   633,   634,   635,   636,
     637,     0,     0,   638,   639,   640,   641,   642,     0,   234,
       0,   643,   235,   644,   645,   646,     0,     0,   647,     0,
       0,   648,   649,   650,   651,   652,   237,   238,   239,   240,
     241,   242,   243,   244,   245,    35,   653,   654,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   413,   414,   415,   416,   417,
     418,   419,   420,     0,   421,   422,   423,     0,     0,     0,
       0,     0,     0,     0,   424,   425,     0,   426,   427,   133,
     428,   429,   430,   135,   136,   137,   138,   139,     0,   431,
     432,   433,   434,   435,     0,     0,   436,   437,     0,   140,
     438,     0,   439,   440,   441,   442,   144,     0,   145,     0,
     443,   444,   445,   446,   148,   447,     0,     0,   448,   449,
     450,   451,   452,   453,     0,   151,   454,     0,     0,     0,
       0,   152,     0,     0,     0,   455,   456,   457,   458,     0,
     459,   155,   156,   460,     0,   461,     0,   462,   463,   464,
     465,   466,     0,   467,   468,   469,     0,     0,   470,   471,
     472,   473,   474,     0,   475,   476,   477,     0,   478,   479,
       0,   480,   481,   482,   483,   164,   484,   485,   486,   166,
       0,   487,     0,   488,   168,   489,     0,   490,     0,   491,
     169,     0,   170,   492,   493,   494,     0,   495,   172,     0,
     496,     0,   497,   498,     0,   499,  1331,   173,   501,   502,
     503,     0,   504,   505,   506,   507,   508,   509,     0,   510,
     174,   175,     0,   511,   512,   513,     0,   176,     0,   177,
       0,   514,   178,   179,   515,   180,   516,   517,   518,   519,
     520,   521,   522,     0,   523,   181,   182,   524,   183,     0,
     525,   526,   527,     0,     0,   528,   529,   530,   531,   532,
       0,   533,   534,     0,   535,   536,   537,   188,   189,   190,
     538,   539,   191,     0,   540,   541,   193,   542,     0,   194,
     543,   195,   544,   545,   546,     0,   547,     0,     0,   548,
     549,   550,     0,     0,   196,   197,   198,   199,   200,   551,
     552,   553,   554,   555,   556,   557,     0,   558,   201,   559,
     202,   560,   561,   562,     0,   563,   564,   565,   566,   567,
     568,   569,   204,   570,   571,   572,   573,     0,   574,   575,
     576,   577,   578,   579,   580,   581,   582,   583,     0,   584,
     585,   210,   586,   587,   212,   588,   589,   590,   591,   592,
     593,     0,   594,     0,   595,   596,   597,   598,   599,     0,
     600,   217,   601,   602,   219,   603,   220,   604,     0,   605,
     606,   607,   608,   609,   610,   611,   612,   613,   614,   222,
       0,   615,   616,     0,   617,   618,   619,   620,   621,   622,
       0,   224,   225,     0,     0,   624,   226,   625,   227,     0,
     626,   627,   628,   629,   630,   631,   632,     0,     0,   633,
     634,   635,   636,   637,     0,     0,   638,   639,   640,   641,
     642,     0,   234,     0,   643,   235,   644,   645,   646,     0,
       0,   647,     0,     0,   648,   649,   650,   651,   652,   237,
     238,   239,   240,   241,   242,   243,   244,   245,    35,   653,
     654,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   413,   414,
     415,   416,   417,   418,   419,   420,     0,   421,   422,   423,
       0,     0,     0,     0,     0,     0,     0,   424,   425,     0,
     426,   427,   133,   428,   429,   430,   135,   136,   137,   138,
     139,     0,   431,   432,   433,   434,   435,     0,     0,   436,
     437,     0,   140,   438,     0,   439,   440,   441,   442,   144,
       0,   145,     0,   443,   444,   445,   446,   148,   447,     0,
       0,   448,   449,   450,   451,   452,   453,     0,   151,   454,
       0,     0,     0,     0,   152,     0,     0,     0,   455,   456,
     457,   458,     0,   459,   155,   156,   460,     0,   461,     0,
     462,   463,   464,   465,   466,     0,   467,   468,   469,     0,
       0,   470,   471,   472,   473,   474,     0,   475,   476,   477,
       0,   478,   479,     0,   480,   481,   482,   483,   164,   484,
     485,   486,   166,     0,   487,     0,   488,   168,   489,     0,
     490,     0,   491,   169,     0,   170,   492,   493,   494,     0,
     495,   172,     0,   496,     0,   497,   498,     0,   499,  1342,
     173,   501,   502,   503,     0,   504,   505,   506,   507,   508,
     509,     0,   510,   174,   175,     0,   511,   512,   513,     0,
     176,     0,   177,     0,   514,   178,   179,   515,   180,   516,
     517,   518,   519,   520,   521,   522,     0,   523,   181,   182,
     524,   183,     0,   525,   526,   527,     0,     0,   528,   529,
    1343,   531,   532,     0,   533,   534,     0,   535,   536,   537,
     188,   189,   190,   538,   539,   191,     0,   540,   541,   193,
     542,     0,   194,   543,   195,   544,   545,   546,     0,   547,
       0,     0,   548,   549,   550,     0,     0,   196,   197,   198,
     199,   200,   551,   552,   553,   554,   555,   556,   557,     0,
     558,   201,   559,   202,   560,   561,   562,     0,   563,   564,
     565,   566,   567,   568,   569,   204,   570,   571,   572,   573,
       0,   574,   575,   576,   577,   578,   579,   580,   581,   582,
     583,     0,   584,   585,   210,   586,   587,   212,   588,   589,
     590,   591,   592,   593,     0,   594,     0,   595,   596,   597,
     598,   599,     0,   600,   217,   601,   602,   219,   603,   220,
     604,     0,   605,   606,   607,   608,   609,   610,   611,   612,
     613,   614,   222,     0,   615,   616,     0,   617,   618,   619,
     620,   621,   622,     0,   224,   225,     0,     0,   624,   226,
     625,   227,     0,   626,   627,   628,   629,   630,   631,   632,
       0,     0,   633,   634,   635,   636,   637,     0,     0,   638,
     639,   640,   641,   642,     0,   234,     0,   643,   235,   644,
     645,   646,     0,     0,   647,     0,     0,   648,   649,   650,
     651,   652,   237,   238,   239,   240,   241,   242,   243,   244,
     245,     0,   653,   654
};

static const yytype_int16 yycheck[] =
{
       2,   246,   359,    78,    78,   209,    78,  1093,  1045,  1098,
      78,  1321,  1325,   840,  1360,  1368,    78,    96,   150,  1417,
     154,  1061,   117,   117,   880,  1329,   167,   106,  1398,   153,
       2,   228,   990,   991,   992,  1705,  1205,  1163,   996,  1201,
    1889,  2049,  1739,    94,  1577,  2756,   187,  1276,  1223,  1873,
    1487,  1213,  1999,   880,  1458,  1459,  1285,   165,  1430,   171,
    1258,  1052,   715,   142,    78,  1748,  1832,   162,   162,   203,
      84,   375,  1744,  1477,  1744,  2202,    78,   933,   157,    78,
    1914,   132,    84,  2913,  1891,   132,  1739,    89,  3340,   160,
     165,   917,   375,  3069,  1594,  1914,  3279,   209,  1757,  1929,
     935,  1263,   153,   154,  1266,  1914,   933,  1788,  2252,  1271,
     945,   917,   163,  1796,  1312,   117,  1278,  1633,  1634,  1635,
    2521,  1914,  2432,  2433,  1914,  1287,  2567,  3119,  1914,  3121,
    1598,  2087,  3261,   959,  1204,   230,   230,  1207,  1140,   716,
    3574,   361,  1801,  1802,  2971,  1215,   361,  2473,   347,  3625,
    3669,   153,   203,  3248,  1140,  1688,  3844,  2736,  1988,  1505,
     162,  3520,   223,  3618,   958,    78,  3261,  3861,   216,  2911,
    3882,    84,  1938,  2909,  2910,  2907,   117,  3525,  3526,   167,
    1731,  2846,  1931,  1692,  1628,  1629,  1179,  1381,  4095,  3586,
    2296,    88,  1352,  3825,  4292,   117,  1090,  1090,  1361,   187,
    1135,  1136,  3458,    30,   117,    10,   208,   950,    21,  3797,
    4555,   128,    88,    72,   216,   108,   218,    72,   121,  1447,
    1448,   162,  1048,   135,   156,   143,   128,   822,   230,   114,
    2336,    86,  2964,   128,  2340,  4431,    78,   113,   204,    84,
     162,   199,  1048,    99,   149,  1473,   179,   145,   187,   162,
       8,   247,   905,    11,    12,    95,  4548,   180,  3265,  3266,
    3267,  3268,  3269,  3270,    22,    23,    24,   143,    26,    27,
     114,   112,   222,    31,    32,    33,  2602,    29,    75,    76,
      77,    78,   236,   209,    78,    82,   208,  3071,    88,   230,
       5,   227,   367,   367,   216,   367,   218,   222,  1256,   367,
      75,    76,    77,    78,  2153,   367,   145,    82,   230,    72,
      25,   112,  2977,   185,   153,    90,  3792,   230,    81,   141,
      35,  1361,   209,    86,   173,    93,   352,  4870,   266,   396,
      78,  1121,    75,    76,    77,    78,   145,    78,   102,    82,
     307,    75,    76,    77,    78,  2671,   329,  2673,    82,    72,
     180,   111,    75,    76,    77,    78,   219,   197,    81,    82,
     411,   375,  4536,    86,    14,   227,   145,    99,   367,   429,
      72,     0,   329,   375,   106,    75,    76,    77,    78,    81,
    1506,   227,    82,  2391,    86,  1241,  1561,    37,   260,  1042,
     356,   227,   135,   228,  1184,  4938,   410,   185,    99,   103,
     104,    14,   153,   386,  1530,   106,    99,   173,   410,    75,
      76,    77,    78,   106,  1241,   173,    82,   233,    38,   134,
      40,   182,    72,   227,    90,    75,    76,    77,    78,   173,
     490,    81,    82,    83,    84,    72,    86,   173,   505,  1876,
     372,   209,  4540,   306,   369,   266,   180,   266,   266,    86,
      75,    76,    77,    78,   227,   227,   373,    82,   137,    14,
    1864,  1865,   375,   173,    78,    90,   173,  1871,  4100,  2121,
    2576,   373,   398,    75,    76,    77,    78,   503,   373,   309,
      82,   196,   128,  2135,   322,  1525,   246,   343,    90,    75,
      76,    77,    78,   227,  3278,  1330,    82,   410,   431,   623,
     322,   455,    75,    76,    77,    78,   258,   465,  4800,    82,
     506,   398,   451,   451,    75,    76,    77,    78,   485,  1345,
     824,    82,   226,  4697,   228,   367,  1566,  1567,   207,    90,
    1840,   429,  2184,   667,   668,   149,   441,   503,   471,  1345,
    1844,   824,  1368,   301,   393,   224,  2046,   262,  4744,   506,
    2050,   165,  2052,   503,  4899,  2055,    75,    76,    77,    78,
    1137,  1138,  1157,    82,  3693,   410,   422,   490,   424,  1404,
     506,   456,   623,   367,   506,   416,  1370,   449,  1368,    75,
      76,    77,    78,   501,  1419,   429,    82,   505,   346,   506,
     429,   503,    75,    76,    77,    78,  1431,   456,  3693,    82,
     503,  4295,   499,  2427,   506,  3612,   370,  1350,  1434,   449,
     503,   506,   380,  4089,  2147,   416,   667,   668,   382,   367,
     429,   623,  1784,   499,  1786,  1794,   367,  1856,  1434,  2436,
     398,  4263,   246,   451,  1862,  1863,    99,  1835,   451,   494,
     495,   503,  1870,  4231,  4232,  4233,  4234,  4235,   503,  1719,
     429,   456,   135,   419,  3837,  1830,   429,   429,   266,  2192,
     506,   449,  4021,  2196,   715,   503,  4025,   503,   503,   433,
    2040,   350,   404,  3856,   501,   419,  4308,  4074,   429,  1992,
     438,    85,  4856,   419,   497,   506,  4860,   506,  3944,   309,
     506,  1853,   453,  4791,    88,   429,   496,   497,   498,   499,
    3026,   119,   506,   404,   501,  3535,   503,   831,   505,   419,
     266,   404,   419,  1648,   959,   828,  4623,   460,   490,   113,
    2403,  1615,  1615,   836,  4898,   820,   820,   373,   503,   192,
    1556,   494,   495,   505,  2047,  2432,  1093,  2486,  1564,  1565,
    2086,  2087,   266,  2056,    25,  1738,    99,   361,   872,   143,
    1556,  2097,   160,   367,   867,  2101,   490,   461,   461,  4857,
     503,   960,    95,  2109,  2110,   444,    88,   469,  2440,  1559,
     470,   505,   495,   907,  1564,  1565,  2122,  2123,  3088,  3220,
    3090,    88,  3223,  3224,  1361,   846,  3227,  2133,  3520,   489,
     861,   113,   494,   495,  4426,   324,  3237,  2924,  3540,  3806,
    1608,  4433,   926,   503,    75,    76,    77,    78,   921,   229,
     824,    82,    75,    76,    77,    78,    25,   930,   820,    82,
     185,   143,   824,   955,   232,   243,   828,  2021,   969,   247,
     971,  2937,   973,  2027,   836,   837,  1996,   503,   979,   192,
     842,  2350,  2005,   451,   494,   495,  4390,   230,  4392,   851,
     180,   959,   100,  2297,   905,  2299,   907,   494,   495,   229,
      95,  1002,  1003,  1083,   197,   867,   284,   972,  1083,   153,
    2421,   976,   977,   978,   268,   269,   878,   956,   503,   820,
     882,   986,   151,   958,   470,  2113,  2114,   460,   319,  4501,
    3622,   893,   971,   137,   973,   260,   180,    99,   820,  3225,
    3226,   503,   953,   489,   983,   325,   957,   820,   160,   911,
      95,   824,  1768,  4631,  4632,   917,  3892,   503,   312,   921,
     189,   325,   151,  1002,  1003,  3590,  2598,   451,   930,   931,
     503,  1721,   182,   935,   175,   182,   180,   151,  3248,  1729,
    1001,  1768,   503,   945,   473,   147,   323,   160,   950,   505,
    2647,  3261,   154,   230,   429,   325,  2637,   959,   319,   174,
     189,   268,   197,  2003,   307,  1073,   374,    71,    72,    75,
      76,    77,    78,   319,   469,   189,    82,  1935,   950,   181,
     232,   262,   400,   971,   503,   973,  1776,   227,  4682,  1779,
    1780,  1042,   412,  1044,   173,  4707,   197,  1044,  1046,   240,
     266,   180,  1050,   336,   235,   128,  1067,   503,   391,   134,
     135,   506,   197,   261,  1002,  1003,  2053,  2054,  2144,   232,
     503,   329,  4381,   270,   389,   309,   221,  4386,  3338,  4377,
    4389,   506,   175,  4509,   367,   250,  1097,   420,  1040,    95,
      75,    76,    77,    78,  1046,   101,  1048,    82,  1050,   251,
    4662,  1841,   183,   262,  1068,   296,  4308,  4601,   299,   389,
     236,   469,   309,   396,   314,   309,  1068,   236,   337,   228,
     314,    72,   503,  1075,    75,    76,    77,    78,   180,  2928,
      81,    82,    83,    84,   449,    86,   490,   491,   492,   419,
     494,   495,   496,   497,   498,   499,   504,   240,  4792,   507,
     494,   495,   496,   497,   498,   499,   350,  4825,   337,   419,
     357,  4799,   455,   244,   391,  1228,  1972,  1178,   335,   363,
      88,   454,   374,   337,  1046,  1238,   327,   457,  1050,  1964,
     309,   307,   367,  1135,  1136,  4127,   173,   184,   307,   469,
    1975,   197,   503,   420,   384,  1972,   387,   378,   137,  1121,
     345,   336,  1987,   296,   423,  1068,   299,   503,   380,  4635,
    2812,  2813,   439,   240,   153,  2817,  4621,  4686,  1140,  4801,
     371,   369,  1171,   503,   496,   497,   498,   499,   184,   338,
    1293,  2585,   367,  2009,   307,   451,   323,   494,   495,   496,
     497,   498,   499,   151,   423,   396,   504,  2237,   506,   151,
     444,   180,   268,   418,   419,  2857,  2858,   309,   129,   423,
     412,   396,  1184,  4043,  2008,   160,   137,   469,   207,   296,
     267,  1772,   462,  4053,  2724,  1296,  1228,   449,   109,    88,
     409,   189,   503,   412,   179,   224,  1238,   189,   175,  4598,
     503,   507,   401,   484,   387,  4072,    75,    76,    77,    78,
     373,   175,   504,    82,   113,   507,   329,   323,  1260,   506,
    1505,   267,   503,  2119,   470,   210,  1371,   431,  1819,  1374,
     307,   469,  1377,   396,  1379,  4751,   121,  1382,  3085,   455,
     336,  1386,   384,   489,   143,  3092,   455,   121,  2517,  4021,
     380,  1293,  2119,  4025,  1373,  1370,  1375,  4039,  4034,  1378,
     268,  1380,   273,   240,  1383,  1384,  1385,   188,   506,  4051,
     387,   367,  3753,  2121,  4748,  4749,   240,  1396,  3759,  3760,
    3761,  3762,  3763,  3764,   503,   107,   171,  2135,  1330,  4458,
    1409,    85,  1411,  2335,    88,   314,   227,   171,   507,  4522,
     396,   484,    25,  1345,   958,   959,  3925,  1349,  1350,  2335,
    1352,  4827,    35,   229,  2664,  2668,   247,   296,  1360,   296,
       2,   350,   299,  4458,   501,  1416,  1368,   288,   505,  2439,
    2674,   451,   296,  3381,  1678,   266,   336,  1349,  1350,   337,
    1352,  1601,  1602,  3693,  1604,   337,  1601,  1602,  1587,  1604,
    3087,  2620,  2621,  2622,  2623,  1678,  1368,   503,   180,   218,
     227,   506,  1404,  2632,    75,    76,    77,    78,   382,   268,
      97,    82,   229,   503,   259,  1417,  2486,  1419,  4434,    85,
     247,   206,    88,   503,   185,   259,   185,   429,  2005,  1431,
     117,   504,  1434,   506,  3087,  2781,   396,  2507,   197,   266,
     257,   309,  4918,  1445,   389,  4879,    95,    89,   387,   183,
     387,   134,   101,  3597,  3855,   444,   398,  3413,   227,   433,
    2658,  3295,   307,   387,   162,   423,   285,  2537,   503,  1083,
    2938,   423,  1474,   307,   419,   503,  3295,   357,   247,   264,
    1575,  1575,  3163,   192,  2830,   194,  3295,   355,   231,  3172,
    4673,  1542,  1543,   494,   495,  1542,  1543,   266,  4514,   260,
    1502,  1503,  3295,  1505,   506,  3295,   382,   449,   172,  3295,
     244,   153,   457,   327,   268,  2861,  1518,   159,   398,   382,
    1522,  3021,   336,   182,   469,  2315,   494,   495,   496,   497,
     498,   499,   230,  1627,  1912,   183,  2392,  3367,   349,   227,
     385,   349,   236,   185,   329,   288,    51,   484,   197,  4801,
    2896,   385,  1930,   367,  1556,   231,  1617,  1559,   503,   247,
     451,   437,  1564,  1565,    69,  2392,   503,  4397,  4398,   449,
     433,   325,  1574,  1575,   261,  3901,   228,  3903,   266,   262,
    4556,   410,   411,    75,    76,    77,    78,  1559,   347,   218,
      82,   336,  1564,  1565,    22,  1646,   244,  1692,  1692,  1646,
     309,  1603,   268,  2438,   256,  1607,  1608,   161,  4624,   126,
     319,   270,   288,   307,  1628,  1629,   507,  4328,  4634,   271,
     431,   507,   367,   431,   451,  1627,  1628,  1629,   378,   152,
     282,   295,  2481,   297,  1575,   494,   495,   496,   497,   498,
     499,    88,   336,   314,    72,  1716,  1648,  4639,   462,  4381,
     309,   396,   382,  1575,  4386,   172,   285,  4389,   443,   325,
     471,  3031,  1575,   471,  1678,   431,  3325,  1639,  1640,  3328,
     422,  1685,   424,   367,   228,   436,  1678,  2330,   201,   422,
     507,   424,   451,  1685,  1686,    95,  2535,   336,   449,  3093,
    1692,   101,   321,  1665,  1666,  4427,   143,  1699,   357,  2489,
     450,   390,   256,   433,   447,   471,   367,  2497,   490,  2499,
    4421,   192,  4423,   194,  1627,  1628,  1629,   271,   367,   501,
     463,   503,   504,   505,   506,   377,   208,   182,   282,  1731,
     419,   336,   249,   507,  1795,   396,  4712,  1739,   507,  3255,
     494,   495,   496,   497,   498,   499,   422,   396,   424,  1721,
     304,  1692,  3056,    14,   277,   278,  1370,  1729,   503,  4200,
    4201,   455,   367,   451,  1766,  1678,   248,   509,   291,   323,
    1692,   447,  1685,  1772,   463,    72,    37,  1699,   295,  1692,
     297,  4455,   115,  4613,  4110,  4111,   336,   197,  3440,    86,
     307,  3443,  3444,  3445,  3446,  3447,  3448,  3449,  3450,  3451,
    3452,  1896,  1896,   136,  1776,  4479,   218,  1779,  1780,  1731,
     222,    72,   451,   336,  1816,   270,  4548,   367,   335,   507,
    1819,  3473,   314,   377,  2650,   491,   492,  1441,   494,   495,
     496,   497,   498,   499,  1836,   155,  1960,   218,   319,  3646,
    1953,   222,   380,    41,  2650,   336,   396,  1461,  3046,  1962,
    3502,  3503,   451,  1855,   309,   372,    75,    76,    77,    78,
    3626,  2687,   222,    82,   503,   296,  4598,   367,   299,  1841,
     408,  1873,   232,   285,   194,  2079,   367,  1491,   145,  3379,
      71,  2687,   336,   262,   336,   501,   153,   247,    79,    80,
     407,  1505,   508,   182,  1896,   247,   396,   451,   421,  1901,
     423,  2009,   357,  3072,   285,    75,    76,    77,    78,   321,
     247,  1913,    82,   367,   206,   367,   451,    85,  2955,   371,
      88,   469,    75,    76,    77,    78,   218,  1929,  4055,    82,
     222,  3100,   469,  2008,  3304,  2926,  2049,   105,  2728,  2018,
     321,  2020,   396,  2247,   396,  2024,  3435,  2026,   403,  3482,
    2029,  1953,    16,  3802,  2033,  1896,   387,  1959,   506,   227,
    1962,   152,  1964,  1965,  2247,   254,  2078,   371,   503,   506,
    3459,  3654,   264,  1975,  1896,    75,    76,    77,    78,   247,
     389,   623,    82,  1896,   421,  1987,  1988,  1601,  1602,   422,
    1604,   424,   396,   285,  1996,  2070,  2070,  1999,  2070,   182,
     318,  2062,  2070,  3073,  2812,  2813,   356,  2009,  2070,  2817,
     419,   202,  3671,  3672,  2085,   367,   376,   469,   307,   371,
     309,   470,  2878,   128,  1996,  3462,  3463,  1999,  3400,   321,
     367,   381,   469,   470,   371,   357,   504,   329,   506,   222,
     489,  4482,   147,   208,   396,   352,   368,  2049,   457,  2857,
    2858,  2878,    14,   218,   503,   274,   161,   386,  2711,   396,
     469,   252,  2157,  2157,   274,  3598,   503,   192,  4800,   194,
     392,   254,    71,    72,   490,    37,    75,    76,    77,    78,
      79,    80,    81,    82,  2086,  2087,    34,    86,    81,   505,
     222,   216,  2094,    86,   503,  2097,  3406,   502,   429,  2101,
     268,   506,  3500,  2929,  2106,   336,   211,  2109,  2110,   390,
     242,  3273,   501,  4824,   503,  2117,   470,   469,  2120,  2121,
    2122,  2123,  2949,  3469,   307,  2266,   309,    97,  2130,  2131,
    4077,  2133,   469,  2135,  2136,   489,   367,  2139,   419,  2929,
    3989,  2249,   506,   507,   314,   172,   501,   117,  4458,   503,
     341,   443,   507,  2155,  2156,  2157,  2360,   325,  2362,  2161,
     503,   314,  3986,  2165,  3836,   396,  3818,  2169,   433,  2171,
    2172,  2173,  2174,  2175,  2176,  2177,  2178,  2179,  3875,  2181,
     389,   180,   463,  3018,  3019,  2187,    88,   222,  2190,   314,
    3860,   501,    71,  4519,   319,   505,    75,    76,    77,    78,
      79,    80,     7,    82,   506,   369,  3404,   242,   510,   501,
     419,   113,   504,   505,    19,    20,  2157,  3772,  3044,  3774,
     862,   336,  3777,   386,  3779,   252,  2288,   384,   469,   470,
     206,  2355,   332,  2247,    39,  2157,   320,    42,  3044,   323,
    4550,   143,   218,   506,  2157,  2247,   222,   510,   457,   157,
    2252,   442,   367,  3623,  3624,  2350,  2350,    85,  3662,   450,
      88,   250,   453,   192,   421,   194,   265,   501,   295,   503,
     297,   505,  2385,    85,   384,   917,   918,   105,  2391,  2330,
     502,   396,    71,  2297,   506,  2299,    72,   216,   264,   288,
      79,    80,   380,   381,   503,  2297,   175,  2299,   153,    75,
      76,    77,    78,   504,   504,   506,    82,   507,   950,   285,
     435,   421,   469,   470,   508,   504,   323,  2319,   507,  3154,
     445,   328,   490,   491,   492,   384,   494,   495,   496,   497,
     498,   499,   380,   381,  2247,  2337,  3294,  2339,   384,  3991,
    3992,  2402,   323,  2315,  2346,   321,   503,   328,  2350,  2351,
     242,   156,  2354,   329,  2829,  2479,  2831,  2832,   150,   469,
     470,   240,   421,  2335,  1006,  2337,  2460,  2339,  2463,  2463,
    4329,  4330,  4331,  4332,  2376,   421,   231,  2379,  2137,   125,
     309,  2140,   386,  2385,  2297,   314,  2299,  3562,   193,  2391,
     319,   498,  1034,   503,  2008,   250,   503,   161,   505,   469,
     470,  1043,   384,  3529,   180,  1047,  1048,  1049,  2410,  2350,
     469,   470,  3912,  3913,  3914,   274,  3769,   296,   384,  2421,
     299,  3248,   498,   469,   470,  2427,   509,   503,  2350,   505,
    2432,  2433,   503,   288,  3261,  2437,  2438,  2350,    86,   421,
     268,   504,  2444,   506,   503,   503,  3532,  3533,  3274,   384,
    3276,  3286,   323,  3288,   336,   421,  2070,   503,  2460,  2461,
     503,  2463,   505,   115,   228,   310,   311,   443,  3274,   127,
    3276,   125,   384,   328,  2606,    71,    72,   506,  2480,  2481,
    2482,   486,  2484,    79,    80,   367,   421,   469,   470,   371,
      86,  4499,   256,  1135,  1136,   494,   495,   325,  1140,  2421,
    2502,   159,  4035,   469,   470,   270,   435,   271,   387,   421,
    2512,  3337,   326,   504,   396,   506,   445,  2489,   282,  2460,
     108,   503,  2463,  2525,   504,  2497,   506,  2499,   496,   497,
     498,  3337,  2534,  2535,   469,   470,  4069,   503,  2460,   127,
     304,  2463,   505,   504,   389,   506,   326,  2460,  2162,   504,
    2463,   506,   504,   504,   506,   506,   214,   469,   470,  2916,
    2482,  4410,    85,   323,  3399,    88,     2,   422,   503,   424,
     504,   159,   506,  2575,   419,  2577,   429,  3746,   433,    75,
      76,    77,    78,   504,   222,   506,    82,   245,   323,   444,
     113,   503,   447,   504,   326,   506,   119,   486,  2600,  3997,
     115,   504,  2604,   506,   503,   484,   505,   504,   486,   506,
    4307,   311,   457,   377,   270,  1257,  2861,  3407,   226,   504,
     143,   506,   280,   504,   469,   506,   214,  3973,   504,   504,
     506,   506,  3440,  2635,   496,  3443,  3444,  3445,  3446,  3447,
    3448,  3449,  3450,  3451,  3452,  2647,   506,  2760,  2650,   503,
      85,   309,  2765,    88,   504,  3884,   506,   245,   503,   422,
    2711,   424,   490,   491,   492,  3473,   494,   495,   496,   497,
     498,   499,  4172,  4173,  2288,  4175,   506,   507,   336,   494,
     495,   496,   497,   498,   180,  2687,   274,   502,  4340,   389,
     487,   488,   280,  2695,  3502,  3503,   504,  4349,    85,   125,
     504,    88,   506,  1345,  2901,  2902,  2903,  1349,  1350,   367,
    1352,   469,   470,   371,  4366,  4367,   504,   375,   105,   419,
     227,   309,  2967,   381,   247,   504,  1368,   506,  1421,  1422,
     388,   167,  2734,   504,   266,   506,   121,   422,   396,   424,
    2956,  2957,  2837,  2837,  2746,   268,   269,   405,  2843,  2843,
     504,   187,   506,   496,  2756,   413,  2728,   457,  2760,   504,
     504,   506,   506,  2765,   494,   495,   496,   497,   498,   469,
     504,  1413,   506,   504,   504,   506,   504,   162,   506,  2781,
    2782,   262,   504,   371,   506,  2787,   504,   375,   506,   312,
     507,   503,  1434,   381,  2907,   504,   504,   506,   506,   509,
     388,   186,   325,   503,   504,   509,   464,   507,   396,   429,
    2812,  2813,   247,   429,   429,  2817,   201,   405,   429,   429,
     205,   504,   504,   506,   506,   413,   203,  2829,  2830,  2831,
    2832,   108,   504,   268,   506,  2837,   125,   504,   223,   506,
    2842,  2843,   504,  2845,   506,  2847,   262,    75,    76,    77,
      78,  2964,  4222,   238,    82,  2857,  2858,   268,    86,  2861,
     504,  4214,   506,   429,  4534,  1507,  3693,   504,   503,   506,
    2945,  2945,  2874,  2945,  2876,  1517,   464,  2945,  2880,   505,
     468,   268,   504,  2945,   506,  1527,    75,    76,    77,    78,
     325,   396,   472,    82,  2896,   211,  2837,    75,    76,    77,
      78,   504,  2843,   506,    82,  2907,   503,  2909,  2910,  2911,
     504,   504,   506,   506,  1556,  2837,    89,  1559,  1560,   503,
    4572,  2843,  1564,  1565,  2837,   211,   504,  2929,   506,   314,
    2843,  2933,    75,    76,    77,    78,   505,   322,   325,    82,
     504,   211,   506,  3769,  2946,   504,  4344,   506,   504,  2951,
     506,   504,   180,   506,   323,   222,  2958,  2929,    75,    76,
      77,    78,  2964,    85,   211,    82,    88,   507,   283,  4095,
     355,   494,   495,   496,   497,   498,   499,   182,   504,  3769,
     506,   451,   504,   105,   506,    75,    76,    77,    78,   323,
     503,   113,    82,    75,    76,    77,    78,   119,   318,    85,
      82,  3003,    88,   386,  3839,  3840,  1648,   504,   274,   506,
    3818,  4708,   504,   504,   506,   506,  3018,  3019,   504,   105,
     506,   143,  3024,   503,   137,  3119,  3120,  3121,   469,   108,
    4070,    75,    76,    77,    78,   309,   503,   180,    82,   504,
     472,   506,  3044,   115,   504,  3047,   506,  4209,  4394,   504,
     504,   506,   506,   115,   438,   490,   491,   492,   336,   494,
     495,   496,   497,   498,   499,   504,   222,   506,    85,   150,
     504,    88,   506,   504,   504,   506,   506,  1087,  4026,  1089,
    4028,   353,   211,   508,   211,  3087,  3088,   211,  3090,   503,
     472,  4591,   211,   211,   506,   211,   113,   211,   323,   211,
     211,  4601,   119,   490,   491,   492,   211,   494,   495,   496,
     497,   498,   499,   211,   323,   211,   211,  3119,  3120,  3121,
     419,   243,  1260,  4493,   503,   247,   143,  3917,   108,   223,
     283,   222,   323,   222,   222,   503,  3138,   503,   503,   503,
    3142,   503,  3144,  3145,   346,   503,   268,   269,  3243,  3243,
    1792,   503,  3154,   503,  4654,   503,   503,   503,   503,   503,
     503,   503,   284,   503,   503,  3260,  3260,   503,   503,   333,
     503,   503,   503,   503,   503,  4573,   503,   503,  3119,  3120,
    3121,   503,   268,  3991,  3992,   506,   108,   309,   205,   163,
     312,   266,   268,   108,   222,  3197,   283,  3119,  3120,  3121,
     321,   222,   396,   325,  4060,   496,  3119,  3120,  3121,   262,
     387,   506,   179,  3215,   299,  3349,   450,   490,   506,  3221,
      14,   506,  3346,   503,   503,   429,   243,   503,   429,  4729,
     247,  4577,   384,  4060,   505,   384,   429,   429,   384,   325,
     153,  3243,   429,   429,  4642,  3247,  3248,  2861,  4646,  4647,
     429,   268,   269,  3315,   211,   323,   388,   280,  3260,  3261,
     429,  2875,   429,   314,   429,  3510,   450,   284,  3381,   145,
     252,   323,  3274,  1915,  3276,  3520,  3248,   319,   400,  1417,
    2894,   503,   429,   503,  3286,   429,  3288,  3349,   153,  3261,
     506,   336,   451,  2907,   451,   312,   174,   125,  3349,   429,
     125,   429,  3243,   429,   429,   327,  4264,  4660,   325,   429,
     114,   114,   323,   384,   429,  3512,  3513,  3514,  3515,  3260,
     429,  3243,  3324,   429,   506,   429,   429,  4416,   429,   323,
    3243,  2945,   472,  4643,   268,  3337,  3338,  4650,  3260,  4652,
    4644,   503,   503,   503,   108,   107,   469,  3260,    97,  3351,
    2964,   211,   460,  2967,  1996,   309,   180,  1999,   503,   451,
     291,   463,   462,   319,   309,  3367,   108,   222,   490,   491,
     492,   108,   494,   495,   496,   497,   498,   499,   274,  3381,
    3475,  3475,  3384,   400,   385,   211,   451,   451,  4214,   211,
     211,   211,  4738,   503,   211,    14,   429,  3399,   505,   318,
    3402,   313,   465,   427,   490,   491,   492,  3520,   494,   495,
     496,   497,   498,   499,  3416,   227,   486,  3419,   301,    85,
     301,    88,    88,   506,  3426,   503,   503,   396,   427,   503,
    3432,   429,  3434,   506,   503,  3407,   227,  3439,  3440,   506,
     490,  3443,  3444,  3445,  3446,  3447,  3448,  3449,  3450,  3451,
    3452,   506,   431,   241,  3456,  3457,   504,   241,   264,   506,
     503,   324,  3464,   319,  2106,   506,   451,  3469,   504,   504,
      34,  3473,    10,  3475,   504,  3477,   429,   494,   495,   496,
     497,   498,   499,   429,   384,  3487,   384,   152,  3490,   503,
    3492,   451,   272,   272,   429,   314,   314,   503,  3500,  3501,
    3502,  3503,  4539,   274,   386,  3507,   314,   323,  3510,  3622,
     115,   403,   322,   429,   950,   330,   506,   384,  3520,   429,
     367,   393,   429,   429,   357,   268,  4612,   108,  3530,   268,
     268,   451,  4340,   969,  3475,   971,  3538,   973,  3540,   268,
     451,  4349,   268,   979,   980,   981,   322,   490,  1686,   107,
     501,   503,   501,  3475,   429,   429,   211,   490,  4366,  4367,
     222,   393,  3475,   224,   319,   503,  1002,  1003,  3709,   211,
     393,   210,  4428,   323,  4884,   469,   323,   222,  2220,   497,
     239,   239,   108,  3585,   211,   222,   393,   323,   323,  3591,
     247,   247,   506,   247,  3688,  3597,    96,  3692,  3692,  3694,
    3694,  4428,   268,   506,   472,   506,   298,  4463,   233,   323,
    1336,   506,   125,   318,   419,    85,   504,   504,    88,   504,
    3622,  1347,   274,   227,   504,   504,   227,   504,  1766,   486,
     340,  4458,   429,   504,   504,   105,  4463,   506,   504,   466,
     504,   486,   504,   113,   332,   504,    71,  3649,    90,   119,
     504,   504,   504,   503,    79,    80,   504,   503,    90,   325,
      85,   457,   374,    88,   837,   466,   507,   506,   504,   842,
     504,   506,   285,   143,   323,   326,   490,  2319,   851,   490,
     105,   103,   104,   108,   250,  1121,  3688,   323,   113,   211,
    3692,  3693,  3694,  2335,   119,  2337,   429,  2339,  1836,   472,
     314,  3315,   429,   503,  1140,   878,   429,   258,   503,   882,
     429,   327,   211,   211,   285,   341,   448,  1855,   143,   341,
     893,  3693,   429,   429,  3726,   429,   293,  3729,   293,   429,
     293,   429,   429,   137,   384,  3349,   429,   384,   160,   143,
     429,   384,   429,   384,   429,   211,   429,  3688,  1184,   153,
     396,  3692,   114,  3694,   429,   501,   268,   179,   268,   268,
     268,   268,   268,  1901,  4572,   268,  3688,  3769,   299,   285,
    3692,   369,  3694,   243,  2416,  3688,   180,   247,   182,  3692,
     504,  3694,   504,   173,   504,   438,   504,   490,   210,   506,
     503,   506,  4750,   322,   108,   323,   429,  3769,   268,   269,
     236,   222,   384,   451,   384,   384,   326,   451,   209,  3871,
     506,   209,  3784,  3785,   284,   268,  3818,   501,   243,   203,
     227,  1959,   247,    88,   490,   491,   492,   222,   494,   495,
     496,   497,   498,   499,  4660,   504,   504,  3839,  3840,   309,
     504,  3843,   312,   268,   269,   462,   135,   227,   235,  3911,
     254,   324,    98,   222,   108,   325,   451,   451,   328,   284,
     490,   429,   258,   438,   504,   503,   438,   429,   429,   504,
     490,   503,   506,  3875,  3876,  3877,   504,   506,   222,   503,
    2522,   504,   503,  4087,   309,   131,   504,   312,   384,   504,
    4746,   384,   429,   429,   504,   504,  3510,   504,   144,   143,
     325,   173,   504,   328,   438,   309,  3520,   268,  4021,   268,
     314,   157,  4025,  1349,  1350,   502,  1352,  2559,  3920,  4746,
     503,   272,   469,   472,   222,  2567,   469,   504,   506,   253,
     400,   148,  1368,   506,  3936,   421,   506,   429,    85,   393,
    4081,   232,   227,   503,   227,  3917,   350,   504,   268,   195,
     268,   268,   268,   362,   504,   503,   125,   331,   504,   363,
     504,   506,  1135,  1136,   504,   467,   467,   389,   503,   271,
     271,  3973,   125,   503,   237,   400,   319,  2619,   224,   504,
     504,  3983,  3984,   229,  3986,   490,   429,   227,   469,  3991,
    3992,   143,  4133,   252,  3996,  3997,   490,   419,   438,   314,
    4002,  4003,  2644,   314,  4006,  4067,   429,   211,  2650,   506,
     268,   506,   187,   502,   314,   229,   227,  2155,   451,  4021,
     490,   491,   492,  4025,   494,   495,   496,   497,   498,   499,
     393,   451,  4034,  4127,   504,   457,  4393,  4039,   108,   461,
     444,   198,   469,   503,   227,  2687,   465,   469,   503,  4051,
     255,   469,   326,   227,   503,   503,   362,   456,   406,   504,
     504,   271,   503,   468,   503,   490,   491,   492,   339,   494,
     495,   496,   497,   498,   499,  4077,   504,   363,   504,   325,
     323,   503,   429,  4055,   469,   222,   108,   504,  4090,   503,
     503,   314,   294,   503,   250,   210,   504,   173,  4239,   327,
     381,   381,    71,   503,   490,  4077,  4108,   353,   125,   125,
      79,    80,   503,   329,   451,   307,   323,  4212,  4212,   217,
     354,   193,   421,  1559,   137,  4127,   326,    96,  1564,  1565,
     137,    85,   455,   362,  4136,   456,   506,   108,   384,   227,
     466,  4143,   360,   222,   390,   198,  4148,   393,   252,   108,
     469,   323,   323,  4155,   503,   125,   326,   108,    78,   326,
     380,   185,   504,   503,    84,   504,    94,   449,   503,    89,
     105,   380,   210,   419,   354,   503,   127,   367,  1818,   425,
    2605,  1213,  2929,   152,  1181,    98,  4127,  1565,  2470,  3100,
    4192,  3692,   438,  2529,  3242,  4485,  4212,   117,  4660,  4283,
    4528,  1637,  3864,  1639,  1640,  4127,  4538,  4534,   159,  3025,
    4212,  4257,  4214,  2716,  4127,  4831,  4427,   463,  4883,  4783,
      95,  4782,  1658,    89,  4846,  4683,   101,  3029,  1954,  1665,
    1666,  4284,   145,   202,  3829,  2596,  3688,  1963,  2596,  1916,
    3834,  1967,   162,  3120,  3836,  2591,  3306,  1973,  1974,  4888,
    4951,  4943,  3260,  4255,  3247,  4853,  4465,  3871,  1908,  4761,
    4839,   174,  4468,   214,   187,  1991,   141,  1405,  4381,  3920,
    4620,  4212,  3873,  4386,  2433,  3875,  4389,  4708,   247,  3199,
    4865,  4945,   195,   252,  1062,  1721,  4675,  2929,   208,  2249,
    4212,  2250,  2945,  1729,   245,  2009,   216,  3911,   218,  4212,
    3858,   167,  3595,  4068,  1363,  4307,  2444,   918,  2699,  1077,
     230,   224,  1593,  2946,  4427,   190,   229,  2286,  1611,  1613,
    1610,   187,   197,   274,  2958,   200,  4328,  2952,  2285,   280,
    2269,  2972,  2964,  4412,  3520,  4027,  4599,  1067,  4340,  3596,
    1776,  3485,  4344,  1779,  1780,  4575,  4818,  4349,  1617,  4462,
    3477,  4819,  4822,  2949,  2812,  2813,  2875,  2783,   309,  2817,
    2873,  3591,   275,  2187,  4366,  4367,   623,  2651,  4370,  3346,
      85,  1300,   341,    88,  1947,  2319,  4809,   252,  1629,  4381,
     376,  1623,  1416,   952,  4386,  2294,  4499,  4389,  1158,  2335,
    1138,  2327,  4394,  4395,  1138,  2923,  2328,  3602,   113,  2857,
    2858,  4054,  3044,  3603,   119,  1841,  1539,  4021,  1627,   378,
    3567,  4025,   409,  2339,  2712,  2038,     2,  1349,    -1,  4421,
     371,  4423,    -1,   982,   375,  4427,    -1,    -1,   143,    -1,
     381,    -1,   307,  4405,   309,  4548,    -1,   388,    -1,  2577,
     353,    -1,    -1,    -1,   319,   396,    -1,    -1,   417,    -1,
      -1,    -1,   327,  4067,   405,   375,  4458,    -1,  4520,    -1,
    4462,   336,   413,    -1,    -1,   378,    -1,    -1,    -1,    -1,
      -1,   384,    -1,   442,    -1,  1648,    -1,   390,    -1,    -1,
      -1,   450,    -1,  3125,   453,  4598,  4458,    -1,    -1,    -1,
     410,    -1,   367,    -1,    -1,    -1,   371,  4499,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   419,    -1,   421,  1945,
    3152,    -1,    -1,   464,    -1,    -1,    -1,   468,   469,    -1,
    2246,   396,    -1,    -1,    -1,   438,    -1,    -1,   243,    -1,
      -1,    -1,   247,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4639,  4548,    -1,  4550,    -1,
     463,    -1,    -1,   268,   269,    -1,    -1,    -1,    -1,    -1,
    1996,    -1,    -1,  1999,    -1,    -1,    -1,    -1,    -1,   284,
    4572,  4573,    -1,  4575,    -1,  4577,    -1,    -1,  3220,   454,
      -1,  3223,  3224,    -1,    -1,  3227,    -1,    -1,    -1,    -1,
      -1,    -1,  4594,    -1,    -1,  3237,  4598,   312,    -1,    -1,
    3242,  4603,    -1,    -1,    -1,    -1,  3248,    -1,  2746,    -1,
     325,    -1,  3254,    -1,    -1,    -1,    -1,    -1,    -1,  3261,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3274,    -1,  3276,    -1,    -1,  4639,    -1,    -1,
    4642,   127,    -1,  1816,  4646,  4647,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4901,    -1,  4660,    -1,
      -1,    -1,    -1,  2099,  2100,  3307,    -1,    -1,    -1,    -1,
      -1,  2107,    -1,   159,    -1,  2111,  2112,  4790,  4680,    -1,
      -1,    -1,    -1,    -1,    -1,   400,    -1,  4800,    -1,    -1,
    2126,    -1,  2128,    -1,  3336,  3337,    -1,    -1,  4639,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4708,    -1,    -1,    -1,
      -1,    -1,    -1,  4715,  2150,    -1,  2152,  4639,    -1,    -1,
      -1,  4834,    -1,    -1,    -1,    -1,  4639,    -1,   214,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4738,    -1,    -1,    -1,
    1913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4755,    -1,    -1,  1929,    -1,    -1,   245,
      -1,    -1,    -1,    -1,    -1,    -1,  2202,  4381,    -1,    -1,
      -1,    -1,  4386,    -1,    -1,  4389,   491,   492,    -1,   494,
     495,   496,   497,   498,   499,    -1,    -1,    -1,  4790,    -1,
    4865,  4865,  1965,  4865,   280,    -1,    -1,  4865,  4800,    -1,
      -1,  4896,  4896,  4865,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1988,    -1,    -1,    -1,  4821,
    4822,    -1,  4824,   309,    -1,    -1,  4901,  4901,    -1,  4901,
    2266,    -1,  4834,  4901,  4947,    -1,    -1,    -1,    -1,  4901,
      -1,    -1,    -1,    -1,  3486,    -1,    -1,    -1,  4943,  4943,
      -1,    -1,    -1,    -1,    -1,    -1,  4951,  4951,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4870,    -1,
    4945,  4945,    -1,  4945,    -1,    -1,    -1,  4945,  4880,  2315,
      -1,    -1,    -1,  4945,    -1,   371,    -1,   373,    -1,   375,
      -1,    -1,    -1,    -1,  4896,   381,    -1,  3539,    -1,  2335,
     820,  2337,   388,  2339,   824,    -1,  4520,    -1,    -1,  3047,
     396,    -1,    -1,    -1,    -1,    -1,    -1,   837,    -1,   405,
      -1,    -1,   842,    -1,  4896,    -1,    -1,   413,    -1,    -1,
      -1,   851,    -1,    -1,    -1,    -1,  4938,  2663,    -1,    -1,
      -1,  4943,    -1,    -1,    -1,  4947,    -1,    -1,    -1,  4951,
      -1,    -1,    -1,  2679,  2680,  4896,    -1,  2683,   878,    -1,
      -1,    -1,   882,  2689,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4943,    -1,   893,  4896,    -1,    -1,    -1,   464,  4951,
      -1,    -1,  3440,  4896,  4598,  3443,  3444,  3445,  3446,  3447,
    3448,  3449,  3450,  3451,  3452,    -1,    -1,   917,   108,    -1,
      -1,    -1,  4943,    -1,  3142,    -1,  3144,    -1,    -1,    -1,
    4951,   931,    -1,    -1,    -1,   935,    -1,   127,    -1,    -1,
      -1,  4943,    -1,    -1,    -1,   945,    -1,    -1,    -1,  4951,
    4943,    -1,  2758,    -1,    -1,    -1,    -1,    -1,  4951,   959,
      -1,    -1,    -1,    -1,  3502,  3503,    -1,    -1,    -1,   159,
      -1,  3693,    -1,  2489,    -1,    -1,    -1,    -1,    -1,  3197,
      -1,  2497,    -1,  2499,    -1,    -1,    -1,    -1,  3710,    -1,
      -1,  3713,    -1,  3715,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3221,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3739,  3740,    -1,
      -1,    -1,    -1,   969,   214,   971,    -1,   973,    -1,    -1,
      -1,  3753,    -1,   979,    -1,    -1,    -1,  3759,  3760,  3761,
    3762,  3763,  3764,    -1,    -1,    -1,  1046,  3769,  1048,    -1,
    1050,  3773,    -1,    -1,    -1,   245,  1002,  1003,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  2319,  2583,  1068,    -1,
      -1,    -1,    -1,    -1,    -1,  3797,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   274,    -1,  3808,  3809,  3810,  3811,
     280,    -1,    -1,  2346,    -1,    -1,    -1,    -1,  2351,    -1,
      -1,  2354,    -1,    -1,    -1,    -1,  3324,    -1,    -1,    85,
      -1,    -1,    88,    -1,    -1,    -1,    -1,    -1,    -1,   309,
      -1,    -1,    -1,  2376,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3351,    -1,  1135,  1136,   113,    -1,    -1,
      95,    -1,    -1,   119,    -1,    -1,   101,    -1,    -1,    -1,
    3872,    -1,    -1,    -1,    -1,    -1,    -1,  2410,    -1,    85,
      -1,    -1,    88,    -1,    -1,    -1,    -1,   143,    -1,    -1,
      -1,  4865,    -1,    -1,    -1,  1121,    -1,    -1,    -1,    -1,
      -1,   371,    -1,    -1,  2437,   375,   141,   113,    -1,  1135,
    1136,   381,    -1,   119,  1140,    -1,    -1,    -1,   388,    -1,
      -1,  3419,    -1,    -1,    -1,    -1,   396,  4901,  2461,    -1,
      -1,  3933,  2728,    -1,    -1,   405,    -1,   143,    -1,    -1,
      -1,  3439,    -1,   413,    -1,    -1,    -1,  2480,  3034,    -1,
      -1,  2484,    -1,    -1,    -1,   190,    -1,    -1,  1184,    -1,
      -1,    -1,   197,   829,   830,   200,  3464,   833,   834,  2502,
      -1,  4945,    -1,    -1,    -1,    78,    -1,    -1,    -1,  2512,
      -1,    84,    -1,    -1,   850,    -1,    89,   243,    -1,    -1,
      -1,   247,  2525,    -1,   464,    -1,    -1,    -1,   468,   205,
    3818,  2534,  3500,    -1,   870,    -1,    -1,    -1,   874,    -1,
      -1,    -1,   268,   269,   117,    -1,    -1,   252,    -1,    -1,
      -1,  3107,    -1,  3109,   890,    -1,    -1,    85,   284,    -1,
      88,    -1,    -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,
      -1,   247,    -1,    -1,    -1,    -1,    -1,   105,    -1,    -1,
    1330,    -1,    -1,  4055,  4056,   113,   312,    -1,    -1,   162,
      -1,   119,   268,   269,    -1,  1345,    -1,    -1,    -1,   325,
      -1,    -1,   307,    -1,   309,  4077,    -1,    -1,   284,    -1,
      -1,    -1,    -1,    -1,   319,   143,    -1,    -1,  1368,    -1,
      -1,    -1,   327,    -1,    -1,    85,    -1,    -1,    88,    -1,
      -1,   336,    -1,    -1,    -1,    -1,   312,    -1,    -1,    -1,
    3196,    -1,    -1,    -1,    -1,  3201,    -1,    -1,    -1,   325,
      -1,    -1,    -1,   113,  1404,    -1,    -1,   230,  2924,   119,
      -1,  2927,   367,  2929,    -1,    -1,   371,    -1,    -1,  1419,
      -1,    -1,  1368,    -1,   400,    -1,    -1,    -1,    -1,    -1,
      -1,  1431,    -1,   143,  1434,    -1,    -1,    -1,    -1,    -1,
      -1,   396,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3991,  3992,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,   247,
      -1,    -1,    -1,    -1,   400,    -1,    -1,    -1,  4200,  4201,
      -1,  2734,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     268,   269,  4214,    -1,    -1,    -1,  4218,    -1,  4220,   454,
      -1,  4223,  4224,  2756,    -1,    -1,   284,    -1,    -1,  4231,
    4232,  4233,  4234,  4235,   490,   491,   492,    -1,   494,   495,
     496,   497,   498,   499,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   309,    -1,   243,   312,    -1,    -1,   247,    -1,    -1,
      -1,    -1,    -1,    -1,  3350,    -1,    -1,   325,  3354,  3355,
     328,  3357,   375,  3359,  3360,    -1,  1556,  4279,   268,   269,
      -1,    -1,  3368,    -1,  1564,  1565,    -1,    -1,   494,   495,
     496,   497,   498,   499,   284,  1575,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4306,    -1,    -1,   410,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  3401,    -1,    -1,    -1,   309,
    1186,  1187,   312,    -1,    -1,    -1,    -1,  4329,  4330,  4331,
    4332,    -1,    -1,  1559,    -1,   325,    -1,    -1,  1564,  1565,
      -1,    -1,   400,    -1,    -1,  3843,    -1,  1627,  1628,  1629,
      -1,    -1,    -1,    -1,    -1,    -1,    85,    -1,    -1,    88,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1648,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   113,    -1,    -1,    -1,  1254,    -1,
     119,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1678,    -1,
      -1,    -1,    -1,    -1,    -1,  1685,    -1,    -1,  1274,  1275,
     400,    -1,  1692,    -1,   143,    -1,    -1,    -1,    -1,  1699,
      -1,    -1,  1648,    -1,    -1,  1291,    -1,    -1,    -1,    95,
      -1,    -1,   490,   491,   492,   101,   494,   495,   496,   497,
     498,   499,    -1,    -1,   502,    -1,    -1,    -1,    -1,    -1,
     508,  1731,  3248,    -1,    -1,    -1,  4458,  3253,  3254,    -1,
    1326,  1327,    -1,    -1,    -1,  3261,    -1,    -1,    -1,    -1,
    3003,    -1,    -1,    -1,    -1,   141,    -1,    -1,    -1,    -1,
    4482,    -1,    -1,    -1,  4486,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3289,    -1,  1721,    -1,    -1,    -1,  3997,
     490,   491,   492,  1729,   494,   495,   496,   497,   498,   499,
      -1,    -1,    -1,    -1,   243,    -1,    -1,    -1,   247,    -1,
      -1,    -1,  4340,    -1,   190,    -1,    -1,    -1,    -1,    -1,
      -1,   197,    95,    -1,   200,    -1,  1816,    -1,   101,   268,
     269,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4366,  4367,
    1776,    -1,    -1,  1779,  1780,   284,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   141,    -1,
     309,    -1,    -1,   312,    -1,    -1,   252,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   325,    -1,    -1,   328,
      -1,    -1,    -1,    -1,    -1,  3138,    -1,    -1,    -1,    -1,
    4108,  3407,  3145,    -1,    -1,  1841,  1896,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   190,    -1,    -1,
      -1,    -1,    -1,  1913,   197,    -1,    -1,   200,  4136,    -1,
      -1,   307,    -1,   309,    -1,    -1,    -1,    -1,    -1,  1929,
    4148,    -1,    -1,   319,    -1,    -1,    -1,    -1,  4660,    -1,
      -1,   327,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     336,   400,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3215,    -1,  1964,  1965,    -1,    -1,    -1,   252,
      -1,    -1,    -1,    -1,  4192,  1975,    -1,    -1,    -1,    -1,
      -1,   367,    -1,    -1,    -1,   371,    -1,  1987,  1988,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   820,    -1,    -1,
      -1,   824,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2009,
     396,    -1,    -1,    -1,   837,    -1,    -1,    -1,    -1,   842,
      -1,    -1,    -1,    -1,   307,    -1,   309,    -1,   851,    -1,
      -1,    -1,    85,    -1,  4572,    88,   319,    -1,    -1,    -1,
      -1,   490,   491,   492,   327,   494,   495,   496,   497,   498,
     499,    -1,    -1,   336,    -1,   878,    -1,   506,    -1,   882,
     113,    -1,    -1,    -1,    -1,    -1,   119,    -1,   454,    -1,
     893,    -1,    -1,    -1,    -1,    -1,    -1,    85,    -1,    -1,
      88,    -1,    -1,  3599,   367,    -1,    -1,    -1,   371,    -1,
     143,    -1,  3898,    -1,   917,    -1,    -1,    -1,    -1,    -1,
    3906,  3907,    -1,    -1,    -1,   113,    -1,    -1,   931,    -1,
      -1,   119,   935,   396,  3367,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   945,    -1,    -1,    -1,  4344,    -1,    -1,    -1,
      -1,  3384,    -1,    -1,    -1,   143,   959,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3402,
      -1,    -1,   205,    -1,    -1,    -1,    -1,  2157,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1753,    -1,    -1,
      -1,   454,    -1,    -1,  4896,    -1,    -1,  3693,    -1,    85,
      -1,    -1,    88,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     243,    -1,    -1,  3709,   247,    -1,    -1,   205,    -1,   105,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   113,    -1,    -1,
      -1,    -1,    -1,   119,    -1,   268,   269,  1803,  1804,  1805,
    1806,  4943,    -1,    -1,    -1,  1048,    -1,    -1,    -1,  4951,
      -1,   284,    -1,    -1,    -1,   243,    -1,   143,    -1,   247,
      -1,    -1,    -1,    -1,    -1,  1068,    -1,  2247,    -1,    -1,
      -1,    -1,    -1,  3769,    -1,    -1,  1842,  1843,    -1,   312,
     268,   269,  1848,    -1,    -1,    -1,    -1,    -1,  3784,  3785,
      -1,    -1,   325,    -1,    -1,    -1,   284,  3793,    -1,    -1,
      -1,  3797,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3808,    -1,    -1,    -1,    -1,  2297,    -1,  2299,
    4106,    -1,    -1,    -1,   312,    -1,    -1,    -1,    -1,  1895,
      -1,    -1,  1135,  1136,    -1,    -1,    -1,   325,    95,  2319,
    2266,    -1,    -1,    -1,   101,    -1,    -1,    -1,    -1,    -1,
      -1,  4137,  4138,  1919,  1920,  1921,  1922,   243,    -1,    -1,
      -1,   247,    -1,    -1,    -1,    -1,  2346,   400,    -1,    -1,
    2350,  2351,    -1,    -1,  2354,  4573,    -1,    -1,    -1,    -1,
      -1,    -1,   268,   269,   141,    -1,    -1,    -1,    -1,  2315,
      -1,    -1,    -1,  2319,    -1,    -1,  2376,    -1,   284,    -1,
      -1,    -1,    -1,    -1,    -1,  4603,    89,  4193,  4194,  2335,
      -1,  1977,   400,    -1,    -1,    -1,  3649,    -1,    -1,    -1,
    1986,  3917,    -1,   309,    -1,    -1,   312,  1993,    -1,    -1,
    2410,    -1,    -1,   190,   117,    -1,    -1,    -1,    -1,   325,
     197,  2421,   328,   200,  4642,    -1,    -1,    -1,  4646,  4647,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2437,  2438,    -1,
      -1,   494,   495,   496,   497,   498,   499,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   162,
    2460,  2461,    -1,  2463,    -1,    85,    -1,    -1,    88,    -1,
      -1,    -1,    -1,  3726,    -1,   252,  3729,    -1,    -1,    -1,
    2480,    -1,  2482,    -1,  2484,   105,   494,   495,   496,   497,
     498,   499,    -1,   113,   400,    -1,    -1,    -1,    -1,   119,
      -1,    -1,  2502,    -1,    -1,   208,    -1,  1330,  4314,    -1,
    4316,  4317,  2512,   216,    -1,   218,    -1,    -1,    -1,    -1,
      -1,  4327,  1345,   143,    -1,  2525,    -1,   230,    -1,    -1,
     307,    -1,   309,    -1,  2534,    -1,    -1,    -1,    -1,  4055,
      -1,    -1,   319,  2489,    85,  1368,    -1,    88,    -1,    -1,
     327,  2497,    -1,  2499,    -1,    -1,    -1,    -1,    -1,   336,
      -1,  4077,    -1,    -1,   105,  4081,    -1,    -1,    -1,    -1,
      -1,    -1,   113,    -1,  2160,    -1,    -1,    -1,   119,    -1,
      -1,  1404,    -1,    -1,   490,   491,   492,    -1,   494,   495,
     496,   497,   498,   499,   371,    -1,  1419,    -1,    -1,    -1,
     506,    -1,   143,    -1,    -1,    -1,    -1,    -1,  1431,    -1,
      -1,  1434,    85,    -1,    -1,    88,    -1,  4133,    -1,   396,
      -1,    -1,    -1,   243,    -1,    -1,    -1,   247,    -1,    -1,
    4146,  4147,    -1,    -1,    -1,  4151,  4152,    -1,    -1,    -1,
     113,    -1,    -1,    -1,    -1,    -1,   119,    -1,   268,   269,
    2650,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   284,    -1,    -1,  3920,    -1,    -1,
     143,    -1,    -1,    -1,    -1,    -1,    -1,   454,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2687,    -1,   309,
      -1,    -1,   312,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,   325,   247,    -1,   328,    -1,
      -1,    -1,    -1,    -1,    -1,  4231,  4232,  4233,  4234,  4235,
      -1,    -1,    -1,  4239,    -1,    -1,    -1,   268,   269,    -1,
      -1,    -1,   205,  1556,  2734,    -1,    -1,    -1,    -1,    -1,
      -1,  1564,  1565,   284,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1575,    -1,    -1,    -1,  2756,    -1,    -1,    -1,
    4566,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   309,    -1,
     243,   312,    -1,    -1,   247,    -1,    -1,    -1,    -1,    -1,
     400,    -1,  2728,    -1,   325,    -1,    -1,   328,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   268,   269,    -1,    -1,    -1,
      -1,  2387,  2388,  2389,  1627,  1628,  1629,    -1,  2394,    -1,
    2396,   284,  2398,  2399,    -1,    95,  4622,    -1,    -1,    -1,
      -1,   101,    -1,    -1,    -1,  1648,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2837,    -1,   312,
      -1,    -1,    -1,  2843,    -1,    -1,   126,    -1,    -1,  4655,
      -1,    -1,   325,    -1,    -1,  1678,    -1,    -1,    -1,   400,
      -1,   141,  1685,    -1,    -1,    -1,    -1,    -1,    -1,  1692,
     490,   491,   492,    -1,   494,   4