.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE CONSTRAINT TRIGGER" "" "2011-04-15" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE CONSTRAINT TRIGGER \- define a new constraint trigger

.SH SYNOPSIS
.sp
.nf
CREATE CONSTRAINT TRIGGER \fIname\fR
    AFTER \fIevent\fR [ OR ... ]
    ON \fItable_name\fR
    [ FROM \fIreferenced_table_name\fR ]
    { NOT DEFERRABLE | [ DEFERRABLE ] { INITIALLY IMMEDIATE | INITIALLY DEFERRED } }
    FOR EACH ROW
    EXECUTE PROCEDURE \fIfuncname\fR ( \fIarguments\fR )
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE CONSTRAINT TRIGGER\fR creates a
\fIconstraint trigger\fR. This is the same as a regular trigger
except that the timing of the trigger firing can be adjusted using
SET CONSTRAINTS [\fBset_constraints\fR(l)].
Constraint triggers must be AFTER ROW triggers. They can
be fired either at the end of the statement causing the triggering event,
or at the end of the containing transaction; in the latter case they are
said to be \fIdeferred\fR. A pending deferred-trigger firing can
also be forced to happen immediately by using \fBSET CONSTRAINTS\fR.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the constraint trigger. This is also the name to use
when modifying the trigger's behavior using \fBSET CONSTRAINTS\fR.
The name cannot be schema-qualified \(em the trigger inherits the
schema of its table.
.TP
\fB\fIevent\fB\fR
One of INSERT, UPDATE, or
DELETE; this specifies the event that will fire the
trigger. Multiple events can be specified using OR.
.TP
\fB\fItable_name\fB\fR
The (possibly schema-qualified) name of the table in which
the triggering events occur.
.TP
\fB\fIreferenced_table_name\fB\fR
The (possibly schema-qualified) name of another table referenced by the
constraint. This option is used for foreign-key constraints and is not
recommended for general use.
.TP
\fBDEFERRABLE\fR
.TP
\fBNOT DEFERRABLE\fR
.TP
\fBINITIALLY IMMEDIATE\fR
.TP
\fBINITIALLY DEFERRED\fR
The default timing of the trigger.
See the CREATE TABLE [\fBcreate_table\fR(l)]
documentation for details of these constraint options.
.TP
\fB\fIfuncname\fB\fR
The function to call when the trigger is fired. See CREATE TRIGGER [\fBcreate_trigger\fR(l)] for
details.
.TP
\fB\fIarguments\fB\fR
Optional argument strings to pass to the trigger function. See CREATE TRIGGER [\fBcreate_trigger\fR(l)] for
details.
.SH "COMPATIBILITY"
.PP
\fBCREATE CONSTRAINT TRIGGER\fR is a
PostgreSQL extension of the SQL
standard.
.SH "SEE ALSO"
CREATE TRIGGER [\fBcreate_trigger\fR(l)], DROP TRIGGER [\fBdrop_trigger\fR(l)], SET CONSTRAINTS [\fBset_constraints\fR(l)]
