.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE TEXT SEARCH DICTIONARY" "" "2008-03-15" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TEXT SEARCH DICTIONARY \- define a new text search dictionary

.SH SYNOPSIS
.sp
.nf
CREATE TEXT SEARCH DICTIONARY \fIname\fR (
    TEMPLATE = \fItemplate\fR
    [, \fIoption\fR = \fIvalue\fR [, ... ]]
)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE TEXT SEARCH DICTIONARY\fR creates a new text search
dictionary. A text search dictionary specifies a way of recognizing
interesting or uninteresting words for searching. A dictionary depends
on a text search template, which specifies the functions that actually
perform the work. Typically the dictionary provides some options that
control the detailed behavior of the template's functions.
.PP
If a schema name is given then the text search dictionary is created in the
specified schema. Otherwise it is created in the current schema.
.PP
The user who defines a text search dictionary becomes its owner.
.PP
Refer to in the documentation for further information.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the text search dictionary to be created. The name can be
schema-qualified.
.TP
\fB\fItemplate\fB\fR
The name of the text search template that will define the basic
behavior of this dictionary.
.TP
\fB\fIoption\fB\fR
The name of a template-specific option to be set for this dictionary.
.TP
\fB\fIvalue\fB\fR
The value to use for a template-specific option. If the value
is not a simple identifier or number, it must be quoted (but you can
always quote it, if you wish).
.PP
The options can appear in any order.
.PP
.SH "EXAMPLES"
.PP
The following example command creates a Snowball-based dictionary
with a nonstandard list of stop words.
.sp
.nf
CREATE TEXT SEARCH DICTIONARY my_russian (
    template = snowball,
    language = russian,
    stopwords = myrussian
);
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBCREATE TEXT SEARCH DICTIONARY\fR statement in
the SQL standard.
.SH "SEE ALSO"
ALTER TEXT SEARCH DICTIONARY [\fBalter_text_search_dictionary\fR(l)], DROP TEXT SEARCH DICTIONARY [\fBdrop_text_search_dictionary\fR(l)]
