.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ROLLBACK TO SAVEPOINT" "" "2010-10-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
ROLLBACK TO SAVEPOINT \- roll back to a savepoint

.SH SYNOPSIS
.sp
.nf
ROLLBACK [ WORK | TRANSACTION ] TO [ SAVEPOINT ] \fIsavepoint_name\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
Roll back all commands that were executed after the savepoint was
established. The savepoint remains valid and can be rolled back to
again later, if needed.
.PP
\fBROLLBACK TO SAVEPOINT\fR implicitly destroys all savepoints that
were established after the named savepoint.
.SH "PARAMETERS"
.TP
\fB\fIsavepoint_name\fB\fR
The savepoint to roll back to.
.SH "NOTES"
.PP
Use RELEASE SAVEPOINT [\fBrelease_savepoint\fR(l)] to destroy a savepoint without
discarding the effects of commands executed after it was established.
.PP
Specifying a savepoint name that has not been established is an error.
.PP
Cursors have somewhat non-transactional behavior with respect to
savepoints. Any cursor that is opened inside a savepoint will be closed
when the savepoint is rolled back. If a previously opened cursor is
affected by a 
\fBFETCH\fR command inside a savepoint that is later rolled
back, the cursor position remains at the position that \fBFETCH\fR
left it pointing to (that is, \fBFETCH\fR is not rolled back).
Closing a cursor is not undone by rolling back, either.
A cursor whose execution causes a transaction to abort is put in a
can't-execute state, so while the transaction can be restored using
\fBROLLBACK TO SAVEPOINT\fR, the cursor can no longer be used.
.SH "EXAMPLES"
.PP
To undo the effects of the commands executed after my_savepoint
was established:
.sp
.nf
ROLLBACK TO SAVEPOINT my_savepoint;
.sp
.fi
.PP
Cursor positions are not affected by savepoint rollback:
.sp
.nf
BEGIN;

DECLARE foo CURSOR FOR SELECT 1 UNION SELECT 2;

SAVEPOINT foo;

FETCH 1 FROM foo;
 ?column? 
----------
        1

ROLLBACK TO SAVEPOINT foo;

FETCH 1 FROM foo;
 ?column? 
----------
        2

COMMIT;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The SQL:2003 standard specifies that the key word
SAVEPOINT is mandatory, but PostgreSQL
and Oracle allow it to be omitted. SQL:2003 allows
only WORK, not TRANSACTION, as a noise word
after ROLLBACK. Also, SQL:2003 has an optional clause
AND [ NO ] CHAIN which is not currently supported by
PostgreSQL. Otherwise, this command conforms to
the SQL standard.
.SH "SEE ALSO"
BEGIN [\fBbegin\fR(l)], COMMIT [\fBcommit\fR(l)], RELEASE SAVEPOINT [\fBrelease_savepoint\fR(l)], ROLLBACK [\fBrollback\fR(l)], SAVEPOINT [\fBsavepoint\fR(l)]
