.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SPI_prepare" "" "2009-03-13" "" "PostgreSQL 8.0.21 Documentation"
.SH NAME
SPI_prepare \- prepare a plan for a command, without executing it yet

.SH SYNOPSIS
.sp
.nf
void * SPI_prepare(const char * \fIcommand\fR, int \fInargs\fR, Oid * \fIargtypes\fR)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSPI_prepare\fR creates and returns an execution
plan for the specified command but doesn't execute the command.
This function should only be called from a connected procedure.
.PP
When the same or a similar command is to be executed repeatedly, it
may be advantageous to perform the planning only once.
\fBSPI_prepare\fR converts a command string into an
execution plan that can be executed repeatedly using
\fBSPI_execute_plan\fR.
.PP
A prepared command can be generalized by writing parameters
($1, $2, etc.) in place of what would be
constants in a normal command. The actual values of the parameters
are then specified when \fBSPI_execute_plan\fR is called.
This allows the prepared command to be used over a wider range of
situations than would be possible without parameters.
.PP
The plan returned by \fBSPI_prepare\fR can be used
only in the current invocation of the procedure, since
\fBSPI_finish\fR frees memory allocated for a plan.
But a plan can be saved for longer using the function
\fBSPI_saveplan\fR.
.SH "ARGUMENTS"
.TP
\fBconst char * \fIcommand\fB\fR
command string
.TP
\fBint \fInargs\fB\fR
number of input parameters ($1, $2, etc.)
.TP
\fBOid * \fIargtypes\fB\fR
pointer to an array containing the OIDs of
the data types of the parameters
.SH "RETURN VALUE"
.PP
\fBSPI_prepare\fR returns a non-null pointer to an
execution plan. On error, \fBNULL\fR will be returned,
and SPI_result will be set to one of the same
error codes used by \fBSPI_execute\fR, except that
it is set to \fBSPI_ERROR_ARGUMENT\fR if
\fIcommand\fR is \fBNULL\fR, or if
\fInargs\fR is less than 0, or if \fInargs\fR is
greater than 0 and \fIargtypes\fR is \fBNULL\fR.
.SH "NOTES"
.PP
There is a disadvantage to using parameters: since the planner does
not know the values that will be supplied for the parameters, it
may make worse planning choices than it would make for a normal
command with all constants visible.
