.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SPI_modifytuple" "" "2010-10-01" "" "PostgreSQL 7.4.30 Documentation"
.SH NAME
SPI_modifytuple \- create a row by replacing selected fields of a given row

.SH SYNOPSIS
.sp
.nf
HeapTuple SPI_modifytuple(Relation \fIrel\fR, HeapTuple \fIrow\fR, \fIncols\fR, \fIcolnum\fR, Datum * \fIvalues\fR, const char * \fInulls\fR)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSPI_modifytuple\fR creates a new row by
substituting new values for selected columns, copying the original
row's columns at other positions. The input row is not modified.
.SH "ARGUMENTS"
.TP
\fBRelation \fIrel\fB\fR
Used only as the source of the row descriptor for the row.
(Passing a relation rather than a row descriptor is a
misfeature.)
.TP
\fBHeapTuple \fIrow\fB\fR
row to be modified
.TP
\fBint \fIncols\fB\fR
number of column numbers in the array
\fIcolnum\fR
.TP
\fBint * \fIcolnum\fB\fR
array of the numbers of the columns that are to be changed
(count starts at 1)
.TP
\fBDatum * \fIvalues\fB\fR
new values for the specified columns
.TP
\fBconst char * \fINulls\fB\fR
which new values are null, if any (see \fBSPI_execp\fR for the format)
.SH "RETURN VALUE"
.PP
new row with modifications, allocated in the upper executor
context; \fBNULL\fR only if \fIrow\fR
is \fBNULL\fR
.PP
On error, SPI_result is set as follows:
.TP
\fBSPI_ERROR_ARGUMENT\fR
if \fIrel\fR is \fBNULL\fR, or if
\fIrow\fR is \fBNULL\fR, or if \fIncols\fR
is less than or equal to 0, or if \fIcolnum\fR is
\fBNULL\fR, or if \fIvalues\fR is \fBNULL\fR.
.TP
\fBSPI_ERROR_NOATTRIBUTE\fR
if \fIcolnum\fR contains an invalid column number (less
than or equal to 0 or greater than the number of column in
\fIrow\fR)
.PP
