.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "BEGIN" "" "2009-03-13" "SQL - Language Statements" "SQL Commands"
.SH NAME
BEGIN \- start a transaction block

.SH SYNOPSIS
.sp
.nf
BEGIN [ WORK | TRANSACTION ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBBEGIN\fR initiates a transaction block, that is,
all statements after \fBBEGIN\fR command will be
executed in a single transaction until an explicit COMMIT [\fBcommit\fR(l)] or ROLLBACK [\fBrollback\fR(l)] is given.
By default (without \fBBEGIN\fR),
PostgreSQL executes
transactions in ``autocommit'' mode, that is, each
statement is executed in its own transaction and a commit is
implicitly performed at the end of the statement (if execution was
successful, otherwise a rollback is done).
.PP
Statements are executed more quickly in a transaction block, because
transaction start/commit requires significant CPU and disk
activity. Execution of multiple statements inside a transaction is
also useful to ensure consistency when making several related changes:
other sessions will be unable to see the intermediate states
wherein not all the related updates have been done.
.SH "PARAMETERS"
.TP
\fBWORK\fR
.TP
\fBTRANSACTION\fR
Optional key words. They have no effect.
.SH "NOTES"
.PP
START TRANSACTION [\fBstart_transaction\fR(l)] has the same functionality
as \fBBEGIN\fR.
.PP
Use COMMIT [\fBcommit\fR(l)] or
ROLLBACK [\fBrollback\fR(l)]
to terminate a transaction block.
.PP
Issuing \fBBEGIN\fR when already inside a transaction block will
provoke a warning message. The state of the transaction is not affected.
.SH "EXAMPLES"
.PP
To begin a transaction block:
.sp
.nf
BEGIN;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBBEGIN\fR is a PostgreSQL
language extension. There is no explicit \fBBEGIN\fR
command in the SQL standard; transaction initiation is
always implicit and it terminates either with a
\fBCOMMIT\fR or \fBROLLBACK\fR statement.
.PP
Other relational database systems may offer an autocommit feature
as a convenience.
.PP
Incidentally, the BEGIN key word is used for a
different purpose in embedded SQL. You are advised to be careful
about the transaction semantics when porting database applications.
.SH "SEE ALSO"
COMMIT [\fBcommit\fR(l)], ROLLBACK [\fBrollback\fR(l)]
