.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_TYPE" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
CREATE TYPE \- Defines a new base data type
.SH SYNOPSIS
.sp
.nf
CREATE TYPE \fItypename\fR ( INPUT = \fIinput_function\fR, OUTPUT = \fIoutput_function\fR
      , INTERNALLENGTH = { \fIinternallength\fR | VARIABLE } [ , EXTERNALLENGTH = { \fIexternallength\fR | VARIABLE } ]
    [ , DEFAULT = "\fIdefault\fR" ]
    [ , ELEMENT = \fIelement\fR ] [ , DELIMITER = \fIdelimiter\fR ]
    [ , SEND = \fIsend_function\fR ] [ , RECEIVE = \fIreceive_function\fR ]
    [ , PASSEDBYVALUE ] )
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fItypename\fB\fR
The name of a type to be created.
.TP
\fB\fIinternallength\fB\fR
A literal value, which specifies the internal length of
the new type.
.TP
\fB\fIexternallength\fB\fR
A literal value, which specifies the external length of
the new type.
.TP
\fB\fIinput_function\fB\fR
The name of a function, created by
\fBCREATE FUNCTION\fR, which
converts data from its external form to the type's
internal form.
.TP
\fB\fIoutput_function\fB\fR
The name of a function, created by CREATE FUNCTION, which
converts data from its internal form to a form suitable
for display.
.TP
\fB\fIelement\fB\fR
The type being created is an array; this specifies
the type of the array elements.
.TP
\fB\fIdelimiter\fB\fR
The delimiter character for the array.
.TP
\fB\fIdefault\fB\fR
The default text to be displayed to indicate "data
not present"
.TP
\fB\fIsend_function\fB\fR
The name of a function, created by \fBCREATE FUNCTION\fR, which
converts data of this type into a form suitable for
transmission to another machine.
.TP
\fB\fIreceive_function\fB\fR
The name of a function, created by \fBCREATE FUNCTION\fR, which
converts data of this type from a form suitable for
transmission from another machine to internal form.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE\fR
Message returned if the type is successfully created.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE TYPE\fR allows the user to register a new user data
type with Postgres for use in the current data base. The
user who defines a type becomes its owner.
\fItypename\fR is
the name of the new type and must be unique within the
types defined for this database.
.PP
\fBCREATE TYPE\fR requires the registration of two functions
(using create function) before defining the type. The
representation of a new base type is determined by
\fIinput_function\fR, which
converts the type's external representation to an internal
representation usable by the
operators and functions defined for the type. Naturally,
\fIoutput_function\fR
performs the reverse transformation. Both
the input and output functions must be declared to take
one or two arguments of type "opaque".
.PP
New base data types can be fixed length, in which case
\fIinternallength\fR is a
positive integer, or variable length,
in which case Postgres assumes that the new type has the
same format
as the Postgres-supplied data type, "text".
To indicate that a type is variable-length, set
\fIinternallength\fR
to \fBVARIABLE\fR.
The external representation is similarly specified using the
\fIexternallength\fR
keyword.
.PP
To indicate that a type is an array and to indicate that a
type has array elements, indicate the type of the array
element using the element keyword. For example, to define
an array of 4 byte integers ("int4"), specify
.sp
.nf
ELEMENT = int4
.sp
.fi
.PP
To indicate the delimiter to be used on arrays of this
type, \fIdelimiter\fR
can be
set to a specific character. The default delimiter is the comma
(",").
.PP
A default value is optionally available in case a user
wants some specific bit pattern to mean "data not present."
Specify the default with the DEFAULT keyword.
[Comment: How does the user specify that bit pattern and associate
it with the fact that the data is not present>]
.PP
The optional arguments
\fIsend_function\fR and
\fIreceive_function\fR
are used when the application program requesting Postgres
services resides on a different machine. In this case,
the machine on which Postgres runs may use a format for the data
type different from that used on the remote machine.
In this case it is appropriate to convert data items to a
standard form when sending from the server to the client
and converting from the standard format to the machine
specific format when the server receives the data from the
client. If these functions are not specified, then it is
assumed that the internal format of the type is acceptable
on all relevant machine architectures. For example, single
characters do not have to be converted if passed from
a Sun-4 to a DECstation, but many other types do.
.PP
The optional flag, \fBPASSEDBYVALUE\fR, indicates that operators
and functions which use this data type should be passed an
argument by value rather than by reference. Note that you
may not pass by value types whose internal representation is 
more than four bytes.
.PP
For new base types, a user can define operators, functions
and aggregates using the appropriate facilities described
in this section.
.SS "ARRAY TYPES"
.PP
Two generalized built-in functions, array_in and
array_out, exist for quick creation of variable-length
array types. These functions operate on arrays of any
existing Postgres type.
.SS "LARGE OBJECT TYPES"
.PP
A "regular" Postgres type can only be 8192 bytes in
length. If you need a larger type you must create a Large
Object type. The interface for these types is discussed
at length in the
\fIPostgreSQL Programmer's Guide\fR.
The length of all large object types is always VARIABLE.
.SH "EXAMPLES"
.PP
This command creates the box data type and then uses the
type in a class definition:
.sp
.nf
CREATE TYPE box (INTERNALLENGTH = 8,
    INPUT = my_procedure_1, OUTPUT = my_procedure_2);
CREATE TABLE myboxes (id INT4, description box);
   
.sp
.fi
.PP
This command creates a variable length array type with
integer elements:
.sp
.nf
CREATE TYPE int4array (INPUT = array_in, OUTPUT = array_out,
    INTERNALLENGTH = VARIABLE, ELEMENT = int4);
CREATE TABLE myarrays (id int4, numbers int4array);
   
.sp
.fi
.PP
This command creates a large object type and uses it in
a class definition:
.sp
.nf
CREATE TYPE bigobj (INPUT = lo_filein, OUTPUT = lo_fileout,
    INTERNALLENGTH = VARIABLE);
CREATE TABLE big_objs (id int4, obj bigobj);
   
.sp
.fi
.SS "NOTES"
.PP
Type names cannot begin with the underscore character
("_") and can only be 31 characters long. This is because
Postgres silently creates an array type for each base type
with a name consisting of the base type's name prepended
with an underscore.
.PP
Refer to \fBDROP TYPE\fR to remove an existing type.
.PP
See also \fBCREATE FUNCTION\fR,
\fBCREATE OPERATOR\fR and the chapter on Large Objects
in the \fIPostgreSQL Programmer's Guide\fR.
.SH "COMPATIBILITY"
.SS "SQL3"
.PP
\fBCREATE TYPE\fR is an SQL3 statement.
