##
# copyright 2009, James William Pye
# http://python.projects.postgresql.org
##
"""
py-postgresql is a Python package for using PostgreSQL. This includes low-level
protocol tools, a driver(PG-API and DB-API), and cluster management tools.

If it's not documented in the narratives, `postgresql.documentation.index`, then
the stability of the APIs should *not* be trusted.
"""
__all__ = [
	'__author__',
	'__date__',
	'__project__',
	'__project_id__',
	'__docformat__',
	'__version__',
	'version_info',
	'open',
]

__author__ = "James William Pye <x@jwp.name>"
__date__ = "2009-01-19 21:15:00-07"

__project__ = 'py-postgresql'
__project_id__ = 'http://python.projects.postgresql.org'

__version__ = "0.8.0"
version_info = (0, 8, 0, 'final', 0)

pg_iri = pg_driver = pg_param = None
def open(iri = None):
	"""
	Create a `postgresql.api.Connection` to the server referenced by the given
	`iri`::

		>>> import postgresql
		# General Format:
		>>> db = postgresql.open('pq://user:password@host:port/database')

		# Connect to 'postgres' at localhost.
		>>> db = postgresql.open('localhost/postgres')

	If the URL starts with an '&', a connector will be returned instead of a
	connection.

	(Note: "pq" is the name of the protocol used to communicate with PostgreSQL)
	"""
	global pg_iri, pg_driver, pg_param
	if None in (pg_iri, pg_driver, pg_param):
		from . import iri as pg_iri
		from . import driver as pg_driver
		from . import clientparameters as pg_param

	return_connector = False
	if iri is not None:
		if iri.startswith('&'):
			return_connector = True
			iri = iri[1:]
		iri_params = pg_iri.parse(iri)
		iri_params.pop('path', None)
	else:
		iri_params = {}

	std_params = pg_param.collect(prompt_title = None)
	params = pg_param.normalize(
		list(pg_param.denormalize_parameters(std_params)) + \
		list(pg_param.denormalize_parameters(iri_params))
	)
	# Resolve the password, but never prompt.
	pg_param.resolve_password(params, prompt_title = None)

	C = pg_driver.default.fit(**params)
	if return_connector is True:
		return C
	else:
		c = C()
		c.connect()
		return c

__docformat__ = 'reStructuredText'
