/* $Id: portal.h,v 1.7 2005/12/03 19:44:32 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/portal.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/portal.h,v 1.3 2004/10/17 07:12:17 flaw
 *//*
 * Postgres Portal interface
 */
#ifndef PyPg_call_portal_H
#define PyPg_call_portal_H 0
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPgPortal {
	PyPgCall_HEAD
	Portal			p_portal;
	PyObj				p_name;
	DestReceiver	p_rec;
} * PyPgPortal;

#ifndef PyPg_ci_H
extern PyTypeObject PyPgPortal_Type;
PyObj PyPgPortal_Initialize(PyObj, PyObj, PyObj);
#else
#	define PyPgPortal_Type (*(PyPgCI._PyPgPortal_Type))
#	define PyPgPortal_Initialize(...) \
		(PyPgCI._PyPgPortal_Initialize(__VA_ARGS__))
#endif


#define PyPgPortal_NEW() \
	PyPgPortal_Type.tp_alloc(&PyPgPortal_Type, 0)
#define PyPgPortal_New(Q, I) \
	PyPgPortal_Initialize(PyPgPortal_NEW(), Q, I)

#define PyPgPortal(SELF) ((PyPgPortal) SELF)

#define PyPgPortal_Check(SELF) \
	(PyObject_TypeCheck(SELF, &PyPgPortal_Type))
#define PyPgPortal_CheckExact(SELF) \
	(SELF->ob_type == &PyPgPortal_Type)

#define PyPgPortal_FetchName(SELF) \
	(PyPgPortal(SELF)->p_name)
#define PyPgPortal_FetchPortal(SELF) \
	(PyPgPortal(SELF)->p_portal)

#define PyPgPortal_FetchReceiver(SELF) \
	(&(PyPgPortal(SELF)->p_rec))

#define PyPgPortal_FixName(SELF, N) \
	(PyPgPortal(SELF)->p_name = N)
#define PyPgPortal_FixPortal(SELF, PORT) \
	(PyPgPortal(SELF)->p_portal = PORT)

#define PyPgPortal_FetchQueryString(SELF) \
	(PyPgQuery_FetchString(PyPgCall_FetchFunction(SELF)))
#define PyPgPortal_FetchQuerySTRING(SELF) \
	(PyPgQuery_FetchSTRING(PyPgCall_FetchFunction(SELF)))
#define PyPgPortal_FetchPosition(SELF) \
	(PyPgPortal_FetchPortal(SELF)->portalPos)

#define PyPgPortal_FetchNameSTRING(SELF) \
	PyString_AS_STRING(PyPgPortal_FetchName(SELF))

#define PyPgPortal_FetchMemoryContext(SELF) \
	(PyPgQuery_FetchMemoryContext(PyPgPortal_FetchQuery(SELF)))
#define PyPgPortal_SwitchContext(SELF) \
	MemoryContextSwitchTo(PyPgPortal_FetchMemoryContext(SELF))

#define PyPgPortal_IsClosed(SELF) \
	(PyPgPortal_FetchPortal(SELF) == NULL \
	 || PyPgPortal_FetchPortal(SELF)->status == PORTAL_DONE \
	 || PyPgPortal_FetchPortal(SELF)->status == PORTAL_FAILED)
#define PyPgPortal_AtEnd(SELF) (PyPgPortal_FetchPortal(SELF)->atEnd)
#define PyPgPortal_AtGenesis(SELF) (PyPgPortal_FetchPortal(SELF)->atStart)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_call_portal_H */
/*
 * vim: ts=3:sw=3:noet:
 */
