/* $Id: trigger.c,v 1.7 2005/05/12 19:29:35 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/tfire.c,v 1.2 2005/02/05 19:41:27 flaw
 * imp/src/tfire.c,v 1.2 2004/10/12 08:22:02 flaw
 *//*
 * Implements the Python interface to a Postgres trigger fire
 */
#include <setjmp.h>
#include <postgres.h>
#include <access/heapam.h>
#include <catalog/pg_type.h>
#include <catalog/pg_proc.h>
#include <commands/trigger.h>
#include <nodes/params.h>
#include <nodes/execnodes.h>
#include <parser/parse_type.h>
#include <parser/parse_oper.h>
#include <tcop/dest.h>
#include <tcop/tcopprot.h>
#include <utils/array.h>
#include <utils/catcache.h>
#include <utils/datum.h>
#include <utils/palloc.h>
#include <utils/builtins.h>
#include <utils/syscache.h>
#include <utils/tuplestore.h>
#include <pypg/postgres.h>
#include <pypg/environment.h>

#include <Python.h>
#include <compile.h>
#include <eval.h>
#include <structmember.h>
#include <pypg/python.h>

#include <pypg/externs.h>
#include <pypg/error.h>
#include <pypg/utils.h>
#include <pypg/tupledesc.h>
#include <pypg/heaptuple.h>
#include <pypg/object.h>
#include <pypg/type.h>
#include <pypg/function.h>
#include <pypg/conv.h>
#include <pypg/call.h>
#include <pypg/call/pl.h>
#include <pypg/call/trigger.h>

static PyObj
pull_arguments(int16 tgnargs, char **tgargs)
{
	PyObj args = PyTuple_New(tgnargs);

	if (tgnargs > 0)
	{
		int i;
		for (i = 0; i < tgnargs; ++i)
		{
			PyObj ob = PyString_FromString(tgargs[i]);
			if (ob == NULL) goto fail;
			PyTuple_SET_ITEM(args, i, ob);
		}
	}

	return(args);
fail:
	DECREF(args);
	return(NULL);
}

static PyMemberDef PyPgTriggerPull_Members[] = {
	{"oid", T_OBJECT, offsetof(struct PyPgTriggerPull, tp_oid), RO,
	"the old tuple in the pull"},
	{"old", T_OBJECT, offsetof(struct PyPgTriggerPull, tp_old), RO,
	"the old tuple in the pull"},
	{"new", T_OBJECT, offsetof(struct PyPgTriggerPull, tp_new), RO,
	"the new tuple in the pull"},
	{"event", T_INT, offsetof(struct PyPgTriggerPull, tp_event), RO,
	"event code of the trigger"},
	{NULL}
};

static int
pull_clear(PyObj self)
{
	PyObj ob;

	ob = PyPgTriggerPull_FetchOid(self);
	if (ob != NULL)
	{
		PyPgTriggerPull_FixOid(self, NULL);
		DECREF(ob);
	}

	ob = PyPgTriggerPull_FetchOld(self);
	if (ob != NULL)
	{
		PyPgTriggerPull_FixOld(self, NULL);
		DECREF(ob);
	}

	ob = PyPgTriggerPull_FetchNew(self);
	if (ob != NULL)
	{
		PyPgTriggerPull_FixNew(self, NULL);
		DECREF(ob);
	}

	return(0);
}

static PyObj
pull_call(PyObj self, PyObj args, PyObj kw)
{
	PyObj rob;

	rob = PyPgCall_Type.tp_call(self, args, kw);
	if (rob == NULL || rob == Py_None || rob == Py_True || rob == Py_False)
		return(rob);

	if (PyPgHeapTuple_Check(rob))
	{
		PyObj ot, nt;
		ot = PyPgTriggerPull_FetchOld(self);
		nt = PyPgTriggerPull_FetchNew(self);
		Assert(ot != Py_None || nt != Py_None);

		if ((nt != Py_None && rob == nt) || (ot))
		{
			DECREF(rob);
			rob = Py_True;
			INCREF(rob);
		}
	}
	else
	{
		PyObj nr;
		nr = Py_Call(PyPgCall_FetchExpected(self), rob);
		DECREF(rob);
		rob = nr;
	}

	return(rob);
}

const char PyPgTriggerPull_Doc[] =
"Python interface to a Postgres trigger pull";

PyTypeObject PyPgTriggerPull_Type = {
	PyObject_HEAD_INIT(NULL)
	0,											/* ob_size */
	"Postgres.TriggerPull",				/* tp_name */
	sizeof(struct PyPgTriggerPull),	/* tp_basicsize */
	0,											/* tp_itemsize */
	NULL,										/* tp_dealloc */
	NULL,										/* tp_print */
	NULL,										/* tp_getattr */
	NULL,										/* tp_setattr */
	NULL,										/* tp_compare */
	NULL,										/* tp_repr */
	NULL,										/* tp_as_number */
	NULL,										/* tp_as_sequence */
	NULL,										/* tp_as_mapping */
	NULL,										/* tp_hash */
	pull_call,								/* tp_call */
	NULL,										/* tp_str */
	NULL,										/* tp_getattro */
	NULL,										/* tp_setattro */
	NULL,										/* tp_as_buffer */
	Py_TPFLAGS_DEFAULT,					/* tp_flags */
	(char *) PyPgTriggerPull_Doc,		/* tp_doc */
	NULL,										/* tp_traverse */
	pull_clear,								/* tp_clear */
	NULL,										/* tp_richcompare */
	0,											/* tp_weaklistoffset */
	NULL,										/* tp_iter */
	NULL,										/* tp_iternext */
	NULL,										/* tp_methods */
	PyPgTriggerPull_Members,			/* tp_members */
	NULL,										/* tp_getset */
	&PyPgProceduralCall_Type,			/* tp_base */
	NULL,										/* tp_dict */
	NULL,										/* tp_descr_get */
	NULL,										/* tp_descr_set */
	0,											/* tp_dictoffset */
	NULL,										/* tp_init */
	NULL,										/* tp_alloc */
	NULL,										/* tp_new */
};

PyObj
PyPgTriggerPull_Initialize(PyObj self, FunctionCallInfo fcinfo)
{
	PyObj func, args, kw, expect, old, new;
	TriggerData *tgd;
	Trigger *tg;

	Assert(fcinfo != NULL && CALLED_AS_TRIGGER(fcinfo));
	if (self == NULL) return(NULL);

	tgd = (TriggerData *) fcinfo->context;
	tg = tgd->tg_trigger;

	func = PyPgFunction_FromOid(fcinfo->flinfo->fn_oid);
	if (func == NULL) goto fail;
	PyPgCall_FixFunction(self, func);

	args = pull_arguments(tg->tgnargs, tg->tgargs);
	if (args == NULL) goto fail;
	PyPgCall_FixArguments(self, args);

	kw = PyDict_New();
	if (kw == NULL) goto fail;
	PyPgCall_FixKeywords(self, kw);
	
	expect = PyPgType_FromOid(tgd->tg_relation->rd_rel->reltype);
	if (expect == NULL) goto fail;
	Assert(PyPgType_IsComposite(expect));

	DECREF(expect);
	expect = PyPgType_FetchPyPgTupleDesc(expect);
	INCREF(expect);
	PyPgCall_FixExpected(self, expect);

	if (tgd->tg_trigtuple != NULL)
	{
		old = PyPgHeapTuple_New(expect, tgd->tg_trigtuple);
		if (old == NULL) goto fail;
		PyPgHeapTuple_FixTableOid(old, tgd->tg_relation->rd_id);
	}
	else
	{
		old = Py_None;
		INCREF(old);
	}
	PyPgTriggerPull_FixOld(self, old);

	if (tgd->tg_newtuple != NULL)
	{
		new = PyPgHeapTuple_New(expect, tgd->tg_newtuple);
		if (new == NULL) goto fail;
		PyPgHeapTuple_FixTableOid(new, tgd->tg_relation->rd_id);
	}
	else
	{
		new = Py_None;
		INCREF(new);
	}
	PyPgTriggerPull_FixNew(self, new);

	PyPgCall_FixReturned(self, Py_None);

	return(self);
fail:
	self->ob_type->tp_free(self);
	return(NULL);
}
