/* $Id: savepoint.h,v 1.3 2005/05/12 19:29:35 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/sp.h,v 1.2 2004/12/16 11:22:18 flaw
 * imp/src/sp.h,v 1.1 2004/12/15 13:10:01 flaw
 *//*
 * Postgres Savepoint
 */
#ifndef PyPg_savepoint_H
#define PyPg_savepoint_H 0
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPgSavepoint {
	PyObject_HEAD
	PyObj				sp_string;	/* The savepoint name */
} * PyPgSavepoint;

extern PyTypeObject PyPgSavepoint_Type;

#define PyPgSavepoint_NEW() (PyObj) \
	PyPgSavepoint_Type.tp_alloc(&PyPgSavepoint_Type, 0)

#define PyPgSavepoint(OB) ((PyPgSavepoint) OB)

#define PyPgSavepoint_Check(OB) \
	(PyObject_TypeCheck(OB, &PyPgSavepoint_Type))
#define PyPgSavepoint_CheckExact(OB) \
	(OB->ob_type == &PyPgSavepoint_Type)

#define PyPgSavepoint_FetchString(SELF) \
	(PyPgSavepoint(SELF)->sp_string)
#define PyPgSavepoint_FetchSTRING(SELF) \
	PyString_AS_STRING((PyPgSavepoint_FetchString(SELF)))

#define PyPgSavepoint_FetchTransaction(SELF) \
	PyATTR((PyObj) (SELF->ob_type), "__xact__")

#define PyPgSavepoint_FixString(SELF, OB) (PyPgSavepoint(SELF)->sp_string = OB)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_savepoint_H */
/*
 * vim: ts=3:sw=3:noet:
 */
