/* $Id: relation.h,v 1.3 2005/05/12 19:29:35 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/rel.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/rel.h,v 1.1.1.1 2004/10/04 01:52:56 flaw
 * if/src/rel.h,v 1.15 2004/09/28 15:39:09 flaw
 *//*
 * Postgres Relation Python interface
 */
#ifndef PyPg_relation_H
#define PyPg_relation_H 0
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPgRelation {
	PyObject_HEAD
	Relation rel_relation;
} * PyPgRelation;

extern PyTypeObject PyPgRelation_Type;
PyObj PyPgRelation_Initialize(PyObj, Relation);

#define PyPgRelation_NEW() \
	(PyObj) PyPgRelation_Type.tp_alloc(&PyPgRelation_Type, 0)
#define PyPgRelation_New(R) \
	PyPgRelation_Initialize(PyPgRelation_NEW(), R)

#define PyPgRelation(SELF) ((PyPgRelation) SELF)

#define PyPgRelation_Check(SELF) (PyObject_TypeCheck(SELF, &PyPgRelation_Type))
#define PyPgRelation_CheckExact(SELF) (SELF->ob_type == &PyPgRelation_Type)

#define PyPgRelation_FetchRelation(SELF) \
	(PyPgRelation(SELF)->rel_relation)

#define PyPgRelation_FixRelation(SELF, R) \
	PyPgRelation_FetchRelation(SELF) = R

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_relation_H */
/*
 * vim: ts=3:sw=3:noet:
 */
