/* $Id: error.h,v 1.6 2005/07/01 08:20:09 jwp Exp $
 *
 * Copyright 2005, PostgresPy Project.
 * http://python.projects.postgresql.org
 *
 *//*
 * be/src/error.h,v 1.1.1.1 2004/12/16 00:32:18 flaw
 * imp/src/error.h,v 1.3 2004/12/15 05:02:45 flaw
 * if/src/error.h,v 1.4 2004/09/28 15:34:07 flaw
 *//*
 * Postgres error Python exception
 */
#ifndef PyPg_error_H
#define PyPg_error_H 0
#ifdef __cplusplus
extern "C" {
#endif

PyObj PyExc_FromERRCODE(int);
#if PG_FEATURE_ERRORDATA
PyObj PyErr_FromErrorData(ErrorData *);
#endif
void PyErr_SetPgError(void);
void PG_ThrowPyExc(void);
PyObj PyPgError_Initialize(void);

#define PYPG_CATCH_END(CATCH_CODE) \
PG_CATCH(); \
PyErr_SetPgError(); \
CATCH_CODE; \
PG_END_TRY()

#define PgError_TRAP(_CODE_) \
PG_TRY(); \
_CODE_; \
PG_CATCH(); \
PyErr_SetPgError(); \
PG_END_TRY()

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_error_H */
/*
 * vim: ts=3:sw=3:noet:
 */
