#!/bin/sh

#############
## Purpose ##
#############

# This script is used for running Bison & Flex because it does some more
# processing by replacing an include in Flex & Bison generated source files
# and by moving Bison includes to the include directory.

#############
## Options ##
#############

# Directory containing pgScript includes (relative to the lib directory)
INCLUDEDIR="include/pgscript"
# Directory containing pgScript sources (relative to the lib directory)
SOURCEDIR="pgscript"
# Headers generated by Bison that need to be moved to $INCLUDEDIR
FILESTOMOVE=( "location.hh" "parser.tab.hh" "position.hh" "stack.hh" )

# Flex destination
LEXER="pgscript/lex.pgs.cc"
# A temporary file
AUX="auxfile"
# Bison destination
PARSER="pgscript/parser.tab.cc"

##################
## Main program ##
##################

echo "Runs Flex and Bison and processes the output files."
echo "Usage: $0"
echo ""

THISDIR=`dirname $0`
PREVDIR="$PWD"

echo -n "cd $THISDIR... "
cd "$THISDIR"
echo "done"
echo ""

# Generate Bison file
echo -n "+ Generating Bison output... "
bison -o"$PARSER" "${SOURCEDIR}/pgsParser.yy"
echo "done"

# Generate Flex file
echo -n "+ Generating Flex output... "
flex -o"$LEXER" "${SOURCEDIR}/pgsScanner.ll"
echo "done"

# Add pgAdmin3.h include at the beginning
# Change <FlexLexer.h> to "pgscript/FlexLexer.h"
echo -n "+ Processing Flex output... "
cat "$LEXER" | awk 'BEGIN {print "#include \"pgAdmin3.h\"\n\n"}{print $0}' \
	| sed -e 's/<FlexLexer\.h>/"pgscript\/FlexLexer\.h"/g' > "$AUX"
rm "$LEXER"
mv "$AUX" "$LEXER"
echo "done"

# Add pgAdmin3.h include at the beginning & a pragma
# Change "parser.tab.hh" to "pgscript/parser.tab.hh"
echo -n "+ Processing Bison output... "
cat "$PARSER" | awk 'BEGIN {print "#include \"pgAdmin3.h\"\n#if _MSC_VER > 1000\n#pragma warning(disable: 4800)\n#endif\n"}{print $0}' | \
	sed -e 's/"parser.tab.hh"/"pgscript\/parser\.tab\.hh"/g' > "$AUX"
rm "$PARSER"
mv "$AUX" "$PARSER"
echo "done"

# Move Bison include files to the include directory
echo + "Moving Bison header files... "
for file in ${FILESTOMOVE[@]}
do
	echo "    + mv ${SOURCEDIR}/$file ${INCLUDEDIR}/$file"
	mv "${SOURCEDIR}/$file" "${INCLUDEDIR}/$file"
done
echo "... done"

echo ""
echo -n "cd $PREVDIR... "
cd "$PREVDIR"
echo "done"
