#!/bin/sh

#############
## Purpose ##
#############

# Deletes useless and generated files. See options to choose what files must
# be deleted.

#############
## Options ##
#############

# Files to delete in the whole tree of directories (recursive deletes)
RECURSIVE_DELETES=( "Makefile" "Makefile.in" )
# Folders to explore concerned by FOLDER_DELETES & FILE_DELETES
# Relative to the project directory
EXPLORE_FOLDERS=( "." "./doc" "./lib" "./src" "./test" "./lib/include/pgscript" )
# Folders to delete in each $EXPLORE_FOLDERS
FOLDER_DELETES=( "autom4te.cache" ".deps" )
# Files to delete in each $EXPLORE_FOLDERS
FILE_DELETES=( "aclocal.m4" "stamp-h1" "config.h" "config.h.in*" "config.log" \
	"config.status" "configure" "depcomp" "install-sh" "missing" \
	"mkinstalldirs" "*.exe" "*.exe.stackdump" "*.a" "*.o" "*.html" "*.1" )

##################
## Main program ##
##################

echo "Deletes generated files by autogen & doc/generate."
echo "Usage: $0"
echo ""

THISDIR=`dirname $0`
PREVDIR="$PWD"

echo -n "cd $THISDIR... "
cd "$THISDIR"
echo "done"
echo ""

for file in ${RECURSIVE_DELETES[@]}
do
	for src in `find ./ -name "$file"`; do
		rm -vf "$src"
	done
done

echo ""

for dir in ${EXPLORE_FOLDERS[@]}
do	
	echo "Entering $dir"
	cd "$dir"
	
	for file in ${FOLDER_DELETES[@]}
	do
		rm -rvf "$file"
	done
	
	for file in ${FILE_DELETES[@]}
	do
		rm -vf "$file"
	done
	
	echo "Leaving $dir"
	cd -
	echo ""
done

echo -n "cd $PREVDIR... "
cd "$PREVDIR"
echo "done"
