/************************************************************************
 *                                                                      *
 * ODBC Simple Wrapper V2.0                                             *
 * Copyright (C) 2009 Claudio Rocchini                                  *
 * Istituto Geografico Militare Italiano                                *
 * web:   www.igmi.org                                                  *
 * email: ad2prod@geomil.esercito.difesa.it                             *
 *                                                                      *
 * This program is free software: you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the  Free Software Foundation, either  version 3 of the  License, or *
 * any later version.                                                   *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without  even the implied warranty of    *
 *   MERCHANTABILITY or  FITNESS  FOR A PARTICULAR PURPOSE.  See the    *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program.  If not, see <http://www.gnu.org/licenses/> *
 *                                                                      *
 ************************************************************************/


inline Environment::Environment()
{
	handle = 0;
	status = ::SQLAllocHandle(SQL_HANDLE_ENV,SQL_NULL_HANDLE,&handle);
	if(handle)
		SQLSetEnvAttr(handle,SQL_ATTR_ODBC_VERSION,SQLPOINTER(SQL_OV_ODBC3),0);
}


inline Environment::~Environment()
{
	if(handle)
		::SQLFreeHandle(SQL_HANDLE_ENV,handle);
}


inline SQLHENV Environment::get_handle() const
{
	return handle;
}


inline SQLRETURN Environment::get_status() const
{
	return status;
}


inline bool Environment::set_attrib( SQLINTEGER attrib, int value )
{
	return ::SQLSetEnvAttr(handle,attrib,SQLPOINTER(value),0)!=SQL_ERROR;
}


inline bool Environment::set_attrib( SQLINTEGER attrib, char * value )
{
	return ::SQLSetEnvAttr(handle,attrib,value,strlen(value))!=SQL_ERROR;
}


inline Connection::Connection( const Environment & env )
{
	handle = 0;
	status = ::SQLAllocHandle(SQL_HANDLE_DBC,env.get_handle(),&handle);
	connected = false;
	envp = &env;
}


inline Connection::~Connection()
{
	if(connected)
		disconnect();
	if(handle)
		::SQLFreeHandle(SQL_HANDLE_DBC,handle);
}


inline SQLHENV Connection::get_handle() const
{
	return handle;
}


inline SQLRETURN Connection::get_status() const
{
	return status;
}


inline bool Connection::is_connected() const
{
	return connected;
}


inline void Connection::disconnect()
{
	SQLDisconnect(handle);
	connected = false;
}


inline bool Connection::set_attrib( SQLINTEGER attrib, int value )
{
	return ::SQLSetConnectAttr(handle,attrib,SQLPOINTER(value),0)!=SQL_ERROR;
}


inline bool Connection::set_attrib( SQLINTEGER attrib, char * value )
{
	return ::SQLSetConnectAttr(handle,attrib,value,strlen(value))!=SQL_ERROR;
}


inline Statement::Statement( const Connection & con )
{
	status = ::SQLAllocHandle(SQL_HANDLE_STMT,con.get_handle(),&handle);
}


inline Statement::~Statement()
{
	if(handle)
		::SQLFreeHandle(SQL_HANDLE_STMT,handle);
}


inline SQLHENV Statement::get_handle() const
{
	return handle;
}


inline SQLRETURN Statement::get_status() const
{
	return status;
}


inline bool Statement::set_attrib( SQLINTEGER attrib, int value )
{
	return ::SQLSetStmtAttr(handle,attrib,SQLPOINTER(value),0)!=SQL_ERROR;
}


inline bool Statement::set_attrib( SQLINTEGER attrib, char * value )
{
	return ::SQLSetStmtAttr(handle,attrib,value,strlen(value))!=SQL_ERROR;
}


inline bool Statement::execute( const char * query )
{
	return ::SQLExecDirect(handle,(unsigned char *)query,SQL_NTS)!=SQL_ERROR;
}


inline int Statement::get_num_cols() const
{
	SQLSMALLINT t = -1;
	::SQLNumResultCols(handle,&t);
	return t;
}


inline bool Statement::describe_col( int num, Column & c) const
{
	const SQLSMALLINT bsize = 256;
	char buff[bsize];
	SQLSMALLINT blength = 0;

	SQLRETURN r = ::SQLDescribeCol(handle,num,(unsigned char *)buff,bsize,
		&blength,&(c.type),&(c.size),&(c.decimal),&(c.nullable));
	if(r==SQL_ERROR) return false;
	buff[blength] = 0;
	c.name = buff;
	return true;
}


inline void Statement::close_cursor()
{
	::SQLCloseCursor(handle);
}


inline SQLRETURN Statement::fetch()
{
	return ::SQLFetch(handle);
}


inline bool Statement::bind( int num_col, long & data )
{
	return ::SQLBindCol(handle,num_col,SQL_C_SLONG,&data,sizeof(long),0)!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, long & data, long & lenght )
{
	return ::SQLBindCol(handle,num_col,SQL_C_SLONG,&data,sizeof(long),&lenght)!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, unsigned long & data )
{
	return ::SQLBindCol(handle,num_col,SQL_C_ULONG,&data,sizeof(unsigned long),0)!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, unsigned long & data, long & lenght )
{
	return ::SQLBindCol(handle,num_col,SQL_C_ULONG,&data,sizeof(unsigned long),&lenght)!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, short & data )
{
	return ::SQLBindCol(handle,num_col,SQL_C_SSHORT,&data,sizeof(short),0)!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, short & data, long & lenght )
{
	return ::SQLBindCol(handle,num_col,SQL_C_SSHORT,&data,sizeof(short),&lenght)!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, unsigned short & data )
{
	return ::SQLBindCol(handle,num_col,SQL_C_USHORT,&data,sizeof(unsigned short),0)!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, unsigned short & data, long & lenght )
{
	return ::SQLBindCol(handle,num_col,SQL_C_USHORT,&data,sizeof(unsigned short),&lenght)!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, float & data )
{
	return ::SQLBindCol(handle,num_col,SQL_C_FLOAT,&data,sizeof(float),0)!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, float & data, long & lenght )
{
	return ::SQLBindCol(handle,num_col,SQL_C_FLOAT,&data,sizeof(float),&lenght)!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, double & data )
{
	return ::SQLBindCol(handle,num_col,SQL_C_DOUBLE,&data,sizeof(double),0)!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, double & data, long & lenght )
{
	return ::SQLBindCol(handle,num_col,SQL_C_DOUBLE,&data,sizeof(double),&lenght)!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, char * data, int size, long & lenght )
{
	return ::SQLBindCol(handle,num_col,SQL_C_CHAR,SQLPOINTER(data),size,&lenght )!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, void * data, int size, long & lenght )
{
	return ::SQLBindCol(handle,num_col,SQL_C_BINARY,SQLPOINTER(data),size,&lenght )!=SQL_ERROR;
}


inline bool Statement::bind( int num_col, TIMESTAMP_STRUCT & tm, long & lenght )
{
	return ::SQLBindCol(handle,num_col,SQL_C_TYPE_TIMESTAMP,&tm,sizeof(TIMESTAMP_STRUCT),&lenght )!=SQL_ERROR;
}


inline bool Statement::cancel()
{
	return ::SQLCancel(handle)!=SQL_ERROR;
}


inline bool Statement::unbind()
{
	return ::SQLFreeStmt(handle,SQL_UNBIND)!=SQL_ERROR;
}

