/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.base;

import com.microsoft.jdbc.base.BaseEscapeTranslator;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.base.BaseSQLEscapeProcessor;
import com.microsoft.jdbc.base.BaseSQLFromSpecificationGenerator;
import com.microsoft.jdbc.base.BaseSQLListManipulator;
import com.microsoft.jdbc.base.BaseSQLListPartManipulator;
import com.microsoft.jdbc.base.BaseSQLParameterProcessor;
import com.microsoft.jdbc.base.BaseSQLParenExpListManipulator;
import com.microsoft.jdbc.base.BaseSQLParser;
import com.microsoft.jdbc.base.BaseSQLParser_Full;
import com.microsoft.jdbc.base.BaseSQLParser_ParametersAndEscapes;
import com.microsoft.jdbc.base.BaseSQLParser_PassThrough;
import com.microsoft.jdbc.base.BaseSQLStringGenerator;
import com.microsoft.jdbc.base.BaseSQLTreeNode;
import com.microsoft.jdbc.base.BaseSQLTreeNodeSearch;
import com.microsoft.jdbc.base.BaseSQLTreePreOrderTraverser;
import java.sql.SQLException;
import java.util.Vector;

public final class BaseSQL {
    private static String footprint = "$Revision:   1.40.1.0  $";
    public static final int PROCESS_NONE = 0;
    public static final int PROCESS_PARAMS = 1;
    public static final int PROCESS_ESCAPES = 2;
    public static final int PROCESS_FULL = 4;
    public static final int SQL_UNKNOWN = 0;
    public static final int SQL_DML_SELECT = 1;
    public static final int SQL_DDL_CREATE_TABLE = 2;
    public static final int SQL_DML_CALL = 3;
    private String originalSQL;
    BaseEscapeTranslator escapeTranslator;
    private int processLevel;
    private char quote;
    private int type;
    private BaseSQLTreeNode treeRoot;
    private Vector createTableColumnSpecificationNodes;
    private BaseSQLListPartManipulator selectListManipulator;
    private boolean hasEscape = false;
    private boolean firstEscapeWasCall = false;
    private boolean hasParameter = false;
    private boolean firstThingWasEscape = false;
    private int parameterCount = -1;
    private boolean isBatch = false;
    private Vector originalSQLs;
    private int currentBatch = 0;
    private BaseExceptions exceptions;

    public BaseSQL(char c, BaseEscapeTranslator baseEscapeTranslator, BaseExceptions baseExceptions) throws SQLException {
        this.quote = c;
        this.escapeTranslator = baseEscapeTranslator;
        this.exceptions = baseExceptions;
        this.isBatch = true;
    }

    public BaseSQL(String string, int n, char c, BaseEscapeTranslator baseEscapeTranslator, BaseExceptions baseExceptions) throws SQLException {
        this.originalSQL = string;
        this.processLevel = n;
        this.quote = c;
        this.escapeTranslator = baseEscapeTranslator;
        this.exceptions = baseExceptions;
        this.processSQL();
    }

    public void addToBatch(String string, int n) {
        if (this.originalSQLs == null) {
            this.originalSQLs = new Vector();
        }
        BaseBatchSubStatement baseBatchSubStatement = new BaseBatchSubStatement();
        baseBatchSubStatement.originalSQL = string;
        baseBatchSubStatement.processLevel = n;
        this.originalSQLs.addElement(baseBatchSubStatement);
    }

    public int batchSize() {
        return this.originalSQLs.size();
    }

    private void buildSQLTree() throws SQLException {
        BaseSQLParser baseSQLParser = null;
        int n = 0;
        this.hasParameter = this.containsParameterMarker();
        this.hasEscape = this.containsEscape();
        if ((this.processLevel & 4) != 0) {
            n = 4;
        } else if (false) {
            if (this.hasParameter) {
                n = 1;
            }
        } else {
            n = (this.processLevel & 1) != 0 && this.hasParameter || (this.processLevel & 2) != 0 && this.hasEscape ? 1 : 0;
        }
        baseSQLParser = n == 0 ? new BaseSQLParser_PassThrough() : (n == 1 ? new BaseSQLParser_ParametersAndEscapes() : new BaseSQLParser_Full());
        this.treeRoot = ((BaseSQLParser)baseSQLParser).parse(this.originalSQL, '\"');
    }

    public void clearBatch() {
        this.originalSQLs.setSize(0);
        this.currentBatch = 0;
    }

    private boolean containsEscape() {
        return this.originalSQL.indexOf(123) != -1;
    }

    private boolean containsParameterMarker() {
        return this.originalSQL.indexOf(63) != -1;
    }

    public void dumpTree() throws SQLException {
        BaseSQLTreePreOrderTraverser baseSQLTreePreOrderTraverser = new BaseSQLTreePreOrderTraverser();
        baseSQLTreePreOrderTraverser.setExceptions(this.exceptions);
        baseSQLTreePreOrderTraverser.traverse(this.treeRoot);
    }

    public Vector getCreateTableColumnSpecification(int n) {
        try {
            if (this.createTableColumnSpecificationNodes == null) {
                return null;
            }
            return this.getFirstTopLevelParenExpListElement(this.createTableColumnSpecificationNodes, n);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public int getCreateTableColumnSpecificationCount() {
        if (this.getType() != 2) {
            return -1;
        }
        try {
            this.createTableColumnSpecificationNodes = new Vector();
            return this.getFirstTopLevelParenExpListCount(this.createTableColumnSpecificationNodes);
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public int getFirstTopLevelParenExpListCount(Vector vector) throws SQLException {
        BaseSQLParenExpListManipulator baseSQLParenExpListManipulator = new BaseSQLParenExpListManipulator();
        vector.addElement(baseSQLParenExpListManipulator);
        return baseSQLParenExpListManipulator.countElements(this.treeRoot, this.exceptions);
    }

    public Vector getFirstTopLevelParenExpListElement(Vector vector, int n) throws SQLException {
        BaseSQLListManipulator baseSQLListManipulator = (BaseSQLListManipulator)vector.elementAt(0);
        return baseSQLListManipulator.getElement(n);
    }

    public String getFormatted() {
        try {
            BaseSQLStringGenerator baseSQLStringGenerator = new BaseSQLStringGenerator();
            String string = baseSQLStringGenerator.generateSQL(this.treeRoot, false, this.exceptions);
            return string;
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    public String getOriginal() {
        return this.originalSQL;
    }

    public int getParameterCount() {
        try {
            if (this.parameterCount == -1) {
                BaseSQLParameterProcessor baseSQLParameterProcessor = new BaseSQLParameterProcessor();
                this.parameterCount = baseSQLParameterProcessor.getParameterCount(this.treeRoot, this.exceptions);
            }
            return this.parameterCount;
        }
        catch (SQLException sQLException) {
            return 0;
        }
    }

    public Vector getSelectColumnSpecification(int n) throws SQLException {
        if (this.selectListManipulator == null && this.getSelectColumnSpecificationCount() == -1) {
            return null;
        }
        return this.selectListManipulator.getElement(n);
    }

    public int getSelectColumnSpecificationCount() throws SQLException {
        if (this.getType() != 1) {
            return -1;
        }
        this.selectListManipulator = new BaseSQLListPartManipulator();
        return this.selectListManipulator.countElements(this.treeRoot, this.exceptions);
    }

    public String getSingleTableFromSpecification() throws SQLException {
        String string = null;
        if (this.getType() == 1) {
            BaseSQLFromSpecificationGenerator baseSQLFromSpecificationGenerator = new BaseSQLFromSpecificationGenerator();
            baseSQLFromSpecificationGenerator.generate(this.treeRoot, this.exceptions);
            int n = baseSQLFromSpecificationGenerator.getSpecificationObjectCount();
            if (n > 0) {
                string = "";
                boolean bl = true;
                int n2 = 0;
                while (n2 < n && bl) {
                    String string2 = baseSQLFromSpecificationGenerator.getSpecificationObject(n2);
                    if (n2 % 2 == 1 && !string2.equalsIgnoreCase(".")) {
                        bl = false;
                    }
                    if (string2.equalsIgnoreCase(",") || string2.equalsIgnoreCase("(")) {
                        bl = false;
                        string = null;
                    }
                    if (bl) {
                        string = String.valueOf(string) + string2;
                    }
                    ++n2;
                }
            }
        }
        return string;
    }

    public String getStringPreceedingParameter(int n) {
        try {
            String string = null;
            BaseSQLParameterProcessor baseSQLParameterProcessor = new BaseSQLParameterProcessor();
            BaseSQLTreeNode baseSQLTreeNode = baseSQLParameterProcessor.getParameter(n, this.treeRoot, this.exceptions);
            baseSQLTreeNode = baseSQLTreeNode.getPrevious();
            while (baseSQLTreeNode != null && baseSQLTreeNode.type == 18) {
                baseSQLTreeNode = baseSQLTreeNode.getPrevious();
            }
            if (baseSQLTreeNode != null) {
                string = baseSQLTreeNode.value;
            }
            return string;
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    public int getType() {
        return this.type;
    }

    public String getVerb() {
        try {
            BaseSQLStringGenerator baseSQLStringGenerator = new BaseSQLStringGenerator();
            return baseSQLStringGenerator.generateSQL(this.treeRoot, true, this.exceptions);
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    public boolean hasGroupBy() {
        return this.lookForSelectNodeType(8);
    }

    public boolean hasHaving() {
        return this.lookForSelectNodeType(11);
    }

    public boolean hasSetOperation() {
        return this.lookForSelectNodeType(9);
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    protected boolean lookForSelectNodeType(int n) {
        boolean bl;
        block3: {
            bl = false;
            if (this.getType() != 1) break block3;
            BaseSQLTreeNodeSearch baseSQLTreeNodeSearch = new BaseSQLTreeNodeSearch();
            try {
                if (baseSQLTreeNodeSearch.search(this.treeRoot, n, this.exceptions) != null) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {}
        }
        return bl;
    }

    public boolean nextBatchStatement() throws SQLException {
        boolean bl = false;
        if (this.originalSQLs != null && this.currentBatch < this.originalSQLs.size()) {
            BaseBatchSubStatement baseBatchSubStatement = (BaseBatchSubStatement)this.originalSQLs.elementAt(this.currentBatch);
            this.originalSQL = baseBatchSubStatement.originalSQL;
            this.processLevel = baseBatchSubStatement.processLevel;
            this.processSQL();
            ++this.currentBatch;
        }
        return bl;
    }

    void processSQL() throws SQLException {
        this.buildSQLTree();
        if (this.escapeTranslator != null && this.hasEscape) {
            this.firstThingWasEscape = false;
            this.firstEscapeWasCall = false;
            this.translateEscapes(this.escapeTranslator);
        }
        this.resultType();
    }

    public boolean resultType() throws SQLException {
        boolean bl;
        String string = this.getVerb();
        if (this.firstEscapeWasCall) {
            bl = true;
            this.type = 3;
        } else if (string.equalsIgnoreCase("select")) {
            bl = true;
            this.type = 1;
        } else if (string.equalsIgnoreCase("create table")) {
            bl = false;
            this.type = 2;
        } else {
            bl = false;
            this.type = 0;
        }
        return bl;
    }

    public boolean selectColumnSpecificationContainsValue(Vector vector, String string) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            if (string.equalsIgnoreCase((String)vector.elementAt(n2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setCreateTableColumnSpecification(int n, String string) {
        try {
            if (this.createTableColumnSpecificationNodes != null) {
                this.setFirstTopLevelParenExpListElement(this.createTableColumnSpecificationNodes, n, string);
            }
        }
        catch (SQLException sQLException) {}
    }

    public void setFirstTopLevelParenExpListElement(Vector vector, int n, String string) throws SQLException {
        BaseSQLListManipulator baseSQLListManipulator = (BaseSQLListManipulator)vector.elementAt(0);
        baseSQLListManipulator.setElement(n, String.valueOf(string) + " ", this.exceptions);
    }

    public void setParameter(int n, String string) {
        try {
            BaseSQLParameterProcessor baseSQLParameterProcessor = new BaseSQLParameterProcessor();
            baseSQLParameterProcessor.setParameterValue(this.treeRoot, n, string, this.exceptions);
        }
        catch (SQLException sQLException) {}
    }

    public void setSelectColumnSpecification(int n, String string) throws SQLException {
        if (this.selectListManipulator == null && this.getSelectColumnSpecificationCount() == -1) {
            return;
        }
        this.selectListManipulator.setElement(n, String.valueOf(string) + " ", this.exceptions);
    }

    private void translateEscapes(BaseEscapeTranslator baseEscapeTranslator) throws SQLException {
        BaseSQLEscapeProcessor baseSQLEscapeProcessor = new BaseSQLEscapeProcessor();
        baseSQLEscapeProcessor.processEscapes(this.treeRoot, baseEscapeTranslator, this.exceptions);
        if (baseSQLEscapeProcessor.firstEscape == 7 || baseSQLEscapeProcessor.firstEscape == 6) {
            this.firstEscapeWasCall = true;
        }
    }

    class BaseBatchSubStatement {
        String originalSQL;
        int processLevel;

        BaseBatchSubStatement() {
        }
    }
}

