/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbcx.sqlserver;

import com.microsoft.jdbc.base.BaseClassUtility;
import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseConnectionProperties;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.sqlserver.SQLServerConnection;
import com.microsoft.jdbc.sqlserver.tds.TDSDTCRequest;
import com.microsoft.jdbcx.base.BaseImplXAResource;
import com.microsoft.jdbcx.base.BaseXid;
import com.microsoft.jdbcx.sqlserver.SQLServerDataSource;
import com.microsoft.util.UtilDebug;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class SQLServerImplXAResource
extends BaseImplXAResource {
    private static String footprint = "$Revision:   1.7  $";
    static final short XA_OPEN = 0;
    static final short XA_CLOSE = 1;
    static final short XA_START = 2;
    static final short XA_END = 3;
    static final short XA_PREPARE = 4;
    static final short XA_COMMIT = 5;
    static final short XA_ROLLBACK = 6;
    static final short XA_FORGET = 7;
    static final short XA_RECOVER = 8;
    static final String[] XP_XA = new String[]{"{? = call master..xp_jdbc_open}", "{? = call master..xp_jdbc_close}", "{? = call master..xp_jdbc_start (?, ?, ?)}", "{? = call master..xp_jdbc_end (?, ?)}", "{? = call master..xp_jdbc_prepare (?, ?)}", "{? = call master..xp_jdbc_commit (?, ?)}", "{? = call master..xp_jdbc_rollback (?, ?)}", "{? = call master..xp_jdbc_forget (?, ?)}", "{? = call master..xp_jdbc_recover (?, ?)}"};
    BaseConnectionProperties connectProps;
    int timeout;
    SQLServerDataSource ds;
    SQLServerConnection txnConn;
    int nXids;
    byte[] xidBytes;
    byte[] cookie;
    boolean enlisted = false;
    boolean isServer7 = true;
    TDSDTCRequest request = null;
    SQLException sqlEx = null;

    public SQLServerImplXAResource(SQLServerDataSource sQLServerDataSource, BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.connectProps = baseConnection.getConnectProperties();
        this.ds = sQLServerDataSource;
    }

    protected void close() throws SQLException {
        try {
            try {
                this.executeXaRpc((short)1);
            }
            catch (XAException xAException) {
                throw new SQLException("xa_close failed, returns " + xAException.errorCode);
            }
            Object var2_2 = null;
            this.request = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.request = null;
            this.txnConn.close();
            this.txnConn = null;
            throw throwable;
        }
        this.txnConn.close();
        this.txnConn = null;
    }

    protected void commit(Xid xid, boolean bl) throws XAException {
        int n = 0;
        if (bl) {
            n = 0x40000000;
        }
        this.executeXaRpc((short)5, xid, n);
        if (this.isServer7) {
            this.unenlist();
        }
    }

    protected void end(Xid xid, int n) throws XAException {
        this.executeXaRpc((short)3, xid, n);
        if (!this.isServer7) {
            this.unenlist();
        }
    }

    void enlist() throws XAException {
        if (this.enlisted) {
            return;
        }
        try {
            int n = this.connection.getTransactionIsolation();
            this.request.enlistConnection(this.cookie);
            if (n != 8) {
                this.connection.setTransactionIsolation(n);
            }
            this.enlisted = true;
        }
        catch (SQLException sQLException) {
            XAException xAException = new XAException(sQLException.getMessage());
            xAException.errorCode = -3;
            throw xAException;
        }
    }

    private final int executeXaRpc(short s) throws XAException {
        return this.executeXaRpc(s, null, 0);
    }

    /*
     * Exception decompiling
     */
    private final int executeXaRpc(short var1_1, Xid var2_2, int var3_3) throws XAException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void forget(Xid xid) throws XAException {
        int n = 0;
        this.executeXaRpc((short)7, xid, n);
        if (this.isServer7) {
            this.unenlist();
        }
    }

    protected String getRmIdentification() throws XAException {
        String string = this.connectProps.get("serverName");
        String string2 = this.connectProps.get("portNumber");
        String string3 = this.connectProps.get("databaseName");
        String string4 = String.valueOf(string) + "_" + string2 + "_" + string3;
        return string4;
    }

    protected int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    private byte[] getXidBytes(Xid xid) {
        int n = xid.getFormatId();
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        int n2 = 6 + byArray.length + byArray2.length;
        byte[] byArray3 = new byte[n2];
        byArray3[0] = (byte)(n & 0xFF);
        byArray3[1] = (byte)(n >>> 8 & 0xFF);
        byArray3[2] = (byte)(n >>> 16 & 0xFF);
        byArray3[3] = (byte)(n >>> 24 & 0xFF);
        byArray3[4] = (byte)byArray.length;
        byArray3[5] = (byte)byArray2.length;
        System.arraycopy(byArray, 0, byArray3, 6, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, 6 + byArray.length, byArray2.length);
        return byArray3;
    }

    protected void open() throws SQLException {
        this.txnConn = new SQLServerConnection();
        this.txnConn.open(this.connectProps, new BaseExceptions(BaseClassUtility.getRootName((String)((Object)((Object)this)).toString(), (String)"ImplXAResource")), new UtilDebug());
        this.txnConn.setTransactionIsolation(2112);
        DatabaseMetaData databaseMetaData = this.txnConn.getMetaData();
        String string = databaseMetaData.getDatabaseProductVersion();
        this.isServer7 = false;
        if (string.startsWith("Microsoft SQL Server  7.00")) {
            this.isServer7 = true;
        }
        this.request = ((SQLServerConnection)this.connection).createTDSDTCRequest();
        try {
            this.executeXaRpc((short)0);
        }
        catch (XAException xAException) {
            if (this.sqlEx != null) {
                throw this.sqlEx;
            }
            throw new SQLException(xAException.getMessage());
        }
    }

    protected int prepare(Xid xid) throws XAException {
        int n = 0;
        int n2 = this.executeXaRpc((short)4, xid, n);
        return n2;
    }

    protected Xid[] recover(int n) throws XAException {
        this.executeXaRpc((short)8, null, n);
        int n2 = 0;
        BaseXid[] baseXidArray = new BaseXid[this.nXids];
        int n3 = 0;
        while (n3 < this.nXids) {
            int n4 = (this.xidBytes[n2] & 0xFF) + ((this.xidBytes[n2 + 1] & 0xFF) << 8) + ((this.xidBytes[n2 + 2] & 0xFF) << 16) + ((this.xidBytes[n2 + 3] & 0xFF) << 24);
            byte by = this.xidBytes[n2 += 4];
            byte by2 = this.xidBytes[++n2];
            byte[] byArray = new byte[by];
            byte[] byArray2 = new byte[by2];
            System.arraycopy(this.xidBytes, ++n2, byArray, 0, by);
            System.arraycopy(this.xidBytes, n2 += by, byArray2, 0, by2);
            n2 += by2;
            baseXidArray[n3] = new BaseXid(n4, byArray, byArray2);
            ++n3;
        }
        return baseXidArray;
    }

    protected void rollback(Xid xid) throws XAException {
        int n = 0;
        this.executeXaRpc((short)6, xid, n);
        if (this.isServer7) {
            this.unenlist();
        }
    }

    protected boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        this.timeout = n;
        return false;
    }

    protected void start(Xid xid, int n) throws XAException {
        if (this.enlisted && n == 0) {
            XAException xAException = new XAException("Transaction has to commit/rollback before another transaction starts.");
            xAException.errorCode = -6;
            throw xAException;
        }
        this.executeXaRpc((short)2, xid, n);
        this.enlist();
    }

    void unenlist() throws XAException {
        try {
            this.request.unenlistConnection();
            this.enlisted = false;
        }
        catch (SQLException sQLException) {
            XAException xAException = new XAException(sQLException.getMessage());
            xAException.errorCode = -3;
            throw xAException;
        }
    }

    private final void verifyReturnCode(String string, int n) throws XAException {
        if (n >= 0) {
            return;
        }
        XAException xAException = new XAException(string);
        xAException.errorCode = n;
        throw xAException;
    }
}

