/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import org.postgresql.pljava.ResultSetProvider;

public class MetaDataBooleans
implements ResultSetProvider {
    String[] methodNames;
    Boolean[] methodResults;

    public MetaDataBooleans() throws SQLException {
        Logger logger = Logger.getAnonymousLogger();
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        Method[] methodArray = DatabaseMetaData.class.getMethods();
        class MethodComparator
        implements Comparator {
            MethodComparator() {
            }

            public int compare(Object object, Object object2) {
                return ((Method)object).getName().compareTo(((Method)object2).getName());
            }
        }
        Arrays.sort(methodArray, new MethodComparator());
        Object[] objectArray = new Object[]{};
        Boolean bl = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?> clazz;
            Class<?>[] classArray = methodArray[i].getParameterTypes();
            if (classArray.length > 0 || !(clazz = methodArray[i].getReturnType()).equals(Boolean.TYPE)) continue;
            try {
                bl = (Boolean)methodArray[i].invoke((Object)databaseMetaData, objectArray);
            }
            catch (Exception exception) {
                logger.info("Method: " + methodArray[i].getName() + " => " + exception.getMessage());
            }
            arrayList.add(methodArray[i].getName());
            arrayList2.add(bl);
        }
        this.methodNames = arrayList.toArray(new String[0]);
        this.methodResults = arrayList2.toArray(new Boolean[0]);
    }

    public boolean assignRowValues(ResultSet resultSet, int n) throws SQLException {
        if (n < this.methodNames.length) {
            resultSet.updateString(1, this.methodNames[n]);
            resultSet.updateBoolean(2, (boolean)this.methodResults[n]);
            return true;
        }
        return false;
    }

    public void close() {
    }

    public static ResultSetProvider getDatabaseMetaDataBooleans() throws SQLException {
        try {
            return new MetaDataBooleans();
        }
        catch (SQLException sQLException) {
            throw new SQLException("Error reading DatabaseMetaData", sQLException.getMessage());
        }
    }
}

