/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.postgresql.pljava.ResultSetProvider;

public class UsingProperties
implements ResultSetProvider {
    private static Logger s_logger = Logger.getAnonymousLogger();
    private final Iterator m_propertyIterator;

    public UsingProperties() throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream("example.properties");
        if (inputStream == null) {
            s_logger.fine("example.properties was null");
            this.m_propertyIterator = Collections.EMPTY_SET.iterator();
        } else {
            properties.load(inputStream);
            inputStream.close();
            s_logger.fine("example.properties has " + properties.size() + " entries");
            this.m_propertyIterator = properties.entrySet().iterator();
        }
    }

    public boolean assignRowValues(ResultSet resultSet, int n) throws SQLException {
        if (!this.m_propertyIterator.hasNext()) {
            s_logger.fine("no more rows, returning false");
            return false;
        }
        Map.Entry entry = (Map.Entry)this.m_propertyIterator.next();
        resultSet.updateString(1, (String)entry.getKey());
        resultSet.updateString(2, (String)entry.getValue());
        return true;
    }

    public static ResultSetProvider getProperties() throws SQLException {
        try {
            return new UsingProperties();
        }
        catch (IOException iOException) {
            throw new SQLException("Error reading properties", iOException.getMessage());
        }
    }
}

