/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.util.HashMap;
import org.postgresql.pljava.internal.Backend;

public class Oid {
    private static final HashMap s_class2typeId;
    private final int m_native;

    public Oid(int n) {
        this.m_native = n;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Oid && ((Oid)object).m_native == this.m_native;
    }

    public int hashCode() {
        return this.m_native;
    }

    public static void registerType(Class clazz, Oid oid) {
        s_class2typeId.put(clazz, oid);
    }

    public static Oid forJavaClass(Class clazz) {
        return (Oid)s_class2typeId.get(clazz);
    }

    public static Oid forSqlType(int n) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                Oid oid = Oid._forSqlType(n);
                Object var3_3 = null;
                return oid;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                throw throwable;
            }
        }
    }

    public static Oid getTypeId() {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            try {
                Oid oid = Oid._getTypeId();
                Object var2_2 = null;
                return oid;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
    }

    public String toString() {
        return "OID(" + this.m_native + ')';
    }

    private static native Oid _forSqlType(int var0);

    private static native Oid _getTypeId();

    static {
        try {
            Class.forName("org.postgresql.pljava.jdbc.SPIDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException);
        }
        s_class2typeId = new HashMap();
    }
}

