/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import org.postgresql.pljava.internal.TypeMap;

public class ResultSetField {
    private final String m_name;
    private final int m_oid;
    private final int m_len;
    private final int m_mod;
    private final Class m_class;

    public ResultSetField(String string, int n, int n2, int n3) throws SQLException {
        this.m_name = string.toUpperCase();
        this.m_oid = n;
        this.m_len = n2;
        this.m_mod = n3;
        try {
            this.m_class = Class.forName(TypeMap.getClassNameFromPgOid(n));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(classNotFoundException.getMessage());
        }
    }

    public ResultSetField(String string, int n, int n2) throws SQLException {
        this(string, n, n2, 0);
    }

    public final int getOID() {
        return this.m_oid;
    }

    public final Class getJavaClass() {
        return this.m_class;
    }

    public final boolean canContain(Class clazz) {
        return this.m_class.isAssignableFrom(clazz);
    }

    public final int getMod() {
        return this.m_mod;
    }

    public final String getColumnLabel() {
        return this.m_name;
    }

    public final int getLength() {
        return this.m_len;
    }
}

