<?
/**************************************************
File name:	sqlresults.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	This page is used for ALL SQL STATMENTS sent to PostgreSQL.
		If there's an $action, the SQL statement is build from an include file.
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/

session_start();
include ("$PATH_INCLUDE"."pre.inc.php");
include ($PATH_INCLUDE . "links.inc.php");

// Assign session variables
if (!empty($ntable)) { $table = $ntable; }
if (!empty($nfield)) { $field = $nfield; }
if (!empty($ntrigger)) { $trigger = $ntrigger; }
if (!empty($nview)) { $view = $nview; }
if (!empty($nseq)) { $seq = $nseq; }
if (!empty($nrule)) { $rule = $nrule; }
if (!empty($sql_query)) { $nsql_query = $sql_query; }


// Get $obj

Switch (substr($action,0,2)) {
	case "db":
		$obj = "db";
		break;
	case "tb":
		$obj = "tbl";
		break;
	case "tr":
		$obj = "trig";
		break;
	case "fu":
		$obj = "func";
		break;
	case "ri":
		$obj = "ri";
		break;
	case "id":
		$obj = "idx";
		break;
	case "ru":
		$obj = "rul";
		break;
	case "se":
		$obj = "seq";
		break;
	case "us":
		$obj = "usr";
		break;
	case "gr":
		$obj = "grp";
		break;
	case "cm":
		$obj = "cmt";
		break;
}


// Build SQL only if action is set.  Does not run after confirmpage
if ((isset($action)) && ($action != "adhocsql")) {
	include ($PATH_INCLUDE."buildsql_".$action.".inc.php");
	// set $message
	if (!isset($message)) {
		eval("\$message = \$strMessage_".$action. ";");
}	}

If (isset($obj)) {
	// Declare $nav_confrim 
	$nav_confirm = "navbar_".$obj.".inc.php"; // default navbar  
	// $gotopage
	$gotopage = $obj."list.php";  		 // default gotopage 
}

# change default $gotopage if it is not redirected to *list.php 
Switch ($action) {
	case "tbl_create":	
		$gotopage = "tbl_properties.php";
		break;
	case "tbl_alterfield":
		$gotopage = "tbl_properties.php";
		break;
	case "tbl_insertrow":
		$gotopage = "tbl_insert.php";
		break;
	case "tbl_addfield":
		$gotopage = "tbl_properties.php";
		break;
	case "tbl_rename":
		$gotopage = "tbl_properties.php";
		break;
	case "tbl_addconstraint":
		$gotopage = "tbl_checks.php";
		break;
	case "tbl_vacuum":
		$gotopage = "tbl_properties.php";
		break;
	case "tbl_changeowner":
		if ($table == $view) {$gotopage = "vwlist.php";}
		break;
	case "tbl_browse":
		unset($gotopage);
		break;
	case "db_vacuum":
		$gotopage = "tbllist.php";
		break;
	case "trig_changeevent":
		$gotopage = "trig_properties.php";
		break;
	case "trig_changefunction":
		$gotopage = "trig_properties.php";
		break;
	case "trig_disable":
		$gotopage = "trig_properties.php";
		break;	
	case "tbl_setprivilege":
		$gotopage = "tbl_privilege1.php";
		break;
	case "idx_create":
		if (!empty($ref)) {  # $ref means that index was created on tbl_properties hyperlinks
			$gotopage = "tbl_properties.php";
		}
		break;
	case "seq_reset":
		$gotopage = "seq_properties.php";
		break;
	case "grp_edit":
		$gotopage = "grp_edit.php";
		break;
	case "cmt_create":
		if ($onobject == "DATABASE") { $gotopage = "dblist.php" ;
		} elseif ($onobject == "TABLE") { $gotopage = "tbllist.php";
		} elseif ($onobject == "FUNCTION") { $gotopage = "funclist.php";
		} elseif ($onobject == "INDEX") { $gotopage = "idxlist.php";
		} elseif ($onobject == "SEQUENCE") { $gotopage = "seqlist.php";
		} elseif ($onobject == "RULE") { $gotopage = "rullist.php";
		} elseif ($onobject == "VIEW") { $gotopage = "vwlist.php";
		} elseif ($onobject == "TRIGGER") { $gotopage = "triglist.php";
		} else {
						$gotopage = "tbllist.php";
		}

		break;
	case "adhocsql":
		unset($gotopage);
		break;

#	case "trig_create":	$gotopage = "triglist.php";		break;
#	case "tbl_changeowner":	$gotopage = "tbllist.php";		break;
#	case "db_create":	$gotopage = "dblist.php";		break;
#	case "trig_drop":	$gotopage = "triglist.php";		break;
#	case "func_create":	$gotopage = "funclist.php";		break;
#	case "tbl_addri":	$gotopage = "rilist.php";		break;
#	case "func_edit":	$gotopage = "funclist.php";		break;  
#	case "trig_dropri":	$gotopage = "rilist.php";		break;
#	case "idx_reindex":	$gotopage = "idxlist.php";		break;
#	case "idx_drop": 	$gotopage = "idxlist.php";		break;
#	case "idx_cluster":	$gotopage = "idxlist.php";		break;
#	case "rul_create":	$gotopage = "rullist.php";		break;
#	case "vw_create":	$gotopage = "vwlist.php";		break;
#	case "seq_create":	$gotopage = "seqlist.php";		break;
#	case "seq_drop":	$gotopage = "seqlist.php";		break;
#	case "db_changeowner":	$gotopage = "dblist.php";		break;
#	default:		unset($gotopage);			break;

}  # end of Switch statement

###############################################################

# Get True/False if DROP, ALTER, or DELETE word exists in query
$is_drop_sql_query = eregi("DROP|ALTER|DELETE", $sql_query);

# Get True/False if SELECT exists in query
$is_select_sql_query = eregi("SELECT", $sql_query); 

$is_update_sql_query = eregi("UPDATE", $sql_query); 

// Assign $nsql_query session variable
if (!empty($sql_query)) { $nsql_query = $sql_query; }

// Default message if none
if (!isset($message)) {	$message = "Your SQL statment was:";}

$nsql_query = stripslashes($nsql_query);
$sql_order = stripslashes($sql_order);

// Assign to $sql_get 
$sql_get = $nsql_query.$sql_order;

// Connect and Execute the SQL statement ($sql_get)
include($PATH_INCLUDE."connect_exec.inc.php");


// for addhocquereies
if ( ($num_rows == 0) AND (($action == "tbl_browse") or ($action == "adhocsql")) ) {
	$message = $strEmptyResultSet;
	$gotopage = "tbllist.php";
}

if (isset($gotopage)) {
	RedirectTo($gotopage);
} else {
	// $web_page is template page that is displayed.
	if (!isset($web_page)) {
		$web_page = webpage($PHP_SELF);
	}

	//Display Page	
	include($PATH_TEMPLATE.$cfgTemplate1);


} 

?>
