/*!
@header pgtypes.h

*/

#define PG_TYPE_H

typedef struct
{
	int		size	;
	BOOL	*bits	;
}
	BOOLARRAY	;
	
typedef struct
{
	int				size	;
	unsigned char	*bytes	;
}
	BSTRING	;
	
typedef struct
{
	int		size	;
	char	*text	;
}
	TEXT	;


//	we copy paste part of geo_decls because including the file itself causes too much trouble
//	we only need the struct definitions

	
typedef int int32	;
#define VARHDRSZ                ((int32) sizeof(int32))

typedef	struct
{
	double	x, y	;
}
	POINT	;
	

/*---------------------------------------------------------------------
 * LSEG - A straight line, specified by endpoints.
 *-------------------------------------------------------------------*/
typedef struct
{
	POINT		p[2];

	double		m;				/* precomputed to save time, not in tuple */
} LSEG;


/*---------------------------------------------------------------------
 * PATH - Specified by vertex points.
 *-------------------------------------------------------------------*/
typedef struct
{
	int32		size;			/* XXX varlena */
	int32		npts;
	int32		closed;			/* is this a closed polygon? */
	int32		dummy;			/* padding to make it double align */
	POINT		p[1];			/* variable length array of POINTs */
} PATH;


/*---------------------------------------------------------------------
 * LINE - Specified by its general equation (Ax+By+C=0).
 *		If there is a y-intercept, it is C, which
 *		 incidentally gives a freebie point on the line
 *		 (if B=0, then C is the x-intercept).
 *		Slope m is precalculated to save time; if
 *		 the line is not vertical, m == A.
 *-------------------------------------------------------------------*/
typedef struct
{
	double		A,
				B,
				C;

	double		m;
} LINE;


/*---------------------------------------------------------------------
 * BOX	- Specified by two corner points, which are
 *		 sorted to save calculation time later.
 *-------------------------------------------------------------------*/
typedef struct
{
	POINT		high,
				low;			/* corner POINTs */
} BOX;

/*---------------------------------------------------------------------
 * POLYGON - Specified by an array of doubles defining the points,
 *		keeping the number of points and the bounding box for
 *		speed purposes.
 *-------------------------------------------------------------------*/
typedef struct
{
	int32		size;			/* XXX varlena */
	int32		npts;
	BOX			boundbox;
	POINT		p[1];			/* variable length array of POINTs */
} POLYGON;

/*---------------------------------------------------------------------
 * CIRCLE - Specified by a center point and radius.
 *-------------------------------------------------------------------*/
typedef struct
{
	POINT		center;
	double		radius;
} CIRCLE;

#define Natts_pg_type					17
#define Anum_pg_type_typname			1
#define Anum_pg_type_typowner			2
#define Anum_pg_type_typlen				3
#define Anum_pg_type_typprtlen			4
#define Anum_pg_type_typbyval			5
#define Anum_pg_type_typtype			6
#define Anum_pg_type_typisdefined		7
#define Anum_pg_type_typdelim			8
#define Anum_pg_type_typrelid			9
#define Anum_pg_type_typelem			10
#define Anum_pg_type_typinput			11
#define Anum_pg_type_typoutput			12
#define Anum_pg_type_typreceive			13
#define Anum_pg_type_typsend			14
#define Anum_pg_type_typalign			15
#define Anum_pg_type_typstorage			16
#define Anum_pg_type_typdefault			17
#define BOOLOID			16
#define BYTEAOID		17
#define CHAROID			18
#define NAMEOID			19
#define INT8OID			20
#define INT2OID			21
#define INT2VECTOROID	22
#define INT4OID			23
#define REGPROCOID		24
#define TEXTOID			25
#define OIDOID			26
#define TIDOID		27
#define XIDOID 28
#define CIDOID 29
#define OIDVECTOROID	30
#define POINTOID		600
#define LSEGOID			601
#define PATHOID			602
#define BOXOID			603
#define POLYGONOID		604
#define LINEOID			628
#define FLOAT4OID 700
#define FLOAT8OID 701
#define ABSTIMEOID		702
#define RELTIMEOID		703
#define TINTERVALOID	704
#define UNKNOWNOID		705
#define CIRCLEOID		718
#define CASHOID 790
#define MACADDROID	829
#define INETOID 869
#define CIDROID 650
#define ACLITEMSIZE 8
#define BPCHAROID		1042
#define VARCHAROID		1043
#define DATEOID			1082
#define TIMEOID			1083
#define TIMESTAMPOID	1184
#define INTERVALOID		1186
#define TIMETZOID		1266
#define ZPBITOID	 1560
#define VARBITOID	  1562
#define NUMERICOID		1700

#define	BOOL_ARRAY_OID	1000
#define	BYTEA_ARRAY_OID	1001
#define	CHAR_ARRAY_OID	1002
#define	SHORT_ARRAY_OID	1005
#define	INT_ARRAY_OID	1007
#define	TEXT_ARRAY_OID	1009
#define	OID_ARRAY_OID	1028
#define	STRING_ARRAY_OID	1014
#define	VSTRING_ARRAY_OID	1015
#define	LONGLONG_ARRAY_OID	1016
#define	POINT_ARRAY_OID	1017
#define	LSEG_ARRAY_OID	1018
#define	PATH_ARRAY_OID	1019
#define	BOX_ARRAY_OID	1020
#define	FLOAT_ARRAY_OID	1021
#define	DOUBLE_ARRAY_OID	1022
#define	ABSTIME_ARRAY_OID	1023
#define	RELTIME_ARRAY_OID	1024
#define	TIMEINT_ARRAY_OID	1025
#define	POLYGON_ARRAY_OID	1027
