// PGOleDS.h : Declaration of the CPGOleDS
/*
 *   PostgreSQL OLE DB Provider 
 *   LGPL License  
 *   initial author Marek Mosiewicz (marekmosiewicz@poczta.onet.pl)
 *                  Jotel Poland 
 *
 *	Datasource
 */
#ifndef __CPGOleDS_H_
#define __CPGOleDS_H_
#include "resource.h"       // main symbols
#include "PGOleRS.h"
#include "PGOleSess.h"
#include "pg_props.h"


EXTERN_C const OLEDBDECLSPEC GUID OLEDB_SVC_DSLPropertyPages = {0x51740c02,0x7e8e,0x11d2,{0xa0,0x2d,0x00,0xc0,0x4f,0xa3,0x73,0x48}};

/////////////////////////////////////////////////////////////////////////////
// CDataSource
class ATL_NO_VTABLE CPGOleDS : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CPGOleDS, &CLSID_PGOle>,
	public IDBCreateSessionImpl<CPGOleDS, CPGOleSession>,
	public IDBInitializeImpl<CPGOleDS>,
	public IDBPropertiesImpl<CPGOleDS>,
	public IPersistImpl<CPGOleDS>,
	public IInternalConnectionImpl<CPGOleDS>,
	public IServiceProviderImpl<CPGOleDS>,
	public ISpecifyPropertyPagesImpl<CPGOleDS>
{
public:
	HRESULT FinalConstruct()
	{
		return FInit();
	}
DECLARE_REGISTRY_RESOURCEID(IDR_PGOLE)
BEGIN_PROPSET_MAP(CPGOleDS)
	BEGIN_PROPERTY_SET(DBPROPSET_DATASOURCEINFO)
		PROPERTY_INFO_ENTRY(ACTIVESESSIONS)
		PROPERTY_INFO_ENTRY(DATASOURCEREADONLY)
		PROPERTY_INFO_ENTRY_VALUE(DATASOURCENAME,L"PostgreSQL")
		PROPERTY_INFO_ENTRY(BYREFACCESSORS)
		PROPERTY_INFO_ENTRY(OUTPUTPARAMETERAVAILABILITY)
		PROPERTY_INFO_ENTRY(PROVIDEROLEDBVER)
		PROPERTY_INFO_ENTRY(DSOTHREADMODEL)
		PROPERTY_INFO_ENTRY(SUPPORTEDTXNISOLEVELS)
		PROPERTY_INFO_ENTRY(USERNAME)
		PROPERTY_INFO_ENTRY_VALUE(PROVIDERNAME,L"PostgreSQL OLE DB Provider")
	END_PROPERTY_SET(DBPROPSET_DATASOURCEINFO)
	BEGIN_PROPERTY_SET(DBPROPSET_DBINIT)
		PROPERTY_INFO_ENTRY_VALUE(AUTH_PASSWORD,L"m")
		PROPERTY_INFO_ENTRY(AUTH_PERSIST_SENSITIVE_AUTHINFO)
		PROPERTY_INFO_ENTRY_VALUE(AUTH_USERID,L"Marek")
		PROPERTY_INFO_ENTRY(INIT_DATASOURCE)
		PROPERTY_INFO_ENTRY(INIT_HWND)
		PROPERTY_INFO_ENTRY(INIT_LCID)
		PROPERTY_INFO_ENTRY_VALUE(INIT_LOCATION,L"localhost")
		PROPERTY_INFO_ENTRY(INIT_MODE)
		PROPERTY_INFO_ENTRY(INIT_PROMPT)
		PROPERTY_INFO_ENTRY(INIT_PROVIDERSTRING)
		PROPERTY_INFO_ENTRY(INIT_TIMEOUT)
		PROPERTY_INFO_ENTRY(PG_SERVER_PORT)
		PROPERTY_INFO_ENTRY_VALUE(PG_DATABASE,L"Marek")
	END_PROPERTY_SET(DBPROPSET_DBINIT)
	CHAIN_PROPERTY_SET(CPGOleSession)
	CHAIN_PROPERTY_SET(CPGOleCommand)
END_PROPSET_MAP()

BEGIN_COM_MAP(CPGOleDS)
	COM_INTERFACE_ENTRY(IDBCreateSession)
	COM_INTERFACE_ENTRY(IDBInitialize)
	COM_INTERFACE_ENTRY(IDBProperties)
	COM_INTERFACE_ENTRY(IPersist)
	COM_INTERFACE_ENTRY(IInternalConnection)
	COM_INTERFACE_ENTRY(IServiceProvider)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
END_COM_MAP()
BEGIN_SERVICE_MAP(CPGOleDS)
	SERVICE_ENTRY(OLEDB_SVC_DSLPropertyPages)
END_SERVICE_MAP()

BEGIN_PROP_MAP(CPGOleDS)
	PROP_PAGE(CLSID_ConnProp)
	PROP_PAGE(CLSID_AdvProp)
END_PROP_MAP()

public:
};
#endif //__CPGOleDS_H_
