""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from object import *

class Map(Object):
	"the map class (based on dict)"

	type = 'Map'

	def __init__(self, name = 'Map'):
		Object.__init__(self, name)
		self.map = {}

	def has_key(self, key):
		return self.map.has_key(key)
		
	def __setitem__(self, key, value):
		self.map[key] = value

	def __getitem__(self, key):
		return self.map.get(key)

	def __delitem__(self, key):
		if self.has_key(key):
			del self.map[key]
			
	def __len__(self):
		return len(self.map)

	def __add__(self, map):
		"Non commutative addition. A new map is created"
		new_map = Map()
		for m in (self, map):
			for (key, value) in m.items():
				new_map[key] = value
		return new_map

	def add(self, map):
		for (key, value) in map.items():
			self[key] = value
		return self

	def values(self):
		return self.map.values()

	def keys(self):
		return self.map.keys()

	def items(self):
		return self.map.items()

	def insert_map(self, map):
		for (key, value) in map.items():
			self[key] = value
		return self
	
	def clear(self):
		self.map.clear()
		
	def __repr__(self):
		xmlstr = "<map name='%s'>\n" % self.name
		for (key, value) in self.items():
			xmlstr = "%s<pair>\n" % xmlstr
			xmlstr = "%s<key>%s</key>\n" % (xmlstr, `key`)
			xmlstr = "%s<value>%s</value>\n" % (xmlstr, `value`)			
			xmlstr = "%s</pair>\n" % xmlstr
		return "%s</map>" % xmlstr
