/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A dashboard
 *
 * @author Stephane MANKOWSKI
 */
#include "skgdashboardplugin.h"

#include <KActionCollection>
#include <KStandardAction>
#include <KAboutData>
#include <KGenericFactory>

#include "skgdashboardpluginwidget.h"
#include "skgdashboard_settings.h"
#include "skgtraces.h"

/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY(SKGDashboardPluginFactory, registerPlugin<SKGDashboardPlugin>();)
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN(SKGDashboardPluginFactory("skg_dashboard", "skg_dashboard"))

SKGDashboardPlugin::SKGDashboardPlugin(QWidget* iWidget, QObject* iParent, const QVariantList& iArg) : SKGInterfacePlugin(iParent)
{
    Q_UNUSED(iArg);
    Q_UNUSED(iWidget);
    SKGTRACEINFUNC(10);
}

SKGDashboardPlugin::~SKGDashboardPlugin()
{
    SKGTRACEINFUNC(10);
    m_currentDocument = NULL;
}

bool SKGDashboardPlugin::setupActions(SKGDocument* iDocument, const QStringList& iArgument)
{
    SKGTRACEINFUNC(10);
    Q_UNUSED(iArgument);

    m_currentDocument = iDocument;

    setComponentData(KGlobal::mainComponent());
    setXMLFile("../skg_dashboard/skg_dashboard.rc");

    // Create yours actions here
    return true;
}

SKGTabPage* SKGDashboardPlugin::getWidget()
{
    SKGTRACEINFUNC(10);
    return new SKGDashboardPluginWidget(m_currentDocument);
}

QString SKGDashboardPlugin::title() const
{
    return i18nc("Noun, a summary of your financial situation", "Dashboard");
}

QString SKGDashboardPlugin::icon() const
{
    return "dashboard-show";
}

QString SKGDashboardPlugin::toolTip() const
{
    return i18nc("Noun, a summary of your financial situation", "Dashboard");
}

int SKGDashboardPlugin::getOrder() const
{
    return 8;
}

QStringList SKGDashboardPlugin::tips() const
{
    QStringList output;
    output.push_back(i18nc("Description of a tips", "<p>... the dashboard is there to give you a summary of your situation.</p>"));
    output.push_back(i18nc("Description of a tips", "<p>... the dashboard can be reorganized by drag and drop.</p>"));
    output.push_back(i18nc("Description of a tips", "<p>... some widgets of the dashboard have parameters.</p>"));
    return output;
}

bool SKGDashboardPlugin::isInPagesChooser() const
{
    return true;
}

#include "skgdashboardplugin.moc"
