%module WMatrix


%{
#include <qwmatrix.h>
%}


%include Baseobject.i


class QWMatrix : public BaseObject
{
public:
    QWMatrix();
%name(QWMatrixInit)    QWMatrix( float m11, float m12, float m21, float m22,
	      float dx,	 float dy );

    void	setMatrix( float m11, float m12, float m21, float m22,
			   float dx,  float dy );

    float	m11() const { return _m11; }
    float	m12() const { return _m12; }
    float	m21() const { return _m21; }
    float	m22() const { return _m22; }
    float	dx()  const { return _dx; }
    float	dy()  const { return _dy; }

    void	map( int x, int y, int *tx, int *ty )	      const;
%name(mapFloat)    void	map( float x, float y, float *tx, float *ty ) const;
%name(mapPoint)    QPoint	map( const QPoint & )	const;
%name(mapRect)    QRect	map( const QRect & )	const;
%name(mapPoints)    QPointArray map( const QPointArray & ) const;

    void	reset();

    QWMatrix   &translate( float dx, float dy );
    QWMatrix   &scale( float sx, float sy );
    QWMatrix   &shear( float sh, float sv );
    QWMatrix   &rotate( float a );

    QWMatrix	invert( bool *flag = 0 ) const;
};
