%module Messagebox


%{
#include <qmsgbox.h>
%}


%include Constants.i
%import Dialog.i
%import Pixmap.i


class QMessageBox : public QDialog
{
public:
    enum Icon { NoIcon = 0, Information = 1, Warning = 2, Critical = 3 };

    QMessageBox( QWidget *parent=0, const char *name=0 );
%name(QMessageBoxInit)    QMessageBox( const char *caption, const char *text, Icon icon,
		 int button0, int button1, int button2,
		 QWidget *parent=0, const char *name=0, bool modal=TRUE,
		 unsigned int f=0 );
   ~QMessageBox();

    enum { Ok = 1, Cancel = 2, Yes = 3, No = 4, Abort = 5, Retry = 6,
	   Ignore = 7, ButtonMask = 0x07,
	   Default = 0x100, Escape = 0x200, FlagMask = 0x300 };

    static int information( QWidget *parent, const char *caption,
			    const char *text,
			    int button0, int button1=0, int button2=0 );
%name(informationButtons)    static int information( QWidget *parent, const char *caption,
			    const char *text,
			    const char *button0Text = "OK",
			    const char *button1Text = 0, 
			    const char *button2Text = 0,
			    int defaultButtonNumber = 0,
			    int escapeButtonNumber = -1 );

    static int warning( QWidget *parent, const char *caption,
			const char *text,
			int button0, int button1, int button2=0 );
%name(warningButtons)    static int warning( QWidget *parent, const char *caption,
			const char *text,
			const char *button0Text = "OK",
			const char *button1Text = 0, 
			const char *button2Text = 0,
			int defaultButtonNumber = 0,
			int escapeButtonNumber = -1 );

    static int critical( QWidget *parent, const char *caption,
			 const char *text,
			 int button0, int button1, int button2=0 );
%name(criticalButtons)    static int critical( QWidget *parent, const char *caption,
			 const char *text,
			 const char *button0Text = "OK",
			 const char *button1Text = 0, 
			 const char *button2Text = 0,
			 int defaultButtonNumber = 0,
			 int escapeButtonNumber = -1 );
    
    static void about( QWidget *parent, const char *caption,
		       const char *text );

    static void aboutQt( QWidget *parent, const char *caption=0 );

    const char *text() const;
    void	setText( const char * );

    Icon	icon() const;
    void	setIcon( Icon );

    const QPixmap *iconPixmap() const;
    void	setIconPixmap( const QPixmap & );

    const char *buttonText( int button ) const;
    void	setButtonText( int button, const char * );

    void	adjustSize();

    void	setStyle( GUIStyle );

    static QPixmap standardIcon( Icon icon, GUIStyle style );
};
