%module Menubar


%{
#include "Python.h"
#include "Object.h"
#include "Popupmenu.h"
#include "Menubar.h"
%}


%include Types.i
%include Constants.i
%import Object.i
%import Widget.i
%import Popupmenu.i


class MenuBar : public QFrame
{
public:

    MenuBar(QWidget *parent=0, const char *name=0 );
   ~MenuBar();

    int		heightForWidth(int) const;

    enum	Separator { Never=0, InWindowsStyle=1 };
    Separator 	separator() const;
    void	setSeparator( Separator when );

/*
signals:
    void	activated( int itemId );
    void	highlighted( int itemId );
*/


/* ---- QMenuData ---- */


    unsigned int	count() const;

    int		_insertItem( const char *text,PyObject *slot,int accel=0 );
%name(insertPixmap)    int _insertPixmap( const QPixmap &pixmap,PyObject *slot,int accel=0 );
%name(insertItemPixmap)    int		_insertItemPixmap( const QPixmap &pixmap,const char *text,PyObject *slot,int accel=0 );
 
%name(insertItemAt)   int		insertItem( const char *text, int id=-1, int index=-1 );
%name(popupItemAt)    int		insertItem( const char *text, PopupMenu *popup, int id=-1, int index=-1 );

%name(insertPixmapAt)    int		insertItem( const QPixmap &pixmap, int id=-1, int index=-1 );

%name(popupPixampAt)    int		insertItem( const QPixmap &pixmap, PopupMenu *popup, int id=-1, int index=-1 );
   
%name(insertItemPixmapAt)  int		insertItem( const QPixmap &pixmap, const char *text, int id=-1, int index=-1 );
%name(popupItemPixmapAt)    int		insertItem( const QPixmap &pixmap, const char *text, PopupMenu *popup, int id=-1, int index=-1 );

    void	insertSeparator( int index=-1 );

    void	removeItem( int id )		{ removeItemAt(indexOf(id)); }
    void	removeItemAt( int index );
    void	clear();

    int		accel( int id )		const;
    void	setAccel( int key, int id );

    const char *text( int id )		const;
    QPixmap    *pixmap( int id )	const;

    void	changeItem( const char *text, int id );
%name(changePixmap)    void	changeItem( const QPixmap &pixmap, int id );
%name(changeItemPixmap)    void	changeItem( const QPixmap &pixmap, const char *text, int id );

    bool	isItemEnabled( int id ) const;
    void	setItemEnabled( int id, bool enable );

    bool	isItemChecked( int id ) const;
    void	setItemChecked( int id, bool check );

    int		indexOf( int id )	const;
    int		idAt( int index )	const;
    void	setId( int index, int id );

    void	_connectItem( int id, PyObject *slot);
    void	_disconnectItem( int id, PyObject *slot);
};
