%module Frame


%{
#include "Object.h"
#include "Button.h"
#include <qframe.h>
%}


%include Types.i
%include Constants.i
%import Object.i
%import Widget.i


class QFrame : public QWidget
{
public:
    QFrame( QWidget *parent=0, const char *name=0, int f=0,
	    bool allowLines=TRUE );
    ~QFrame();

    enum { NoFrame  = 0,		
	   Box	    = 0x0001,			
	   Panel    = 0x0002,			
	   WinPanel = 0x0003,	
	   HLine    = 0x0004,	
	   VLine    = 0x0005,
	   MShape   = 0x000f,
	   Plain    = 0x0010,			
	   Raised   = 0x0020,		
	   Sunken   = 0x0030,		
	   MShadow  = 0x00f0 };

    int		frameStyle()	const;
    int		frameShape()	const;
    int		frameShadow()	const;
    void	setFrameStyle( int );

    bool	lineShapesOk()	const;

    int		lineWidth()	const;
    void	setLineWidth( int );

    int		midLineWidth()	const;
    void	setMidLineWidth( int );

    int		frameWidth()	const;
    QRect	frameRect()	const;
    QRect	contentsRect()	const;

};
