#ifndef _BUTTON_H_
#define _BUTTON_H_

#include <Python.h>
#include "qbutton.h"
#include "Baseobject.h"


class Button : public QButton, public BaseObject
{
  Q_OBJECT	

  public:
    Button(QWidget *parent=0, const char *name=0) : QButton(parent,name), BaseObject() {
      connect(this, SIGNAL(pressed()), this, SLOT(sigPressed()));
      connect(this, SIGNAL(released()), this, SLOT(sigReleased()));
      connect(this, SIGNAL(clicked()), this, SLOT(sigClicked()));
      connect(this, SIGNAL(toggled(bool)), this, SLOT(sigToggled(bool)));
    };

protected slots:

    void sigPressed() {
      _emit("pressed", 0);
    };
    
    void sigReleased() {
      _emit("released", 0);
    };
    
    void sigClicked() {
      _emit("clicked", 0);
    };
    
    void sigToggled(bool on) {
       PyObject *arg = Py_BuildValue("(i)",on);
       _emit("toggled", arg);  
       Py_DECREF(arg);
    };
    
};

#endif
