#import copy
import libqtpythonc
from baseobject import *


class ColorPtr(BaseObjectPtr):

    _classname = "Color"

    def __init__(self,this,name=""):
        BaseObjectPtr.__init__(self,name)
    	self.this = this
     	self.thisown = 0

    def __del__(self):
        if self.thisown == 1:
            libqtpythonc.delete_QColor(self.this)

    def isValid(self):
        return libqtpythonc.QColor_isValid(self.this)

    def isDirty(self):
        return libqtpythonc.QColor_isDirty(self.this)

    def setNamedColor(self,name):
        libqtpythonc.QColor_setNamedColor(self.this,name)

    def getRgb(self):
        return (libqtpythonc.QColor_red(self.this),libqtpythonc.QColor_green(self.this),libqtpythonc.QColor_blue(self.this))

    def setRgb(self,rgb):
        libqtpythonc.QColor_setRgb(self.this,rgb[0],rgb[1],rgb[2])

    def getRed(self):
        return libqtpythonc.QColor_red(self.this)

    def setRed(self,r):
        self.setRgb((r, self.getGreen(), self.getBlue()))

    def getGreen(self):
        return libqtpythonc.QColor_green(self.this)

    def setGreen(self,g):
	self.setRgb((self.getRed(), g, self.getBlue()))

    def getBlue(self):
        return libqtpythonc.QColor_blue(self.this)

    def setBlue(self, b):
	self.setRgb((self.getRed(), self.getGreen(), b))

    def getHsv(self):
	return (libqtpythonc.QColor_getH(self.this),libqtpythonc.QColor_getS(self.this),libqtpythonc.QColor_getV(self.this))

    def setHsv(self,hsv):
       libqtpythonc.QColor_setHsv(self.this,hsv[0],hsv[1],hsv[2])

    def light(self,factor=150):
        val = ColorPtr(libqtpythonc.QColor_light(self.this,factor))
        val.thisown = 1
        return val

    def dark(self,factor=200):
        val = ColorPtr(libqtpythonc.QColor_dark(self.this,factor))
        val.thisown = 1
        return val

    def alloc(self):
        return libqtpythonc.QColor_alloc(self.this)

    def pixel(self):
        return libqtpythonc.QColor_pixel(self.this)

    def __repr__(self):
        return "Color instance at %s" % self.this

    # properties

#    _props = copy.copy(BaseObject._properties)
#    _props['rgb'] = (getRgb, setRgb, '(int)')
#    _props['red'] = (getRed, setRed, 'int')
#    _props['green'] = (getGreen, setGreen, 'int')
#    _props['blue'] = (getBlue, setBlue, 'int')
#    _props['hsv'] = (getHsv, setHsv, '(int)')
#    _properties = _props
    

class Color(ColorPtr):
    def __init__(self,name='') :
	ColorPtr.__init__(self,"NULL",name)
        self.this = libqtpythonc.new_QColor()
        self.thisown = 1

def ColorRGB(arg,name='') :
    val = ColorPtr(libqtpythonc.new_QColorRGB(arg[0],arg[1],arg[2]),name)
    val.thisown = 1
    return val

def ColorName(arg0,name='') :
    val = ColorPtr(libqtpythonc.new_QColorName(arg0),name)
    val.thisown = 1
    return val

def ColorCopy(arg0,name='') :
    val = ColorPtr(libqtpythonc.new_QColorCopy(arg0.this),name)
    val.thisown = 1
    return val


#-------------- FUNCTION WRAPPERS ------------------


Color_lazyAlloc = libqtpythonc.QColor_lazyAlloc

Color_setLazyAlloc = libqtpythonc.QColor_setLazyAlloc

Color_maxColors = libqtpythonc.QColor_maxColors

Color_numBitPlanes = libqtpythonc.QColor_numBitPlanes

Color_enterAllocContext = libqtpythonc.QColor_enterAllocContext

Color_leaveAllocContext = libqtpythonc.QColor_leaveAllocContext

Color_currentAllocContext = libqtpythonc.QColor_currentAllocContext

Color_destroyAllocContext = libqtpythonc.QColor_destroyAllocContext


# color constants


black       = ColorRGB((   0,   0,   0 ), "black")
white       = ColorRGB(( 255, 255, 255 ), "white")
darkGray    = ColorRGB(( 128, 128, 128 ), "darkGray")
gray        = ColorRGB(( 160, 160, 164 ), "gray")
lightGray   = ColorRGB(( 192, 192, 192 ), "lightGray")
red         = ColorRGB(( 255,   0,   0 ), "red")
green       = ColorRGB((   0, 255,   0 ), "green")
blue        = ColorRGB((   0,   0, 255 ), "blue")
cyan        = ColorRGB((   0, 255, 255 ), "cyan")
magenta     = ColorRGB(( 255,   0, 255 ), "magenta")
yellow      = ColorRGB(( 255, 255,   0 ), "yellow")
darkRed     = ColorRGB(( 128,   0,   0 ), "darkRed")
darkGreen   = ColorRGB((   0, 128,   0 ), "darkGreen")
darkBlue    = ColorRGB((   0,   0, 128 ), "darkBlue")
darkCyan    = ColorRGB((   0, 128, 128 ), "darkCyan")
darkMagenta = ColorRGB(( 128,   0, 128 ), "darkMagenta")
darkYellow  = ColorRGB(( 128, 128,   0 ), "darkYellow")
