%module KFile


%{
#include "KFile.h"
#include "Object.h"
%}


%include Types.i
%import Dialog.i
%import Widget.i


class _FileBaseDialog : public QDialog
{
public:
    _FileBaseDialog(const char *dirName, const char *filter= 0,
		QWidget *parent= 0, const char *name= 0, 
		bool modal = false, bool acceptURLs = true);
    ~_FileBaseDialog();
    
    QString selectedFile();
    QString dirPath();
    void rereadDir();
    void back();
    void forward();
    void home();
    void cdUp();
    bool dirIsLocal() const { return !acceptUrls; }
    QString selectedFileURL();
//    QStrList selectedFileURLList();
    void setMultiSelection(bool multi= true);
    bool isMultiSelection() const { return false; }

    static QString getDirectory(const char *url, QWidget *parent = 0,  
				const char *name = 0);
/*    QStrList getOpenFileURLList(const char *url= 0,
				const char *filter= 0,
				QWidget *parent= 0,
				const char *name= 0);
    QStrList getSaveFileURLList(const char *url= 0, const char *filter= 0,
				QWidget *parent= 0, const char *name= 0);
*/    void _setDir(const char *name);

/*
signals:
    void fileSelected(const char *);
    void fileHighlighted(const char *);
    void dirEntered(const char *);
    void historyUpdate(bool, bool);
*/
};


class _DirDialog : public _FileBaseDialog
{
public:
    
    _DirDialog(const char *url, QWidget *parent, const char *name);
};


class _FileDialog : public _FileBaseDialog
{
public: 
    _FileDialog(const char *dirName, const char *filter= 0,
		QWidget *parent= 0, const char *name= 0, 
		bool modal = false, bool acceptURLs = true);

    static QString getOpenFileName(const char *dir= 0, const char *filter= 0,
				   QWidget *parent= 0, const char *name= 0);
    static QString getSaveFileName(const char *dir= 0, const char *filter= 0,
				   QWidget *parent= 0, const char *name= 0);
    static QString getOpenFileURL(const char *url= 0, const char *filter= 0,
				  QWidget *parent= 0, const char *name= 0);
    static QString getSaveFileURL(const char *url= 0, const char *filter= 0,
				  QWidget *parent= 0, const char *name= 0);
};
