#ifndef _KSTATUSBAR_H_
#define _KSTATUSBAR_H_

#include <Python.h>
#include <kstatusbar.h>
#include "Baseobject.h"


class _StatusBar : public KStatusBar, public BaseObject
{
  Q_OBJECT
public:
    _StatusBar(QWidget *parent=0, const char *name=0) : KStatusBar(parent,name), BaseObject() {
      connect(this, SIGNAL(pressed(int)), this, SLOT(sigPressed(int)));
      connect(this, SIGNAL(released(int)), this, SLOT(sigReleased(int)));
    };
    ~_StatusBar() {};
    
protected slots:

    void sigPressed(int at) {
       PyObject *arg = Py_BuildValue("(i)",at);
       _emit("pressed", arg);  
       Py_DECREF(arg);
    };
    
    void sigReleased(int at) {
       PyObject *arg = Py_BuildValue("(i)",at);
       _emit("released", arg);  
       Py_DECREF(arg);
    };

};

#endif
