#ifndef _KSLIDER_H_
#define _KSLIDER_H_

#include <Python.h>
#include <kslider.h>
#include "Baseobject.h"


class _Slider : public KSlider, BaseObject
{
  Q_OBJECT

  public:
  
  _Slider(QSlider::Orientation o, QWidget *parent=0, const char *name=0) : KSlider(KSlider::Orientation(o),parent,name), BaseObject() {
    connect(this, SIGNAL(sliderPressed()), this, SLOT(sigSliderPressed()));
    connect(this, SIGNAL(sliderMoved(int)), this, SLOT(sigSliderMoved(int)));
    connect(this, SIGNAL(sliderReleased()), this, SLOT(sigSliderReleased()));
    connect(this, SIGNAL(valueChanged(int)), this, SLOT(sigValueChanged(int)));    
  };
  _Slider(int min, int max, int step, int value, QSlider::Orientation o , QWidget *parent=0, const char *name=0) :
    KSlider(min,max,step,value,KSlider::Orientation(o),parent,name), BaseObject()
  {
    connect(this, SIGNAL(sliderPressed()), this, SLOT(sigSliderPressed()));
    connect(this, SIGNAL(sliderMoved(int)), this, SLOT(sigSliderMoved(int)));
    connect(this, SIGNAL(sliderReleased()), this, SLOT(sigSliderReleased()));
    connect(this, SIGNAL(valueChanged(int)), this, SLOT(sigValueChanged(int)));    
  }
  ~_Slider() {};

  protected slots:

    void sigSliderPressed() {
      _emit("pressed", 0);
    };
    
    void sigSliderReleased() {
      _emit("sliderReleaser", 0);
    };
    
    void sigSliderMoved(int value) {
      PyObject *arg = Py_BuildValue("(i)",value);
      _emit("sliderMoved", arg);
      Py_DECREF(arg);
    };

    void sigValueChanged(int value) {
      PyObject *arg = Py_BuildValue("(i)",value);
      _emit("valueChanged", arg);
      Py_DECREF(arg);
    };

};

#endif