//////////////////////////////////////////////////////////////////////////////
//
//    KEXIFUTILS.CPP
//
//    Copyright (C) 2002-2004 Renchi Raju <renchi at pooh.tam.uiuc.edu>
//                            Gilles CAULIER <caulier dot gilles at free.fr>
//                            Ralf Hoelzer <kde at ralfhoelzer.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
//////////////////////////////////////////////////////////////////////////////

#include "kexifentry.h"
#include "kexiflistviewitem.h"

KExifListViewItem::KExifListViewItem(KListView *parent,
                                     KExifEntry* entry)
    : KListViewItem(parent)
{
    mExifEntry = 0;
    if (entry) {
        mExifEntry = entry;
        setText(0,mExifEntry->getName());
        setText(1,mExifEntry->getValue());
    }

}

KExifListViewItem::KExifListViewItem(KListView *parent,
                                     QListViewItem* afterItem,
                                     KExifEntry* entry)
    : KListViewItem(parent, afterItem)
{
    mExifEntry = 0;
    if (entry) {
        mExifEntry = entry;
        setText(0,mExifEntry->getName());
        setText(1,mExifEntry->getValue());
    }
}


KExifListViewItem::~KExifListViewItem()
{
    if (mExifEntry) {
        mExifEntry = 0;
    }
}

