#ifndef THUMBNAILCREATOR_H
#define THUMBNAILCREATOR_H

#include <qthread.h>
#include <qmutex.h>
#include <qobject.h>
#include <qstring.h>
#include <qimage.h>


#include "mtqueue.h"
#include "thumbnailrequest.h"

class ThumbnailCreator : public QThread {

public:

    ThumbnailCreator(QObject *_parent);
    ~ThumbnailCreator();

    void requestThumbnail(const QString& fileName,
                          const ThumbnailSize& thumbSize);

    void stop();
    void pause(bool shouldPause);
    bool isPaused();

    void setThumbnailCacheDirs(const QString& smallCacheDir,
                               const QString& mediumCacheDir,
                               const QString& largeCacheDir);

    void forceRegeneration(bool force);
    bool isForceRegeneration();


private:

    QObject *parent;
    QMutex mutex;

    bool mForceRegeneration;
    bool mPaused;

    MTQueue<ThumbnailRequest> mRequestQueue;
    bool mThreadExit;

    QString mThumbSmallCacheDir;
    QString mThumbMediumCacheDir;
    QString mThumbLargeCacheDir;

    QString getThumbSmallCacheDir();
    QString getThumbMediumCacheDir();
    QString getThumbLargeCacheDir();

    bool isJPEG(const QString& fileName);
    bool loadJPEG(QImage& image, const ThumbnailSize& thumbSize,
                  const QString& fileName);

protected:

    virtual void run();

private:

    void showBusyStatus(bool _busy);

};


#endif
