#ifndef GPHOTO_EVENTS_H
#define GPHOTO_EVENTS_H

#include <qevent.h>
#include <qstring.h>

#include "mtlist.h"
#include "camerafileiteminfo.h"
#include "thumbnailmt.h"

enum Gphoto_EventTypes {
  Gphoto_InitializedT = QCustomEvent::User,
  Gphoto_NewSubFoldersT,
  Gphoto_NewItemsT,
  Gphoto_MakeFolderT,
  Gphoto_DeleteFolderT,
  Gphoto_GetThumbNailT,
  Gphoto_ThumbNailReadyT,
  Gphoto_DownloadImageT,
  Gphoto_DeleteImageT,
  Gphoto_OpenImageT,
  Gphoto_InformationT,
  Gphoto_StatusMsgT,
  Gphoto_ProgressT,
  Gphoto_ErrorMsgT,
  Gphoto_BusyT
};


class Gphoto_Event_InitializedCamera : public QCustomEvent {

public:

  Gphoto_Event_InitializedCamera(const QString& _camModel,
				const QString& _camPort,
                                const QString& _camPath)
    : QCustomEvent(Gphoto_InitializedT),
      camModel(_camModel),
      camPort(_camPort),
      camPath(_camPath)
  {}

  QString cameraModel() const {return camModel;}
  QString cameraPort() const {return camPort;}
  QString cameraPath() const {return camPath;}

private:

    QString camModel;
    QString camPort;
    QString camPath;

};

class Gphoto_Event_NewSubFolders : public QCustomEvent {

public:

  Gphoto_Event_NewSubFolders(const QString& _parentFolder,
			     const QStringList& _subFolderList,
			     const QStringList& _subFolderNameList)
    : QCustomEvent(Gphoto_NewSubFoldersT),
      m_parentFolder(_parentFolder),
      m_subFolderList(_subFolderList),
      m_subFolderNameList(_subFolderNameList)
  {}

  QString parentFolder() const {return m_parentFolder;}
  QStringList subFolderList() const {return m_subFolderList;}
  QStringList subFolderNameList() const {return m_subFolderNameList;}

private:

  QString m_parentFolder;
  QStringList m_subFolderList;
  QStringList m_subFolderNameList;

};


class Gphoto_Event_NewItems : public QCustomEvent {

public:

  Gphoto_Event_NewItems(const QString& _parentFolder,
                        const MTList<CameraFileItemInfo>& _infoList)
    : QCustomEvent(Gphoto_NewItemsT),
      m_parentFolder(_parentFolder),
      m_infoList(_infoList)
  {}

  QString parentFolder() const {return m_parentFolder;}
  MTList<CameraFileItemInfo> itemsInfoList() const {return m_infoList;}

private:

  QString m_parentFolder;
  MTList<CameraFileItemInfo> m_infoList;

};


class Gphoto_Event_GetThumbNail : public QCustomEvent {

public:

  Gphoto_Event_GetThumbNail(const QString& _parentFolder,
		      const QString& _imageName,
		      const ThumbnailMT& _thumbSmall,
		      const ThumbnailMT& _thumbMedium,
		      const ThumbnailMT& _thumbLarge) :
    QCustomEvent(Gphoto_GetThumbNailT),
    m_parentFolder(_parentFolder),
    m_imageName(_imageName),
    m_thumbnailSmall(_thumbSmall),
    m_thumbnailMedium(_thumbMedium),
    m_thumbnailLarge(_thumbLarge)
  {}


  QString parentFolder() const {return m_parentFolder;}
  QString imageName()    const {return m_imageName;}
  void getThumbnailSmall(QPixmap& pix)
    { m_thumbnailSmall.fillPixmap(pix); }
  void getThumbnailMedium(QPixmap& pix)
    { m_thumbnailMedium.fillPixmap(pix); }
  void getThumbnailLarge(QPixmap& pix)
    { m_thumbnailLarge.fillPixmap(pix); }


private:

  QString m_parentFolder;
  QString m_imageName;
  ThumbnailMT m_thumbnailSmall;
  ThumbnailMT m_thumbnailMedium;
  ThumbnailMT m_thumbnailLarge;

};


class Gphoto_Event_ThumbNailReady : public QCustomEvent {

public:

  Gphoto_Event_ThumbNailReady(const QString& _parentFolder,
                              const QString& _imageName,
			      const ThumbnailMT& thumbnail,
                              bool _success) :
      QCustomEvent(Gphoto_ThumbNailReadyT),
      m_parentFolder(_parentFolder),
      m_imageName(_imageName),
      m_thumbnail(thumbnail),
      m_success(_success)
  {}


    QString parentFolder() const {return m_parentFolder;}
    QString imageName() const {return m_imageName;}
    void fillPixmap(QPixmap& pix) {m_thumbnail.fillPixmap(pix);}
    bool success() const {return m_success;}

private:

    QString m_parentFolder;
    QString m_imageName;
    ThumbnailMT m_thumbnail;
    bool m_success;

};


class Gphoto_Event_DownloadImage : public QCustomEvent {

public:

    Gphoto_Event_DownloadImage(const QString& _parentFolder,
			   const QString& _imageName) :
    QCustomEvent(Gphoto_DownloadImageT),
    m_parentFolder(_parentFolder),
    m_imageName(_imageName)
  {}

  QString parentFolder() const {return m_parentFolder;}
  QString imageName()    const {return m_imageName;}

private:

  QString m_parentFolder;
  QString m_imageName;

};

class Gphoto_Event_DeleteImage : public QCustomEvent {

public:

  Gphoto_Event_DeleteImage(const QString& _parentFolder,
			   const QString& _imageName) :
    QCustomEvent(Gphoto_DeleteImageT),
    m_parentFolder(_parentFolder),
    m_imageName(_imageName)
  {}

  QString parentFolder() const {return m_parentFolder;}
  QString imageName()    const {return m_imageName;}

private:

  QString m_parentFolder;
  QString m_imageName;

};

class Gphoto_Event_OpenImage : public QCustomEvent {

public:

  Gphoto_Event_OpenImage(const QString& _parentFolder,
			   const QString& _imageName) :
    QCustomEvent(Gphoto_OpenImageT),
    m_parentFolder(_parentFolder),
    m_imageName(_imageName)
  {}

  QString parentFolder() const {return m_parentFolder;}
  QString imageName()    const {return m_imageName;}

private:

  QString m_parentFolder;
  QString m_imageName;

};

class Gphoto_Event_Information : public QCustomEvent {

public:

    Gphoto_Event_Information(const QString& summary,
                         const QString& manual,
                         const QString& about)
        : QCustomEvent(Gphoto_InformationT),
          mSummary(summary.latin1()),
          mManual(manual.latin1()),
          mAbout(about.latin1())
        {}

    QString getSummary() const { return mSummary; }
    QString getManual() const { return mManual; }
    QString getAbout() const { return mAbout; }

private:

    QString mSummary;
    QString mManual;
    QString mAbout;

};


class Gphoto_Event_CameraStatusMsg : public QCustomEvent {

public:

  Gphoto_Event_CameraStatusMsg(const QString& _msg):
    QCustomEvent(Gphoto_StatusMsgT),
    m_msg(_msg)
  {}

  QString statusMsg() const { return m_msg;}

private:

  QString m_msg;

};


class Gphoto_Event_CameraProgress : public QCustomEvent {

public:

  Gphoto_Event_CameraProgress(const int& _val):
    QCustomEvent(Gphoto_ProgressT),
    m_val(_val)
  {}

  int val() const { return m_val;}

private:

  int m_val;

};

class Gphoto_Event_CameraErrorMsg : public QCustomEvent {

public:

  Gphoto_Event_CameraErrorMsg(const QString& _msg):
    QCustomEvent(Gphoto_ErrorMsgT),
    m_msg(_msg)
  {}

  QString errorMsg() const { return m_msg;}

private:

  QString m_msg;

};

class Gphoto_Event_Busy : public QCustomEvent {

public:

  Gphoto_Event_Busy(bool _busy):
    QCustomEvent(Gphoto_BusyT),
    m_busy(_busy)
  {}

  bool busy() { return m_busy;}

private:

  bool m_busy;

};

#endif
