#ifndef CAMERAICONITEM_H
#define CAMERAICONITEM_H

#include <qiconview.h>
#include <qobject.h>

#include "thumbnailsize.h"

class QPixmap;
class CameraFileItem;
class CameraFileItemInfo;
class CameraIconView;

class CameraIconItem : public QObject, public QIconViewItem {

    Q_OBJECT

public:

    CameraIconItem(CameraIconView* parent,
                   const CameraFileItem* fileItem,
                   const ThumbnailSize& thumbSize);
    ~CameraIconItem();

    CameraFileItemInfo* fileInfo() const;
    const CameraFileItem* fileItem();

private:

    void showPixmapForMime();
    void dropShadow(QPixmap& thumbnail);

private:

    const CameraFileItem* mFileItem;
    ThumbnailSize mThumbnailSize;
    static const char * new_xpm[];

private slots:

    void slot_showThumbnail();
    void slot_deleteThis();
};

#endif
