#include <qmime.h>
#include <qstringlist.h>
#include <qstring.h>
#include <qcstring.h>
#include <qwidget.h>

#include "cameradragobject.h"

CameraDragObject::CameraDragObject(const QStringList& nameList,
                                   const QStringList& folderList,
                                   QWidget *dragSource)
    : QStoredDrag("camera/unknown",dragSource)
{
    setDragItems(nameList, folderList);
}

CameraDragObject::~CameraDragObject()
{

}

void CameraDragObject::setDragItems(const QStringList& nameList,
                                    const QStringList& folderList)
{
    if (nameList.isEmpty() || folderList.isEmpty())
        return;

    QByteArray byteArray;
    int currentSize = 0;

    QStringList::ConstIterator it = nameList.begin();
    QStringList::ConstIterator it2 = folderList.begin();
    for ( ;it != nameList.end(); ++it, ++it2 ) {

        const char* cname   = (*it).latin1();
        const char* cfolder = (*it2).latin1();

        int lname = qstrlen(cname);
        int lfolder = qstrlen(cfolder);

        byteArray.resize(currentSize + lname + lfolder + 4);
        memcpy(byteArray.data() + currentSize, cname, lname);
        currentSize += lname;
        memcpy(byteArray.data() + currentSize, "\r\n", 2);
        currentSize += 2;
        memcpy(byteArray.data() + currentSize, cfolder, lfolder);
        currentSize += lfolder;
        memcpy(byteArray.data() + currentSize, "\r\n", 2);
        currentSize += 2;

    }
    setEncodedData(byteArray);

}

bool CameraDragObject::canDecode(const QMimeSource* e)
{
    return e->provides("camera/unknown");
}

bool CameraDragObject::decode(const QMimeSource* e,
                              QStringList& nameList,
                              QStringList& folderList)
{
    QByteArray payload = e->encodedData("camera/unknown");
    if (payload.size()) {

        nameList.clear();
        folderList.clear();

        uint c = 0;

        const char* d = payload.data();
        while (c < payload.size() && d[c]) {

            // Find Line End
            uint f = c;
            while (c < payload.size() && d[c] && d[c]!='\r'
                   && d[c] != '\n')
                c++;
            QCString name(d+f,c-f+1);
            nameList.append(name);

            // Skip Junk
            while (c < payload.size() && d[c] &&
		    (d[c]=='\n' || d[c]=='\r'))
                c++;

            // Find Line End
            f = c;
            while (c < payload.size() && d[c] && d[c]!='\r'
                   && d[c] != '\n')
                c++;
            QCString folder(d+f,c-f+1);
            folderList.append(folder);

            // Skip Junk
            while (c < payload.size() && d[c] &&
                   (d[c]=='\n' || d[c]=='\r'))
                c++;
        }

        return true;
    }
    else
        return false;
}
