/***************************************************************************
                          digikam_view.h  -  description
                             -------------------
    begin                : Wed Jan 9 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DIGIKAM_VIEW_H
#define DIGIKAM_VIEW_H

#include <qwidget.h>
#include <qvariant.h>
#include <kmainwindow.h>

class QGridLayout;
class QGroupBox;
class QTabWidget;
class QCheckBox;
class QLabel;
class QWidgetStack;
class QPushButton;
class QProgressBar;

class KIconView;
class KListView;
class KStatusBar;
class KProgress;
class KComboBox;

class Camera_Folder;
class Photo_FolderTree;
class Photo_IconView;

class Digikam_View : public QWidget  {
   Q_OBJECT
   friend class Digikam;

 public: 

   Digikam_View(QWidget *parent = 0, const char *name=0);
   ~Digikam_View();

   QTabWidget* TabWidget;
   QWidget*   tabCameraBrowser;
   KListView* KListView_camFolders;
   QWidgetStack* QWidgetStack_camIconViews;
   KIconView* KIconView_camIconViewRoot;
   Camera_Folder* camGlobFolder;

   QWidget*   tabPhotoBrowser;
   Photo_FolderTree* photoFolderTree;
   Photo_IconView* photoIconView;

   QCheckBox* QCheckBox_thumbNails;
   QLabel* cameraLabel;
  
   int QWidgetStack_id;

   KStatusBar *camStatusBar;
   KProgress  *camProgressBar;
   KComboBox  *camDirBox;
   QPushButton *QPushButton_camBrowse;

   KStatusBar *photoStatusBar;
   QProgressBar  *photoProgressBar;

 protected:

   QGridLayout* MainLayout;
   QGridLayout* tabCameraBrowser_Layout;
   QGridLayout* tabPhotoBrowser_Layout;
   
   QGroupBox* QGroupBox_camBottom;
   QGridLayout* QGroupBox_camBottomLayout;

 protected slots:
   
   void slot_setCamStatusMsg(const QString &msg);
   void slot_startedGenThumbnail(int count);
   void slot_stoppedGenThumbnail();
   void slot_generatedOneThumbnail();
};

#endif
