/***************************************************************************
 *   Copyright (C) 2010 by Volker Krause <vkrause@kde.org>                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#include "bridgeserver.h"

#include "exception.h"

BridgeServerBase::BridgeServerBase(quint16 port, QObject *parent) :
    QObject(parent),
    m_server( new QTcpServer( this ) )
{
  connect( m_server, SIGNAL(newConnection()), SLOT(slotNewConnection()) );
  if ( !m_server->listen( QHostAddress::Any, port ) )
      throw Exception<std::runtime_error>( tr("Can't listen to port %1: %2")
                                           .arg( port ).arg( m_server->errorString() ) );
}

#include "bridgeserver.moc"
