#include "Ratios.moc"
#include "AddDlFree.h"
#include "ftpaccess.h"
#include <qlabel.h>
#include <kapp.h>
#include <klocale.h>
#include <qwhatsthis.h>

Ratios::Ratios(QWidget *parent, const char *name): QWidget(parent,name)
{
	int x=5, y=5;
	int w=640, h=380;
	ftpxs=0;
	QLabel *lbl1=new QLabel(i18n("&Upload/download ratio: 1:"),this);
	lbl1->setGeometry(x,y,lbl1->sizeHint().width(),lbl1->height());
	x+=lbl1->width();
	UlDlRatio=new QSpinBox(this); lbl1->setBuddy(UlDlRatio);
	UlDlRatio->move(x,y); UlDlRatio->setRange(1,9999);
	x+=UlDlRatio->width()+5;
	UlDlRatioAnon=new QCheckBox(i18n("for &anonymous users"),this);
	UlDlRatioAnon->setGeometry(x,y,UlDlRatioAnon->sizeHint().width(),UlDlRatioAnon->height());
	x+=UlDlRatioAnon->width();
	UlDlRatioGuest=new QCheckBox(i18n("for &guest users"),this);
	UlDlRatioGuest->setGeometry(x,y,UlDlRatioGuest->sizeHint().width(),UlDlRatioGuest->height());
	QWhatsThis::add(UlDlRatioAnon,i18n("If enabled, an anonymous user can download only [x] bytes per uploaded byte."));
	QWhatsThis::add(UlDlRatioGuest,i18n("If enabled, a guest can download only [x] bytes per uploaded byte."));
	x=5; y+=UlDlRatio->height()+5;

	QLabel *lbl2=new QLabel(i18n("&Time limit:"),this);
	lbl2->setGeometry(x,y,lbl2->sizeHint().width(),lbl1->height());
	x+=lbl2->width();
	limitTime=new QSpinBox(this); lbl2->setBuddy(limitTime);
	limitTime->move(x,y); limitTime->setRange(1,99999);
	x+=limitTime->width()+5;
	QLabel *lbl3=new QLabel(i18n("minutes"),this);
	lbl3->setGeometry(x,y,lbl3->sizeHint().width(),lbl3->height());
	x+=lbl3->width()+5;
	limitTimeAnon=new QCheckBox(i18n("for a&nonymous users"),this);
	limitTimeAnon->setGeometry(x,y,limitTimeAnon->sizeHint().width(),limitTimeAnon->height());
	x+=limitTimeAnon->width();
	limitTimeGuest=new QCheckBox(i18n("for g&uest users"),this);
	limitTimeGuest->setGeometry(x,y,limitTimeGuest->sizeHint().width(),limitTimeGuest->height());
	x=5; y+=limitTime->height()+5;

	QLabel *lbl4=new QLabel(i18n("U&pload limit:"),this);
	lbl4->setGeometry(x,y,lbl4->sizeHint().width(),lbl4->height());
	x+=lbl4->width();
	limitUpload=new QSpinBox(this); lbl4->setBuddy(limitUpload);
	limitUpload->move(x,y); limitUpload->setRange(1,2147483647);
	x+=limitUpload->width()+5;
	QLabel *lbl5=new QLabel(i18n("bytes"),this);
	lbl5->setGeometry(x,y,lbl5->sizeHint().width(),lbl5->height());
	x+=lbl5->width()+5;
	limitUploadAnon=new QCheckBox(i18n("for an&onymous users"),this);
	limitUploadAnon->setGeometry(x,y,limitUploadAnon->sizeHint().width(),limitUpload->height());
	x+=limitUploadAnon->width();
	limitUploadGuest=new QCheckBox(i18n("for gu&est users"),this);
	limitUploadGuest->setGeometry(x,y,limitUploadGuest->sizeHint().width(),limitUploadGuest->height());
	x=5;y+=limitUpload->height()+5;

	QLabel *lbl6=new QLabel(i18n("&Download limit:"),this);
	lbl6->setGeometry(x,y,lbl6->sizeHint().width(),lbl6->height());
	x+=lbl6->width();
	limitDownload=new QSpinBox(this); lbl6->setBuddy(limitDownload);
	limitDownload->move(x,y); limitDownload->setRange(1,2147483647);
	x+=limitDownload->width()+5;
	QLabel *lbl7=new QLabel(i18n("bytes"),this);
	lbl7->setGeometry(x,y,lbl7->sizeHint().width(),lbl7->height());
	x+=lbl7->width()+5;
	limitDownloadAnon=new QCheckBox(i18n("for anon&ymous users"),this);
	limitDownloadAnon->setGeometry(x,y,limitDownloadAnon->sizeHint().width(),limitDownload->height());
	x+=limitDownloadAnon->width();
	limitDownloadGuest=new QCheckBox(i18n("for gue&st users"),this);
	limitDownloadGuest->setGeometry(x,y,limitDownloadGuest->sizeHint().width(),limitDownloadGuest->height());
	x=5;y+=limitDownload->height()+5;

	QLabel *lbl8=new QLabel(i18n("Freely downloadable files:"),this);
	lbl8->setGeometry(x,y,w/2-10,lbl8->height());

	QLabel *lbl9=new QLabel(i18n("Freely downloadable directories:"),this);
	lbl9->setGeometry(w/2+5,y,w/2-10,lbl9->height());
	y+=lbl9->height();

	dlFree=new QListBox(this);
	dlFree->setGeometry(x,y,w/2-10,h-y-lbl9->height()*3);

	dlFreeDir=new QListBox(this);
	dlFreeDir->setGeometry(w/2+5,y,w/2-10,h-y-lbl9->height()*3);
	y=h-lbl9->height()*3;

	dlFreeAdd=new QPushButton(i18n("&Add"),this);
	dlFreeAdd->setGeometry(x,y,w/4-5,dlFreeAdd->height());
	connect(dlFreeAdd,SIGNAL(clicked()),SLOT(dlFreeAddPressed()));
	dlFreeRm=new QPushButton(i18n("&Remove"),this);
	dlFreeRm->setGeometry(w/4,y,w/4-5,dlFreeRm->height());
	connect(dlFreeRm,SIGNAL(clicked()),SLOT(dlFreeRmPressed()));

	dlFreeDirAdd=new QPushButton(i18n("A&dd"),this);
	dlFreeDirAdd->setGeometry(w/2+5,y,w/4-5,dlFreeDirAdd->height());
	connect(dlFreeDirAdd,SIGNAL(clicked()),SLOT(dlFreeDirAddPressed()));
	dlFreeDirRm=new QPushButton(i18n("Remo&ve"),this);
	dlFreeDirRm->setGeometry(w*3/4,y,w/4-5,dlFreeDirRm->height());
	connect(dlFreeDirRm,SIGNAL(clicked()),SLOT(dlFreeDirRmPressed()));
}
Ratios::~Ratios()
{
}
void Ratios::ftpaccessLoaded(ftpaccess *xs)
{
	ftpxs=xs;
	UlDlRatio->setValue(ftpxs->getUlDlRatio());
	UlDlRatioAnon->setChecked((ftpxs->getUlDlRatioWho()&ANONYMOUS)!=0);
	UlDlRatioGuest->setChecked((ftpxs->getUlDlRatioWho()&GUEST)!=0);
	limitTime->setValue(ftpxs->getLimitTime());
	limitTimeAnon->setChecked((ftpxs->getLimitTimeWho()&ANONYMOUS)!=0);
	limitTimeGuest->setChecked((ftpxs->getLimitTimeWho()&GUEST)!=0);
	limitUpload->setValue(ftpxs->getLimitUpload());
	limitUploadAnon->setChecked((ftpxs->getLimitUploadWho()&ANONYMOUS)!=0);
	limitUploadGuest->setChecked((ftpxs->getLimitUploadWho()&GUEST)!=0);
	limitDownload->setValue(ftpxs->getLimitDownload());
	limitDownloadAnon->setChecked((ftpxs->getLimitDownloadWho()&ANONYMOUS)!=0);
	limitDownloadGuest->setChecked((ftpxs->getLimitDownloadWho()&GUEST)!=0);
	dlFreeL=ftpxs->getDlFree();
	dlFreeDirL=ftpxs->getDlFreeDir();
	redraw();
}
void Ratios::redraw()
{
	dlFree->clear();
	dlFreeDir->clear();
}
void Ratios::update()
{
	ftpxs->setUlDlRatio(UlDlRatio->value());
	ftpxs->setLimitTime(limitTime->value());
	ftpxs->setLimitUpload(limitUpload->value());
	ftpxs->setLimitDownload(limitDownload->value());
	if(UlDlRatioAnon->isChecked())
		ftpxs->setUlDlRatioWho(ftpxs->getUlDlRatioWho()|ANONYMOUS);
	else
		ftpxs->setUlDlRatioWho(ftpxs->getUlDlRatioWho()&~ANONYMOUS);
	if(UlDlRatioGuest->isChecked())
		ftpxs->setUlDlRatioWho(ftpxs->getUlDlRatioWho()|GUEST);
	else
		ftpxs->setUlDlRatioWho(ftpxs->getUlDlRatioWho()&~GUEST);
	if(limitTimeAnon->isChecked())
		ftpxs->setLimitTimeWho(ftpxs->getLimitTimeWho()|ANONYMOUS);
	else
		ftpxs->setLimitTimeWho(ftpxs->getLimitTimeWho()&~ANONYMOUS);
	if(limitTimeGuest->isChecked())
		ftpxs->setLimitTimeWho(ftpxs->getLimitTimeWho()|GUEST);
	else
		ftpxs->setLimitTimeWho(ftpxs->getLimitTimeWho()&~GUEST);
	if(limitUploadAnon->isChecked())
		ftpxs->setLimitUploadWho(ftpxs->getLimitUploadWho()|ANONYMOUS);
	else
		ftpxs->setLimitUploadWho(ftpxs->getLimitUploadWho()&~ANONYMOUS);
	if(limitUploadGuest->isChecked())
		ftpxs->setLimitUploadWho(ftpxs->getLimitUploadWho()|GUEST);
	else
		ftpxs->setLimitUploadWho(ftpxs->getLimitUploadWho()&~GUEST);
	if(limitDownloadAnon->isChecked())
		ftpxs->setLimitDownloadWho(ftpxs->getLimitDownloadWho()|ANONYMOUS);
	else
		ftpxs->setLimitDownloadWho(ftpxs->getLimitDownloadWho()&~ANONYMOUS);
	if(limitDownloadGuest->isChecked())
		ftpxs->setLimitDownloadWho(ftpxs->getLimitDownloadWho()|GUEST);
	else
		ftpxs->setLimitDownloadWho(ftpxs->getLimitDownloadWho()&~GUEST);
}
void Ratios::dlFreeAddPressed()
{
	AddDlFree *a=new AddDlFree();
	connect(a,SIGNAL(dlFreeAdded(bool, QString)),SLOT(dlFreeAdded(bool, QString)));
}
void Ratios::dlFreeRmPressed()
{
	for(unsigned int i=0;i<dlFree->count();i++)
		if(dlFree->isSelected(i)) {
			dlFree->removeItem(i);
			dlFreeL->remove(dlFreeL->at(i));
		}
}
void Ratios::dlFreeDirAddPressed()
{
	AddDlFree *a=new AddDlFree(true);
	connect(a,SIGNAL(dlFreeAdded(bool, QString)),SLOT(dlFreeAdded(bool, QString)));
}
void Ratios::dlFreeDirRmPressed()
{
	for(unsigned int i=0;i<dlFreeDir->count();i++)
		if(dlFreeDir->isSelected(i)) {
			dlFreeDir->removeItem(i);
			dlFreeDirL->remove(dlFreeDirL->at(i));
		}
}
void Ratios::dlFreeAdded(bool isDir, QString name)
{
	if(isDir) {
		dlFreeDir->insertItem(name);
		dlFreeDirL->append(name);
	} else {
		dlFree->insertItem(name);
		dlFreeL->append(name);
	}
}
