/*
 * Decompiled with CFR 0.152.
 */
package IceBox;

import Ice.Application;
import Ice.Identity;
import Ice.ObjectPrx;
import Ice.Properties;
import IceBox.AlreadyStartedException;
import IceBox.AlreadyStoppedException;
import IceBox.NoSuchServiceException;
import IceBox.ServiceManagerPrx;
import IceBox.ServiceManagerPrxHelper;
import java.util.ArrayList;

public final class Admin {
    public static void main(String[] args) {
        Client app = new Client();
        int rc = app.main("IceBox.Admin", args);
        System.exit(rc);
    }

    private static class Client
    extends Application {
        private Client() {
        }

        private void usage() {
            System.err.println("Usage: " + Client.appName() + " [options] [command...]\n" + "Options:\n" + "-h, --help          Show this message.\n" + "\n" + "Commands:\n" + "start SERVICE       Start a service." + "stop SERVICE        Stop a service." + "shutdown            Shutdown the server.");
        }

        public int run(String[] args) {
            String managerProxy;
            ArrayList<String> commands = new ArrayList<String>();
            for (int idx = 0; idx < args.length; ++idx) {
                if (args[idx].equals("-h") || args[idx].equals("--help")) {
                    this.usage();
                    return 1;
                }
                if (args[idx].charAt(0) == '-') {
                    System.err.println(Client.appName() + ": unknown option `" + args[idx] + "'");
                    this.usage();
                    return 1;
                }
                commands.add(args[idx]);
            }
            if (commands.isEmpty()) {
                this.usage();
                return 0;
            }
            Properties properties = Client.communicator().getProperties();
            Identity managerIdentity = new Identity();
            managerIdentity.category = properties.getPropertyWithDefault("IceBox.InstanceName", "IceBox");
            managerIdentity.name = "ServiceManager";
            if (properties.getProperty("Ice.Default.Locator").length() == 0) {
                String managerEndpoints = properties.getProperty("IceBox.ServiceManager.Endpoints");
                if (managerEndpoints.length() == 0) {
                    System.err.println(Client.appName() + ": property `IceBox.ServiceManager.Endpoints' is not set");
                    return 1;
                }
                managerProxy = "\"" + Client.communicator().identityToString(managerIdentity) + "\" :" + managerEndpoints;
            } else {
                String managerAdapterId = properties.getProperty("IceBox.ServiceManager.AdapterId");
                if (managerAdapterId.length() == 0) {
                    System.err.println(Client.appName() + ": property `IceBox.ServiceManager.AdapterId' is not set");
                    return 1;
                }
                managerProxy = "\"" + Client.communicator().identityToString(managerIdentity) + "\" @" + managerAdapterId;
            }
            ObjectPrx base = Client.communicator().stringToProxy(managerProxy);
            ServiceManagerPrx manager = ServiceManagerPrxHelper.checkedCast(base);
            if (manager == null) {
                System.err.println(Client.appName() + ": `" + managerProxy + "' is not running");
                return 1;
            }
            for (int i = 0; i < commands.size(); ++i) {
                String service;
                String command = (String)commands.get(i);
                if (command.equals("shutdown")) {
                    manager.shutdown();
                    continue;
                }
                if (command.equals("start")) {
                    if (++i >= commands.size()) {
                        System.err.println(Client.appName() + ": no service name specified.");
                        return 1;
                    }
                    service = (String)commands.get(i);
                    try {
                        manager.startService(service);
                    }
                    catch (NoSuchServiceException ex) {
                        System.err.println(Client.appName() + ": unknown service `" + service + "'");
                    }
                    catch (AlreadyStartedException ex) {
                        System.err.println(Client.appName() + "service already started.");
                    }
                    continue;
                }
                if (command.equals("stop")) {
                    if (++i >= commands.size()) {
                        System.err.println(Client.appName() + ": no service name specified.");
                        return 1;
                    }
                    service = (String)commands.get(i);
                    try {
                        manager.stopService(service);
                    }
                    catch (NoSuchServiceException ex) {
                        System.err.println(Client.appName() + ": unknown service `" + service + "'");
                    }
                    catch (AlreadyStoppedException ex) {
                        System.err.println(Client.appName() + "service already stopped.");
                    }
                    continue;
                }
                System.err.println(Client.appName() + ": unknown command `" + command + "'");
                this.usage();
                return 1;
            }
            return 0;
        }
    }
}

