// Adds a cookie
function webdeveloper_addCookie()
{
    window.openDialog("chrome://webdeveloper/content/dialogs/cookie.xul", "webdeveloper-cookie-dialog", "centerscreen,chrome,modal", "add");
}

// Clears all session cookies
function webdeveloper_clearSessionCookies()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");

    // If the clearing is confirmed
    if(webdeveloper_clearConfirmation(stringBundle.getString("webdeveloper_clearSessionCookiesConfirmation")))
    {
        var cookie        = null;
        var cookieManager = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);
        var cookies       = cookieManager.enumerator;
        var removed       = 0;

        // Loop through the cookies
        while(cookies.hasMoreElements())
        {
            cookie = cookies.getNext();

            // If this is a cookie with no expiration
            if(cookie instanceof Components.interfaces.nsICookie && cookie.expires == "0")
            {
                cookieManager.remove(cookie.host, cookie.name, cookie.path, false);
                removed++;
            }
        }

        // If the hide informational dialogs preference is not set
        if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
        {
            var title = stringBundle.getString("webdeveloper_clearSessionCookies");

            // If one session cookie was removed
            if(removed == 1)
            {
                webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_clearSessionCookiesSingleResult"));
            }
            else
            {
                webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_clearSessionCookiesMultipleResult", [removed]));
            }
        }
    }
}

// Deletes a cookie
function webdeveloper_deleteCookie(event)
{
    var eventTarget = event.target;

    // If there is an event target and the click was not a right click
    if(eventTarget && event.button != 2)
    {
        var stringBundle = document.getElementById("webdeveloper-string-bundle");

        // If the deletion is confirmed
        if(webdeveloper_deleteConfirmation(stringBundle.getString("webdeveloper_deleteCookieConfirmation")))
        {
            Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager).remove(eventTarget.getAttribute("cookie-host"), eventTarget.getAttribute("cookie-name"), eventTarget.getAttribute("cookie-path"), false);

            // If the hide informational dialogs preference is not set
            if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
            {
                webdeveloper_informationalDialog(stringBundle.getString("webdeveloper_deleteCookie"), stringBundle.getString("webdeveloper_deleteCookieResult"));
            }
        }

        event.preventDefault();
    }
}

// Called when a delete cookie link is moused out
function webdeveloper_deleteCookieMouseOut(event)
{
    // If there is an event target
    if(event.target)
    {
        getBrowser().contentWindow.status = "";

        event.preventDefault();
    }
}

// Called when a delete cookie link is moused over
function webdeveloper_deleteCookieMouseOver(event)
{
    // If there is an event target
    if(event.target)
    {
        getBrowser().contentWindow.status = document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_deleteCookie");

        event.preventDefault();
    }
}

// Deletes all the cookies for the current domain
function webdeveloper_deleteDomainCookies()
{
    var cookies        = new Array();
    var cookiesLength  = null;
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var message        = null;
    var pageDocument   = null;
    var stringBundle   = document.getElementById("webdeveloper-string-bundle");

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        cookies      = cookies.concat(webdeveloper_getCookies(pageDocument.location.hostname, "/", false));
    }

    cookiesLength = cookies.length;

    // If one cookie was found
    if(cookiesLength == 1)
    {
        message = stringBundle.getString("webdeveloper_deleteDomainCookiesSingleConfirmation");
    }
    else
    {
        message = stringBundle.getFormattedString("webdeveloper_deleteDomainCookiesMultipleConfirmation", [cookiesLength]);
    }

    // If the deletion is confirmed
    if(cookiesLength == 0 || webdeveloper_deleteConfirmation(message))
    {
        var cookie         = null;
        var cookieManager  = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);

        // Loop through all the cookies
        for(i = 0 ; i < cookiesLength; i++)
        {
            cookie = cookies[i];

            cookieManager.remove(cookie.host, cookie.name, cookie.path, false);
        }

        // If the hide informational dialogs preference is not set
        if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
        {
            var title = stringBundle.getString("webdeveloper_deleteDomainCookies");

            // If one cookie was found
            if(cookiesLength == 1)
            {
                webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_deleteDomainCookiesSingleResult"));
            }
            else
            {
                webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_deleteDomainCookiesMultipleResult", [cookiesLength]));
            }
        }
    }
}

// Deletes all the cookies for the current path
function webdeveloper_deletePathCookies()
{
    var cookies        = new Array();
    var cookiesLength  = null;
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;
    var message        = null;
    var pageDocument   = null;
    var stringBundle   = document.getElementById("webdeveloper-string-bundle");

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument = documentList[i];
        cookies      = cookies.concat(webdeveloper_getCookies(pageDocument.location.hostname, pageDocument.location.pathname, false));
    }

    cookiesLength = cookies.length;

    // If one cookie was found
    if(cookiesLength == 1)
    {
        message = stringBundle.getString("webdeveloper_deletePathCookiesSingleConfirmation");
    }
    else
    {
        message = stringBundle.getFormattedString("webdeveloper_deletePathCookiesMultipleConfirmation", [cookiesLength]);
    }

    // If the deletion is confirmed
    if(cookiesLength == 0 || webdeveloper_deleteConfirmation(message))
    {
        var cookie         = null;
        var cookieManager  = Components.classes["@mozilla.org/cookiemanager;1"].getService(Components.interfaces.nsICookieManager);

        // Loop through all the cookies
        for(i = 0 ; i < cookiesLength; i++)
        {
            cookie = cookies[i];

            cookieManager.remove(cookie.host, cookie.name, cookie.path, false);
        }

        // If the hide informational dialogs preference is not set
        if(!webdeveloper_getBooleanPreference("webdeveloper.informational.dialogs.hide", true))
        {
            var title = stringBundle.getString("webdeveloper_deletePathCookies");

            // If one cookie was found
            if(cookiesLength == 1)
            {
                webdeveloper_informationalDialog(title, stringBundle.getString("webdeveloper_deletePathCookiesSingleResult"));
            }
            else
            {
                webdeveloper_informationalDialog(title, stringBundle.getFormattedString("webdeveloper_deletePathCookiesMultipleResult", [cookiesLength]));
            }
        }
    }
}

// Edits a cookie
function webdeveloper_editCookie(event)
{
    var eventTarget = event.target;

    // If there is an event target and the click was not a right click
    if(eventTarget && event.button != 2)
    {
        window.openDialog("chrome://webdeveloper/content/dialogs/cookie.xul", "webdeveloper-cookie-dialog", "centerscreen,chrome,modal", "edit", eventTarget.getAttribute("cookie-name"), eventTarget.getAttribute("cookie-value"), eventTarget.getAttribute("cookie-host"), eventTarget.getAttribute("cookie-path"), eventTarget.getAttribute("cookie-expires"), eventTarget.getAttribute("cookie-secure"));

        event.preventDefault();
    }
}

// Called when an edit cookie link is moused out
function webdeveloper_editCookieMouseOut(event)
{
    // If there is an event target
    if(event.target)
    {
        getBrowser().contentWindow.status = "";

        event.preventDefault();
    }
}

// Called when an edit cookie link is moused over
function webdeveloper_editCookieMouseOver(event)
{
    // If there is an event target
    if(event.target)
    {
        getBrowser().contentWindow.status = document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_editCookie");

        event.preventDefault();
    }
}

// Toggles cookies
function webdeveloper_toggleCookies(element)
{
    var cookieBehavior = 0;

    // If disabling cookies
    if(webdeveloper_convertToBoolean(element.getAttribute("checked")))
    {
        cookieBehavior = 2;
    }

    webdeveloper_setIntegerPreference("network.cookie.cookieBehavior", cookieBehavior);
}

// Toggles external site cookies
function webdeveloper_toggleExternalSiteCookies(element)
{
    var cookieBehavior = 0;

    // If disabling external cookies
    if(webdeveloper_convertToBoolean(element.getAttribute("checked")))
    {
        cookieBehavior = 1;
    }

    webdeveloper_setIntegerPreference("network.cookie.cookieBehavior", cookieBehavior);
}

// Updates the disable cookies menu
function webdeveloper_updateDisableCookiesMenu(suffix)
{
    var disableExternalSiteCookiesChecked = false;
    var disableExternalSiteCookiesMenu    = document.getElementById("webdeveloper-disable-external-site-cookies-" + suffix);
    var disableCookiesChecked             = false;
    var disableCookiesPreferenceValue     = webdeveloper_getIntegerPreference("network.cookie.cookieBehavior", true);

    // If the cookie preference value is set to 2
    if(disableCookiesPreferenceValue == 2)
    {
        disableCookiesChecked = true;
    }
    else if(disableCookiesPreferenceValue == 1)
    {
        disableExternalSiteCookiesChecked = true;
    }

    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-all-cookies-" + suffix), "checked", disableCookiesChecked);
    webdeveloper_configureElement(disableExternalSiteCookiesMenu, "checked", disableExternalSiteCookiesChecked);
    webdeveloper_configureElement(disableExternalSiteCookiesMenu, "disabled", disableCookiesChecked);
}

// Displays all the cookies for the page
function webdeveloper_viewCookieInformation()
{
    var cellDataElement   = null;
    var cellHeaderElement = null;
    var cookie            = null;
    var cookieExpires     = null;
    var cookieHost        = null;
    var cookieLength      = null;
    var cookieName        = null;
    var cookiePath        = null;
    var cookies           = null;
    var cookieSecure      = null;
    var cookieValue       = null;
    var divElement        = null;
    var documentList      = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength    = documentList.length;
    var hostName          = null;
    var linkElement       = null;
    var listElement       = null;
    var listItemElement   = null;
    var location          = null;
    var oldTab            = getBrowser().selectedTab;
    var oldURL            = getBrowser().currentURI.spec;
    var generatedDocument = webdeveloper_generateDocument("");
    var bodyElement       = webdeveloper_getDocumentBodyElement(generatedDocument);
    var headElement       = webdeveloper_getDocumentHeadElement(generatedDocument);
    var headerElement     = generatedDocument.createElement("h1");
    var pageDocument      = null;
    var preElement        = null;
    var scriptElement     = generatedDocument.createElement("script");
    var spanElement       = null;
    var stringBundle      = document.getElementById("webdeveloper-string-bundle");
    var tableElement      = null;
    var tableRowElement   = null;
    var title             = stringBundle.getFormattedString("webdeveloper_viewCookieInformationTitle", [oldURL]);

    generatedDocument.title = title;

    webdeveloper_addGeneratedStyles(generatedDocument);

    headerElement.appendChild(generatedDocument.createTextNode(title));
    bodyElement.appendChild(headerElement);

    webdeveloper_addGeneratedTools(generatedDocument);

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        hostName     = null;
        pageDocument = documentList[i];
        location     = pageDocument.location;

        // Try to get the host name
        try
        {
            hostName = location.hostname;
        }
        catch(exception)
        {
            // Do nothing
        }

        // If the host name is set
        if(hostName)
        {
            divElement    = generatedDocument.createElement("div");
            headerElement = generatedDocument.createElement("h2");
            linkElement   = generatedDocument.createElement("a");
            cookies       = webdeveloper_getCookies(hostName, location.pathname, true);
            cookieLength  = cookies.length;
            spanElement   = generatedDocument.createElement("span");

            linkElement.setAttribute("href", pageDocument.documentURI);
            linkElement.appendChild(generatedDocument.createTextNode(pageDocument.documentURI));
            headerElement.appendChild(linkElement);
            bodyElement.appendChild(headerElement);

            headerElement = generatedDocument.createElement("h3");

            spanElement.setAttribute("class", "expanded pivot");
            headerElement.appendChild(spanElement);

            // If there is one cookie
            if(cookieLength == 1)
            {
                headerElement.appendChild(generatedDocument.createTextNode(cookieLength + " " + stringBundle.getString("webdeveloper_cookie").toLowerCase()));
            }
            else
            {
                headerElement.appendChild(generatedDocument.createTextNode(cookieLength + " " + stringBundle.getString("webdeveloper_cookies").toLowerCase()));
            }

            bodyElement.appendChild(headerElement);

            // Loop through the cookies
            for(var j = 0; j < cookieLength; j++)
            {
                cookie       = cookies[j];
                cookieHost   = cookie.host;
                cookieName   = cookie.name;
                cookiePath   = cookie.path;
                cookieSecure = cookie.isSecure;
                cookieValue  = cookie.value;
                tableElement = generatedDocument.createElement("table");

                // Cookie name
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                tableRowElement   = generatedDocument.createElement("tr");

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_name")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedDocument.createTextNode(cookieName));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                // Cookie value
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                tableRowElement   = generatedDocument.createElement("tr");

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_value")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.setAttribute("class", "shaded");
                cellDataElement.appendChild(generatedDocument.createTextNode(cookieValue));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                // Cookie host
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                tableRowElement   = generatedDocument.createElement("tr");

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_host")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.appendChild(generatedDocument.createTextNode(cookieHost));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                // Cookie path
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                tableRowElement   = generatedDocument.createElement("tr");

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_path")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.setAttribute("class", "shaded");
                cellDataElement.appendChild(generatedDocument.createTextNode(cookiePath));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                // Cookie secure
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                tableRowElement   = generatedDocument.createElement("tr");

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_secure")));
                tableRowElement.appendChild(cellHeaderElement);

                // If the cookie is secure
                if(cookieSecure)
                {
                    cellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_yes")));
                }
                else
                {
                    cellDataElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_no")));
                }

                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                // If the cookie has an expiration date
                if(cookie.expires)
                {
                    cookieExpires = new Date(cookie.expires * 1000).toUTCString();
                }
                else
                {
                    cookieExpires = stringBundle.getString("webdeveloper_viewCookieInformationSession");
                }

                // Cookie expires
                cellDataElement   = generatedDocument.createElement("td");
                cellHeaderElement = generatedDocument.createElement("th");
                tableRowElement   = generatedDocument.createElement("tr");

                cellHeaderElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_expires")));
                tableRowElement.appendChild(cellHeaderElement);
                cellDataElement.setAttribute("class", "shaded");
                cellDataElement.appendChild(generatedDocument.createTextNode(cookieExpires));
                tableRowElement.appendChild(cellDataElement);
                tableElement.appendChild(tableRowElement);

                divElement.appendChild(tableElement);

                // Edit link
                linkElement     = generatedDocument.createElement("a");
                listElement     = generatedDocument.createElement("ul");
                listItemElement = generatedDocument.createElement("li");

                linkElement.addEventListener("blur", webdeveloper_editCookieMouseOut, false);
                linkElement.addEventListener("click", webdeveloper_editCookie, false);
                linkElement.addEventListener("focus", webdeveloper_editCookieMouseOver, false);
                linkElement.addEventListener("mouseout", webdeveloper_editCookieMouseOut, false);
                linkElement.addEventListener("mouseover", webdeveloper_editCookieMouseOver, false);
                linkElement.setAttribute("cookie-expires", cookieExpires);
                linkElement.setAttribute("cookie-host", cookieHost);
                linkElement.setAttribute("cookie-name", cookieName);
                linkElement.setAttribute("cookie-path", cookiePath);
                linkElement.setAttribute("cookie-secure", cookieSecure);
                linkElement.setAttribute("cookie-value", cookieValue);
                linkElement.setAttribute("href", "http://example.com/");

                linkElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_editCookie")));
                listItemElement.appendChild(linkElement);
                listItemElement.setAttribute("class", "edit");
                listElement.appendChild(listItemElement);

                // Delete link
                linkElement     = generatedDocument.createElement("a");
                listItemElement = generatedDocument.createElement("li");

                linkElement.addEventListener("blur", webdeveloper_deleteCookieMouseOut, false);
                linkElement.addEventListener("click", webdeveloper_deleteCookie, false);
                linkElement.addEventListener("focus", webdeveloper_deleteCookieMouseOver, false);
                linkElement.addEventListener("mouseout", webdeveloper_deleteCookieMouseOut, false);
                linkElement.addEventListener("mouseover", webdeveloper_deleteCookieMouseOver, false);
                linkElement.setAttribute("cookie-host", cookieHost);
                linkElement.setAttribute("cookie-name", cookieName);
                linkElement.setAttribute("cookie-path", cookiePath);
                linkElement.setAttribute("href", "http://example.com/");

                linkElement.appendChild(generatedDocument.createTextNode(stringBundle.getString("webdeveloper_deleteCookie")));
                listItemElement.appendChild(linkElement);
                listItemElement.setAttribute("class", "delete");
                listElement.appendChild(listItemElement);
                listElement.setAttribute("class", "commands");
                divElement.appendChild(listElement);
                divElement.appendChild(generatedDocument.createElement("hr"));
            }

            divElement.setAttribute("class", "output");
            bodyElement.appendChild(divElement);
        }
    }

    scriptElement.setAttribute("defer", "defer");
    scriptElement.setAttribute("src", "chrome://webdeveloper/content/common/xpath.js");
    scriptElement.setAttribute("type", "text/javascript");
    headElement.appendChild(scriptElement);

    scriptElement = generatedDocument.createElement("script");

    scriptElement.setAttribute("defer", "defer");
    scriptElement.setAttribute("src", "chrome://webdeveloper/content/generated/output_pivot.js");
    scriptElement.setAttribute("type", "text/javascript");
    headElement.appendChild(scriptElement);

    // If the open tabs in background preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
    {
        getBrowser().selectedTab = oldTab;
    }
}
