

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: Vectors.i,v 1.7 2002/01/16 14:51:31 nando Exp $

#ifndef quantlib_vectors_i
#define quantlib_vectors_i

%{
#include <vector>
typedef std::vector<int>    IntVector;
typedef std::vector<double> DoubleVector;
using QuantLib::Null;
%}

%typemap(ruby,in) IntVector (IntVector temp),
                  const IntVector & (IntVector temp) {
    if (rb_obj_is_kind_of($source,rb_cArray)) {
        int size = RARRAY($source)->len;
        temp = IntVector(size);
        for (int i=0; i<size; i++) {
            VALUE o = RARRAY($source)->ptr[i];
            if (o == Qnil)
                temp[i] = Null<int>();
            else if (FIXNUM_P(o))
                temp[i] = FIX2INT(o);
            else
                rb_raise(rb_eTypeError,
                         "wrong argument type (expected integers)");
        }
    } else {
        rb_raise(rb_eTypeError,
                 "wrong argument type (expected array)");
    }
    $target = &temp;
}


%typemap(ruby,in) DoubleVector (DoubleVector temp),
                  const DoubleVector & (DoubleVector temp) {
    if (rb_obj_is_kind_of($source,rb_cArray)) {
        int size = RARRAY($source)->len;
        temp = DoubleVector(size);
        for (int i=0; i<size; i++) {
            VALUE o = RARRAY($source)->ptr[i];
            if (o == Qnil)
                temp[i] = Null<double>();
            else if (FIXNUM_P(o))
                temp[i] = double(FIX2INT(o));
            else if (TYPE(o) == T_FLOAT)
                temp[i] = NUM2DBL(o);
            else
                rb_raise(rb_eTypeError,
                         "wrong argument type (expected numbers)");
        }
    } else {
        rb_raise(rb_eTypeError,
                 "wrong argument type (expected array)");
    }
    $target = &temp;
}


#endif
