# Just for flag constants
from Ft.Rdf import Model, OBJECT_TYPE_UNKNOWN

import os

class FakeCompiledObject:
    def __init__(self):
        self._id = 1
        pass
    def __cmp__(self,other):
        return cmp(self._id,other._id)


DATABASE_NAME = os.environ.get('RDF_TEST_DB','test')

SOURCE_URI = 'http://localhost/Versa-tests'


def test_query(tester):
    tester.startGroup("Extended Query Interfaces")

    tester.startTest("Init")
    driver = tester.test_data['driver']
    db = tester.test_data['driver'].GetDb(DATABASE_NAME)    
    db.begin()
    db.removePattern(None,None,None,None,None,{})
    db.commit()

    db = tester.test_data['driver'].GetDb(DATABASE_NAME)    
    db.begin()
    db.add([
        ('Book','Author','molson','uri', SOURCE_URI, OBJECT_TYPE_UNKNOWN),
        ('Book','Publisher','AWL','uri', SOURCE_URI, OBJECT_TYPE_UNKNOWN),
        ('Book','Printer','Free Press','uri', SOURCE_URI, OBJECT_TYPE_UNKNOWN),
        ('molson','Title','Mike Olson','uri', SOURCE_URI, OBJECT_TYPE_UNKNOWN),
        ('uogbuji','Title','Uche Ogbuji','uri', SOURCE_URI, OBJECT_TYPE_UNKNOWN),
        ])
    tester.testDone()

    tester.startTest("subjectsFromPredAndObjs(None,None,None)")
    res = db.subjectsFromPredAndObjs(None,None,None)
    tester.compare(3,len(res))
    tester.compareIn(res,"Book")
    tester.compareIn(res,"molson")
    tester.compareIn(res,"uogbuji")
    tester.testDone()

    tester.startTest("subjectsFromPredAndObjs")
    res = db.subjectsFromPredAndObjs('Title',['Mike Olson','Uche Ogbuji'],None)
    tester.compare(2,len(res))
    tester.compareIn(res,"uogbuji")
    tester.compareIn(res,"molson")
    tester.testDone()

    tester.startTest("objectsFromSubAndPreds(None,None,None)")
    res = db.objectsFromSubAndPreds(None,None,None)
    tester.compare(5,len(res))
    tester.compareIn(res,("molson", OBJECT_TYPE_UNKNOWN))
    tester.compareIn(res,("AWL", OBJECT_TYPE_UNKNOWN))
    tester.compareIn(res,("Free Press", OBJECT_TYPE_UNKNOWN))
    tester.compareIn(res,("Mike Olson", OBJECT_TYPE_UNKNOWN))
    tester.compareIn(res,("Uche Ogbuji", OBJECT_TYPE_UNKNOWN))
    tester.testDone()

    tester.startTest("objectsFromSubAndPreds")
    res = db.objectsFromSubAndPreds('Book',['Printer','Author'],None)
    tester.compare(2,len(res))
    tester.compareIn(res,("molson", OBJECT_TYPE_UNKNOWN))
    tester.compareIn(res,("Free Press", OBJECT_TYPE_UNKNOWN))
    tester.testDone()

    tester.startTest("isResource")
    tester.compare(1,db.isResource("Book"))
    tester.compare(0,db.isResource("Mike Olson"))
    tester.testDone()

    db.commit()
    tester.groupDone()


def test_binding(tester):

    tester.startGroup("Binding Interfaces")
    fco = FakeCompiledObject()

    driver = tester.test_data['driver']
    db = tester.test_data['driver'].GetDb(DATABASE_NAME)    
    db.begin()


    tester.startTest("Test Bind")
    db.bind(fco, "TEST", SOURCE_URI)
    tester.testDone()

    tester.startTest("Test Lookup")
    tester.compare(fco,db.lookup("TEST",SOURCE_URI))
    tester.testDone()

    tester.startTest("Test has_keys")
    tester.compare(1,db.has_key("TEST",SOURCE_URI))
    tester.testDone()

    tester.startTest("Test keys")
    tester.compareIn(db.keys(SOURCE_URI),'TEST')
    tester.testDone()



    tester.startTest("Test Lookup (no results)")
    tester.compare(None,db.lookup("TEST2", SOURCE_URI))
    tester.testDone()

    tester.startTest("Test UnBind")
    db.unbind("TEST", SOURCE_URI)
    tester.compare(None,db.lookup("TEST", SOURCE_URI))
    tester.testDone()


    tester.startTest("Test Commit")
    db.commit()
    tester.testDone()

    tester.groupDone()


def init(tester):
    tester.startTest("Init DB")
    driver = tester.test_data['driver']
    if driver.ExistsDb(DATABASE_NAME):
        driver.DestroyDb(DATABASE_NAME)
        db = driver.CreateDb(DATABASE_NAME)
        db.begin()
    else:
        db = driver.CreateDb(DATABASE_NAME)
        db.begin()
    db.commit()
    tester.testDone()


def Test(tester):

    init(tester)
    test_query(tester)
    test_binding(tester)




